/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.condition;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ColumnDataType;
import com.kingdee.eas.dynbusiness.IBusinessConfigItem;
import com.kingdee.eas.dynbusiness.condition.Condition;
import com.kingdee.eas.dynbusiness.condition.ILevelFrom;
import com.kingdee.eas.dynbusiness.condition.IPreBatchFetch;
import com.kingdee.eas.dynbusiness.condition.IPropertyInitialization;
import com.kingdee.eas.dynbusiness.condition.ISelectorSupport;
import com.kingdee.eas.dynbusiness.condition.ITableSQLBuild;
import com.kingdee.eas.dynbusiness.condition.ObjectValueSearcher;
import com.kingdee.eas.dynbusiness.util.ArrayUtils;
import com.kingdee.eas.dynbusiness.util.ExpressionParser;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class Conditions
implements ILevelFrom,
ITableSQLBuild,
IPreBatchFetch,
ISelectorSupport,
IPropertyInitialization,
IBusinessConfigItem {
    static final Logger logger = Logger.getLogger(Conditions.class);
    public static final String HEAD = "_HEAD";
    public static final String ENTRISENAME = "_ENTRISENAME";
    public static final String THIS = "@this";
    private String id;
    private List conditions;
    private String linkMask;

    public String toString() {
        int size = this.conditions.size();
        String link = this.linkMask != null ? this.linkMask : this.getDefaultLinkMask(size);
        for (int i = 0; i < size; ++i) {
            Condition condition = (Condition)this.conditions.get(i);
            link = link.replaceFirst("#" + i, condition.toString());
        }
        return link;
    }

    private String getDefaultLinkMask(int size) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(" AND ");
            }
            sb.append("#").append(i);
        }
        return sb.toString();
    }

    public boolean calculateResult(IObjectValue objValue, int level, Map paramMap, String objName) throws EASBizException, BOSException {
        boolean[] results = this.calculateResults(objValue, level, paramMap, objName);
        boolean result = false;
        for (int i = 0; i < results.length; ++i) {
            result = result || results[i];
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u6761\u4ef6\u96c6\u5408\u9879[" + this.toString() + "]\u7684\u503c\u4e3a" + result));
        }
        return result;
    }

    private boolean[] calculateResultsWithLinkMask(IObjectValue objValue, int level, Map paramMap, String objName) throws EASBizException, BOSException {
        ExpressionParser exprParse;
        String[] params;
        IObjectCollection objCollection;
        boolean[] results = null;
        int size = this.conditions.size();
        String entriesName = (String)paramMap.get(ENTRISENAME);
        int entrySize = 1;
        if (level == 0 && this.hasLevelGreaterZero(entriesName + ".") && (objCollection = (IObjectCollection)objValue.get(entriesName)) != null && objCollection.size() > 0) {
            entrySize = objCollection.size();
        }
        if ((params = (exprParse = ExpressionParser.getInstance()).splitParameters(this.getLinkMask())).length != size) {
            throw new IllegalArgumentException("The parameters of linkmask " + this.getLinkMask() + " is not match the condition in checkItem " + this.id);
        }
        HashMap[] contexts = new HashMap[entrySize];
        for (int i = 0; i < size; ++i) {
            int j;
            Condition condition = (Condition)this.conditions.get(i);
            boolean[] thisResults = condition.calculateResults(objValue, level, paramMap, objName);
            if (thisResults.length >= entrySize) {
                for (j = 0; j < entrySize; ++j) {
                    if (contexts[j] == null) {
                        contexts[j] = new HashMap(size);
                    }
                    contexts[j].put(params[i], thisResults[j]);
                }
                continue;
            }
            for (j = 0; j < entrySize; ++j) {
                if (contexts[j] == null) {
                    contexts[j] = new HashMap(size);
                }
                contexts[j].put(params[i], thisResults[0]);
            }
        }
        results = new boolean[entrySize];
        Interpreter interpreter = new Interpreter();
        String linkResult = this.linkMask.replaceAll("AND", "&&").replaceAll("OR", "||");
        for (int i = 0; i < entrySize; ++i) {
            results[i] = (Boolean)interpreter.eval(linkResult, (Map)contexts[i]);
        }
        return results;
    }

    private boolean[] calculateResultsNoLinkMask(IObjectValue objValue, int level, Map paramMap, String objName) throws EASBizException, BOSException {
        boolean[] results = null;
        int size = this.conditions.size();
        for (int i = 0; i < size; ++i) {
            int j;
            Condition condition = (Condition)this.conditions.get(i);
            boolean[] thisResults = condition.calculateResults(objValue, level, paramMap, objName);
            if (results == null) {
                results = thisResults;
                continue;
            }
            if (thisResults.length > results.length) {
                boolean[] temp = results;
                results = thisResults;
                thisResults = temp;
            }
            if (thisResults.length == results.length) {
                for (j = 0; j < results.length; ++j) {
                    results[j] = results[j] && thisResults[j];
                }
                continue;
            }
            for (j = 0; j < results.length; ++j) {
                results[j] = results[j] && thisResults[0];
            }
        }
        return results;
    }

    public boolean[] calculateResults(IObjectValue objValue, int level, Map paramMap, String objName) throws EASBizException, BOSException {
        if (this.getLinkMask() == null) {
            return this.calculateResultsNoLinkMask(objValue, level, paramMap, objName);
        }
        return this.calculateResultsWithLinkMask(objValue, level, paramMap, objName);
    }

    static String buildKey(IObjectValue objValue, String key, Map paramMap) {
        ExpressionParser exprParse = ExpressionParser.getInstance();
        String[] exprs = exprParse.splitVariables(key);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < exprs.length; ++i) {
            Object value = ObjectValueSearcher.searchValue((Object)objValue, exprs[i].split("\\."), 0, null, paramMap);
            if (value instanceof IObjectValue) {
                value = ((IObjectValue)value).get(((IObjectValue)value).getPKField());
            }
            sb.append(value.toString());
        }
        return sb.toString();
    }

    public List getConditions() {
        return this.conditions;
    }

    public void setConditions(List conditions) {
        this.conditions = conditions;
    }

    public String getLinkMask() {
        return this.linkMask;
    }

    public void setLinkMask(String linkMask) {
        this.linkMask = linkMask;
    }

    @Override
    public String buildConditon(boolean isToSum, String[] columns) {
        if (this.conditions == null || this.conditions.size() == 0) {
            return null;
        }
        if (this.linkMask == null || this.linkMask.length() == 0) {
            StringBuffer sb = new StringBuffer();
            int size = this.conditions.size();
            for (int i = 0; i < size; ++i) {
                if (sb.length() > 0) {
                    sb.append(" AND ");
                }
                Condition condition = (Condition)this.conditions.get(i);
                sb.append(condition.buildConditon(isToSum, null));
            }
            return sb.toString();
        }
        String result = this.linkMask;
        String mask = "#";
        int size = this.conditions.size();
        for (int i = 0; i < size; ++i) {
            Condition condition = (Condition)this.conditions.get(i);
            result = result.replaceAll(mask + i, condition.buildConditon(isToSum, null));
        }
        return result;
    }

    public String buildUpdColList() {
        if (this.conditions == null || this.conditions.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int subsize = this.conditions.size();
        for (int j = 0; j < subsize; ++j) {
            sb.append(", ");
            Condition condition = (Condition)this.conditions.get(j);
            sb.append(condition.buildUpdColList());
        }
        return sb.toString();
    }

    @Override
    public boolean hasLevelGreaterZero(String alias) {
        Condition condition;
        boolean result = false;
        int size = this.conditions.size();
        for (int i = 0; i < size && !(result = (condition = (Condition)this.conditions.get(i)).hasLevelGreaterZero(alias)); ++i) {
        }
        return result;
    }

    @Override
    public boolean hasLevelZero(String alias) {
        Condition condition;
        boolean result = false;
        int size = this.conditions.size();
        for (int i = 0; i < size && !(result = (condition = (Condition)this.conditions.get(i)).hasLevelZero(alias)); ++i) {
        }
        return result;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    static boolean isStringConstants(String variable) {
        return variable.startsWith("'") && variable.endsWith("'");
    }

    static boolean isTemporaryVariable(String variable) {
        return variable.startsWith("[") && variable.endsWith("]");
    }

    @Override
    public boolean hasMulOrDivOperation(int levelFrom) {
        Condition condition;
        boolean result = false;
        int size = this.conditions.size();
        for (int i = 0; i < size && !(result = (condition = (Condition)this.conditions.get(i)).hasMulOrDivOperation(levelFrom)); ++i) {
        }
        return result;
    }

    @Override
    public String buildJoin() {
        StringBuffer sb = new StringBuffer();
        HashSet<String> joinSet = new HashSet<String>();
        int size = this.conditions.size();
        for (int i = 0; i < size; ++i) {
            Condition condition = (Condition)this.conditions.get(i);
            String join = condition.buildJoin();
            if (StringUtil.isEmpty(join)) continue;
            joinSet.add(condition.buildJoin());
        }
        if (joinSet.size() > 0) {
            Iterator iter = joinSet.iterator();
            while (iter.hasNext()) {
                sb.append(iter.next());
                sb.append("\r\n");
            }
        }
        return sb.toString();
    }

    @Override
    public String[] getGroupByFields(int levelFrom) {
        String[] result = new String[]{};
        int size = this.conditions.size();
        for (int i = 0; i < size; ++i) {
            Condition condition = (Condition)this.conditions.get(i);
            result = ArrayUtils.mergeArray(result, condition.getGroupByFields(levelFrom));
        }
        return result;
    }

    @Override
    public void setDataType(ColumnDataType dataType) {
    }

    @Override
    public void collectPreFetchItems(List items, String entriesName) {
        int size = this.conditions.size();
        for (int i = 0; i < size; ++i) {
            Condition condition = (Condition)this.conditions.get(i);
            condition.collectPreFetchItems(items, entriesName);
        }
    }

    @Override
    public void preBatchFetch(IObjectCollection objCollection, int level, Map paramMap) throws EASBizException, BOSException {
    }

    @Override
    public String[] getColumnNames(int levelFrom, boolean withAlias) {
        String[] result = new String[]{};
        int size = this.conditions.size();
        for (int i = 0; i < size; ++i) {
            Condition condition = (Condition)this.conditions.get(i);
            result = ArrayUtils.mergeArray(result, condition.getColumnNames(levelFrom, withAlias));
        }
        return result;
    }

    @Override
    public List getSelectorList() {
        ArrayList result = new ArrayList();
        int size = this.conditions.size();
        for (int i = 0; i < size; ++i) {
            Condition condition = (Condition)this.conditions.get(i);
            result.addAll(condition.getSelectorList());
        }
        return result;
    }

    @Override
    public PropertyInfo[] getPropertyInfo(EntityObjectInfo mainEo, Map subEntities) {
        int size = this.conditions.size();
        for (int i = 0; i < size; ++i) {
            Condition condition = (Condition)this.conditions.get(i);
            condition.getPropertyInfo(mainEo, subEntities);
        }
        return null;
    }

    @Override
    public String getEntryName() {
        int size = this.conditions.size();
        for (int i = 0; i < size; ++i) {
            Condition condition = (Condition)this.conditions.get(i);
            String entryName = condition.getEntryName();
            if (entryName == null) continue;
            return entryName;
        }
        return null;
    }
}

