/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.config;

import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.dynbusiness.IBusinessConfigItem;
import com.kingdee.eas.dynbusiness.expression.ExpressionEvaluator;
import com.kingdee.eas.dynbusiness.expression.datameta.Variable;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.dynbusiness.util.ExpressionParser;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.dynbusiness.util.ValidationUtils;
import java.util.ArrayList;

public class Property
implements IBusinessConfigItem,
Cloneable {
    String name;
    String precondition;
    String alias;
    String comparison;
    transient PropertyInfo propInfo;
    transient String[] splits;
    transient Property parent;
    String key;
    String emptyExpression;
    String title;
    private static final String VAR_THIS = "__this";

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getEmptyExpression() {
        return this.emptyExpression;
    }

    public void setEmptyExpression(String emptyExpression) {
        this.emptyExpression = emptyExpression;
        if (this.emptyExpression != null) {
            this.emptyExpression = this.emptyExpression.replaceAll("@this", VAR_THIS);
        }
    }

    public String getKey() {
        return this.key;
    }

    public Property(String key, String name) {
        this.key = key;
        this.name = name;
    }

    public Property getParent() {
        return this.parent;
    }

    public String[] getSplits() {
        if (this.splits == null) {
            ExpressionParser exprParser = ExpressionParser.getInstance();
            this.splits = exprParser.splitPropertise(this.getName());
        }
        return this.splits;
    }

    public DataType getDataType() {
        if (this.propInfo == null) {
            return null;
        }
        return BusinessProcessUtil.getDataType(this.propInfo);
    }

    public void setComparison(String comparison) {
        this.comparison = comparison;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Property(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getPrecondition() {
        return this.precondition;
    }

    public void setPrecondition(String precondition) {
        this.precondition = precondition;
    }

    public String getComparison() {
        return this.comparison;
    }

    public PropertyInfo getPropInfo() {
        return this.propInfo;
    }

    public void setPropInfo(PropertyInfo propInfo) {
        this.propInfo = propInfo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.precondition == null ? 0 : this.precondition.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Property)) {
            return false;
        }
        Property property = (Property)obj;
        boolean result = this.name.equals(property.getName());
        if (result) {
            if (this.precondition == null && property.precondition == null) {
                return true;
            }
            if (this.precondition == null) {
                return false;
            }
            return this.precondition.equals(property.precondition);
        }
        return result;
    }

    public boolean validate(Object value, String validation) {
        if (StringUtil.isEmpty(this.comparison)) {
            if (!StringUtil.isEmpty(this.emptyExpression) && "REQUIRED".equalsIgnoreCase(validation)) {
                ArrayList<Variable> variables = new ArrayList<Variable>(1);
                variables.add(Variable.createVariable(VAR_THIS, value));
                Object result = ExpressionEvaluator.evaluate(this.emptyExpression, variables);
                return (Boolean)result;
            }
            return ValidationUtils.doRealValidate(value, validation);
        }
        return ValidationUtils.doRealValidate(value, this.comparison);
    }
}

