/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.config;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.dynbusiness.IBusinessBatchHandle;
import com.kingdee.eas.dynbusiness.app.handler.PropertyCheckHandler;
import com.kingdee.eas.dynbusiness.app.parsing.BusinessConfigurationCache;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.dynbusiness.config.BusinessCheckConfigItem;
import com.kingdee.eas.dynbusiness.config.BusinessCheckConfigItems;
import com.kingdee.eas.dynbusiness.config.BusinessProcessConfigItem;
import com.kingdee.eas.dynbusiness.config.Property;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.dynbusiness.util.InitializationHelper;
import com.kingdee.eas.dynbusiness.util.ObjectListMap;
import com.kingdee.eas.dynbusiness.util.StringTokenComparator;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PropertyCheckConfigItems
extends BusinessCheckConfigItems
implements Cloneable {
    private static final String CHECK_REQUIRED = "checkRequired";
    private transient ObjectListMap mapCheckItems;
    private int maxLevel = 1;
    private List selectorList;
    private Locale locale = null;
    static final int MAX_LEV = 3;
    private boolean isInitialized = false;
    private transient List preFetchItems;

    public PropertyCheckConfigItems(Object parent) {
        super(parent);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public synchronized void build(Context ctx) throws BOSException {
        if (this.isInitialized && this.locale != null && ctx.getLocale() != null && this.locale.getLanguage().equals(ctx.getLocale().getLanguage())) {
            return;
        }
        this.locale = ctx.getLocale();
        BusinessProcessConfigItem configItem = (BusinessProcessConfigItem)this.getParent();
        HashMap subEntities = new HashMap();
        this.selectorList = new ArrayList();
        this.selectorList.add(new SelectorItemInfo("id"));
        EntityObjectInfo mainEo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(BOSObjectType.create((String)configItem.getBosType()));
        List preConds = this.getPreConditions();
        if (preConds != null) {
            int size = preConds.size();
            for (int i = 0; i < size; ++i) {
                Conditions preCond = (Conditions)preConds.get(i);
                InitializationHelper.preTreatingConds(ctx, preCond, mainEo, subEntities, this.selectorList);
            }
        }
        this.prepareCheckItems(ctx, mainEo, subEntities);
        for (Map.Entry entry : subEntities.entrySet()) {
            String key = (String)entry.getKey();
            this.selectorList.add(new SelectorItemInfo(key + ".id"));
            EntityObjectInfo childEo = (EntityObjectInfo)entry.getValue();
            if (childEo.getPropertyByNameRuntime("seq") == null) continue;
            this.selectorList.add(new SelectorItemInfo(key + ".seq"));
        }
        String entriesName = BusinessProcessUtil.getEntityEntriesName(ctx, BOSObjectType.create((String)((BusinessProcessConfigItem)this.getParent()).getBosType()));
        this.preFetchItems = this.preparePreFetchItems(entriesName);
        this.isInitialized = true;
    }

    private void prepareCheckItems(Context ctx, EntityObjectInfo mainEo, Map subEntities) {
        this.mapCheckItems = new ObjectListMap(2);
        Map checkItems = this.getCheckItems();
        for (BusinessCheckConfigItem checkItem : checkItems.values()) {
            if (checkItem.getValidation() == null && checkItem.getConditions() != null) {
                InitializationHelper.preTreatingConds(ctx, checkItem.getConditions(), mainEo, subEntities, this.selectorList);
                continue;
            }
            List properties = checkItem.getProperties();
            ArrayList<String> propList = new ArrayList<String>();
            HashMap<String, Property> mapProp = new HashMap<String, Property>();
            int subsize = properties.size();
            for (int idxOfProp = 0; idxOfProp < subsize; ++idxOfProp) {
                String parentName;
                PropertyInfo propInfo;
                Property prop = (Property)properties.get(idxOfProp);
                String[] splits = prop.getName().split("\\.");
                if (splits.length > 3) {
                    throw new UnsupportedOperationException("does not support property level greater than 3");
                }
                if (this.maxLevel < splits.length) {
                    this.maxLevel = splits.length;
                }
                if ((propInfo = BusinessProcessUtil.getPropertyInfo(mainEo, prop.getName().trim(), splits, subEntities)) == null) continue;
                propList.add(prop.getName());
                prop.setAlias(propInfo.getAlias());
                mapProp.put(prop.getName(), prop);
                this.selectorList.add(new SelectorItemInfo(prop.getName()));
                if (splits.length <= 1 || !subEntities.containsKey(parentName = mainEo.getName() + StringUtil.nameFromSplits(splits, splits.length - 1))) continue;
                if (mapProp.containsKey(parentName)) {
                    prop.parent = (Property)mapProp.get(parentName);
                    continue;
                }
                Property parentProperty = new Property(parentName);
                parentProperty.alias = ((EntityObjectInfo)subEntities.get(parentName)).getAlias();
                prop.parent = parentProperty;
                mapProp.put(parentName, parentProperty);
            }
            String[] propArray = new String[propList.size()];
            propList.toArray(propArray);
            Arrays.sort(propArray, new StringTokenComparator());
            this.mapCheckItems.put(checkItem, new Object[]{propArray, mapProp});
        }
    }

    private List preparePreFetchItems(String entriesName) {
        String key = entriesName + ".";
        ArrayList preFetchItems = new ArrayList();
        List preConds = this.getPreConditions();
        if (preConds != null) {
            for (Conditions preCond : preConds) {
                preCond.collectPreFetchItems(preFetchItems, key);
            }
        }
        for (BusinessCheckConfigItem checkItem : this.getCheckItems().values()) {
            Conditions conds;
            if (checkItem.getValidation() != null || (conds = checkItem.getConditions()) == null) continue;
            conds.collectPreFetchItems(preFetchItems, entriesName);
        }
        return preFetchItems;
    }

    @Override
    public IBusinessBatchHandle getBusinessCheckHandler(Context ctx) throws BOSException {
        this.build(ctx);
        BusinessProcessConfigItem configItem = (BusinessProcessConfigItem)this.getParent();
        return new PropertyCheckHandler(this, BOSObjectType.create((String)configItem.getBosType()), configItem.getAction(), configItem.getBillTypeId());
    }

    public ObjectListMap getMapCheckItems(Context ctx) throws BOSException {
        this.doInitialize(ctx);
        return this.mapCheckItems;
    }

    public List getPreConditions() {
        if (this.getParent() instanceof BusinessProcessConfigItem) {
            return ((BusinessProcessConfigItem)this.getParent()).getPreConditions();
        }
        return null;
    }

    public List getSelectorList(Context ctx) throws BOSException {
        this.doInitialize(ctx);
        return this.selectorList;
    }

    private void doInitialize(Context ctx) throws BOSException {
        try {
            if (!this.isInitialized) {
                this.build(ctx);
            }
        }
        catch (IllegalArgumentException e) {
            BusinessProcessConfigItem configItem = (BusinessProcessConfigItem)this.getParent();
            BusinessConfigurationCache.getCache().clearConfigItem(configItem.getBosType(), configItem.getAction());
            throw e;
        }
        catch (UnsupportedOperationException e) {
            BusinessProcessConfigItem configItem = (BusinessProcessConfigItem)this.getParent();
            BusinessConfigurationCache.getCache().clearConfigItem(configItem.getBosType(), configItem.getAction());
            throw e;
        }
    }

    public List getPreFetchItems() {
        return this.preFetchItems;
    }

    public static PropertyCheckConfigItems defineForRequiredValidation(String bosType) {
        BusinessProcessConfigItem confItem = new BusinessProcessConfigItem();
        confItem.setBosType(bosType);
        PropertyCheckConfigItems checkItems = new PropertyCheckConfigItems(confItem);
        BusinessCheckConfigItem checkItem = new BusinessCheckConfigItem();
        checkItem.setId(CHECK_REQUIRED);
        checkItem.setValidation("required");
        ArrayList properties = new ArrayList();
        checkItem.setProperties(properties);
        checkItems.add(checkItem);
        return checkItems;
    }

    public void addRequiredProperty(Property property) {
        BusinessCheckConfigItem checkItem = (BusinessCheckConfigItem)this.getCheckItems().get(CHECK_REQUIRED);
        if (checkItem == null) {
            throw new UnsupportedOperationException("Can't find Required Type CheckItem.");
        }
        checkItem.getProperties().add(property);
    }

    public void addRequiredProperty(String propertyName) {
        this.addRequiredProperty(new Property(propertyName));
    }

    public void addRequiredProperties(String[] propertyNames) {
        if (propertyNames == null) {
            return;
        }
        BusinessCheckConfigItem checkItem = (BusinessCheckConfigItem)this.getCheckItems().get(CHECK_REQUIRED);
        if (checkItem == null) {
            throw new UnsupportedOperationException("Can't find Required Type CheckItem.");
        }
        for (int i = 0; i < propertyNames.length; ++i) {
            checkItem.getProperties().add(new Property(propertyNames[i]));
        }
    }
}

