/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.util;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ExpressionParser {
    public static final Pattern OPE_PATTERN = Pattern.compile("[\\+\\-\\*/\\(\\)\\s]+");
    public static final Pattern EXP_PATTERN = Pattern.compile("([\\+\\-\\*/]+|(?i)(\\s+(IN|NOTIN|LIKE)\\s+))");
    public static final Pattern EXTCOM_PATTERN = Pattern.compile("((?i)(\\s+(IN|NOTIN|LIKE)\\s+))");
    public static final Pattern VAR_PATTERN = Pattern.compile("[a-zA-Z_@][a-zA-Z_0-9\\.]*");
    public static final Pattern VAR_PATTERN2 = Pattern.compile("[a-zA-Z_@\\[][a-zA-Z_0-9\\.\\]]*");
    public static final Pattern VARDIG_PATTERN = Pattern.compile("([a-zA-Z_@][a-zA-Z_0-9\\.]*)|(([1-9]\\d+|\\d)(\\.\\d+)?\\d*)|([\\(\\)]+)|([\\+\\-\\*/]+)");
    public static final Pattern DIG_PATTERN = Pattern.compile("(([1-9]\\d+|\\d)(\\.\\d+)?\\d*)");
    public static final Pattern COM_PATTERN = Pattern.compile("([=><\\s]+)");
    public static final Pattern PRO_PATTERN = Pattern.compile("(\\[[^]]+\\]+)|\\(([^\\)]+)\\)|([^\\.^\\*^\\+^\\-^/]+)");
    public static final Pattern PAR_PATTERN = Pattern.compile("(#[0-9]+)");
    public static final Pattern FUNSYMBOL_PATTERN = Pattern.compile("([a-zA-Z]+)[\\s]*\\(");
    public static final Pattern FUN_PATTERN = Pattern.compile("([a-zA-Z]+)[\\s]*\\((([^()]*)|(([a-zA-Z]*)\\(([^()]*)\\).*))\\)");
    public static final Pattern KEYWORD_PATTERN = Pattern.compile("if[\\s]*\\((.*)\\)");
    public static final Pattern REG_PATTERN = Pattern.compile("([\\\\\\{\\|\\*\\+\\?\\(\\)\\.\\[\\]\\^\\$]{1})");
    public static final Pattern BAR_PATTERN = Pattern.compile("(\\[[^\\]]+\\])");
    public static final Pattern BRACES_BRACKETS_PATTERN = Pattern.compile("(\\{[(^\\})a-zA-Z_@]([a-zA-Z_0-9\\.])*\\})|(\\[[(^\\])a-zA-Z_@]([a-zA-Z_0-9\\.])*\\])");
    public static final Pattern BRACES_PATTERN = Pattern.compile("(\\{[(^\\})a-zA-Z_@]([a-zA-Z_0-9\\.])*\\})");
    public static final Pattern DATETIME_PATTERN = Pattern.compile("(\\{\\d{4}\\-\\d{2}\\-\\d{2}[T:\\s0-9]{0,13}\\})");
    public static final Pattern LINK_PATTERN = Pattern.compile("((?i)(\\s+(AND|OR)\\s+))");

    private ExpressionParser() {
    }

    public static ExpressionParser getInstance() {
        return new ExpressionParser();
    }

    public String[] splitVariables(String expr) {
        String[] results = OPE_PATTERN.split(expr);
        ArrayList<String> list = new ArrayList<String>(results.length);
        for (int i = 0; i < results.length; ++i) {
            Matcher matcher = VAR_PATTERN.matcher(results[i]);
            if (!matcher.matches()) continue;
            list.add(results[i]);
        }
        if (list.size() < results.length) {
            results = list.toArray(new String[0]);
        }
        return results;
    }

    public String[] splitVariableAndDigit(String expr) {
        Matcher matcher = VARDIG_PATTERN.matcher(expr);
        int start = 0;
        ArrayList<String> list = new ArrayList<String>();
        while (start < expr.length()) {
            if (matcher.find(start)) {
                list.add(matcher.group(1) != null ? matcher.group(1) : matcher.group(0));
                start = matcher.end();
                continue;
            }
            ++start;
        }
        return list.toArray(new String[0]);
    }

    public String[] splitVariables2(String expr) {
        String[] results = OPE_PATTERN.split(expr);
        ArrayList<String> list = new ArrayList<String>(results.length);
        for (int i = 0; i < results.length; ++i) {
            Matcher matcher = VAR_PATTERN2.matcher(results[i]);
            if (!matcher.matches()) continue;
            list.add(results[i]);
        }
        if (list.size() < results.length) {
            results = list.toArray(new String[0]);
        }
        return results;
    }

    public FilterInfo parseFilterInfo(String expr) {
        if (expr == null) {
            return null;
        }
        String[] results = COM_PATTERN.split(expr);
        if (results.length < 1) {
            return null;
        }
        Matcher matcher = COM_PATTERN.matcher(expr);
        String operator = null;
        if (matcher.find()) {
            operator = matcher.group();
        }
        if (operator == null) {
            return null;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(results[0], (Object)results[1], CompareType.getEnum((String)operator)));
        return filterInfo;
    }

    public String[] splitPropertise(String expr) {
        Matcher matcher = PRO_PATTERN.matcher(expr);
        int start = 0;
        ArrayList<String> list = new ArrayList<String>();
        while (start < expr.length()) {
            if (matcher.find(start)) {
                list.add(matcher.group(1) != null ? matcher.group(1) : matcher.group(0));
                start = matcher.end();
                continue;
            }
            ++start;
        }
        return list.toArray(new String[0]);
    }

    public boolean isExpression(String expr) {
        if (expr.indexOf(".(") > 0) {
            return false;
        }
        Matcher matcher = EXP_PATTERN.matcher(expr);
        return matcher.find();
    }

    public boolean isExpressionOrFunction(String expr) {
        Matcher matcher = EXP_PATTERN.matcher(expr);
        boolean result = matcher.find();
        if (!result) {
            matcher = FUN_PATTERN.matcher(expr);
            result = matcher.find();
        }
        return result;
    }

    public boolean isVariable(String expr) {
        Matcher matcher = VAR_PATTERN.matcher(expr);
        return matcher.find();
    }

    public boolean isOperator(String expr) {
        Matcher matcher = OPE_PATTERN.matcher(expr);
        return matcher.find();
    }

    public boolean isDigit(String expr) {
        Matcher matcher = DIG_PATTERN.matcher(expr);
        return matcher.find();
    }

    public String[] splitParameters(String expr) {
        Matcher matcher = PAR_PATTERN.matcher(expr);
        int start = 0;
        ArrayList<String> list = new ArrayList<String>();
        while (start < expr.length()) {
            if (matcher.find(start)) {
                list.add(matcher.group(1));
                start = matcher.end();
                continue;
            }
            ++start;
        }
        return list.toArray(new String[0]);
    }

    public String[][] splitLinkMask(String expr) {
        Matcher matcher = LINK_PATTERN.matcher(expr);
        int start = 0;
        String line = expr;
        ArrayList<String> linkList = new ArrayList<String>();
        ArrayList<String> lineList = new ArrayList<String>();
        while (start < expr.length() && matcher.find(start)) {
            line = expr.substring(start, matcher.start());
            linkList.add(matcher.group(1).trim());
            start = matcher.end();
            lineList.add(line.trim());
        }
        if (start < expr.length()) {
            lineList.add(expr.substring(start).trim());
        }
        int size = lineList.size();
        int linkSize = linkList.size();
        String[][] results = new String[size][4];
        for (int i = 0; i < size; ++i) {
            line = (String)lineList.get(i);
            matcher = PAR_PATTERN.matcher(line);
            if (!matcher.find()) continue;
            results[i][0] = line.substring(0, matcher.start());
            results[i][1] = matcher.group(1);
            results[i][2] = line.substring(matcher.end());
            results[i][3] = i < linkSize ? (String)linkList.get(i) : "";
        }
        return results;
    }

    public String[] splitOperators(String expr) {
        Matcher matcher = EXP_PATTERN.matcher(expr);
        int start = 0;
        ArrayList<String> list = new ArrayList<String>();
        while (start < expr.length()) {
            if (matcher.find(start)) {
                list.add(matcher.group(0).trim().toUpperCase());
                start = matcher.end();
                continue;
            }
            ++start;
        }
        return list.toArray(new String[0]);
    }

    public String[] splitOperatorAndVar(String expr) {
        Matcher matcher = EXP_PATTERN.matcher(expr);
        int start = 0;
        int matchEnd = 0;
        ArrayList<String> list = new ArrayList<String>();
        while (start < expr.length()) {
            if (matcher.find(start)) {
                list.add(expr.substring(start, matcher.start()));
                list.add(matcher.group(0).trim().toUpperCase());
                start = matcher.end();
                matchEnd = matcher.end();
                continue;
            }
            ++start;
        }
        list.add(expr.substring(matchEnd));
        return list.toArray(new String[0]);
    }

    public String[] splitExtCompareOperator(String expr) {
        Matcher matcher = EXTCOM_PATTERN.matcher(expr);
        int start = 0;
        ArrayList<String> list = new ArrayList<String>();
        while (start < expr.length()) {
            if (matcher.find(start)) {
                String leftExpr = this.searchWholeExpression(expr, matcher.start(), false);
                String oper = matcher.group(0).trim().toUpperCase();
                String rightExpr = this.searchWholeExpression(expr, matcher.end(), true);
                start = matcher.end() + rightExpr.length();
                list.add(new StringBuffer().append(leftExpr).append(" ").append(oper).append(" ").append(rightExpr).toString());
                continue;
            }
            ++start;
        }
        return list.toArray(new String[0]);
    }

    private String searchWholeExpression(String expr, int pos, boolean isForward) {
        boolean todo;
        char rightBracket;
        char leftBracket;
        String symbol = "+-*/=|& ";
        int length = expr.length();
        int bracket = 0;
        int end = pos;
        boolean inQuotes = false;
        if (isForward) {
            leftBracket = '(';
            rightBracket = ')';
            todo = end < length;
        } else {
            leftBracket = ')';
            rightBracket = '(';
            todo = end > -1;
        }
        StringBuffer sb = new StringBuffer();
        while (todo) {
            char c = expr.charAt(end);
            if (c == '\"') {
                inQuotes = !inQuotes;
            } else if (!inQuotes) {
                if (c == leftBracket) {
                    ++bracket;
                } else if (c == rightBracket) {
                    if (bracket == 0) break;
                    --bracket;
                } else if (bracket == 0 && sb.length() > 0 && symbol.indexOf(c) > 0) break;
            }
            end = isForward ? ++end : --end;
            todo = isForward ? end < length : end > -1;
            sb.append(c);
        }
        if (!isForward) {
            sb.reverse();
        }
        return sb.toString().trim();
    }

    public String[] parseFunction(String expr) {
        if (expr == null) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        String params = null;
        Matcher matcher = FUN_PATTERN.matcher(expr);
        if (matcher.find()) {
            String name = matcher.group(1);
            list.add(name);
            params = matcher.group(2);
        }
        this.parseFuncParams(list, params);
        return list.toArray(new String[0]);
    }

    public String parsePropertyAfterFunction(String expr) {
        if (expr == null) {
            return null;
        }
        int idx = 0;
        Matcher matcher = FUN_PATTERN.matcher(expr);
        if (matcher.find()) {
            idx = matcher.end();
        }
        if (idx < expr.length() - 1 && expr.charAt(idx) == '.') {
            return expr.substring(idx + 1);
        }
        return null;
    }

    public String[] parseFunctions(String expr) {
        ArrayList<String> lists = new ArrayList<String>();
        if (expr == null) {
            return new String[0];
        }
        int start = 0;
        Matcher matcher = FUNSYMBOL_PATTERN.matcher(expr);
        while (start < expr.length()) {
            if (matcher.find(start)) {
                int posEnd = this.indexOfNextBracket(expr, matcher.end());
                String func = expr.substring(matcher.start(), ++posEnd);
                Matcher kwMatcher = KEYWORD_PATTERN.matcher(func);
                if (kwMatcher.find()) {
                    String ifBody = kwMatcher.group(1);
                    String[] funcs = this.parseFunctions(ifBody);
                    for (int j = 0; j < funcs.length; ++j) {
                        lists.add(funcs[j]);
                    }
                    start = posEnd;
                    continue;
                }
                if (posEnd < expr.length() - 1 && expr.charAt(posEnd) == '.') {
                    String property = this.searchWholeExpression(expr, posEnd, true);
                    lists.add(func + property);
                    start = posEnd + property.length();
                    continue;
                }
                lists.add(func);
                start = posEnd;
                continue;
            }
            ++start;
        }
        return lists.toArray(new String[0]);
    }

    private int indexOfNextBracket(String expr, int pos) {
        char leftBracket = '(';
        char rightBracket = ')';
        int begin = pos;
        int bracket = 0;
        int length = expr.length();
        char c = expr.charAt(begin);
        while (begin < length) {
            if (c == leftBracket) {
                ++bracket;
            } else if (c == rightBracket) {
                if (bracket == 0) {
                    return begin;
                }
                --bracket;
            }
            c = expr.charAt(++begin);
        }
        return begin;
    }

    public String[] parseDateTimes(String expr) {
        ArrayList<String> lists = new ArrayList<String>();
        if (expr == null) {
            return new String[0];
        }
        int start = 0;
        Matcher matcher = DATETIME_PATTERN.matcher(expr);
        while (start < expr.length()) {
            if (matcher.find(start)) {
                String date = expr.substring(matcher.start(), matcher.end());
                lists.add(date);
                start = matcher.end();
                continue;
            }
            ++start;
        }
        return lists.toArray(new String[0]);
    }

    private void parseFuncParams(List list, String params) {
        if (params == null) {
            return;
        }
        String[] array = params.split("\\s*,\\s*");
        for (int i = 0; i < array.length; ++i) {
            if (array[i].length() <= 0) continue;
            list.add(array[i]);
        }
    }

    public String castRegular(String expr) {
        Matcher matcher = REG_PATTERN.matcher(expr);
        int start = 0;
        StringBuffer sb = new StringBuffer();
        int lastend = 0;
        while (start < expr.length()) {
            if (matcher.find(start)) {
                sb.append(expr.substring(start, matcher.end() - 1));
                sb.append("\\");
                sb.append(matcher.group(0));
                lastend = start = matcher.end();
                continue;
            }
            ++start;
        }
        if (lastend < expr.length()) {
            sb.append(expr.substring(lastend));
        }
        return sb.toString();
    }

    public String[] splitBarVariables(String expr) {
        Matcher matcher = BAR_PATTERN.matcher(expr);
        int start = 0;
        ArrayList<String> results = new ArrayList<String>();
        while (start < expr.length()) {
            if (matcher.find(start)) {
                results.add(matcher.group(1));
                start = matcher.end();
                continue;
            }
            ++start;
        }
        return results.toArray(new String[0]);
    }

    public boolean isBracesVariable(String expr) {
        Matcher matcher = BRACES_PATTERN.matcher(expr);
        return matcher.find();
    }

    public String[] splitBracesVariables(String expr) {
        Matcher matcher = BRACES_BRACKETS_PATTERN.matcher(expr);
        int start = 0;
        ArrayList<String> results = new ArrayList<String>();
        while (start < expr.length()) {
            if (matcher.find(start)) {
                String v = matcher.group(0);
                if (v == null) {
                    v = matcher.group(1);
                }
                if (v == null) continue;
                results.add(v);
                start = matcher.end();
                continue;
            }
            ++start;
        }
        return results.toArray(new String[0]);
    }

    public static boolean isTemporaryVariable(String variable) {
        return variable.startsWith("[") && variable.endsWith("]");
    }
}

