/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.util;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.eas.dynbusiness.util.DataConverter;
import com.kingdee.eas.dynbusiness.util.ValueConstants;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class ValidationUtils {
    static final Logger logger = Logger.getLogger(ValidationUtils.class);
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    public static final String REQUIRED_SYMBOL = "REQUIRED";

    public static boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        return value instanceof String ? ((String)value).trim().length() == 0 : (value instanceof BigDecimal ? ((BigDecimal)value).compareTo(ValueConstants.ZERO) == 0 : (value instanceof Boolean ? (Boolean)value == false : (value instanceof Integer ? (Integer)value == 0 : (value instanceof IObjectCollection ? ((IObjectCollection)value).size() == 0 : (value instanceof Collection ? ((Collection)value).size() == 0 : value instanceof Map && ((Map)value).size() == 0)))));
    }

    public static Object insteadOfNull(Object value, DataType dataType) {
        if (value != null) {
            return value;
        }
        if (dataType.equals((Object)DataType.STRING)) {
            return "";
        }
        if (dataType.equals((Object)DataType.BOOLEAN)) {
            return Boolean.FALSE;
        }
        if (dataType.equals((Object)DataType.DECIMAL)) {
            return ValueConstants.ZERO;
        }
        if (dataType.equals((Object)DataType.DATE) || dataType.equals((Object)DataType.TIMESTAMP) || dataType.equals((Object)DataType.TIME)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            try {
                return dateFormat.parse("1900-01-01");
            }
            catch (ParseException e) {
                logger.error((Object)e);
            }
        } else {
            if (dataType.equals((Object)DataType.INTEGER)) {
                return Integer.valueOf("0");
            }
            if (dataType.equals((Object)DataType.SHORT)) {
                return Short.valueOf("0");
            }
            if (dataType.equals((Object)DataType.LONG)) {
                return Long.valueOf("0");
            }
            if (dataType.equals((Object)DataType.FLOAT)) {
                return Float.valueOf("0.00");
            }
            if (dataType.equals((Object)DataType.DOUBLE)) {
                return Double.valueOf("0.00");
            }
        }
        return null;
    }

    public static boolean doRealValidate(Object value, String validation) {
        if (validation.equalsIgnoreCase(REQUIRED_SYMBOL)) {
            return ValidationUtils.isEmpty(value);
        }
        return ValidationUtils.doRealCompare(value, null, validation, null, null);
    }

    public static boolean isEquals(Object object, Object val, DataType dataType, String className) {
        if (object == null && val == null) {
            return true;
        }
        if (val == null) {
            return false;
        }
        if (object == null) {
            return false;
        }
        if (dataType.equals((Object)DataType.BOOLEAN)) {
            object = ValidationUtils.convertForBoolean(object);
            val = ValidationUtils.convertForBoolean(val);
        }
        if (!(object instanceof Comparable) || !(val instanceof Comparable)) {
            return object.equals(val);
        }
        return ValidationUtils.compare(object, val, "=");
    }

    private static Object convertForBoolean(Object object) {
        if (object instanceof Integer) {
            Boolean o = Boolean.TRUE;
            if ((Integer)object == 0) {
                o = Boolean.FALSE;
            }
            return o;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        return object;
    }

    private static boolean compare(Object obj, Object val, String operator) {
        if (obj == null || val == null) {
            return false;
        }
        if (!obj.getClass().getName().equals(val.getClass().getName())) {
            return false;
        }
        if (!(obj instanceof Comparable)) {
            throw new UnsupportedOperationException("The Object " + obj + " is not supported comparing.");
        }
        int result = ((Comparable)obj).compareTo(val);
        if (operator.equals("=")) {
            return result == 0;
        }
        if (operator.equals("<>")) {
            return result != 0;
        }
        if (operator.equals(">")) {
            return result > 0;
        }
        if (operator.equals("<")) {
            return result < 0;
        }
        if (operator.equals(">=")) {
            return result >= 0;
        }
        if (operator.equals("<=")) {
            return result <= 0;
        }
        throw new UnsupportedOperationException(operator + " is not supported.");
    }

    public static boolean doRealCompare(Object obj, Object val, String operator, DataType dataType, String className) {
        if (operator.equalsIgnoreCase("isNull")) {
            return obj == null;
        }
        if (operator.equalsIgnoreCase("isNotNull")) {
            return obj != null;
        }
        Object object = ValidationUtils.insteadOfNull(obj, dataType);
        Object covertedValue = val;
        if (!(object instanceof String) && val instanceof String) {
            covertedValue = DataConverter.convert(object, (String)val, dataType, className);
        }
        if (operator.equals("=")) {
            return ValidationUtils.isEquals(object, covertedValue, dataType, className);
        }
        if (operator.equals("<>")) {
            return !ValidationUtils.isEquals(object, covertedValue, dataType, className);
        }
        if (operator.equalsIgnoreCase("in")) {
            return ValidationUtils.doInCompare(obj, val, operator);
        }
        if (operator.equalsIgnoreCase("notIn")) {
            return ValidationUtils.doNotInCompare(obj, val, operator);
        }
        if (operator.equalsIgnoreCase("like")) {
            return ValidationUtils.doLikeCompare(obj, val, operator);
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Comparable) || !(covertedValue instanceof Comparable)) {
            return object.equals(covertedValue);
        }
        return ValidationUtils.compare(object, covertedValue, operator);
    }

    private static boolean doLikeCompare(Object obj, Object val, String operator) {
        if (obj == null) {
            return false;
        }
        if (val == null) {
            return true;
        }
        if (!(obj instanceof String) && !(val instanceof String)) {
            throw new UnsupportedOperationException(operator + " is only support for String.");
        }
        String o1 = (String)obj;
        String o2 = ((String)val).trim();
        if (o2.length() == 0) {
            return true;
        }
        if (o2.startsWith("%")) {
            o2 = o2.replaceFirst("%", ".*");
        }
        if (o2.endsWith("%")) {
            o2 = o2.replaceFirst("%$", ".*");
        }
        return o1.matches(o2);
    }

    private static boolean doNotInCompare(Object obj, Object val, String operator) {
        if (val == null) {
            return true;
        }
        if (obj instanceof Object[]) {
            List<Object> objList = Arrays.asList((Object[])obj);
            Collection<Object> valueList = null;
            if (val instanceof Object[]) {
                valueList = Arrays.asList((Object[])val);
            } else if (val instanceof Collection) {
                valueList = (Collection)val;
            } else {
                throw new UnsupportedOperationException(operator + " is only support for Array or Collection.");
            }
            return !valueList.containsAll(objList);
        }
        if (val instanceof Object[]) {
            Object[] values = (Object[])val;
            for (int i = 0; i < values.length; ++i) {
                if (!obj.equals(values[i])) continue;
                return false;
            }
            return true;
        }
        if (val instanceof Collection) {
            return !((Collection)val).contains(obj);
        }
        throw new UnsupportedOperationException(operator + " is only support for Array or Collection.");
    }

    private static boolean doInCompare(Object obj, Object val, String operator) {
        if (val == null) {
            return false;
        }
        if (obj instanceof Object[]) {
            List<Object> objList = Arrays.asList((Object[])obj);
            Collection<Object> valueList = null;
            if (val instanceof Object[]) {
                valueList = Arrays.asList((Object[])val);
            } else if (val instanceof Collection) {
                valueList = (Collection)val;
            } else {
                throw new UnsupportedOperationException(operator + " is only support for Array or Collection.");
            }
            return valueList.containsAll(objList);
        }
        if (val instanceof Object[]) {
            Object[] values = (Object[])val;
            for (int i = 0; i < values.length; ++i) {
                if (!obj.equals(values[i])) continue;
                return true;
            }
            return false;
        }
        if (val instanceof Collection) {
            return ((Collection)val).contains(obj);
        }
        throw new UnsupportedOperationException(operator + " is only support for Array or Collection.");
    }
}

