/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.em.common.utils;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.eas.em.common.EMException;
import com.kingdee.eas.em.common.utils.EMClientUtils;
import com.kingdee.eas.em.common.utils.EMUtils;
import com.kingdee.util.StringUtils;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;

public class EMRequiredUtils {
    public static EMException checkRequiredItem(KDLabelContainer[] container) {
        EMException exc = null;
        int count = container.length;
        for (int i = 0; i < count; ++i) {
            JComponent input = container[i].getBoundEditor();
            if ((input instanceof KDTextField || input instanceof JFormattedTextField) && EMUtils.isNotNull((Object)(exc = EMRequiredUtils.checkRequiredItem((JTextField)input, container[i])))) {
                return exc;
            }
            if (input instanceof KDBizMultiLangBox && EMUtils.isNotNull((Object)(exc = EMRequiredUtils.checkRequiredItem((KDBizMultiLangBox)input, container[i])))) {
                return exc;
            }
            if (input instanceof KDDatePicker && EMUtils.isNotNull((Object)(exc = EMRequiredUtils.checkRequiredItem((KDDatePicker)input, container[i])))) {
                return exc;
            }
            if (input instanceof KDBizPromptBox && EMUtils.isNotNull((Object)(exc = EMRequiredUtils.checkRequiredItem((KDBizPromptBox)input, container[i])))) {
                return exc;
            }
            if (!(input instanceof KDComboBox) || !EMUtils.isNotNull((Object)(exc = EMRequiredUtils.checkRequiredItem((KDComboBox)input, container[i])))) continue;
            return exc;
        }
        return exc;
    }

    public static EMException checkRequiredItem(JTextField input, KDLabelContainer title) {
        EMException exc = null;
        if (StringUtils.isEmpty((String)input.getText())) {
            input.requestFocus();
            exc = new EMException(EMException.NULL_TEXT_FIELD, new String[]{title.getBoundLabelText()});
        }
        return exc;
    }

    public static EMException checkRequiredItem(KDBizMultiLangBox input, KDLabelContainer title) {
        EMException exc = null;
        if (StringUtils.isEmpty((String)EMClientUtils.getBizMultiLangBoxValue(input))) {
            input.requestFocus();
            exc = new EMException(EMException.NULL_MULTITEXT_FIELD, new String[]{title.getBoundLabelText()});
        }
        return exc;
    }

    public static EMException checkRequiredItem(KDDatePicker input, KDLabelContainer title) {
        EMException exc = null;
        if (EMUtils.isNull(input.getValue())) {
            input.requestFocus();
            exc = new EMException(EMException.NULL_DATE_FIELD, new String[]{title.getBoundLabelText()});
        }
        return exc;
    }

    public static EMException checkRequiredItem(KDBizPromptBox input, KDLabelContainer title) {
        EMException exc = null;
        if (EMUtils.isNull(input.getValue())) {
            input.requestFocus();
            exc = new EMException(EMException.NULL_F7_FIELD, new String[]{title.getBoundLabelText()});
        }
        return exc;
    }

    public static EMException checkRequiredItem(KDComboBox input, KDLabelContainer title) {
        EMException exc = null;
        if (EMUtils.isNull(input.getSelectedItem())) {
            input.requestFocus();
            exc = new EMException(EMException.NULL_COMBO_FIELD, new String[]{title.getBoundLabelText()});
        }
        return exc;
    }

    public static EMException checkEntryRequiredItem(KDTable kdtEntries, String[] checkColumnNames) throws Exception {
        EMException exc = null;
        int[] columnIndex = new int[checkColumnNames.length];
        int count = checkColumnNames.length;
        for (int j = 0; j < count; ++j) {
            columnIndex[j] = kdtEntries.getColumnIndex(checkColumnNames[j]);
        }
        int size = kdtEntries.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = kdtEntries.getRow(i);
            int count2 = checkColumnNames.length;
            for (int j = 0; j < count2; ++j) {
                Object o = row.getCell(checkColumnNames[j]).getValue();
                boolean isThrowable = false;
                if (EMUtils.isNull(o)) {
                    isThrowable = true;
                } else if (StringUtils.isEmpty((String)o.toString())) {
                    isThrowable = true;
                }
                if (!isThrowable) continue;
                kdtEntries.getEditManager().editCellAt(i, columnIndex[j]);
                throw new EMException(EMException.NULL_ENTRY_FIELD, new Object[]{new Integer(i + 1), kdtEntries.getHead().getRow(0).getCell(columnIndex[j]).getValue()});
            }
        }
        return exc;
    }

    public static EMException checkEntryRequiredItem(KDTable kdtEntries, String[] checkColumnNames, int rowIndex) throws Exception {
        EMException exc = null;
        int[] columnIndex = new int[checkColumnNames.length];
        int count = checkColumnNames.length;
        for (int j = 0; j < count; ++j) {
            columnIndex[j] = kdtEntries.getColumnIndex(checkColumnNames[j]);
        }
        IRow row = kdtEntries.getRow(rowIndex);
        int count2 = checkColumnNames.length;
        for (int j = 0; j < count2; ++j) {
            Object o = row.getCell(checkColumnNames[j]).getValue();
            boolean isThrowable = false;
            if (EMUtils.isNull(o)) {
                isThrowable = true;
            } else if (StringUtils.isEmpty((String)o.toString())) {
                isThrowable = true;
            }
            if (!isThrowable) continue;
            kdtEntries.getEditManager().editCellAt(rowIndex, columnIndex[j]);
            throw new EMException(EMException.NULL_ENTRY_FIELD, new Object[]{new Integer(rowIndex + 1), kdtEntries.getHead().getRow(0).getCell(columnIndex[j]).getValue()});
        }
        return exc;
    }
}

