/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.zj;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.zj.AbstractDivisionWarehouseFacadeControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DivisionWarehouseFacadeControllerBean
extends AbstractDivisionWarehouseFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.zj.DivisionWarehouseFacadeControllerBean");
    private static final long serialVersionUID = -1367500760637970997L;

    @Override
    protected String _createTempTable(Context ctx) throws BOSException, EASBizException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Create Table TempTable(\r\n");
        sql.append("FID VARCHAR(100) Null,\r\n");
        sql.append("FStorageOrgUnitID VARCHAR(44) Null,\r\n");
        sql.append("FWorkCenterID VARCHAR(44) Null,\r\n");
        sql.append("FMaterialID VARCHAR(44) Null,\r\n");
        sql.append("FWarehouseID VARCHAR(44) Null,\r\n");
        sql.append("FSourceBillID VARCHAR(44) Null\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FMaterialID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FStorageOrgUnitID,FMaterialID,IsNull(FWorkCenterID,'Null'),FID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FID,FWarehouseID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    @Override
    protected List _getCollectionIDList(Context ctx, IObjectCollection objectCollection) throws BOSException, EASBizException {
        if (objectCollection == null) {
            return null;
        }
        if (objectCollection.size() == 0) {
            return null;
        }
        ArrayList<String> idList = new ArrayList<String>();
        for (int index = 0; index < objectCollection.size(); ++index) {
            IObjectValue objectValue = objectCollection.getObject(index);
            if (objectValue == null || objectValue.getBOSUuid("id") == null || idList.contains(objectValue.getBOSUuid("id").toString())) continue;
            idList.add(objectValue.getBOSUuid("id").toString());
        }
        return idList;
    }

    @Override
    protected IObjectValue _getWarehouse(Context ctx, Map param) throws BOSException, EASBizException {
        String warehouseKey;
        String objectCollectionKey;
        IObjectCollection objectCollection;
        String userID;
        if (param == null) {
            return null;
        }
        if (!param.containsKey("UpdateID")) {
            return null;
        }
        if (!param.containsKey("StorageOrgUnitID")) {
            return null;
        }
        if (!param.containsKey("MaterialID")) {
            return null;
        }
        if (!param.containsKey("ObjectCollection")) {
            return null;
        }
        if (!param.containsKey("WarehouseKey")) {
            return null;
        }
        String updateID = param.get("UpdateID") == null ? null : param.get("UpdateID").toString();
        String storageOrgUnitID = param.get("StorageOrgUnitID") == null ? null : param.get("StorageOrgUnitID").toString();
        String materialID = param.get("MaterialID") == null ? null : param.get("MaterialID").toString();
        String string = userID = param.get("UserID") == null ? null : param.get("UserID").toString();
        IObjectCollection iObjectCollection = param.get("ObjectCollection") == null ? null : (objectCollection = param.get("ObjectCollection") instanceof IObjectCollection ? (IObjectCollection)param.get("ObjectCollection") : null);
        String string2 = param.containsKey("ObjectCollectionKey") ? (param.get("ObjectCollectionKey") == null ? null : param.get("ObjectCollectionKey").toString()) : (objectCollectionKey = null);
        String string3 = param.containsKey("WarehouseKey") ? (param.get("WarehouseKey") == null ? null : param.get("WarehouseKey").toString()) : (warehouseKey = null);
        if (updateID == null || storageOrgUnitID == null || materialID == null || objectCollection == null) {
            return null;
        }
        if (updateID.trim().length() == 0 || storageOrgUnitID.trim().length() == 0 || materialID.trim().length() == 0 || objectCollection.size() == 0) {
            return null;
        }
        if (warehouseKey == null && objectCollection != null) {
            return null;
        }
        if (objectCollection != null) {
            if (warehouseKey == null) {
                return null;
            }
            if (warehouseKey.trim().length() == 0) {
                return null;
            }
            if (warehouseKey.indexOf(".") >= 0) {
                warehouseKey = warehouseKey.substring(warehouseKey.indexOf(".") + 1);
            }
        }
        String tempTable = this._createTempTable(ctx);
        param.put("TempTable", tempTable);
        StringBuffer sql = new StringBuffer();
        int effectedRows = 0;
        sql.setLength(0);
        sql.append(this._insertTempTable(ctx, tempTable));
        sql.append("Values(\r\n");
        sql.append("'").append(updateID).append("',\r\n");
        if (storageOrgUnitID == null) {
            sql.append("Null,\r\n");
        } else {
            sql.append("'").append(storageOrgUnitID).append("',\r\n");
        }
        sql.append("Null,\r\n");
        if (materialID == null) {
            sql.append("Null,\r\n");
        } else {
            sql.append("'").append(materialID).append("',\r\n");
        }
        sql.append("Null,\r\n");
        sql.append("Null\r\n");
        sql.append(")\r\n");
        effectedRows = SQLUtils.execute((Context)ctx, (String)sql.toString());
        logger.debug((Object)effectedRows);
        sql.setLength(0);
        sql.append("Update [WarehouseTempTable] UT\r\n");
        sql.append("Set FWarehouseID=Null\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And UT.FWarehouseID Is Not Null\r\n");
        sql.append("And IsNull((\r\n");
        sql.append("Select\r\n");
        sql.append("Count(1)\r\n");
        sql.append("From T_PM_User U\r\n");
        sql.append("Inner Join T_IN_WarehousePerson WP On\r\n");
        sql.append("1=1\r\n");
        sql.append("And WP.FPersonID=U.FPersonID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And U.FID='").append(userID).append("'\r\n");
        sql.append("And WP.FWarehouseID=UT.FWarehouseID\r\n");
        sql.append("),0)=0\r\n");
        param.put("WarehouseExtendSQL", sql.toString());
        param.put("UpdateTable", tempTable);
        param.put("UpdateColumn", "FWarehouseID");
        param.put("InOut", "In");
        objectCollection = this._refreshWarehouse(ctx, param);
        for (int index = 0; index < objectCollection.size(); ++index) {
            IObjectValue objectValue = objectCollection.getObject(index);
            if (objectValue == null) continue;
            if (objectCollectionKey != null) {
                IObjectCollection entryCollection;
                if (!(objectValue.get(objectCollectionKey) instanceof IObjectCollection) || (entryCollection = (IObjectCollection)objectValue.get(objectCollectionKey)).size() <= 0) continue;
                for (int entryIndex = 0; entryIndex < entryCollection.size(); ++entryIndex) {
                    IObjectValue entryValue = entryCollection.getObject(index);
                    if (entryValue == null) continue;
                    IObjectValue warehouseInfo = entryValue.containsKey(warehouseKey) ? (entryValue.get(warehouseKey) == null ? null : (entryValue.get(warehouseKey) instanceof IObjectValue ? (IObjectValue)entryValue.get(warehouseKey) : null)) : null;
                    return warehouseInfo;
                }
                continue;
            }
            return null;
        }
        return null;
    }

    @Override
    protected void _insertDataToTempTable(Context ctx, Map param) throws BOSException, EASBizException {
        String sourceBillIDKey;
        IObjectCollection objectCollection;
        String tempTable;
        if (param == null) {
            return;
        }
        if (!param.containsKey("TempTable")) {
            return;
        }
        if (!param.containsKey("ObjectCollection")) {
            return;
        }
        if (!param.containsKey("IDKey")) {
            return;
        }
        if (!param.containsKey("StorageOrgUnitKey")) {
            return;
        }
        if (!param.containsKey("MaterialKey")) {
            return;
        }
        if (!param.containsKey("WarehouseKey")) {
            return;
        }
        if (!param.containsKey("SourceBillIDKey")) {
            return;
        }
        String string = tempTable = param.get("TempTable") == null ? null : param.get("TempTable").toString();
        IObjectCollection iObjectCollection = param.get("ObjectCollection") == null ? null : (objectCollection = param.get("ObjectCollection") instanceof IObjectCollection ? (IObjectCollection)param.get("ObjectCollection") : null);
        String objectCollectionKey = param.containsKey("ObjectCollectionKey") ? (param.get("ObjectCollectionKey") == null ? null : param.get("ObjectCollectionKey").toString()) : null;
        String idKey = param.get("IDKey") == null ? null : param.get("IDKey").toString();
        String storageOrgUnitKey = param.get("StorageOrgUnitKey") == null ? null : param.get("StorageOrgUnitKey").toString();
        String workCenterKey = param.get("WorkCenterKey") == null ? null : param.get("WorkCenterKey").toString();
        String materialKey = param.get("MaterialKey") == null ? null : param.get("MaterialKey").toString();
        String warehouseKey = param.get("WarehouseKey") == null ? null : param.get("WarehouseKey").toString();
        String string2 = sourceBillIDKey = param.get("SourceBillIDKey") == null ? null : param.get("SourceBillIDKey").toString();
        if (tempTable == null) {
            return;
        }
        if (tempTable.trim().length() == 0) {
            return;
        }
        if (objectCollection == null) {
            return;
        }
        if (objectCollection.size() == 0) {
            return;
        }
        if (idKey == null) {
            return;
        }
        if (idKey.trim().length() == 0) {
            return;
        }
        if (storageOrgUnitKey == null) {
            return;
        }
        if (storageOrgUnitKey.trim().length() == 0) {
            return;
        }
        if (materialKey == null) {
            return;
        }
        if (materialKey.trim().length() == 0) {
            return;
        }
        if (warehouseKey == null) {
            return;
        }
        if (warehouseKey.trim().length() == 0) {
            return;
        }
        if (sourceBillIDKey == null) {
            return;
        }
        if (sourceBillIDKey.trim().length() == 0) {
            return;
        }
        for (int index = 0; index < objectCollection.size(); ++index) {
            IObjectValue objectValue = objectCollection.getObject(index);
            if (idKey.indexOf(objectCollectionKey + ".") < 0) {
                String id = this.getColumnBOSUUID(objectValue, idKey);
                if (id == null || id.trim().length() == 0) continue;
                param.put("ID", id);
            }
            if (storageOrgUnitKey.indexOf(objectCollectionKey + ".") < 0) {
                param.put("StorageOrgUnitID", this.getColumnObjectValueID(objectValue, storageOrgUnitKey));
            }
            if (workCenterKey != null && workCenterKey.trim().length() > 0 && workCenterKey.indexOf(objectCollectionKey + ".") < 0) {
                param.put("WorkCenterID", this.getColumnObjectValueID(objectValue, workCenterKey));
            }
            if (materialKey.indexOf(objectCollectionKey + ".") < 0) {
                param.put("MaterialID", this.getColumnObjectValueID(objectValue, materialKey));
            }
            if (warehouseKey.indexOf(objectCollectionKey + ".") < 0) {
                param.put("WarehouseID", this.getColumnObjectValueID(objectValue, warehouseKey));
            }
            if (sourceBillIDKey.indexOf(objectCollectionKey + ".") < 0) {
                param.put("SourceBillID", this.getColumnString(objectValue, sourceBillIDKey));
            }
            if (objectCollectionKey != null) {
                IObjectCollection entryCollection;
                if (!(objectValue.get(objectCollectionKey) instanceof IObjectCollection) || (entryCollection = (IObjectCollection)objectValue.get(objectCollectionKey)).size() <= 0) continue;
                for (int entryIndex = 0; entryIndex < entryCollection.size(); ++entryIndex) {
                    IObjectValue entryValue = entryCollection.getObject(index);
                    if (entryValue == null) continue;
                    param.put("ObjectValue", entryValue);
                    this.insertRowDataToTempTable(ctx, param);
                }
                continue;
            }
            param.put("ObjectValue", objectValue);
            this.insertRowDataToTempTable(ctx, param);
        }
    }

    @Override
    protected String _insertTempTable(Context ctx, String tempTableName) throws BOSException, EASBizException {
        if (tempTableName == null) {
            return null;
        }
        if (tempTableName.trim().length() == 0) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(tempTableName).append("(\r\n");
        sql.append("FID,\r\n");
        sql.append("FStorageOrgUnitID,\r\n");
        sql.append("FWorkCenterID,\r\n");
        sql.append("FMaterialID,\r\n");
        sql.append("FWarehouseID,\r\n");
        sql.append("FSourceBillID\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IObjectCollection _refreshPurReceivalWarehouse(Context ctx, Map param) throws BOSException, EASBizException {
        IObjectCollection objectCollection;
        block63: {
            String warehouseKey;
            String objectCollectionKey;
            String warehouseExtendSQL;
            String updateExtendSQL;
            String inOut;
            if (param == null) {
                return null;
            }
            if (!param.containsKey("TempTable")) {
                return null;
            }
            if (!param.containsKey("UpdateTable")) {
                return null;
            }
            if (!param.containsKey("UpdateColumn")) {
                return null;
            }
            if (!param.containsKey("InOut")) {
                return null;
            }
            String tempTable = param.get("TempTable") == null ? null : param.get("TempTable").toString();
            String updateTable = param.get("UpdateTable") == null ? null : param.get("UpdateTable").toString();
            String updateColumn = param.get("UpdateColumn") == null ? null : param.get("UpdateColumn").toString();
            String string = inOut = param.get("InOut") == null ? null : param.get("InOut").toString();
            String string2 = param.containsKey("UpdateExtendSQL") ? (param.get("UpdateExtendSQL") == null ? null : param.get("UpdateExtendSQL").toString()) : (updateExtendSQL = null);
            String string3 = param.containsKey("WarehouseExtendSQL") ? (param.get("WarehouseExtendSQL") == null ? null : param.get("WarehouseExtendSQL").toString()) : (warehouseExtendSQL = null);
            IObjectCollection iObjectCollection = param.containsKey("ObjectCollection") ? (param.get("ObjectCollection") == null ? null : (param.get("ObjectCollection") instanceof IObjectCollection ? (IObjectCollection)param.get("ObjectCollection") : null)) : (objectCollection = null);
            String string4 = param.containsKey("ObjectCollectionKey") ? (param.get("ObjectCollectionKey") == null ? null : param.get("ObjectCollectionKey").toString()) : (objectCollectionKey = null);
            if (!param.containsKey("WarehouseKey") && objectCollection != null) {
                return null;
            }
            String string5 = param.containsKey("WarehouseKey") ? (param.get("WarehouseKey") == null ? null : param.get("WarehouseKey").toString()) : (warehouseKey = null);
            if (tempTable == null) {
                return null;
            }
            if (tempTable.trim().length() == 0) {
                return null;
            }
            if (updateTable == null) {
                return null;
            }
            if (updateTable.trim().length() == 0) {
                return null;
            }
            if (updateColumn == null) {
                return null;
            }
            if (updateColumn.trim().length() == 0) {
                return null;
            }
            if (objectCollection != null) {
                if (warehouseKey == null) {
                    return null;
                }
                if (warehouseKey.trim().length() == 0) {
                    return null;
                }
                if (warehouseKey.indexOf(".") >= 0) {
                    warehouseKey = warehouseKey.substring(warehouseKey.indexOf(".") + 1);
                }
            }
            String WarehouseTempTable = this.createWarehouseTempTable(ctx);
            int effectedRows = 0;
            StringBuffer sql = new StringBuffer();
            try {
                sql.setLength(0);
                sql.append(this.insertWarehouseTempTable(ctx, WarehouseTempTable));
                sql.append("Select\r\n");
                sql.append("T.FID,\r\n");
                sql.append("DW.CFWarehouseID\r\n");
                sql.append("From ").append(tempTable).append(" T\r\n");
                sql.append("Left Join CT_BD_DivisionWarehouse DW On\r\n");
                sql.append("1=1\r\n");
                sql.append("And DW.CFMaterialID=T.FMaterialID\r\n");
                if (inOut != null) {
                    if ("In".equals(inOut)) {
                        sql.append("And IsNull(DW.CFIsOut,0)=0\r\n");
                    } else if ("Out".equals(inOut)) {
                        sql.append("And IsNull(DW.CFIsOut,0)=1\r\n");
                    }
                }
                sql.append("And IsNull(DW.CFDeletedStatus,1)=").append(1).append("\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And IsNull((\r\n");
                sql.append("Select\r\n");
                sql.append("Count(1)\r\n");
                sql.append("From CT_BD_DivisionWarehouse TDW\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And TDW.CFMaterialID=T.FMaterialID\r\n");
                if (inOut != null) {
                    if ("In".equals(inOut)) {
                        sql.append("And IsNull(TDW.CFIsOut,0)=0\r\n");
                    } else if ("Out".equals(inOut)) {
                        sql.append("And IsNull(TDW.CFIsOut,0)=1\r\n");
                    }
                }
                sql.append("),0)=1\r\n");
                effectedRows = SQLUtils.execute((Context)ctx, (String)sql.toString());
                logger.debug((Object)effectedRows);
                sql.setLength(0);
                sql.append(this.insertWarehouseTempTable(ctx, WarehouseTempTable));
                sql.append("Select\r\n");
                sql.append("T.FID,\r\n");
                sql.append("Case\r\n");
                sql.append("When DW.CFWarehouseID Is Null Then\r\n");
                sql.append("\tCase\r\n");
                sql.append("\tWhen PDW.CFWarehouseID Is Null Then FDW.CFWarehouseID\r\n");
                sql.append("\tElse PDW.CFWarehouseID\r\n");
                sql.append("\tEnd\r\n");
                sql.append("Else DW.CFWarehouseID\r\n");
                sql.append("End\r\n");
                sql.append("From ").append(tempTable).append(" T\r\n");
                sql.append("Left Join T_MM_WorkCenter WC On WC.FID=T.FWorkCenterID\r\n");
                sql.append("Left Join CT_BD_DivisionWarehouse DW On\r\n");
                sql.append("1=1\r\n");
                sql.append("And DW.CFMaterialID=T.FMaterialID\r\n");
                sql.append("And IsNull(DW.CFWorkCenterID,'Null')=IsNull(T.FWorkCenterID,'Null')\r\n");
                if (inOut != null) {
                    if ("In".equals(inOut)) {
                        sql.append("And IsNull(DW.CFIsOut,0)=0\r\n");
                    } else if ("Out".equals(inOut)) {
                        sql.append("And IsNull(DW.CFIsOut,0)=1\r\n");
                    }
                }
                sql.append("And IsNull(DW.CFDeletedStatus,1)=").append(1).append("\r\n");
                sql.append("Left Join CT_BD_DivisionWarehouse PDW On\r\n");
                sql.append("1=1\r\n");
                sql.append("And PDW.CFMaterialID=T.FMaterialID\r\n");
                sql.append("And IsNull(PDW.CFWorkCenterID,'Null')=IsNull(WC.FParentWCID,'Null')\r\n");
                if (inOut != null) {
                    if ("In".equals(inOut)) {
                        sql.append("And IsNull(PDW.CFIsOut,0)=0\r\n");
                    } else if ("Out".equals(inOut)) {
                        sql.append("And IsNull(PDW.CFIsOut,0)=1\r\n");
                    }
                }
                sql.append("And IsNull(PDW.CFDeletedStatus,1)=").append(1).append("\r\n");
                sql.append("Left Join CT_BD_DivisionWarehouse FDW On\r\n");
                sql.append("1=1\r\n");
                sql.append("And FDW.CFMaterialID=T.FMaterialID\r\n");
                sql.append("And IsNull(FDW.CFWorkCenterID,'Null')='Null'\r\n");
                if (inOut != null) {
                    if ("In".equals(inOut)) {
                        sql.append("And IsNull(FDW.CFIsOut,0)=0\r\n");
                    } else if ("Out".equals(inOut)) {
                        sql.append("And IsNull(FDW.CFIsOut,0)=1\r\n");
                    }
                }
                sql.append("And IsNull(FDW.CFDeletedStatus,1)=").append(1).append("\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And T.FStorageOrgUnitID='").append("4ueEzZGDSYuVfAD/hLHijsznrtQ=").append("'\r\n");
                sql.append("And IsNull((\r\n");
                sql.append("Select\r\n");
                sql.append("Count(1)\r\n");
                sql.append("From CT_BD_DivisionWarehouse TDW\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And TDW.CFMaterialID=T.FMaterialID\r\n");
                sql.append("),0)>1\r\n");
                effectedRows = SQLUtils.execute((Context)ctx, (String)sql.toString());
                logger.debug((Object)effectedRows);
                sql.setLength(0);
                sql.append(this.insertWarehouseTempTable(ctx, WarehouseTempTable));
                sql.append("Select\r\n");
                sql.append("T.FID,\r\n");
                sql.append("Case\r\n");
                sql.append("When DW.CFWarehouseID Is Null Then\r\n");
                sql.append("\tCase\r\n");
                sql.append("\tWhen PDW.CFWarehouseID Is Null Then FDW.CFWarehouseID\r\n");
                sql.append("\tElse PDW.CFWarehouseID\r\n");
                sql.append("\tEnd\r\n");
                sql.append("Else DW.CFWarehouseID\r\n");
                sql.append("End\r\n");
                sql.append("From ").append(tempTable).append(" T\r\n");
                sql.append("Left Join T_MM_WorkCenter WC On WC.FID=T.FWorkCenterID\r\n");
                sql.append("Left Join CT_BD_DivisionWarehouse DW On\r\n");
                sql.append("1=1\r\n");
                sql.append("And DW.CFStorageOrgUnitID=T.FStorageOrgUnitID\r\n");
                sql.append("And DW.CFMaterialID=T.FMaterialID\r\n");
                sql.append("And IsNull(DW.CFWorkCenterID,'Null')=IsNull(T.FWorkCenterID,'Null')\r\n");
                if (inOut != null) {
                    if ("In".equals(inOut)) {
                        sql.append("And IsNull(DW.CFIsOut,0)=0\r\n");
                    } else if ("Out".equals(inOut)) {
                        sql.append("And IsNull(DW.CFIsOut,0)=1\r\n");
                    }
                }
                sql.append("And IsNull(DW.CFDeletedStatus,1)=").append(1).append("\r\n");
                sql.append("Left Join CT_BD_DivisionWarehouse PDW On\r\n");
                sql.append("1=1\r\n");
                sql.append("And PDW.CFStorageOrgUnitID=T.FStorageOrgUnitID\r\n");
                sql.append("And PDW.CFMaterialID=T.FMaterialID\r\n");
                sql.append("And IsNull(PDW.CFWorkCenterID,'Null')=IsNull(WC.FParentWCID,'Null')\r\n");
                if (inOut != null) {
                    if ("In".equals(inOut)) {
                        sql.append("And IsNull(PDW.CFIsOut,0)=0\r\n");
                    } else if ("Out".equals(inOut)) {
                        sql.append("And IsNull(PDW.CFIsOut,0)=1\r\n");
                    }
                }
                sql.append("And IsNull(PDW.CFDeletedStatus,1)=").append(1).append("\r\n");
                sql.append("Left Join CT_BD_DivisionWarehouse FDW On\r\n");
                sql.append("1=1\r\n");
                sql.append("And FDW.CFStorageOrgUnitID=T.FStorageOrgUnitID\r\n");
                sql.append("And FDW.CFMaterialID=T.FMaterialID\r\n");
                sql.append("And IsNull(FDW.CFWorkCenterID,'Null')='Null'\r\n");
                if (inOut != null) {
                    if ("In".equals(inOut)) {
                        sql.append("And IsNull(FDW.CFIsOut,0)=0\r\n");
                    } else if ("Out".equals(inOut)) {
                        sql.append("And IsNull(FDW.CFIsOut,0)=1\r\n");
                    }
                }
                sql.append("And IsNull(FDW.CFDeletedStatus,1)=").append(1).append("\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And IsNull((\r\n");
                sql.append("Select\r\n");
                sql.append("Count(1)\r\n");
                sql.append("From CT_BD_DivisionWarehouse TDW\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And TDW.CFMaterialID=T.FMaterialID\r\n");
                sql.append("),0)>1\r\n");
                effectedRows = SQLUtils.execute((Context)ctx, (String)sql.toString());
                logger.debug((Object)effectedRows);
                sql.setLength(0);
                sql.append(this.insertWarehouseTempTable(ctx, WarehouseTempTable));
                sql.append("Select\r\n");
                sql.append("T.FID,\r\n");
                sql.append("Null\r\n");
                sql.append("From ").append(tempTable).append(" T\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And IsNull((\r\n");
                sql.append("Select\r\n");
                sql.append("Count(1)\r\n");
                sql.append("From ").append(WarehouseTempTable).append(" WT\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And WT.FID=T.FID\r\n");
                sql.append("),0)=0\r\n");
                effectedRows = SQLUtils.execute((Context)ctx, (String)sql.toString());
                logger.debug((Object)effectedRows);
                if (warehouseExtendSQL != null) {
                    warehouseExtendSQL = warehouseExtendSQL.replace("[WarehouseTempTable]", WarehouseTempTable);
                    effectedRows = SQLUtils.execute((Context)ctx, (String)warehouseExtendSQL);
                    logger.debug((Object)effectedRows);
                }
                if (objectCollection == null) {
                    sql.setLength(0);
                    sql.append("Update ").append(updateTable).append(" UT\r\n");
                    sql.append("Set ").append(updateColumn).append("=(\r\n");
                    sql.append("Select\r\n");
                    sql.append("Top 1\r\n");
                    sql.append("T.FWarehouseID\r\n");
                    sql.append("From ").append(WarehouseTempTable).append(" T\r\n");
                    sql.append("Where\r\n");
                    sql.append("1=1\r\n");
                    sql.append("And T.FID=UT.FID\r\n");
                    sql.append(")\r\n");
                    sql.append("Where\r\n");
                    sql.append("1=1\r\n");
                    sql.append("And UT.FID In (\r\n");
                    sql.append("Select\r\n");
                    sql.append("T.FID\r\n");
                    sql.append("From ").append(WarehouseTempTable).append(" T\r\n");
                    sql.append(")\r\n");
                    SQLUtils.execute((Context)ctx, (String)sql.toString());
                    if (updateExtendSQL != null) {
                        effectedRows = SQLUtils.execute((Context)ctx, (String)updateExtendSQL);
                        logger.debug((Object)effectedRows);
                    }
                    break block63;
                }
                if (objectCollection.size() <= 0) break block63;
                sql.setLength(0);
                sql.append("Select\r\n");
                sql.append("T.FID FID,\r\n");
                sql.append("T.FWarehouseID FWarehouseID\r\n");
                sql.append("From ").append(WarehouseTempTable).append(" T\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                IRowSet rowSet = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
                HashMap<String, WarehouseInfo> warehouseDataMap = new HashMap<String, WarehouseInfo>();
                if (rowSet != null && rowSet.size() > 0) {
                    try {
                        while (rowSet.next()) {
                            String id = rowSet.getString("FID");
                            String warehouseID = rowSet.getString("FWarehouseID");
                            if (id == null || id.trim().length() == 0 || warehouseID == null || warehouseID.trim().length() <= 0) continue;
                            WarehouseInfo warehouseInfo = new WarehouseInfo();
                            warehouseInfo.setId(BOSUuid.read((String)warehouseID));
                            warehouseDataMap.put(id, warehouseInfo);
                        }
                    }
                    catch (Exception e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                for (int index = 0; index < objectCollection.size(); ++index) {
                    String id;
                    IObjectValue objectValue = objectCollection.getObject(index);
                    if (objectValue == null) continue;
                    String string6 = objectValue.containsKey("id") ? (objectValue.get("id") == null ? null : objectValue.get("id").toString()) : (id = null);
                    if (id == null || id.trim().length() == 0) continue;
                    if (objectCollectionKey != null) {
                        IObjectCollection entryCollection;
                        if (!(objectValue.get(objectCollectionKey) instanceof IObjectCollection) || (entryCollection = (IObjectCollection)objectValue.get(objectCollectionKey)).size() <= 0) continue;
                        for (int entryIndex = 0; entryIndex < entryCollection.size(); ++entryIndex) {
                            String entryID;
                            IObjectValue entryValue = entryCollection.getObject(index);
                            if (entryValue == null) continue;
                            String string7 = entryValue.containsKey("id") ? (entryValue.get("id") == null ? null : entryValue.get("id").toString()) : (entryID = null);
                            if (entryID == null || entryID.trim().length() == 0) continue;
                            if (warehouseDataMap.containsKey(entryID)) {
                                entryValue.put(warehouseKey, warehouseDataMap.get(entryID));
                                continue;
                            }
                            entryValue.put(warehouseKey, null);
                        }
                        continue;
                    }
                    if (warehouseDataMap.containsKey(id)) {
                        objectValue.put(warehouseKey, warehouseDataMap.get(id));
                        continue;
                    }
                    objectValue.put(warehouseKey, null);
                }
            }
            finally {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
                TempTablePool.getInstance((Context)ctx).releaseTable(WarehouseTempTable);
            }
        }
        return objectCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IObjectCollection _refreshWarehouse(Context ctx, Map param) throws BOSException, EASBizException {
        IObjectCollection objectCollection;
        block31: {
            String warehouseKey;
            String objectCollectionKey;
            String warehouseExtendSQL;
            String updateExtendSQL;
            String inOut;
            if (param == null) {
                return null;
            }
            if (!param.containsKey("TempTable")) {
                return null;
            }
            if (!param.containsKey("UpdateTable")) {
                return null;
            }
            if (!param.containsKey("UpdateColumn")) {
                return null;
            }
            if (!param.containsKey("InOut")) {
                return null;
            }
            String tempTable = param.get("TempTable") == null ? null : param.get("TempTable").toString();
            String updateTable = param.get("UpdateTable") == null ? null : param.get("UpdateTable").toString();
            String updateColumn = param.get("UpdateColumn") == null ? null : param.get("UpdateColumn").toString();
            String string = inOut = param.get("InOut") == null ? null : param.get("InOut").toString();
            String string2 = param.containsKey("UpdateExtendSQL") ? (param.get("UpdateExtendSQL") == null ? null : param.get("UpdateExtendSQL").toString()) : (updateExtendSQL = null);
            String string3 = param.containsKey("WarehouseExtendSQL") ? (param.get("WarehouseExtendSQL") == null ? null : param.get("WarehouseExtendSQL").toString()) : (warehouseExtendSQL = null);
            IObjectCollection iObjectCollection = param.containsKey("ObjectCollection") ? (param.get("ObjectCollection") == null ? null : (param.get("ObjectCollection") instanceof IObjectCollection ? (IObjectCollection)param.get("ObjectCollection") : null)) : (objectCollection = null);
            String string4 = param.containsKey("ObjectCollectionKey") ? (param.get("ObjectCollectionKey") == null ? null : param.get("ObjectCollectionKey").toString()) : (objectCollectionKey = null);
            if (!param.containsKey("WarehouseKey") && objectCollection != null) {
                return null;
            }
            String string5 = param.containsKey("WarehouseKey") ? (param.get("WarehouseKey") == null ? null : param.get("WarehouseKey").toString()) : (warehouseKey = null);
            if (tempTable == null) {
                return null;
            }
            if (tempTable.trim().length() == 0) {
                return null;
            }
            if (updateTable == null) {
                return null;
            }
            if (updateTable.trim().length() == 0) {
                return null;
            }
            if (updateColumn == null) {
                return null;
            }
            if (updateColumn.trim().length() == 0) {
                return null;
            }
            if (objectCollection != null) {
                if (warehouseKey == null) {
                    return null;
                }
                if (warehouseKey.trim().length() == 0) {
                    return null;
                }
                if (warehouseKey.indexOf(".") >= 0) {
                    warehouseKey = warehouseKey.substring(warehouseKey.indexOf(".") + 1);
                }
            }
            String WarehouseTempTable = this.createWarehouseTempTable(ctx);
            int effectedRows = 0;
            StringBuffer sql = new StringBuffer();
            try {
                sql.setLength(0);
                sql.append(this.insertWarehouseTempTable(ctx, WarehouseTempTable));
                sql.append("Select\r\n");
                sql.append("STP.FID,\r\n");
                sql.append("MWSA.FDefaultWarehouseID\r\n");
                sql.append("From ").append(tempTable).append(" STP\r\n");
                sql.append("Inner Join T_BD_MaterialInventory MWSA On\r\n");
                sql.append("1=1\r\n");
                sql.append("And MWSA.FOrgUnit=IsNull(STP.FStorageOrgUnitID,'Null')\r\n");
                sql.append("And MWSA.FMaterialID=IsNull(STP.FMaterialID,'Null')\r\n");
                sql.append("And IsNull(MWSA.FStatus,0)=").append(1).append("\r\n");
                sql.append("Group By\r\n");
                sql.append("STP.FID,\r\n");
                sql.append("MWSA.FDefaultWarehouseID\r\n");
                effectedRows = SQLUtils.execute((Context)ctx, (String)sql.toString());
                logger.debug((Object)effectedRows);
                sql.setLength(0);
                sql.append(this.insertWarehouseTempTable(ctx, WarehouseTempTable));
                sql.append("Select\r\n");
                sql.append("STP.FID,\r\n");
                sql.append("MWSA.FDefaultWarehouseID\r\n");
                sql.append("From ").append(tempTable).append(" STP\r\n");
                sql.append("Inner Join T_BD_MaterialInventory MWSA On\r\n");
                sql.append("1=1\r\n");
                sql.append("And MWSA.FOrgUnit=IsNull(STP.FStorageOrgUnitID,'Null')\r\n");
                sql.append("And MWSA.FMaterialID=IsNull(STP.FMaterialID,'Null')\r\n");
                sql.append("And IsNull(MWSA.FStatus,0)=").append(1).append("\r\n");
                sql.append("Group By\r\n");
                sql.append("STP.FID,\r\n");
                sql.append("MWSA.FDefaultWarehouseID\r\n");
                effectedRows = SQLUtils.execute((Context)ctx, (String)sql.toString());
                logger.debug((Object)effectedRows);
                sql.setLength(0);
                sql.append(this.insertWarehouseTempTable(ctx, WarehouseTempTable));
                sql.append("Select\r\n");
                sql.append("T.FID,\r\n");
                sql.append("Null\r\n");
                sql.append("From ").append(tempTable).append(" T\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And IsNull((\r\n");
                sql.append("Select\r\n");
                sql.append("Count(1)\r\n");
                sql.append("From ").append(WarehouseTempTable).append(" WT\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And WT.FID=T.FID\r\n");
                sql.append("),0)=0\r\n");
                effectedRows = SQLUtils.execute((Context)ctx, (String)sql.toString());
                logger.debug((Object)effectedRows);
                if (warehouseExtendSQL != null) {
                    warehouseExtendSQL = warehouseExtendSQL.replace("[WarehouseTempTable]", WarehouseTempTable);
                    effectedRows = SQLUtils.execute((Context)ctx, (String)warehouseExtendSQL);
                    logger.debug((Object)effectedRows);
                }
                if (objectCollection == null) {
                    sql.setLength(0);
                    sql.append("Update ").append(updateTable).append(" UT\r\n");
                    sql.append("Set ").append(updateColumn).append("=(\r\n");
                    sql.append("Select\r\n");
                    sql.append("Top 1\r\n");
                    sql.append("T.FWarehouseID\r\n");
                    sql.append("From ").append(WarehouseTempTable).append(" T\r\n");
                    sql.append("Where\r\n");
                    sql.append("1=1\r\n");
                    sql.append("And T.FID=UT.FID\r\n");
                    sql.append(")\r\n");
                    sql.append("Where\r\n");
                    sql.append("1=1\r\n");
                    sql.append("And UT.FID In (\r\n");
                    sql.append("Select\r\n");
                    sql.append("T.FID\r\n");
                    sql.append("From ").append(WarehouseTempTable).append(" T\r\n");
                    sql.append(")\r\n");
                    SQLUtils.execute((Context)ctx, (String)sql.toString());
                    if (updateExtendSQL != null) {
                        effectedRows = SQLUtils.execute((Context)ctx, (String)updateExtendSQL);
                        logger.debug((Object)effectedRows);
                    }
                    break block31;
                }
                if (objectCollection.size() <= 0) break block31;
                sql.setLength(0);
                sql.append("Select\r\n");
                sql.append("T.FID FID,\r\n");
                sql.append("T.FWarehouseID FWarehouseID,\r\n");
                sql.append("WH.FNumber FWarehouseNumber,\r\n");
                sql.append("WH.FName_").append(ctx.getLocale()).append(" FWarehouseName,\r\n");
                sql.append("WH.FHasLocation FHasLocation\r\n");
                sql.append("From ").append(WarehouseTempTable).append(" T\r\n");
                sql.append("Left Join T_DB_Warehouse WH On WH.FID=T.FWarehouseID\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                IRowSet rowSet = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
                HashMap<String, WarehouseInfo> warehouseDataMap = new HashMap<String, WarehouseInfo>();
                if (rowSet != null && rowSet.size() > 0) {
                    try {
                        while (rowSet.next()) {
                            String id = rowSet.getString("FID");
                            String warehouseID = rowSet.getString("FWarehouseID");
                            String warehouseNumber = rowSet.getString("FWarehouseNumber");
                            String warehouseName = rowSet.getString("FWarehouseName");
                            Boolean hasLocation = rowSet.getBoolean("FHasLocation");
                            if (id == null || id.trim().length() == 0 || warehouseID == null || warehouseID.trim().length() <= 0) continue;
                            WarehouseInfo warehouseInfo = new WarehouseInfo();
                            warehouseInfo.setId(BOSUuid.read((String)warehouseID));
                            warehouseInfo.setNumber(warehouseNumber);
                            warehouseInfo.setName(warehouseName);
                            warehouseInfo.setHasLocation(hasLocation.booleanValue());
                            warehouseDataMap.put(id, warehouseInfo);
                        }
                    }
                    catch (Exception e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                for (int index = 0; index < objectCollection.size(); ++index) {
                    String id;
                    IObjectValue objectValue = objectCollection.getObject(index);
                    if (objectValue == null) continue;
                    String string6 = objectValue.containsKey("id") ? (objectValue.get("id") == null ? null : objectValue.get("id").toString()) : (id = null);
                    if (id == null || id.trim().length() == 0) continue;
                    if (objectCollectionKey != null) {
                        IObjectCollection entryCollection;
                        if (!(objectValue.get(objectCollectionKey) instanceof IObjectCollection) || (entryCollection = (IObjectCollection)objectValue.get(objectCollectionKey)).size() <= 0) continue;
                        for (int entryIndex = 0; entryIndex < entryCollection.size(); ++entryIndex) {
                            String entryID;
                            IObjectValue entryValue = entryCollection.getObject(index);
                            if (entryValue == null) continue;
                            String string7 = entryValue.containsKey("id") ? (entryValue.get("id") == null ? null : entryValue.get("id").toString()) : (entryID = null);
                            if (entryID == null || entryID.trim().length() == 0) continue;
                            if (warehouseDataMap.containsKey(entryID)) {
                                entryValue.put(warehouseKey, warehouseDataMap.get(entryID));
                                continue;
                            }
                            entryValue.put(warehouseKey, null);
                        }
                        continue;
                    }
                    if (warehouseDataMap.containsKey(id)) {
                        objectValue.put(warehouseKey, warehouseDataMap.get(id));
                        continue;
                    }
                    objectValue.put(warehouseKey, null);
                }
            }
            finally {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
                TempTablePool.getInstance((Context)ctx).releaseTable(WarehouseTempTable);
            }
        }
        return objectCollection;
    }

    protected String createWarehouseTempTable(Context ctx) throws BOSException, EASBizException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Create Table WarehouseTempTable(\r\n");
        sql.append("FID VARCHAR(100) Null,\r\n");
        sql.append("FWarehouseID VARCHAR(44) Null\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FID,FWarehouseID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String getColumnBOSUUID(IObjectValue objectValue, String columnKey) {
        if (objectValue == null) {
            return null;
        }
        if (columnKey == null) {
            return null;
        }
        if (columnKey.trim().length() == 0) {
            return null;
        }
        BOSUuid bosUUID = objectValue.containsKey(columnKey) ? (objectValue.get(columnKey) == null ? null : (objectValue.get(columnKey) instanceof BOSUuid ? (BOSUuid)objectValue.get(columnKey) : null)) : null;
        String id = bosUUID == null ? null : bosUUID.toString();
        return id;
    }

    protected String getColumnObjectValueID(IObjectValue objectValue, String columnKey) {
        IObjectValue dataObjectValue;
        if (objectValue == null) {
            return null;
        }
        if (columnKey == null) {
            return null;
        }
        if (columnKey.trim().length() == 0) {
            return null;
        }
        IObjectValue iObjectValue = objectValue.containsKey(columnKey) ? (objectValue.get(columnKey) == null ? null : (objectValue.get(columnKey) instanceof IObjectValue ? (IObjectValue)objectValue.get(columnKey) : null)) : (dataObjectValue = null);
        String id = dataObjectValue == null ? null : (dataObjectValue.containsKey("id") ? (dataObjectValue.get("id") == null ? null : dataObjectValue.get("id").toString()) : null);
        return id;
    }

    protected String getColumnString(IObjectValue objectValue, String columnKey) {
        if (objectValue == null) {
            return null;
        }
        if (columnKey == null) {
            return null;
        }
        if (columnKey.trim().length() == 0) {
            return null;
        }
        String value = objectValue.containsKey(columnKey) ? (objectValue.get(columnKey) == null ? null : objectValue.get(columnKey).toString()) : null;
        return value;
    }

    protected void insertRowDataToTempTable(Context ctx, Map param) throws BOSException, EASBizException {
        String warehouseID;
        String materialID;
        String id;
        String sourceBillIDKey;
        String storageOrgUnitKey;
        String tempTable;
        if (param == null) {
            return;
        }
        if (!param.containsKey("TempTable")) {
            return;
        }
        if (!param.containsKey("ObjectValue")) {
            return;
        }
        if (!param.containsKey("IDKey")) {
            return;
        }
        if (!param.containsKey("StorageOrgUnitKey")) {
            return;
        }
        if (!param.containsKey("MaterialKey")) {
            return;
        }
        if (!param.containsKey("WarehouseKey")) {
            return;
        }
        if (!param.containsKey("SourceBillIDKey")) {
            return;
        }
        String string = tempTable = param.get("TempTable") == null ? null : param.get("TempTable").toString();
        IObjectValue objectValue = param.get("ObjectValue") == null ? null : (param.get("ObjectValue") instanceof IObjectValue ? (IObjectValue)param.get("ObjectValue") : null);
        String idKey = param.get("IDKey") == null ? null : param.get("IDKey").toString();
        String string2 = storageOrgUnitKey = param.get("StorageOrgUnitKey") == null ? null : param.get("StorageOrgUnitKey").toString();
        String workCenterKey = param.containsKey("WorkCenterKey") ? (param.get("WorkCenterKey") == null ? null : param.get("WorkCenterKey").toString()) : null;
        String materialKey = param.get("MaterialKey") == null ? null : param.get("MaterialKey").toString();
        String warehouseKey = param.get("WarehouseKey") == null ? null : param.get("WarehouseKey").toString();
        String string3 = sourceBillIDKey = param.get("SourceBillIDKey") == null ? null : param.get("SourceBillIDKey").toString();
        if (tempTable == null) {
            return;
        }
        if (tempTable.trim().length() == 0) {
            return;
        }
        if (objectValue == null) {
            return;
        }
        if (idKey == null) {
            return;
        }
        if (idKey.trim().length() == 0) {
            return;
        }
        if (storageOrgUnitKey == null) {
            return;
        }
        if (storageOrgUnitKey.trim().length() == 0) {
            return;
        }
        if (materialKey == null) {
            return;
        }
        if (materialKey.trim().length() == 0) {
            return;
        }
        if (warehouseKey == null) {
            return;
        }
        if (warehouseKey.trim().length() == 0) {
            return;
        }
        if (sourceBillIDKey == null) {
            return;
        }
        if (sourceBillIDKey.trim().length() == 0) {
            return;
        }
        if (idKey.indexOf(".") >= 0) {
            idKey = idKey.substring(idKey.indexOf(".") + 1);
        }
        if (storageOrgUnitKey.indexOf(".") >= 0) {
            storageOrgUnitKey = storageOrgUnitKey.substring(storageOrgUnitKey.indexOf(".") + 1);
        }
        if (workCenterKey != null && workCenterKey.trim().length() > 0 && workCenterKey.indexOf(".") >= 0) {
            workCenterKey = workCenterKey.substring(workCenterKey.indexOf(".") + 1);
        }
        if (materialKey.indexOf(".") >= 0) {
            materialKey = materialKey.substring(materialKey.indexOf(".") + 1);
        }
        if (warehouseKey.indexOf(".") >= 0) {
            warehouseKey = warehouseKey.substring(warehouseKey.indexOf(".") + 1);
        }
        if (sourceBillIDKey.indexOf(".") >= 0) {
            sourceBillIDKey = sourceBillIDKey.substring(sourceBillIDKey.indexOf(".") + 1);
        }
        Object object = param.containsKey("ID") ? (param.get("ID") == null ? null : param.get("ID").toString()) : (id = this.getColumnBOSUUID(objectValue, idKey));
        if (id == null) {
            return;
        }
        if (id.trim().length() == 0) {
            return;
        }
        String storageOrgUnitID = param.containsKey("StorageOrgUnitID") ? (param.get("StorageOrgUnitID") == null ? null : param.get("StorageOrgUnitID").toString()) : this.getColumnObjectValueID(objectValue, storageOrgUnitKey);
        String workCenterID = null;
        if (workCenterKey != null && workCenterKey.trim().length() > 0) {
            Object object2 = param.containsKey("WorkCenterID") ? (param.get("WorkCenterID") == null ? null : param.get("WorkCenterID").toString()) : (workCenterID = this.getColumnObjectValueID(objectValue, workCenterKey));
        }
        Object object3 = param.containsKey("MaterialID") ? (param.get("MaterialID") == null ? null : param.get("MaterialID").toString()) : (materialID = this.getColumnObjectValueID(objectValue, materialKey));
        Object object4 = param.containsKey("WarehouseID") ? (param.get("WarehouseID") == null ? null : param.get("WarehouseID").toString()) : (warehouseID = this.getColumnObjectValueID(objectValue, warehouseKey));
        String sourceBillID = param.containsKey("SourceBillID") ? (param.get("SourceBillID") == null ? null : param.get("SourceBillID").toString()) : this.getColumnString(objectValue, sourceBillIDKey);
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(this._insertTempTable(ctx, tempTable));
        sql.append("Values(\r\n");
        sql.append("'").append(id).append("',\r\n");
        if (storageOrgUnitID == null) {
            sql.append("Null,\r\n");
        } else {
            sql.append("'").append(storageOrgUnitID).append("',\r\n");
        }
        if (workCenterID == null) {
            sql.append("Null,\r\n");
        } else {
            sql.append("'").append(workCenterID).append("',\r\n");
        }
        if (materialID == null) {
            sql.append("Null,\r\n");
        } else {
            sql.append("'").append(materialID).append("',\r\n");
        }
        if (warehouseID == null) {
            sql.append("Null,\r\n");
        } else {
            sql.append("'").append(warehouseID).append("',\r\n");
        }
        if (sourceBillID == null) {
            sql.append("Null\r\n");
        } else {
            sql.append("'").append(sourceBillID).append("'\r\n");
        }
        sql.append(")\r\n");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
    }

    protected String insertWarehouseTempTable(Context ctx, String tempTableName) throws BOSException, EASBizException {
        if (tempTableName == null) {
            return null;
        }
        if (tempTableName.trim().length() == 0) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(tempTableName).append("(\r\n");
        sql.append("FID,\r\n");
        sql.append("FWarehouseID\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }
}

