/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.common.utils;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.industry.emm.common.utils.KmConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BOSFtpUtil {
    private KmConfig kmConfig;
    private FTPClient ftp;
    private String FTPDLSB_INFO = EASResource.getString((String)"com.kingdee.eas.mm.basedata.EMMEMBasedataResource", (String)"FTPDLSB_INFO");

    public BOSFtpUtil(KmConfig kmConfig) {
        this.kmConfig = kmConfig;
    }

    public FTPClient loginFTP(KmConfig kmConfig) {
        String ftpHost = kmConfig.getFtpHost();
        int port = kmConfig.getFtpPort();
        String userName = kmConfig.getFtpUser();
        String passWord = kmConfig.getFtpPassword();
        try {
            if (this.ftp != null && this.ftp.connected()) {
                this.ftp.login(userName, passWord);
                return this.ftp;
            }
            this.ftp = new FTPClient();
            this.ftp.setControlEncoding("GBK");
            this.ftp.setRemoteHost(ftpHost);
            this.ftp.setRemotePort(port);
            this.ftp.connect();
            this.ftp.login(userName, passWord);
            return this.ftp;
        }
        catch (Exception e) {
            throw new RuntimeException(this.FTPDLSB_INFO, e);
        }
    }

    public void upLoadFileFtp(InputStream is, String fileName) {
        try {
            String path = this.kmConfig.getFtpPath();
            FTPClient ftpClient = this.loginFTP(this.kmConfig);
            if (!this.isDirExist(path, ftpClient)) {
                this.createDir(path, ftpClient);
                ftpClient.chdir(path);
            }
            ftpClient.setType(FTPTransferType.BINARY);
            String fn = new String(fileName.getBytes());
            ftpClient.put(is, fn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteFileFtp(String fileName) {
        try {
            String path = this.kmConfig.getFtpPath();
            FTPClient ftpClient = this.loginFTP(this.kmConfig);
            ftpClient.chdir(path);
            try {
                ftpClient.delete(fileName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void downloadFileFtp(String fileName, OutputStream outputStream) {
        try {
            String path = this.kmConfig.getFtpPath();
            FTPClient ftpClient = this.loginFTP(this.kmConfig);
            ftpClient.chdir(path);
            if (fileName.startsWith("\\") || fileName.startsWith("/")) {
                fileName = fileName.substring(1);
            }
            try {
                ftpClient.setType(FTPTransferType.BINARY);
                byte[] bytes = ftpClient.get(fileName);
                outputStream.write(bytes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean createDir(String path, FTPClient ftpClient) throws Exception {
        if (this.isDirExist(path, ftpClient)) {
            return true;
        }
        if (path.indexOf("\\") != -1) {
            int ind = path.lastIndexOf("\\");
            this.createDir(path.substring(0, ind), ftpClient);
        }
        ftpClient.chdir("/");
        ftpClient.mkdir(path);
        return false;
    }

    public boolean isDirExist(String dir, FTPClient ftpClient) {
        try {
            ftpClient.chdir(dir);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void ftpQuit() {
        try {
            if (this.ftp != null) {
                this.ftp.quit();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (FTPException e) {
            e.printStackTrace();
        }
    }
}

