/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.common.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.ISQLFacade;
import com.kingdee.eas.csinterface.syncdatabase.SQLFacadeFactory;
import com.kingdee.eas.util.ResourceBase;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class TCTask {
    protected Context ctx;
    protected ConnectionInfo con;
    private String RESURL = "com.kingdee.eas.mm.basedata.EMMEMBasedataResource";
    protected static String[] url = new String[]{"jdbc:oracle:thin:@172.18.1.10:1521:orcl11", "OA", "passwordOfOA"};
    protected String pstmt1 = "select * from tcdata.CHANGET where fbillno=?";
    protected String pstmt2 = "select * from tcdata.CHANGEC where fbillno=? order by frow asc";
    protected String pstmt3 = "select fmno,fmname from tcdata.MATERIAL where fid=?";
    protected ResultSet tRs;
    protected ResultSet cRs;
    protected ResultSet mRs;
    protected HSSFWorkbook workbook = null;
    public static final String LINK = "TC_CHANGE_LINK";

    public TCTask(Context ctx) throws BOSException {
        this.ctx = ctx;
        this.con = TCTask.getConnectionInfo(ctx);
    }

    public int exec(String changeId, OutputStream out) throws BOSException, EASBizException {
        changeId = changeId.trim();
        try {
            InputStream is = this.getClass().getResourceAsStream("muban.xls");
            this.workbook = new HSSFWorkbook(is);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        this.workbook.cloneSheet(0);
        ISQLFacade isql = SQLFacadeFactory.getLocalInstance((Context)this.ctx);
        try {
            this.tRs = isql.getTargetRowset(this.con, this.pstmt1.replace("?", "'" + changeId + "'"));
            this.cRs = isql.getTargetRowset(this.con, this.pstmt2.replace("?", "'" + changeId + "'"));
            int curRow = 5;
            int rowNo = 0;
            int page = 1;
            String fid = null;
            HSSFSheet sheet = this.workbook.getSheetAt(1);
            this.workbook.setSheetName(1, ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.EMMEMBasedataResource", (String)"DYY_INFO", (Locale)this.ctx.getLocale()));
            HSSFRow row = null;
            HSSFCell cell = null;
            while (this.tRs.next()) {
                row = sheet.getRow(2);
                cell = row.getCell(14);
                cell.setCellValue(this.tRs.getString("fbillno"));
                cell = row.getCell(21);
                cell.setCellValue(this.tRs.getString("fopdate"));
                row = sheet.getRow(3);
                cell = row.getCell(2);
                cell.setCellValue(this.tRs.getString("ftitle"));
                cell = row.getCell(8);
                cell.setCellValue(this.tRs.getString("fxm"));
                cell = row.getCell(14);
                cell.setCellValue(this.tRs.getString("fpno"));
                cell = row.getCell(20);
                cell.setCellValue(this.tRs.getString("fpname"));
                row = sheet.getRow(16);
                cell = row.getCell(4);
                cell.setCellValue(this.tRs.getString("fmemo"));
                row = sheet.getRow(17);
                cell = row.getCell(22);
                cell.setCellValue(this.tRs.getString("fopid"));
                row = sheet.getRow(18);
                cell = row.getCell(4);
                cell.setCellValue(this.tRs.getString("fcsdw"));
            }
            while (this.cRs.next()) {
                rowNo = this.cRs.getInt("frow");
                if (curRow > 15) {
                    sheet = this.workbook.cloneSheet(0);
                    curRow = 5;
                    String strInfo = ResourceBase.getString((String)this.RESURL, (String)"DXY_INFO", (Locale)this.ctx.getLocale(), (Object[])new Object[]{String.valueOf(page)});
                    this.workbook.setSheetName(++page, strInfo);
                }
                this.mRs = isql.getTargetRowset(this.con, this.pstmt3.replace("?", "" + this.cRs.getLong("fmno")));
                sheet.getRow(curRow).getCell(1).setCellValue((double)rowNo);
                while (this.mRs.next()) {
                    fid = String.valueOf(this.mRs.getString("fmno"));
                    sheet.getRow(curRow).getCell(2).setCellValue(fid);
                    sheet.getRow(curRow).getCell(8).setCellValue(this.mRs.getString("fmname"));
                }
                if (this.cRs.getString("FCHGSIG") != null && this.cRs.getString("FCHGSIG").equals("/")) {
                    int i = TCTask.getAsc(fid.substring(fid.length() - 1));
                    sheet.getRow(curRow).getCell(5).setCellValue(TCTask.backChar(i - 1) + "/" + fid.substring(fid.length() - 1));
                } else {
                    sheet.getRow(curRow).getCell(5).setCellValue(fid.substring(fid.length() - 1) + "/" + fid.substring(fid.length() - 1));
                }
                if (this.cRs.getShort("FENDCARNO") == 9999) {
                    sheet.getRow(curRow).getCell(7).setCellValue(this.cRs.getString("FBEGINCARNO") + "-UP");
                } else {
                    sheet.getRow(curRow).getCell(7).setCellValue(this.cRs.getString("FBEGINCARNO") + "-" + this.cRs.getString("FENDCARNO"));
                }
                sheet.getRow(curRow).getCell(10).setCellValue(this.cRs.getString("FCHGSIG"));
                sheet.getRow(curRow).getCell(11).setCellValue(this.cRs.getString("FCHGNUM"));
                sheet.getRow(curRow).getCell(12).setCellValue(this.cRs.getString("FCHGYY"));
                String s = this.cRs.getString("FMEMO");
                int intCharacterRow = 1;
                if (s != null) {
                    s = s.trim();
                    intCharacterRow = (int)Math.ceil(s.length() / 30) + 1;
                }
                int r = this.CharacterToRow(intCharacterRow);
                sheet.getRow(curRow).getCell(14).setCellValue(this.cRs.getString("FMEMO"));
                if (r > 1) {
                    int lineNum = curRow + r - 1;
                    if (lineNum > 15) {
                        lineNum = 15;
                    }
                    sheet.addMergedRegion(new CellRangeAddress(curRow, 1, lineNum, 1));
                    sheet.addMergedRegion(new CellRangeAddress(curRow, 2, lineNum, 2));
                    sheet.addMergedRegion(new CellRangeAddress(curRow, 5, lineNum, 5));
                    sheet.addMergedRegion(new CellRangeAddress(curRow, 7, lineNum, 7));
                    sheet.addMergedRegion(new CellRangeAddress(curRow, 8, lineNum, 8));
                    sheet.addMergedRegion(new CellRangeAddress(curRow, 10, lineNum, 10));
                    sheet.addMergedRegion(new CellRangeAddress(curRow, 11, lineNum, 11));
                    sheet.addMergedRegion(new CellRangeAddress(curRow, 12, lineNum, 12));
                    sheet.addMergedRegion(new CellRangeAddress(curRow, 14, lineNum, 14));
                    curRow += r;
                    continue;
                }
                ++curRow;
            }
            this.workbook.removeSheetAt(0);
            for (int p = 1; p <= page; ++p) {
                String strInfo = ResourceBase.getString((String)this.RESURL, (String)"DXYGXY_INFO", (Locale)this.ctx.getLocale(), (Object[])new Object[]{p, page});
                this.workbook.getSheetAt(p - 1).getRow(18).getCell(20).setCellValue(strInfo);
            }
            try {
                this.workbook.write(out);
                out.close();
                return 1;
            }
            catch (IOException e) {
                e.printStackTrace();
                return 0;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static int getAsc(String str) {
        byte[] gc = str.getBytes();
        byte ascNum = gc[0];
        return ascNum;
    }

    private static char backChar(int charAscNum) {
        char c = (char)charAscNum;
        return c;
    }

    private int CharacterToRow(int intCharacter) {
        int intRow = 0;
        switch (intCharacter) {
            case 1: {
                intRow = 1;
                break;
            }
            case 2: {
                intRow = 2;
                break;
            }
            case 3: {
                intRow = 2;
                break;
            }
            case 4: {
                intRow = 3;
                break;
            }
            case 5: {
                intRow = 3;
                break;
            }
            case 6: {
                intRow = 4;
                break;
            }
            case 7: {
                intRow = 5;
                break;
            }
            case 8: {
                intRow = 5;
                break;
            }
            case 9: {
                intRow = 6;
                break;
            }
            case 10: {
                intRow = 6;
                break;
            }
            case 11: {
                intRow = 7;
                break;
            }
            case 12: {
                intRow = 8;
                break;
            }
            case 13: {
                intRow = 9;
                break;
            }
            case 14: {
                intRow = 9;
                break;
            }
            case 15: {
                intRow = 10;
                break;
            }
            case 16: {
                intRow = 10;
                break;
            }
            default: {
                intRow = 0;
            }
        }
        return intRow;
    }

    public static ConnectionInfo getConnectionInfo(Context ctx) throws BOSException {
        ConnectionInfo con;
        try {
            con = ConnectionFactory.getLocalInstance((Context)ctx).getConnectionInfo("where number = 'TC_CHANGE_LINK'");
        }
        catch (Exception e) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.EMMEMBasedataResource", (String)"HQTCXTSJKCC", (Locale)ctx.getLocale()), (Throwable)e);
        }
        return con;
    }
}

