/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.zj.SqlExcFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.industry.emm.mm.client.AbstractZXJYLQDFilterUI;
import com.kingdee.eas.industry.emm.mm.ps.client.BomSelectUI;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.WorkCenterInfo;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Logger;

public class ZXJYLQDFilterUI
extends AbstractZXJYLQDFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ZXJYLQDFilterUI.class);
    private static final long serialVersionUID = -1822194030595864985L;
    private String RESURL = "com.kingdee.eas.industry.emm.mm.basedata.EMMEMBaseResource";
    private String CP_ISNOTNULL = EASResource.getString((String)this.RESURL, (String)"CP_ISNOTNULL");
    private String XMH_ISNOTNULL = EASResource.getString((String)this.RESURL, (String)"XMH_ISNOTNULL");
    private String GZH_ISNOTNULL = EASResource.getString((String)this.RESURL, (String)"GZH_ISNOTNULL");
    private String GZZX_NAME = EASResource.getString((String)this.RESURL, (String)"GZZX_NAME");
    protected DataChangeListener f7DataChangeListener = null;
    protected PreChangeListener f7PreChangeListener = null;
    protected SelectorListener f7SelectorListener = null;

    public ZXJYLQDFilterUI() throws Exception {
        this.isReport = true;
        this.getElementsInfo();
    }

    public void clear() {
        super.getFilterManager().clearAll();
        this.prmtStorageOrgUnit.setValue((Object)SysContext.getSysContext().getCurrentStorageUnit());
        this.setDefaultValue();
    }

    public void getElementsInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement storageOrgUnitElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit);
        elements.add((FilterElement)storageOrgUnitElement);
        SingleFilterElement productElement = new SingleFilterElement("product.number", (Component)this.prmtProduct);
        productElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, this.CP_ISNOTNULL));
        elements.add((FilterElement)productElement);
        SingleFilterElement projectElement = new SingleFilterElement("project.number", (Component)this.prmtProject);
        projectElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, this.XMH_ISNOTNULL));
        elements.add((FilterElement)projectElement);
        SingleFilterElement traceElement = new SingleFilterElement("trace.number", (Component)this.prmtTraceNumber);
        traceElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, this.GZH_ISNOTNULL));
        elements.add((FilterElement)traceElement);
        SingleFilterElement workCenterElement = new SingleFilterElement("workCenter.number", (Component)this.prmtWorkCenter);
        elements.add((FilterElement)workCenterElement);
        SingleFilterElement parentWorkCenterElement = new SingleFilterElement("parentWorkCenter.number", (Component)this.prmtParentWorkCenter);
        elements.add((FilterElement)parentWorkCenterElement);
        SingleFilterElement operationElement = new SingleFilterElement("operation.number", (Component)this.prmtOperation);
        elements.add((FilterElement)operationElement);
        SingleFilterElement warehouseElement = new SingleFilterElement("warehouse.number", (Component)this.prmtWarehouse);
        elements.add((FilterElement)warehouseElement);
        SingleFilterElement materialElement = new SingleFilterElement("material.number", (Component)this.prmtMaterial);
        elements.add((FilterElement)materialElement);
        SingleFilterElement parentMaterialElement = new SingleFilterElement("parentMaterial.number", (Component)this.prmtParentMaterial);
        elements.add((FilterElement)parentMaterialElement);
        SingleFilterElement routingElement = new SingleFilterElement("routing.number", (Component)this.prmtRouting);
        elements.add((FilterElement)routingElement);
        SingleFilterElement materialAttributeElement = new SingleFilterElement("materialAttribute", (Component)this.comboMaterialAttribute);
        elements.add((FilterElement)materialAttributeElement);
        SingleFilterElement processElement = new SingleFilterElement("process", (Component)this.txtProcess);
        elements.add((FilterElement)processElement);
        this.getFilterManager().setElement((FilterElement)elements);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.addListener();
        UIHelper.registerProjectF7ForEdit((KDBizPromptBox)this.prmtStorageOrgUnit, null, (KDBizPromptBox)this.prmtProject);
        UIHelper.registerTrackNumberF7ForEdit((KDBizPromptBox)this.prmtStorageOrgUnit, null, (KDBizPromptBox)this.prmtProject, (KDBizPromptBox)this.prmtTraceNumber, (boolean)false);
    }

    protected void addListener() {
        if (this.f7DataChangeListener == null) {
            this.f7DataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        ZXJYLQDFilterUI.this.f7DataChange(e);
                    }
                    catch (Exception exc) {
                        ZXJYLQDFilterUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtStorageOrgUnit.addDataChangeListener(this.f7DataChangeListener);
        this.prmtProject.addDataChangeListener(this.f7DataChangeListener);
        this.prmtTraceNumber.addDataChangeListener(this.f7DataChangeListener);
        if (this.f7PreChangeListener == null) {
            this.f7PreChangeListener = new PreChangeListener(){

                public void preChange(PreChangeEvent e) {
                    try {
                        ZXJYLQDFilterUI.this.f7PreChange(e);
                    }
                    catch (Exception exc) {
                        ZXJYLQDFilterUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtWorkCenter.addPreChangeListener(this.f7PreChangeListener);
        this.prmtParentWorkCenter.addPreChangeListener(this.f7PreChangeListener);
        this.prmtOperation.addPreChangeListener(this.f7PreChangeListener);
        this.prmtRouting.addPreChangeListener(this.f7PreChangeListener);
        if (this.f7SelectorListener == null) {
            this.f7SelectorListener = new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    try {
                        ZXJYLQDFilterUI.this.f7WillShow(e);
                    }
                    catch (Exception exc) {
                        ZXJYLQDFilterUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtWorkCenter.addSelectorListener(this.f7SelectorListener);
        this.prmtParentWorkCenter.addSelectorListener(this.f7SelectorListener);
        this.prmtOperation.addSelectorListener(this.f7SelectorListener);
        this.prmtRouting.addSelectorListener(this.f7SelectorListener);
    }

    @Override
    protected void btnSelectBOM_actionPerformed(ActionEvent e) throws Exception {
        this.showBOMSelector(this.prmtProduct.getName());
    }

    @Override
    protected void btnSelectPMBOM_actionPerformed(ActionEvent e) throws Exception {
        this.showBOMSelector(this.prmtParentMaterial.getName());
    }

    protected void f7DataChange(DataChangeEvent e) throws BOSException, EASBizException {
        if (e.getSource() == null) {
            return;
        }
        boolean isDifferent = SCMGroupClientUtils.isDiffrent((Object)e.getNewValue(), (Object)e.getOldValue());
        if (!isDifferent) {
            return;
        }
        this.removeListener();
        StorageOrgUnitInfo souInfo = null;
        if (this.prmtStorageOrgUnit.getValue() != null && this.prmtStorageOrgUnit.getValue() instanceof StorageOrgUnitInfo) {
            souInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        }
        ProjectInfo projectInfo = null;
        if (this.prmtProject.getValue() != null && this.prmtProject.getValue() instanceof ProjectInfo) {
            projectInfo = (ProjectInfo)this.prmtProject.getValue();
        }
        TrackNumberInfo traceNumberInfo = null;
        if (this.prmtTraceNumber.getValue() != null && this.prmtTraceNumber.getValue() instanceof TrackNumberInfo) {
            traceNumberInfo = (TrackNumberInfo)this.prmtTraceNumber.getValue();
        }
        String f7Name = null;
        if (e.getSource() instanceof KDBizPromptBox) {
            f7Name = ((KDBizPromptBox)e.getSource()).getName();
        }
        StringBuffer sql = new StringBuffer();
        if ((this.prmtProject.getName().equals(f7Name) || this.prmtTraceNumber.getName().equals(f7Name) || this.prmtStorageOrgUnit.getName().equals(f7Name)) && projectInfo != null && traceNumberInfo != null && souInfo != null && projectInfo.getId() != null && traceNumberInfo.getId() != null && souInfo.getId() != null) {
            sql.setLength(0);
            sql.append("Select\r\n");
            sql.append("Top 1\r\n");
            sql.append("PPE.CFMaterialID FMaterialID\r\n");
            sql.append("From CT_BAS_ProductProjectEntry PPE\r\n");
            sql.append("Inner Join CT_BAS_ProductProject PP On PP.FID=PPE.FParentID\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And PPE.CFTrackNumberID='").append(traceNumberInfo.getId().toString()).append("'\r\n");
            sql.append("And PP.CFProjectID='").append(projectInfo.getId().toString()).append("'\r\n");
            sql.append("And PP.CFStorageOrgUnitID='").append(souInfo.getId().toString()).append("'\r\n");
            IRowSet rowSet = SqlExcFacadeFactory.getRemoteInstance().executeQuery(sql.toString());
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            if (rowSet != null && rowSet.size() > 0) {
                try {
                    MaterialInfo materialInfo;
                    rowSet.next();
                    String materialID = rowSet.getString("FMaterialID");
                    if (materialID != null && materialID.trim().length() > 0 && (materialInfo = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID), sic)) != null) {
                        this.prmtProduct.setValue((Object)materialInfo);
                    }
                }
                catch (SQLException exc) {
                    this.handUIException(exc);
                }
            }
        }
        this.addListener();
    }

    protected void f7PreChange(PreChangeEvent e) {
        if (e.getSource() == null) {
            e.setResult(0);
            return;
        }
        if (!(e.getSource() instanceof KDBizPromptBox)) {
            e.setResult(0);
            return;
        }
        this.setF7EntityViewInfo((KDBizPromptBox)e.getSource());
        e.setResult(1);
    }

    protected void f7WillShow(SelectorEvent e) {
        if (e.getSource() == null) {
            e.setCanceled(true);
            return;
        }
        if (!(e.getSource() instanceof KDBizPromptBox)) {
            e.setCanceled(true);
            return;
        }
        this.setF7EntityViewInfo((KDBizPromptBox)e.getSource());
    }

    protected void removeListener() {
        if (this.f7DataChangeListener != null) {
            this.prmtStorageOrgUnit.removeDataChangeListener(this.f7DataChangeListener);
            this.prmtProject.removeDataChangeListener(this.f7DataChangeListener);
            this.prmtTraceNumber.removeDataChangeListener(this.f7DataChangeListener);
        }
        if (this.f7PreChangeListener != null) {
            this.prmtWorkCenter.removePreChangeListener(this.f7PreChangeListener);
            this.prmtParentWorkCenter.removePreChangeListener(this.f7PreChangeListener);
            this.prmtOperation.removePreChangeListener(this.f7PreChangeListener);
            this.prmtRouting.removePreChangeListener(this.f7PreChangeListener);
        }
        if (this.f7SelectorListener != null) {
            this.prmtWorkCenter.removeSelectorListener(this.f7SelectorListener);
            this.prmtParentWorkCenter.removeSelectorListener(this.f7SelectorListener);
            this.prmtOperation.removeSelectorListener(this.f7SelectorListener);
            this.prmtRouting.removeSelectorListener(this.f7SelectorListener);
        }
    }

    protected void setF7EntityViewInfo(KDBizPromptBox sourceKDBizPromptBox) {
        String name = sourceKDBizPromptBox.getName();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer sql = new StringBuffer();
        String storageOrgUnitID = null;
        String workCenterID = null;
        String projectID = null;
        if (this.prmtStorageOrgUnit.getValue() != null && this.prmtStorageOrgUnit.getValue() instanceof StorageOrgUnitInfo && ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId() != null) {
            storageOrgUnitID = ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString();
        }
        if (this.prmtWorkCenter.getValue() != null && this.prmtWorkCenter.getValue() instanceof WorkCenterInfo && ((WorkCenterInfo)this.prmtWorkCenter.getValue()).getId() != null) {
            workCenterID = ((WorkCenterInfo)this.prmtWorkCenter.getValue()).getId().toString();
        }
        if (this.prmtProject.getValue() != null && this.prmtProject.getValue() instanceof ProjectInfo && ((ProjectInfo)this.prmtProject.getValue()).getId() != null) {
            projectID = ((ProjectInfo)this.prmtProject.getValue()).getId().toString();
        }
        if (name.equals(this.prmtWorkCenter.getName()) || name.equals(this.prmtParentWorkCenter.getName()) || name.equals(this.prmtOperation.getName()) || name.equals(this.prmtRouting.getName())) {
            filterInfo.getFilterItems().clear();
            if (storageOrgUnitID != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitID, CompareType.EQUALS));
            }
            if (name.equals(this.prmtRouting.getName())) {
                filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)60, CompareType.EQUALS));
                if (projectID != null) {
                    sql.setLength(0);
                    sql.append("Select\r\n");
                    sql.append("R.FID\r\n");
                    sql.append("From T_MM_BOM B\r\n");
                    sql.append("Inner Join T_MM_StandardRooting R On\r\n");
                    sql.append("1=1\r\n");
                    sql.append("And R.FStorageOrgUnitID=B.FStorageOrgUnitID\r\n");
                    sql.append("And R.FMaterialID=B.FMaterialID\r\n");
                    sql.append("And R.FStatus=").append(60).append("\r\n");
                    sql.append("Where\r\n");
                    sql.append("1=1\r\n");
                    sql.append("And B.FProjectID='").append(projectID).append("'\r\n");
                    sql.append("And B.FBaseStatus=").append(4).append("\r\n");
                    filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
                }
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)20, CompareType.EQUALS));
            }
            if (name.equals(this.prmtParentWorkCenter.getName())) {
                filterInfo.getFilterItems().add(new FilterItemInfo("isWorkshop", (Object)true, CompareType.EQUALS));
            }
            if (name.equals(this.prmtOperation.getName()) && workCenterID != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("workCenter.id", (Object)workCenterID, CompareType.EQUALS));
            }
            entityViewInfo.setFilter(filterInfo);
        }
        sourceKDBizPromptBox.setEntityViewInfo(entityViewInfo);
        sourceKDBizPromptBox.getQueryAgent().resetRuntimeEntityView();
    }

    protected void showBOMSelector(String f7Name) throws EASBizException, BOSException {
        String materialID;
        if (f7Name == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"mid", (Object)"");
        if (this.prmtProject.getValue() != null && this.prmtProject.getValue() instanceof ProjectInfo) {
            ProjectInfo projectInfo = (ProjectInfo)this.prmtProject.getValue();
            uiContext.put((Object)"projectID", (Object)projectInfo.getId().toString());
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BomSelectUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        Map parmContext = uiWindow.getUIObject().getUIContext();
        if (parmContext.containsKey("mid") && parmContext.get("mid") != null && parmContext.get("mid").toString().trim().length() > 0 && !(materialID = parmContext.get("mid").toString()).equals("null")) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            MaterialInfo materialInfo = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID), sic);
            if (this.prmtParentMaterial.getName().equals(f7Name)) {
                this.prmtParentMaterial.setValue((Object)materialInfo);
            } else if (this.prmtProduct.getName().equals(f7Name)) {
                this.prmtProduct.setValue((Object)materialInfo);
            }
        }
    }
}

