/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.pm.dp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.industry.emm.common.BillBaseStatusEnum;
import com.kingdee.eas.industry.emm.common.util.UITitleTranUtil;
import com.kingdee.eas.industry.emm.mm.pm.dp.DeliveryPlanFactory;
import com.kingdee.eas.industry.emm.mm.pm.dp.DeliveryPlanInfo;
import com.kingdee.eas.industry.emm.mm.pm.dp.client.AbstractDeliveryPlanEditUI;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;

public class DeliveryPlanEditUI
extends AbstractDeliveryPlanEditUI {
    private static final long serialVersionUID = 3355681973981074331L;
    ICodingRuleManager iCodingRuleManager = null;

    public DeliveryPlanEditUI() throws Exception {
        String title = UITitleTranUtil.getTranTileByXML((String)((Object)((Object)this)).getClass().getName());
        if (title != null && !"".equals(title)) {
            super.setUITitle(UITitleTranUtil.getTranTileByXML((String)((Object)((Object)this)).getClass().getName()));
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        if (this.editData.getId() != null) {
            String billID = this.editData.getId().toString();
            DeliveryPlanInfo planInfo = DeliveryPlanFactory.getRemoteInstance().getDeliveryPlanInfo((IObjectPK)new ObjectUuidPK(billID));
            DeliveryPlanFactory.getRemoteInstance().audit(planInfo);
            this.refreshCurPage();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        BillBaseStatusEnum status = (BillBaseStatusEnum)this.baseStatus.getSelectedItem();
        if (status.equals((Object)BillBaseStatusEnum.AUDITED)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0224"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnAudit_actionPerformed(e);
        if (this.editData.getId() != null) {
            String billID = this.editData.getId().toString();
            DeliveryPlanInfo planInfo = DeliveryPlanFactory.getRemoteInstance().getDeliveryPlanInfo((IObjectPK)new ObjectUuidPK(billID));
            DeliveryPlanFactory.getRemoteInstance().unAudit(planInfo);
            this.refreshCurPage();
        }
    }

    public CodingRuleInfo getNewNumberByUnit(String bizOrgUnitID) throws Exception {
        if (this.iCodingRuleManager == null) {
            this.iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        }
        return this.iCodingRuleManager.getCodingRule((IObjectValue)this.editData, bizOrgUnitID);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.editData.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            this.baseStatus.setSelectedItem((Object)BillBaseStatusEnum.TEMPORARILYSAVED);
            this.editData.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            this.prmtCreator.setValue((Object)SysContext.getSysContext().getCurrentUserInfo());
            this.editData.setCreateTime(null);
            this.kDDateCreateTime.setValue(null);
            this.editData.setLastUpdateUser(null);
            this.prmtLastUpdateUser.setValue(null);
            this.editData.setLastUpdateTime(null);
            this.kDDateLastUpdateTime.setValue(null);
            this.editData.setAuditor(null);
            this.prmtAuditor.setValue(null);
            this.editData.setAuditDate(null);
            this.pkauditDate.setValue(null);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        UIHelper.registerTrackNumberF7ForFilter(null, (KDBizPromptBox)this.prmtproject, (KDBizPromptBox)this.prmttrackNo, (boolean)false);
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        this.btnAudit.setEnabled(true);
        this.btnUnAudit.setEnabled(true);
        this.pkBizDate.setDatePattern("yyyy-MM");
        this.btnFirst.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnWorkFlowG.setVisible(false);
        this.btnCreateFrom.setVisible(false);
        this.btnCreateTo.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.btnNextPerson.setVisible(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void afterMainOrgChanged(String oldValue, String newValue) {
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)newValue);
        try {
            if (this.getOprtState().equals("ADDNEW") && isDiffrent) {
                CodingRuleInfo ruleInfo = this.getNewNumberByUnit(newValue);
                if (ruleInfo != null) {
                    String newNumber = this.iCodingRuleManager.getNumber((IObjectValue)this.editData, ruleInfo);
                    if (ruleInfo.isIsAddView()) {
                        this.txtNumber.setText(newNumber);
                    }
                    this.editData.setNumber(newNumber);
                    this.initOldData((IObjectValue)this.editData);
                    if (ruleInfo.isIsModifiable()) {
                        if ("VIEW".equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState())) {
                            this.txtNumber.setEditable(false);
                            this.txtNumber.setAccessAuthority(1);
                        } else {
                            this.txtNumber.setEditable(true);
                            this.txtNumber.setAccessAuthority(0);
                            this.txtNumber.setEnabled(true);
                            this.txtNumber.requestFocus();
                        }
                    } else {
                        this.txtNumber.setEditable(false);
                        this.txtNumber.setAccessAuthority(1);
                    }
                } else {
                    this.txtNumber.setEditable(true);
                    this.txtNumber.setAccessAuthority(0);
                    this.txtNumber.setEnabled(true);
                    this.txtNumber.requestFocus();
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    protected IObjectValue createNewData() {
        DeliveryPlanInfo objectValue = new DeliveryPlanInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setQty(1);
        objectValue.setBaseStatus(BillBaseStatusEnum.ADD);
        return objectValue;
    }

    protected IObjectValue createNewDetailData(KDTable arg0) {
        return null;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
    }

    protected void refreshCurPage() throws EASBizException, BOSException, Exception {
        if (this.editData.getId() != null) {
            ObjectUuidPK iObjectPk = new ObjectUuidPK(this.editData.getId());
            IObjectValue iObjectValue = this.getValue((IObjectPK)iObjectPk);
            this.setDataObject(iObjectValue);
            this.setOprtState("VIEW");
            this.loadFields();
            this.setSave(true);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        Object project = this.prmtproject.getValue();
        String trackNo = this.prmttrackNo.getText();
        BigDecimal qty = this.txtqty.getBigDecimalValue();
        Object bizDate = this.pkBizDate.getValue();
        Object orgUnit = this.prmtorgUnit.getValue();
        String nodeDesc = this.txtnodeDesc.getText();
        if (project == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0115"));
            this.prmtproject.requestFocus();
            SysUtil.abort();
        } else if (trackNo == null || trackNo.equals("")) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0225"));
            this.prmttrackNo.requestFocus();
            SysUtil.abort();
        } else if (qty == null || qty.compareTo(new BigDecimal(0)) <= 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0226"));
            this.txtqty.requestFocus();
            SysUtil.abort();
        } else if (bizDate == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0227"));
            this.pkBizDate.requestFocus();
            SysUtil.abort();
        } else if (orgUnit == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0023"));
            this.prmtorgUnit.requestFocus();
            SysUtil.abort();
        } else if (nodeDesc == null || nodeDesc.equals("")) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0228"));
            this.txtnodeDesc.requestFocus();
            SysUtil.abort();
        }
    }
}

