/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.restruct;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.industry.emm.mm.restruct.RestructReqBillEntryFactory;
import com.kingdee.eas.industry.emm.mm.restruct.RestructReqBillEntryInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.scm.common.app.bizprocess.processor.AbstractSCMBusinessProcessor;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;

public class RestructReqBillWBMaterialReqProcessor
extends AbstractSCMBusinessProcessor {
    private static final long serialVersionUID = 3184086179995359970L;

    public RestructReqBillWBMaterialReqProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public RestructReqBillWBMaterialReqProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public RestructReqBillWBMaterialReqProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection objCol = batchResults.getObjCollection();
        for (int n = 0; n < objCol.size(); ++n) {
            MaterialReqBillInfo info = (MaterialReqBillInfo)objCol.getObject(n);
            info = MaterialReqBillFactory.getLocalInstance((Context)this.ctx).getMaterialReqBillInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()));
            MaterialReqBillEntryCollection colls = info.getEntry();
            for (int i = 0; i < colls.size(); ++i) {
                MaterialReqBillEntryInfo entryinfo = colls.get(i);
                String sourceid = entryinfo.getSourceBillEntryId();
                if (sourceid == null) {
                    return;
                }
                Boolean flag = false;
                if (RestructReqBillEntryFactory.getLocalInstance(this.ctx).exists((IObjectPK)new ObjectUuidPK(sourceid))) {
                    flag = true;
                }
                BigDecimal amout = entryinfo.getQty();
                if (flag.booleanValue()) {
                    RestructReqBillEntryInfo _info = RestructReqBillEntryFactory.getLocalInstance(this.ctx).getRestructReqBillEntryInfo((IObjectPK)new ObjectUuidPK(sourceid));
                    BigDecimal tmpQty = _info.getRejectedqty();
                    if (!this.batchAction.equals((Object)BatchActionEnum.UNAUDIT)) {
                        _info.setRejectedqty(tmpQty.add(amout.multiply(new BigDecimal(-1))));
                        if (tmpQty.add(amout).compareTo(_info.getRejecteqty()) == 1) {
                            throw new EASBizException(new NumericExceptionSubItem("\u63d0\u793a", "\u5df2\u9000\u6599\u6570\u91cf\u4e0d\u5141\u8bb8\u5927\u4e8e\u8ba1\u5212\u9000\u6599\u6570\u91cf\uff01"));
                        }
                    } else {
                        _info.setRejectedqty(tmpQty.add(amout));
                    }
                    RestructReqBillEntryFactory.getLocalInstance(this.ctx).save((CoreBaseInfo)_info);
                    continue;
                }
                if (!ManufactureOrderStockFactory.getLocalInstance((Context)this.ctx).exists((IObjectPK)new ObjectUuidPK(sourceid))) continue;
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("parent.*"));
                sic.add(new SelectorItemInfo("parent.sourceBillType.*"));
                ManufactureOrderStockInfo stock = (ManufactureOrderStockInfo)ManufactureOrderStockFactory.getLocalInstance((Context)this.ctx).getSCMBillEntryBaseInfo((IObjectPK)new ObjectUuidPK(sourceid), sic);
                String sourcestockentryid = stock.getSourceBillEntryId();
                boolean isExist = false;
                if (sourcestockentryid != null && !"".equals(sourcestockentryid)) {
                    isExist = RestructReqBillEntryFactory.getLocalInstance(this.ctx).exists((IObjectPK)new ObjectUuidPK(sourcestockentryid));
                }
                if (!isExist) continue;
                RestructReqBillEntryInfo _info = RestructReqBillEntryFactory.getLocalInstance(this.ctx).getRestructReqBillEntryInfo((IObjectPK)new ObjectUuidPK(sourcestockentryid));
                BigDecimal tmpQty = _info.getIssuedqty();
                if (this.batchAction.equals((Object)BatchActionEnum.UNAUDIT)) {
                    _info.setIssuedqty(tmpQty.add(amout.multiply(new BigDecimal(-1))));
                } else {
                    if (tmpQty.add(amout).compareTo(_info.getIssueqty()) == 1) {
                        throw new EASBizException(new NumericExceptionSubItem("\u63d0\u793a", "\u6539\u5236\u540e\u5df2\u9886\u6599\u6570\u91cf\u4e0d\u5141\u8bb8\u5927\u4e8e\u8ba1\u5212\u9886\u6599\u6570\u91cf\uff01"));
                    }
                    _info.setIssuedqty(tmpQty.add(amout));
                }
                RestructReqBillEntryFactory.getLocalInstance(this.ctx).save((CoreBaseInfo)_info);
            }
        }
    }
}

