/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.fcs.algorithm;

import com.kingdee.eas.industry.emm.project.fcs.algorithm.method.CubicExponentialSmoothingAlgotithm;
import com.kingdee.eas.industry.emm.project.fcs.algorithm.method.DemoAlgorithm;
import com.kingdee.eas.industry.emm.project.fcs.algorithm.method.ExponentialSmoothingAlgotithm;
import com.kingdee.eas.industry.emm.project.fcs.algorithm.method.MovingAverageAlgorithm;
import com.kingdee.eas.industry.emm.project.fcs.algorithm.method.QuadraticExponentialSmoothingAlgotithm;
import com.kingdee.eas.industry.emm.project.fcs.algorithm.method.TrendMovingAverageAlgorithm;
import com.kingdee.eas.industry.emm.project.fcs.algorithm.method.WeightedMovingAverageAlgorithm;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;

public class Calculator {
    public static final String ALGORITHM_MOVING_AVG = "ALGORITHM_MOVING_AVG";
    public static final String ALGORITHM_WEIGHTED_MOVING_AVG = "ALGORITHM_WEIGHTED_MOVING_AVG";
    public static final String ALGORITHM_TREND_MOVING_AVG = "ALGORITHM_TREND_MOVING_AVG";
    public static final String ALGORITHM_EXPONENTIAL_SMOOTHING = "ALGORITHM_TREND_MOVING_AVG";
    public static final String ALGORITHM_QUADRATIC_EXPONENTIAL_SMOOTHING = "ALGORITHM_TREND_MOVING_AVG";
    public static final String ALGORITHM_CUBIC_EXPONENTIAL_SMOOTHING = "ALGORITHM_TREND_MOVING_AVG";

    public static void printArray(String description, BigDecimal[] data) {
        System.out.println(String.format("******************* %s *********************", description));
        for (int i = 0; i < data.length; ++i) {
            System.out.print(data[i]);
            if (i == data.length - 1) continue;
            System.out.print(", ");
        }
        System.out.println();
        System.out.println(String.format("*****************************************************************", description));
    }

    public static void printArray(String description, double[] data) {
        System.out.println(String.format("******************* %s *********************", description));
        for (int i = 0; i < data.length; ++i) {
            System.out.print(new BigDecimal(data[i]).setScale(2, RoundingMode.HALF_UP));
            if (i == data.length - 1) continue;
            System.out.print(", ");
        }
        System.out.println();
        System.out.println(String.format("*****************************************************************", description));
    }

    public static void main(String[] args) {
        int i;
        Calculator.testMovingAvgAlgorithm();
        Calculator.testWeightedMovingAvgAlgorithm();
        Calculator.testTrendMovingAvgAlgorithm();
        Calculator.testExponentialSmoothingAlgotithm();
        Calculator.testQuadraticExponentialSmoothingAlgotithm();
        Integer[] source = new Integer[]{253993, 289665, 341785, 384763, 428964, 470614, 530217, 620206, 688212, 746422, 809592, 791376, 772682, 806048, 860855, 996630, 1092883, 1172596, 1245356, 1326094, 1378717, 1394413, 1478573, 1534122, 1608150};
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (i = 0; i < source.length; ++i) {
            list.add(source[i]);
        }
        Calculator.printArray("DemoAlgorithm.getSecExpect", DemoAlgorithm.getSecExpect(list, 1, 0.6));
        Calculator.testCubicExponentialSmoothingAlgotithm();
        source = new Integer[]{225, 250, 263, 294, 319, 357, 363, 424, 467, 582, 750, 225, 250, 263, 294, 319, 357, 363, 424, 467, 582, 750};
        list.clear();
        for (i = 0; i < source.length; ++i) {
            list.add(source[i]);
        }
        System.out.println("******************* DemoAlgorithm.getThridExpect *********************");
        System.out.println(DemoAlgorithm.getThridExpect(list, 1, 0.3));
        System.out.println(DemoAlgorithm.getThridExpect(list, 2, 0.3));
        System.out.println("*****************************************************************");
    }

    private static void testMovingAvgAlgorithm() {
        double[] source = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        MovingAverageAlgorithm algorithm = new MovingAverageAlgorithm(source, source.length, 3);
        Calculator.printArray("MovingAverageAlgorithm", algorithm.calc());
    }

    private static void testWeightedMovingAvgAlgorithm() {
        double[] source = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        double[] factors = new double[]{0.3, 0.4, 0.3};
        WeightedMovingAverageAlgorithm algorithm = new WeightedMovingAverageAlgorithm(source, source.length, 3, factors);
        Calculator.printArray("WeightedMovingAverageAlgorithm", algorithm.calc());
    }

    private static void testTrendMovingAvgAlgorithm() {
        double[] source = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        TrendMovingAverageAlgorithm algorithm = new TrendMovingAverageAlgorithm(source, source.length, 3);
        Calculator.printArray("TrendMovingAverageAlgorithm", algorithm.calc());
    }

    private static void testExponentialSmoothingAlgotithm() {
        double[] source = new double[]{10.0, 15.0, 8.0, 20.0, 10.0, 16.0, 18.0, 20.0, 22.0, 24.0, 20.0, 26.0, 27.0, 29.0, 29.0};
        ExponentialSmoothingAlgotithm algorithm = new ExponentialSmoothingAlgotithm(source, 3, 0.5);
        Calculator.printArray("ExponentialSmoothingAlgotithm", algorithm.calc());
    }

    private static void testQuadraticExponentialSmoothingAlgotithm() {
        double[] source = new double[]{253993.0, 289665.0, 341785.0, 384763.0, 428964.0, 470614.0, 530217.0, 620206.0, 688212.0, 746422.0, 809592.0, 791376.0, 772682.0, 806048.0, 860855.0, 996630.0, 1092883.0, 1172596.0, 1245356.0, 1326094.0, 1378717.0, 1394413.0, 1478573.0, 1534122.0, 1608150.0};
        QuadraticExponentialSmoothingAlgotithm algorithm = new QuadraticExponentialSmoothingAlgotithm(source, 27, 0.6);
        Calculator.printArray("QuadraticExponentialSmoothingAlgotithm", algorithm.calc());
    }

    private static void testCubicExponentialSmoothingAlgotithm() {
        double[] source = new double[]{225.2, 249.9, 263.2, 293.6, 318.9, 356.7, 363.3, 424.2, 466.5, 582.0, 750.0, 225.2, 249.9, 263.2, 293.6, 318.9, 356.7, 363.3, 424.2, 466.5, 582.0, 750.0};
        CubicExponentialSmoothingAlgotithm algorithm = new CubicExponentialSmoothingAlgotithm(source, 24, 0.37);
        Calculator.printArray("CubicExponentialSmoothingAlgotithm", algorithm.calc());
    }

    public static BigDecimal[] runMovingAvgAlgorithm(double[] source, int forcasePeriod, int step) {
        MovingAverageAlgorithm algorithm = new MovingAverageAlgorithm(source, forcasePeriod, step);
        return algorithm.calc();
    }

    public static BigDecimal[] runWeightedMovingAvgAlgorithm(double[] source, int forcasePeriod, int step, double[] factors) {
        WeightedMovingAverageAlgorithm algorithm = new WeightedMovingAverageAlgorithm(source, forcasePeriod, step, factors);
        return algorithm.calc();
    }

    public static BigDecimal[] runTrendMovingAvgAlgorithm(double[] source, int forcasePeriod, int step) {
        TrendMovingAverageAlgorithm algorithm = new TrendMovingAverageAlgorithm(source, forcasePeriod, step);
        return algorithm.calc();
    }

    public static BigDecimal[] runExponentialSmoothingAlgotithm(double[] source, int initialStep, double alpha) {
        ExponentialSmoothingAlgotithm algorithm = new ExponentialSmoothingAlgotithm(source, initialStep, alpha);
        return algorithm.calc();
    }

    public static BigDecimal[] runQuadraticExponentialSmoothingAlgotithm(double[] source, int forcasePeriod, double alpha) {
        QuadraticExponentialSmoothingAlgotithm algorithm = new QuadraticExponentialSmoothingAlgotithm(source, forcasePeriod, alpha);
        return algorithm.calc();
    }

    public static BigDecimal[] runCubicExponentialSmoothingAlgotithm(double[] source, int forcasePeriod, double alpha) {
        CubicExponentialSmoothingAlgotithm algorithm = new CubicExponentialSmoothingAlgotithm(source, forcasePeriod, alpha);
        return algorithm.calc();
    }
}

