/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.reworkprocess.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.CommonF7KDTableListener;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.industry.emm.common.BillBaseStatusEnum;
import com.kingdee.eas.industry.emm.project.biz.basedata.PermissionCheckFacadeFactory;
import com.kingdee.eas.industry.emm.reworkprocess.ReworkBillChangeTypeEnum;
import com.kingdee.eas.industry.emm.reworkprocess.ReworkBillFactory;
import com.kingdee.eas.industry.emm.reworkprocess.ReworkBillInfo;
import com.kingdee.eas.industry.emm.reworkprocess.client.AbstractReworkBillEditUI;
import com.kingdee.eas.mm.basedata.BomEntryCollection;
import com.kingdee.eas.mm.basedata.BomEntryFactory;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.MRWorkProcesEntryCollection;
import com.kingdee.eas.mm.basedata.MRWorkProcesEntryFactory;
import com.kingdee.eas.mm.basedata.MRWorkProcesEntryInfo;
import com.kingdee.eas.mm.basedata.OperationInfo;
import com.kingdee.eas.mm.basedata.PBOMEntryCollection;
import com.kingdee.eas.mm.basedata.PBOMEntryFactory;
import com.kingdee.eas.mm.basedata.PBOMEntryInfo;
import com.kingdee.eas.mm.basedata.StandardRootingInfo;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ReworkBillEditUI
extends AbstractReworkBillEditUI {
    private static final long serialVersionUID = 1L;
    private KDWorkButton btnAddOperations;
    private KDWorkButton btnAddStocks;
    private HashMap<String, CacheData> cache = new HashMap();
    private HashSet<String> operationVisibleCols = new HashSet();
    private HashSet<String> stockVisibleCols = new HashSet();

    public ReworkBillEditUI() throws Exception {
        this.operationVisibleCols.add("manufactureOrderNumber");
        this.operationVisibleCols.add("operationID");
        this.operationVisibleCols.add("operationNo");
        this.operationVisibleCols.add("workCenter");
        this.operationVisibleCols.add("entrustType");
        this.operationVisibleCols.add("storageOrgUnit");
        this.operationVisibleCols.add("isCheckPoint");
        this.operationVisibleCols.add("isReportPoint");
        this.operationVisibleCols.add("isPickingPoint");
        this.operationVisibleCols.add("entrustSupplier");
        this.operationVisibleCols.add("TAIWEI");
        this.operationVisibleCols.add("operationAlias");
        this.stockVisibleCols.add("manufactureOrderNumber");
        this.stockVisibleCols.add("operationID");
        this.stockVisibleCols.add("operationNo");
        this.stockVisibleCols.add("material");
        this.stockVisibleCols.add("qty");
        this.stockVisibleCols.add("unitQty");
        this.stockVisibleCols.add("unit");
        this.stockVisibleCols.add("warehouse");
        this.stockVisibleCols.add("storageOrgUnit");
        this.stockVisibleCols.add("material.number");
    }

    @Override
    public void loadFields() {
        KDComboBox kdtEntrys_provideType_ComboBox;
        Component component;
        super.loadFields();
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            IRow row = this.kdtEntrys.getRow(i);
            if (row.getCell("stockID").getValue() == null) {
                this.lockTechnicsCells(row);
                continue;
            }
            if (row.getCell("technicsID").getValue() != null) continue;
            this.lockStockCells(row);
        }
        this.updateEntryPrecesion();
        try {
            this.setEntryF7Filter();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.handleException(e);
        }
        ICellEditor provideTypeEditor = this.kdtEntrys.getColumn("provideType").getEditor();
        Component component2 = component = provideTypeEditor == null ? null : provideTypeEditor.getComponent();
        KDComboBox kDComboBox = component instanceof KDComboBox ? (KDComboBox)component : (kdtEntrys_provideType_ComboBox = component == null ? null : null);
        if (kdtEntrys_provideType_ComboBox != null && kdtEntrys_provideType_ComboBox.getItemCount() >= 5) {
            kdtEntrys_provideType_ComboBox.removeItemAt(4);
        }
        ObjectValueRender kdtEntrys_storageOrgUnit_OVR = new ObjectValueRender();
        kdtEntrys_storageOrgUnit_OVR.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtEntrys.getColumn("storageOrgUnit").setRenderer((IBasicRender)kdtEntrys_storageOrgUnit_OVR);
        this.prmtAuditor.setDisplayFormat("$name$");
        this.prmtCreator.setDisplayFormat("$name$");
        this.prmtLastUpdateUser.setDisplayFormat("$name$");
        this.contCreator.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0032"));
        this.contCreateTime.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0033"));
        this.kDDateLastUpdateTime.setDatePattern("yyyy-MM-dd");
        this.kDDateCreateTime.setDatePattern("yyyy-MM-dd");
        this.contLastUpdateUser.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0034"));
        this.contLastUpdateTime.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0035"));
        this.contauditTime.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0036"));
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtstorageOrgUnit, (OrgType)this.getMainBizOrgType(), (String)this.getPermissionItem(this.getOprtState()));
    }

    private void setEntryF7Filter() throws EASBizException, BOSException {
        KDBizPromptBox prmtEntryWorkCenter;
        ICellEditor workCenterEditor;
        Component workCenterComponent;
        Component storageOrgUnitComponent;
        Component dispatchOrgUnitComponent;
        KDBizPromptBox prmtTaiwei;
        Component taiweiComponent;
        ICellEditor taiweiEditor = this.kdtEntrys.getColumn("TAIWEI").getEditor();
        Component component = taiweiComponent = taiweiEditor == null ? null : taiweiEditor.getComponent();
        KDBizPromptBox kDBizPromptBox = taiweiComponent instanceof KDBizPromptBox ? (KDBizPromptBox)taiweiComponent : (prmtTaiwei = taiweiComponent == null ? null : null);
        if (prmtTaiwei != null) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterinfo = new FilterInfo();
            filterinfo.getFilterItems().add(new FilterItemInfo("status", (Object)20, CompareType.EQUALS));
            filterinfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", new HashSet(PermissionCheckFacadeFactory.getRemoteInstance().getOrgIdPermission("startposition_view")), CompareType.INCLUDE));
            evi.setFilter(filterinfo);
            prmtTaiwei.setEntityViewInfo(evi);
        }
        ICellEditor dispatchOrgUnitEditor = this.kdtEntrys.getColumn("dispatchOrgUnit").getEditor();
        ICellEditor storageOrgUnitEditor = this.kdtEntrys.getColumn("storageOrgUnit").getEditor();
        Component component2 = dispatchOrgUnitComponent = dispatchOrgUnitEditor == null ? null : dispatchOrgUnitEditor.getComponent();
        KDBizPromptBox prmtDispatchOrgUnit = dispatchOrgUnitComponent instanceof KDBizPromptBox ? (KDBizPromptBox)dispatchOrgUnitComponent : (dispatchOrgUnitComponent == null ? null : null);
        Component component3 = storageOrgUnitComponent = storageOrgUnitEditor == null ? null : storageOrgUnitEditor.getComponent();
        KDBizPromptBox prmtStorageOrgUnit = storageOrgUnitComponent instanceof KDBizPromptBox ? (KDBizPromptBox)storageOrgUnitComponent : (storageOrgUnitComponent == null ? null : null);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterinfo = new FilterInfo();
        filterinfo.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)true, CompareType.EQUALS));
        evi.setFilter(filterinfo);
        if (prmtDispatchOrgUnit != null) {
            prmtDispatchOrgUnit.setEntityViewInfo(evi);
        }
        if (prmtStorageOrgUnit != null) {
            prmtStorageOrgUnit.setEntityViewInfo(evi);
        }
        Component component4 = workCenterComponent = (workCenterEditor = this.kdtEntrys.getColumn("workCenter").getEditor()) == null ? null : workCenterEditor.getComponent();
        KDBizPromptBox kDBizPromptBox2 = workCenterComponent instanceof KDBizPromptBox ? (KDBizPromptBox)workCenterComponent : (prmtEntryWorkCenter = workCenterComponent == null ? null : null);
        if (prmtEntryWorkCenter != null) {
            EntityViewInfo workcenterEvi = new EntityViewInfo();
            FilterInfo workCenterFilterinfo = new FilterInfo();
            workCenterFilterinfo.getFilterItems().add(new FilterItemInfo("status", (Object)20, CompareType.EQUALS));
            String cu = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            workCenterFilterinfo.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cu, CompareType.EQUALS));
            workcenterEvi.setFilter(workCenterFilterinfo);
            prmtEntryWorkCenter.setEntityViewInfo(workcenterEvi);
        }
    }

    private void updateEntryPrecesion() {
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            MeasureUnitInfo unit = (MeasureUnitInfo)this.kdtEntrys.getCell(i, "unit").getValue();
            if (unit == null) continue;
            int precesion = unit.getQtyPrecision();
            ((KDFormattedTextField)((KDTDefaultCellEditor)this.kdtEntrys.getColumn("baseQty").getEditor()).getComponent()).setPrecision(precesion);
            ((KDFormattedTextField)((KDTDefaultCellEditor)this.kdtEntrys.getColumn("qty").getEditor()).getComponent()).setPrecision(precesion);
            ((KDFormattedTextField)((KDTDefaultCellEditor)this.kdtEntrys.getColumn("lossQty").getEditor()).getComponent()).setPrecision(precesion);
            ((KDFormattedTextField)((KDTDefaultCellEditor)this.kdtEntrys.getColumn("lossBaseQty").getEditor()).getComponent()).setPrecision(precesion);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.actionAudit.setEnabled(true);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.treeMOOrders.setTree(null);
        this.baseStatus.setSelectedItem((Object)BillBaseStatusEnum.ADD);
        this.txtNumber.setEnabled(true);
        this.txtNumber.setEditable(true);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        SysContext sysCtx = SysContext.getSysContext();
        Timestamp time = new Timestamp(System.currentTimeMillis());
        this.editData.setBaseStatus(BillBaseStatusEnum.ADD);
        this.editData.setAuditor(null);
        this.editData.setAuditTime(null);
        this.editData.setLastUpdateTime(null);
        this.editData.setLastUpdateUser(null);
        this.editData.setCreator(sysCtx.getCurrentUserInfo());
        this.editData.setCreateTime(time);
        super.actionCopy_actionPerformed(e);
        this.btnAddOperations.setEnabled(true);
        this.btnAddStocks.setEnabled(true);
        this.txtNumber.setEditable(true);
        this.txtNumber.setEnabled(true);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getBaseStatus() == BillBaseStatusEnum.AUDITED) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0037"));
            return;
        }
        super.actionEdit_actionPerformed(e);
        this.btnAddOperations.setEnabled(true);
        this.btnAddStocks.setEnabled(true);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ReworkBillFactory.getRemoteInstance();
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    @Override
    protected IObjectValue createNewData() {
        ReworkBillInfo objectValue = new ReworkBillInfo();
        if (SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Storage")) != null && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Storage")).getBoolean("isBizUnit")) {
            objectValue.put("storageOrgUnit", SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Storage")));
        } else {
            try {
                OrgUnitInfo[] mainOrgs = SCMServiceFactory.getPermissionService().getAuthorizedBizOrgUnits((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), this.getMainBizOrgType(), "reworkbill_addnew");
                if (mainOrgs != null && mainOrgs.length > 0) {
                    objectValue.put("storageOrgUnit", mainOrgs[0]);
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setBaseStatus(BillBaseStatusEnum.ADD);
        return objectValue;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("operation.operation.*"));
        return sic;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReworkBillEditUI.this.kDSplitPane1.setDividerLocation(0.5);
                ReworkBillEditUI.this.kDSplitPane2.setDividerLocation(0.2);
                ReworkBillEditUI.this.kDSplitPane3.setDividerLocation(0.5);
            }
        });
        if ("ADDNEW".equals(this.getOprtState())) {
            this.baseStatus.setSelectedItem((Object)BillBaseStatusEnum.ADD);
        }
        this.prmtproject.setRequired(true);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtproject.addCommonF7KDTableListener(new CommonF7KDTableListener(){

            public void onTableStructureCreated(KDTable table) {
                for (int i = 0; i < table.getColumnCount(); ++i) {
                    table.getColumn(i).getStyleAttributes().setHided(true);
                }
                table.getColumn("name").getStyleAttributes().setHided(false);
                table.getColumn("number").getStyleAttributes().setHided(false);
                table.getColumn("baseStatus").getStyleAttributes().setHided(false);
                table.setColumnMoveable(true);
                table.moveColumn(table.getColumnIndex("beasStatus"), 0);
                table.moveColumn(table.getColumnIndex("name"), 0);
                table.moveColumn(table.getColumnIndex("number"), 0);
            }
        });
        this.prmtproject.setEntityViewInfo(view);
        this.prmtstandardRooting.setRequired(true);
        DataChangeListener l = new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                ReworkBillEditUI.this.prmtstandardRooting.setRefresh(true);
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)ReworkBillEditUI.this.prmtstorageOrgUnit.getValue();
                if (orgInfo != null) {
                    filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgInfo.getId().toString(), CompareType.EQUALS));
                }
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)60, CompareType.EQUALS));
                view.setFilter(filter);
                ReworkBillEditUI.this.prmtstandardRooting.setEntityViewInfo(view);
                ReworkBillEditUI.this.cache.clear();
            }
        };
        this.prmtstorageOrgUnit.addDataChangeListener(l);
        if (this.prmtstorageOrgUnit.getValue() != null) {
            l.dataChanged(null);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("wpseq"));
        sic.add(new SelectorItemInfo("operation.id"));
        sic.add(new SelectorItemInfo("operation.name"));
        sic.add(new SelectorItemInfo("operation.number"));
        this.prmtoperation.setSelectorCollection(sic);
        this.onTechnicsChanged();
        ActionImpl action = new ActionImpl();
        action.putValue("Name", EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0038"));
        action.putValue("SmallIcon", this.kdtEntrys_detailPanel.getAddNewLineButton().getIcon());
        this.btnAddOperations = new KDWorkButton((Action)action);
        this.btnAddStocks = new KDWorkButton((Action)action);
        this.kDContainer1.addButton((JButton)this.btnAddOperations);
        this.kDContainer2.addButton((JButton)this.btnAddStocks);
        this.kdtEntrys_detailPanel.getAddNewLineButton().setVisible(false);
        this.kdtEntrys_detailPanel.getInsertLineButton().setVisible(false);
        this.initOperationTable();
        this.initStockTable();
        this.bindTableCellEditor();
        this.bindTableCellRender();
        this.kdtEntrys.getColumn("manufactureOrder").getStyleAttributes().setHided(true);
        this.kdtEntrys.getColumn("technicsID").getStyleAttributes().setHided(true);
        this.kdtEntrys.getColumn("stockID").getStyleAttributes().setHided(true);
        this.actionUnAudit.setVisible(false);
        if ("VIEW".equals(this.getOprtState())) {
            this.btnAddOperations.setEnabled(false);
            this.btnAddStocks.setEnabled(false);
        }
        this.chkMenuItemSubmitAndAddNew.setVisible(false);
        ObjectValueRender kdtEntrys_material_OVR = new ObjectValueRender();
        kdtEntrys_material_OVR.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtEntrys.getColumn("material").setRenderer((IBasicRender)kdtEntrys_material_OVR);
        this.tblOperations.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    try {
                        ReworkBillEditUI.this.selectOperations();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.tblOperations.getHeadRow(0).getCell("storageOrgUnit").setValue((Object)EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0039"));
        this.tblStocks.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    try {
                        ReworkBillEditUI.this.selectStocks();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        if (!this.txtNumber.isEnabled()) {
            this.txtNumber.setEnabled(true);
            this.txtNumber.setEditable(false);
        }
        if (this.editData.getId() == null) {
            this.txtNumber.setEnabled(true);
            this.txtNumber.setEditable(true);
        }
        if (!this.prmtstorageOrgUnit.isEnabled()) {
            this.prmtstorageOrgUnit.setEnabled(true);
            this.prmtstorageOrgUnit.setEditable(false);
        }
        if (this.editData.getBaseStatus() != BillBaseStatusEnum.SUBMITED) {
            this.actionAudit.setEnabled(false);
        }
        this.kdtEntrys.getColumn("modifyQty").getStyleAttributes().setHided(true);
        this.kdtEntrys.getEditManager().addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                if (ReworkBillEditUI.this.kdtEntrys.getColumnIndex("baseQty") == e.getColIndex()) {
                    BigDecimal value = new BigDecimal(String.valueOf(ReworkBillEditUI.this.kdtEntrys.getValueAt(e.getRowIndex(), ReworkBillEditUI.this.kdtEntrys.getColumnIndex("baseQty"))));
                    BigDecimal value2 = value.multiply(new BigDecimal(String.valueOf(ReworkBillEditUI.this.kdtEntrys.getValueAt(e.getRowIndex(), ReworkBillEditUI.this.kdtEntrys.getColumnIndex("lossRatio")))));
                    value = value2.add(value);
                    ReworkBillEditUI.this.kdtEntrys.getCell(e.getRowIndex(), "qty").setValue((Object)value);
                    ReworkBillEditUI.this.kdtEntrys.getCell(e.getRowIndex(), "lossQty").setValue((Object)value2);
                    ReworkBillEditUI.this.kdtEntrys.getCell(e.getRowIndex(), "lossBaseQty").setValue((Object)value2);
                } else if (ReworkBillEditUI.this.kdtEntrys.getColumnIndex("lossQty") == e.getColIndex()) {
                    BigDecimal value = new BigDecimal(String.valueOf(ReworkBillEditUI.this.kdtEntrys.getValueAt(e.getRowIndex(), ReworkBillEditUI.this.kdtEntrys.getColumnIndex("baseQty"))));
                    value = value.add(new BigDecimal(String.valueOf(ReworkBillEditUI.this.kdtEntrys.getValueAt(e.getRowIndex(), ReworkBillEditUI.this.kdtEntrys.getColumnIndex("lossQty")))));
                    ReworkBillEditUI.this.kdtEntrys.getCell(e.getRowIndex(), "qty").setValue((Object)value);
                }
            }
        });
        this.txtNumber.setRequired(true);
    }

    protected void initListener() {
        super.initListener();
        DataChangeListenerImpl listener = new DataChangeListenerImpl();
        this.prmtproject.addDataChangeListener((DataChangeListener)listener);
        this.prmtstandardRooting.addDataChangeListener((DataChangeListener)listener);
        this.prmtoperation.addDataChangeListener((DataChangeListener)listener);
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntrys;
    }

    protected void bindTableCellEditor() {
    }

    protected void bindTableCellRender() {
    }

    protected void initOperationTable() {
        this.tblOperations.getStyleAttributes().setLocked(true);
        this.tblOperations.getSelectManager().setSelectMode(2);
        for (int i = 0; i < this.tblOperations.getColumnCount(); ++i) {
            if (this.operationVisibleCols.contains(this.tblOperations.getColumnKey(i))) continue;
            this.tblOperations.getColumn(i).getStyleAttributes().setHided(true);
        }
    }

    protected void initStockTable() {
        this.tblStocks.setFormatXml(this.tblOperations.getFormatXml());
        this.tblStocks.checkParsed(true);
        this.tblStocks.getStyleAttributes().setLocked(true);
        this.tblStocks.getSelectManager().setSelectMode(2);
        IColumn col = this.tblStocks.addColumn();
        col.setKey("dispatchOrgUnit");
        this.tblStocks.getHeadRow(0).getCell("dispatchOrgUnit").setValue((Object)EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0040"));
        for (int i = 0; i < this.tblStocks.getColumnCount(); ++i) {
            if (this.stockVisibleCols.contains(this.tblStocks.getColumnKey(i))) {
                this.tblStocks.getColumn(i).getStyleAttributes().setHided(false);
                continue;
            }
            this.tblStocks.getColumn(i).getStyleAttributes().setHided(true);
        }
    }

    protected void refreshTree() throws Exception {
        StandardRootingInfo rootingInfo = (StandardRootingInfo)this.prmtstandardRooting.getValue();
        ProjectInfo projectInfo = (ProjectInfo)this.prmtproject.getValue();
        StorageOrgUnitInfo orgUnitInfo = (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
        if (projectInfo == null) {
            return;
        }
        if (rootingInfo == null) {
            return;
        }
        if (orgUnitInfo == null) {
            return;
        }
        KDTreeNode rootNode = new KDTreeNode((Object)EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0041"));
        DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)rootNode);
        KDTree kDTree1 = this.treeMOOrders.getTree();
        if (kDTree1 == null) {
            kDTree1 = new KDTree((TreeModel)treeModel);
            kDTree1.addTreeSelectionListener((TreeSelectionListener)new TreeSelectionListenerImpl());
            this.treeMOOrders.setTree(kDTree1);
        } else {
            kDTree1.setModel((TreeModel)treeModel);
        }
        kDTree1.setShowCheckBox(false);
        kDTree1.setRootVisible(false);
        kDTree1.setShowsRootHandles(true);
        IManufactureOrder ctrl = ManufactureOrderFactory.getRemoteInstance();
        StringBuilder oql = new StringBuilder();
        oql.append("SELECT trackNumber.* ,number, id, bomID, routing.*,storageOrgUnit.*,project.*,material.*,qty,baseStatus,technics.operation.id,stocks.operation.id WHERE ID IN (");
        oql.append("SELECT FID FROM T_MM_ManufactureOrder MO WHERE FBaseStatus in (");
        oql.append(1).append(",");
        oql.append(2).append(",");
        oql.append(4).append(",");
        oql.append(8).append(",");
        oql.append(5);
        oql.append(")");
        oql.append(" AND FStorageOrgUnitID='").append(orgUnitInfo.getId()).append("'");
        oql.append(" AND FRoutingID='").append(rootingInfo.getId()).append("'");
        oql.append(" AND FProjectID='").append(projectInfo.getId()).append("'");
        oql.append(") ORDER BY trackNumber.number, number");
        ManufactureOrderCollection orders = ctrl.getManufactureOrderCollection(oql.toString());
        KDTreeNode unStart = new KDTreeNode((Object)EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0042"));
        KDTreeNode started = new KDTreeNode((Object)EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0043"));
        KDTreeNode finished = new KDTreeNode((Object)EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0044"));
        for (int i = 0; i < orders.size(); ++i) {
            ManufactureOrderInfo moInfo = orders.get(i);
            com.kingdee.eas.scm.common.BillBaseStatusEnum baseStatus = moInfo.getBaseStatus();
            KDTreeNode leaf = new KDTreeNode((Object)moInfo);
            leaf.setText(EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0041") + "\uff08" + moInfo.getTrackNumber() + "\uff09 - " + EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0045") + "\uff08" + moInfo.getNumber() + "\uff09");
            if (com.kingdee.eas.scm.common.BillBaseStatusEnum.COMPLETE.equals((Object)baseStatus)) {
                finished.add((MutableTreeNode)leaf);
                continue;
            }
            if (com.kingdee.eas.scm.common.BillBaseStatusEnum.RELEASED.equals((Object)baseStatus)) {
                started.add((MutableTreeNode)leaf);
                continue;
            }
            unStart.add((MutableTreeNode)leaf);
        }
        rootNode.add((MutableTreeNode)unStart);
        rootNode.add((MutableTreeNode)started);
        rootNode.add((MutableTreeNode)finished);
        if (!orders.isEmpty()) {
            kDTree1.expandOnLevel(3);
        }
    }

    protected void refreshOperationAndStockTables() throws Exception {
        TreePath[] paths = this.treeMOOrders.getTree().getSelectionModel().getSelectionPaths();
        if (paths == null) {
            return;
        }
        for (int i = 0; i < paths.length; ++i) {
            IRow row;
            int k;
            KDTreeNode tn = (KDTreeNode)paths[i].getLastPathComponent();
            if (!(tn.getUserObject() instanceof ManufactureOrderInfo)) continue;
            ManufactureOrderInfo moInfo = (ManufactureOrderInfo)tn.getUserObject();
            CacheData cData = this.cache.get(this.getCacheID(moInfo));
            for (k = 0; k < cData.moTechnics.size(); ++k) {
                row = this.tblOperations.addRow();
                ManufactureOrderTechnicsInfo motInfo = (ManufactureOrderTechnicsInfo)cData.moTechnics.get(k);
                StandardRootingInfo srInfo = motInfo.getParent().getRouting();
                if (srInfo.getMaterialRooting() != null) {
                    int j;
                    MRWorkProcesEntryCollection c = MRWorkProcesEntryFactory.getRemoteInstance().getMRWorkProcesEntryCollection("WHERE parent.ID='" + srInfo.getMaterialRooting().getId() + "'");
                    for (j = 0; j < c.size(); ++j) {
                        if (motInfo.getOperationNo() != c.get(j).getWpSeq()) continue;
                        if (c.get(j).getOperation() == null) {
                            row.setUserObject((Object)"DELETE");
                            continue;
                        }
                        if (motInfo.getOperation().getId().equals((Object)c.get(j).getOperation().getId())) {
                            row.setUserObject((Object)"SAME");
                            j = 0;
                            break;
                        }
                        j = 0;
                        break;
                    }
                    if (j == c.size()) {
                        row.setUserObject((Object)"DELETE");
                    }
                } else {
                    row.setUserObject((Object)"DELETE");
                }
                this.syncOperationRowData(row, moInfo, motInfo);
            }
            for (k = 0; k < cData.standardTechnics.size(); ++k) {
                int j;
                MRWorkProcesEntryInfo mrInfo = cData.standardTechnics.get(k);
                for (j = 0; j < cData.moTechnics.size(); ++j) {
                    ManufactureOrderTechnicsInfo motInfo = (ManufactureOrderTechnicsInfo)cData.moTechnics.get(j);
                    if (motInfo.getOperationNo() != mrInfo.getWpSeq() || mrInfo.getOperation() == null || motInfo.getOperation() == null || !motInfo.getOperation().getId().equals((Object)mrInfo.getOperation().getId())) continue;
                    j = 0;
                    break;
                }
                if (j != cData.moTechnics.size()) continue;
                IRow row2 = this.tblOperations.addRow();
                row2.setUserObject((Object)"ADD");
                this.syncOperationRowData(row2, moInfo, mrInfo);
            }
            for (k = 0; k < cData.moStocks.size(); ++k) {
                int j;
                row = this.tblStocks.addRow();
                ManufactureOrderStockInfo mosInfo = (ManufactureOrderStockInfo)cData.moStocks.get(k);
                BigDecimal bomQty = BigDecimal.ZERO;
                if (!cData.standardPStocks.isEmpty()) {
                    for (j = 0; j < cData.standardPStocks.size(); ++j) {
                        PBOMEntryInfo peInfo = cData.standardPStocks.get(j);
                        if (!mosInfo.getMaterial().getId().equals((Object)peInfo.getMaterial().getId())) continue;
                        bomQty = peInfo.getConsumeQuota();
                        if (mosInfo.getPlannedQty().equals(moInfo.getQty().multiply(bomQty))) {
                            row.setUserObject((Object)"SAME");
                        } else {
                            row.setUserObject((Object)"DIFF");
                        }
                        j = 0;
                        break;
                    }
                    if (j == cData.standardPStocks.size()) {
                        bomQty = mosInfo.getPlannedQty();
                        row.setUserObject((Object)"DELETE");
                    }
                } else {
                    while (j < cData.standardBStocks.size()) {
                        BomEntryInfo beInfo = cData.standardBStocks.get(j);
                        if (mosInfo.getMaterial().getId().equals((Object)beInfo.getMaterial().getId())) {
                            bomQty = moInfo.getQty().multiply(beInfo.getConsumeFixQty());
                            if (mosInfo.getPlannedQty().equals(bomQty)) {
                                row.setUserObject((Object)"SAME");
                            } else {
                                row.setUserObject((Object)"DIFF");
                            }
                            j = 0;
                            break;
                        }
                        ++j;
                    }
                    if (j == cData.standardBStocks.size()) {
                        bomQty = mosInfo.getPlannedQty();
                        row.setUserObject((Object)"DELETE");
                    }
                }
                this.syncStockRowData(row, moInfo, mosInfo, bomQty);
            }
            if (!cData.standardPStocks.isEmpty()) {
                for (int j = 0; j < cData.standardPStocks.size(); ++j) {
                    int k2;
                    PBOMEntryInfo peInfo = cData.standardPStocks.get(j);
                    for (k2 = 0; k2 < cData.moStocks.size(); ++k2) {
                        ManufactureOrderStockInfo mosInfo = (ManufactureOrderStockInfo)cData.moStocks.get(k2);
                        if (!mosInfo.getMaterial().getId().equals((Object)peInfo.getMaterial().getId())) continue;
                        k2 = 0;
                        break;
                    }
                    if (k2 != cData.moStocks.size()) continue;
                    IRow row3 = this.tblStocks.addRow();
                    row3.setUserObject((Object)"ADD");
                    this.syncStockRowData(row3, moInfo, peInfo);
                }
                continue;
            }
            StandardRootingInfo srInfo = ((ManufactureOrderInfo)tn.getUserObject()).getRouting();
            MRWorkProcesEntryCollection c = MRWorkProcesEntryFactory.getRemoteInstance().getMRWorkProcesEntryCollection("SELECT operation.*,wpSeq WHERE parent.ID='" + srInfo.getMaterialRooting().getId() + "'");
            for (int j = 0; j < cData.standardBStocks.size(); ++j) {
                String operationID;
                BomEntryInfo beInfo = cData.standardBStocks.get(j);
                int k3 = 0;
                String string = this.prmtoperation.getValue() != null ? (((MRWorkProcesEntryInfo)this.prmtoperation.getValue()).getOperation() != null ? ((MRWorkProcesEntryInfo)this.prmtoperation.getValue()).getOperation().getId().toString() : null) : (operationID = null);
                while (k3 < cData.moStocks.size()) {
                    ManufactureOrderStockInfo mosInfo = (ManufactureOrderStockInfo)cData.moStocks.get(k3);
                    if (mosInfo.getMaterial().getId().equals((Object)beInfo.getMaterial().getId())) {
                        k3 = 0;
                        break;
                    }
                    ++k3;
                }
                if (k3 != cData.moStocks.size() || operationID == null || c.isEmpty() || !operationID.equals(c.get(0).getOperation().getId().toString())) continue;
                IRow row4 = this.tblStocks.addRow();
                row4.setUserObject((Object)"ADD");
                this.syncStockRowData(row4, moInfo, beInfo, c.isEmpty() ? null : c.get(0));
            }
        }
    }

    protected void syncOperationRowData(IRow row, ManufactureOrderInfo moInfo, ManufactureOrderTechnicsInfo motInfo) {
        row.getCell("manufactureOrderID").setValue((Object)moInfo.getId());
        row.getCell("manufactureOrderID").setUserObject((Object)moInfo);
        row.getCell("manufactureOrderNumber").setValue((Object)moInfo.getNumber());
        row.getCell("technicsID").setUserObject((Object)motInfo);
        row.getCell("technicsID").setValue((Object)motInfo.getId());
        row.getCell("operationID").setValue((Object)motInfo.getOperation());
        row.getCell("operationNo").setValue((Object)motInfo.getOperationNo());
        row.getCell("workCenter").setValue((Object)motInfo.getWorkcenter());
        row.getCell("entrustType").setValue((Object)motInfo.getEntrustType());
        row.getCell("storageOrgUnit").setValue((Object)motInfo.getStorageOrgUnit());
        row.getCell("isCheckPoint").setValue((Object)motInfo.isIsCheckPoint());
        row.getCell("isReportPoint").setValue((Object)motInfo.isIsReportPoint());
        row.getCell("isPickingPoint").setValue((Object)motInfo.isIsPickingPoint());
        row.getCell("entrustSupplier").setValue((Object)motInfo.getEntrustSupplier());
        row.getCell("TAIWEI").setValue((Object)motInfo.getStartPosition());
        if ("DELETE".equals(row.getUserObject())) {
            row.getStyleAttributes().setFontColor(Color.BLUE);
        }
    }

    protected void syncOperationRowData(IRow row, ManufactureOrderInfo moInfo, MRWorkProcesEntryInfo mrInfo) {
        row.getCell("manufactureOrderID").setValue((Object)moInfo.getId());
        row.getCell("manufactureOrderID").setUserObject((Object)moInfo);
        row.getCell("manufactureOrderNumber").setValue((Object)moInfo.getNumber());
        row.getCell("technicsID").setUserObject((Object)mrInfo);
        row.getCell("technicsID").setValue((Object)mrInfo.getId());
        row.getCell("operationID").setValue((Object)mrInfo.getOperation());
        row.getCell("operationNo").setValue((Object)mrInfo.getWpSeq());
        row.getCell("workCenter").setValue((Object)mrInfo.getWorkCenter());
        row.getCell("entrustType").setValue((Object)mrInfo.getEntrustType());
        row.getCell("storageOrgUnit").setValue((Object)mrInfo.getCooStorageOrgUnit());
        row.getCell("isCheckPoint").setValue((Object)mrInfo.isIsCheckPoint());
        row.getCell("isReportPoint").setValue((Object)mrInfo.isIsReportPoint());
        row.getCell("isPickingPoint").setValue((Object)mrInfo.isIsPickingPoint());
        row.getCell("entrustSupplier").setValue((Object)mrInfo.getEntrustSupplier());
        if ("ADD".equals(row.getUserObject())) {
            row.getStyleAttributes().setFontColor(Color.RED);
        }
    }

    protected void syncStockRowData(IRow row, ManufactureOrderInfo moInfo, ManufactureOrderStockInfo mosInfo, BigDecimal bomQty) {
        row.getCell("manufactureOrderID").setValue((Object)moInfo.getId());
        row.getCell("manufactureOrderID").setUserObject((Object)moInfo);
        row.getCell("manufactureOrderNumber").setValue((Object)moInfo.getNumber());
        row.getCell("stockID").setUserObject((Object)mosInfo);
        row.getCell("stockID").setValue((Object)mosInfo.getId());
        row.getCell("operationID").setValue((Object)mosInfo.getOperation());
        row.getCell("operationNo").setValue((Object)mosInfo.getOperationNo());
        row.getCell("material").setValue((Object)mosInfo.getMaterial());
        row.getCell("material.number").setValue((Object)mosInfo.getMaterial().getNumber());
        row.getCell("qty").setValue((Object)mosInfo.getPlannedQty());
        row.getCell("unitQty").setValue((Object)moInfo.getQty().multiply(bomQty));
        row.getCell("unit").setValue((Object)mosInfo.getUnit());
        row.getCell("warehouse").setValue((Object)mosInfo.getWarehouse());
        row.getCell("storageOrgUnit").setValue((Object)mosInfo.getStorageOrgUnit());
        row.getCell("dispatchOrgUnit").setValue((Object)mosInfo.getDispatchOrgUnit());
        if ("DELETE".equals(row.getUserObject())) {
            row.getStyleAttributes().setFontColor(Color.BLUE);
        } else if ("DIFF".equals(row.getUserObject())) {
            row.getCell("qty").getStyleAttributes().setFontColor(Color.RED);
            row.getCell("unitQty").getStyleAttributes().setFontColor(Color.RED);
        }
    }

    protected void syncStockRowData(IRow row, ManufactureOrderInfo moInfo, PBOMEntryInfo peInfo) {
        row.getCell("manufactureOrderID").setValue((Object)moInfo.getId());
        row.getCell("manufactureOrderID").setUserObject((Object)moInfo);
        row.getCell("manufactureOrderNumber").setValue((Object)moInfo.getNumber());
        row.getCell("stockID").setUserObject((Object)peInfo);
        row.getCell("stockID").setValue((Object)peInfo.getId());
        row.getCell("operationID").setValue((Object)peInfo.getRoutingItem().getOperation());
        row.getCell("operationNo").setValue((Object)peInfo.getRoutingItem().getWpSeq());
        row.getCell("material").setValue((Object)peInfo.getMaterial());
        row.getCell("material.number").setValue((Object)peInfo.getMaterial().getNumber());
        row.getCell("qty").setValue((Object)moInfo.getQty().multiply(peInfo.getConsumeQuota()));
        row.getCell("unitQty").setValue((Object)moInfo.getQty().multiply(peInfo.getConsumeQuota()));
        row.getCell("unit").setValue((Object)peInfo.getBomItem().getUnit());
        row.getCell("storageOrgUnit").setValue((Object)peInfo.getBomItem().getSupplyOrgUnit());
        row.getStyleAttributes().setFontColor(Color.RED);
    }

    protected void syncStockRowData(IRow row, ManufactureOrderInfo moInfo, BomEntryInfo beInfo, MRWorkProcesEntryInfo firstOP) {
        row.getCell("manufactureOrderID").setValue((Object)moInfo.getId());
        row.getCell("manufactureOrderID").setUserObject((Object)moInfo);
        row.getCell("manufactureOrderNumber").setValue((Object)moInfo.getNumber());
        row.getCell("stockID").setUserObject((Object)beInfo);
        row.getCell("stockID").setValue((Object)beInfo.getId());
        row.getCell("operationID").setValue((Object)firstOP.getOperation());
        row.getCell("operationNo").setValue((Object)firstOP.getWpSeq());
        row.getCell("material").setValue((Object)beInfo.getMaterial());
        row.getCell("material.number").setValue((Object)beInfo.getMaterial().getNumber());
        row.getCell("qty").setValue((Object)moInfo.getQty().multiply(beInfo.getConsumeFixQty()));
        row.getCell("unitQty").setValue((Object)moInfo.getQty().multiply(beInfo.getConsumeFixQty()));
        row.getCell("unit").setValue((Object)beInfo.getUnit());
        row.getCell("storageOrgUnit").setValue((Object)beInfo.getSupplyOrgUnit());
        row.getStyleAttributes().setFontColor(Color.RED);
    }

    protected void selectOperations() throws Exception {
        int[] selections = KDTableUtil.getSelectedRows((KDTable)this.tblOperations);
        if (selections == null || selections.length == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0046"));
            return;
        }
        block0: for (int i = 0; i < selections.length; ++i) {
            IRow row = this.tblOperations.getRow(selections[i]);
            ReworkBillChangeTypeEnum ct = "DELETE".equals(row.getUserObject()) ? ReworkBillChangeTypeEnum.DELETE : ("ADD".equals(row.getUserObject()) ? ReworkBillChangeTypeEnum.ADD : ReworkBillChangeTypeEnum.UPDATE);
            ManufactureOrderInfo moInfo = (ManufactureOrderInfo)row.getCell("manufactureOrderID").getUserObject();
            OperationInfo opInfo = (OperationInfo)row.getCell("operationID").getValue();
            for (int j = 0; j < this.kdtEntrys.getRowCount(); ++j) {
                ManufactureOrderInfo mo = (ManufactureOrderInfo)this.kdtEntrys.getCell(j, "manufactureOrder").getValue();
                OperationInfo op = (OperationInfo)this.kdtEntrys.getCell(j, "operation").getValue();
                if (!mo.getId().equals((Object)moInfo.getId()) || !op.getId().equals((Object)opInfo.getId())) continue;
                if (this.kdtEntrys.getCell(j, "stockID").getValue() != null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0047"));
                    continue block0;
                }
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0048"));
                continue block0;
            }
            IRow addRow = this.kdtEntrys.addRow();
            addRow.getCell("manufactureOrder").setValue((Object)moInfo);
            addRow.getCell("manufactureOrderNumber").setValue((Object)moInfo.getNumber());
            addRow.getCell("changeType").setValue((Object)ct);
            addRow.getCell("operation").setValue((Object)opInfo);
            addRow.getCell("operationNo").setValue(row.getCell("operationNo").getValue());
            addRow.getCell("technicsID").setValue(row.getCell("technicsID").getValue());
            addRow.getCell("entrustType").setValue(row.getCell("entrustType").getValue());
            addRow.getCell("isCheckPoint").setValue(row.getCell("isCheckPoint").getValue());
            addRow.getCell("isReportPoint").setValue(row.getCell("isReportPoint").getValue());
            addRow.getCell("isPickingPoint").setValue(row.getCell("isPickingPoint").getValue());
            addRow.getCell("entrustSupplier").setValue(row.getCell("entrustSupplier").getValue());
            addRow.getCell("TAIWEI").setValue(row.getCell("TAIWEI").getValue());
            addRow.getCell("opertionAlias").setValue(row.getCell("operationAlias").getValue());
            Object uo = row.getCell("technicsID").getUserObject();
            if (uo instanceof ManufactureOrderTechnicsInfo) {
                ManufactureOrderTechnicsInfo motInfo = (ManufactureOrderTechnicsInfo)uo;
                addRow.getCell("baseUnit").setValue((Object)motInfo.getBaseUnit());
                addRow.getCell("workCenter").setValue((Object)motInfo.getWorkcenter());
                addRow.getCell("proInstruction").setValue((Object)motInfo.getOperationRemark());
            } else if (uo instanceof MRWorkProcesEntryInfo) {
                MRWorkProcesEntryInfo peInfo = (MRWorkProcesEntryInfo)uo;
                addRow.getCell("workCenter").setValue((Object)peInfo.getWorkCenter());
                addRow.getCell("proInstruction").setValue((Object)peInfo.getOperationRemark());
            }
            this.lockTechnicsCells(addRow);
        }
    }

    protected void lockTechnicsCells(IRow addRow) {
        HashSet<String> editableCols = new HashSet<String>();
        editableCols.add("entrustType");
        editableCols.add("workCenter");
        editableCols.add("isCheckPoint");
        editableCols.add("isReportPoint");
        editableCols.add("isPickingPoint");
        editableCols.add("entrustSupplier");
        editableCols.add("TAIWEI");
        editableCols.add("proInstruction");
        editableCols.add("opertionAlias");
        for (int j = 0; j < this.kdtEntrys.getColumnCount(); ++j) {
            if (editableCols.contains(this.kdtEntrys.getColumnKey(j))) continue;
            addRow.getCell(j).getStyleAttributes().setLocked(true);
            addRow.getCell(j).getStyleAttributes().setBackground(Color.LIGHT_GRAY);
        }
    }

    protected void selectStocks() throws Exception {
        int[] selections = KDTableUtil.getSelectedRows((KDTable)this.tblStocks);
        if (selections == null || selections.length == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0049"));
            return;
        }
        block0: for (int i = 0; i < selections.length; ++i) {
            IRow row = this.tblStocks.getRow(selections[i]);
            ReworkBillChangeTypeEnum ct = "DELETE".equals(row.getUserObject()) ? ReworkBillChangeTypeEnum.DELETE : ("ADD".equals(row.getUserObject()) ? ReworkBillChangeTypeEnum.ADD : ReworkBillChangeTypeEnum.UPDATE);
            ManufactureOrderInfo moInfo = (ManufactureOrderInfo)row.getCell("manufactureOrderID").getUserObject();
            OperationInfo opInfo = (OperationInfo)row.getCell("operationID").getValue();
            for (int j = 0; j < this.kdtEntrys.getRowCount(); ++j) {
                ManufactureOrderInfo mo = (ManufactureOrderInfo)this.kdtEntrys.getCell(j, "manufactureOrder").getValue();
                OperationInfo op = (OperationInfo)this.kdtEntrys.getCell(j, "operation").getValue();
                if (!mo.getId().equals((Object)moInfo.getId()) || !op.getId().equals((Object)opInfo.getId())) continue;
                if (this.kdtEntrys.getCell(j, "technicsID").getValue() != null) {
                    if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0050")) != 0) continue block0;
                    this.kdtEntrys.removeRow(j);
                    break;
                }
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0051"));
                continue block0;
            }
            IRow addRow = this.kdtEntrys.addRow();
            addRow.getCell("manufactureOrder").setValue((Object)moInfo);
            addRow.getCell("manufactureOrderNumber").setValue((Object)moInfo.getNumber());
            addRow.getCell("changeType").setValue((Object)ct);
            addRow.getCell("operation").setValue((Object)opInfo);
            addRow.getCell("operationNo").setValue(row.getCell("operationNo").getValue());
            addRow.getCell("stockID").setValue(row.getCell("stockID").getValue());
            MaterialInfo mInfo = (MaterialInfo)row.getCell("material").getValue();
            addRow.getCell("material").setValue((Object)mInfo);
            addRow.getCell("materialNumber").setValue((Object)(mInfo == null ? "" : mInfo.getNumber()));
            BigDecimal b0 = (BigDecimal)row.getCell("calcRequireQty").getValue();
            BigDecimal b1 = (BigDecimal)row.getCell("qty").getValue();
            addRow.getCell("baseQty").setValue((Object)b0);
            addRow.getCell("qty").setValue((Object)b0);
            addRow.getCell("modifyQty").setValue((Object)(b0 == null ? BigDecimal.ZERO : (b1 == null ? BigDecimal.ZERO : b0.subtract(b1))));
            addRow.getCell("unitQty").setValue(row.getCell("unitQty").getValue());
            addRow.getCell("unit").setValue(row.getCell("unit").getValue());
            addRow.getCell("dispatchOrgUnit").setValue(row.getCell("dispatchOrgUnit").getValue());
            addRow.getCell("storageOrgUnit").setValue(row.getCell("storageOrgUnit").getValue());
            addRow.getCell("warehouse").setValue(row.getCell("warehouse").getValue());
            addRow.getCell("isCheckPoint").setValue((Object)false);
            addRow.getCell("isReportPoint").setValue((Object)false);
            addRow.getCell("isPickingPoint").setValue((Object)false);
            addRow.getCell("isMustReq").setValue((Object)false);
            addRow.getCell("issueMode").setValue((Object)MaterialIssueModeEnum.PRODUCEISSMODE);
            Object uo = row.getCell("stockID").getUserObject();
            if (uo instanceof ManufactureOrderStockInfo) {
                ManufactureOrderStockInfo mosInfo = (ManufactureOrderStockInfo)uo;
                addRow.getCell("baseUnit").setValue((Object)mosInfo.getBaseUnit());
                addRow.getCell("workCenter").setValue((Object)mosInfo.getWorkcenter());
                addRow.getCell("location").setValue((Object)mosInfo.getLocation());
                addRow.getCell("issueMode").setValue((Object)mosInfo.getIssueMode());
                addRow.getCell("unitBaseQty").setValue((Object)mosInfo.getUnitBaseQty());
                addRow.getCell("provideType").setValue((Object)mosInfo.getProvideType());
                addRow.getCell("isMustReq").setValue((Object)mosInfo.isIsMustReq());
                addRow.getCell("plannedQty").setValue((Object)mosInfo.getPlannedQty());
                addRow.getCell("plannedBaseQty").setValue((Object)mosInfo.getPlannedBaseQty());
                addRow.getCell("flow").setValue((Object)mosInfo.getFlow());
                addRow.getCell("isOwnObject").setValue((Object)mosInfo.isIsOwnObject());
                addRow.getCell("lossRatio").setValue((Object)mosInfo.getLossRatio());
                addRow.getCell("actureLossRatio").setValue((Object)mosInfo.getActureLossRatio());
                addRow.getCell("lossQty").setValue((Object)mosInfo.getLossQty());
                addRow.getCell("actureLossQty").setValue((Object)mosInfo.getActLossQty());
                addRow.getCell("lossBaseQty").setValue((Object)mosInfo.getLossBaseQty());
                addRow.getCell("actureLossBaseQty").setValue((Object)mosInfo.getActLossBaseQty());
            } else if (uo instanceof PBOMEntryInfo) {
                PBOMEntryInfo peInfo = (PBOMEntryInfo)uo;
                addRow.getCell("baseUnit").setValue((Object)peInfo.getBomItem().getBaseUnit());
                addRow.getCell("workCenter").setValue((Object)peInfo.getRoutingItem().getWorkCenter());
                addRow.getCell("location").setValue((Object)peInfo.getBomItem().getLocation());
                addRow.getCell("issueMode").setValue((Object)MaterialIssueModeEnum.getEnum((int)peInfo.getIssueMode()));
                addRow.getCell("provideType").setValue((Object)peInfo.getBomItem().getProvideType());
                addRow.getCell("isMustReq").setValue((Object)peInfo.isIsMustReq());
                addRow.getCell("isOwnObject").setValue((Object)peInfo.isIsOwnObject());
                addRow.getCell("lossRatio").setValue((Object)peInfo.getBomItem().getScrapRatio());
                addRow.getCell("lossQty").setValue((Object)BigDecimal.ZERO);
                addRow.getCell("lossBaseQty").setValue((Object)BigDecimal.ZERO);
            } else if (uo instanceof BomEntryInfo) {
                BomEntryInfo beInfo = (BomEntryInfo)uo;
                addRow.getCell("baseUnit").setValue((Object)beInfo.getBaseUnit());
                addRow.getCell("location").setValue((Object)beInfo.getLocation());
                addRow.getCell("provideType").setValue((Object)beInfo.getProvideType());
                addRow.getCell("issueMode").setValue((Object)beInfo.getIssMode());
                addRow.getCell("lossRatio").setValue((Object)beInfo.getScrapRatio());
                addRow.getCell("lossQty").setValue((Object)BigDecimal.ZERO);
                addRow.getCell("lossBaseQty").setValue((Object)BigDecimal.ZERO);
            }
            this.lockStockCells(addRow);
        }
        this.updateEntryPrecesion();
    }

    protected void lockStockCells(IRow addRow) {
        HashSet<String> editableCols = new HashSet<String>();
        editableCols.add("issueMode");
        editableCols.add("storageOrgUnit");
        editableCols.add("provideType");
        editableCols.add("isMustReq");
        editableCols.add("flow");
        editableCols.add("dispatchOrgUnit");
        editableCols.add("isOwnObject");
        editableCols.add("baseQty");
        editableCols.add("lossQty");
        editableCols.add("lossBaseQty");
        for (int j = 0; j < this.kdtEntrys.getColumnCount(); ++j) {
            if (!editableCols.contains(this.kdtEntrys.getColumnKey(j))) {
                addRow.getCell(j).getStyleAttributes().setLocked(true);
                addRow.getCell(j).getStyleAttributes().setBackground(Color.LIGHT_GRAY);
                continue;
            }
            addRow.getCell(j).getStyleAttributes().setLocked(false);
        }
    }

    protected void onProjectChanged() throws Exception {
        this.refreshTree();
    }

    protected void onTechnicsChanged() throws Exception {
        StandardRootingInfo rootingInfo = (StandardRootingInfo)this.prmtstandardRooting.getValue();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (rootingInfo != null) {
            StringBuilder sql = new StringBuilder();
            sql.append(" select od.fid ");
            sql.append(" from t_mm_materialrwp od ");
            sql.append(" inner join t_mm_standardrooting oh on oh.fmaterialrootingid = od.fparentid ");
            sql.append(" where oh.fid = '").append(rootingInfo.getId()).append("' ");
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"xxx", CompareType.EQUALS));
        }
        view.setFilter(filter);
        this.prmtoperation.setEntityViewInfo(view);
        this.refreshTree();
    }

    protected void onOperationChanged() throws Exception {
        this.refreshTree();
    }

    protected void clearEntrys() throws Exception {
        this.tblOperations.removeRows();
        this.tblStocks.removeRows();
    }

    private String getCacheID(ManufactureOrderInfo moInfo) {
        String trackID = moInfo.getTrackNumber() == null ? "null" : moInfo.getTrackNumber().getId().toString();
        return trackID + "###" + moInfo.getNumber();
    }

    private void iteratorBomEntrys(BomEntryCollection bEntrys, BomEntryCollection entrys) throws Exception {
        StringBuilder oql = new StringBuilder();
        ProjectInfo projectInfo = (ProjectInfo)this.prmtproject.getValue();
        StorageOrgUnitInfo orgUnitInfo = (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
        for (int j = 0; j < entrys.size(); ++j) {
            if (MaterialAttributeEnum.PHANTOMPART.equals((Object)entrys.get(j).getMaterialProp())) {
                oql.setLength(0);
                oql.append("SELECT *,material.*,supplyOrgUnit.* WHERE 1=1").append(" AND Project.ID='").append(projectInfo.getId()).append("' AND StorageOrgUnit.ID='").append(orgUnitInfo.getId()).append("' AND Material.ID='").append(entrys.get(j).getMaterial().getId()).append("' BOMType=").append(40);
                this.iteratorBomEntrys(bEntrys, BomEntryFactory.getRemoteInstance().getBomEntryCollection(oql.toString()));
                continue;
            }
            bEntrys.add(entrys.get(j));
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        this.baseStatus.setSelectedItem((Object)BillBaseStatusEnum.AUDITED);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0054"));
        this.actionSave.setEnabled(false);
        this.actionSubmit.setEnabled(false);
        this.actionAudit.setEnabled(false);
    }

    protected String getPermissionItem(String status) {
        if ("ADDNEW".equals(status)) {
            return "reworkbill_addnew";
        }
        if ("EDIT".equals(status)) {
            return "reworkbill_update";
        }
        if ("VIEW".equals(status)) {
            return "reworkbill_view";
        }
        return null;
    }

    private class CacheData {
        CoreBaseCollection moTechnics;
        MRWorkProcesEntryCollection standardTechnics;
        CoreBaseCollection moStocks;
        PBOMEntryCollection standardPStocks;
        BomEntryCollection standardBStocks;

        private CacheData() {
        }

        CacheData merge() {
            return this;
        }
    }

    private class TreeSelectionListenerImpl
    implements TreeSelectionListener {
        private TreeSelectionListenerImpl() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            KDTree tree = ReworkBillEditUI.this.treeMOOrders.getTree();
            TreePath[] paths = tree.getSelectionModel().getSelectionPaths();
            try {
                ReworkBillEditUI.this.clearEntrys();
                if (paths == null) {
                    return;
                }
                String operationID = ReworkBillEditUI.this.prmtoperation.getValue() != null ? (((MRWorkProcesEntryInfo)ReworkBillEditUI.this.prmtoperation.getValue()).getOperation() != null ? ((MRWorkProcesEntryInfo)ReworkBillEditUI.this.prmtoperation.getValue()).getOperation().getId().toString() : null) : null;
                for (int i = 0; i < paths.length; ++i) {
                    KDTreeNode tn = (KDTreeNode)paths[i].getLastPathComponent();
                    if (!(tn.getUserObject() instanceof ManufactureOrderInfo)) continue;
                    ManufactureOrderInfo moInfo = (ManufactureOrderInfo)tn.getUserObject();
                    if (ReworkBillEditUI.this.cache.containsKey(ReworkBillEditUI.this.getCacheID(moInfo))) continue;
                    CacheData data = new CacheData();
                    StringBuilder oql = new StringBuilder();
                    oql.append("SELECT *,parent.number,parent.id,parent.routing.materialRooting.id,parent.routing.materialRooting.workProcess.operation,parent.routing.materialRooting.workProcess.wpSeq");
                    oql.append(",operation.*");
                    oql.append(",workcenter.*");
                    oql.append(",entrustSupplier.*");
                    oql.append(",startPosition.*");
                    oql.append(",storageOrgUnit.*");
                    oql.append(",material.*");
                    oql.append(" WHERE parent.ID='").append(moInfo.getId()).append("'");
                    if (operationID != null) {
                        oql.append(" AND operation.id = '").append(operationID).append("'");
                    }
                    data.moTechnics = ManufactureOrderTechnicsFactory.getRemoteInstance().getCollection(oql.toString());
                    oql.setLength(0);
                    StandardRootingInfo rootingInfo = (StandardRootingInfo)ReworkBillEditUI.this.prmtstandardRooting.getValue();
                    oql.append("SELECT *,operation.*,workCenter.*,entrustSupplier.*,cooStorageOrgUnit.* WHERE parent.ID in (SELECT FMaterialRootingID FROM T_MM_StandardRooting WHERE FID='").append(rootingInfo.getId()).append("')");
                    if (operationID != null) {
                        oql.append(" AND operation.id = '").append(operationID).append("'");
                    }
                    data.standardTechnics = MRWorkProcesEntryFactory.getRemoteInstance().getMRWorkProcesEntryCollection(oql.toString());
                    oql.setLength(0);
                    oql.append("SELECT *,parent.number,parent.id,material.*,unit.*,storageOrgUnit.*,directSupplyOrgID.*,warehouse.*,operation.* WHERE parent.ID='").append(moInfo.getId()).append("'");
                    if (operationID != null) {
                        oql.append(" AND operation.id = '").append(operationID).append("'");
                    }
                    data.moStocks = ManufactureOrderStockFactory.getRemoteInstance().getCollection(oql.toString());
                    oql.setLength(0);
                    oql.append("SELECT *,material.*,routingItem.*,routingItem.operation.*,bomItem.* WHERE parent.ID IN (");
                    String bomID = "'" + moInfo.getBomID() + "'";
                    if (moInfo.getBomID() == null) {
                        bomID = "(SELECT FID FROM T_MM_BOM WHERE FStorageOrgUnitID='" + moInfo.getStorageOrgUnit().getId() + "' AND FMaterialID='" + moInfo.getMaterial().getId() + "' AND FProjectID='" + moInfo.getProject().getId() + "' AND (FBomType=" + 40 + " OR FBomType=" + 80 + "))";
                    }
                    oql.append("SELECT FID FROM T_MM_PBOM WHERE FBomID=").append(bomID).append(" AND FRoutingID='").append(rootingInfo.getId());
                    oql.append("' AND FStorageOrgUnitID='").append(moInfo.getStorageOrgUnit().getId()).append("' AND FProjectID='").append(moInfo.getProject().getId()).append("'");
                    oql.append(")");
                    if (operationID != null) {
                        oql.append(" AND routingItem.operation.id = '").append(operationID).append("'");
                    }
                    data.standardPStocks = PBOMEntryFactory.getRemoteInstance().getPBOMEntryCollection(oql.toString());
                    data.standardBStocks = new BomEntryCollection();
                    if (data.standardPStocks.isEmpty()) {
                        oql.setLength(0);
                        oql.append("SELECT *,material.*,supplyOrgUnit.* WHERE parent.ID IN (").append(bomID).append(")");
                        ReworkBillEditUI.this.iteratorBomEntrys(data.standardBStocks, BomEntryFactory.getRemoteInstance().getBomEntryCollection(oql.toString()));
                    }
                    ReworkBillEditUI.this.cache.put(ReworkBillEditUI.this.getCacheID(moInfo), data.merge());
                }
                ReworkBillEditUI.this.refreshOperationAndStockTables();
            }
            catch (Exception ex) {
                ReworkBillEditUI.this.handleException(ex);
            }
        }
    }

    private class DataChangeListenerImpl
    implements DataChangeListener {
        private DataChangeListenerImpl() {
        }

        public void dataChanged(DataChangeEvent eventObj) {
            try {
                ReworkBillEditUI.this.cache.clear();
                ReworkBillEditUI.this.clearEntrys();
                if (eventObj.getSource() == ReworkBillEditUI.this.prmtproject) {
                    ReworkBillEditUI.this.onProjectChanged();
                } else if (eventObj.getSource() == ReworkBillEditUI.this.prmtstandardRooting) {
                    ReworkBillEditUI.this.prmtoperation.setValue(null);
                    ReworkBillEditUI.this.onTechnicsChanged();
                } else if (eventObj.getSource() == ReworkBillEditUI.this.prmtoperation) {
                    ReworkBillEditUI.this.onOperationChanged();
                } else {
                    MsgBox.showWarning((Component)((Object)ReworkBillEditUI.this), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0053"));
                }
            }
            catch (Exception ex) {
                ReworkBillEditUI.this.handleException(ex);
            }
        }
    }

    private class ActionImpl
    extends AbstractAction {
        private static final long serialVersionUID = 281313659556952252L;

        private ActionImpl() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (e.getSource() == ReworkBillEditUI.this.btnAddOperations) {
                    ReworkBillEditUI.this.selectOperations();
                } else if (e.getSource() == ReworkBillEditUI.this.btnAddStocks) {
                    ReworkBillEditUI.this.selectStocks();
                } else {
                    MsgBox.showWarning((Component)((Object)ReworkBillEditUI.this), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0052"));
                }
            }
            catch (Exception ex) {
                ReworkBillEditUI.this.handleException(ex);
            }
        }
    }
}

