/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.webservice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialPlan;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialProductEnum;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationCollection;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WHStateEnum;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.webservice.AbstractWSStandardBomChangeWebServiceFacadeControllerBean;
import com.kingdee.eas.industry.webservice.WSBomChangeInfo;
import com.kingdee.eas.mm.basedata.BOMTypeEnum;
import com.kingdee.eas.mm.basedata.BomChangeBillStatusEnum;
import com.kingdee.eas.mm.basedata.BomChangeFactory;
import com.kingdee.eas.mm.basedata.BomChangeInfo;
import com.kingdee.eas.mm.basedata.BomChangeNewEntryCollection;
import com.kingdee.eas.mm.basedata.BomChangeNewEntryFactory;
import com.kingdee.eas.mm.basedata.BomChangeNewEntryInfo;
import com.kingdee.eas.mm.basedata.BomEntryFactory;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.ConsumeTypeEnum;
import com.kingdee.eas.mm.basedata.DesignModeCollection;
import com.kingdee.eas.mm.basedata.DesignModeFactory;
import com.kingdee.eas.mm.basedata.DesignModeInfo;
import com.kingdee.eas.mm.basedata.IBom;
import com.kingdee.eas.mm.basedata.IBomChange;
import com.kingdee.eas.mm.basedata.IBomChangeNewEntry;
import com.kingdee.eas.mm.basedata.IBomEntry;
import com.kingdee.eas.mm.basedata.IssuePropEnum;
import com.kingdee.eas.mm.basedata.MMBasedataStatusEnum;
import com.kingdee.eas.mm.basedata.MainTenanceLevelCollection;
import com.kingdee.eas.mm.basedata.MainTenanceLevelFactory;
import com.kingdee.eas.mm.basedata.MainTenanceLevelInfo;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.MMBaseStatusEnum;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.project.ProjectCarCollection;
import com.kingdee.eas.mm.project.ProjectCarFactory;
import com.kingdee.eas.mm.project.ProjectCarInfo;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.util.IndustryUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.convert.BomChangeBillAuditFacadeFactory;
import com.kingdee.eas.zjbom.convert.process.BomConvertBaseProcess;
import com.kingdee.eas.zjbom.convert.util.BomUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class WSStandardBomChangeWebServiceFacadeControllerBean
extends AbstractWSStandardBomChangeWebServiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.webservice.WSStandardBomChangeWebServiceFacadeControllerBean");

    @Override
    protected String[] _importChangeBom(Context ctx, IObjectCollection wsChangeBom) throws BOSException, EASBizException {
        if (wsChangeBom.size() == 0 || wsChangeBom == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"QSXLHBOMCS_LESS", (Locale)ctx.getLocale()));
        }
        System.out.print("---------------webservice start import Bom-------------------");
        CoreBaseCollection coreBaseCol = new CoreBaseCollection();
        IBom idb = BomFactory.getLocalInstance((Context)ctx);
        String[] result = new String[wsChangeBom.size()];
        for (int i = 0; i < wsChangeBom.size(); ++i) {
            System.out.println(wsChangeBom.getClass() + ":" + wsChangeBom.getObject(i).toString() + ";");
            WSBomChangeInfo wsBomChange = (WSBomChangeInfo)wsChangeBom.getObject(i);
            String error = "";
            if (wsBomChange.getChangePersonNumber() == null || wsBomChange.getChangePersonNumber().equals("")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"BGSQRNUMBER_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsBomChange.getPLMBomID() + ",-1," + error;
                continue;
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)wsBomChange.getChangePersonNumber(), CompareType.EQUALS));
            if (!UserFactory.getLocalInstance((Context)ctx).exists(filter)) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"BGSHQRBCZ_NOT_EXIST", (Locale)ctx.getLocale(), (Object[])new Object[]{wsBomChange.getChangePersonNumber()});
                result[i] = wsBomChange.getPLMBomID() + ",-1," + error;
                continue;
            }
            UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfoByNumber(wsBomChange.getChangePersonNumber());
            FullOrgUnitInfo fullOrg = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(userInfo.getDefOrgUnit().getId()));
            CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            if (fullOrg.getCU() != null) {
                cu = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(fullOrg.getCU().getId()));
            }
            if (wsBomChange.getStoageOrgUnitNumber() == null || wsBomChange.getStoageOrgUnitNumber().equals("")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"KUCZZHBNWK_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsBomChange.getPLMBomID() + ",-1," + error;
                continue;
            }
            EntityViewInfo stoEv = new EntityViewInfo();
            FilterInfo stoFilter = new FilterInfo();
            stoFilter.getFilterItems().add(new FilterItemInfo("number", (Object)wsBomChange.getStoageOrgUnitNumber(), CompareType.EQUALS));
            stoEv.setFilter(stoFilter);
            StorageOrgUnitCollection storageCol = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(stoEv);
            if (storageCol == null || storageCol.size() == 0) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"KCZZBCZ_NOT_EXIST", (Locale)ctx.getLocale());
                result[i] = wsBomChange.getPLMBomID() + ",-1," + error;
                continue;
            }
            StorageOrgUnitInfo storageInfo = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(storageCol.get(0).getId()));
            if (!WSStandardBomChangeWebServiceFacadeControllerBean.hasPermission(ctx, "emm_bomchangebill_addnew", new ObjectUuidPK(storageInfo.getId()), userInfo.getId().toString())) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"BGSQRMYZZBBGXZQ_NOT", (Locale)ctx.getLocale(), (Object[])new Object[]{userInfo.getName(), storageInfo.getName()});
                result[i] = wsBomChange.getPLMBomID() + ",-1," + error;
                continue;
            }
            if (!storageInfo.isIsBizUnit()) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"KCZZBWSHTKCZZ_NOT_BIZUNIT", (Locale)ctx.getLocale(), (Object[])new Object[]{storageInfo.getName()});
                result[i] = wsBomChange.getPLMBomID() + ",-1," + error;
                continue;
            }
            if (wsBomChange.getPLMBomID() == null || wsBomChange.getPLMBomID().equals("")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"PLMSJBOMID_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsBomChange.getPLMBomID() + ",-1," + error;
                continue;
            }
            if (wsBomChange.getDesignMode() == null || wsBomChange.getDesignMode().equals("")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SJMSBNWK_DONOT", (Locale)ctx.getLocale());
                result[i] = wsBomChange.getPLMBomID() + ",-1," + error;
                continue;
            }
            if (wsBomChange.getParentMaterialNumber() == null || wsBomChange.getParentMaterialNumber().equals("")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SSLJBMBNWK_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsBomChange.getPLMBomID() + ",-1," + error;
                continue;
            }
            if (wsBomChange.getPmaterialunitname() == null || wsBomChange.getPmaterialunitname().equals("")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SSLJJLDWMCB_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsBomChange.getPLMBomID() + ",-1," + error;
                continue;
            }
            if (wsBomChange.getUnitname() == null || wsBomChange.getUnitname().equals("")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"LJJLDWMCB_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsBomChange.getPLMBomID() + ",-1," + error;
                continue;
            }
            if (wsBomChange.getMaterialnumber() == null || wsBomChange.getMaterialnumber().equals("")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"LJBMBNWK_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsBomChange.getPLMBomID() + ",-1," + error;
                continue;
            }
            if (wsBomChange.getSupplyOrgUnitnumber() == null || wsBomChange.getSupplyOrgUnitnumber().equals("")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"GHKCZZBNWK_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsBomChange.getPLMBomID() + ",-1," + error;
                continue;
            }
            if (wsBomChange.getMaterialProp() == null || wsBomChange.getMaterialProp().equals("")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"WLSXBNWK_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsBomChange.getPLMBomID() + ",-1," + error;
                continue;
            }
            if (wsBomChange.getCanSelected() == null || wsBomChange.getCanSelected().equals("")) {
                wsBomChange.setCanSelected("0");
            } else if (!wsBomChange.getCanSelected().equals("0") && !wsBomChange.getCanSelected().equals("1")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"KXJZNWLY_ONLY", (Locale)ctx.getLocale());
                result[i] = wsBomChange.getPLMBomID() + ",-1," + error;
                continue;
            }
            if (wsBomChange.getFirstCfg() == null || wsBomChange.getFirstCfg().equals("")) {
                wsBomChange.setFirstCfg("0");
            } else if (!wsBomChange.getFirstCfg().equals("0") && !wsBomChange.getFirstCfg().equals("1")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SXPZZNWLY_ONLY", (Locale)ctx.getLocale());
                result[i] = wsBomChange.getPLMBomID() + ",-1," + error;
                continue;
            }
            if (wsBomChange.getFeture() == null || wsBomChange.getFeture().equals("")) {
                wsBomChange.setFeture("0");
            } else if (!wsBomChange.getFeture().equals("0") && !wsBomChange.getFeture().equals("1")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"TZJZNWLY_ONLY", (Locale)ctx.getLocale());
                result[i] = wsBomChange.getPLMBomID() + ",-1," + error;
                continue;
            }
            if (wsBomChange.getFixSeq() != null && !wsBomChange.getFixSeq().equals("")) {
                if (!WSStandardBomChangeWebServiceFacadeControllerBean.isInteteger(wsBomChange.getFixSeq())) {
                    error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"ZHPXHGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
                    result[i] = wsBomChange.getPLMBomID() + ",-1," + error;
                    continue;
                }
            } else {
                wsBomChange.setFixSeq("0");
            }
            if (wsBomChange.getEffectiveDate() != null && !wsBomChange.getEffectiveDate().equals("")) {
                if (!WSStandardBomChangeWebServiceFacadeControllerBean.isDate(wsBomChange.getEffectiveDate())) {
                    error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"ENARQGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
                    result[i] = wsBomChange.getPLMBomID() + ",-1," + error;
                    continue;
                }
            } else {
                wsBomChange.setEffectiveDate("1999-01-01");
            }
            if (wsBomChange.getDisableDate() != null && !wsBomChange.getDisableDate().equals("")) {
                if (!WSStandardBomChangeWebServiceFacadeControllerBean.isDate(wsBomChange.getDisableDate())) {
                    error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SHXDAGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
                    result[i] = wsBomChange.getPLMBomID() + ",-1," + error;
                    continue;
                }
            } else {
                wsBomChange.setDisableDate("2099-01-01");
            }
            if (wsBomChange.getNetWeight() != null && !wsBomChange.getNetWeight().equals("")) {
                if (!WSStandardBomChangeWebServiceFacadeControllerBean.isPosNumber(wsBomChange.getNetWeight())) {
                    error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"JZHGSHBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
                    result[i] = wsBomChange.getPLMBomID() + ",-1," + error;
                    continue;
                }
            }
            if (wsBomChange.getProductQty() != null && !wsBomChange.getProductQty().equals("") && !wsBomChange.getProductQty().equals("0")) {
                if (!WSStandardBomChangeWebServiceFacadeControllerBean.isPosNumber(wsBomChange.getProductQty())) {
                    error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SHCSHLGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
                    result[i] = wsBomChange.getPLMBomID() + ",-1," + error;
                    continue;
                }
            } else {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SHCHSHLBNWK_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsBomChange.getPLMBomID() + ",-1," + error;
                continue;
            }
            if (wsBomChange.getYield() != null && !wsBomChange.getYield().equals("")) {
                if (!WSStandardBomChangeWebServiceFacadeControllerBean.isPosNumber(wsBomChange.getYield())) {
                    error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"CHPLGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
                    result[i] = wsBomChange.getPLMBomID() + ",-1," + error;
                    continue;
                }
            }
            if (wsBomChange.getConsumeFixQty() != null && !wsBomChange.getConsumeFixQty().equals("")) {
                if (!WSStandardBomChangeWebServiceFacadeControllerBean.isPosNumber(wsBomChange.getConsumeFixQty())) {
                    error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"XHDEGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
                    result[i] = wsBomChange.getPLMBomID() + ",-1," + error;
                    continue;
                }
            } else {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"XHDEBNWK_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsBomChange.getPLMBomID() + ",-1," + error;
                continue;
            }
            String designResult = this.addNewBom(ctx, wsBomChange, userInfo, cu, coreBaseCol);
            if (coreBaseCol.size() > 0) {
                int size = coreBaseCol.size();
                for (int j = 0; j < size; ++j) {
                    idb.save(coreBaseCol.get(j));
                }
            }
            result[i] = designResult;
        }
        if (result != null && result.length > 0) {
            String ss = "";
            for (int i = 0; i < result.length; ++i) {
                ss = ss + result[i];
            }
            throw new BOSException(ss);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String addNewBom(Context ctx, WSBomChangeInfo wsBomChange, UserInfo userInfo, CtrlUnitInfo cu, CoreBaseCollection coreBaseCol) throws BOSException, EASBizException {
        BomChangeNewEntryCollection bomEntryCol;
        MaterialProvideTypeEnum provideType;
        ProjectInfo projectInfo;
        TrackNumberInfo endTrack;
        TrackNumberInfo startTrack;
        WarehouseInfo deWarehouse;
        WarehouseInfo warehouse;
        MeasureUnitInfo unitInfo;
        MaterialPlanInfo maPlan;
        MaterialPlanCollection maPlanCol;
        MaterialInfo parentMaterial;
        MaterialInfo materialInfo;
        BOMTypeEnum BomType;
        DesignModeInfo designMode;
        AdminOrgUnitInfo adminInfo;
        MainTenanceLevelInfo mainTenanceLevelInfo;
        StorageOrgUnitInfo transferInfo;
        StorageOrgUnitInfo supplyInfo;
        StorageOrgUnitInfo storageInfo;
        BOSUuid pk;
        IBomChange ib;
        IBomChangeNewEntry ibe;
        BomChangeNewEntryInfo bomEntryInfo;
        BomChangeInfo bomInfo;
        block161: {
            bomInfo = new BomChangeInfo();
            bomEntryInfo = new BomChangeNewEntryInfo();
            IBomEntry iboe = BomEntryFactory.getLocalInstance((Context)ctx);
            ibe = BomChangeNewEntryFactory.getLocalInstance(ctx);
            ib = BomChangeFactory.getLocalInstance(ctx);
            IStorageOrgUnit isr = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
            IMaterial im = MaterialFactory.getLocalInstance((Context)ctx);
            IMaterialPlan imp = MaterialPlanFactory.getLocalInstance((Context)ctx);
            pk = null;
            Timestamp now = new Timestamp(System.currentTimeMillis());
            EntityViewInfo stoEv = new EntityViewInfo();
            FilterInfo stoFilter = new FilterInfo();
            stoFilter.getFilterItems().add(new FilterItemInfo("number", (Object)wsBomChange.getStoageOrgUnitNumber(), CompareType.EQUALS));
            stoEv.setFilter(stoFilter);
            StorageOrgUnitCollection storageCol = isr.getStorageOrgUnitCollection(stoEv);
            if (storageCol == null || storageCol.size() == 0) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"KCZZBCZ_NOT_EXIST", (Locale)ctx.getLocale());
            }
            storageInfo = storageCol.get(0);
            StorageOrgUnitCollection supplyCol = null;
            supplyInfo = null;
            if (wsBomChange.getSupplyOrgUnitnumber() != null && !wsBomChange.getSupplyOrgUnitnumber().equals("")) {
                EntityViewInfo supplyEv = new EntityViewInfo();
                FilterInfo supplyFilter = new FilterInfo();
                supplyFilter.getFilterItems().add(new FilterItemInfo("number", (Object)wsBomChange.getSupplyOrgUnitnumber(), CompareType.EQUALS));
                supplyEv.setFilter(supplyFilter);
                supplyCol = isr.getStorageOrgUnitCollection(supplyEv);
                if (supplyCol == null || supplyCol.size() == 0) {
                    return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"GHKCZZBCZ_NOT_EXIST", (Locale)ctx.getLocale());
                }
                supplyInfo = supplyCol.get(0);
                if (!(supplyInfo = isr.getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(supplyInfo.getId()))).isIsBizUnit()) {
                    return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"KCZZBWSHTKCZZ_NOT_BIZUNIT", (Locale)ctx.getLocale(), (Object[])new Object[]{supplyInfo.getName()});
                }
            }
            StorageOrgUnitCollection transferCol = null;
            transferInfo = null;
            if (wsBomChange.getTransferOrgUnit() != null && !wsBomChange.getTransferOrgUnit().equals("")) {
                EntityViewInfo transferEv = new EntityViewInfo();
                FilterInfo transferFilter = new FilterInfo();
                transferFilter.getFilterItems().add(new FilterItemInfo("number", (Object)wsBomChange.getTransferOrgUnit(), CompareType.EQUALS));
                transferEv.setFilter(transferFilter);
                transferCol = isr.getStorageOrgUnitCollection(transferEv);
                if (transferCol == null || transferCol.size() == 0) {
                    return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"DCKCZZBCZ_NOT_EXIST", (Locale)ctx.getLocale());
                }
                transferInfo = transferCol.get(0);
                if (!(transferInfo = isr.getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(transferInfo.getId()))).isIsBizUnit()) {
                    return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"KCZZBWSHTKCZZ_NOT_BIZUNIT", (Locale)ctx.getLocale(), (Object[])new Object[]{transferInfo.getName()});
                }
            }
            MainTenanceLevelCollection mainTenanceLevelCollection = null;
            mainTenanceLevelInfo = null;
            if (wsBomChange.getMainTenanceLevelNumber() != null && !wsBomChange.getMainTenanceLevelNumber().equals("")) {
                EntityViewInfo mainTenanceLevelViewInfo = new EntityViewInfo();
                FilterInfo mainTenanceLevelFilterInfo = new FilterInfo();
                mainTenanceLevelFilterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)wsBomChange.getMainTenanceLevelNumber(), CompareType.EQUALS));
                mainTenanceLevelViewInfo.setFilter(mainTenanceLevelFilterInfo);
                mainTenanceLevelCollection = MainTenanceLevelFactory.getLocalInstance((Context)ctx).getMainTenanceLevelCollection(mainTenanceLevelViewInfo);
                if (mainTenanceLevelCollection == null || mainTenanceLevelCollection.size() == 0) {
                    return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"MainTenanceLevelNumber_IsNotExists", (Locale)ctx.getLocale(), (Object[])new String[]{wsBomChange.getMainTenanceLevelNumber()});
                }
                mainTenanceLevelInfo = mainTenanceLevelCollection.get(0);
            }
            List oldSelectedOrgs = OrgRangeFactory.getLocalInstance((Context)ctx).getOrgIdByUserAndType((IObjectPK)new ObjectUuidPK(userInfo.getId().toString()), OrgRangeType.ADMIN_ORG_TYPE);
            adminInfo = null;
            AdminOrgUnitCollection depCol = null;
            if (wsBomChange.getDepartmentnumber() != null && !wsBomChange.getDepartmentnumber().equals("")) {
                EntityViewInfo depEnv = new EntityViewInfo();
                FilterInfo depFilter = new FilterInfo();
                depFilter.getFilterItems().add(new FilterItemInfo("number", (Object)wsBomChange.getDepartmentnumber(), CompareType.EQUALS));
                depEnv.setFilter(depFilter);
                depCol = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(depEnv);
                if (depCol == null || depCol.size() == 0) {
                    return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SQBMZZBCZ_NOT_EXIST", (Locale)ctx.getLocale());
                }
                adminInfo = depCol.get(0);
                if (!oldSelectedOrgs.contains(adminInfo.getId().toString())) {
                    return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"XZZZBZDQBGRGLFWN_NOT_IN", (Locale)ctx.getLocale(), (Object[])new Object[]{adminInfo.getName()});
                }
                adminInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminInfo.getId()));
            }
            designMode = null;
            if (wsBomChange.getDesignMode() != null && !wsBomChange.getDesignMode().equals("")) {
                DesignModeCollection designModeCol = DesignModeFactory.getLocalInstance((Context)ctx).getDesignModeCollection("select id where number='" + wsBomChange.getDesignMode() + "'");
                if (designModeCol.size() <= 0) return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SJMOSHBMEAS_NOT_EXIST", (Locale)ctx.getLocale());
                designMode = DesignModeFactory.getLocalInstance((Context)ctx).getDesignModeInfo((IObjectPK)new ObjectUuidPK(designModeCol.get(0).getId()));
                if (!designMode.getStatus().equals((Object)MMBaseStatusEnum.ENABLE)) {
                    return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SHJMSHWQY_NOT_ACTIVE", (Locale)ctx.getLocale(), (Object[])new Object[]{designMode.getName()});
                }
            }
            BomType = designMode.getBomType();
            if (designMode.isProject() && (wsBomChange.getProjectnumber() == null || wsBomChange.getProjectnumber().equals(""))) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"XMHINSTRATEGY_MUST", (Locale)ctx.getLocale());
            }
            if (designMode.isTrackNumber()) {
                if (wsBomChange.getBeginTracknumber() == null || wsBomChange.getBeginTracknumber().equals("")) {
                    return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"KSGZINSTRATEGY_MUST", (Locale)ctx.getLocale());
                }
                if (wsBomChange.getEndTracknumber() == null || wsBomChange.getBeginTracknumber().equals("")) {
                    return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"JSGZINSTRATEGY_MUST", (Locale)ctx.getLocale());
                }
            }
            EntityViewInfo maEv = new EntityViewInfo();
            FilterInfo maFilter = new FilterInfo();
            maFilter.getFilterItems().add(new FilterItemInfo("number", (Object)wsBomChange.getMaterialnumber(), CompareType.EQUALS));
            maEv.setFilter(maFilter);
            MaterialCollection maCol = im.getMaterialCollection(maEv);
            if (maCol == null || maCol.size() == 0) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"WLBMBCZ_NOT_EXIST", (Locale)ctx.getLocale());
            }
            materialInfo = maCol.get(0);
            if (!(materialInfo = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()))).getStatus().equals((Object)UsedStatusEnum.APPROVED)) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"WLWHZH_NOT_APPROVED", (Locale)ctx.getLocale(), (Object[])new Object[]{materialInfo.getNumber()});
            }
            EntityViewInfo parentMaEv = new EntityViewInfo();
            FilterInfo parentMaFilter = new FilterInfo();
            parentMaFilter.getFilterItems().add(new FilterItemInfo("number", (Object)wsBomChange.getParentMaterialNumber(), CompareType.EQUALS));
            parentMaEv.setFilter(parentMaFilter);
            MaterialCollection parentMaCol = im.getMaterialCollection(parentMaEv);
            if (parentMaCol == null || parentMaCol.size() == 0) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SSLJBMBCZ_NOT_EXIST", (Locale)ctx.getLocale());
            }
            parentMaterial = parentMaCol.get(0);
            if (!(parentMaterial = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(parentMaterial.getId()))).getStatus().equals((Object)UsedStatusEnum.APPROVED)) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"WLWHZH_NOT_APPROVED", (Locale)ctx.getLocale(), (Object[])new Object[]{parentMaterial.getNumber()});
            }
            EntityViewInfo maPlanEnv = new EntityViewInfo();
            FilterInfo maPlanFilter = new FilterInfo();
            maPlanFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
            maPlanFilter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)supplyInfo.getId().toString(), CompareType.EQUALS));
            maPlanEnv.setFilter(maPlanFilter);
            maPlanCol = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(maPlanEnv);
            maPlan = null;
            if (maPlanCol != null && maPlanCol.size() > 0) {
                maPlan = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanInfo((IObjectPK)new ObjectUuidPK(maPlanCol.get(0).getId()));
            }
            EntityViewInfo paMaPlanEnv = new EntityViewInfo();
            FilterInfo paMaPlanFilter = new FilterInfo();
            paMaPlanFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)parentMaterial.getId().toString(), CompareType.EQUALS));
            paMaPlanFilter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storageInfo.getId().toString(), CompareType.EQUALS));
            paMaPlanEnv.setFilter(paMaPlanFilter);
            MaterialPlanCollection paMaPlanCol = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(paMaPlanEnv);
            MaterialPlanInfo paMaPlan = null;
            if (paMaPlanCol != null && paMaPlanCol.size() > 0) {
                paMaPlan = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanInfo((IObjectPK)new ObjectUuidPK(paMaPlanCol.get(0).getId()));
                if (designMode.getNumber().equals("M03") && !paMaPlan.isIsConfigable()) {
                    return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SJMSWMFXWLBXKP_NOT_CONFIG", (Locale)ctx.getLocale());
                }
            }
            if (maPlanCol != null && maPlanCol.size() > 0 && paMaPlanCol != null && paMaPlanCol.size() > 0 && designMode.getNumber().equals("M02") && (maPlan.isIsConfigable() || paMaPlan.isIsConfigable())) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SJMSWMZFWLJBKP_NOT_CONFIG", (Locale)ctx.getLocale());
            }
            EntityViewInfo paMaStoEnv = new EntityViewInfo();
            FilterInfo paMaStoFilter = new FilterInfo();
            paMaStoFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)parentMaterial.getId().toString(), CompareType.EQUALS));
            paMaStoFilter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storageInfo.getId().toString(), CompareType.EQUALS));
            paMaStoEnv.setFilter(paMaStoFilter);
            MaterialInventoryCollection paMaStoCol = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(paMaStoEnv);
            if (paMaStoCol == null || paMaStoCol.size() == 0) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"WLZMYHZHZHTDKC_NOT", (Locale)ctx.getLocale(), (Object[])new Object[]{parentMaterial.getNumber(), storageInfo.getName()});
            }
            EntityViewInfo maStoEnv = new EntityViewInfo();
            FilterInfo maStoFilter = new FilterInfo();
            maStoFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
            maStoFilter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)supplyInfo.getId().toString(), CompareType.EQUALS));
            maStoEnv.setFilter(maStoFilter);
            MaterialInventoryCollection maStoCol = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(maStoEnv);
            if (maStoCol == null || maStoCol.size() == 0) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"WLZMYHZHZHTDKC_NOT", (Locale)ctx.getLocale(), (Object[])new Object[]{materialInfo.getNumber(), supplyInfo.getName()});
            }
            EntityViewInfo paUniEv = new EntityViewInfo();
            FilterInfo paUniFilter = new FilterInfo();
            paUniFilter.getFilterItems().add(new FilterItemInfo("name", (Object)wsBomChange.getPmaterialunitname(), CompareType.EQUALS));
            paUniEv.setFilter(paUniFilter);
            MeasureUnitCollection paUniCol = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(paUniEv);
            if (paUniCol == null || paUniCol.size() == 0) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SSLJJLDWBCZ_NOT_EXIST", (Locale)ctx.getLocale());
            }
            MeasureUnitInfo paUnitInfo = paUniCol.get(0);
            paUnitInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(paUnitInfo.getId()));
            if (paUnitInfo.isIsDisabled()) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"JLDWYJY_IS_DISABLED", (Locale)ctx.getLocale(), (Object[])new Object[]{paUnitInfo.getName()});
            }
            IMultiMeasureUnit immu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
            MultiMeasureUnitInfo parentMu = new MultiMeasureUnitInfo();
            parentMu = immu.getMultiUnit(parentMaterial.getId().toString(), paUnitInfo.getId().toString());
            if (parentMu == null) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"JLDWBSWLDYDDJLDW_NOT", (Locale)ctx.getLocale(), (Object[])new Object[]{paUnitInfo.getName(), parentMaterial.getNumber()});
            }
            EntityViewInfo uniEv = new EntityViewInfo();
            FilterInfo uniFilter = new FilterInfo();
            uniFilter.getFilterItems().add(new FilterItemInfo("name", (Object)wsBomChange.getUnitname(), CompareType.EQUALS));
            uniEv.setFilter(uniFilter);
            MeasureUnitCollection meaCol = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(uniEv);
            if (meaCol == null || meaCol.size() == 0) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"LJJLDWBCZ_NOT_EXIST", (Locale)ctx.getLocale());
            }
            unitInfo = meaCol.get(0);
            unitInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(unitInfo.getId()));
            if (unitInfo.isIsDisabled()) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"JLDWYJY_IS_DISABLED", (Locale)ctx.getLocale(), (Object[])new Object[]{unitInfo.getName()});
            }
            MultiMeasureUnitInfo maMu = new MultiMeasureUnitInfo();
            maMu = immu.getMultiUnit(materialInfo.getId().toString(), unitInfo.getId().toString());
            if (maMu == null) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"JLDWBSWLDYDDJLDW_NOT", (Locale)ctx.getLocale(), (Object[])new Object[]{unitInfo.getName(), materialInfo.getNumber()});
            }
            warehouse = null;
            if (wsBomChange.getTransferWarehouse() != null && !wsBomChange.getTransferWarehouse().equals("")) {
                EntityViewInfo wareEv = new EntityViewInfo();
                FilterInfo wareFilter = new FilterInfo();
                wareFilter.getFilterItems().add(new FilterItemInfo("number", (Object)wsBomChange.getTransferWarehouse(), CompareType.EQUALS));
                wareEv.setFilter(wareFilter);
                WarehouseCollection wareCol = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseCollection(wareEv);
                if (wareCol == null || wareCol.size() == 0) {
                    return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"DCCKBCZ_NOT_EXIST", (Locale)ctx.getLocale());
                }
                warehouse = wareCol.get(0);
                warehouse = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseInfo((IObjectPK)new ObjectUuidPK(warehouse.getId()));
                if (!warehouse.getWhState().equals((Object)WHStateEnum.ACTIVE)) {
                    return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"DCCKWQY_NOT_ACTIVE", (Locale)ctx.getLocale(), (Object[])new Object[]{warehouse.getNumber()});
                }
            }
            deWarehouse = null;
            if (wsBomChange.getDefaultWarehousenumber() != null && !wsBomChange.getDefaultWarehousenumber().equals("")) {
                EntityViewInfo deWareEv = new EntityViewInfo();
                FilterInfo deWareFilter = new FilterInfo();
                deWareFilter.getFilterItems().add(new FilterItemInfo("number", (Object)wsBomChange.getDefaultWarehousenumber(), CompareType.EQUALS));
                deWareEv.setFilter(deWareFilter);
                WarehouseCollection deWareCol = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseCollection(deWareEv);
                if (deWareCol == null || deWareCol.size() == 0) {
                    return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"LLCKBCZ_NOT_EXIST", (Locale)ctx.getLocale());
                }
                deWarehouse = deWareCol.get(0);
                deWarehouse = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseInfo((IObjectPK)new ObjectUuidPK(deWarehouse.getId()));
                if (!deWarehouse.getWhState().equals((Object)WHStateEnum.ACTIVE)) {
                    return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"LLCKWQY_NOT_ACTIVE", (Locale)ctx.getLocale(), (Object[])new Object[]{deWarehouse.getNumber()});
                }
            }
            startTrack = null;
            endTrack = null;
            if (wsBomChange.getBeginTracknumber() != null && !wsBomChange.getBeginTracknumber().equals("")) {
                TrackNumberCollection startTrackNumberCol = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberCollection("select id where number='" + wsBomChange.getBeginTracknumber() + "'");
                if (startTrackNumberCol == null || startTrackNumberCol.size() <= 0) return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"KSGZHZEASZBCZ_NOT_EXIST", (Locale)ctx.getLocale());
                startTrack = startTrackNumberCol.get(0);
                startTrack = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberInfo((IObjectPK)new ObjectUuidPK(startTrack.getId()));
                if (startTrack.getStatus().equals((Object)MMBasedataStatusEnum.CLOSED)) {
                    return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"KSGZHZEASYGB_IS_CLOSE", (Locale)ctx.getLocale(), (Object[])new Object[]{startTrack.getNumber()});
                }
            }
            if (wsBomChange.getEndTracknumber() != null && !wsBomChange.getEndTracknumber().equals("")) {
                TrackNumberCollection endTrackNumberCol = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberCollection("select id where number='" + wsBomChange.getEndTracknumber() + "'");
                if (endTrackNumberCol == null || endTrackNumberCol.size() <= 0) return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"JSHGZHZEASXT_NOT_EXIST", (Locale)ctx.getLocale());
                endTrack = endTrackNumberCol.get(0);
                endTrack = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberInfo((IObjectPK)new ObjectUuidPK(endTrack.getId()));
                if (endTrack.getStatus().equals((Object)MMBasedataStatusEnum.CLOSED)) {
                    return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"JSHGZHZEASYGB_IS_CLOSE", (Locale)ctx.getLocale(), (Object[])new Object[]{endTrack.getNumber()});
                }
            }
            projectInfo = null;
            if (wsBomChange.getProjectnumber() != null && !wsBomChange.getProjectnumber().equals("")) {
                ProjectCarInfo entryInfo;
                int index;
                int collsSize;
                ProjectCarCollection ptColls;
                block160: {
                    ProjectCollection projectCol = ProjectFactory.getLocalInstance((Context)ctx).getProjectCollection("select id where number='" + wsBomChange.getProjectnumber() + "'");
                    if (projectCol == null || projectCol.size() <= 0) return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"XMHZEASZBCZ_NOT_EXIST", (Locale)ctx.getLocale());
                    projectInfo = projectCol.get(0);
                    projectInfo = ProjectFactory.getLocalInstance((Context)ctx).getProjectInfo((IObjectPK)new ObjectUuidPK(projectInfo.getId()));
                    if (!projectInfo.getBaseStatus().equals((Object)MMBaseStatusEnum.AUDIT)) {
                        return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"XMHZEASZWHZ_NOT_APPROVED", (Locale)ctx.getLocale(), (Object[])new Object[]{projectInfo.getNumber()});
                    }
                    if (startTrack != null && !IndustryUtils.isEmptyObjectCollection((IObjectCollection)(ptColls = projectInfo.getCarNumberRange()))) {
                        collsSize = ptColls.size();
                        for (index = 0; index < collsSize; ++index) {
                            entryInfo = ptColls.get(index);
                            if (entryInfo == null || !(entryInfo = ProjectCarFactory.getLocalInstance((Context)ctx).getProjectCarInfo((IObjectPK)new ObjectUuidPK(entryInfo.getId()))).getTrackNumber().getId().equals((Object)startTrack.getId())) {
                                continue;
                            }
                            break block160;
                        }
                        return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"XMHYKSBEGGZH_NOT_CORRECT", (Locale)ctx.getLocale());
                    }
                }
                if (endTrack != null && !IndustryUtils.isEmptyObjectCollection((IObjectCollection)(ptColls = projectInfo.getCarNumberRange()))) {
                    collsSize = ptColls.size();
                    for (index = 0; index < collsSize; ++index) {
                        entryInfo = ptColls.get(index);
                        if (entryInfo == null || !(entryInfo = ProjectCarFactory.getLocalInstance((Context)ctx).getProjectCarInfo((IObjectPK)new ObjectUuidPK(entryInfo.getId()))).getTrackNumber().getId().equals((Object)endTrack.getId())) {
                            continue;
                        }
                        break block161;
                    }
                    return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"XMHYJSENDGZH_NOT_CORRECT", (Locale)ctx.getLocale());
                }
            }
        }
        Boolean isStock = false;
        if (wsBomChange.getIsStockTransfer() != null && !wsBomChange.getIsStockTransfer().equals("")) {
            if (wsBomChange.getIsStockTransfer().equals("1")) {
                isStock = true;
            } else if (!wsBomChange.getIsStockTransfer().equals("0")) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"BLDBGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
            }
        } else {
            wsBomChange.setIsStockTransfer("0");
        }
        LocationInfo location = null;
        if (isStock.booleanValue()) {
            if (transferInfo == null) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"BLDBWYDCKCZCBNWK_NOT_NULL", (Locale)ctx.getLocale());
            }
            if (warehouse != null && transferInfo != null) {
                if (!warehouse.getStorageOrg().getId().equals((Object)transferInfo.getId())) {
                    return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"DCCKBSDCKCZZHDYX_NOT", (Locale)ctx.getLocale(), (Object[])new Object[]{warehouse.getNumber(), transferInfo.getName()});
                }
                if (wsBomChange.getLocationnumber() != null && !wsBomChange.getLocationnumber().equals("") && warehouse.isHasLocation()) {
                    EntityViewInfo loEv = new EntityViewInfo();
                    FilterInfo loFilter = new FilterInfo();
                    loFilter.getFilterItems().add(new FilterItemInfo("number", (Object)wsBomChange.getLocationnumber(), CompareType.EQUALS));
                    loEv.setFilter(loFilter);
                    LocationCollection locaCol = LocationFactory.getLocalInstance((Context)ctx).getLocationCollection(loEv);
                    if (locaCol == null || locaCol.size() == 0) {
                        return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"KWZEASBCZ_NOT_EXIST", (Locale)ctx.getLocale());
                    }
                    location = locaCol.get(0);
                    location = LocationFactory.getLocalInstance((Context)ctx).getLocationInfo((IObjectPK)new ObjectUuidPK(location.getId()));
                    if (!location.getWarehouse().getId().toString().equals(warehouse.getId().toString())) {
                        return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"KWBSDCCKXDYDKW_NOT_EXIST", (Locale)ctx.getLocale(), (Object[])new Object[]{location.getNumber(), warehouse.getNumber()});
                    }
                    if (!location.getState().equals((Object)WHStateEnum.ACTIVE)) {
                        return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"KWZEASXTZHWQY_NOT_ACTIVE", (Locale)ctx.getLocale(), (Object[])new Object[]{location.getNumber()});
                    }
                }
            }
        } else {
            transferInfo = null;
            warehouse = null;
            if (wsBomChange.getTransferOrgUnit() != null && !wsBomChange.getTransferOrgUnit().equals("")) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"BLDBWKHLDCKCBXWK_MUST_NULL", (Locale)ctx.getLocale());
            }
            if (wsBomChange.getTransferWarehouse() != null && !wsBomChange.getTransferWarehouse().equals("")) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"BLDBWKHLDCCKWK_MUST_NULL", (Locale)ctx.getLocale());
            }
        }
        Boolean isSelect = false;
        if (wsBomChange.getCanSelected() != null && !wsBomChange.getCanSelected().equals("")) {
            if (wsBomChange.getCanSelected().equals("1")) {
                isSelect = true;
            } else if (!wsBomChange.getCanSelected().equals("0")) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"KXJIANGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
            }
        } else {
            wsBomChange.setCanSelected("0");
        }
        Boolean isFirst = false;
        if (wsBomChange.getFirstCfg() != null && !wsBomChange.getFirstCfg().equals("")) {
            if (wsBomChange.getFirstCfg().equals("1")) {
                isFirst = true;
            } else if (!wsBomChange.getFirstCfg().equals("0")) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SXPZGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
            }
        } else {
            wsBomChange.setFirstCfg("0");
        }
        Boolean isFeture = false;
        if (wsBomChange.getFeture() != null && !wsBomChange.getFeture().equals("")) {
            if (wsBomChange.getFeture().equals("1")) {
                isFeture = true;
            } else if (!wsBomChange.getFeture().equals("0")) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"TZHJGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
            }
        } else {
            wsBomChange.setFeture("0");
        }
        Boolean isBackFlush = false;
        if (wsBomChange.getIsBackFlush() != null && !wsBomChange.getIsBackFlush().equals("")) {
            if (wsBomChange.getIsBackFlush().equals("1")) {
                isBackFlush = true;
            } else if (!wsBomChange.getIsBackFlush().equals("0")) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"DCHGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
            }
        } else {
            wsBomChange.setIsBackFlush("0");
        }
        Integer leadTime = new Integer(0);
        if (wsBomChange.getLeadtime() != null && !wsBomChange.getLeadtime().equals("")) {
            if (!WSStandardBomChangeWebServiceFacadeControllerBean.isInteteger(wsBomChange.getLeadtime())) return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"PZSJGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
            leadTime = Integer.parseInt(wsBomChange.getLeadtime());
        } else {
            wsBomChange.setLeadtime("0");
        }
        ConsumeTypeEnum consumeType = ConsumeTypeEnum.VariableAmount;
        if (wsBomChange.getConsumeType() != null && !wsBomChange.getConsumeType().equals("")) {
            if (wsBomChange.getConsumeType().equals("30")) {
                consumeType = ConsumeTypeEnum.Proportion;
            } else if (!wsBomChange.getConsumeType().equals("20")) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"XHLXGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
            }
        } else {
            wsBomChange.setConsumeType("20");
        }
        IssuePropEnum issuePropEnum = IssuePropEnum.NULL;
        if (wsBomChange.getIssueProp() != null && !wsBomChange.getIssueProp().equals("")) {
            if (wsBomChange.getIssueProp().equals("ECP")) {
                issuePropEnum = IssuePropEnum.ECP;
            } else if (!wsBomChange.getIssueProp().equals("MCP")) {
                issuePropEnum = IssuePropEnum.MCP;
            }
        }
        BigDecimal scrapRatio = BigDecimal.ZERO;
        if (wsBomChange.getScrapRatio() != null && !wsBomChange.getScrapRatio().equals("")) {
            if (!WSStandardBomChangeWebServiceFacadeControllerBean.isPosNumber(wsBomChange.getScrapRatio())) return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"FPLGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
            scrapRatio = new BigDecimal(wsBomChange.getScrapRatio());
        } else {
            wsBomChange.setScrapRatio("0");
        }
        BigDecimal proportion = new BigDecimal("100");
        if (wsBomChange.getProportion() != null && !wsBomChange.getProportion().equals("")) {
            if (!WSStandardBomChangeWebServiceFacadeControllerBean.isPosNumber(wsBomChange.getProportion())) return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"XHBLGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
            proportion = new BigDecimal(wsBomChange.getProportion());
        } else {
            wsBomChange.setProportion("100");
        }
        MaterialAttributeEnum materialProp = MaterialAttributeEnum.OTHER;
        if (wsBomChange.getMaterialProp().equals("10010")) {
            materialProp = MaterialAttributeEnum.SCHEDULEPART;
        } else if (wsBomChange.getMaterialProp().equals("10020")) {
            materialProp = MaterialAttributeEnum.PHANTOMPART;
        } else if (wsBomChange.getMaterialProp().equals("10030")) {
            materialProp = MaterialAttributeEnum.FABRICATEDPART;
        } else if (wsBomChange.getMaterialProp().equals("10040")) {
            materialProp = MaterialAttributeEnum.PURCHASEDPART;
        } else if (wsBomChange.getMaterialProp().equals("10050")) {
            materialProp = MaterialAttributeEnum.EXTERNALPROCESSINPART;
        } else {
            if (!wsBomChange.getMaterialProp().equals("10060")) return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"WLSHXEASXT_NOT_EXIST", (Locale)ctx.getLocale());
            materialProp = MaterialAttributeEnum.OTHER;
        }
        MaterialIssueModeEnum materialIssue = MaterialIssueModeEnum.PRODUCEISSMODE;
        if (wsBomChange.getIssMode() != null && !wsBomChange.getIssMode().equals("")) {
            if (wsBomChange.getIssMode().equals("11010")) {
                materialIssue = MaterialIssueModeEnum.PRODUCEISSMODE;
            } else if (wsBomChange.getIssMode().equals("11030")) {
                materialIssue = MaterialIssueModeEnum.KANBANISSMODE;
            } else if (wsBomChange.getIssMode().equals("11050")) {
                materialIssue = MaterialIssueModeEnum.STRAIGHT;
            } else {
                if (!wsBomChange.getIssMode().equals("11040")) return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"LSLMSZEASXT_NOT_EXIST", (Locale)ctx.getLocale());
                materialIssue = MaterialIssueModeEnum.NOTISSMODE;
            }
        }
        if ((provideType = BomConvertBaseProcess.getMaterialProvideTypeEnum(ctx, storageInfo.getId().toString(), supplyInfo.getId().toString(), materialInfo.getId().toString())).equals((Object)MaterialProvideTypeEnum.CURRENTORGPROVIDE) || provideType.equals((Object)MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE)) {
            if (deWarehouse != null && !deWarehouse.getStorageOrg().getId().equals((Object)storageInfo.getId())) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"GYLXLLCKBSDQKCZZXCK_NOT", (Locale)ctx.getLocale(), (Object[])new Object[]{deWarehouse.getNumber(), storageInfo.getName()});
            }
        } else if ((provideType.equals((Object)MaterialProvideTypeEnum.SPANORGPROVIDE) || provideType.equals((Object)MaterialProvideTypeEnum.SPANORGDIRECTPROVIDE)) && deWarehouse != null && !deWarehouse.getStorageOrg().getId().equals((Object)supplyInfo.getId())) {
            return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"GYLXLLCKBSDQGHZZXCK_NOT", (Locale)ctx.getLocale(), (Object[])new Object[]{deWarehouse.getNumber(), supplyInfo.getName()});
        }
        if ((bomEntryCol = ibe.getBomChangeNewEntryCollection("select id where sourcebillEntryID ='" + wsBomChange.getPLMBomEntryID() + "'")) != null && bomEntryCol.size() > 0) {
            bomEntryInfo = bomEntryCol.get(0);
            bomEntryInfo = ibe.getBomChangeNewEntryInfo((IObjectPK)new ObjectUuidPK(bomEntryInfo.getId()));
            bomInfo = bomEntryInfo.getParent();
            if ((bomInfo = ib.getBomChangeInfo((IObjectPK)new ObjectUuidPK(bomInfo.getId()))).getBaseStatus().equals((Object)BomChangeBillStatusEnum.AUDIT)) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"DYDEBOMBGDZEAS_AUDITED", (Locale)ctx.getLocale());
            }
            bomInfo.setStorageOrgUnit(storageInfo);
            bomInfo.setBaseStatus(BomChangeBillStatusEnum.SAVE);
            bomInfo.setChangePerson(userInfo.getPerson());
            bomInfo.setBomType(BomType);
            bomInfo.setProject(projectInfo);
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
            bomInfo.setLastUpdateUser(user);
            bomInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            if (wsBomChange.getProductQty() != null && !wsBomChange.getProductQty().equals("")) {
                bomInfo.setProductQty(new BigDecimal(wsBomChange.getProductQty()));
            }
            if (wsBomChange.getProductQty() != null && !wsBomChange.getProductQty().equals("")) {
                bomInfo.setOldProductQty(new BigDecimal(wsBomChange.getProductQty()));
            }
            bomInfo.setDepartment(adminInfo);
            if (wsBomChange.getYield() != null && !wsBomChange.getYield().equals("")) {
                bomInfo.setYield(new BigDecimal(wsBomChange.getYield()));
            }
            if (wsBomChange.getYield() != null && !wsBomChange.getYield().equals("")) {
                bomInfo.setOldYield(new BigDecimal(wsBomChange.getYield()));
            }
            bomInfo.setMainTenanceLevel(mainTenanceLevelInfo);
            bomInfo.setDesignMode(designMode);
            bomInfo.setCreator(userInfo);
            bomInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            pk = bomEntryInfo.getId();
            bomEntryInfo.setMaterial(materialInfo);
            bomEntryInfo.setUnit(unitInfo);
            if (wsBomChange.getConsumeFixQty() != null && !wsBomChange.getConsumeFixQty().equals("")) {
                bomEntryInfo.setConsumeFixQty(new BigDecimal(wsBomChange.getConsumeFixQty()));
            }
            bomEntryInfo.setConsumeType(consumeType);
            bomEntryInfo.setProportion(proportion);
            bomEntryInfo.setScrapRatio(scrapRatio);
            bomEntryInfo.setLeadtime(leadTime);
            bomEntryInfo.setIssueProp(issuePropEnum);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                if (wsBomChange.getEffectiveDate() != null && !wsBomChange.getEffectiveDate().equals("")) {
                    bomEntryInfo.setEffectiveDate(sdf.parse(wsBomChange.getEffectiveDate()));
                } else {
                    bomEntryInfo.setEffectiveDate(sdf.parse(MMUtils.dateToString((Date)new Date(), (String)"yyyy-MM-dd")));
                }
                if (wsBomChange.getDisableDate() != null && !wsBomChange.getDisableDate().equals("")) {
                    bomEntryInfo.setDisableDate(sdf.parse(wsBomChange.getDisableDate()));
                } else {
                    bomEntryInfo.setDisableDate(sdf.parse("2099-12-31"));
                }
            }
            catch (ParseException e) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"RQGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
            }
            if (maPlanCol != null && maPlanCol.size() > 0) {
                bomEntryInfo.setOutputType(maPlan.getOutputType());
            } else {
                bomEntryInfo.setOutputType(MaterialProductEnum.OTHER);
            }
            bomEntryInfo.setIssMode(materialIssue);
            bomEntryInfo.setSupplyOrgUnit(supplyInfo);
            bomEntryInfo.setTransferOrgUnit(transferInfo);
            bomEntryInfo.setProvideType(provideType);
            if (wsBomChange.getNetWeight() != null && !wsBomChange.getNetWeight().equals("")) {
                bomEntryInfo.setNetWeight(new BigDecimal(wsBomChange.getNetWeight()));
            }
            bomEntryInfo.setBlkSize(wsBomChange.getBlkSize());
            bomEntryInfo.setSpecifiedLength(wsBomChange.getSpecifiedLength());
            bomEntryInfo.setMaterialProp(materialProp);
            if (bomEntryInfo.getProvideType() == MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE) {
                bomEntryInfo.setTransferOrgUnit(bomEntryInfo.getSupplyOrgUnit());
            }
            bomEntryInfo.setTransferWarehouse(warehouse);
            bomEntryInfo.setDefaultWarehouse(deWarehouse);
            bomEntryInfo.setBomFlow(wsBomChange.getBomFlow());
            bomEntryInfo.setBeginCarno(startTrack);
            bomEntryInfo.setEndCarno(endTrack);
            bomEntryInfo.setCanSelected(isSelect);
            bomEntryInfo.setFirstCfg(isFirst);
            bomEntryInfo.setFeture(isFeture);
            bomEntryInfo.setIsStockTransfer(isStock);
            bomEntryInfo.setIsBackFlush(isBackFlush);
            bomEntryInfo.setSourcebillEntryID(wsBomChange.getPLMBomEntryID());
            bomEntryInfo.setSourcebillID(wsBomChange.getPLMBomID());
            bomEntryInfo.setSourcebillNumber(wsBomChange.getPLMBomNumber());
            bomInfo.getNewEntry().add(bomEntryInfo);
            ib.update((IObjectPK)new ObjectUuidPK(bomInfo.getId()), (CoreBaseInfo)bomInfo);
            return wsBomChange.getPLMBomID() + ",1," + pk.toString();
        }
        BomInfo bom = new BomInfo();
        String projectid = "";
        String trackId = "";
        if (projectInfo != null) {
            projectid = projectInfo.getId().toString();
        }
        if (startTrack != null) {
            trackId = startTrack.getId().toString();
        }
        bom = BomUtil.getBomInfo(ctx, parentMaterial.getId().toString(), storageInfo.getId().toString(), projectid, designMode, trackId, mainTenanceLevelInfo == null ? null : mainTenanceLevelInfo.getId().toString());
        try {
            if (bom == null) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"PLMDYBOM_NOT_EXIST", (Locale)ctx.getLocale());
            }
            bomInfo = BomChangeBillAuditFacadeFactory.getLocalInstance(ctx).addBomChangeInfoByBom(null, bom);
            if (bomInfo.getId() == null) {
                bomInfo.setId(BOSUuid.create((BOSObjectType)bomInfo.getBOSType()));
            }
            bomInfo.setStorageOrgUnit(storageInfo);
            bomInfo.setBaseStatus(BomChangeBillStatusEnum.SAVE);
            bomInfo.setChangePerson(userInfo.getPerson());
            bomInfo.setBomType(BomType);
            bomInfo.setDesignMode(designMode);
            bomInfo.setProject(projectInfo);
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
            bomInfo.setLastUpdateUser(user);
            bomInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            if (wsBomChange.getProductQty() != null && !wsBomChange.getProductQty().equals("")) {
                bomInfo.setProductQty(new BigDecimal(wsBomChange.getProductQty()));
            }
            bomInfo.setDepartment(adminInfo);
            if (wsBomChange.getYield() != null && !wsBomChange.getYield().equals("")) {
                bomInfo.setYield(new BigDecimal(wsBomChange.getYield()));
            }
            bomInfo.setCreator(userInfo);
            bomInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            bomInfo.setMainTenanceLevel(mainTenanceLevelInfo);
            bomEntryInfo = new BomChangeNewEntryInfo();
            bomEntryInfo.setMaterial(materialInfo);
            if (maPlanCol != null && maPlanCol.size() > 0) {
                bomEntryInfo.setOutputType(maPlan.getOutputType());
            } else {
                bomEntryInfo.setOutputType(MaterialProductEnum.OTHER);
            }
            bomEntryInfo.setUnit(unitInfo);
            if (wsBomChange.getConsumeFixQty() != null && !wsBomChange.getConsumeFixQty().equals("")) {
                bomEntryInfo.setConsumeFixQty(new BigDecimal(wsBomChange.getConsumeFixQty()));
            }
            bomEntryInfo.setConsumeType(consumeType);
            bomEntryInfo.setProportion(proportion);
            bomEntryInfo.setScrapRatio(scrapRatio);
            bomEntryInfo.setLeadtime(leadTime);
            bomEntryInfo.setIssueProp(issuePropEnum);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                if (wsBomChange.getEffectiveDate() != null && !wsBomChange.getEffectiveDate().equals("")) {
                    bomEntryInfo.setEffectiveDate(sdf.parse(wsBomChange.getEffectiveDate()));
                } else {
                    bomEntryInfo.setEffectiveDate(sdf.parse(MMUtils.dateToString((Date)new Date(), (String)"yyyy-MM-dd")));
                }
                if (wsBomChange.getDisableDate() != null && !wsBomChange.getDisableDate().equals("")) {
                    bomEntryInfo.setDisableDate(sdf.parse(wsBomChange.getDisableDate()));
                } else {
                    bomEntryInfo.setDisableDate(sdf.parse("2099-12-31"));
                }
            }
            catch (ParseException e) {
                return wsBomChange.getPLMBomID() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"RQGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
            }
            bomEntryInfo.setIssMode(materialIssue);
            bomEntryInfo.setSupplyOrgUnit(supplyInfo);
            bomEntryInfo.setTransferOrgUnit(transferInfo);
            bomEntryInfo.setProvideType(provideType);
            if (wsBomChange.getNetWeight() != null && !wsBomChange.getNetWeight().equals("")) {
                bomEntryInfo.setNetWeight(new BigDecimal(wsBomChange.getNetWeight()));
            }
            bomEntryInfo.setBlkSize(wsBomChange.getBlkSize());
            bomEntryInfo.setSpecifiedLength(wsBomChange.getSpecifiedLength());
            bomEntryInfo.setMaterialProp(materialProp);
            if (bomEntryInfo.getProvideType() == MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE) {
                bomEntryInfo.setTransferOrgUnit(bomEntryInfo.getSupplyOrgUnit());
            }
            bomEntryInfo.setTransferWarehouse(warehouse);
            bomEntryInfo.setDefaultWarehouse(deWarehouse);
            bomEntryInfo.setBomFlow(wsBomChange.getBomFlow());
            bomEntryInfo.setBeginCarno(startTrack);
            bomEntryInfo.setEndCarno(endTrack);
            bomEntryInfo.setCanSelected(isSelect);
            bomEntryInfo.setFirstCfg(isFirst);
            bomEntryInfo.setFeture(isFeture);
            bomEntryInfo.setIsStockTransfer(isStock);
            bomEntryInfo.setIsBackFlush(isBackFlush);
            bomEntryInfo.setSourcebillEntryID(wsBomChange.getPLMBomEntryID());
            bomEntryInfo.setSourcebillID(wsBomChange.getPLMBomID());
            bomEntryInfo.setSourcebillNumber(wsBomChange.getPLMBomNumber());
            bomInfo.getNewEntry().add(bomEntryInfo);
            bomInfo.setNumber(this.setBillNumber(ctx, (IObjectValue)bomInfo, bomInfo.getStorageOrgUnit().getId().toString()));
            ib.save((CoreBaseInfo)bomInfo);
            pk = bomEntryInfo.getId();
            return wsBomChange.getPLMBomID() + ",1," + pk.toString();
        }
        catch (Exception e) {
            return wsBomChange.getPLMBomID() + ",-1," + e.getMessage();
        }
    }

    public static final TrackNumberInfo getTrackNumberInfo(Context ctx, String trackID) throws BOSException, EASBizException {
        return TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberInfo((IObjectPK)new ObjectUuidPK(trackID), WSStandardBomChangeWebServiceFacadeControllerBean.getNumberSic());
    }

    private static final SelectorItemCollection getNumberSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        return sic;
    }

    public static boolean isPosNumber(String string) {
        if (string == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("^\\d+(\\.\\d+)?$");
        return pattern.matcher(string).matches();
    }

    public static boolean isDate(String string) {
        if (string == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("^(?:(?!0000)[0-9]{4}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)$");
        return pattern.matcher(string).matches();
    }

    public static boolean isInteteger(String string) {
        if (string == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[1-9]\\d*|0$");
        return pattern.matcher(string).matches();
    }

    public static boolean hasPermission(Context ctx, String permItemName, ObjectUuidPK orgIdPK, String userId) throws EASBizException, BOSException {
        ObjectUuidPK userPK = new ObjectUuidPK(userId);
        return PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgIdPK, permItemName);
    }

    protected String setBillNumber(Context ctx, IObjectValue billInfo, String bizOrgUnitID) throws EASBizException, BOSException {
        String billNumber = null;
        CodingRuleInfo ruleInfo = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCodingRule(billInfo, bizOrgUnitID);
        if (ruleInfo != null) {
            billNumber = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber(billInfo, ruleInfo);
        }
        if (billNumber != null) {
            ((BomInfo)billInfo).setNumber(billNumber);
        } else if (billInfo.getString("id") != null) {
            billInfo.setString("number", "AutoNumberFromBTP_" + billInfo.getString("id").toString());
        } else {
            billInfo.setString("number", "AutoNumberFromBTP_" + BOSUuid.create((BOSObjectType)billInfo.getBOSType()));
        }
        String sqlbillNumber = "select 1 from T_MM_BOM where fnumber = '" + billNumber + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlbillNumber);
        try {
            if (rs.next()) {
                billNumber = this.setBillNumber(ctx, billInfo, bizOrgUnitID);
            }
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("", e.getMessage()));
        }
        return billNumber;
    }

    private static final SelectorItemCollection getBomSelectSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.beginCarno.id"));
        sic.add(new SelectorItemInfo("entrys.beginCarno.number"));
        sic.add(new SelectorItemInfo("entrys.endCarno.id"));
        sic.add(new SelectorItemInfo("entrys.endCarno.number"));
        return sic;
    }
}

