/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.webservice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.framework.cache.ICacheService;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AddressClassCollection;
import com.kingdee.eas.basedata.assistant.AddressClassFactory;
import com.kingdee.eas.basedata.assistant.AddressClassInfo;
import com.kingdee.eas.basedata.assistant.AddressCollection;
import com.kingdee.eas.basedata.assistant.AddressFactory;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.assistant.CityCollection;
import com.kingdee.eas.basedata.assistant.CityFactory;
import com.kingdee.eas.basedata.assistant.CountryCollection;
import com.kingdee.eas.basedata.assistant.CountryFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.LanguageCollection;
import com.kingdee.eas.basedata.assistant.LanguageFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.ProvinceCollection;
import com.kingdee.eas.basedata.assistant.ProvinceFactory;
import com.kingdee.eas.basedata.assistant.RegionCollection;
import com.kingdee.eas.basedata.assistant.RegionFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeCollection;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeFactory;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaCatCollection;
import com.kingdee.eas.fi.fa.basedata.FaCatFactory;
import com.kingdee.eas.fi.fa.basedata.FaEconomicPurpCollection;
import com.kingdee.eas.fi.fa.basedata.FaEconomicPurpFactory;
import com.kingdee.eas.fi.fa.basedata.FaUseStatusCollection;
import com.kingdee.eas.fi.fa.basedata.FaUseStatusFactory;
import com.kingdee.eas.fi.fa.basedata.SplithDealModeEnum;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBizDepartmentCollection;
import com.kingdee.eas.fi.fa.manage.FaBizDepartmentInfo;
import com.kingdee.eas.fi.fa.manage.FaChangeBillCollection;
import com.kingdee.eas.fi.fa.manage.FaChangeBillFactory;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillFactory;
import com.kingdee.eas.fi.fa.manage.FaClearBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurDepartmentInfo;
import com.kingdee.eas.fi.fa.manage.FaFromUnitCatEnum;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.industry.webservice.AbstractWsFaCardFacadeControllerBean;
import com.kingdee.eas.industry.webservice.WSAddressClassInfo;
import com.kingdee.eas.industry.webservice.WSAddressInfo;
import com.kingdee.eas.industry.webservice.WSFaClearBillInfo;
import com.kingdee.eas.industry.webservice.WSFaClearEntryInfo;
import com.kingdee.eas.industry.webservice.WSFaCurCardInfo;
import com.kingdee.eas.industry.webservice.WsFaCurDeptInfo;
import com.kingdee.eas.scm.im.inv.ws.ImportException;
import com.kingdee.eas.scm.im.inv.ws.util.ErrorCodeUtil;
import com.kingdee.eas.scm.im.inv.ws.util.XMLUtil;
import com.kingdee.eas.scm.sm.pur.constant.UIConstant;
import com.kingdee.eas.scm.sm.pur.util.InfoUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.NumericExceptionSubItem;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class WsFaCardFacadeControllerBean
extends AbstractWsFaCardFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.webservice.WsFaCardFacadeControllerBean");
    final String[] validateBillHeadProps = new String[]{"assetCat", "number", "assetName", "assetAmt", "measureUnit", "accountDate", "originMethod", "useStatus", "economicPurp", "storeCity", "dept"};
    final String[] validateEntriesProps = new String[]{"useDepartment"};
    final String[] headLinkProperties = new String[]{"company", "assetCat", "measureUnit", "originMethod", "useStatus", "economicPurp", "storeCity", "dept", "keeper", "currency"};
    final String[] entryLinkProperties = new String[]{"faCurCard", "useDepartment", "usePerson"};
    final String[] string_Fields_Head = new String[]{"number", "oldNumber", "assetName", "specs", "pArea", "mfr", "paperNo", "originType", "originUnit", "remark"};
    final String[] boolean_Fields_Head = new String[0];
    final String[] bigDecimal_Fields_Head = new String[]{"assetAmt"};
    final String[] int_Fields_Head = new String[0];
    final String[] string_Fields_DEPT = new String[]{"usage", "remark"};
    final String[] boolean_Fields_DEPT = new String[0];
    final String[] bigDecimal_Fields_DEPT = new String[0];
    final String[] int_Fields_DEPT = new String[0];

    @Override
    protected String[] _importFaCurCard(Context ctx, IObjectValue faCurCard, IObjectCollection faCurDeptColl) throws BOSException, EASBizException {
        System.out.print("---------------webservice start import FaCurCard-------------------");
        System.out.println(faCurCard.getClass() + ":" + faCurCard.toString() + ";");
        for (int i = 0; i < faCurDeptColl.size(); ++i) {
            System.out.println(faCurDeptColl.getClass() + ":" + faCurDeptColl.getObject(i).toString() + ";");
        }
        String[] msg = new String[3];
        try {
            this.setDefaultContext(ctx);
            WSFaCurCardInfo faCurInfo = (WSFaCurCardInfo)faCurCard;
            FaCurCardInfo cardInfo = new FaCurCardInfo();
            this.buildCardInfo(ctx, faCurCard, faCurDeptColl, cardInfo);
            cardInfo.setDescription("import");
            IFaCurCard iFaCurCard = FaCurCardFactory.getLocalInstance((Context)ctx);
            FaCurCardCollection coll = iFaCurCard.getFaCurCardCollection("select id where number='" + cardInfo.getNumber() + "'");
            if (coll != null && coll.size() > 0) {
                throw new Exception("\u7f16\u7801\u5df2\u5b58\u5728\uff01");
            }
            iFaCurCard.save((CoreBaseInfo)cardInfo);
            msg[0] = "Y";
            msg[1] = cardInfo.getId().toString();
            msg[2] = cardInfo.getNumber();
        }
        catch (BOSException e) {
            ImportException excep = new ImportException(new NumericExceptionSubItem("bosException", e.getMessage()));
            msg[0] = "N";
            msg[1] = excep.getMessage();
            msg[2] = null;
            logger.error((Object)excep);
            return msg;
        }
        catch (Exception e) {
            msg[0] = "N";
            msg[1] = e.getMessage();
            msg[2] = null;
            logger.error((Object)e);
            return msg;
        }
        return msg;
    }

    private void buildCardInfo(Context ctx, IObjectValue faCurCard, IObjectCollection faCurDeptColl, FaCurCardInfo cardInfo) throws EASBizException, BOSException, ParseException, Exception {
        Map billHead = this.converColl(ctx, faCurCard, faCurDeptColl);
        ArrayList billEntriesList = (ArrayList)billHead.get("depts");
        this.validateProperty(billHead, billEntriesList);
        this.buildBillHead(ctx, cardInfo, (HashMap)billHead);
        this.buildBillEntries(ctx, cardInfo, billEntriesList);
    }

    private void setDefaultContext(Context ctx) {
        String fcu = "00000000-0000-0000-0000-000000000000CCE7AED4";
        UserInfo curUserInfo = (UserInfo)ctx.get((Object)"UserInfo");
        if (curUserInfo.getCU() != null) {
            fcu = curUserInfo.getCU().getId().toString();
        }
        if (ContextUtil.getCurrentCtrlUnit((Context)ctx) == null) {
            CtrlUnitInfo cuInfo = new CtrlUnitInfo();
            cuInfo.setId(BOSUuid.read((String)fcu));
            cuInfo.setNumber("1");
            ContextUtil.setCurrentCtrlUnit((Context)ctx, (CtrlUnitInfo)cuInfo);
        }
        if (ContextUtil.getCurrentFIUnit((Context)ctx) == null) {
            CompanyOrgUnitInfo couInfo = new CompanyOrgUnitInfo();
            couInfo.setId(BOSUuid.read((String)fcu));
            couInfo.setNumber("1");
            ContextUtil.setCurrentFIUnit((Context)ctx, (CompanyOrgUnitInfo)couInfo);
        }
    }

    private void validateProperty(Map billHead, ArrayList billEntriesList) throws EASBizException {
        for (int i = 0; i < this.validateBillHeadProps.length; ++i) {
            if (InfoUtil.validateProperty((HashMap)((HashMap)billHead), (String)this.validateBillHeadProps[i])) continue;
            throw new EASBizException(new NumericExceptionSubItem("1000", this.validateBillHeadProps[i] + UIConstant.PROPNOTEMPT));
        }
        HashMap entryMap = null;
        for (int i = 0; i < billEntriesList.size(); ++i) {
            entryMap = (HashMap)billEntriesList.get(i);
            for (int j = 0; j < this.validateEntriesProps.length; ++j) {
                if (InfoUtil.validateProperty((HashMap)entryMap, (String)this.validateEntriesProps[j])) continue;
                throw new EASBizException(new NumericExceptionSubItem("2000", this.validateEntriesProps[i] + UIConstant.PROPNOTEMPT));
            }
        }
    }

    private void buildBillHead(Context ctx, FaCurCardInfo info, HashMap billHeadMap) throws BOSException, ParseException, EASBizException {
        if (billHeadMap != null) {
            this.dealWithStringFields((CoreBaseInfo)info, billHeadMap, this.string_Fields_Head);
            this.dealWithBooleanFields((CoreBaseInfo)info, billHeadMap, this.boolean_Fields_Head);
            this.dealWithBigDecimalFields((CoreBaseInfo)info, billHeadMap, this.bigDecimal_Fields_Head);
            this.dealWithIntFields((CoreBaseInfo)info, billHeadMap, this.int_Fields_Head);
            this.setLinkProperties(ctx, (CoreBaseInfo)info, billHeadMap, null, true);
            this.dealwithOtherFields_Head(ctx, info, billHeadMap);
        }
    }

    private void dealwithOtherFields_Head(Context ctx, FaCurCardInfo info, HashMap billHeadMap) throws ParseException {
        Date bizDate;
        String strNumber = null;
        strNumber = (String)billHeadMap.get("accountDate");
        if (strNumber != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            bizDate = XMLUtil.convertStrToDate((String)strNumber, (String)"yyyy-MM-dd");
            info.setAccountDate(bizDate);
        }
        if ((strNumber = (String)billHeadMap.get("fiAccountDate")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            bizDate = XMLUtil.convertStrToDate((String)strNumber, (String)"yyyy-MM-dd");
            info.setFiAccountDate(bizDate);
        }
        if ((strNumber = (String)billHeadMap.get("levFrDate")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            bizDate = XMLUtil.convertStrToDate((String)strNumber, (String)"yyyy-MM-dd");
            info.setLevFrDate(bizDate);
        }
    }

    private void buildBillEntries(Context ctx, FaCurCardInfo info, ArrayList entriesList) throws Exception {
        if (entriesList != null) {
            for (int i = 0; i < entriesList.size(); ++i) {
                HashMap entryMap = (HashMap)entriesList.get(i);
                FaCurDepartmentInfo deptInfo = new FaCurDepartmentInfo();
                deptInfo.setSeq(i + 1);
                this.dealWithStringFields((CoreBaseInfo)deptInfo, entryMap, this.string_Fields_DEPT);
                this.dealWithBooleanFields((CoreBaseInfo)deptInfo, entryMap, this.boolean_Fields_DEPT);
                this.dealWithBigDecimalFields((CoreBaseInfo)deptInfo, entryMap, this.bigDecimal_Fields_DEPT);
                this.dealWithIntFields((CoreBaseInfo)deptInfo, entryMap, this.int_Fields_DEPT);
                this.setLinkProperties(ctx, (CoreBaseInfo)deptInfo, entryMap, null, false);
                info.getFaCurDepartment().add(deptInfo);
            }
        }
    }

    private Map converColl(Context ctx, IObjectValue faCurCard, IObjectCollection faCurDeptColl) throws EASBizException {
        Map billHeadMap = new HashMap();
        billHeadMap = this.getHead((WSFaCurCardInfo)faCurCard);
        ArrayList<Object> depts = new ArrayList<Object>();
        for (int i = 0; i < faCurDeptColl.size(); ++i) {
            depts.add(this.getEntry(ctx, (WsFaCurDeptInfo)faCurDeptColl.getObject(i)));
        }
        billHeadMap.put("depts", depts);
        return billHeadMap;
    }

    private Map getHead(WSFaCurCardInfo billEntity) {
        HashMap<String, String> billHeadMap = new HashMap<String, String>();
        billHeadMap.put("company", "1");
        billHeadMap.put("assetCat", billEntity.getAssetCat_number());
        billHeadMap.put("number", billEntity.getNumber());
        billHeadMap.put("oldNumber", billEntity.getOldNumber());
        billHeadMap.put("assetName", billEntity.getAssetName());
        billHeadMap.put("assetAmt", billEntity.getAssetAmt());
        billHeadMap.put("measureUnit", billEntity.getMeasureUnit_number());
        billHeadMap.put("accountDate", billEntity.getAccountDate());
        billHeadMap.put("fiAccountDate", billEntity.getFiAccountDate());
        billHeadMap.put("originMethod", billEntity.getOriginMethod_number());
        billHeadMap.put("useStatus", billEntity.getUseStatus_number());
        billHeadMap.put("economicPurp", billEntity.getEconomicPurp_number());
        billHeadMap.put("storeCity", billEntity.getStoreCity_number());
        billHeadMap.put("specs", billEntity.getSpecs());
        billHeadMap.put("pArea", billEntity.getPArea());
        billHeadMap.put("mfr", billEntity.getMfr());
        billHeadMap.put("levFrDate", billEntity.getLevFrDate());
        billHeadMap.put("paperNo", billEntity.getPaperNo());
        billHeadMap.put("originType", billEntity.getOriginType());
        billHeadMap.put("originUnit", billEntity.getOriginUnit());
        billHeadMap.put("dept", billEntity.getDept_number());
        billHeadMap.put("keeper", billEntity.getKeeper_number());
        billHeadMap.put("remark", billEntity.getRemark());
        billHeadMap.put("currency", billEntity.getCurrency_number());
        billHeadMap.put("changeNumber", billEntity.getChangeNumber());
        billHeadMap.put("changeDate", billEntity.getChangeDate());
        billHeadMap.put("changeMode_number", billEntity.getChangeMode_number());
        return billHeadMap;
    }

    private Object getEntry(Context ctx, WsFaCurDeptInfo billEntity) throws EASBizException {
        HashMap<String, String> billEntryMap = new HashMap<String, String>();
        billEntryMap.put("useDepartment", billEntity.getUseDepartment_number());
        billEntryMap.put("usePerson", billEntity.getUsePerson_number());
        billEntryMap.put("usage", billEntity.getUsage());
        billEntryMap.put("remark", billEntity.getRemark());
        return billEntryMap;
    }

    private void dealWithStringFields(CoreBaseInfo info, HashMap billHeadMap, String[] string_Fields) {
        int c = string_Fields.length;
        for (int i = 0; i < c; ++i) {
            if (billHeadMap.get(string_Fields[i]) == null) {
                info.setNull(string_Fields[i]);
                continue;
            }
            String value = (String)billHeadMap.get(string_Fields[i]);
            info.setString(string_Fields[i], value);
        }
    }

    private void dealWithBooleanFields(CoreBaseInfo info, HashMap billHeadMap, String[] boolean_Fields) {
        try {
            int c = boolean_Fields.length;
            for (int i = 0; i < c; ++i) {
                String fieldName = boolean_Fields[i];
                String fieldValue = (String)billHeadMap.get(boolean_Fields[i]);
                if (!(fieldValue != null && !fieldValue.trim().equals("") && fieldValue.trim().equals("true") && fieldValue.trim().equals("false") && fieldValue.trim().equals("1") && fieldValue.trim().equals("0"))) {
                    info.setNull(fieldName);
                    continue;
                }
                if (fieldValue.equals("1")) {
                    info.setBoolean(fieldName, true);
                }
                if (fieldValue.equals("0")) {
                    info.setBoolean(fieldName, false);
                }
                info.setBoolean(fieldName, Boolean.getBoolean(fieldValue));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void dealWithBigDecimalFields(CoreBaseInfo info, HashMap billHeadMap, String[] bigDecimal_Fields) {
        int c = bigDecimal_Fields.length;
        for (int i = 0; i < c; ++i) {
            String fieldName = bigDecimal_Fields[i];
            String fieldValue = (String)billHeadMap.get(bigDecimal_Fields[i]);
            try {
                if (fieldValue == null || fieldValue.trim().equals("")) {
                    info.setNull(fieldName);
                    continue;
                }
                info.setBigDecimal(fieldName, new BigDecimal(fieldValue.trim()));
                continue;
            }
            catch (NumberFormatException ne) {
                info.setNull(fieldName);
            }
        }
    }

    private void dealWithIntFields(CoreBaseInfo info, HashMap billHeadMap, String[] int_Fields) {
        int c = int_Fields.length;
        for (int i = 0; i < c; ++i) {
            String fieldName = int_Fields[i];
            String fieldValue = (String)billHeadMap.get(int_Fields[i]);
            try {
                if (fieldValue == null || fieldValue.trim().equals("")) {
                    info.setNull(fieldName);
                    continue;
                }
                info.setInt(fieldName, Integer.parseInt(fieldValue.trim()));
                continue;
            }
            catch (NumberFormatException ne) {
                info.setNull(fieldName);
            }
        }
    }

    private void setLinkProperties(Context ctx, CoreBaseInfo info, HashMap billHeadMap, String cuId, boolean isBillHead) throws EASBizException {
        String[] linkProperties = null;
        String propertyName = null;
        HashMap erroMap = null;
        if (isBillHead) {
            erroMap = ErrorCodeUtil.getHeadErrorMap();
            linkProperties = this.headLinkProperties;
        } else {
            erroMap = ErrorCodeUtil.getEntryErrorMap();
            linkProperties = this.entryLinkProperties;
        }
        CoreBaseInfo linkBaseInfo = null;
        try {
            for (int i = 0; i < linkProperties.length; ++i) {
                propertyName = linkProperties[i];
                linkBaseInfo = WsFaCardFacadeControllerBean.getLinkPropCoreBaseInfo(ctx, info, propertyName, (String)billHeadMap.get(propertyName));
                if (linkBaseInfo == null && (String)billHeadMap.get(propertyName) != null && !"".equals(((String)billHeadMap.get(propertyName)).trim())) {
                    throw new Exception(propertyName + " " + EASResource.getString((String)"com.kingdee.eas.scm.im.inv.ws.WebserviceResource", (String)"NUMBERNOTFOUND"));
                }
                if (linkBaseInfo == null && this.isMustValidateProperty(propertyName, isBillHead)) {
                    throw new Exception(propertyName + " " + EASResource.getString((String)"com.kingdee.eas.scm.im.inv.ws.WebserviceResource", (String)"NUMBERNOTFOUND"));
                }
                info.put(propertyName, (Object)linkBaseInfo);
            }
        }
        catch (Exception e) {
            NumericExceptionSubItem numberExc = (NumericExceptionSubItem)erroMap.get(propertyName);
            if (numberExc == null) {
                numberExc = new NumericExceptionSubItem(propertyName, e.getMessage());
            }
            throw new ImportException(numberExc);
        }
    }

    public static CoreBaseInfo getLinkPropCoreBaseInfo(Context ctx, CoreBaseInfo info, String linkProperty, String number) throws BOSException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo eo = loader.getEntity(info.getBOSType());
        LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)eo.getPropertyByName(linkProperty);
        EntityObjectInfo superEntityObjectInfo = null;
        ICoreBase iLinkCoreBase = null;
        CoreBaseInfo linkInfo = null;
        if (linkPropertyInfo != null && number != null) {
            superEntityObjectInfo = linkPropertyInfo.getRelationship().getSupplierObject();
            iLinkCoreBase = WsFaCardFacadeControllerBean.getLocalInstance(ctx, superEntityObjectInfo);
            linkInfo = WsFaCardFacadeControllerBean.getCoreBaseInfo(iLinkCoreBase, number);
        }
        return linkInfo;
    }

    public static ICoreBase getLocalInstance(Context ctx, EntityObjectInfo eo) {
        ICoreBase iCoreBase = null;
        try {
            Class<?> cls = Class.forName(eo.getBusinessImplFactory());
            Method mtd = cls.getMethod("getLocalInstance", Context.class);
            iCoreBase = (ICoreBase)mtd.invoke(cls, ctx);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return iCoreBase;
    }

    public static CoreBaseInfo getCoreBaseInfo(ICoreBase iDataBase, String number) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        CoreBaseCollection coll = iDataBase.getCollection("select id where number='" + number + "'");
        if (coll != null && coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    private boolean isMustValidateProperty(String propName, boolean isHeadBill) {
        String[] musValidateProp = null;
        musValidateProp = isHeadBill ? this.validateBillHeadProps : this.validateEntriesProps;
        for (int i = 0; i < musValidateProp.length; ++i) {
            if (!musValidateProp[i].equals(propName)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String[] _importFaChangeBill(Context ctx, IObjectValue wsCardInfo, IObjectCollection depts) throws BOSException, EASBizException {
        System.out.print("---------------webservice start import FaChangeBill-------------------");
        System.out.println(wsCardInfo.getClass() + ":" + wsCardInfo.toString() + ";");
        for (int i = 0; i < depts.size(); ++i) {
            System.out.println(depts.getClass() + ":" + depts.getObject(i).toString() + ";");
        }
        String[] msg = new String[3];
        try {
            this.setDefaultContext(ctx);
            WSFaCurCardInfo wsSCardInfo = (WSFaCurCardInfo)wsCardInfo;
            this.checkForChangeBill(wsSCardInfo);
            FaCurCardInfo oldFaCurCardInfo = null;
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)wsSCardInfo.getNumber()));
            evi.setSelector(this.getFaCurCardSelectors());
            FaCurCardCollection faCurCardColl = FaCurCardFactory.getLocalInstance((Context)ctx).getFaCurCardCollection(evi);
            if (faCurCardColl == null || faCurCardColl.size() == 0) {
                throw new Exception("\u8d44\u4ea7\u7f16\u53f7\u5bf9\u5e94\u7684\u8d44\u4ea7\u4e0d\u5b58\u5728\uff01");
            }
            oldFaCurCardInfo = faCurCardColl.get(0);
            FaChangeBillInfo faChangeBillInfo = new FaChangeBillInfo();
            faChangeBillInfo.setCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
            faChangeBillInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            String number = wsSCardInfo.getChangeNumber();
            FaChangeBillCollection faChangeBillColl = FaChangeBillFactory.getLocalInstance((Context)ctx).getFaChangeBillCollection("Where number = '" + number + "'");
            if (faChangeBillColl != null && faChangeBillColl.size() > 0) {
                throw new Exception("\u5df2\u5b58\u5728\u76f8\u540c\u7684\u53d8\u66f4\u5e8f\u53f7\uff01");
            }
            faChangeBillInfo.setNumber(number);
            Date changeDate = XMLUtil.convertStrToDate((String)wsSCardInfo.getChangeDate(), (String)"yyyy-MM-dd");
            faChangeBillInfo.setChangeDate(changeDate);
            FaAlterModeInfo faAltermode = null;
            String changeMode = wsSCardInfo.getChangeMode_number();
            if (changeMode != null && !"".equals(changeMode)) {
                EntityViewInfo entityView = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)changeMode));
                entityView.setFilter(filter);
                FaAlterModeCollection faAlterModeColl = FaAlterModeFactory.getLocalInstance((Context)ctx).getFaAlterModeCollection(entityView);
                if (faAlterModeColl != null && faAlterModeColl.size() > 0) {
                    faAltermode = faAlterModeColl.get(0);
                    faChangeBillInfo.setChangeMode(faAlterModeColl.get(0));
                } else {
                    throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + changeMode + "\u5bf9\u5e94\u7684\u53d8\u66f4\u65b9\u5f0f\uff01");
                }
            }
            this.checkBuildFaCardBill(ctx, wsSCardInfo);
            this.checkBuildFaCardBillEntry(ctx, wsSCardInfo, depts);
            FaCurCardInfo facurCardInfo = faCurCardColl.get(0);
            facurCardInfo.put("changeDate", (Object)changeDate);
            facurCardInfo.put("changeMode", faAltermode);
            IObjectPK pk = FaChangeBillFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)facurCardInfo);
            faChangeBillInfo = FaChangeBillFactory.getLocalInstance((Context)ctx).getFaChangeBillInfo(pk);
            FaBizCardInfo faBizCardInfo = faChangeBillInfo.getChangeBillEntry().get(0).getBizCard();
            this.buildFaCardBill(ctx, wsSCardInfo, faBizCardInfo);
            this.buildFaCardBillEntry(ctx, wsSCardInfo, faBizCardInfo, depts);
            FaChangeBillFactory.getLocalInstance((Context)ctx).update(pk, (CoreBaseInfo)faChangeBillInfo);
            msg[0] = "Y";
            msg[1] = faChangeBillInfo.getId().toString();
            msg[2] = faChangeBillInfo.getNumber();
        }
        catch (BOSException e) {
            ImportException excep = new ImportException(new NumericExceptionSubItem("bosException", e.getMessage()));
            msg[0] = "N";
            msg[1] = excep.getMessage();
            msg[2] = null;
            logger.error((Object)excep);
            return msg;
        }
        catch (Exception e) {
            msg[0] = "N";
            msg[1] = e.getMessage();
            msg[2] = null;
            logger.error((Object)e);
            return msg;
        }
        return msg;
    }

    private void checkForChangeBill(WSFaCurCardInfo cardInfo) throws Exception {
        if (cardInfo.getChangeNumber() == null || "".equals(cardInfo.getChangeNumber())) {
            throw new Exception("\u53d8\u66f4\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (cardInfo.getChangeDate() == null || "".equals(cardInfo.getChangeDate() == null)) {
            throw new Exception("\u53d8\u66f4\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (cardInfo.getChangeMode_number() == null || "".equals(cardInfo.getChangeMode_number())) {
            throw new Exception("\u53d8\u66f4\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (cardInfo.getOldNumber() == null || "".equals(cardInfo.getOldNumber())) {
            throw new Exception("\u539f\u8d44\u4ea7\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void checkBuildFaCardBill(Context ctx, WSFaCurCardInfo wsSCardInfo) throws Exception {
        CurrencyCollection currencyColl;
        PersonCollection personColl;
        AdminOrgUnitCollection adminOrgColl;
        String deptNumber;
        FaEconomicPurpCollection faEconomicColl;
        String faEconomicPurp;
        String useStatus;
        String originMethod_number;
        Date measureUnitColl;
        FaCatCollection faCatColl;
        if (!(wsSCardInfo.getAssetCat_number() == null || "".equals(wsSCardInfo.getAssetCat_number()) || (faCatColl = FaCatFactory.getLocalInstance((Context)ctx).getFaCatCollection("Where number = '" + wsSCardInfo.getAssetCat_number() + "'")) != null && faCatColl.size() > 0)) {
            throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + wsSCardInfo.getAssetCat_number() + "\u5bf9\u5e94\u7684\u8d44\u4ea7\u7c7b\u522b\uff01");
        }
        if (!(wsSCardInfo.getMeasureUnit_number() == null || "".equals(wsSCardInfo.getMeasureUnit_number()) || (measureUnitColl = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection("Where number = '" + wsSCardInfo.getMeasureUnit_number() + "'")) != null && measureUnitColl.size() > 0)) {
            throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + wsSCardInfo.getMeasureUnit_number() + "\u5bf9\u5e94\u7684\u8ba1\u91cf\u5355\u4f4d\uff01");
        }
        if (wsSCardInfo.getAccountDate() != null && !"".equals(wsSCardInfo.getAccountDate())) {
            measureUnitColl = XMLUtil.convertStrToDate((String)wsSCardInfo.getAccountDate(), (String)"yyyy-MM-dd");
        }
        if (wsSCardInfo.getFiAccountDate() != null && !"".equals(wsSCardInfo.getFiAccountDate())) {
            measureUnitColl = XMLUtil.convertStrToDate((String)wsSCardInfo.getFiAccountDate(), (String)"yyyy-MM-dd");
        }
        if ((originMethod_number = wsSCardInfo.getOriginMethod_number()) != null && !"".equals(originMethod_number)) {
            EntityViewInfo entityView = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)originMethod_number));
            entityView.setFilter(filter);
            FaAlterModeCollection faAlterModeColl = FaAlterModeFactory.getLocalInstance((Context)ctx).getFaAlterModeCollection(entityView);
            if (faAlterModeColl == null || faAlterModeColl.size() <= 0) {
                throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + originMethod_number + "\u5bf9\u5e94\u7684\u6765\u6e90\u65b9\u5f0f\uff01");
            }
        }
        if ((useStatus = wsSCardInfo.getUseStatus_number()) != null && !"".equals(useStatus)) {
            EntityViewInfo entityView = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)useStatus));
            entityView.setFilter(filter);
            FaUseStatusCollection faUseStatusColl = FaUseStatusFactory.getLocalInstance((Context)ctx).getFaUseStatusCollection(entityView);
            if (faUseStatusColl == null || faUseStatusColl.size() <= 0) {
                throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + useStatus + "\u5bf9\u5e94\u7684\u4f7f\u7528\u72b6\u6001\uff01");
            }
        }
        if (!((faEconomicPurp = wsSCardInfo.getEconomicPurp_number()) == null || "".equals(faEconomicPurp) || (faEconomicColl = FaEconomicPurpFactory.getLocalInstance((Context)ctx).getFaEconomicPurpCollection("Where number = '" + faEconomicPurp + "'")) != null && faEconomicColl.size() > 0)) {
            throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + faEconomicPurp + "\u5bf9\u5e94\u7684\u7ecf\u6d4e\u7528\u9014\uff01");
        }
        String address = wsSCardInfo.getStoreCity_number();
        if (address != null && !"".equals(address)) {
            EntityViewInfo entityView = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)address));
            entityView.setFilter(filter);
            AddressCollection addressColl = AddressFactory.getLocalInstance((Context)ctx).getAddressCollection(entityView);
            if (addressColl == null || addressColl.size() <= 0) {
                throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + address + "\u5bf9\u5e94\u7684\u5b58\u653e\u5730\u70b9\uff01");
            }
        }
        String originType = wsSCardInfo.getOriginType();
        String originUnit = wsSCardInfo.getOriginUnit();
        if (originUnit != null && !"".equals(originUnit)) {
            CompanyOrgUnitCollection companyColl;
            CustomerCollection customerColl;
            SupplierCollection supplierColl;
            if (originType == null) {
                throw new Exception("\u8bf7\u5148\u586b\u5199\u6765\u6e90\u5355\u4f4d\u7c7b\u578b\uff01");
            }
            Integer originTypeInt = Integer.parseInt(originType);
            FaFromUnitCatEnum faFromUnitCat = FaFromUnitCatEnum.getEnum((int)originTypeInt);
            if (faFromUnitCat.equals((Object)FaFromUnitCatEnum.SUPPLIER) && ((supplierColl = SupplierFactory.getLocalInstance((Context)ctx).getSupplierCollection("Where number = '" + originUnit + "'")) == null || supplierColl.size() <= 0)) {
                throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + originUnit + "\u5bf9\u5e94\u7684\u4f9b\u5e94\u5546\uff01");
            }
            if (faFromUnitCat.equals((Object)FaFromUnitCatEnum.CUSTOMER) && ((customerColl = CustomerFactory.getLocalInstance((Context)ctx).getCustomerCollection("Where number = '" + originUnit + "'")) == null || customerColl.size() <= 0)) {
                throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + originUnit + "\u5bf9\u5e94\u7684\u5ba2\u6237\uff01");
            }
            if (faFromUnitCat.equals((Object)FaFromUnitCatEnum.INNER_COMPANY) && ((companyColl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection("Where number = '" + originUnit + "'")) == null || companyColl.size() <= 0)) {
                throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + originUnit + "\u5bf9\u5e94\u7684\u5185\u90e8\u516c\u53f8\uff01");
            }
        }
        if (!((deptNumber = wsSCardInfo.getDept_number()) == null || "".equals(deptNumber) || (adminOrgColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("Where number = '" + deptNumber + "'")) != null && adminOrgColl.size() > 0)) {
            throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + deptNumber + "\u5bf9\u5e94\u7684\u7ba1\u7406\u90e8\u95e8\uff01");
        }
        String keeper = wsSCardInfo.getKeeper_number();
        if (!(keeper == null || "".equals(keeper) || (personColl = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("Where number = '" + keeper + "'")) != null && personColl.size() > 0)) {
            throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + keeper + "\u5bf9\u5e94\u7684\u4fdd\u7ba1\u4eba\u5458\uff01");
        }
        String currencynum = wsSCardInfo.getCurrency_number();
        if (!(currencynum == null || "".equals(currencynum) || (currencyColl = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection("Where number = '" + currencynum + "'")) != null && currencyColl.size() > 0)) {
            throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + currencynum + "\u5bf9\u5e94\u7684\u5e01\u522b\uff01");
        }
    }

    private void checkBuildFaCardBillEntry(Context ctx, WSFaCurCardInfo wsSCardInfo, IObjectCollection depts) throws Exception {
        FaBizDepartmentCollection faCurDeparColl = new FaBizDepartmentCollection();
        for (int i = 0; i < depts.size(); ++i) {
            PersonCollection personColl;
            AdminOrgUnitCollection adminOrgColl;
            WsFaCurDeptInfo wsFaCurDeptInfo = (WsFaCurDeptInfo)depts.getObject(i);
            String useDepartNum = wsFaCurDeptInfo.getUseDepartment_number();
            if (!(useDepartNum == null || "".equals(useDepartNum) || (adminOrgColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("Where number = '" + useDepartNum + "'")) != null && adminOrgColl.size() > 0)) {
                throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + useDepartNum + "\u5bf9\u5e94\u7684\u4f7f\u7528\u90e8\u95e8\uff01");
            }
            String usePerson = wsFaCurDeptInfo.getUsePerson_number();
            if (usePerson == null || "".equals(usePerson) || (personColl = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("Where number = '" + usePerson + "'")) != null && personColl.size() > 0) continue;
            throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + usePerson + "\u5bf9\u5e94\u7684\u4f7f\u7528\u4eba\uff01");
        }
    }

    private FaBizCardInfo buildFaCardBill(Context ctx, WSFaCurCardInfo wsSCardInfo, FaBizCardInfo faBizCardInfo) throws Exception {
        String currencynum;
        String remark;
        String keeper;
        String deptNumber;
        String originUnit;
        String originType;
        String paperNo;
        String levFrDateStr;
        String mfr;
        String pArea;
        String specs;
        String address;
        String faEconomicPurp;
        String useStatus;
        String originMethod_number;
        if (wsSCardInfo.getId() != null && "".equals(wsSCardInfo.getId())) {
            faBizCardInfo.setId(BOSUuid.read((String)wsSCardInfo.getId()));
        }
        if (wsSCardInfo.getAssetCat_number() != null && !"".equals(wsSCardInfo.getAssetCat_number())) {
            FaCatCollection faCatColl = FaCatFactory.getLocalInstance((Context)ctx).getFaCatCollection("Where number = '" + wsSCardInfo.getAssetCat_number() + "'");
            if (faCatColl != null && faCatColl.size() > 0) {
                faBizCardInfo.setAssetCat(faCatColl.get(0));
            } else {
                throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + wsSCardInfo.getAssetCat_number() + "\u5bf9\u5e94\u7684\u8d44\u4ea7\u7c7b\u522b\uff01");
            }
        }
        if (wsSCardInfo.getNumber() != null && !"".equals(wsSCardInfo.getNumber())) {
            faBizCardInfo.setNumber(wsSCardInfo.getNumber());
        }
        if (wsSCardInfo.getOldNumber() != null && !"".equals(wsSCardInfo.getOldNumber())) {
            faBizCardInfo.setOldNumber(wsSCardInfo.getOldNumber());
        }
        if (wsSCardInfo.getAssetName() != null && !"".equals(wsSCardInfo.getAssetName())) {
            faBizCardInfo.setAssetName(wsSCardInfo.getAssetName());
        }
        if (wsSCardInfo.getAssetAmt() != null && !"".equals(wsSCardInfo.getAssetAmt())) {
            BigDecimal assetAmt = new BigDecimal(wsSCardInfo.getAssetAmt());
            faBizCardInfo.setAssetAmt(assetAmt);
        }
        if (wsSCardInfo.getMeasureUnit_number() != null && !"".equals(wsSCardInfo.getMeasureUnit_number())) {
            MeasureUnitCollection measureUnitColl = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection("Where number = '" + wsSCardInfo.getMeasureUnit_number() + "'");
            if (measureUnitColl != null && measureUnitColl.size() > 0) {
                faBizCardInfo.setMeasureUnit(measureUnitColl.get(0));
            } else {
                throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + wsSCardInfo.getMeasureUnit_number() + "\u5bf9\u5e94\u7684\u8ba1\u91cf\u5355\u4f4d\uff01");
            }
        }
        if (wsSCardInfo.getAccountDate() != null && !"".equals(wsSCardInfo.getAccountDate())) {
            Date accountDate = XMLUtil.convertStrToDate((String)wsSCardInfo.getAccountDate(), (String)"yyyy-MM-dd");
            faBizCardInfo.setAccountDate(accountDate);
        }
        if (wsSCardInfo.getFiAccountDate() != null && !"".equals(wsSCardInfo.getFiAccountDate())) {
            Date fiAccountDate = XMLUtil.convertStrToDate((String)wsSCardInfo.getFiAccountDate(), (String)"yyyy-MM-dd");
            faBizCardInfo.setFiAccountDate(fiAccountDate);
        }
        if ((originMethod_number = wsSCardInfo.getOriginMethod_number()) != null && !"".equals(originMethod_number)) {
            EntityViewInfo entityView = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)originMethod_number));
            entityView.setFilter(filter);
            FaAlterModeCollection faAlterModeColl = FaAlterModeFactory.getLocalInstance((Context)ctx).getFaAlterModeCollection(entityView);
            if (faAlterModeColl != null && faAlterModeColl.size() > 0) {
                faBizCardInfo.setOriginMethod(faAlterModeColl.get(0));
            } else {
                throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + originMethod_number + "\u5bf9\u5e94\u7684\u6765\u6e90\u65b9\u5f0f\uff01");
            }
        }
        if ((useStatus = wsSCardInfo.getUseStatus_number()) != null && !"".equals(useStatus)) {
            EntityViewInfo entityView = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)useStatus));
            entityView.setFilter(filter);
            FaUseStatusCollection faUseStatusColl = FaUseStatusFactory.getLocalInstance((Context)ctx).getFaUseStatusCollection(entityView);
            if (faUseStatusColl != null && faUseStatusColl.size() > 0) {
                faBizCardInfo.setUseStatus(faUseStatusColl.get(0));
            } else {
                throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + useStatus + "\u5bf9\u5e94\u7684\u4f7f\u7528\u72b6\u6001\uff01");
            }
        }
        if ((faEconomicPurp = wsSCardInfo.getEconomicPurp_number()) != null && !"".equals(faEconomicPurp)) {
            FaEconomicPurpCollection faEconomicColl = FaEconomicPurpFactory.getLocalInstance((Context)ctx).getFaEconomicPurpCollection("Where number = '" + faEconomicPurp + "'");
            if (faEconomicColl != null && faEconomicColl.size() > 0) {
                faBizCardInfo.setEconomicPurp(faEconomicColl.get(0));
            } else {
                throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + faEconomicPurp + "\u5bf9\u5e94\u7684\u7ecf\u6d4e\u7528\u9014\uff01");
            }
        }
        if ((address = wsSCardInfo.getStoreCity_number()) != null && !"".equals(address)) {
            EntityViewInfo entityView = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)address));
            entityView.setFilter(filter);
            AddressCollection addressColl = AddressFactory.getLocalInstance((Context)ctx).getAddressCollection(entityView);
            if (addressColl != null && addressColl.size() > 0) {
                faBizCardInfo.setStoreCity(addressColl.get(0));
            } else {
                throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + address + "\u5bf9\u5e94\u7684\u5b58\u653e\u5730\u70b9\uff01");
            }
        }
        if ((specs = wsSCardInfo.getSpecs()) != null && !"".equals(specs)) {
            faBizCardInfo.setSpecs(specs);
        }
        if ((pArea = wsSCardInfo.getPArea()) != null && !"".equals(pArea)) {
            faBizCardInfo.setPArea(pArea);
        }
        if ((mfr = wsSCardInfo.getMfr()) != null && !"".equals(mfr)) {
            faBizCardInfo.setMfr(mfr);
        }
        if ((levFrDateStr = wsSCardInfo.getLevFrDate()) != null && !"".equals(levFrDateStr)) {
            Date levFrDate = XMLUtil.convertStrToDate((String)levFrDateStr, (String)"yyyy-MM-dd");
            faBizCardInfo.setLevFrDate(levFrDate);
        }
        if ((paperNo = wsSCardInfo.getPaperNo()) != null && !"".equals(paperNo)) {
            faBizCardInfo.setPaperNo(paperNo);
        }
        if ((originType = wsSCardInfo.getOriginType()) != null && !"".equals(originType)) {
            Integer originTypeInt = Integer.parseInt(originType);
            FaFromUnitCatEnum faFromUnitCat = FaFromUnitCatEnum.getEnum((int)originTypeInt);
            faBizCardInfo.setOriginType(faFromUnitCat);
        }
        if ((originUnit = wsSCardInfo.getOriginUnit()) != null && !"".equals(originUnit)) {
            if (originType == null) {
                throw new Exception("\u8bf7\u5148\u586b\u5199\u6765\u6e90\u5355\u4f4d\u7c7b\u578b\uff01");
            }
            Integer originTypeInt = Integer.parseInt(originType);
            FaFromUnitCatEnum faFromUnitCat = FaFromUnitCatEnum.getEnum((int)originTypeInt);
            if (faFromUnitCat.equals((Object)FaFromUnitCatEnum.SUPPLIER)) {
                SupplierCollection supplierColl = SupplierFactory.getLocalInstance((Context)ctx).getSupplierCollection("Where number = '" + originUnit + "'");
                if (supplierColl != null && supplierColl.size() > 0) {
                    faBizCardInfo.setOriginUnit(supplierColl.get(0).getId().toString());
                } else {
                    throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + originUnit + "\u5bf9\u5e94\u7684\u4f9b\u5e94\u5546\uff01");
                }
            }
            if (faFromUnitCat.equals((Object)FaFromUnitCatEnum.CUSTOMER)) {
                CustomerCollection customerColl = CustomerFactory.getLocalInstance((Context)ctx).getCustomerCollection("Where number = '" + originUnit + "'");
                if (customerColl != null && customerColl.size() > 0) {
                    faBizCardInfo.setOriginUnit(customerColl.get(0).getId().toString());
                } else {
                    throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + originUnit + "\u5bf9\u5e94\u7684\u5ba2\u6237\uff01");
                }
            }
            if (faFromUnitCat.equals((Object)FaFromUnitCatEnum.INNER_COMPANY)) {
                CompanyOrgUnitCollection companyColl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection("Where number = '" + originUnit + "'");
                if (companyColl != null && companyColl.size() > 0) {
                    faBizCardInfo.setOriginUnit(companyColl.get(0).getId().toString());
                } else {
                    throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + originUnit + "\u5bf9\u5e94\u7684\u5185\u90e8\u516c\u53f8\uff01");
                }
            }
        }
        if ((deptNumber = wsSCardInfo.getDept_number()) != null && !"".equals(deptNumber)) {
            AdminOrgUnitCollection adminOrgColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("Where number = '" + deptNumber + "'");
            if (adminOrgColl != null && adminOrgColl.size() > 0) {
                faBizCardInfo.setDept(adminOrgColl.get(0));
            } else {
                throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + deptNumber + "\u5bf9\u5e94\u7684\u7ba1\u7406\u90e8\u95e8\uff01");
            }
        }
        if ((keeper = wsSCardInfo.getKeeper_number()) != null && !"".equals(keeper)) {
            PersonCollection personColl = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("Where number = '" + keeper + "'");
            if (personColl != null && personColl.size() > 0) {
                faBizCardInfo.setKeeper(personColl.get(0));
            } else {
                throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + keeper + "\u5bf9\u5e94\u7684\u4fdd\u7ba1\u4eba\u5458\uff01");
            }
        }
        if ((remark = wsSCardInfo.getRemark()) != null && !"".equals(remark)) {
            faBizCardInfo.setRemark(remark);
        }
        if ((currencynum = wsSCardInfo.getCurrency_number()) != null && !"".equals(currencynum)) {
            CurrencyCollection currencyColl = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection("Where number = '" + currencynum + "'");
            if (currencyColl != null && currencyColl.size() > 0) {
                faBizCardInfo.setCurrency(currencyColl.get(0));
            } else {
                throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + currencynum + "\u5bf9\u5e94\u7684\u5e01\u522b\uff01");
            }
        }
        return faBizCardInfo;
    }

    private FaBizCardInfo buildFaCardBillEntry(Context ctx, WSFaCurCardInfo wsSCardInfo, FaBizCardInfo faBizCardInfo, IObjectCollection depts) throws Exception {
        if (depts != null && depts.size() > 0) {
            faBizCardInfo.getFaBizDepartment().clear();
        }
        FaBizDepartmentCollection faCurDeparColl = new FaBizDepartmentCollection();
        for (int i = 0; i < depts.size(); ++i) {
            String remark;
            String usage;
            String usePerson;
            String useDepartNum;
            WsFaCurDeptInfo wsFaCurDeptInfo = (WsFaCurDeptInfo)depts.getObject(i);
            FaBizDepartmentInfo faBizDeptInfo = new FaBizDepartmentInfo();
            if (wsFaCurDeptInfo.getId() != null && !"".equals(wsFaCurDeptInfo.getId())) {
                faBizDeptInfo.setId(BOSUuid.read((String)wsFaCurDeptInfo.getId()));
            }
            if ((useDepartNum = wsFaCurDeptInfo.getUseDepartment_number()) != null && !"".equals(useDepartNum)) {
                AdminOrgUnitCollection adminOrgColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("Where number = '" + useDepartNum + "'");
                if (adminOrgColl != null && adminOrgColl.size() > 0) {
                    faBizDeptInfo.setUseDepartment(adminOrgColl.get(0));
                } else {
                    throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + useDepartNum + "\u5bf9\u5e94\u7684\u4f7f\u7528\u90e8\u95e8\uff01");
                }
            }
            if ((usePerson = wsFaCurDeptInfo.getUsePerson_number()) != null && !"".equals(usePerson)) {
                PersonCollection personColl = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("Where number = '" + usePerson + "'");
                if (personColl != null && personColl.size() > 0) {
                    faBizDeptInfo.setUsePerson(personColl.get(0));
                } else {
                    throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + usePerson + "\u5bf9\u5e94\u7684\u4f7f\u7528\u4eba\uff01");
                }
            }
            if ((usage = wsFaCurDeptInfo.getUsage()) != null && !"".equals(usage)) {
                faBizDeptInfo.setUsage(usage);
            }
            if ((remark = wsFaCurDeptInfo.getRemark()) != null && !"".equals(remark)) {
                faBizDeptInfo.setRemark(remark);
            }
            faCurDeparColl.add(faBizDeptInfo);
        }
        faBizCardInfo.getFaBizDepartment().addCollection(faCurDeparColl);
        return faBizCardInfo;
    }

    @Override
    protected String[] _importFaClearBill(Context ctx, IObjectValue wsfaClearBill, IObjectCollection faClearEntryColl) throws BOSException, EASBizException {
        System.out.print("---------------webservice start import FaClearBill-------------------");
        System.out.println(wsfaClearBill.getClass() + ":" + wsfaClearBill.toString() + ";");
        for (int i = 0; i < faClearEntryColl.size(); ++i) {
            System.out.println(faClearEntryColl.getClass() + ":" + faClearEntryColl.getObject(i).toString() + ";");
        }
        String[] msg = new String[3];
        try {
            this.setDefaultContext(ctx);
            WSFaClearBillInfo wsFaClearBillInfo = (WSFaClearBillInfo)wsfaClearBill;
            FaClearBillInfo faClearBill = new FaClearBillInfo();
            this.buildFaClearBill(ctx, faClearBill, wsFaClearBillInfo, faClearEntryColl);
            this.buildFaClearEntry(ctx, faClearBill, wsFaClearBillInfo, faClearEntryColl);
            FaClearBillFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)faClearBill);
            msg[0] = "Y";
            msg[1] = faClearBill.getId().toString();
            msg[2] = faClearBill.getNumber();
        }
        catch (BOSException e) {
            ImportException excep = new ImportException(new NumericExceptionSubItem("bosException", e.getMessage()));
            msg[0] = "N";
            msg[1] = excep.getMessage();
            msg[2] = null;
            logger.error((Object)excep);
            return msg;
        }
        catch (Exception e) {
            msg[0] = "N";
            msg[1] = e.getMessage();
            msg[2] = null;
            logger.error((Object)e);
            return msg;
        }
        return msg;
    }

    private FaClearBillInfo buildFaClearBill(Context ctx, FaClearBillInfo faClearBill, WSFaClearBillInfo wsFaClearBillInfo, IObjectCollection wsfaClearEntryColl) throws Exception {
        String createTimeStr;
        String clearMode;
        faClearBill.setCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
        faClearBill.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        faClearBill.setDescription(null);
        faClearBill.setDeletedStatus(DeletedStatusEnum.NORMAL);
        faClearBill.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        faClearBill.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        faClearBill.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        faClearBill.setFiVouchered(false);
        String clearDateStr = wsFaClearBillInfo.getClearDate();
        if (clearDateStr != null) {
            Date clearDate = XMLUtil.convertStrToDate((String)clearDateStr, (String)"yyyy-MM-dd");
            faClearBill.setClearDate(clearDate);
        }
        if ((clearMode = wsFaClearBillInfo.getClearMode()) == null || "".equals(clearMode)) {
            throw new BOSException("\u6e05\u7406\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)clearMode));
        entityView.setFilter(filter);
        FaAlterModeCollection faAlterModeColl = FaAlterModeFactory.getLocalInstance((Context)ctx).getFaAlterModeCollection(entityView);
        if (faAlterModeColl == null || faAlterModeColl.size() <= 0) {
            throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + clearMode + "\u5bf9\u5e94\u7684\u6e05\u7406\u65b9\u5f0f\uff01");
        }
        faClearBill.setClearMode(faAlterModeColl.get(0));
        String voncherAbstract = wsFaClearBillInfo.getVoncherAbstract();
        if (voncherAbstract == null || "".equals(voncherAbstract)) {
            throw new BOSException("\u6458\u8981\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        faClearBill.setVoucherAbstract(voncherAbstract);
        String creatorStr = wsFaClearBillInfo.getCreatorNumber();
        if (creatorStr != null) {
            UserCollection userColl = UserFactory.getLocalInstance((Context)ctx).getUserCollection("Where number = '" + creatorStr + "'");
            if (userColl != null && userColl.size() > 0) {
                faClearBill.setCreator(userColl.get(0));
            } else {
                throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + creatorStr + "\u5bf9\u5e94\u7684\u7528\u6237(\u521b\u5efa\u4eba)\uff01");
            }
        }
        if ((createTimeStr = wsFaClearBillInfo.getCreateTime()) != null) {
            Date createTime = XMLUtil.convertStrToDate((String)createTimeStr, (String)"yyyy-MM-dd");
            faClearBill.setCreateTime(new Timestamp(createTime.getTime()));
        }
        return faClearBill;
    }

    private FaClearBillInfo buildFaClearEntry(Context ctx, FaClearBillInfo faClearBill, WSFaClearBillInfo wsFaClearBillInfo, IObjectCollection wsfaClearEntryColl) throws Exception {
        if (wsfaClearEntryColl == null || wsfaClearEntryColl.size() <= 0) {
            throw new BOSException("\u6e05\u7406\u5355\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FaClearBillEntryCollection faClearEntryColl = new FaClearBillEntryCollection();
        for (int i = 0; i < wsfaClearEntryColl.size(); ++i) {
            String commentStr;
            String spilthDeal;
            String spilthIncomeStr;
            String priceStr;
            String spilthMoveInStr;
            FaClearBillEntryInfo faClearEntryInfo = new FaClearBillEntryInfo();
            WSFaClearEntryInfo wsFaClearEntryInfo = (WSFaClearEntryInfo)wsfaClearEntryColl.getObject(i);
            String faCardNumber = wsFaClearEntryInfo.getFaCardNumber();
            if (faCardNumber == null || "".equals(faCardNumber)) {
                throw new BOSException("\u5bfc\u5165\u6570\u636e\u7b2c" + (i + 1) + "\u884c\u5206\u5f55\u8d44\u4ea7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            FaCurCardCollection faCurCardColl = FaCurCardFactory.getLocalInstance((Context)ctx).getFaCurCardCollection("Where number = '" + faCardNumber + "'");
            if (faCurCardColl == null || faCurCardColl.size() <= 0) {
                throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + faCardNumber + "\u5bf9\u5e94\u7684\u56fa\u5b9a\u8d44\u4ea7\uff01");
            }
            faClearEntryInfo.put("faCurCard", (Object)faCurCardColl.get(0).getId().toString());
            faClearEntryInfo.setCurCard(faCurCardColl.get(0));
            faClearEntryInfo.put("cardUpdateTime", (Object)faCurCardColl.get(0).getLastUpdateTime());
            String clrQtyStr = wsFaClearEntryInfo.getClrQty();
            if (clrQtyStr == null || "".equals(clrQtyStr)) {
                throw new BOSException("\u5bfc\u5165\u6570\u636e\u7b2c" + (i + 1) + "\u884c\u5206\u5f55\u6e05\u7406\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            BigDecimal clrQty = new BigDecimal(clrQtyStr);
            faClearEntryInfo.setClrQty(clrQty);
            String clrFareStr = wsFaClearEntryInfo.getClrFare();
            if (clrFareStr != null) {
                BigDecimal clrFare = new BigDecimal(clrFareStr);
                faClearEntryInfo.setClrFare(clrFare);
            }
            if ((spilthMoveInStr = wsFaClearEntryInfo.getSpilthMoveIn()) != null) {
                BigDecimal spilthMoveIn = new BigDecimal(spilthMoveInStr);
                faClearEntryInfo.setSpilthMoveIn(spilthMoveIn);
            }
            if ((priceStr = wsFaClearEntryInfo.getPrice()) != null) {
                BigDecimal price = new BigDecimal(priceStr);
                faClearEntryInfo.setPrice(price);
            }
            if ((spilthIncomeStr = wsFaClearEntryInfo.getSpilthIncome()) != null) {
                BigDecimal spilthIncome = new BigDecimal(spilthIncomeStr);
                faClearEntryInfo.setSpilthIncome(spilthIncome);
            }
            if ((spilthDeal = wsFaClearEntryInfo.getSpilthDeal()) != null) {
                SplithDealModeEnum splithModeEnum = SplithDealModeEnum.getEnum((String)spilthDeal);
                faClearEntryInfo.setSplithDeal(splithModeEnum);
            }
            if ((commentStr = wsFaClearEntryInfo.getComment()) != null) {
                faClearEntryInfo.setComment(commentStr);
            }
            faClearEntryColl.add(faClearEntryInfo);
        }
        faClearBill.getClearBillEntry().addCollection(faClearEntryColl);
        return faClearBill;
    }

    @Override
    protected String[] _importAddressClass(Context ctx, IObjectValue wsAddressClass) throws BOSException, EASBizException {
        System.out.print("---------------webservice start import AddressClass-------------------");
        System.out.println(wsAddressClass.getClass() + ":" + wsAddressClass.toString() + ";");
        String[] msg = new String[3];
        try {
            this.setDefaultContext(ctx);
            WSAddressClassInfo wsAddressClassInfo = (WSAddressClassInfo)wsAddressClass;
            AddressClassInfo addressClassInfo = new AddressClassInfo();
            this.buildAddressClass(ctx, addressClassInfo, wsAddressClassInfo);
            AddressClassFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)addressClassInfo);
            msg[0] = "Y";
            msg[1] = addressClassInfo.getId().toString();
            msg[2] = addressClassInfo.getNumber();
        }
        catch (BOSException e) {
            ImportException excep = new ImportException(new NumericExceptionSubItem("bosException", e.getMessage()));
            msg[0] = "N";
            msg[1] = excep.getMessage();
            msg[2] = null;
            logger.error((Object)excep);
            return msg;
        }
        catch (Exception e) {
            msg[0] = "N";
            msg[1] = e.getMessage();
            msg[2] = null;
            logger.error((Object)e);
            return msg;
        }
        return msg;
    }

    private AddressClassInfo buildAddressClass(Context ctx, AddressClassInfo addressClassInfo, WSAddressClassInfo wsAddressClassInfo) throws Exception {
        String createTimeStr;
        String creatorStr;
        String parentNo;
        String name_l2;
        String numberStr = wsAddressClassInfo.getNumber();
        if (numberStr != null && !"".equals(numberStr)) {
            EntityViewInfo entityView = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)numberStr));
            entityView.setFilter(filter);
            AddressClassCollection addressClassColl = AddressClassFactory.getLocalInstance((Context)ctx).getAddressClassCollection(entityView);
            if (addressClassColl != null && addressClassColl.size() > 0) {
                throw new Exception("\u5df2\u5b58\u5728\u76f8\u540c\u7684\u5730\u5740\u7c7b\u522b\u7f16\u7801\uff01");
            }
        } else {
            throw new Exception("\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        addressClassInfo.setNumber(numberStr);
        String name_l1 = wsAddressClassInfo.getName_l1();
        if (name_l1 != null && !"".equals(name_l1)) {
            addressClassInfo.setName(name_l1, Locale.ENGLISH);
        }
        if ((name_l2 = wsAddressClassInfo.getName_l2()) == null || "".equals(name_l2)) {
            throw new Exception("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        addressClassInfo.setName(name_l2);
        String name_l3 = wsAddressClassInfo.getName_l3();
        if (name_l3 != null && !"".equals(name_l3)) {
            addressClassInfo.setName(name_l3, Locale.TRADITIONAL_CHINESE);
        }
        if ((parentNo = wsAddressClassInfo.getParent()) != null && !"".equals(parentNo)) {
            EntityViewInfo entityView = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)parentNo));
            entityView.setFilter(filter);
            AddressClassCollection addressClassColl = AddressClassFactory.getLocalInstance((Context)ctx).getAddressClassCollection(entityView);
            if (addressClassColl != null && addressClassColl.size() > 0) {
                addressClassInfo.setParent(addressClassColl.get(0));
            } else {
                throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + parentNo + "\u5bf9\u5e94\u7684\u5730\u5740\u7c7b\u522b(\u4e0a\u7ea7\u7f16\u7801)\uff01");
            }
        }
        if ((creatorStr = wsAddressClassInfo.getCreatorNumber()) != null) {
            UserCollection userColl = UserFactory.getLocalInstance((Context)ctx).getUserCollection("Where number = '" + creatorStr + "'");
            if (userColl != null && userColl.size() > 0) {
                addressClassInfo.setCreator(userColl.get(0));
            } else {
                throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + creatorStr + "\u5bf9\u5e94\u7684\u7528\u6237(\u521b\u5efa\u4eba)\uff01");
            }
        }
        if ((createTimeStr = wsAddressClassInfo.getCreateTime()) != null) {
            Date createTime = XMLUtil.convertStrToDate((String)createTimeStr, (String)"yyyy-MM-dd");
            addressClassInfo.setCreateTime(new Timestamp(createTime.getTime()));
        }
        return addressClassInfo;
    }

    @Override
    protected String[] _importAddress(Context ctx, IObjectCollection wsAddressColl) throws BOSException, EASBizException {
        System.out.print("---------------webservice start import Address-------------------");
        for (int i = 0; i < wsAddressColl.size(); ++i) {
            System.out.println(wsAddressColl.getObject(i).getClass() + ":" + wsAddressColl.getObject(i).toString() + ";");
        }
        String[] msg = new String[3];
        try {
            this.setDefaultContext(ctx);
            CoreBaseCollection corebasecollection = new CoreBaseCollection();
            this.buildAddress(ctx, corebasecollection, wsAddressColl);
            AddressFactory.getLocalInstance((Context)ctx).save(corebasecollection);
            StringBuffer id = new StringBuffer();
            StringBuffer number = new StringBuffer();
            for (int i = 0; i < corebasecollection.size(); ++i) {
                AddressInfo addressInfo = (AddressInfo)corebasecollection.get(i);
                if (i != corebasecollection.size() - 1) {
                    id.append(addressInfo.getId().toString()).append(",");
                    number.append(addressInfo.getId().toString()).append(",");
                    continue;
                }
                id.append(addressInfo.getId().toString());
                number.append(addressInfo.getId().toString());
            }
            msg[0] = "Y";
            msg[1] = id.toString();
            msg[2] = number.toString();
        }
        catch (Exception e) {
            msg[0] = "N";
            msg[1] = e.getMessage();
            msg[2] = null;
            logger.error((Object)e);
            return msg;
        }
        return msg;
    }

    private CoreBaseCollection buildAddress(Context ctx, CoreBaseCollection corebasecollection, IObjectCollection wsAddressColl) throws Exception {
        for (int i = 0; i < wsAddressColl.size(); ++i) {
            String createTimeStr;
            String creatorStr;
            String fax;
            String availTimeStr;
            String phone;
            String linkMan_l3;
            String linkMan_l2;
            String linkMan_l1;
            String webAddress;
            String postalCode;
            String languageId;
            String detailAddress_l3;
            String detailAddress_l2;
            String detailAddress_l1;
            String district;
            String cityId;
            String provinceId;
            AddressClassCollection addressClassColl;
            String classId;
            String name_l2;
            AddressInfo addressInfo = new AddressInfo();
            WSAddressInfo wsAddressInfo = (WSAddressInfo)wsAddressColl.getObject(i);
            String numberStr = wsAddressInfo.getNumber();
            if (numberStr != null && !"".equals(numberStr)) {
                EntityViewInfo entityView = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)numberStr));
                entityView.setFilter(filter);
                AddressCollection addressColl = AddressFactory.getLocalInstance((Context)ctx).getAddressCollection(entityView);
                if (addressColl != null && addressColl.size() > 0) {
                    throw new Exception("\u5df2\u5b58\u5728\u76f8\u540c\u7684\u5730\u5740\u7f16\u7801\uff01");
                }
            } else {
                throw new Exception("\u5bfc\u5165\u7b2c" + (i + 1) + "\u884c\u6570\u636e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            addressInfo.setNumber(numberStr);
            String name_l1 = wsAddressInfo.getName_l1();
            if (name_l1 != null && !"".equals(name_l1)) {
                addressInfo.setName(name_l1, Locale.ENGLISH);
            }
            if ((name_l2 = wsAddressInfo.getName_l2()) == null || "".equals(name_l2)) {
                throw new Exception("\u5bfc\u5165\u7b2c" + (i + 1) + "\u884c\u6570\u636e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            addressInfo.setName(name_l2);
            String name_l3 = wsAddressInfo.getName_l3();
            if (name_l3 != null && !"".equals(name_l3)) {
                addressInfo.setName(name_l3, Locale.TRADITIONAL_CHINESE);
            }
            if ((classId = wsAddressInfo.getClassID()) != null && !"".equals(classId)) {
                EntityViewInfo entityView = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)classId));
                entityView.setFilter(filter);
                addressClassColl = AddressClassFactory.getLocalInstance((Context)ctx).getAddressClassCollection(entityView);
                if (addressClassColl == null || addressClassColl.size() <= 0) {
                    throw new Exception("\u5bfc\u5165\u7b2c" + (i + 1) + "EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + classId + "\u5bf9\u5e94\u7684\u5730\u5740\u7c7b\u522b(\u4e0a\u7ea7\u7f16\u7801)\uff01");
                }
            } else {
                throw new Exception("\u5bfc\u5165\u7b2c" + (i + 1) + "\u884c\u6570\u636e\u5730\u5740\u7c7b\u522b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            addressInfo.setClassId(addressClassColl.get(0));
            String countryId = wsAddressInfo.getCountryID();
            if (countryId != null && !"".equals(countryId)) {
                CountryCollection countryColl = CountryFactory.getLocalInstance((Context)ctx).getCountryCollection("Where number = '" + countryId + "'");
                if (countryColl != null && countryColl.size() > 0) {
                    addressInfo.setCountryId(countryColl.get(0));
                } else {
                    throw new Exception("\u5bfc\u5165\u7b2c" + (i + 1) + "EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + classId + "\u5bf9\u5e94\u7684\u56fd\u5bb6\uff01");
                }
            }
            if ((provinceId = wsAddressInfo.getProvinceID()) != null && !"".equals(provinceId)) {
                EntityViewInfo entityView = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)provinceId));
                entityView.setFilter(filter);
                ProvinceCollection provinceColl = ProvinceFactory.getLocalInstance((Context)ctx).getProvinceCollection(entityView);
                if (provinceColl != null && provinceColl.size() > 0) {
                    addressInfo.setProvinceId(provinceColl.get(0));
                } else {
                    throw new Exception("\u5bfc\u5165\u7b2c" + (i + 1) + "EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + classId + "\u5bf9\u5e94\u7684\u7701\u4efd\uff01");
                }
            }
            if ((cityId = wsAddressInfo.getCity()) != null && !"".equals(cityId)) {
                EntityViewInfo entityView = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)cityId));
                entityView.setFilter(filter);
                CityCollection cityColl = CityFactory.getLocalInstance((Context)ctx).getCityCollection(entityView);
                if (cityColl != null && cityColl.size() > 0) {
                    addressInfo.setCityId(cityColl.get(0));
                } else {
                    throw new Exception("\u5bfc\u5165\u7b2c" + (i + 1) + "EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + classId + "\u5bf9\u5e94\u7684\u57ce\u5e02\uff01");
                }
            }
            if ((district = wsAddressInfo.getDistrict()) != null && !"".equals(district)) {
                EntityViewInfo entityView = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)district));
                entityView.setFilter(filter);
                RegionCollection regionColl = RegionFactory.getLocalInstance((Context)ctx).getRegionCollection(entityView);
                if (regionColl != null && regionColl.size() > 0) {
                    addressInfo.setDistrictId(regionColl.get(0));
                } else {
                    throw new Exception("\u5bfc\u5165\u7b2c" + (i + 1) + "EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + classId + "\u5bf9\u5e94\u7684\u533a\u53bf\uff01");
                }
            }
            if ((detailAddress_l1 = wsAddressInfo.getDetaillAddress_l1()) != null && !"".equals(detailAddress_l1)) {
                addressInfo.setDetailAddress(detailAddress_l1, Locale.ENGLISH);
            }
            if ((detailAddress_l2 = wsAddressInfo.getDetaillAddress_l2()) != null && !"".equals(detailAddress_l2)) {
                addressInfo.setDetailAddress(detailAddress_l2);
            }
            if ((detailAddress_l3 = wsAddressInfo.getDetaillAddress_l3()) != null && !"".equals(detailAddress_l3)) {
                addressInfo.setDetailAddress(detailAddress_l3, Locale.TRADITIONAL_CHINESE);
            }
            if ((languageId = wsAddressInfo.getLanguageID()) != null && !"".equals(languageId)) {
                EntityViewInfo entityView = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)languageId));
                entityView.setFilter(filter);
                LanguageCollection languageColl = LanguageFactory.getLocalInstance((Context)ctx).getLanguageCollection(entityView);
                if (languageColl != null && languageColl.size() > 0) {
                    addressInfo.setLanguageId(languageColl.get(0));
                } else {
                    throw new Exception("\u5bfc\u5165\u7b2c" + (i + 1) + "EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + languageId + "\u5bf9\u5e94\u7684\u8bed\u79cd\uff01");
                }
            }
            if ((postalCode = wsAddressInfo.getPostalCode()) != null && !"".equals(postalCode)) {
                addressInfo.setPostalCode(postalCode);
            }
            if ((webAddress = wsAddressInfo.getWebAddress()) != null && !"".equals(webAddress)) {
                addressInfo.setPostalAddress(webAddress);
            }
            if ((linkMan_l1 = wsAddressInfo.getLinkMan_l1()) != null && !"".equals(linkMan_l1)) {
                addressInfo.setLinkMan(linkMan_l1, Locale.ENGLISH);
            }
            if ((linkMan_l2 = wsAddressInfo.getLinkMan_l2()) != null && !"".equals(linkMan_l2)) {
                addressInfo.setLinkMan(linkMan_l2);
            }
            if ((linkMan_l3 = wsAddressInfo.getLinkMan_l3()) != null && !"".equals(linkMan_l3)) {
                addressInfo.setLinkMan(linkMan_l3, Locale.TRADITIONAL_CHINESE);
            }
            if ((phone = wsAddressInfo.getPhone()) != null && !"".equals(phone)) {
                addressInfo.setPhone(phone);
            }
            if ((availTimeStr = wsAddressInfo.getAvailTime()) != null && !"".equals(availTimeStr)) {
                Date availTime = XMLUtil.convertStrToDate((String)availTimeStr, (String)"yyyy-MM-dd");
                addressInfo.setAvailTime(availTime);
            }
            if ((fax = wsAddressInfo.getFax()) != null && !"".equals(fax)) {
                addressInfo.setFax(fax);
            }
            if ((creatorStr = wsAddressInfo.getCreatorNumber()) != null) {
                UserCollection userColl = UserFactory.getLocalInstance((Context)ctx).getUserCollection("Where number = '" + creatorStr + "'");
                if (userColl != null && userColl.size() > 0) {
                    addressInfo.setCreator(userColl.get(0));
                } else {
                    throw new Exception("\u5bfc\u5165\u7b2c" + (i + 1) + "EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + creatorStr + "\u5bf9\u5e94\u7684\u7528\u6237(\u521b\u5efa\u4eba)\uff01");
                }
            }
            if ((createTimeStr = wsAddressInfo.getCreatorTime()) != null) {
                Date createTime = XMLUtil.convertStrToDate((String)createTimeStr, (String)"yyyy-MM-dd");
                addressInfo.setCreateTime(new Timestamp(createTime.getTime()));
            }
            corebasecollection.add((CoreBaseInfo)addressInfo);
        }
        return corebasecollection;
    }

    @Override
    protected String[] _updateAddress(Context ctx, IObjectValue address) throws BOSException, EASBizException {
        System.out.print("---------------webservice start import Address-------------------");
        System.out.println(address.getClass() + ":" + address.toString() + ";");
        String[] msg = new String[3];
        try {
            AddressCollection addressColl;
            this.setDefaultContext(ctx);
            WSAddressInfo wsAddressInfo = (WSAddressInfo)address;
            String number = wsAddressInfo.getNumber();
            AddressInfo addressInfo = null;
            if (number != null && !"".equals(number)) {
                EntityViewInfo entityView = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
                entityView.setFilter(filter);
                addressColl = AddressFactory.getLocalInstance((Context)ctx).getAddressCollection(entityView);
                if (addressColl == null || addressColl.size() <= 0) {
                    throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + number + "\u5bf9\u5e94\u7684\u5730\u5740\uff01");
                }
            } else {
                throw new Exception("\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            addressInfo = addressColl.get(0);
            this.buildAddressInfo(ctx, addressInfo, wsAddressInfo);
            AddressFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(addressInfo.getId()), (CoreBaseInfo)addressInfo);
            ICacheService cacheService = CacheServiceFactory.getInstance();
            cacheService.discardType(new AddressInfo().getBOSType());
            msg[0] = "Y";
            msg[1] = addressInfo.getId().toString();
            msg[2] = addressInfo.getNumber().toString();
        }
        catch (Exception e) {
            msg[0] = "N";
            msg[1] = e.getMessage();
            msg[2] = null;
            logger.error((Object)e);
            return msg;
        }
        return msg;
    }

    private AddressInfo buildAddressInfo(Context ctx, AddressInfo addressInfo, WSAddressInfo wsAddressInfo) throws Exception {
        String createTimeStr;
        String creatorStr;
        String fax;
        String availTimeStr;
        String phone;
        String linkMan_l3;
        String linkMan_l2;
        String linkMan_l1;
        String webAddress;
        String postalCode;
        String languageId;
        String detailAddress_l3;
        String detailAddress_l2;
        String detailAddress_l1;
        String district;
        String cityId;
        String provinceId;
        AddressClassCollection addressClassColl;
        String classId;
        String name_l2;
        String name_l1 = wsAddressInfo.getName_l1();
        if (name_l1 != null && !"".equals(name_l1)) {
            addressInfo.setName(name_l1, Locale.ENGLISH);
        }
        if ((name_l2 = wsAddressInfo.getName_l2()) == null || "".equals(name_l2)) {
            throw new Exception("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        addressInfo.setName(name_l2);
        String name_l3 = wsAddressInfo.getName_l3();
        if (name_l3 != null && !"".equals(name_l3)) {
            addressInfo.setName(name_l3, Locale.TRADITIONAL_CHINESE);
        }
        if ((classId = wsAddressInfo.getClassID()) != null && !"".equals(classId)) {
            EntityViewInfo entityView = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)classId));
            entityView.setFilter(filter);
            addressClassColl = AddressClassFactory.getLocalInstance((Context)ctx).getAddressClassCollection(entityView);
            if (addressClassColl == null || addressClassColl.size() <= 0) {
                throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + classId + "\u5bf9\u5e94\u7684\u5730\u5740\u7c7b\u522b(\u4e0a\u7ea7\u7f16\u7801)\uff01");
            }
        } else {
            throw new Exception("\u5730\u5740\u7c7b\u522b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        addressInfo.setClassId(addressClassColl.get(0));
        String countryId = wsAddressInfo.getCountryID();
        if (countryId != null && !"".equals(countryId)) {
            CountryCollection countryColl = CountryFactory.getLocalInstance((Context)ctx).getCountryCollection("Where number = '" + countryId + "'");
            if (countryColl != null && countryColl.size() > 0) {
                addressInfo.setCountryId(countryColl.get(0));
            } else {
                throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + classId + "\u5bf9\u5e94\u7684\u56fd\u5bb6\uff01");
            }
        }
        if ((provinceId = wsAddressInfo.getProvinceID()) != null && !"".equals(provinceId)) {
            EntityViewInfo entityView = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)provinceId));
            entityView.setFilter(filter);
            ProvinceCollection provinceColl = ProvinceFactory.getLocalInstance((Context)ctx).getProvinceCollection(entityView);
            if (provinceColl != null && provinceColl.size() > 0) {
                addressInfo.setProvinceId(provinceColl.get(0));
            } else {
                throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + classId + "\u5bf9\u5e94\u7684\u7701\u4efd\uff01");
            }
        }
        if ((cityId = wsAddressInfo.getCity()) != null && !"".equals(cityId)) {
            EntityViewInfo entityView = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)cityId));
            entityView.setFilter(filter);
            CityCollection cityColl = CityFactory.getLocalInstance((Context)ctx).getCityCollection(entityView);
            if (cityColl != null && cityColl.size() > 0) {
                addressInfo.setCityId(cityColl.get(0));
            } else {
                throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + classId + "\u5bf9\u5e94\u7684\u57ce\u5e02\uff01");
            }
        }
        if ((district = wsAddressInfo.getDistrict()) != null && !"".equals(district)) {
            EntityViewInfo entityView = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)district));
            entityView.setFilter(filter);
            RegionCollection regionColl = RegionFactory.getLocalInstance((Context)ctx).getRegionCollection(entityView);
            if (regionColl != null && regionColl.size() > 0) {
                addressInfo.setDistrictId(regionColl.get(0));
            } else {
                throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + classId + "\u5bf9\u5e94\u7684\u533a\u53bf\uff01");
            }
        }
        if ((detailAddress_l1 = wsAddressInfo.getDetaillAddress_l1()) != null && !"".equals(detailAddress_l1)) {
            addressInfo.setDetailAddress(detailAddress_l1, Locale.ENGLISH);
        }
        if ((detailAddress_l2 = wsAddressInfo.getDetaillAddress_l2()) != null && !"".equals(detailAddress_l2)) {
            addressInfo.setDetailAddress(detailAddress_l2);
        }
        if ((detailAddress_l3 = wsAddressInfo.getDetaillAddress_l3()) != null && !"".equals(detailAddress_l3)) {
            addressInfo.setDetailAddress(detailAddress_l3, Locale.TRADITIONAL_CHINESE);
        }
        if ((languageId = wsAddressInfo.getLanguageID()) != null && !"".equals(languageId)) {
            EntityViewInfo entityView = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)languageId));
            entityView.setFilter(filter);
            LanguageCollection languageColl = LanguageFactory.getLocalInstance((Context)ctx).getLanguageCollection(entityView);
            if (languageColl != null && languageColl.size() > 0) {
                addressInfo.setLanguageId(languageColl.get(0));
            } else {
                throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + languageId + "\u5bf9\u5e94\u7684\u8bed\u79cd\uff01");
            }
        }
        if ((postalCode = wsAddressInfo.getPostalCode()) != null && !"".equals(postalCode)) {
            addressInfo.setPostalCode(postalCode);
        }
        if ((webAddress = wsAddressInfo.getWebAddress()) != null && !"".equals(webAddress)) {
            addressInfo.setPostalAddress(webAddress);
        }
        if ((linkMan_l1 = wsAddressInfo.getLinkMan_l1()) != null && !"".equals(linkMan_l1)) {
            addressInfo.setLinkMan(linkMan_l1, Locale.ENGLISH);
        }
        if ((linkMan_l2 = wsAddressInfo.getLinkMan_l2()) != null && !"".equals(linkMan_l2)) {
            addressInfo.setLinkMan(linkMan_l2);
        }
        if ((linkMan_l3 = wsAddressInfo.getLinkMan_l3()) != null && !"".equals(linkMan_l3)) {
            addressInfo.setLinkMan(linkMan_l3, Locale.TRADITIONAL_CHINESE);
        }
        if ((phone = wsAddressInfo.getPhone()) != null && !"".equals(phone)) {
            addressInfo.setPhone(phone);
        }
        if ((availTimeStr = wsAddressInfo.getAvailTime()) != null && !"".equals(availTimeStr)) {
            Date availTime = XMLUtil.convertStrToDate((String)availTimeStr, (String)"yyyy-MM-dd");
            addressInfo.setAvailTime(availTime);
        }
        if ((fax = wsAddressInfo.getFax()) != null && !"".equals(fax)) {
            addressInfo.setFax(fax);
        }
        if ((creatorStr = wsAddressInfo.getCreatorNumber()) != null) {
            UserCollection userColl = UserFactory.getLocalInstance((Context)ctx).getUserCollection("Where number = '" + creatorStr + "'");
            if (userColl != null && userColl.size() > 0) {
                addressInfo.setCreator(userColl.get(0));
            } else {
                throw new Exception("EAS\u4e2d\u4e0d\u5b58\u5728\u7f16\u53f7:" + creatorStr + "\u5bf9\u5e94\u7684\u7528\u6237(\u521b\u5efa\u4eba)\uff01");
            }
        }
        if ((createTimeStr = wsAddressInfo.getCreatorTime()) != null) {
            Date createTime = XMLUtil.convertStrToDate((String)createTimeStr, (String)"yyyy-MM-dd");
            addressInfo.setCreateTime(new Timestamp(createTime.getTime()));
        }
        return addressInfo;
    }

    public SelectorItemCollection getFaCurCardSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("measureUnit.*"));
        sic.add(new SelectorItemInfo("storeCity.*"));
        sic.add(new SelectorItemInfo("economicPurp.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("dept.*"));
        sic.add(new SelectorItemInfo("keeper.*"));
        sic.add(new SelectorItemInfo("originType"));
        sic.add(new SelectorItemInfo("originUnit.*"));
        sic.add(new SelectorItemInfo("originMethod.*"));
        sic.add(new SelectorItemInfo("useStatus.*"));
        sic.add(new SelectorItemInfo("deprMethod.*"));
        sic.add(new SelectorItemInfo("measureUnitWL.*"));
        sic.add(new SelectorItemInfo("evalDeprMode.*"));
        sic.add(new SelectorItemInfo("evalMeasureUnitWL.*"));
        sic.add(new SelectorItemInfo("accountAsset.*"));
        sic.add(new SelectorItemInfo("accountAccuDepr.*"));
        sic.add(new SelectorItemInfo("accountDecValue.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.accountView.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.remark"));
        sic.add(new SelectorItemInfo("faCurCostCenter.apportionScale"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.accountView.*"));
        sic.add(new SelectorItemInfo("faCurFacility.facilityNumber"));
        sic.add(new SelectorItemInfo("faCurFacility.facilityName"));
        sic.add(new SelectorItemInfo("faCurFacility.facilityModel"));
        sic.add(new SelectorItemInfo("faCurFacility.registerDate"));
        sic.add(new SelectorItemInfo("faCurFacility.storePlace.*"));
        sic.add(new SelectorItemInfo("faCurFacility.measureUnit.*"));
        sic.add(new SelectorItemInfo("faCurFacility.quantity"));
        sic.add(new SelectorItemInfo("faCurFacility.amount"));
        sic.add(new SelectorItemInfo("faCurFacility.keeper.*"));
        sic.add(new SelectorItemInfo("faCurFacility.remark"));
        sic.add(new SelectorItemInfo("faCurFacility.id"));
        sic.add(new SelectorItemInfo("faCurDepartment.useDepartment.*"));
        sic.add(new SelectorItemInfo("faCurDepartment.usePerson.*"));
        sic.add(new SelectorItemInfo("faCurDepartment.usage"));
        sic.add(new SelectorItemInfo("faCurDepartment.remark"));
        sic.add(new SelectorItemInfo("faCurDepartment.id"));
        sic.add(new SelectorItemInfo("assetCat.*"));
        sic.add(new SelectorItemInfo("creator.*"));
        SelectorItemCollection newSic = new SelectorItemCollection();
        for (int i = 0; i < sic.size(); ++i) {
            SelectorItemInfo selector = sic.get(i);
            if (selector.getPropertyName().endsWith(".*") && !selector.getPropertyName().equalsIgnoreCase("originUnit.*")) {
                String propName = selector.get("propertyName").toString();
                String prefix = propName.substring(0, propName.length() - 1);
                newSic.add(new SelectorItemInfo(prefix + "id"));
                newSic.add(new SelectorItemInfo(prefix + "name"));
                newSic.add(new SelectorItemInfo(prefix + "number"));
                continue;
            }
            newSic.add(selector);
        }
        newSic.add(new SelectorItemInfo("*"));
        newSic.add(new SelectorItemInfo("currency.id"));
        newSic.add(new SelectorItemInfo("currency.number"));
        newSic.add(new SelectorItemInfo("currency.name"));
        newSic.add(new SelectorItemInfo("currency.isoCode"));
        newSic.add(new SelectorItemInfo("currency.sign"));
        newSic.add(new SelectorItemInfo("currency.baseUnit"));
        newSic.add(new SelectorItemInfo("currency.precision"));
        newSic.add(new SelectorItemInfo("assetCat.isDeductInputTax"));
        newSic.add(new SelectorItemInfo("assetCat.isLeaf"));
        newSic.add(new SelectorItemInfo("assetCat.displayName"));
        newSic.add(new SelectorItemInfo("assetCat.calcuByEvaluate"));
        newSic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.*"));
        newSic.add(new SelectorItemInfo("assetCat.measureUnit.name"));
        newSic.add(new SelectorItemInfo("assetCat.measureUnit.number"));
        newSic.add(new SelectorItemInfo("assetCat.depreMode.number"));
        newSic.add(new SelectorItemInfo("assetCat.depreMode.name"));
        newSic.add(new SelectorItemInfo("assetCat.depreMode.isCustom"));
        newSic.add(new SelectorItemInfo("assetCat.depreMode.isWorkload"));
        newSic.add(new SelectorItemInfo("assetCat.classfication.*"));
        newSic.add(new SelectorItemInfo("assetCat.classfication.detailCollection.*"));
        newSic.add(new SelectorItemInfo("assetCat.classfication.number"));
        newSic.add(new SelectorItemInfo("assetCat.company.name"));
        newSic.add(new SelectorItemInfo("assetCat.creator.name"));
        newSic.add(new SelectorItemInfo("assetCat.creator.name"));
        newSic.add(new SelectorItemInfo("assetCat.creator.name"));
        newSic.add(new SelectorItemInfo("assetCat.creator.name"));
        newSic.add(new SelectorItemInfo("assetCat.id"));
        newSic.add(new SelectorItemInfo("assetCat.numberRule"));
        newSic.add(new SelectorItemInfo("assetCat.number"));
        newSic.add(new SelectorItemInfo("dept.id"));
        newSic.add(new SelectorItemInfo("dept.name"));
        newSic.add(new SelectorItemInfo("dept.number"));
        newSic.add(new SelectorItemInfo("CU.id"));
        newSic.add(new SelectorItemInfo("CU.name"));
        newSic.add(new SelectorItemInfo("CU.number"));
        newSic.add(new SelectorItemInfo("number"));
        newSic.add(new SelectorItemInfo("effectedStatus"));
        newSic.add(new SelectorItemInfo("originMethod.isLeaf"));
        newSic.add(new SelectorItemInfo("useStatus.isLeaf"));
        newSic.add(new SelectorItemInfo("useStatus.isDepreciation"));
        newSic.add(new SelectorItemInfo("economicPurp.isLeaf"));
        newSic.add(new SelectorItemInfo("dept.isLeaf"));
        newSic.add(new SelectorItemInfo("accountAsset.isLeaf"));
        newSic.add(new SelectorItemInfo("accountAccuDepr.isLeaf"));
        newSic.add(new SelectorItemInfo("accountDecValue.isLeaf"));
        newSic.add(new SelectorItemInfo("faCurFacility.seq"));
        newSic.add(new SelectorItemInfo("faCurDepartment.seq"));
        newSic.add(new SelectorItemInfo("faCurCostCenter.seq"));
        newSic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.*"));
        newSic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.*"));
        newSic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.*"));
        newSic.add(new SelectorItemInfo("faCurCostCenter.accountView.isLeaf"));
        newSic.add(new SelectorItemInfo("faCurCostCenter.accountView.longName"));
        newSic.add(new SelectorItemInfo("faCurCostCenter.accountView.name"));
        newSic.add(new SelectorItemInfo("accountAsset.longName"));
        newSic.add(new SelectorItemInfo("accountAccuDepr.longName"));
        newSic.add(new SelectorItemInfo("accountDecValue.longName"));
        newSic.add(new SelectorItemInfo("company.*"));
        newSic.add(new SelectorItemInfo("company.id"));
        newSic.add(new SelectorItemInfo("company.number"));
        newSic.add(new SelectorItemInfo("company.name"));
        newSic.add(new SelectorItemInfo("deprMethod.isCustom"));
        newSic.add(new SelectorItemInfo("deprMethod.isWorkload"));
        newSic.add(new SelectorItemInfo("period.beginDate"));
        newSic.add(new SelectorItemInfo("period.endDate"));
        newSic.add(new SelectorItemInfo("period.periodYear"));
        newSic.add(new SelectorItemInfo("period.periodNumber"));
        newSic.add(new SelectorItemInfo("faCurDepartment.useDepartment.displayName"));
        newSic.add(new SelectorItemInfo("evalDeprMode.isCustom"));
        newSic.add(new SelectorItemInfo("evalDeprMode.isWorkload"));
        return newSic;
    }
}

