/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.webservice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.emm.mm.mo.BillTypeStatusEnum;
import com.kingdee.eas.industry.emm.mm.mo.FaultHandlRecordFactory;
import com.kingdee.eas.industry.emm.mm.mo.FaultHandlRecordInfo;
import com.kingdee.eas.industry.emm.mm.mo.FaultRecordCollection;
import com.kingdee.eas.industry.emm.mm.mo.FaultRecordEntryCollection;
import com.kingdee.eas.industry.emm.mm.mo.FaultRecordEntryInfo;
import com.kingdee.eas.industry.emm.mm.mo.FaultRecordFactory;
import com.kingdee.eas.industry.emm.mm.mo.FaultRecordInfo;
import com.kingdee.eas.industry.emm.mm.mo.IFaultHandlRecord;
import com.kingdee.eas.industry.emm.mm.mo.IFaultRecord;
import com.kingdee.eas.industry.webservice.AbstractWsFaultRecordFacadeControllerBean;
import com.kingdee.eas.industry.webservice.WsFaultHandlRecordInfo;
import com.kingdee.eas.industry.webservice.WsFaultRecordCollection;
import com.kingdee.eas.industry.webservice.WsFaultRecordInfo;
import com.kingdee.eas.mm.basedata.FaultBaseTypeInfo;
import com.kingdee.eas.mm.basedata.FaultTypeFactory;
import com.kingdee.eas.mm.basedata.FaultTypeInfo;
import com.kingdee.eas.mm.basedata.IFaultType;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class WsFaultRecordFacadeControllerBean
extends AbstractWsFaultRecordFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.webservice.WsFaultRecordFacadeControllerBean");
    protected static final String isOK = "ok";
    protected static final String paremError_handl = "\u7b2cN\u6761\u6545\u969c\u5904\u7406\u4fe1\u606f";
    protected static final String paremError_record = "\u7b2cN\u6761\u6545\u969c\u4fe1\u606f";

    @Override
    protected String _faultSave(Context ctx, IObjectCollection coll) throws BOSException, EASBizException {
        if (coll == null || coll.size() == 0) {
            throw new BOSException("\u7f3a\u5c11\u6545\u969c\u4fe1\u606f\u53c2\u6570");
        }
        try {
            WsFaultRecordInfo wsinfo = (WsFaultRecordInfo)coll.getObject(0);
            String personid = wsinfo.getRepFaultPer();
            UserInfo userinfo = null;
            if (!StringUtils.isEmpty((String)personid)) {
                userinfo = this.getUserByPersonid(ctx, personid);
            }
            return this.faultBillSave(ctx, coll, userinfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException("WebService\u6545\u969c\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    protected UserInfo getUserByPersonid(Context ctx, String personid) throws BOSException {
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"SELECT FID FROM T_PM_User WHERE FPERSONID = ?", (Object[])new Object[]{personid});
            if (rs.next()) {
                return this.getUser(ctx, rs.getString("FID"));
            }
            throw new BOSException("\u5458\u5de5[FID:" + personid + "]\u65e0\u5bf9\u5e94\u7528\u6237\u4fe1\u606f");
        }
        catch (Exception e) {
            throw new BOSException("\u6839\u636e\u5458\u5de5[FID:" + personid + "]\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    protected UserInfo getUser(Context ctx, String id) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("person.number"));
        return UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(id), sic);
    }

    protected String faultBillSave(Context ctx, IObjectCollection col, UserInfo user) throws BOSException, EASBizException {
        int i;
        CoreBaseCollection coreBaseCol = new CoreBaseCollection();
        SelectorItemCollection sic_order = new SelectorItemCollection();
        sic_order.add(new SelectorItemInfo("technics.operationNo"));
        sic_order.add(new SelectorItemInfo("technics.workcenter"));
        String Sid = "'0'";
        Date now = new Date();
        IStorageOrgUnit isou = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
        IManufactureOrder imft = ManufactureOrderFactory.getLocalInstance((Context)ctx);
        IFaultType ift = FaultTypeFactory.getLocalInstance(ctx);
        IFaultRecord ifr = FaultRecordFactory.getLocalInstance(ctx);
        for (i = 0; i < col.size(); ++i) {
            WsFaultRecordInfo wsinfo = (WsFaultRecordInfo)col.getObject(i);
            FaultRecordInfo newInfo = new FaultRecordInfo();
            BOSUuid pk = null;
            if (StringUtils.isEmpty((String)wsinfo.getBillid())) {
                pk = BOSUuid.create((String)"404560F4");
                newInfo.setId(pk);
                String disTaskID = wsinfo.getDisTaskDispatchID();
                if (StringUtils.isEmpty((String)disTaskID)) {
                    throw new BOSException("\u7f3a\u5c11\u53c2\u6570\uff1a\u751f\u4ea7\u5de5\u827a");
                }
                String[] technics = disTaskID.split("[,;]");
                FaultRecordEntryCollection fres = newInfo.getEntry();
                int size = technics.length;
                for (int j = 0; j < size; ++j) {
                    if (StringUtils.isEmpty((String)technics[j])) continue;
                    FaultRecordEntryInfo ei = new FaultRecordEntryInfo();
                    ei.setParent(newInfo);
                    ManufactureOrderTechnicsInfo ti = new ManufactureOrderTechnicsInfo();
                    ti.setId(BOSUuid.read((String)technics[j]));
                    ei.setTechnics(ti);
                    ei.setSeq(j + 1);
                    fres.add(ei);
                }
                if (user != null) {
                    newInfo.setCreator(user);
                    newInfo.setLastUpdateUser(user);
                    newInfo.setRepFaultPer(user.getPerson());
                }
                newInfo.setRepFaultTime(now);
                newInfo.setBizDate(now);
                newInfo.setNumber(null);
            } else {
                newInfo = ifr.getFaultRecordInfo((IObjectPK)new ObjectUuidPK(wsinfo.getBillid()));
                pk = newInfo.getId();
            }
            Sid = Sid + ",'" + pk.toString() + "'";
            ObjectUuidPK orgunitpk = new ObjectUuidPK(wsinfo.getStorageOrgUnit());
            StorageOrgUnitInfo orgunitinfo = null;
            ObjectUuidPK orderpk = new ObjectUuidPK(wsinfo.getManuOrder());
            ManufactureOrderInfo orderinfo = null;
            orgunitinfo = isou.getStorageOrgUnitInfo((IObjectPK)orgunitpk);
            newInfo.setStorageOrgUnit(orgunitinfo);
            orderinfo = imft.getManufactureOrderInfo((IObjectPK)orderpk, sic_order);
            newInfo.setManuOrder(orderinfo);
            newInfo.setOperationNo(Integer.parseInt(wsinfo.getOperationNo()));
            int size = orderinfo.getTechnics().size();
            for (int j = 0; j < size; ++j) {
                ManufactureOrderTechnicsInfo mot = orderinfo.getTechnics().get(j);
                if (mot.getOperationNo() != newInfo.getOperationNo()) continue;
                newInfo.setWorkCenter(mot.getWorkcenter());
                break;
            }
            BillTypeStatusEnum typeenum = null;
            typeenum = wsinfo.getTypeStatus() == "\u672a\u89e3\u51b3" ? BillTypeStatusEnum.NO_TYPE : BillTypeStatusEnum.OK_TYPE;
            newInfo.setTypeStatus(typeenum);
            newInfo.setReNote(wsinfo.getReNote());
            if (StringUtils.isEmpty((String)wsinfo.getFolat())) {
                throw new BOSException("\u7f3a\u5c11\u53c2\u6570\uff1a\u6545\u969c\u539f\u56e0");
            }
            FaultTypeInfo typeInfo = ift.getFaultTypeInfo((IObjectPK)new ObjectUuidPK(wsinfo.getFolat()));
            newInfo.setFolat(typeInfo);
            newInfo.setFaultBaseType(typeInfo.getFaultBaseType());
            newInfo.setFolatNote(wsinfo.getFolatNote());
            newInfo.setRefmobilenumber(wsinfo.getNumber());
            if (StringUtils.isEmpty((String)wsinfo.getFaultBaseTypeID())) {
                throw new BOSException("\u7f3a\u5c11\u53c2\u6570\uff1a\u6545\u969c\u7c7b\u578b");
            }
            FaultBaseTypeInfo fbt = new FaultBaseTypeInfo();
            fbt.setId(BOSUuid.read((String)wsinfo.getFaultBaseTypeID()));
            newInfo.setFaultBaseType(fbt);
            newInfo.setMaterialQty(wsinfo.getMaterialQty());
            newInfo.setMaterialName(wsinfo.getMaterialName());
            newInfo.setMaterialNote(wsinfo.getMaterialNote());
            if (!StringUtils.isEmpty((String)wsinfo.getMaterialID())) {
                MaterialInfo material = new MaterialInfo();
                material.setId(BOSUuid.read((String)wsinfo.getMaterialID()));
                newInfo.setMaterial(material);
            }
            coreBaseCol.add((CoreBaseInfo)newInfo);
        }
        if (coreBaseCol.size() > 0) {
            int size = coreBaseCol.size();
            for (i = 0; i < size; ++i) {
                ifr.save(coreBaseCol.get(i));
            }
        } else {
            throw new BOSException("\u7f3a\u5c11\u6545\u969c\u4fe1\u606f\u53c2\u6570");
        }
        if (user != null) {
            String updateSQL = "update CT_MO_FaultRecord set flastupdateuserid = '" + user.getId().toString() + "' where fid in (" + Sid.toString() + ")";
            DbUtil.execute((Context)ctx, (String)updateSQL.toString());
        }
        return isOK;
    }

    public String _falutReq(Context ctx, WsFaultRecordCollection coll) throws BOSException, EASBizException {
        if (coll == null || coll.size() == 0) {
            throw new BOSException("\u7f3a\u5c11\u6545\u969c\u4fe1\u606f\u53c2\u6570");
        }
        String userid = "";
        String Sid = "'0'";
        ArrayList<String> listid = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            WsFaultRecordInfo wsinfo = (WsFaultRecordInfo)coll.getObject(i);
            listid.add(wsinfo.getBillid());
            Sid = Sid + ",'" + wsinfo.getBillid().toString() + "'";
            if (wsinfo.getSolvePer() == null || !StringUtils.isEmpty((String)userid)) continue;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("SELECT FID FROM T_PM_User WHERE FPERSONID = '" + wsinfo.getSolvePer().toString() + "'"));
            try {
                if (!rs.next()) continue;
                userid = rs.getString("fid");
                continue;
            }
            catch (SQLException e) {
                return "\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25";
            }
        }
        if (listid.size() <= 0) {
            return "\u8bf7\u68c0\u67e5\u662f\u5426\u9009\u4e2d\u6570\u636e\uff01 ";
        }
        try {
            FaultRecordFactory.getLocalInstance(ctx).falutReq(listid);
            String updateSQL = "update CT_MO_FaultRecord set flastupdateuserid = '" + userid + "' where fid in (" + Sid.toString() + ")";
            DbUtil.execute((Context)ctx, (String)updateSQL.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException("WebService\u89e3\u9664\u6545\u969c\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        return isOK;
    }

    @Override
    protected String _faultHandlRecordSave(Context ctx, IObjectCollection col) throws BOSException, EASBizException {
        if (col == null || col.size() == 0) {
            return "\u8c03\u7528\u63a5\u53e3\u5f02\u5e38\uff1a\u65e0\u6545\u969c\u5904\u7406\u4fe1\u606f";
        }
        CoreBaseCollection addCol = new CoreBaseCollection();
        CoreBaseCollection faultCol = new CoreBaseCollection();
        CoreBaseCollection technicsCol = new CoreBaseCollection();
        HashMap<String, FaultRecordInfo> faultMap = new HashMap<String, FaultRecordInfo>();
        WsFaultHandlRecordInfo ws = (WsFaultHandlRecordInfo)col.getObject(0);
        UserInfo user = null;
        if (!StringUtils.isEmpty((String)ws.getHandlePersonID())) {
            user = this.getUserByPersonid(ctx, ws.getHandlePersonID());
        }
        String Sid = "'0'";
        String Sid2 = "'0'";
        try {
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                IObjectValue o = col.getObject(i);
                int index = i + 1;
                if (o == null || !WsFaultHandlRecordInfo.class.isInstance(o)) {
                    throw new BOSException(paremError_handl.replace("N", String.valueOf(index)) + "\u6709\u8bef");
                }
                ws = (WsFaultHandlRecordInfo)o;
                FaultHandlRecordInfo info = this.getFaultHandlRecordInfo(ctx, ws, user);
                FaultRecordInfo fault = info.getFaultRecord();
                if (fault == null) {
                    throw new BOSException(paremError_handl.replace("N", String.valueOf(index)) + "\u65e0\u5bf9\u5e94\u7684\u6545\u969c\u8bb0\u5f55\u5355");
                }
                fault.setTypeStatus(info.getBaseStatus());
                faultMap.put(fault.getId().toString(), fault);
                Sid = Sid + ",'" + info.getId().toString() + "'";
                addCol.add((CoreBaseInfo)info);
            }
            if (addCol.size() > 0) {
                IFaultHandlRecord ifhr = FaultHandlRecordFactory.getLocalInstance(ctx);
                int size2 = addCol.size();
                for (int i = 0; i < size2; ++i) {
                    ifhr.addnew(addCol.get(i));
                }
            }
            IFaultRecord ifr = FaultRecordFactory.getLocalInstance(ctx);
            if (faultMap.size() > 0) {
                EntityViewInfo evi = new EntityViewInfo();
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add(new SelectorItemInfo("disTaskDispatchID"));
                evi.getSelector().add(new SelectorItemInfo("typeStatus"));
                evi.getSelector().add(new SelectorItemInfo("entry.*"));
                evi.setFilter(new FilterInfo());
                HashSet ids = new HashSet(faultMap.keySet());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
                FaultRecordCollection faults = ifr.getFaultRecordCollection(evi);
                if (faults.size() > 0) {
                    int size3 = faults.size();
                    for (int i = 0; i < size3; ++i) {
                        FaultRecordInfo fault = faults.get(i);
                        String key = fault.getId().toString();
                        Sid2 = Sid2 + ",'" + key + "'";
                        if (!faultMap.containsKey(key)) continue;
                        FaultRecordInfo upfault = (FaultRecordInfo)faultMap.get(key);
                        fault.setTypeStatus(upfault.getTypeStatus());
                        faultCol.add((CoreBaseInfo)fault);
                    }
                }
            }
            if (faultCol.size() > 0) {
                int size4 = faultCol.size();
                for (int i = 0; i < size4; ++i) {
                    ifr.update((IObjectPK)new ObjectUuidPK(faultCol.get(i).getId()), faultCol.get(i));
                }
            }
            if (user != null) {
                String updateSQL = "update CT_MO_FaultHandlRecord set flastupdateuserid = '" + user.getId().toString() + "' where fid in (" + Sid.toString() + ")";
                DbUtil.execute((Context)ctx, (String)updateSQL.toString());
                updateSQL = "update CT_MO_FaultRecord set flastupdateuserid = '" + user.getId().toString() + "' where fid in (" + Sid2.toString() + ")";
                DbUtil.execute((Context)ctx, (String)updateSQL.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException("WebService\u6545\u969c\u5904\u7406\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        return isOK;
    }

    protected FaultHandlRecordInfo getFaultHandlRecordInfo(Context ctx, WsFaultHandlRecordInfo ws, UserInfo user) {
        FaultHandlRecordInfo info = new FaultHandlRecordInfo();
        info.setHandlNote(ws.getHandlNote());
        PersonInfo person = new PersonInfo();
        person.setId(BOSUuid.read((String)ws.getHandlePersonID()));
        info.setRepFaultPer(person);
        info.setRepFaultTime(ws.getHandleTime());
        if (user != null) {
            info.setCreator(user);
            info.setLastUpdateUser(user);
        }
        Timestamp now = new Timestamp(new Date().getTime());
        info.setCreateTime(now);
        info.setLastUpdateTime(now);
        info.setId(BOSUuid.create((String)"844585CB"));
        if (!StringUtils.isEmpty((String)ws.getFaultRecordID())) {
            FaultRecordInfo fault = new FaultRecordInfo();
            fault.setId(BOSUuid.read((String)ws.getFaultRecordID()));
            info.setFaultRecord(fault);
        }
        BillTypeStatusEnum typeStatus = BillTypeStatusEnum.NO_TYPE;
        if (!StringUtils.isEmpty((String)ws.getBaseStatus())) {
            typeStatus = BillTypeStatusEnum.getEnum(ws.getBaseStatus());
            info.setBaseStatus(typeStatus);
        }
        return info;
    }

    @Override
    protected String _troubleshoot(Context ctx, IObjectCollection col) throws BOSException, EASBizException {
        String Sid = "'0'";
        CoreBaseCollection faultCol = new CoreBaseCollection();
        HashMap<String, WsFaultRecordInfo> faultMap = new HashMap<String, WsFaultRecordInfo>();
        WsFaultRecordInfo wsinfo = (WsFaultRecordInfo)col.getObject(0);
        UserInfo user = null;
        if (StringUtils.isEmpty((String)wsinfo.getSolvePer())) {
            return "\u65e0\u5bf9\u5e94\u7684\u6545\u969c\u89e3\u51b3\u4eba";
        }
        user = this.getUserByPersonid(ctx, wsinfo.getSolvePer());
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            wsinfo = (WsFaultRecordInfo)col.getObject(i);
            faultMap.put(wsinfo.getFaultRecodeID(), wsinfo);
        }
        try {
            IFaultRecord ifr = FaultRecordFactory.getLocalInstance(ctx);
            if (faultMap.size() > 0) {
                EntityViewInfo evi = new EntityViewInfo();
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add(new SelectorItemInfo("disTaskDispatchID"));
                evi.getSelector().add(new SelectorItemInfo("typeStatus"));
                evi.getSelector().add(new SelectorItemInfo("entry.*"));
                evi.setFilter(new FilterInfo());
                HashSet ids = new HashSet(faultMap.keySet());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
                FaultRecordCollection faults = ifr.getFaultRecordCollection(evi);
                if (faults.size() > 0) {
                    int size2 = faults.size();
                    for (int i = 0; i < size2; ++i) {
                        FaultRecordInfo fault = faults.get(i);
                        String key = fault.getId().toString();
                        Sid = Sid + ",'" + key + "'";
                        fault.setTypeStatus(BillTypeStatusEnum.OK_TYPE);
                        wsinfo = (WsFaultRecordInfo)faultMap.get(key);
                        PersonInfo person = new PersonInfo();
                        person.setId(BOSUuid.read((String)wsinfo.getSolvePer()));
                        fault.setSolvePer(person);
                        fault.setSolveTime(new Date());
                        faultCol.add((CoreBaseInfo)fault);
                    }
                }
            }
            if (faultCol.size() > 0) {
                int size3 = faultCol.size();
                for (int i = 0; i < size3; ++i) {
                    ifr.update((IObjectPK)new ObjectUuidPK(faultCol.get(i).getId()), faultCol.get(i));
                }
            }
            if (user != null) {
                String updateSQL = "update CT_MO_FaultRecord set flastupdateuserid = '" + user.getId().toString() + "' where fid in (" + Sid.toString() + ")";
                DbUtil.execute((Context)ctx, (String)updateSQL.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException("WebService\u6545\u969c\u6392\u9664\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        return isOK;
    }

    @Override
    protected String _deleteFaultRecord(Context ctx, IObjectCollection col) throws BOSException, EASBizException {
        HashMap<String, WsFaultRecordInfo> faultMap = new HashMap<String, WsFaultRecordInfo>();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            WsFaultRecordInfo wsinfo = (WsFaultRecordInfo)col.getObject(i);
            faultMap.put(wsinfo.getDisTaskDispatchID(), wsinfo);
        }
        IFaultRecord ifr = FaultRecordFactory.getLocalInstance(ctx);
        IObjectPK[] pks = null;
        if (faultMap.size() > 0) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add(new SelectorItemInfo("disTaskDispatchID"));
            evi.getSelector().add(new SelectorItemInfo("typeStatus"));
            evi.setFilter(new FilterInfo());
            HashSet distaskids = new HashSet(faultMap.keySet());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("disTaskDispatchID", distaskids, CompareType.INCLUDE));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("typeStatus", (Object)"1"));
            FaultRecordCollection faults = ifr.getFaultRecordCollection(evi);
            if (faults.size() > 0) {
                int size2 = faults.size();
                pks = new IObjectPK[size2];
                for (int i = 0; i < size2; ++i) {
                    FaultRecordInfo fault = faults.get(i);
                    ObjectUuidPK pk = new ObjectUuidPK(fault.getId());
                    pks[i] = pk;
                }
            }
        }
        if (pks != null && pks.length > 0) {
            ifr.delete(pks);
        }
        return isOK;
    }
}

