/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.industry.emm.common.client.OprtState;
import com.kingdee.eas.industry.util.MutexControl;
import com.kingdee.eas.mm.basedata.BomChangeBillStatusEnum;
import com.kingdee.eas.mm.basedata.BomChangeCollection;
import com.kingdee.eas.mm.basedata.BomChangeFactory;
import com.kingdee.eas.mm.basedata.BomChangeInfo;
import com.kingdee.eas.mm.basedata.IBomChange;
import com.kingdee.eas.mm.basedata.client.AbstractBomChangeListUI;
import com.kingdee.eas.mm.basedata.client.BomChangeFilterUI;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.client.ISCMFilter;
import com.kingdee.eas.scm.common.client.SCMCommonProcessor;
import com.kingdee.eas.scm.common.client.SCMPromptBoxFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.eas.zjbom.convert.BomChangeBillAuditFacadeFactory;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class BomChangeListUI
extends AbstractBomChangeListUI {
    private static final Logger logger = CoreUIObject.getLogger(BomChangeListUI.class);
    public CommonQueryDialog commonQueryDialog = null;
    protected BomChangeFilterUI filterUI = null;

    protected boolean initDefaultFilter() {
        return true;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQueryDialog == null) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            this.commonQueryDialog = super.initCommonQueryDialog();
            this.commonQueryDialog.setWidth(450);
            this.commonQueryDialog.setHeight(320);
            try {
                SCMPromptBoxFactory scmF7Factory = new SCMPromptBoxFactory(this.getFilterUI(), this.getMainBizOrgType());
                this.commonQueryDialog.setPromptBoxFactory((IPromptBoxFactory)scmF7Factory);
                this.commonQueryDialog.setProcessor((IProcessor)new SCMCommonProcessor());
                ISCMFilter iFilter = (ISCMFilter)this.getFilterUI();
                if (this.getBOTPViewStatus() == 1) {
                    iFilter.setBOTPFilter((Map)((HashMap)this.getUIContext().get("BTPEDITPARAMETER")));
                }
                iFilter.setIsSupportMultiOrgs(false);
                iFilter.setContextObject(null);
                iFilter.setAuthorizedMainOrgs(null);
                this.commonQueryDialog.addUserPanel((KDPanel)this.getFilterUI());
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
        return this.commonQueryDialog;
    }

    public CustomerQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new BomChangeFilterUI();
        }
        return this.filterUI;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return BomChangeFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        BomChangeInfo objectValue = new BomChangeInfo();
        return objectValue;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.btnAudit.setEnabled(true);
        this.btnSubmit.setEnabled(true);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        BomChangeInfo info = BomChangeFactory.getRemoteInstance().getBomChangeInfo("select baseStatus where id = '" + id + "'");
        if (info.getBaseStatus().equals((Object)BomChangeBillStatusEnum.AUDIT)) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getResource("bomchange_msg_22"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("designMode.*"));
        sic.add(new SelectorItemInfo("bom.*"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("oldunit.id"));
        sic.add(new SelectorItemInfo("oldunit.number"));
        sic.add(new SelectorItemInfo("oldunit.name"));
        sic.add(new SelectorItemInfo("material.*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.*"));
        sic.add(new SelectorItemInfo("project.*"));
        sic.add(new SelectorItemInfo("oldProject.*"));
        sic.add(new SelectorItemInfo("changePerson.*"));
        sic.add(new SelectorItemInfo("department.*"));
        sic.add(new SelectorItemInfo("NewEntry.*"));
        sic.add(new SelectorItemInfo("OldEntry.*"));
        sic.add(new SelectorItemInfo("NewEntry.material.*"));
        sic.add(new SelectorItemInfo("NewEntry.material.baseUnit.*"));
        sic.add(new SelectorItemInfo("NewEntry.supplyOrgUnit.*"));
        sic.add(new SelectorItemInfo("NewEntry.defaultWarehouse.*"));
        sic.add(new SelectorItemInfo("NewEntry.location.*"));
        sic.add(new SelectorItemInfo("NewEntry.transferOrgUnit.*"));
        sic.add(new SelectorItemInfo("NewEntry.transferWarehouse.*"));
        sic.add(new SelectorItemInfo("NewEntry.beginCarno.*"));
        sic.add(new SelectorItemInfo("NewEntry.endCarno.*"));
        sic.add(new SelectorItemInfo("NewEntry.unit.*"));
        sic.add(new SelectorItemInfo("OldEntry.material.*"));
        sic.add(new SelectorItemInfo("OldEntry.material.baseUnit.*"));
        sic.add(new SelectorItemInfo("OldEntry.supplyOrgUnit.*"));
        sic.add(new SelectorItemInfo("OldEntry.defaultWarehouse.*"));
        sic.add(new SelectorItemInfo("OldEntry.location.*"));
        sic.add(new SelectorItemInfo("OldEntry.transferOrgUnit.*"));
        sic.add(new SelectorItemInfo("OldEntry.transferWarehouse.*"));
        sic.add(new SelectorItemInfo("OldEntry.beginCarno.*"));
        sic.add(new SelectorItemInfo("OldEntry.endCarno.*"));
        sic.add(new SelectorItemInfo("OldEntry.unit.*"));
        return sic;
    }

    protected boolean isAuditAfterSubmit(String billTypeId, String orgUnitID, int orgType) throws BOSException, EASBizException {
        ISCMBillParam scmParam;
        String strAutoAudit;
        boolean isAutoAudit = false;
        if (billTypeId != null && (strAutoAudit = (scmParam = SCMBillParamFactory.getRemoteInstance()).getParamByBillTypeID("BOMChange_Submit", orgType, orgUnitID, billTypeId)) != null && strAutoAudit.trim().length() != 0 && strAutoAudit.trim().toLowerCase().equals("1")) {
            isAutoAudit = true;
        }
        return isAutoAudit;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(this.getSelectors());
        BomChangeCollection bomColl = BomChangeFactory.getRemoteInstance().getBomChangeCollection(viewInfo);
        String errorString = "";
        for (int i = 0; i < bomColl.size(); ++i) {
            IObjectPK pk = null;
            BomChangeInfo info = bomColl.get(i);
            try {
                pk = BomChangeFactory.getRemoteInstance().submit((CoreBaseInfo)info);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                errorString = errorString + " " + e1.getMessage() + "\r\n";
                continue;
            }
            StorageOrgUnitInfo sinfo = info.getStorageOrgUnit();
            boolean continueFlag = this.isAuditAfterSubmit("+yC28RLbTf+lDdmpRX68vEY+1VI=", sinfo.getId().toString(), 4);
            try {
                if (!continueFlag) continue;
                BomChangeBillAuditFacadeFactory.getRemoteInstance().bomBillChangeAudit(pk.toString());
                continue;
            }
            catch (Exception e1) {
                e1.printStackTrace();
                errorString = errorString + info.getNumber() + " " + e1.getMessage() + "\r\n";
            }
        }
        if (errorString != null && !"".equals(errorString)) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)this.getResource("bomchange_msg_35"), (String)errorString, (int)1);
        }
        this.refreshList();
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getResource("bomchange_msg_30"));
            SysUtil.abort();
        }
        BomChangeInfo info = null;
        IBomChange ibt = BomChangeFactory.getRemoteInstance();
        for (int i = 0; i < idList.size(); ++i) {
            info = ibt.getBomChangeInfo("select number,baseStatus where id = '" + idList.get(i) + "'");
            if (!info.getBaseStatus().equals((Object)BomChangeBillStatusEnum.AUDIT)) continue;
            MsgBox.showError((String)(this.getResource("bomchange_msg_37") + info.getNumber() + this.getResource("bomchange_msg_38")));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    private String getResource(String number) {
        return EASResource.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)number);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList<String> idList = new ArrayList<String>();
        int size = this.tblMain.getSelectManager().size();
        MutexControl mc = new MutexControl();
        try {
            for (int i = 0; i < size; ++i) {
                KDTSelectBlock block = this.tblMain.getSelectManager().get(i);
                for (int j = block.getTop(); j <= block.getBottom(); ++j) {
                    String id = (String)this.tblMain.getCell(j, "id").getValue();
                    idList.add(id);
                    boolean is = mc.addMutex(id);
                    if (is) continue;
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"EMMZJBOM-880-DESIGNBOM_0003", (Object[])new Object[]{j + 1}));
                    SysUtil.abort();
                }
            }
            if (idList.size() > 0) {
                UIContext uiContext = new UIContext();
                IUIWindow uiWindow = null;
                String uiClass = "com.kingdee.eas.zjbom.convert.client.BomChangeAuditUI";
                uiContext.put((Object)"bomChangeIDList", idList);
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.zjbom.convert.client.BomChangeAuditUI", (Map)uiContext, null, OprtState.ADDNEW);
                uiWindow.show();
                this.tblMain.refresh();
            }
        }
        finally {
            mc.finallys();
        }
    }
}

