/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.scm.sm.ConsignmentScheduleCbInfo;
import com.kingdee.eas.industry.emm.scm.sm.ConsignmentScheduleFactory;
import com.kingdee.eas.industry.emm.scm.sm.ConsignmentScheduleInfo;
import com.kingdee.eas.mm.mo.CalculateResultScopeVO;
import com.kingdee.eas.mm.mo.DeliveryPlanSingletonFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class DeliveryPlanSingleton {
    private static DeliveryPlanSingleton instance;
    private static HashMap<String, HashMap<String, BigDecimal>> mapDeliveryPlan;
    String queryDeliveryPlanSqlNoAll = " select a.fid,a.fneeddate,  b.fprojectid,  a.fmaterialid,  a.fproduceorgid,  a.cftracknumberid,  a.fneedamt - a.fwarehouseamt fqty  from t_sm_consignmentschedule a left join t_sm_purorderentry b on a.fparentid = b.fid  where a.fneeddate between ? and ? and a.fbasestatus = 4 ";
    private Context ctx;

    private DeliveryPlanSingleton(Context _ctx) throws BOSException, EASBizException {
        this.ctx = _ctx;
        this.initDeliveryPlanSingleton();
    }

    public static synchronized DeliveryPlanSingleton getInstance(Context ctx) throws BOSException, EASBizException {
        if (instance == null) {
            instance = new DeliveryPlanSingleton(ctx);
        }
        return instance;
    }

    public void clear() {
        instance = null;
        mapDeliveryPlan.clear();
    }

    public void initDeliveryPlanSingleton() throws BOSException, EASBizException {
        Timestamp startDate = (Timestamp)this.ctx.get((Object)"STARTDATE");
        Timestamp endDate = (Timestamp)this.ctx.get((Object)"ENDDATE");
        String solatedrule = null;
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)this.queryDeliveryPlanSqlNoAll, (Object[])new Object[]{startDate, endDate});
        String hashcode = null;
        try {
            while (rs.next()) {
                String id = rs.getString("fid");
                Timestamp stamp = rs.getTimestamp("fneeddate");
                String strStamp = this.timeStampToString(stamp);
                String materialid = rs.getString("fmaterialid");
                String produceorgid = rs.getString("fproduceorgid");
                String projectid = rs.getString("fprojectid") == null ? "" : rs.getString("fprojectid");
                String trackid = rs.getString("cftracknumberid") == null ? "" : rs.getString("cftracknumberid");
                BigDecimal qty = rs.getBigDecimal("fqty");
                solatedrule = DeliveryPlanSingletonFactory.getInventoryMaterialSingleton(this.ctx).getSolatedRule(materialid, produceorgid);
                hashcode = solatedrule == null || "NONE".equals(solatedrule) ? materialid.hashCode() + "" + produceorgid.hashCode() + strStamp.hashCode() : ("ITEM".equals(solatedrule) ? materialid.hashCode() + "" + produceorgid.hashCode() + "" + projectid.hashCode() + strStamp.hashCode() : materialid.hashCode() + "" + produceorgid.hashCode() + "" + projectid.hashCode() + "" + trackid.hashCode() + "" + strStamp.hashCode());
                if (mapDeliveryPlan.get(hashcode) == null) {
                    HashMap<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>();
                    qtyMap.put(id, qty);
                    mapDeliveryPlan.put(hashcode, qtyMap);
                    continue;
                }
                mapDeliveryPlan.get(hashcode).put(id, qty);
            }
        }
        catch (Exception ex) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.mm.mo.EMMEMMoResource", (String)"0EMMMO-0112", (Locale)this.ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.mm.mo.EMMEMMoResource", (String)"0EMMMO-0113", (Locale)this.ctx.getLocale())));
        }
    }

    private BigDecimal calcuteDeliveryQty(HashMap<String, BigDecimal> map) {
        Iterator<Map.Entry<String, BigDecimal>> iter = map.entrySet().iterator();
        BigDecimal qty = BigDecimal.ZERO;
        while (iter.hasNext()) {
            Map.Entry<String, BigDecimal> obj = iter.next();
            qty = qty.add(obj.getValue());
        }
        return qty;
    }

    private HashMap<String, BigDecimal> subtractDeliveryQty(HashMap<String, BigDecimal> map, BigDecimal actqty) {
        return map;
    }

    public void getDeliveryPlanQty(CalculateResultScopeVO vo) throws BOSException, EASBizException {
        BigDecimal deliveryplanqty = BigDecimal.ZERO;
        String solatedrule = vo.getSolatedrule();
        Date stamp = vo.getReqDate();
        String strStamp = this.dateToString(stamp);
        String materialid = vo.getMaterialid();
        String produceorgid = vo.getStorageorgid();
        String projectid = vo.getProjectid() == null ? "" : vo.getProjectid();
        String trackid = vo.getTracknumberid() == null ? "" : vo.getTracknumberid();
        String hashcode = null;
        hashcode = solatedrule == null || "NONE".equals(solatedrule) ? materialid.hashCode() + "" + produceorgid.hashCode() + strStamp.hashCode() : ("ITEM".equals(solatedrule) ? materialid.hashCode() + "" + produceorgid.hashCode() + "" + projectid.hashCode() + strStamp.hashCode() : materialid.hashCode() + "" + produceorgid.hashCode() + "" + projectid.hashCode() + "" + trackid.hashCode() + "" + strStamp.hashCode());
        if (mapDeliveryPlan.get(hashcode) != null) {
            deliveryplanqty = this.calcuteDeliveryQty(mapDeliveryPlan.get(hashcode));
            vo.setExistdeliveryplanpks(this.calcualteExistDeliveryPlan(mapDeliveryPlan.get(hashcode)));
        }
        BigDecimal actualqty = BigDecimal.ZERO;
        if (deliveryplanqty.doubleValue() == vo.getActqty().doubleValue()) {
            mapDeliveryPlan.put(hashcode, new HashMap());
            actualqty = BigDecimal.ZERO;
        } else if (deliveryplanqty.doubleValue() > vo.getActqty().doubleValue()) {
            mapDeliveryPlan.put(hashcode, this.subtractDeliveryQty(mapDeliveryPlan.get(hashcode), vo.getActqty()));
            actualqty = BigDecimal.ZERO;
            this.markDeliveryPlanChange(this.ctx, vo, mapDeliveryPlan.get(hashcode), deliveryplanqty.subtract(vo.getActqty()));
        } else {
            mapDeliveryPlan.put(hashcode, new HashMap());
            actualqty = vo.getActqty().subtract(deliveryplanqty);
        }
        vo.setActDeliveryqty(deliveryplanqty);
        vo.setActqty(actualqty);
    }

    private String calcualteExistDeliveryPlan(HashMap<String, BigDecimal> map) {
        StringBuffer sbStr = new StringBuffer();
        for (Map.Entry<String, BigDecimal> obj : map.entrySet()) {
            String pks = obj.getKey();
            sbStr.append("'").append(pks).append("',");
        }
        sbStr.append("''");
        return sbStr.toString();
    }

    public void markDeliveryPlanChange(Context ctx, CalculateResultScopeVO vo, HashMap<String, BigDecimal> parentMap, BigDecimal _qty) throws BOSException, EASBizException {
        for (Map.Entry<String, BigDecimal> obj : parentMap.entrySet()) {
            ConsignmentScheduleInfo sinfo;
            ConsignmentScheduleCbInfo info;
            String parentid = obj.getKey();
            BigDecimal qty = obj.getValue();
            if (_qty.compareTo(BigDecimal.ZERO) <= 0) continue;
            if (_qty.compareTo(qty) >= 0) {
                info = new ConsignmentScheduleCbInfo();
                info.setBasestatus(1);
                sinfo = ConsignmentScheduleFactory.getLocalInstance((Context)ctx).getConsignmentScheduleInfo((IObjectPK)new ObjectUuidPK(parentid));
                info.setMaterialid(vo.getMaterialid());
                info.setParentid(parentid);
                info.setNeedAmt(qty.multiply(new BigDecimal(-1)));
                info.setNeedDate((java.util.Date)vo.getReqDate());
                info.setPreNeedDate(sinfo.getNeedDate());
                info.setPreNeedAmt(sinfo.getNeedAmt());
                info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
                vo.getConsignmentCbList().add(info);
                _qty = _qty.subtract(qty);
                continue;
            }
            info = new ConsignmentScheduleCbInfo();
            info.setBasestatus(1);
            sinfo = ConsignmentScheduleFactory.getLocalInstance((Context)ctx).getConsignmentScheduleInfo((IObjectPK)new ObjectUuidPK(parentid));
            info.setMaterialid(vo.getMaterialid());
            info.setParentid(parentid);
            info.setNeedAmt(_qty.multiply(new BigDecimal(-1)));
            info.setNeedDate((java.util.Date)vo.getReqDate());
            info.setPreNeedDate(sinfo.getNeedDate());
            info.setPreNeedAmt(sinfo.getNeedAmt());
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            vo.getConsignmentCbList().add(info);
            _qty = BigDecimal.ZERO;
        }
    }

    private String timeStampToString(Timestamp stamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String tsStr = "";
        try {
            tsStr = sdf.format(stamp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tsStr;
    }

    private String dateToString(Date stamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String tsStr = "";
        try {
            tsStr = sdf.format(stamp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tsStr;
    }

    static {
        mapDeliveryPlan = new HashMap();
    }
}

