/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.basedata.OverRunMeasureEnum;
import com.kingdee.eas.mm.mo.MOUtil;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class MOIndustryUtil
extends MOUtil {
    public static int manufactureOrderClosedCheck(Context ctx, BatchActionResults batchResults, ManufactureOrderInfo orderInfo) throws BOSException, EASBizException {
        int result = 1;
        if (orderInfo == null) {
            List idList = batchResults.getToDoIdsList();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("transactionType.*"));
            sic.add(new SelectorItemInfo("routing.*"));
            sic.add(new SelectorItemInfo("stocks.*"));
            sic.add(new SelectorItemInfo("expectOutputs.*"));
            sic.add(new SelectorItemInfo("technics.*"));
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
            viewInfo.setSelector(sic);
            viewInfo.setFilter(filter);
            ManufactureOrderCollection coll = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderCollection(viewInfo);
            MOIndustryUtil.MoClosedCommonCheck(ctx, coll, batchResults, false);
        } else {
            ManufactureOrderCollection coll = new ManufactureOrderCollection();
            coll.add(orderInfo);
            result = MOIndustryUtil.MoClosedCommonCheck(ctx, coll, batchResults, true);
        }
        return result;
    }

    public static int MoClosedCommonCheck(Context ctx, ManufactureOrderCollection moColl, BatchActionResults batchResults, boolean flag) throws BOSException, EASBizException {
        String id = null;
        String msg = null;
        String messageFormatString = null;
        BigDecimal one = new BigDecimal("1.0");
        int result = 1;
        ManufactureOrderStockCollection stockCol = null;
        ManufactureOrderStockInfo entry = null;
        BigDecimal orderQty = null;
        BigDecimal totalSplitQty = null;
        BigDecimal rejectedQty = null;
        BigDecimal plannedQty = null;
        BigDecimal wipQty = null;
        BigDecimal actIssueQty = null;
        BigDecimal lackRatio = null;
        BigDecimal finishedQty = null;
        BigDecimal toStroreQty = null;
        ManufactureOrderTechnicsCollection tecCol = null;
        ManufactureOrderTechnicsInfo tecEntry = null;
        BigDecimal reportQty = null;
        BigDecimal qty = null;
        BigDecimal totalQtyLower = null;
        for (ManufactureOrderInfo moInfo : moColl) {
            int j;
            ISCMBillParam scmParam;
            String strAutoClose;
            id = moInfo.getId() == null ? "NEWID" : moInfo.getId().toString();
            if (moInfo.getTransactionType().isIsWPManagement() && !moInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.COMPLETE)) {
                msg = MOUtil.getString((Context)ctx, (String)"STATUS_CANNT_FINISH1");
                batchResults.addError(id, msg);
            }
            if (!flag && !batchResults.isToDo(id)) continue;
            IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
            BOTRelationCollection botcoll = iBTPManager.getDestRelation(id);
            boolean autoClose = false;
            if (flag && (strAutoClose = (scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx)).getParamByBillTypeID("MM_Close_01", 4, moInfo.getStorageOrgUnit().getId().toString(), "B2aZSVXaSx6qxdfekgCmrEY+1VI=")) != null && strAutoClose.trim().length() != 0 && strAutoClose.trim().toLowerCase().equals("1")) {
                autoClose = true;
            }
            for (j = 0; j < botcoll.size(); ++j) {
                IRowSet resultSet;
                String sql;
                String destObjectid;
                String destEntityid;
                block40: {
                    BOTRelationInfo botInfo = botcoll.get(j);
                    destEntityid = botInfo.getDestEntityID();
                    destObjectid = botInfo.getDestObjectID();
                    if (moInfo.getTransactionType() != null && moInfo.getTransactionType().isIsWPManagement()) {
                        if ("6F0D8519".equals(destEntityid)) {
                            sql = " select Fbasestatus from t_mm_distaskdispatch where fbasestatus<4 and fid='" + destObjectid + "'";
                            resultSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                            try {
                                if (resultSet.next()) {
                                    msg = MOUtil.getString((Context)ctx, (String)"OrderHasAuditDest");
                                    batchResults.addError(id, msg);
                                    if (flag) {
                                        result = autoClose ? 2 : 3;
                                        return result;
                                    }
                                    return result;
                                }
                                break block40;
                            }
                            catch (SQLException e) {
                                throw new BOSException((Throwable)e);
                            }
                        }
                        if ("DFBE5164".equals(destEntityid)) {
                            sql = " select Fbasestatus from T_MM_CompletionReport where fbasestatus<4 and fid='" + destObjectid + "'";
                            resultSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                            try {
                                if (resultSet.next()) {
                                    msg = MOUtil.getString((Context)ctx, (String)"OrderHasAuditDest");
                                    batchResults.addError(id, msg);
                                    if (flag) {
                                        result = autoClose ? 2 : 3;
                                        return result;
                                    }
                                    return result;
                                }
                                break block40;
                            }
                            catch (SQLException e) {
                                throw new BOSException((Throwable)e);
                            }
                        }
                        if ("200BB61F".equals(destEntityid)) {
                            sql = " select Fbasestatus from T_MM_WPTransferBill where fbasestatus<4 and fid='" + destObjectid + "'";
                            resultSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                            try {
                                if (resultSet.next()) {
                                    msg = MOUtil.getString((Context)ctx, (String)"OrderHasAuditDest");
                                    batchResults.addError(id, msg);
                                    if (flag) {
                                        result = autoClose ? 2 : 3;
                                        return result;
                                    }
                                    return result;
                                }
                            }
                            catch (SQLException e) {
                                throw new BOSException((Throwable)e);
                            }
                        }
                    }
                }
                if ("FA1292B4".equals(destEntityid)) {
                    sql = " select Fbasestatus from T_IM_ManufactureRecBill where fbasestatus<4 and fid='" + destObjectid + "'";
                    resultSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                    try {
                        if (!resultSet.next()) continue;
                        msg = MOUtil.getString((Context)ctx, (String)"OrderHasAuditDest");
                        batchResults.addError(id, msg);
                        if (flag) {
                            result = autoClose ? 2 : 3;
                            return result;
                        }
                        return result;
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                if ("76C9F8D8".equals(destEntityid)) {
                    sql = " select Fbasestatus from T_MM_DirectDeliveryBill where fbasestatus<4 and fid='" + destObjectid + "'";
                    resultSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                    try {
                        if (!resultSet.next()) continue;
                        msg = MOUtil.getString((Context)ctx, (String)"OrderHasAuditDest");
                        batchResults.addError(id, msg);
                        if (flag) {
                            result = autoClose ? 2 : 3;
                            return result;
                        }
                        return result;
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                if (!"500AB75E".equals(destEntityid)) continue;
                sql = " select Fbasestatus from T_IM_MaterialReqBill where fbasestatus<4 and fid='" + destObjectid + "'";
                resultSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                try {
                    if (!resultSet.next()) continue;
                    msg = MOUtil.getString((Context)ctx, (String)"OrderHasAuditDest");
                    batchResults.addError(id, msg);
                    if (flag) {
                        result = autoClose ? 2 : 3;
                        return result;
                    }
                    return result;
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            if (flag) {
                result = autoClose ? 2 : 3;
            }
            stockCol = moInfo.getStocks();
            finishedQty = moInfo.getFinishedQty();
            toStroreQty = moInfo.getToStroreQty();
            orderQty = moInfo.getQty();
            totalSplitQty = moInfo.getTotalSplitQty();
            for (j = 0; j < stockCol.size(); ++j) {
                MessageFormat messageFormat;
                entry = stockCol.get(j);
                boolean isQtyLimt = entry.isIsQtyLimit();
                plannedQty = entry.getPlannedQty();
                actIssueQty = entry.getActIssueQty();
                wipQty = entry.getWipQty();
                entry.getExtraRatio().multiply(new BigDecimal("0.01"));
                lackRatio = entry.getLackRatio().multiply(new BigDecimal("0.01"));
                rejectedQty = entry.getRejectedQty();
                entry.getTotalDirectReceiveQty();
                MaterialIssueModeEnum issueModeEnum = entry.getIssueMode();
                if (isQtyLimt && actIssueQty.subtract(rejectedQty).compareTo(plannedQty.multiply(one.subtract(lackRatio))) < 0) {
                    messageFormatString = MOUtil.getString((Context)ctx, (String)"ACTISSUEQTY_LESS_PLANNEDQTYLACK");
                    messageFormat = new MessageFormat(messageFormatString);
                    msg = messageFormat.format(new String[]{" " + (j + 1) + " "});
                    batchResults.addError(id, msg);
                }
                if (wipQty.compareTo(SysConstant.BIGZERO) != 0) {
                    messageFormatString = MOUtil.getString((Context)ctx, (String)"WIPQTY_NOT_ZERO");
                    messageFormat = new MessageFormat(messageFormatString);
                    msg = messageFormat.format(new String[]{" " + (j + 1) + " "});
                    batchResults.addError(id, msg);
                }
                if (moInfo.getTransactionType() != null && moInfo.getTransactionType().isIsWPManagement()) {
                    if (orderQty.subtract(totalSplitQty).compareTo(new BigDecimal(0)) > 0) {
                        if (actIssueQty.subtract(rejectedQty).compareTo(finishedQty.multiply(plannedQty.divide(orderQty.subtract(totalSplitQty), 8, 4))) >= 0) continue;
                        messageFormatString = MOUtil.getString((Context)ctx, (String)"ACTISSUEQTY_LESS_PLANNEDQTY");
                        messageFormat = new MessageFormat(messageFormatString);
                        msg = messageFormat.format(new String[]{" " + (j + 1) + " "});
                        batchResults.addError(id, msg);
                        continue;
                    }
                    if (actIssueQty.subtract(rejectedQty).compareTo(new BigDecimal(0)) >= 0) continue;
                    messageFormatString = MOUtil.getString((Context)ctx, (String)"ACTISSUEQTY_LESS_PLANNEDQTY");
                    messageFormat = new MessageFormat(messageFormatString);
                    msg = messageFormat.format(new String[]{" " + (j + 1) + " "});
                    batchResults.addError(id, msg);
                    continue;
                }
                if (moInfo.getTransactionType() == null || moInfo.getTransactionType().isIsWPManagement() || issueModeEnum.equals((Object)MaterialIssueModeEnum.NOTISSMODE)) continue;
                if (orderQty.subtract(totalSplitQty).compareTo(new BigDecimal(0)) > 0) {
                    if (actIssueQty.subtract(rejectedQty).compareTo(toStroreQty.multiply(plannedQty.divide(orderQty.subtract(totalSplitQty), 8, 4))) >= 0) continue;
                    messageFormatString = MOUtil.getString((Context)ctx, (String)"ACTISSUEQTY_LESS_TOSTORAGEQTY");
                    messageFormat = new MessageFormat(messageFormatString);
                    msg = messageFormat.format(new String[]{" " + (j + 1) + " "});
                    batchResults.addError(id, msg);
                    continue;
                }
                if (actIssueQty.subtract(rejectedQty).compareTo(new BigDecimal(0)) >= 0) continue;
                messageFormatString = MOUtil.getString((Context)ctx, (String)"ACTISSUEQTY_LESS_TOSTORAGEQTY");
                messageFormat = new MessageFormat(messageFormatString);
                msg = messageFormat.format(new String[]{" " + (j + 1) + " "});
                batchResults.addError(id, msg);
            }
            if (moInfo.getTransactionType() != null && moInfo.getTransactionType().isIsWPManagement() && finishedQty.compareTo(toStroreQty) != 0) {
                msg = MOUtil.getString((Context)ctx, (String)"FINISHEDQTY_NOTEQUAL_TOSTROREQTY");
                batchResults.addError(id, msg);
            }
            tecCol = moInfo.getTechnics();
            for (j = 0; j < tecCol.size(); ++j) {
                tecEntry = tecCol.get(j);
                if (!tecEntry.isIsReportPoint()) continue;
                reportQty = tecEntry.getFinishedQty();
                qty = tecEntry.getQty();
                totalQtyLower = tecEntry.getTotalQtyLower().multiply(new BigDecimal("0.01"));
                tecEntry.getTotalQtyUpper().multiply(new BigDecimal("0.01"));
                if (reportQty.compareTo(qty.multiply(new BigDecimal("1.00").subtract(totalQtyLower))) >= 0 || moInfo.getTransactionType() == null || !moInfo.getTransactionType().isIsWPManagement() || !tecEntry.getOverrunMeasure().equals((Object)OverRunMeasureEnum.REFUSE) && !tecEntry.getOverrunMeasure().equals((Object)OverRunMeasureEnum.WARNING)) continue;
                messageFormatString = MOUtil.getString((Context)ctx, (String)"REPORTQTY_LESS_QTY");
                MessageFormat messageFormat = new MessageFormat(messageFormatString);
                msg = messageFormat.format(new String[]{" " + (j + 1) + " "});
                batchResults.addError(id, msg);
            }
        }
        return result;
    }

    public static <T> List<List<T>> split(List<T> resList, int count) {
        if (resList == null || count < 1) {
            return null;
        }
        ArrayList<List<T>> ret = new ArrayList<List<T>>();
        int size = resList.size();
        if (size <= count) {
            ret.add(resList);
        } else {
            int pre = size / count;
            int last = size % count;
            for (int i = 0; i < pre; ++i) {
                ArrayList<T> itemList = new ArrayList<T>();
                for (int j = 0; j < count; ++j) {
                    itemList.add(resList.get(i * count + j));
                }
                ret.add(itemList);
            }
            if (last > 0) {
                ArrayList<T> itemList = new ArrayList<T>();
                for (int i = 0; i < last; ++i) {
                    itemList.add(resList.get(pre * count + i));
                }
                ret.add(itemList);
            }
        }
        return ret;
    }
}

