/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.extendcontrols.ext.CommonF7KDTableListener;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.clientUtil.DateUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.basedata.WorkCenterInfo;
import com.kingdee.eas.mm.report.client.AbstractWorkshopDailyOutputReportFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.Calendar;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class WorkshopDailyOutputReportFilterUI
extends AbstractWorkshopDailyOutputReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(WorkshopDailyOutputReportFilterUI.class);
    public static final String F_TITLE = "title";
    private String RESURL = "com.kingdee.eas.mm.report.EMMEMReportResource";
    private SelectorListener prmtSelectListener;
    private DataChangeListener prmtDataChange;

    public WorkshopDailyOutputReportFilterUI() throws Exception {
        this.initElementsInfo();
    }

    private void initElementsInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new SingleFilterElement("storageOrgUnit", (Component)this.prmtStorageOrgUnit));
        elements.add((FilterElement)new SingleFilterElement("storageOrgUnittitle", null){

            public void addRptParams(RptParams cp) {
                cp.setObject(this.getId(), (Object)(WorkshopDailyOutputReportFilterUI.this.contStorageOrgUnit.getBoundLabelText() + "\uff1a" + WorkshopDailyOutputReportFilterUI.this.prmtStorageOrgUnit.getText()));
            }
        });
        elements.add((FilterElement)new SingleFilterElement("workshop", (Component)this.prmtWorkshop));
        elements.add((FilterElement)new SingleFilterElement("workshoptitle", null){

            public void addRptParams(RptParams cp) {
                cp.setObject(this.getId(), (Object)(WorkshopDailyOutputReportFilterUI.this.contWorkshop.getBoundLabelText() + "\uff1a" + WorkshopDailyOutputReportFilterUI.this.prmtWorkshop.getText()));
            }
        });
        elements.add((FilterElement)new SingleFilterElement("workcenter", (Component)this.prmtWorkCenter));
        elements.add((FilterElement)new SingleFilterElement("workcentertitle", null){

            public void addRptParams(RptParams cp) {
                cp.setObject(this.getId(), (Object)(WorkshopDailyOutputReportFilterUI.this.contWorkConter.getBoundLabelText() + "\uff1a" + WorkshopDailyOutputReportFilterUI.this.prmtWorkCenter.getText()));
            }
        });
        elements.add((FilterElement)new SingleFilterElement("pkStartDate", (Component)this.pkStartDate));
        elements.add((FilterElement)new SingleFilterElement("pkEndDate", (Component)this.pkEndDate));
        elements.add((FilterElement)new SingleFilterElement("pkDatetitle", null){

            public void addRptParams(RptParams cp) {
                String bizdateStr = WorkshopDailyOutputReportFilterUI.this.pkStartDate.getText();
                String bizdate2Str = WorkshopDailyOutputReportFilterUI.this.pkEndDate.getText();
                cp.setObject(this.getId(), (Object)(WorkshopDailyOutputReportFilterUI.this.contStartDate.getBoundLabelText() + "\uff1a" + bizdateStr + " " + WorkshopDailyOutputReportFilterUI.this.contEndDate.getBoundLabelText() + " " + bizdate2Str));
            }
        });
        this.getFilterManager().setElement((FilterElement)elements);
    }

    public void onLoad() throws Exception {
        this.removeListener();
        super.onLoad();
        this.prmtInit();
        this.addListener();
        this.contStorageOrgUnit.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0037"));
        this.prmtWorkCenter.addCommonF7KDTableListener((CommonF7KDTableListener)new CommonF7KDTableListenerImpl(EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0050"), this.prmtWorkCenter));
        this.prmtWorkshop.addCommonF7KDTableListener((CommonF7KDTableListener)new CommonF7KDTableListenerImpl(EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0049"), this.prmtWorkshop));
    }

    protected void prmtInit() {
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_flow_orderSimulation");
        this.prmtStorageOrgUnit.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery");
        this.prmtStorageOrgUnit.setEnabledMultiSelection(false);
        this.prmtStorageOrgUnit.setEditFormat("$number$");
        this.prmtStorageOrgUnit.setDisplayFormat("$name$");
        this.prmtWorkshop.setQueryInfo("com.kingdee.eas.mm.basedata.app.F7WorkcenterQuery");
        this.prmtWorkshop.setEnabledMultiSelection(true);
        this.prmtWorkshop.setEditFormat("$number$");
        this.prmtWorkshop.setDisplayFormat("$name$");
        this.prmtWorkCenter.setQueryInfo("com.kingdee.eas.mm.basedata.app.F7WorkcenterQuery");
        this.prmtWorkCenter.setEnabledMultiSelection(true);
        this.prmtWorkCenter.setEditFormat("$number$");
        this.prmtWorkCenter.setDisplayFormat("$name$");
    }

    protected void addListener() {
        if (this.prmtSelectListener == null) {
            this.prmtSelectListener = new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    WorkshopDailyOutputReportFilterUI.this.prmtSelectorListener(e);
                }
            };
        }
        this.prmtWorkCenter.addSelectorListener(this.prmtSelectListener);
        this.prmtWorkshop.addSelectorListener(this.prmtSelectListener);
        if (this.prmtDataChange == null) {
            this.prmtDataChange = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    if (e.getOldValue() == null ? e.getNewValue() == null : e.getNewValue() != null && e.getOldValue().equals(e.getNewValue())) {
                        return;
                    }
                    WorkshopDailyOutputReportFilterUI.this.prmtDataChanged(e);
                }
            };
        }
        this.prmtStorageOrgUnit.addDataChangeListener(this.prmtDataChange);
        this.prmtWorkshop.addDataChangeListener(this.prmtDataChange);
    }

    protected void removeListener() {
        if (this.prmtSelectListener != null) {
            this.prmtWorkCenter.removeSelectorListener(this.prmtSelectListener);
            this.prmtWorkshop.removeSelectorListener(this.prmtSelectListener);
        }
        if (this.prmtDataChange != null) {
            this.prmtStorageOrgUnit.removeDataChangeListener(this.prmtDataChange);
            this.prmtWorkshop.removeDataChangeListener(this.prmtDataChange);
        }
    }

    protected void prmtSelectorListener(SelectorEvent e) {
        this.removeListener();
        if (e.getSource().equals(this.prmtWorkshop)) {
            this.prmtWorkshopInit();
        } else if (e.getSource().equals(this.prmtWorkCenter)) {
            this.prmtWorkCenterInit();
        }
        this.addListener();
    }

    protected void prmtDataChanged(DataChangeEvent e) {
        this.removeListener();
        if (e.getSource().equals(this.prmtStorageOrgUnit)) {
            this.prmtWorkshop.setValue(null);
            this.prmtWorkCenter.setValue(null);
            this.prmtWorkshopInit();
            this.prmtWorkCenterInit();
        } else if (e.getSource().equals(this.prmtWorkshop)) {
            this.prmtWorkCenter.setValue(null);
            this.prmtWorkCenterInit();
        }
        this.addListener();
    }

    protected void prmtWorkshopInit() {
        StorageOrgUnitInfo storage = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        if (storage == null) {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("storageOrgUnit.number", (Object)this.prmtStorageOrgUnit.getText()));
        } else {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storage.getId().toString()));
        }
        evi.getFilter().getFilterItems().add(new FilterItemInfo("status", (Object)20));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isWorkshop", (Object)true));
        this.prmtWorkshop.setEntityViewInfo(evi);
    }

    protected void prmtWorkCenterInit() {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        StorageOrgUnitInfo storage = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        if (storage == null) {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("storageOrgUnit.number", (Object)this.prmtStorageOrgUnit.getText()));
        } else {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storage.getId().toString()));
        }
        Object o = this.prmtWorkshop.getValue();
        if (o == null) {
            HashSet<String> numbers = new HashSet<String>();
            String numberStr = this.prmtWorkshop.getText();
            if (!StringUtils.isEmpty((String)numberStr)) {
                String[] ss = numberStr.split("[,;]");
                for (int i = 0; i < ss.length; ++i) {
                    numbers.add(ss[i].trim());
                }
            }
            if (numbers.size() > 0) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("parentWC.number", numbers, CompareType.INCLUDE));
            }
        } else {
            HashSet<String> ids = new HashSet<String>();
            if (WorkCenterInfo.class.isInstance(o)) {
                ids.add(((WorkCenterInfo)o).getId().toString());
            } else {
                Object[] os = (Object[])o;
                for (int i = 0; i < os.length; ++i) {
                    if (os[i] == null || !WorkCenterInfo.class.isInstance(os[i])) continue;
                    ids.add(((WorkCenterInfo)os[i]).getId().toString());
                }
            }
            if (ids.size() > 0) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("parentWC.id", ids, CompareType.INCLUDE));
            }
        }
        evi.getFilter().getFilterItems().add(new FilterItemInfo("status", (Object)20));
        this.prmtWorkCenter.setEntityViewInfo(evi);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.prmtWorkshopInit();
        this.prmtWorkCenterInit();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrg.id";
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        Calendar now = Calendar.getInstance();
        now.add(6, 1);
        this.pkEndDate.setValue((Object)now.getTime());
        now.add(6, -2);
        this.pkStartDate.setValue((Object)now.getTime());
    }

    public boolean verify() {
        super.verify();
        if (StringUtils.isEmpty((String)this.prmtStorageOrgUnit.getText())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0054"));
            return false;
        }
        if (StringUtils.isEmpty((String)this.pkStartDate.getText()) || StringUtils.isEmpty((String)this.pkEndDate.getText())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0063"));
            return false;
        }
        int c = DateUtil.conpareToDate((String)this.pkStartDate.getText(), (String)this.pkEndDate.getText());
        if (c < 0) {
            String strInfo = EASResource.getString((String)this.RESURL, (String)"JHWGRQDYJSRQ_INFO", (Object[])new Object[]{this.pkStartDate.getText(), this.pkEndDate.getText()});
            MsgBox.showInfo((Component)((Object)this), (String)strInfo);
            return false;
        }
        if (c > 31) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0064"));
            return false;
        }
        return true;
    }

    private class CommonF7KDTableListenerImpl
    implements CommonF7KDTableListener {
        private String title;
        private KDBizPromptBox prmtBox;

        private CommonF7KDTableListenerImpl(String title, KDBizPromptBox prmtBox) {
            this.title = title;
            this.prmtBox = prmtBox;
        }

        public void onTableStructureCreated(KDTable paramKDTable) {
            ((KDCommonPromptDialog)this.prmtBox.getSelector()).setTitle(this.title);
        }
    }
}

