/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.schedule.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.report.schedule.GraphicSetEntryCollection;
import com.kingdee.eas.mm.report.schedule.GraphicSetEntryInfo;
import com.kingdee.eas.mm.report.schedule.GraphicSetFactory;
import com.kingdee.eas.mm.report.schedule.GraphicSetInfo;
import com.kingdee.eas.mm.report.schedule.ITemplateSet;
import com.kingdee.eas.mm.report.schedule.TemplateSetFactory;
import com.kingdee.eas.mm.report.schedule.TemplateSetInfo;
import com.kingdee.eas.mm.report.schedule.client.AbstractGraphicSetEditUI;
import com.kingdee.eas.mm.report.schedule.client.util.TemplateSetUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class GraphicSetEditUI
extends AbstractGraphicSetEditUI {
    private static final Logger logger = CoreUIObject.getLogger(GraphicSetEditUI.class);
    private TemplateSetInfo selectTemplate = null;
    public static final String TEMPLATE_ID = "id";
    public static final String TEMPLATE_NAME = "name";
    public static final String TEMPLATE_NUMBER = "number";
    public static final String TEMPLATE_PRODUCT_NAME = "product.name";
    public static final String TEMPLATE_PRODUCT_NUMBER = "product.number";
    public static final String TEMPLATE_STORAGEORG_NAME = "storageOrg.name";
    public static final String TEMPLATE_LASTUPDATE_NAME = "lastUpdateUser.name";
    public static final String TEMPLATE_LASTUPDATETIME = "lastUpdateTime";
    private static final String RES_CLASS_NAME = "com.kingdee.eas.mm.report.schedule.client.ScheduleResource";

    @Override
    public void storeFields() {
        super.storeFields();
        GraphicSetEntryCollection entryCollection = this.editData.getEntry();
        int size = entryCollection.size();
        for (int i = 0; i < size; ++i) {
            entryCollection.get(i).setSeq(i + 1);
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    protected KDTable getDetailTable() {
        return this.kdtEntry;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return GraphicSetFactory.getRemoteInstance();
    }

    public String getOprtState() {
        if (this.oprtState == null) {
            this.oprtState = "ADDNEW";
        }
        return this.oprtState;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorageOrg;
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtStorageOrg;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected IObjectValue createNewData() {
        GraphicSetInfo info = new GraphicSetInfo();
        info.setStorageOrg((StorageOrgUnitInfo)this.getDefaultMainBizOrg());
        info.setBaseStatus(BillBaseStatusEnum.ADD);
        info.setBizDate(new Timestamp(System.currentTimeMillis()));
        return info;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        KDTSelectBlock sb = this.kdtTemplate.getSelectManager().get();
        if (sb == null) {
            this.showInfo("select_template");
            SysUtil.abort();
        }
        int top = sb.getTop();
        int bottom = sb.getBottom();
        for (int i = top; i <= bottom; ++i) {
            IRow row = this.kdtTemplate.getRow(i);
            Object o = row.getUserObject();
            if (!TemplateSetInfo.class.isInstance(o)) continue;
            this.selectTemplate = (TemplateSetInfo)o;
        }
        GraphicSetEntryInfo info = new GraphicSetEntryInfo();
        info.setTemplate(this.selectTemplate);
        info.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
        return info;
    }

    protected void addLine(KDTable table) {
        super.addLine(table);
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
    }

    protected String getOnloadPermItemName() {
        return super.getOnloadPermItemName();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.prmtStorageOrg.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery");
        this.prmtStorageOrg.setEnabledMultiSelection(false);
        this.prmtStorageOrg.setCommitFormat("$id$");
        this.prmtStorageOrg.setDisplayFormat("$name$");
        this.prmtStorageOrg.setEditFormat("$number$");
        this.prmtStorageOrg.setRequired(true);
        TemplateSetUtil.kdtColumnTemplateF7(this.kdtEntry, "template.number");
        this.kdUp.setEnabled(true);
        this.kdClearEntry.setText(EASResource.getString((String)RES_CLASS_NAME, (String)"clear_all"));
    }

    public void onShow() throws Exception {
        super.onShow();
        try {
            ITemplateSet its = TemplateSetFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
            EntityViewInfo entityviewinfo = new EntityViewInfo();
            SelectorItemCollection coll = new SelectorItemCollection();
            coll.add(new SelectorItemInfo(TEMPLATE_ID));
            coll.add(new SelectorItemInfo(TEMPLATE_NAME));
            coll.add(new SelectorItemInfo(TEMPLATE_NUMBER));
            coll.add(new SelectorItemInfo(TEMPLATE_PRODUCT_NAME));
            coll.add(new SelectorItemInfo(TEMPLATE_PRODUCT_NUMBER));
            coll.add(new SelectorItemInfo(TEMPLATE_STORAGEORG_NAME));
            coll.add(new SelectorItemInfo(TEMPLATE_LASTUPDATE_NAME));
            coll.add(new SelectorItemInfo(TEMPLATE_LASTUPDATETIME));
            entityviewinfo.setSelector(coll);
            CoreBaseCollection tsCollection = its.getCollection(entityviewinfo);
            int size = tsCollection.size();
            for (int i = 0; i < size; ++i) {
                TemplateSetInfo info = (TemplateSetInfo)tsCollection.get(i);
                this.kdtTemplate.addRow(i);
                IRow row = this.kdtTemplate.getRow(i);
                row.getCell(TEMPLATE_ID).setValue((Object)info.getId());
                row.getCell(TEMPLATE_NUMBER).setValue((Object)info.getNumber());
                row.getCell(TEMPLATE_NAME).setValue((Object)info.getName());
                if (info.getProduct() != null) {
                    row.getCell(TEMPLATE_PRODUCT_NAME).setValue((Object)info.getProduct().getName());
                    row.getCell(TEMPLATE_PRODUCT_NUMBER).setValue((Object)info.getProduct().getNumber());
                }
                if (info.getStorageOrg() != null) {
                    row.getCell(TEMPLATE_STORAGEORG_NAME).setValue((Object)info.getStorageOrg().getName());
                }
                if (info.getLastUpdateUser() != null) {
                    row.getCell(TEMPLATE_LASTUPDATE_NAME).setValue((Object)info.getLastUpdateUser().getName());
                }
                row.getCell(TEMPLATE_LASTUPDATETIME).setValue((Object)info.getLastUpdateTime());
                row.setUserObject((Object)info);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.kdtTemplate.getSelectManager().setSelectMode(2);
        this.kdtEntry.getSelectManager().setSelectMode(10);
        this.btnAttachment.setVisible(false);
        this.btnUnAudit.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.btnAuditResult.setVisible(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    private void showInfo(String resourceName) {
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_CLASS_NAME, (String)resourceName));
    }

    @Override
    public void actionUp_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock sb = this.kdtEntry.getSelectManager().get();
        if (sb == null) {
            this.showInfo("select_playback_template");
            SysUtil.abort();
        }
        int top = sb.getTop();
        int bottom = sb.getBottom();
        int move = bottom - top + 1;
        if (top == 0 || move == this.kdtEntry.getRowCount()) {
            return;
        }
        IRow moveRow = this.kdtEntry.getRow(top - 1);
        this.kdtEntry.addRow(bottom + 1, moveRow);
        this.kdtEntry.removeRow(top - 1);
        this.kdtEntry.getSelectManager().select(top - 1, 0, bottom - 1, 0);
    }

    @Override
    public void actionDown_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock sb = this.kdtEntry.getSelectManager().get();
        if (sb == null) {
            this.showInfo("select_playback_template");
            SysUtil.abort();
        }
        int top = sb.getTop();
        int bottom = sb.getBottom();
        int move = bottom - top + 1;
        int count = this.kdtEntry.getRowCount();
        if (bottom + 1 == count || move == count) {
            return;
        }
        IRow moveRow = this.kdtEntry.getRow(bottom + 1);
        this.kdtEntry.removeRow(bottom + 1);
        this.kdtEntry.addRow(top, moveRow);
        this.kdtEntry.getSelectManager().select(top + 1, 0, bottom + 1, 0);
    }

    @Override
    public void actionClearEntry_actionPerformed(ActionEvent e) throws Exception {
        int count = this.kdtEntry.getRowCount();
        if (count == 0) {
            return;
        }
        this.kdtEntry.getSelectManager().select(0, 0, count - 1, 0);
        this.actionRemoveLine_actionPerformed(e);
    }
}

