/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.schedule.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.mo.IManufactureOrderTechnics;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.report.schedule.GraphicSetEntryCollection;
import com.kingdee.eas.mm.report.schedule.GraphicSetEntryInfo;
import com.kingdee.eas.mm.report.schedule.GraphicSetInfo;
import com.kingdee.eas.mm.report.schedule.ITemplateSetEntry;
import com.kingdee.eas.mm.report.schedule.TemplateSetEntryCollection;
import com.kingdee.eas.mm.report.schedule.TemplateSetEntryInfo;
import com.kingdee.eas.mm.report.schedule.client.util.FlowChartPane;
import com.kingdee.eas.mm.report.schedule.client.util.FlowchartNode;
import com.kingdee.eas.mm.report.schedule.client.util.TemplateSetUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.JToolBar;
import org.apache.log4j.Logger;

public class FlowchartShow
extends FlowChartPane {
    private static final Logger logger = CoreUIObject.getLogger(FlowchartShow.class);
    protected GraphicSetInfo gsi;
    protected Timer t;
    public boolean refresh = false;
    private static final String RES_CLASS_NAME = "com.kingdee.eas.mm.report.schedule.client.ScheduleResource";

    public void setPortsVisible(boolean pv) {
        this.graph.setPortsVisible(pv);
    }

    @Override
    public JToolBar createToolBar() {
        JToolBar toolbar = new JToolBar();
        toolbar.addSeparator();
        this.zoom = new AbstractAction(FlowchartShow.getResourceInfo("zoom")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowchartShow.this.graph.setScale(1.0);
            }
        };
        toolbar.add(this.zoom);
        this.zoomIn = new AbstractAction(FlowchartShow.getResourceInfo("zoom_in")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowchartShow.this.graph.setScale(1.2 * FlowchartShow.this.graph.getScale());
            }
        };
        toolbar.add(this.zoomIn);
        this.zoomOut = new AbstractAction(FlowchartShow.getResourceInfo("zoom_out")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowchartShow.this.graph.setScale(FlowchartShow.this.graph.getScale() / 1.2);
            }
        };
        toolbar.add(this.zoomOut);
        return toolbar;
    }

    public void showNodeTrackNumber(final GraphicSetInfo gsi) {
        this.gsi = gsi;
        int refresh = gsi.getRefreshInterval();
        if (refresh <= 0) {
            FlowchartShow.showNodeTrackNumber(this.allNodes, gsi.isShowCurrentTrackNum());
            return;
        }
        final FlowchartShow flowchart = this;
        long l = refresh * 60 * 1000;
        this.t = new Timer();
        this.t.schedule(new TimerTask(){

            @Override
            public void run() {
                if (flowchart.refresh) {
                    return;
                }
                flowchart.refresh = true;
                try {
                    FlowchartShow.showNodeTrackNumber(FlowchartShow.this.allNodes, gsi.isShowCurrentTrackNum());
                }
                finally {
                    flowchart.refresh = false;
                    FlowchartShow.this.zoomOut.actionPerformed(null);
                    FlowchartShow.this.zoomIn.actionPerformed(null);
                }
            }
        }, 0L, l);
    }

    public static void showFlowchart(final GraphicSetInfo gsi, final ITemplateSetEntry its, IManufactureOrderTechnics imo) {
        final KDFrame frame = new KDFrame();
        frame.setSize(100, 100);
        final Thread thr = new Thread(){

            @Override
            public void run() {
                FlowchartShow graphShow = null;
                try {
                    GraphicSetEntryCollection collection = gsi.getEntry();
                    int size = collection.size();
                    if (size == 0) {
                        return;
                    }
                    int i = 0;
                    do {
                        GraphicSetEntryInfo entry = collection.get(i++ % size);
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)entry.getTemplate().getId().toString(), CompareType.EQUALS));
                        EntityViewInfo entityViewInfo = new EntityViewInfo();
                        entityViewInfo.setFilter(filter);
                        entityViewInfo.setSelector(TemplateSetUtil.getEntrySelectors());
                        CoreBaseCollection es = its.getCollection(entityViewInfo);
                        TemplateSetEntryCollection tses = new TemplateSetEntryCollection();
                        for (int j = 0; j < es.size(); ++j) {
                            tses.add((TemplateSetEntryInfo)es.get(j));
                        }
                        if (tses == null || tses.size() == 0) continue;
                        if (graphShow != null) {
                            frame.getContentPane().remove(graphShow);
                        }
                        frame.setTitle(gsi.getName() + ":" + entry.getTemplate().getName());
                        graphShow = new FlowchartShow();
                        frame.getContentPane().add(graphShow);
                        List<FlowchartNode> nodes = graphShow.initNode(tses);
                        graphShow.showNodeTrackNumber(gsi);
                        graphShow.setPortsVisible(false);
                        frame.pack();
                        frame.setVisible(true);
                        frame.setExtendedState(6);
                        int showTime = gsi.getSingleProjectShowTime();
                        if (showTime > 0) {
                            5.sleep(showTime * 60 * 1000);
                            continue;
                        }
                        5.sleep(3000L);
                    } while (size != 1);
                }
                catch (Exception e) {
                    logger.error((Object)"thread show FlowchartShow is error", (Throwable)e);
                }
            }
        };
        frame.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent windowevent) {
            }

            @Override
            public void windowClosed(WindowEvent windowevent) {
            }

            @Override
            public void windowClosing(WindowEvent windowevent) {
                try {
                    thr.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void windowDeactivated(WindowEvent windowevent) {
            }

            @Override
            public void windowDeiconified(WindowEvent windowevent) {
            }

            @Override
            public void windowIconified(WindowEvent windowevent) {
            }

            @Override
            public void windowOpened(WindowEvent windowevent) {
            }
        });
        thr.start();
    }

    public static void showNodeTrackNumber(List<FlowchartNode> nodes, boolean showCurrentTrackNum) {
        IManufactureOrderTechnics imot;
        try {
            imot = ManufactureOrderTechnicsFactory.getRemoteInstance();
        }
        catch (BOSException e1) {
            logger.error((Object)EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0075"), (Throwable)e1);
            return;
        }
        ArrayList<String> textLine = new ArrayList<String>();
        for (FlowchartNode node : nodes) {
            try {
                TemplateSetEntryInfo info = node.getInfo();
                info.getParent().getProduct();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("operation.id", (Object)info.getOperation().getId(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("operationNo", (Object)info.getOperationNo(), CompareType.EQUALS));
                if (info.getParent() != null) {
                    if (info.getParent().getProduct() != null) {
                        filter.getFilterItems().add(new FilterItemInfo("parent.material.id", (Object)info.getMaterial().getId(), CompareType.EQUALS));
                    }
                    if (info.getParent().getProject() != null) {
                        filter.getFilterItems().add(new FilterItemInfo("parent.project.id", (Object)info.getParent().getProject().getId(), CompareType.EQUALS));
                    }
                    if (info.getParent().getStorageOrg() != null) {
                        filter.getFilterItems().add(new FilterItemInfo("parent.storageOrgUnit.id", (Object)info.getParent().getStorageOrg().getId(), CompareType.EQUALS));
                    }
                }
                HashSet<Integer> status = new HashSet<Integer>();
                status.add(13);
                status.add(14);
                status.add(15);
                status.add(11);
                status.add(20);
                status.add(22);
                status.add(21);
                status.add(23);
                filter.getFilterItems().add(new FilterItemInfo("baseStatus", status, CompareType.INCLUDE));
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                entityViewInfo.setFilter(filter);
                SelectorItemCollection coll = new SelectorItemCollection();
                coll.add(new SelectorItemInfo("parent.trackNumber.number"));
                coll.add(new SelectorItemInfo("baseStatus"));
                entityViewInfo.setSelector(coll);
                entityViewInfo.setSorter(new SorterItemCollection());
                entityViewInfo.getSorter().add(new SorterItemInfo("parent.trackNumber.number"));
                CoreBaseCollection motc = null;
                try {
                    motc = imot.getCollection(entityViewInfo);
                }
                catch (BOSException e) {
                    logger.error((Object)("select ManufactureOrderTechnicsInfo collection is error [" + entityViewInfo + "]"), (Throwable)e);
                    continue;
                }
                int size = motc.size();
                if (size == 0) continue;
                textLine.clear();
                textLine.add(node.initObject.toString());
                textLine.add(FlowchartShow.getResourceInfo("tracking_number") + "\uff1a");
                StringBuffer tn = new StringBuffer();
                if (showCurrentTrackNum) {
                    ManufactureOrderTechnicsInfo moti = (ManufactureOrderTechnicsInfo)motc.get(size - 1);
                    ManufactureOrderInfo moi = moti.getParent();
                    if (moi == null || moi.getTrackNumber() == null) continue;
                    String num = moi.getTrackNumber().getNumber();
                    tn.append(num).append(" \u3010").append(moti.getBaseStatus().getAlias(imot.getContext().getLocale())).append("\u3011");
                    textLine.add(tn.toString());
                } else {
                    for (int i = 0; i < size; ++i) {
                        tn.setLength(0);
                        CoreBaseInfo o = motc.get(i);
                        if (ManufactureOrderTechnicsInfo.class.isInstance(o)) {
                            ManufactureOrderTechnicsInfo moti = (ManufactureOrderTechnicsInfo)o;
                            ManufactureOrderInfo moi = moti.getParent();
                            if (moi == null || moi.getTrackNumber() == null) continue;
                            String num = moi.getTrackNumber().getNumber();
                            tn.append(num).append(" \u3010").append(moti.getBaseStatus().getAlias(imot.getContext().getLocale())).append("\u3011");
                        }
                        if (tn.length() <= 0 || textLine.contains(tn.toString())) continue;
                        textLine.add(tn.toString());
                    }
                }
                node.setText(textLine);
            }
            catch (Exception e) {
                logger.error((Object)("FlowchartNode show tracking number is error [" + (Object)((Object)node) + "]"), (Throwable)e);
            }
        }
    }

    private static String getResourceInfo(String resourceName) {
        return EASResource.getString((String)RES_CLASS_NAME, (String)resourceName);
    }
}

