/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.convert.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BOMTypeEnum;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.DesignModeInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.zjbom.convert.bomConvertToPBomFacadeFactory;
import com.kingdee.eas.zjbom.convert.client.AbstractBomTreeExpandUI;
import com.kingdee.eas.zjbom.convert.util.BomUtil;
import java.awt.Color;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BomTreeExpandUI
extends AbstractBomTreeExpandUI {
    private static final Logger logger = CoreUIObject.getLogger(BomTreeExpandUI.class);
    private String topBomID = null;

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().get("bomid") != null && !"".equals(this.getUIContext().get("bomid").toString())) {
            this.topBomID = this.getUIContext().get("bomid").toString();
            try {
                this.initTree();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.handleException(e);
            }
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.zjbom.convert.BomCutResource", (String)"BOMSXZK_INFO"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected SelectorItemCollection getBomSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("designMode.id"));
        sic.add(new SelectorItemInfo("designMode.name"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("bomType"));
        return sic;
    }

    private void initTree() throws Exception {
        List<TrackNumberInfo> orderTList;
        DefaultKingdeeTreeNode root = this.initKDTree_Top();
        HashMap<String, String> tempM = new HashMap<String, String>();
        tempM.put("fnodetype", "BOM");
        tempM.put("fbomid", this.topBomID);
        BomInfo bomInfo = BomFactory.getRemoteInstance().getBomInfo((IObjectPK)new ObjectUuidPK(this.topBomID), this.getBomSic());
        MaterialAttributeEnum topMaterialAttr = this.getMaterialAttrFromMplan(bomInfo.getMaterial().getId().toString(), bomInfo.getStorageOrgUnit().getId().toString());
        if (topMaterialAttr == null) {
            topMaterialAttr = MaterialAttributeEnum.FABRICATEDPART;
        }
        tempM.put("fmaterialAttr", topMaterialAttr.getValue() + "");
        DefaultKingdeeTreeNode bomMaterialNote = new DefaultKingdeeTreeNode(tempM);
        String fbeginTrackNumber = null;
        String fendTrackNumber = null;
        if (bomInfo.getDesignMode() == null && bomInfo.getBomType().equals((Object)BOMTypeEnum.OrderBOM) && (orderTList = BomUtil.getOrderBomTrackNumberInfoList(null, this.topBomID)) != null && orderTList.size() > 0) {
            fbeginTrackNumber = orderTList.get(0).getNumber();
            fendTrackNumber = orderTList.get(orderTList.size() - 1).getNumber();
        }
        String dispName = BomTreeExpandUI.getTreeDisplayText(bomInfo.getMaterial() == null ? null : bomInfo.getMaterial().getNumber(), bomInfo.getMaterial() == null ? null : bomInfo.getMaterial().getName(), bomInfo.getStorageOrgUnit() == null ? null : bomInfo.getStorageOrgUnit().getName(), bomInfo.getDesignMode() == null ? null : bomInfo.getDesignMode().getName(), bomInfo.getProject() == null ? null : bomInfo.getProject().getNumber(), bomInfo.getProject() == null ? null : bomInfo.getProject().getName(), topMaterialAttr.getAlias(), bomInfo.getNumber(), bomInfo.getBomType(), fbeginTrackNumber, fendTrackNumber);
        bomMaterialNote.setText(dispName);
        bomMaterialNote.setAllowsChildren(true);
        this.kDTree1.addNodeInto((MutableTreeNode)bomMaterialNote, (MutableTreeNode)root);
        MyTreeWillExpand treeWillExpand = new MyTreeWillExpand();
        this.kDTree1.addTreeWillExpandListener((TreeWillExpandListener)treeWillExpand);
    }

    private MaterialAttributeEnum getMaterialAttrFromMplan(String materialid, String orgUnitID) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialid, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitID, CompareType.EQUALS));
        view.setFilter(filter);
        view.setSelector(this.getMpInfoSic());
        MaterialPlanCollection mcoll = MaterialPlanFactory.getRemoteInstance().getMaterialPlanCollection(view);
        if (mcoll != null && mcoll.size() > 0) {
            return mcoll.get(0).getMaterialAttr();
        }
        return null;
    }

    protected SelectorItemCollection getMpInfoSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("materialAttr"));
        return sic;
    }

    private DefaultKingdeeTreeNode initKDTree_Top() throws Exception {
        HashMap<String, String> rootMap = new HashMap<String, String>();
        rootMap.put("fnodetype", "root");
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode(rootMap);
        root.setText(EASResource.getString((String)"com.kingdee.eas.mm.basedata.EMMfgBomExResource", (String)"mfgBomEx_001"));
        KingdeeTreeModel kingdeeTreeModel = new KingdeeTreeModel((TreeNode)root);
        kingdeeTreeModel.setAsksAllowsChildren(true);
        this.kDTree1.setModel((TreeModel)kingdeeTreeModel);
        return root;
    }

    public static String getTreeDisplayText(String materialNumber, String materialName, String storageOrgUnitName, String designModeName, String projectNumber, String projectName, String materialAttrName, String bomnumber, BOMTypeEnum bomType, String fbegintracknumber, String fendtracknumber) throws BOSException {
        String returnString = null;
        if (materialNumber != null) {
            returnString = materialName;
            returnString = returnString + "[" + materialNumber + "]";
        } else {
            returnString = bomnumber;
        }
        if (storageOrgUnitName != null) {
            returnString = returnString + "" + storageOrgUnitName + "";
        }
        if (materialAttrName != null && !"".equals(materialAttrName)) {
            returnString = returnString + "(" + materialAttrName + ")";
        }
        if (designModeName != null) {
            returnString = returnString + " " + designModeName;
        } else if (bomType != null) {
            returnString = returnString + " " + bomType.getAlias();
        }
        if (projectNumber != null) {
            returnString = returnString + " [" + projectNumber + "]";
            returnString = returnString + " " + projectName + "";
        }
        if (fbegintracknumber != null && fendtracknumber != null) {
            returnString = returnString + " [" + fbegintracknumber + "] ~ [" + fendtracknumber + "]";
        }
        return returnString;
    }

    protected void addChildNodeToTree(DefaultKingdeeTreeNode parentNode) throws EASBizException, BOSException, SQLException {
        Map tempM = (Map)parentNode.getUserObject();
        String fnodeType = (String)tempM.get("fnodetype");
        Object rs = null;
        Map returnMap = null;
        if (fnodeType == null || !fnodeType.equals("BOM")) {
            return;
        }
        String bomid = (String)tempM.get("fbomid");
        returnMap = bomConvertToPBomFacadeFactory.getRemoteInstance().getBomChild(bomid, null, null, false, false);
        ArrayList dataList = null;
        if (returnMap.get("dataList") == null) {
            return;
        }
        dataList = (ArrayList)returnMap.get("dataList");
        int fbomtype = 0;
        DesignModeInfo dsInfo = null;
        HashMap<String, Object> tempMap = null;
        String displyName = "";
        if (dataList != null && dataList.size() > 0) {
            for (int i = 0; i < dataList.size(); ++i) {
                HashMap dataMap = (HashMap)dataList.get(i);
                String fbomid = (String)dataMap.get("fbomid");
                String fmaterialid = (String)dataMap.get("fmaterialid");
                String fmaterialnumber = (String)dataMap.get("fmaterialnumber");
                String fmaterialname = (String)dataMap.get("fmaterialname");
                String fstorageorgunitname = (String)dataMap.get("fstorageorgunitname");
                int fmaterialAttr = Integer.parseInt(dataMap.get("fmaterialAttr").toString());
                String fmaterialAttrName = fmaterialAttr != 0 ? MaterialAttributeEnum.getEnum((int)fmaterialAttr).getAlias() : EASResource.getString((String)"com.kingdee.eas.mm.basedata.EMMfgBomExResource", (String)"No_MaterialAttr");
                String fstorageorgunitid = (String)dataMap.get("fstorageorgunitid");
                String fprojectid = (String)dataMap.get("fprojectid");
                String fprojectnumber = (String)dataMap.get("fprojectnumber");
                String fprojectname = (String)dataMap.get("fprojectname");
                String ftrackNumberid = (String)dataMap.get("ftrackNumberId");
                String ftrackNumber = (String)dataMap.get("ftrackNumber");
                String ftrackName = (String)dataMap.get("ftrackName");
                String fbegintracknumber = (String)dataMap.get("fbegintracknumber");
                String fendtracknumber = (String)dataMap.get("fendtracknumber");
                dsInfo = dataMap.get("fdesignmode") != null ? (DesignModeInfo)dataMap.get("fdesignmode") : null;
                String fbomnumber = (String)dataMap.get("fbomnumber");
                fbomtype = dataMap.get("fbomtype") != null ? Integer.parseInt(dataMap.get("fbomtype").toString()) : 0;
                tempMap = new HashMap<String, Object>();
                tempMap.put("fnodetype", "BOM");
                tempMap.put("fprojectid", fprojectid);
                tempMap.put("ftrackNumberid", ftrackNumberid);
                tempMap.put("fmaterialid", fmaterialid);
                tempMap.put("fstorageorgunitid", fstorageorgunitid);
                tempMap.put("fmaterialAttr", fmaterialAttr);
                tempMap.put("fbomid", fbomid);
                DefaultKingdeeTreeNode TreeNode2 = new DefaultKingdeeTreeNode(tempMap);
                TreeNode2.setTextColor(Color.BLACK);
                if (fmaterialAttr == 10020) {
                    TreeNode2.setTextColor(Color.GRAY);
                }
                displyName = BomTreeExpandUI.getTreeDisplayText(fmaterialnumber, fmaterialname, fstorageorgunitname, dsInfo == null ? null : dsInfo.getName(), fprojectnumber, fprojectname, fmaterialAttrName, fbomnumber, fbomtype == 0 ? null : BOMTypeEnum.getEnum((int)fbomtype), fbegintracknumber, fendtracknumber);
                TreeNode2.setText(displyName);
                if (fbomid == null || "".equals(fbomid)) {
                    TreeNode2.setAllowsChildren(false);
                } else {
                    TreeNode2.setAllowsChildren(true);
                }
                this.kDTree1.addNodeInto((MutableTreeNode)TreeNode2, (MutableTreeNode)parentNode);
            }
        }
    }

    class MyTreeWillExpand
    implements TreeWillExpandListener {
        MyTreeWillExpand() {
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            if (BomTreeExpandUI.this.kDTree1.getRowCount() == 1) {
                return;
            }
            TreePath tp = event.getPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent();
            HashMap tempMap = (HashMap)node.getUserObject();
            if (node.getChildCount() != 0) {
                return;
            }
            try {
                BomTreeExpandUI.this.addChildNodeToTree((DefaultKingdeeTreeNode)node);
            }
            catch (Exception e) {
                BomTreeExpandUI.this.handUIException(e);
            }
        }
    }
}

