/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.convert.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.extendcontrols.ext.CommonF7KDTableListener;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.clientUtil.ComponentUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.industry.emm.project.biz.basedata.PermissionCheckFacadeFactory;
import com.kingdee.eas.mm.basedata.BOMTypeEnum;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.DesignModeInfo;
import com.kingdee.eas.mm.basedata.MMBasedataStatusEnum;
import com.kingdee.eas.mm.basedata.StandardRootingFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.client.StandardRootingEditUI;
import com.kingdee.eas.mm.basedata.util.MfgBomUtil;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.eas.zjbom.convert.bomConvertToPBomFacadeFactory;
import com.kingdee.eas.zjbom.convert.client.AbstractStdPbomUI;
import com.kingdee.eas.zjbom.convert.client.BomConvertToPBomUI;
import com.kingdee.eas.zjbom.convert.client.BomConvertToPbomOneKeyUI;
import com.kingdee.eas.zjbom.convert.util.BomUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class StdPbomUI
extends AbstractStdPbomUI {
    private static final Logger logger = CoreUIObject.getLogger(StdPbomUI.class);
    private String RESURL = "com.kingdee.eas.zjbom.convert.StdPbomResource";
    private ChangeListener radioChangeListener = null;
    protected DataChangeListener f7DataChangeListener = null;
    protected PreChangeListener f7PreChangeListener = null;
    protected SelectorListener f7SelectorListener = null;
    protected boolean isProjectChange = false;
    protected boolean isTrackChange = false;
    protected boolean isBomChange = false;
    protected boolean isTrackNumberChange = false;
    protected boolean isStorageOrgUnitChange = false;
    protected boolean isDesignModeChange = false;
    protected String queryKey = null;
    protected Map<String, List<String>> bomIDListMap = null;

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    private String getRTAddPermissionItem() {
        return "mm_standardRooting_addnew";
    }

    private String getRTEditPermissionItem() {
        return "mm_standardRooting_update";
    }

    private String getRTRemovePermissionItem() {
        return "mm_standardRooting_delete";
    }

    private String getRTAuditPermissionItem() {
        return "mm_standardRooting_audit";
    }

    private String getRTUnAuditPermissionItem() {
        return "mm_standardRooting_unAudit";
    }

    private String getRTViewPermissionItem() {
        return "mm_standardRooting_view";
    }

    private String getPBomAddPermissionItem() {
        return "mm_pbom_addnew";
    }

    private String getPBomEditPermissionItem() {
        return "mm_pbom_edit";
    }

    private void setPrmtDesignModeDefaultValue() throws Exception {
        DesignModeInfo defSdInfo = MfgBomUtil.getDefaultDesignMode(null);
        this.prmtDesignMode.setValue((Object)defSdInfo);
    }

    protected void initPrmtDesignMode() throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)8, CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtDesignMode.setEntityViewInfo(view);
    }

    private void initPrmtStorageOrgUnit() throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(PermissionCheckFacadeFactory.getRemoteInstance().getOrgIdPermission(this.getRTViewPermissionItem())), CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtStorageOrgUnit.setEntityViewInfo(view);
    }

    private void setPrmtStorageOrgUnitDefaultValue() throws Exception {
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)OrgType.Storage, (String)this.getRTViewPermissionItem());
        this.prmtStorageOrgUnit.setValue((Object)orgInfo);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtStorageOrgUnit.setEnabledMultiSelection(true);
        this.prmtDesignMode.setRequired(true);
        this.prmtBOM.setRequired(true);
        this.prmtProject.setRequired(false);
        this.prmtTrackNumber.setRequired(false);
        this.prmtStorageOrgUnit.setRequired(true);
        this.initPrmtStorageOrgUnit();
        this.setPrmtStorageOrgUnitDefaultValue();
        this.initPrmtDesignMode();
        this.setPrmtDesignModeDefaultValue();
        this.contTrackNumber.setVisible(false);
        this.kDRadioButtonBom.setSelected(true);
        this.kdRDButtonAllData.setSelected(true);
        this.kdRDButtonAllStd.setSelected(true);
        this.prmtBOM.addCommonF7KDTableListener((CommonF7KDTableListener)new CommonF7KDTableListenerImpl(EASResource.getString((String)this.RESURL, (String)"BOMNumber"), this.prmtBOM));
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.addListener();
        UIHelper.registerProjectF7ForEdit((KDBizPromptBox)this.prmtStorageOrgUnit, null, (KDBizPromptBox)this.prmtProject);
        this.kdtPBOM.checkParsed();
        this.kdtRT.checkParsed();
        this.kdtEntrysSetEditor();
        this.kdtPBOMSortable();
        this.kdtRTSortable();
        this.setKDTSelectMode();
    }

    protected void kdtPBOMSortable() {
        KDTSortManager som = new KDTSortManager(this.kdtPBOM);
        som.setSortAuto(true);
        for (int row = 0; row < this.kdtPBOM.getColumnCount(); ++row) {
            this.kdtPBOM.getColumn(row).setSortable(true);
        }
    }

    protected void kdtRTSortable() {
        KDTSortManager som = new KDTSortManager(this.kdtRT);
        som.setSortAuto(true);
        for (int row = 0; row < this.kdtRT.getColumnCount(); ++row) {
            this.kdtRT.getColumn(row).setSortable(true);
        }
    }

    protected void kdtEntrysSetEditor() {
        KDComboBox comboRTStatus = new KDComboBox();
        comboRTStatus.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.mm.basedata.MMBasedataStatusEnum").toArray());
        this.kdtRT.getColumn("rtStatus").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comboRTStatus));
        KDComboBox comboBomType = new KDComboBox();
        comboBomType.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.mm.basedata.BOMTypeEnum").toArray());
        this.kdtRT.getColumn("bomtype").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comboBomType));
        this.kdtRT.getColumn("ismainRT").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
        this.kdtRT.getColumn("isdefStd").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
        this.kdtPBOM.getColumn("isdefStd").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
    }

    protected void removeListener() {
        if (this.f7DataChangeListener != null) {
            this.prmtStorageOrgUnit.removeDataChangeListener(this.f7DataChangeListener);
            this.prmtProject.removeDataChangeListener(this.f7DataChangeListener);
            this.prmtTrackNumber.removeDataChangeListener(this.f7DataChangeListener);
            this.prmtBOM.removeDataChangeListener(this.f7DataChangeListener);
            this.prmtDesignMode.removeDataChangeListener(this.f7DataChangeListener);
        }
        if (this.f7PreChangeListener != null) {
            this.prmtStorageOrgUnit.removePreChangeListener(this.f7PreChangeListener);
            this.prmtProject.removePreChangeListener(this.f7PreChangeListener);
            this.prmtTrackNumber.removePreChangeListener(this.f7PreChangeListener);
            this.prmtBOM.removePreChangeListener(this.f7PreChangeListener);
            this.prmtDesignMode.removePreChangeListener(this.f7PreChangeListener);
        }
        if (this.f7SelectorListener != null) {
            this.prmtStorageOrgUnit.removeSelectorListener(this.f7SelectorListener);
            this.prmtProject.removeSelectorListener(this.f7SelectorListener);
            this.prmtTrackNumber.removeSelectorListener(this.f7SelectorListener);
            this.prmtBOM.removeSelectorListener(this.f7SelectorListener);
            this.prmtDesignMode.removeSelectorListener(this.f7SelectorListener);
        }
        if (this.radioChangeListener != null) {
            this.kDRadioButtonBom.removeChangeListener(this.radioChangeListener);
            this.kDRadioButtonBomChild.removeChangeListener(this.radioChangeListener);
            this.kDRadioButtonProject.removeChangeListener(this.radioChangeListener);
            this.kdRDButtonAllData.removeChangeListener(this.radioChangeListener);
            this.kdRDButtonNoAudit.removeChangeListener(this.radioChangeListener);
            this.kdRDButtonNoRT.removeChangeListener(this.radioChangeListener);
            this.kdRDButtonAllStd.removeChangeListener(this.radioChangeListener);
            this.kdRDButtonDefStd.removeChangeListener(this.radioChangeListener);
        }
    }

    protected void addListener() {
        if (this.radioChangeListener == null) {
            this.radioChangeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    try {
                        StdPbomUI.this.radioStateChanged(e);
                    }
                    catch (Exception e1) {
                        StdPbomUI.this.handUIException(e1);
                    }
                }
            };
        }
        this.kDRadioButtonBom.addChangeListener(this.radioChangeListener);
        this.kDRadioButtonBomChild.addChangeListener(this.radioChangeListener);
        this.kDRadioButtonProject.addChangeListener(this.radioChangeListener);
        this.kdRDButtonAllData.addChangeListener(this.radioChangeListener);
        this.kdRDButtonAllStd.addChangeListener(this.radioChangeListener);
        this.kdRDButtonDefStd.addChangeListener(this.radioChangeListener);
        this.kdRDButtonNoAudit.addChangeListener(this.radioChangeListener);
        this.kdRDButtonNoRT.addChangeListener(this.radioChangeListener);
        if (this.f7DataChangeListener == null) {
            this.f7DataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        StdPbomUI.this.f7DataChange(e);
                    }
                    catch (Exception exc) {
                        StdPbomUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtStorageOrgUnit.addDataChangeListener(this.f7DataChangeListener);
        this.prmtProject.addDataChangeListener(this.f7DataChangeListener);
        this.prmtTrackNumber.addDataChangeListener(this.f7DataChangeListener);
        this.prmtBOM.addDataChangeListener(this.f7DataChangeListener);
        this.prmtDesignMode.addDataChangeListener(this.f7DataChangeListener);
        if (this.f7PreChangeListener == null) {
            this.f7PreChangeListener = new PreChangeListener(){

                public void preChange(PreChangeEvent e) {
                    try {
                        StdPbomUI.this.f7PreChange(e);
                    }
                    catch (Exception exc) {
                        StdPbomUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtStorageOrgUnit.addPreChangeListener(this.f7PreChangeListener);
        this.prmtProject.addPreChangeListener(this.f7PreChangeListener);
        this.prmtTrackNumber.addPreChangeListener(this.f7PreChangeListener);
        this.prmtBOM.addPreChangeListener(this.f7PreChangeListener);
        this.prmtDesignMode.addPreChangeListener(this.f7PreChangeListener);
        if (this.f7SelectorListener == null) {
            this.f7SelectorListener = new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    try {
                        StdPbomUI.this.f7WillShow(e);
                    }
                    catch (Exception exc) {
                        StdPbomUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtStorageOrgUnit.addSelectorListener(this.f7SelectorListener);
        this.prmtProject.addSelectorListener(this.f7SelectorListener);
        this.prmtTrackNumber.addSelectorListener(this.f7SelectorListener);
        this.prmtBOM.addSelectorListener(this.f7SelectorListener);
        this.prmtDesignMode.addSelectorListener(this.f7SelectorListener);
    }

    protected void SetBOMFilter() throws Exception {
        DesignModeInfo dsInfo = null;
        if (this.prmtDesignMode.getValue() != null) {
            dsInfo = (DesignModeInfo)this.prmtDesignMode.getValue();
        }
        ProjectInfo projectInfo = null;
        if (dsInfo != null && dsInfo.isProject()) {
            projectInfo = (ProjectInfo)this.prmtProject.getValue();
        }
        TrackNumberInfo trackNumberInfo = null;
        if (dsInfo != null && !dsInfo.isProject() && dsInfo.isTrackNumber()) {
            trackNumberInfo = (TrackNumberInfo)this.prmtTrackNumber.getValue();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        Set<String> storageOrgUnitIDSet = this.getStorageOrgUnitIDSet();
        if (storageOrgUnitIDSet == null || storageOrgUnitIDSet.size() < 1) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", null, CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", storageOrgUnitIDSet, CompareType.INCLUDE));
        }
        if (dsInfo != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("designMode.id", (Object)dsInfo.getId(), CompareType.EQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS));
        if (projectInfo != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("project.id", (Object)projectInfo.getId().toString(), CompareType.EQUALS));
        }
        if (trackNumberInfo != null) {
            StringBuilder sql = new StringBuilder();
            sql.append(" Select bd.fparentid from t_mm_bomentry bd inner join t_mm_tracknumber bt on bt.fid = bd.fbegincarnoid inner join t_mm_tracknumber et on et.fid = bd.fendcarnoid where bt.fnumber <= '" + trackNumberInfo.getNumber() + "' and et.fnumber >= '" + trackNumberInfo.getNumber() + "' ");
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        }
        view.setFilter(filterInfo);
        this.prmtBOM.setEntityViewInfo(view);
        this.prmtBOM.getQueryAgent().resetRuntimeEntityView();
    }

    protected void clearKDTSelectRows(KDTable tbl) {
        if (tbl == null) {
            this.kdtPBOM.getSelectManager().removeAll();
            this.kdtRT.getSelectManager().removeAll();
        } else {
            tbl.getSelectManager().removeAll();
        }
    }

    protected void clearKDTRows(KDTable tbl) {
        if (tbl == null) {
            this.kdtRT.removeRows();
            this.kdtPBOM.removeRows();
        } else {
            tbl.removeRows();
        }
    }

    protected Object getDataChangeObject(DataChangeEvent e) throws BOSException {
        String name = ((KDBizPromptBox)e.getSource()).getName();
        Object[] newValues = null;
        Object[] oldValues = null;
        Object newInfo = null;
        if (e.getNewValue() instanceof Object[]) {
            newValues = (Object[])e.getNewValue();
        } else if (e.getNewValue() instanceof Object) {
            newValues = new Object[]{e.getNewValue()};
        }
        if (e.getOldValue() instanceof Object[]) {
            oldValues = (Object[])e.getOldValue();
        } else if (e.getOldValue() instanceof Object) {
            oldValues = new Object[]{e.getOldValue()};
        }
        if (newValues == null && oldValues == null) {
            return null;
        }
        if (newValues == null && oldValues != null) {
            if (oldValues.length > 0 && oldValues[0] == null) {
                return null;
            }
        } else if (newValues != null && oldValues == null) {
            if (newValues.length > 0 && newValues[0] == null) {
                return null;
            }
        } else if (newValues != null && oldValues != null) {
            if (newValues.length > 0 && oldValues.length > 0 && newValues[0] == null && oldValues[0] == null) {
                return null;
            }
            if (newValues.length > 0 && oldValues.length > 0 && newValues[0] != null && oldValues[0] != null && newValues[0].toString().equals(oldValues[0].toString())) {
                return null;
            }
        }
        if (newValues != null && newValues.length > 0 && newValues[0] != null) {
            newInfo = newValues[0];
        }
        return newInfo;
    }

    protected void storageOrgUnitDataChange() throws Exception {
        if (this.isBomChange || this.isProjectChange || this.isTrackNumberChange || this.isDesignModeChange) {
            return;
        }
        try {
            this.isStorageOrgUnitChange = true;
            if (!this.isProjectChange) {
                this.prmtProject.setValue(null);
            }
            if (!this.isTrackNumberChange) {
                this.prmtTrackNumber.setValue(null);
            }
            if (!this.isBomChange) {
                this.prmtBOM.setValue(null);
            }
            this.prmtMaterial.setValue(null);
            this.txtMaterialName.setText(null);
            this.clearKDTSelectRows(null);
            this.clearKDTRows(null);
            this.SetBOMFilter();
        }
        finally {
            this.isStorageOrgUnitChange = false;
        }
    }

    protected void designModeDataChange() throws Exception {
        if (this.isBomChange || this.isProjectChange || this.isTrackNumberChange || this.isStorageOrgUnitChange) {
            return;
        }
        try {
            this.isDesignModeChange = true;
            this.prmtProject.setValue(null);
            this.prmtTrackNumber.setValue(null);
            this.prmtBOM.setValue(null);
            this.prmtMaterial.setValue(null);
            this.txtMaterialName.setText(null);
            DesignModeInfo dsInfo = (DesignModeInfo)this.prmtDesignMode.getValue();
            if (dsInfo != null && !dsInfo.isProject() && !dsInfo.isTrackNumber()) {
                this.prmtProject.setEnabled(false);
                this.prmtProject.setRequired(false);
                this.prmtTrackNumber.setEnabled(false);
                this.prmtTrackNumber.setRequired(false);
                this.contTrackNumber.setVisible(false);
                this.contProject.setVisible(true);
                this.kDRadioButtonProject.setEnabled(false);
                this.kDRadioButtonBom.setSelected(true);
                this.kDRadioButtonProject.setSelected(false);
                this.kDRadioButtonBomChild.setSelected(false);
            } else if (dsInfo != null && !dsInfo.isProject() && dsInfo.isTrackNumber()) {
                this.prmtProject.setEnabled(false);
                this.prmtProject.setRequired(false);
                this.prmtTrackNumber.setEnabled(true);
                this.prmtTrackNumber.setRequired(true);
                this.contTrackNumber.setVisible(true);
                this.contProject.setVisible(false);
                this.kDRadioButtonProject.setEnabled(false);
                this.kDRadioButtonBom.setSelected(true);
                this.kDRadioButtonProject.setSelected(false);
                this.kDRadioButtonBomChild.setSelected(false);
            } else {
                this.prmtProject.setEnabled(true);
                this.prmtProject.setRequired(true);
                this.prmtTrackNumber.setEnabled(false);
                this.prmtTrackNumber.setRequired(false);
                this.contTrackNumber.setVisible(false);
                this.contProject.setVisible(true);
                this.kDRadioButtonProject.setEnabled(true);
            }
            this.clearKDTSelectRows(null);
            this.clearKDTRows(null);
            this.SetBOMFilter();
        }
        finally {
            this.isDesignModeChange = false;
        }
    }

    protected void projectDataChange() throws Exception {
        if (this.isBomChange || this.isStorageOrgUnitChange || this.isDesignModeChange || this.isTrackNumberChange) {
            return;
        }
        try {
            this.isProjectChange = true;
            this.prmtBOM.setValue(null);
            this.prmtMaterial.setValue(null);
            this.txtMaterialName.setText(null);
            this.clearKDTSelectRows(null);
            this.clearKDTRows(null);
            this.SetBOMFilter();
        }
        finally {
            this.isProjectChange = false;
        }
    }

    protected void trackNumberDataChange() throws Exception {
        if (this.isBomChange || this.isStorageOrgUnitChange || this.isDesignModeChange || this.isProjectChange) {
            return;
        }
        try {
            this.isTrackNumberChange = true;
            this.prmtBOM.setValue(null);
            this.prmtMaterial.setValue(null);
            this.txtMaterialName.setText(null);
            this.clearKDTSelectRows(null);
            this.clearKDTRows(null);
            this.SetBOMFilter();
        }
        finally {
            this.isTrackNumberChange = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bomDataChange() throws Exception {
        if (this.isProjectChange || this.isStorageOrgUnitChange || this.isDesignModeChange || this.isTrackNumberChange) {
            return;
        }
        try {
            this.isBomChange = true;
            this.prmtMaterial.setValue(null);
            this.txtMaterialName.setText(null);
            this.SetMaterialValue();
            this.SetProjectOrTrackNumberValue();
            this.clearKDTSelectRows(null);
            this.clearKDTRows(null);
            if (this.prmtBOM.getValue() != null) {
                BomInfo bom = (BomInfo)this.prmtBOM.getValue();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("designmode.id"));
                selector.add(new SelectorItemInfo("designmode.number"));
                selector.add(new SelectorItemInfo("designmode.name"));
                BomInfo bomInfo = BomFactory.getRemoteInstance().getBomInfo((IObjectPK)new ObjectUuidPK(bom.getId().toString()), selector);
                if (this.prmtDesignMode.getValue() == null) {
                    this.prmtDesignMode.setValue((Object)bomInfo.getDesignMode());
                }
            }
        }
        finally {
            this.isBomChange = false;
        }
    }

    protected void SetMaterialValue() throws Exception {
        BomInfo bomInfo = null;
        if (this.prmtBOM.getValue() != null) {
            bomInfo = (BomInfo)this.prmtBOM.getValue();
            if (bomInfo.getMaterial() == null) {
                this.prmtMaterial.setValue(null);
                this.txtMaterialName.setText(null);
            } else if (bomInfo.getMaterial().getNumber() == null || bomInfo.getMaterial().getNumber().equals("")) {
                MaterialInfo mInfo = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(bomInfo.getMaterial().getId().toString()));
                this.prmtMaterial.setValue((Object)mInfo);
                this.txtMaterialName.setText(mInfo.getName());
            } else {
                this.prmtMaterial.setValue((Object)bomInfo.getMaterial());
                this.txtMaterialName.setText(bomInfo.getMaterial().getName());
            }
        } else {
            this.prmtMaterial.setValue(null);
            this.txtMaterialName.setText(null);
            return;
        }
    }

    protected TrackNumberInfo getBomFirstTrackNumberInfo(BomInfo bomInfo) throws Exception {
        List<TrackNumberInfo> list;
        TrackNumberInfo info = null;
        if (bomInfo != null && (list = BomUtil.getBomTrackNumberInfoList(null, bomInfo)) != null && list.size() > 0) {
            return list.get(0);
        }
        return info;
    }

    protected void SetProjectOrTrackNumberValue() throws Exception {
        BomInfo bomInfo = null;
        DesignModeInfo dsInfo = null;
        if (this.prmtDesignMode.getValue() != null) {
            dsInfo = (DesignModeInfo)this.prmtDesignMode.getValue();
        }
        if (dsInfo != null && dsInfo.isProject() && this.prmtBOM.getValue() != null) {
            ProjectInfo oldProjectinfo = null;
            if (this.prmtProject.getValue() != null) {
                oldProjectinfo = (ProjectInfo)this.prmtProject.getValue();
            }
            bomInfo = (BomInfo)this.prmtBOM.getValue();
            if (oldProjectinfo == null && bomInfo.getProject() == null) {
                return;
            }
            if (oldProjectinfo != null && bomInfo.getProject() != null && bomInfo.getProject().getId().toString().equals(oldProjectinfo.getId().toString())) {
                return;
            }
            if (bomInfo.getProject() == null) {
                this.prmtProject.setValue(null);
            } else if (bomInfo.getProject().getNumber() == null || bomInfo.getProject().getNumber().equals("")) {
                ProjectInfo pInfo = ProjectFactory.getRemoteInstance().getProjectInfo((IObjectPK)new ObjectUuidPK(bomInfo.getProject().getId().toString()));
                this.prmtProject.setValue((Object)pInfo);
            } else {
                this.prmtProject.setValue((Object)bomInfo.getProject());
            }
        } else if (dsInfo != null && !dsInfo.isProject() && dsInfo.isTrackNumber() && this.prmtBOM.getValue() != null) {
            TrackNumberInfo oldTrackNumberInfo = null;
            if (this.prmtTrackNumber.getValue() != null) {
                oldTrackNumberInfo = (TrackNumberInfo)this.prmtTrackNumber.getValue();
            }
            bomInfo = (BomInfo)this.prmtBOM.getValue();
            TrackNumberInfo newTrackNumberInfo = this.getBomFirstTrackNumberInfo(bomInfo);
            if (oldTrackNumberInfo == null && newTrackNumberInfo == null) {
                return;
            }
            if (oldTrackNumberInfo != null && newTrackNumberInfo != null && oldTrackNumberInfo.getId().toString().equals(newTrackNumberInfo.getId().toString())) {
                return;
            }
            this.prmtTrackNumber.setValue((Object)newTrackNumberInfo);
        }
    }

    protected void f7DataChange(DataChangeEvent e) throws Exception {
        String name = ((KDBizPromptBox)e.getSource()).getName();
        if (name != null && name.equals(this.prmtStorageOrgUnit.getName())) {
            this.storageOrgUnitDataChange();
        }
        if (name != null && name.equals(this.prmtDesignMode.getName())) {
            this.designModeDataChange();
        }
        if (name != null && name.equals(this.prmtProject.getName())) {
            this.projectDataChange();
        }
        if (name != null && name.equals(this.prmtTrackNumber.getName())) {
            this.trackNumberDataChange();
        }
        if (name != null && name.equals(this.prmtBOM.getName())) {
            this.bomDataChange();
        }
    }

    protected void f7PreChange(PreChangeEvent e) throws BOSException {
    }

    protected void f7WillShow(SelectorEvent e) {
        if (e.getSource() == null || !(e.getSource() instanceof KDBizPromptBox)) {
            e.setCanceled(true);
            return;
        }
        String name = ((KDBizPromptBox)e.getSource()).getName();
        if (name.equals(this.prmtProject.getName()) || name.equals(this.prmtTrackNumber.getName())) {
            if (this.prmtStorageOrgUnit.getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)this.RESURL, (String)"StorageOrgUnit_NULL"));
                e.setCanceled(true);
                return;
            }
            if (this.prmtDesignMode.getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)this.RESURL, (String)"DesignMode_IsNull"));
                e.setCanceled(true);
                return;
            }
        }
        if (name.equals(this.prmtBOM.getName()) && this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)this.RESURL, (String)"StorageOrgUnit_NULL"));
            e.setCanceled(true);
            return;
        }
        if ((name.equals(this.prmtProject.getName()) || name.equals(this.prmtTrackNumber.getName())) && this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)this.RESURL, (String)"StorageOrgUnit_NULL"));
            e.setCanceled(true);
            return;
        }
        if (name.equals(this.prmtBOM.getName())) {
            try {
                this.SetBOMFilter();
            }
            catch (Exception e1) {
                e1.printStackTrace();
                this.handleException(e1);
            }
        }
    }

    protected void radioStateChanged(ChangeEvent e) {
        if (e.getSource().equals(this.kDRadioButtonBom) || e.getSource().equals(this.kDRadioButtonBomChild) || e.getSource().equals(this.kDRadioButtonProject) || e.getSource().equals(this.kdRDButtonAllData) || e.getSource().equals(this.kdRDButtonAllStd) || e.getSource().equals(this.kdRDButtonDefStd) || e.getSource().equals(this.kdRDButtonNoAudit) || e.getSource().equals(this.kdRDButtonNoRT)) {
            if (e.getSource().equals(this.kDRadioButtonBom) && this.kDRadioButtonBom.isSelected()) {
                this.kDRadioButtonBomChild.setSelected(false);
                this.kDRadioButtonProject.setSelected(false);
            }
            if (e.getSource().equals(this.kDRadioButtonBomChild) && this.kDRadioButtonBomChild.isSelected()) {
                this.kDRadioButtonBom.setSelected(false);
                this.kDRadioButtonProject.setSelected(false);
            }
            if (e.getSource().equals(this.kDRadioButtonProject) && this.kDRadioButtonProject.isSelected()) {
                this.kDRadioButtonBomChild.setSelected(false);
                this.kDRadioButtonBom.setSelected(false);
            }
            if (e.getSource().equals(this.kdRDButtonAllData) && this.kdRDButtonAllData.isSelected()) {
                this.kdRDButtonNoAudit.setSelected(false);
                this.kdRDButtonNoRT.setSelected(false);
            }
            if (e.getSource().equals(this.kdRDButtonNoAudit) && this.kdRDButtonNoAudit.isSelected()) {
                this.kdRDButtonAllData.setSelected(false);
                this.kdRDButtonNoRT.setSelected(false);
            }
            if (e.getSource().equals(this.kdRDButtonNoRT) && this.kdRDButtonNoRT.isSelected()) {
                this.kdRDButtonNoAudit.setSelected(false);
                this.kdRDButtonAllData.setSelected(false);
            }
            if (e.getSource().equals(this.kdRDButtonAllStd) && this.kdRDButtonAllStd.isSelected()) {
                this.kdRDButtonDefStd.setSelected(false);
            }
            if (e.getSource().equals(this.kdRDButtonDefStd) && this.kdRDButtonDefStd.isSelected()) {
                this.kdRDButtonAllStd.setSelected(false);
            }
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnSubmit.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnCopy.setVisible(false);
        this.contBOM.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.mm.report.ReportResource", (String)"BOM_NUM"));
        this.contMaterial.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.mm.report.REPORTAutoGenerateResource", (String)"89_PlantProduceReportFilterUI"));
        this.kdtRT.getHeadRow(0).getCell("rtStatus").setValue((Object)EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.processresource", (String)"statusName"));
        this.kdtRT.getHeadRow(0).getCell("auditname").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"247_GLXMLGenerator"));
        this.kdtRT.getHeadRow(0).getCell("audittime").setValue((Object)EASResource.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptResource", (String)"aduitTime"));
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemAddNew});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemEdit});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemSubmit});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemSave});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemRemove});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemPre});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemCopy});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemNext});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemLast});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemFirst});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemPrint});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemPrintPreview});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemCancel});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemCancelCancel});
    }

    protected void setKDTSelectMode() {
        this.kdtPBOM.getSelectManager().setSelectMode(10);
        this.kdtRT.getSelectManager().setSelectMode(10);
    }

    public static boolean hasPermission(String permItemName, ObjectUuidPK orgIdPK) throws EASBizException, BOSException {
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        return PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgIdPK, permItemName);
    }

    @Override
    protected void btnQueryRT_actionPerformed(ActionEvent e) throws Exception {
        Component[] cps;
        this.checkDataInput();
        this.clearKDTSelectRows(this.kdtRT);
        this.clearKDTRows(this.kdtRT);
        LongTimeDialog dialog = new LongTimeDialog((Frame)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        dialog.setLongTimeTask(new ILongTimeTask(){

            public void afterExec(Object result) throws Exception {
            }

            public Object exec() {
                try {
                    StdPbomUI.this.queryRTKDEntryDatas();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    StdPbomUI.this.handleException(e);
                }
                return EASResource.getString((String)StdPbomUI.this.RESURL, (String)"LoadDataEnd");
            }
        });
        for (Component cp : cps = dialog.getContentPane().getComponents()) {
            if (!(cp instanceof JLabel)) continue;
            ((JLabel)cp).setText(EASResource.getString((String)this.RESURL, (String)"LoadDataIng_PleaseWait"));
        }
        dialog.show();
    }

    protected void queryRTKDEntryDatas() throws Exception {
        Map queryMap = this.getQueryDataMap();
        List<String> bomIDList = null;
        if (this.bomIDListMap != null && this.bomIDListMap.containsKey(this.queryKey)) {
            bomIDList = this.bomIDListMap.get(this.queryKey);
        } else {
            bomIDList = bomConvertToPBomFacadeFactory.getRemoteInstance().getChildBomIDList(queryMap);
            if (this.bomIDListMap == null) {
                this.bomIDListMap = new HashMap<String, List<String>>();
            }
            this.bomIDListMap.put(this.queryKey, bomIDList);
        }
        if (bomIDList != null && bomIDList.size() > 0) {
            HashMap<String, Object> queryDataMap = new HashMap<String, Object>();
            queryDataMap.put("bomIDList", bomIDList);
            queryDataMap.put("rtQueryType", this.getRTQueryType());
            IRowSet rs = bomConvertToPBomFacadeFactory.getRemoteInstance().getStdInfoDatas(queryDataMap);
            Map defRtMap = bomConvertToPBomFacadeFactory.getRemoteInstance().getBomDefStdMap(bomIDList);
            IRow arow = null;
            String rtid = null;
            String bomid = null;
            while (rs.next()) {
                arow = this.kdtRT.addRow();
                arow.getCell("storageorgunit.name").setValue((Object)rs.getString("fstorageorgunitname"));
                arow.getCell("bom.number").setValue((Object)rs.getString("fbomnumber"));
                arow.getCell("bomtype").setValue((Object)BOMTypeEnum.getEnum((int)rs.getInt("fbomtype")));
                arow.getCell("material.id").setValue((Object)rs.getString("fmaterialid"));
                arow.getCell("material.number").setValue((Object)rs.getString("fmaterialnumber"));
                arow.getCell("material.name").setValue((Object)rs.getString("fmaterialname"));
                rtid = rs.getString("fstdid");
                bomid = rs.getString("fbomid");
                if (rtid != null) {
                    arow.getCell("std.id").setValue((Object)rtid);
                    arow.getCell("std.number").setValue((Object)rs.getString("fstdnumber"));
                    if (rs.getString("fismainrooting") != null && rs.getString("fismainrooting").equals("1")) {
                        arow.getCell("ismainRT").setValue((Object)true);
                    } else {
                        arow.getCell("ismainRT").setValue((Object)false);
                    }
                    arow.getCell("rtStatus").setValue((Object)MMBasedataStatusEnum.getEnum((int)rs.getInt("fstdstatus")));
                    arow.getCell("auditname").setValue((Object)rs.getString("fauditorname"));
                    arow.getCell("audittime").setValue((Object)rs.getString("faudittime"));
                    if (rs.getInt("fstdstatus") == 60) {
                        arow.getCell("rtStatus").getStyleAttributes().setBackground(Color.green);
                    }
                    if (defRtMap != null && defRtMap.containsKey(bomid) && defRtMap.get(bomid) != null && ((String)defRtMap.get(bomid)).toString().equals(rtid)) {
                        arow.getCell("isdefStd").setValue((Object)true);
                    } else {
                        arow.getCell("isdefStd").setValue((Object)false);
                    }
                }
                arow.getCell("bom.id").setValue((Object)bomid);
                arow.getCell("storageorgunit.id").setValue((Object)rs.getString("fstorageorgunitid"));
            }
        }
    }

    protected Set<String> getStorageOrgUnitIDSet() {
        Object objects = this.prmtStorageOrgUnit.getValue();
        if (objects == null) {
            return null;
        }
        HashSet<String> orgSet = new HashSet<String>();
        if (objects instanceof Object[]) {
            Object[] infos = (Object[])objects;
            for (int i = 0; i < infos.length; ++i) {
                StorageOrgUnitInfo info;
                if (infos[i] instanceof StorageOrgUnitInfo) {
                    info = (StorageOrgUnitInfo)infos[i];
                    orgSet.add(info.getId().toString());
                    continue;
                }
                if (!(infos[i] instanceof FullOrgUnitInfo)) continue;
                info = (FullOrgUnitInfo)infos[i];
                orgSet.add(info.getId().toString());
            }
        } else if (objects instanceof Object) {
            if (objects instanceof StorageOrgUnitInfo) {
                StorageOrgUnitInfo info = (StorageOrgUnitInfo)objects;
                orgSet.add(info.getId().toString());
            } else if (objects instanceof FullOrgUnitInfo) {
                FullOrgUnitInfo info = (FullOrgUnitInfo)objects;
                orgSet.add(info.getId().toString());
            }
        }
        return orgSet;
    }

    protected Map getQueryDataMap() {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        Set<String> storageOrgUnitIDSet = this.getStorageOrgUnitIDSet();
        this.queryKey = storageOrgUnitIDSet.toString();
        DesignModeInfo dsInfo = null;
        if (this.prmtDesignMode.getValue() != null) {
            dsInfo = (DesignModeInfo)this.prmtDesignMode.getValue();
            this.queryKey = this.queryKey + dsInfo.getId().toString();
        }
        BomInfo bomInfo = null;
        if (this.prmtBOM.getValue() != null) {
            bomInfo = (BomInfo)this.prmtBOM.getValue();
            this.queryKey = this.queryKey + bomInfo.getId().toString();
        }
        ProjectInfo projectInfo = null;
        if (this.prmtProject.getValue() != null) {
            projectInfo = (ProjectInfo)this.prmtProject.getValue();
            this.queryKey = this.queryKey + projectInfo.getId().toString();
        }
        TrackNumberInfo trackNumberInfo = null;
        if (this.prmtTrackNumber.getValue() != null) {
            trackNumberInfo = (TrackNumberInfo)this.prmtTrackNumber.getValue();
            this.queryKey = this.queryKey + trackNumberInfo.getId().toString();
        }
        int queryBomType = this.getQueryBomType();
        this.queryKey = this.queryKey + queryBomType;
        queryMap.put("storageOrgUnitIDSet", storageOrgUnitIDSet);
        queryMap.put("designMode", dsInfo);
        queryMap.put("bomInfo", bomInfo);
        queryMap.put("projectInfo", projectInfo);
        queryMap.put("trackNumberInfo", trackNumberInfo);
        queryMap.put("queryBomType", queryBomType);
        return queryMap;
    }

    protected void checkDataInput() throws Exception {
        int queryBomType;
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)this.RESURL, (String)"StorageOrgUnit_NULL"));
            SysUtil.abort();
            return;
        }
        if (this.prmtDesignMode.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)this.RESURL, (String)"DesignMode_IsNull"));
            SysUtil.abort();
            return;
        }
        DesignModeInfo dsInfo = null;
        if (this.prmtDesignMode.getValue() != null) {
            dsInfo = (DesignModeInfo)this.prmtDesignMode.getValue();
        }
        if (this.prmtBOM.getValue() == null) {
            if (dsInfo.isProject()) {
                if (this.prmtProject.getValue() == null) {
                    MsgBox.showInfo((String)EASResource.getString((String)this.RESURL, (String)"BomOrProject_Null"));
                    SysUtil.abort();
                    return;
                }
            } else if (!dsInfo.isProject() && dsInfo.isTrackNumber()) {
                if (this.prmtTrackNumber.getValue() == null) {
                    MsgBox.showInfo((String)EASResource.getString((String)this.RESURL, (String)"BomOrTrack_Null"));
                    SysUtil.abort();
                    return;
                }
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)this.RESURL, (String)"Bom_Null"));
                SysUtil.abort();
                return;
            }
        }
        if ((queryBomType = this.getQueryBomType()) == 0 || queryBomType == 1) {
            if (this.prmtBOM.getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)this.RESURL, (String)"Bom_Null"));
                SysUtil.abort();
                return;
            }
        } else if (this.prmtProject.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)this.RESURL, (String)"Project_Null"));
            SysUtil.abort();
            return;
        }
    }

    protected int getQueryBomType() {
        int queryBomType = 0;
        if (this.kDRadioButtonBomChild.isSelected()) {
            queryBomType = 1;
        } else if (this.kDRadioButtonProject.isSelected()) {
            queryBomType = 2;
        }
        return queryBomType;
    }

    protected int getRTQueryType() {
        int values = 0;
        values = this.kdRDButtonAllData.isSelected() ? 1 : (this.kdRDButtonNoRT.isSelected() ? 2 : 3);
        return values;
    }

    protected int getPBOMQueryType() {
        int values = 0;
        if (this.kdRDButtonAllStd.isSelected()) {
            values = 1;
        } else if (this.kdRDButtonDefStd.isSelected()) {
            values = 2;
        }
        return values;
    }

    protected List<IRow> getSelectRowList(KDTable kdtable) throws Exception {
        ArrayList<IRow> selectedRowList = new ArrayList<IRow>();
        int size = kdtable.getSelectManager().size();
        if (size > 0) {
            KDTSelectBlock selectBlock = null;
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = kdtable.getSelectManager().get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                for (int i = top; i <= bottom; ++i) {
                    selectedRowList.add(kdtable.getRow(i));
                }
            }
        }
        return selectedRowList;
    }

    protected void checkPerMission(String permissItem, String orgID, String orgName) throws Exception {
        if (!this.checkPerMissionBoolean(permissItem, orgID, orgName)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)permissItem, (Object[])new String[]{orgName}));
            SysUtil.abort();
        }
    }

    protected boolean checkPerMissionBoolean(String permissItem, String orgID, String orgName) throws Exception {
        boolean rule = StdPbomUI.hasPermission(permissItem, new ObjectUuidPK(orgID));
        return rule;
    }

    @Override
    protected void btnQueryPBom_actionPerformed(ActionEvent e) throws Exception {
        Component[] cps;
        this.checkDataInput();
        this.clearKDTSelectRows(this.kdtPBOM);
        this.clearKDTRows(this.kdtPBOM);
        LongTimeDialog dialog = new LongTimeDialog((Frame)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        dialog.setLongTimeTask(new ILongTimeTask(){

            public void afterExec(Object result) throws Exception {
            }

            public Object exec() {
                try {
                    StdPbomUI.this.queryPBOMKDEntryDatas();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    StdPbomUI.this.handleException(e);
                }
                return EASResource.getString((String)StdPbomUI.this.RESURL, (String)"LoadDataEnd");
            }
        });
        for (Component cp : cps = dialog.getContentPane().getComponents()) {
            if (!(cp instanceof JLabel)) continue;
            ((JLabel)cp).setText(EASResource.getString((String)this.RESURL, (String)"LoadDataIng_PleaseWait"));
        }
        dialog.show();
    }

    protected void queryPBOMKDEntryDatas() throws Exception {
        Map queryMap = this.getQueryDataMap();
        List<String> bomIDList = null;
        if (this.bomIDListMap != null && this.bomIDListMap.containsKey(this.queryKey)) {
            bomIDList = this.bomIDListMap.get(this.queryKey);
        } else {
            bomIDList = bomConvertToPBomFacadeFactory.getRemoteInstance().getChildBomIDList(queryMap);
            if (this.bomIDListMap == null) {
                this.bomIDListMap = new HashMap<String, List<String>>();
            }
            this.bomIDListMap.put(this.queryKey, bomIDList);
        }
        if (bomIDList != null && bomIDList.size() > 0) {
            HashMap<String, Object> queryDataMap = new HashMap<String, Object>();
            queryDataMap.put("bomIDList", bomIDList);
            queryDataMap.put("pbomQueryType", this.getPBOMQueryType());
            IRowSet rs = bomConvertToPBomFacadeFactory.getRemoteInstance().getBomStdPboms(queryDataMap);
            IRow arow = null;
            while (rs.next()) {
                arow = this.kdtPBOM.addRow();
                arow.getCell("storageorgunit.name").setValue((Object)rs.getString("fstorageorgunitname"));
                arow.getCell("bom.number").setValue((Object)rs.getString("fbomnumber"));
                arow.getCell("material.id").setValue((Object)rs.getString("fmaterialid"));
                arow.getCell("material.number").setValue((Object)rs.getString("fmaterialnumber"));
                arow.getCell("material.name").setValue((Object)rs.getString("fmaterialname"));
                arow.getCell("project.number").setValue((Object)rs.getString("fprojectnumber"));
                arow.getCell("project.name").setValue((Object)rs.getString("fprojectname"));
                arow.getCell("tracknumber.name").setValue(null);
                arow.getCell("tracknumber.name").getStyleAttributes().setHided(true);
                arow.getCell("std.id").setValue((Object)rs.getString("fstdid"));
                arow.getCell("std.number").setValue((Object)rs.getString("fstdnumber"));
                arow.getCell("pbom.id").setValue((Object)rs.getString("fpbomid"));
                arow.getCell("pbom.number").setValue((Object)rs.getString("fpbomnumber"));
                arow.getCell("storageorgunit.id").setValue((Object)rs.getString("fstorageorgunitid"));
                arow.getCell("bom.id").setValue((Object)rs.getString("fbomid"));
                if (rs.getString("fisdef") != null && "1".equals(rs.getString("fisdef"))) {
                    arow.getCell("isdefStd").setValue((Object)true);
                    continue;
                }
                arow.getCell("isdefStd").setValue((Object)false);
            }
        }
    }

    @Override
    protected void kdtPBOM_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            if (e.getType() == 0) {
                return;
            }
            if (e.getColIndex() >= 0 && this.kdtPBOM.getColumnKey(e.getColIndex()).equals("pbom.number")) {
                List<IRow> selectedRowList = this.getSelectRowList(this.kdtPBOM);
                if (selectedRowList == null || selectedRowList.size() < 1) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"NoSelectRow"));
                    SysUtil.abort();
                }
                if (selectedRowList.get(0).getCell("pbom.id").getValue() != null) {
                    String pbomid = selectedRowList.get(0).getCell("pbom.id").getValue().toString();
                    UIContext uiContext = new UIContext();
                    IUIWindow uiWindow = null;
                    uiContext.put((Object)"ID", (Object)new ObjectUuidPK(pbomid));
                    String uiClass = "com.kingdee.eas.mm.basedata.client.PBOMEditUI";
                    uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.mm.basedata.client.PBOMEditUI", (Map)uiContext, null, OprtState.VIEW);
                    uiWindow.show();
                }
            }
        }
    }

    protected final void refreshAfterModified(final IUIWindow uiWindow) {
        Window window = SwingUtilities.getWindowAncestor((JComponent)uiWindow.getUIObject());
        WindowAdapter listenerForWindow = new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent event) {
                if (uiWindow != null) {
                    if (uiWindow.getUIObject() instanceof StandardRootingEditUI) {
                        if (((StandardRootingEditUI)uiWindow.getUIObject()).isSaved()) {
                            try {
                                StdPbomUI.this.btnQueryRT_actionPerformed(null);
                            }
                            catch (Exception e) {
                                StdPbomUI.this.handUIException(e);
                            }
                        }
                    } else if (uiWindow.getUIObject() instanceof BomConvertToPBomUI) {
                        if (((BomConvertToPBomUI)uiWindow.getUIObject()).isSaved()) {
                            try {
                                StdPbomUI.this.btnQueryPBom_actionPerformed(null);
                            }
                            catch (Exception e) {
                                StdPbomUI.this.handUIException(e);
                            }
                        }
                    } else if (uiWindow.getUIObject() instanceof BomConvertToPbomOneKeyUI && ((BomConvertToPbomOneKeyUI)uiWindow.getUIObject()).isSaved()) {
                        try {
                            StdPbomUI.this.btnQueryPBom_actionPerformed(null);
                        }
                        catch (Exception e) {
                            StdPbomUI.this.handUIException(e);
                        }
                    }
                }
            }
        };
        window.addWindowListener(listenerForWindow);
    }

    @Override
    protected void btnAddRT_actionPerformed(ActionEvent e) throws Exception {
        List<IRow> selectedRowList = this.getSelectRowList(this.kdtRT);
        if (selectedRowList == null || selectedRowList.size() < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"NoSelectRow"));
            SysUtil.abort();
        }
        String storageOrgUnitID = selectedRowList.get(0).getCell("storageorgunit.id").getValue().toString();
        String storageOrgUnitname = selectedRowList.get(0).getCell("storageorgunit.name").getValue().toString();
        this.checkPerMission(this.getRTAddPermissionItem(), storageOrgUnitID, storageOrgUnitname);
        String fmaterialid = selectedRowList.get(0).getCell("material.id").getValue().toString();
        String bomid = selectedRowList.get(0).getCell("bom.id").getValue().toString();
        UIContext uiContext = new UIContext();
        uiContext.put((Object)"storageorgunitid", (Object)storageOrgUnitID);
        uiContext.put((Object)"fmaterialid", (Object)fmaterialid);
        uiContext.put((Object)"pid", (Object)bomid);
        IUIWindow uiWindow = null;
        uiContext.put((Object)"ID", null);
        String uiClass = "com.kingdee.eas.mm.basedata.client.StandardRootingEditUI";
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.mm.basedata.client.StandardRootingEditUI", (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.refreshAfterModified(uiWindow);
    }

    @Override
    protected void btnEditRT_actionPerformed(ActionEvent e) throws Exception {
        MMBasedataStatusEnum rtStatus;
        List<IRow> selectedRowList = this.getSelectRowList(this.kdtRT);
        if (selectedRowList == null || selectedRowList.size() < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"NoSelectRow"));
            SysUtil.abort();
        }
        if (selectedRowList.get(0).getCell("std.id").getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"SelectRow_NoRT"));
            SysUtil.abort();
        }
        String storageOrgUnitID = selectedRowList.get(0).getCell("storageorgunit.id").getValue().toString();
        String storageOrgUnitname = selectedRowList.get(0).getCell("storageorgunit.name").getValue().toString();
        this.checkPerMission(this.getRTEditPermissionItem(), storageOrgUnitID, storageOrgUnitname);
        String rtid = selectedRowList.get(0).getCell("std.id").getValue().toString();
        if (!(selectedRowList.get(0).getCell("rtStatus").getValue() == null || (rtStatus = (MMBasedataStatusEnum)selectedRowList.get(0).getCell("rtStatus").getValue()).equals((Object)MMBasedataStatusEnum.ADDNEW) || rtStatus.equals((Object)MMBasedataStatusEnum.SAVED) || rtStatus.equals((Object)MMBasedataStatusEnum.SUBMIT))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"RT_IsNoSaveStatus"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext();
        IUIWindow uiWindow = null;
        uiContext.put((Object)"ID", (Object)rtid);
        String uiClass = "com.kingdee.eas.mm.basedata.client.StandardRootingEditUI";
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.mm.basedata.client.StandardRootingEditUI", (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        this.refreshAfterModified(uiWindow);
    }

    @Override
    protected void btnRemoveRT_actionPerformed(ActionEvent e) throws Exception {
        List<IRow> selectedRowList = this.getSelectRowList(this.kdtRT);
        String allerrorString = "";
        String thiserrorString = null;
        if (selectedRowList == null || selectedRowList.size() < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"NoSelectRow"));
            SysUtil.abort();
        }
        if (MsgBox.showConfirm2((String)EASResource.getString((String)this.RESURL, (String)"Affirm_DeleteRT")) == 2) {
            SysUtil.abort();
        }
        ArrayList<ObjectUuidPK> delPkList = new ArrayList<ObjectUuidPK>();
        for (int i = 0; i < selectedRowList.size(); ++i) {
            MMBasedataStatusEnum rtStatus;
            IRow arow = selectedRowList.get(i);
            if (arow.getCell("std.id").getValue() == null) {
                thiserrorString = EASResource.getString((String)this.RESURL, (String)"Material_NoRT", (Object[])new String[]{arow.getCell("material.number").getValue().toString()});
                allerrorString = allerrorString + thiserrorString + "\r\n";
                continue;
            }
            if (!(arow.getCell("rtStatus").getValue() == null || (rtStatus = (MMBasedataStatusEnum)arow.getCell("rtStatus").getValue()).equals((Object)MMBasedataStatusEnum.ADDNEW) || rtStatus.equals((Object)MMBasedataStatusEnum.SAVED) || rtStatus.equals((Object)MMBasedataStatusEnum.SUBMIT))) {
                thiserrorString = EASResource.getString((String)this.RESURL, (String)"Material_IsNoSaveStatus", (Object[])new String[]{arow.getCell("material.number").getValue().toString(), arow.getCell("std.number").getValue().toString()});
                allerrorString = allerrorString + thiserrorString + "\r\n";
                continue;
            }
            String storageOrgUnitID = arow.getCell("storageorgunit.id").getValue().toString();
            String storageOrgUnitname = arow.getCell("storageorgunit.name").getValue().toString();
            if (!this.checkPerMissionBoolean(this.getRTRemovePermissionItem(), storageOrgUnitID, storageOrgUnitname)) {
                thiserrorString = EASResource.getString((String)this.RESURL, (String)this.getRTRemovePermissionItem(), (Object[])new String[]{storageOrgUnitname});
                allerrorString = allerrorString + thiserrorString + "\r\n";
                continue;
            }
            delPkList.add(new ObjectUuidPK(arow.getCell("std.id").getValue().toString()));
        }
        boolean needRefresh = false;
        IObjectPK[] delPK = null;
        if (delPkList != null && delPkList.size() > 0) {
            delPK = new IObjectPK[delPkList.size()];
            for (int i = 0; i < delPkList.size(); ++i) {
                delPK[i] = (IObjectPK)delPkList.get(i);
            }
            StandardRootingFactory.getRemoteInstance().delete(delPK);
            needRefresh = true;
        }
        if (allerrorString != null && !allerrorString.equals("")) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"ERRORMESSAGE"), (String)allerrorString, (int)8188);
        }
        if (needRefresh) {
            this.btnQueryRT_actionPerformed(e);
        }
    }

    @Override
    protected void btnSubmitRT_actionPerformed(ActionEvent e) throws Exception {
        List<IRow> selectedRowList = this.getSelectRowList(this.kdtRT);
        String allerrorString = "";
        String thiserrorString = null;
        if (selectedRowList == null || selectedRowList.size() < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"NoSelectRow"));
            SysUtil.abort();
        }
        ArrayList submitPkList = new ArrayList();
        boolean needRefresh = false;
        for (int i = 0; i < selectedRowList.size(); ++i) {
            MMBasedataStatusEnum rtStatus;
            IRow arow = selectedRowList.get(i);
            if (arow.getCell("std.id").getValue() == null) {
                thiserrorString = EASResource.getString((String)this.RESURL, (String)"Material_NoRT", (Object[])new String[]{arow.getCell("material.number").getValue().toString()});
                allerrorString = allerrorString + thiserrorString + "\r\n";
                continue;
            }
            if (!(arow.getCell("rtStatus").getValue() == null || (rtStatus = (MMBasedataStatusEnum)arow.getCell("rtStatus").getValue()).equals((Object)MMBasedataStatusEnum.ADDNEW) || rtStatus.equals((Object)MMBasedataStatusEnum.SAVED) || rtStatus.equals((Object)MMBasedataStatusEnum.SUBMIT))) {
                thiserrorString = EASResource.getString((String)this.RESURL, (String)"Material_IsNoSaveStatus", (Object[])new String[]{arow.getCell("material.number").getValue().toString(), arow.getCell("std.number").getValue().toString()});
                allerrorString = allerrorString + thiserrorString + "\r\n";
                continue;
            }
            String storageOrgUnitID = arow.getCell("storageorgunit.id").getValue().toString();
            String storageOrgUnitname = arow.getCell("storageorgunit.name").getValue().toString();
            if (!this.checkPerMissionBoolean(this.getRTEditPermissionItem(), storageOrgUnitID, storageOrgUnitname)) {
                thiserrorString = EASResource.getString((String)this.RESURL, (String)this.getRTEditPermissionItem(), (Object[])new String[]{storageOrgUnitname});
                allerrorString = allerrorString + thiserrorString + "\r\n";
                continue;
            }
            StandardRootingFactory.getRemoteInstance().submit((IObjectPK)new ObjectUuidPK(arow.getCell("std.id").getValue().toString()));
            needRefresh = true;
        }
        if (allerrorString != null && !allerrorString.equals("")) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"ERRORMESSAGE"), (String)allerrorString, (int)8188);
        }
        if (needRefresh) {
            this.btnQueryRT_actionPerformed(e);
        }
    }

    @Override
    protected void btnAuditRT_actionPerformed(ActionEvent e) throws Exception {
        List<IRow> selectedRowList = this.getSelectRowList(this.kdtRT);
        String allerrorString = "";
        String thiserrorString = null;
        if (selectedRowList == null || selectedRowList.size() < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"NoSelectRow"));
            SysUtil.abort();
        }
        ArrayList submitPkList = new ArrayList();
        boolean needRefresh = false;
        for (int i = 0; i < selectedRowList.size(); ++i) {
            IRow arow = selectedRowList.get(i);
            if (arow.getCell("std.id").getValue() == null) {
                thiserrorString = EASResource.getString((String)this.RESURL, (String)"Material_NoRT", (Object[])new String[]{arow.getCell("material.number").getValue().toString()});
                allerrorString = allerrorString + thiserrorString + "\r\n";
                continue;
            }
            MMBasedataStatusEnum rtStatus = null;
            if (arow.getCell("rtStatus").getValue() != null) {
                rtStatus = (MMBasedataStatusEnum)arow.getCell("rtStatus").getValue();
            }
            if (!rtStatus.equals((Object)MMBasedataStatusEnum.SUBMIT)) {
                thiserrorString = EASResource.getString((String)this.RESURL, (String)"Material_IsNoSubmitStatus", (Object[])new String[]{arow.getCell("material.number").getValue().toString(), arow.getCell("std.number").getValue().toString()});
                allerrorString = allerrorString + thiserrorString + "\r\n";
                continue;
            }
            String storageOrgUnitID = arow.getCell("storageorgunit.id").getValue().toString();
            String storageOrgUnitname = arow.getCell("storageorgunit.name").getValue().toString();
            if (!this.checkPerMissionBoolean(this.getRTAuditPermissionItem(), storageOrgUnitID, storageOrgUnitname)) {
                thiserrorString = EASResource.getString((String)this.RESURL, (String)this.getRTAuditPermissionItem(), (Object[])new String[]{storageOrgUnitname});
                allerrorString = allerrorString + thiserrorString + "\r\n";
                continue;
            }
            StandardRootingFactory.getRemoteInstance().audit((IObjectPK)new ObjectUuidPK(arow.getCell("std.id").getValue().toString()));
            needRefresh = true;
        }
        if (allerrorString != null && !allerrorString.equals("")) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"ERRORMESSAGE"), (String)allerrorString, (int)8188);
        }
        if (needRefresh) {
            this.btnQueryRT_actionPerformed(e);
        }
    }

    @Override
    protected void btnUnAuditRT_actionPerformed(ActionEvent e) throws Exception {
        List<IRow> selectedRowList = this.getSelectRowList(this.kdtRT);
        String allerrorString = "";
        String thiserrorString = null;
        if (selectedRowList == null || selectedRowList.size() < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"NoSelectRow"));
            SysUtil.abort();
        }
        ArrayList submitPkList = new ArrayList();
        boolean needRefresh = false;
        for (int i = 0; i < selectedRowList.size(); ++i) {
            IRow arow = selectedRowList.get(i);
            if (arow.getCell("std.id").getValue() == null) {
                thiserrorString = EASResource.getString((String)this.RESURL, (String)"Material_NoRT", (Object[])new String[]{arow.getCell("material.number").getValue().toString()});
                allerrorString = allerrorString + thiserrorString + "\r\n";
                continue;
            }
            MMBasedataStatusEnum rtStatus = null;
            if (arow.getCell("rtStatus").getValue() != null) {
                rtStatus = (MMBasedataStatusEnum)arow.getCell("rtStatus").getValue();
            }
            if (!rtStatus.equals((Object)MMBasedataStatusEnum.AUDIT)) {
                thiserrorString = EASResource.getString((String)this.RESURL, (String)"Material_IsNoAuditStatus", (Object[])new String[]{arow.getCell("material.number").getValue().toString(), arow.getCell("std.number").getValue().toString()});
                allerrorString = allerrorString + thiserrorString + "\r\n";
                continue;
            }
            String storageOrgUnitID = arow.getCell("storageorgunit.id").getValue().toString();
            String storageOrgUnitname = arow.getCell("storageorgunit.name").getValue().toString();
            if (!this.checkPerMissionBoolean(this.getRTUnAuditPermissionItem(), storageOrgUnitID, storageOrgUnitname)) {
                thiserrorString = EASResource.getString((String)this.RESURL, (String)this.getRTUnAuditPermissionItem(), (Object[])new String[]{storageOrgUnitname});
                allerrorString = allerrorString + thiserrorString + "\r\n";
                continue;
            }
            StandardRootingFactory.getRemoteInstance().unAudit((IObjectPK)new ObjectUuidPK(arow.getCell("std.id").getValue().toString()));
            needRefresh = true;
        }
        if (allerrorString != null && !allerrorString.equals("")) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"ERRORMESSAGE"), (String)allerrorString, (int)8188);
        }
        if (needRefresh) {
            this.btnQueryRT_actionPerformed(e);
        }
    }

    @Override
    protected void btnViewRT_actionPerformed(ActionEvent e) throws Exception {
        List<IRow> selectedRowList = this.getSelectRowList(this.kdtRT);
        if (selectedRowList == null || selectedRowList.size() < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"NoSelectRow"));
            SysUtil.abort();
        }
        if (selectedRowList.get(0).getCell("std.id").getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"SelectRow_NoRT"));
            SysUtil.abort();
        }
        String storageOrgUnitID = selectedRowList.get(0).getCell("storageorgunit.id").getValue().toString();
        String storageOrgUnitname = selectedRowList.get(0).getCell("storageorgunit.name").getValue().toString();
        this.checkPerMission(this.getRTViewPermissionItem(), storageOrgUnitID, storageOrgUnitname);
        String rtid = selectedRowList.get(0).getCell("std.id").getValue().toString();
        UIContext uiContext = new UIContext();
        IUIWindow uiWindow = null;
        uiContext.put((Object)"ID", (Object)rtid);
        String uiClass = "com.kingdee.eas.mm.basedata.client.StandardRootingEditUI";
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.mm.basedata.client.StandardRootingEditUI", (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    protected void btnPbomOne_actionPerformed(ActionEvent e) throws Exception {
        List<IRow> selectedRowList = this.getSelectRowList(this.kdtPBOM);
        if (selectedRowList == null || selectedRowList.size() < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"NoSelectRow"));
            SysUtil.abort();
        }
        String pbomID = null;
        String storageOrgUnitID = selectedRowList.get(0).getCell("storageorgunit.id").getValue().toString();
        String storageOrgUnitname = selectedRowList.get(0).getCell("storageorgunit.name").getValue().toString();
        this.checkPerMission(this.getPBomAddPermissionItem(), storageOrgUnitID, storageOrgUnitname);
        if (selectedRowList.get(0).getCell("pbom.id").getValue() != null) {
            pbomID = selectedRowList.get(0).getCell("pbom.id").getValue().toString();
            this.checkPerMission(this.getPBomEditPermissionItem(), storageOrgUnitID, storageOrgUnitname);
        }
        String fmaterialid = selectedRowList.get(0).getCell("material.id").getValue().toString();
        String bomid = selectedRowList.get(0).getCell("bom.id").getValue().toString();
        String stdid = selectedRowList.get(0).getCell("std.id").getValue().toString();
        UIContext uiContext = new UIContext();
        uiContext.put((Object)"storageorgunitid", (Object)storageOrgUnitID);
        uiContext.put((Object)"materialid", (Object)fmaterialid);
        uiContext.put((Object)"bomid", (Object)bomid);
        uiContext.put((Object)"stdid", (Object)stdid);
        IUIWindow uiWindow = null;
        uiContext.put((Object)"ID", null);
        String uiClass = "com.kingdee.eas.zjbom.convert.client.BomConvertToPBomUI";
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.zjbom.convert.client.BomConvertToPBomUI", (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.refreshAfterModified(uiWindow);
    }

    @Override
    protected void btnPbomAuto_actionPerformed(ActionEvent e) throws Exception {
        List<IRow> selectedRowList = this.getSelectRowList(this.kdtPBOM);
        if (selectedRowList == null || selectedRowList.size() < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"NoSelectRow"));
            SysUtil.abort();
        }
        ArrayList<String> execOrgUnitList = new ArrayList<String>();
        ArrayList bomstdList = new ArrayList();
        for (int i = 0; i < selectedRowList.size(); ++i) {
            String storageOrgUnitID = selectedRowList.get(i).getCell("storageorgunit.id").getValue().toString();
            if (!execOrgUnitList.contains(storageOrgUnitID)) {
                String storageOrgUnitname = selectedRowList.get(i).getCell("storageorgunit.name").getValue().toString();
                this.checkPerMission(this.getPBomAddPermissionItem(), storageOrgUnitID, storageOrgUnitname);
                if (selectedRowList.get(i).getCell("pbom.id").getValue() != null) {
                    this.checkPerMission(this.getPBomEditPermissionItem(), storageOrgUnitID, storageOrgUnitname);
                }
                execOrgUnitList.add(storageOrgUnitID);
            }
            String bomid = selectedRowList.get(i).getCell("bom.id").getValue().toString();
            String stdid = selectedRowList.get(i).getCell("std.id").getValue().toString();
            HashMap<String, String> bomstdMap = new HashMap<String, String>();
            bomstdMap.put("bomid", bomid);
            bomstdMap.put("stdid", stdid);
            bomstdList.add(bomstdMap);
        }
        UIContext uiContext = new UIContext();
        uiContext.put((Object)"bomstdList", bomstdList);
        uiContext.put((Object)"storageOrgUnitIDSet", this.getStorageOrgUnitIDSet());
        if (this.prmtBOM.getValue() != null) {
            uiContext.put((Object)"bominfo", (Object)((BomInfo)this.prmtBOM.getValue()));
        }
        if (this.prmtDesignMode.getValue() != null) {
            uiContext.put((Object)"designModeInfo", (Object)((DesignModeInfo)this.prmtDesignMode.getValue()));
        }
        if (this.prmtProject.getValue() != null) {
            uiContext.put((Object)"projectInfo", (Object)((ProjectInfo)this.prmtProject.getValue()));
        }
        if (this.prmtTrackNumber.getValue() != null) {
            uiContext.put((Object)"tracknumberInfo", (Object)((TrackNumberInfo)this.prmtTrackNumber.getValue()));
        }
        if (this.prmtMaterial.getValue() != null) {
            uiContext.put((Object)"materialinfo", (Object)((MaterialInfo)this.prmtMaterial.getValue()));
        }
        uiContext.put((Object)"queryBomType", (Object)this.getQueryBomType());
        IUIWindow uiWindow = null;
        uiContext.put((Object)"ID", null);
        String uiClass = "com.kingdee.eas.zjbom.convert.client.BomConvertToPbomOneKeyUI";
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.zjbom.convert.client.BomConvertToPbomOneKeyUI", (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.refreshAfterModified(uiWindow);
    }

    private class CommonF7KDTableListenerImpl
    implements CommonF7KDTableListener {
        private KDBizPromptBox prmtBox;
        private String title;

        private CommonF7KDTableListenerImpl(String title, KDBizPromptBox prmtBox) {
            this.prmtBox = prmtBox;
            this.title = title;
        }

        public void onTableStructureCreated(KDTable arg0) {
            ((KDCommonPromptDialog)this.prmtBox.getSelector()).setTitle(this.title);
        }
    }
}

