/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.convert.process;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.taskmng.util.StringUtil;
import com.kingdee.eas.csinterface.syncdatabase.SQLFacadeFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.BomEntryFactory;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.BomGroupstandardCollection;
import com.kingdee.eas.mm.basedata.BomGroupstandardFactory;
import com.kingdee.eas.mm.basedata.BomGroupstandardInfo;
import com.kingdee.eas.mm.basedata.DesignModeEntryInfo;
import com.kingdee.eas.mm.basedata.DesignModeInfo;
import com.kingdee.eas.mm.basedata.util.MfgBomUtil;
import com.kingdee.eas.mm.common.MMBaseStatusEnum;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.BusinessRepEntryInfo;
import com.kingdee.eas.zjbom.BusinessRepInfo;
import com.kingdee.eas.zjbom.DBOMTypeEnum;
import com.kingdee.eas.zjbom.DesignBOMBillCollection;
import com.kingdee.eas.zjbom.DesignBOMBillFactory;
import com.kingdee.eas.zjbom.DesignBomChangeTempEntryInfo;
import com.kingdee.eas.zjbom.DesignBomChangeTempInfo;
import com.kingdee.eas.zjbom.DesignBomTempBillCollection;
import com.kingdee.eas.zjbom.DesignBomTempBillFactory;
import com.kingdee.eas.zjbom.convert.BomConvertLogEntryFactory;
import com.kingdee.eas.zjbom.convert.BomConvertLogEntryInfo;
import com.kingdee.eas.zjbom.convert.BomConvertLogFactory;
import com.kingdee.eas.zjbom.convert.BomConvertLogInfo;
import com.kingdee.eas.zjbom.convert.ExecStatusEnum;
import com.kingdee.eas.zjbom.convert.IBomConvertLog;
import com.kingdee.eas.zjbom.convert.IBomConvertLogEntry;
import com.kingdee.eas.zjbom.convert.util.BomUtil;
import com.kingdee.eas.zjbom.util.BomUtilZY;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class BomConvertBaseProcess {
    public static String RESURL = "com.kingdee.eas.zjbom.convert.convertBomResource";
    public BomConvertLogInfo bomConvertLogInfo = null;
    public BomConvertLogEntryInfo bomConvertLogEntryInfo = null;
    public IBomConvertLogEntry iBomConvertLogEntry = null;
    public IBomConvertLog iBomConvertLog = null;
    public static SelectorItemCollection updateSic = null;
    public UserInfo currentUserInfo = null;
    public Date currentDate = null;
    public boolean isException = false;
    public Timestamp curentTimeStamp = null;
    public final DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    public Date effectiveDate = null;
    public Date disableDate = null;
    public Context ctx = null;
    protected Map<String, Boolean> checkPermissionCacheMap = new HashMap<String, Boolean>();
    protected static Map<String, MaterialInfo> materialInfoCacheMap = null;
    protected static Map<String, MeasureUnitInfo> MeasureUnitInfoCacheMap = null;
    protected static Map<String, String> MeasureUnitConvertRateCacheMap = null;
    protected static Map<String, BomGroupstandardInfo> BomGroupstandardInfoCacheMap = null;
    protected static Map<String, String> SysParamCacheMap = null;

    public BomConvertBaseProcess() throws BOSException, EASBizException {
        materialInfoCacheMap = new HashMap<String, MaterialInfo>();
        MeasureUnitInfoCacheMap = new HashMap<String, MeasureUnitInfo>();
        BomGroupstandardInfoCacheMap = new HashMap<String, BomGroupstandardInfo>();
        SysParamCacheMap = new HashMap<String, String>();
        MeasureUnitConvertRateCacheMap = new HashMap<String, String>();
        this.isException = false;
        try {
            this.effectiveDate = this.sdf.parse(MMUtils.dateToString((Date)new Date(), (String)"yyyy-MM-dd"));
            this.disableDate = this.sdf.parse("2099-12-31");
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    public Context getContext() {
        return this.ctx;
    }

    public void convert(Context ctx, BomConvertLogEntryInfo entryInfo, BomConvertLogInfo info) throws BOSException, EASBizException {
        this.bomConvertLogInfo = info;
        this.bomConvertLogEntryInfo = entryInfo;
        this.iBomConvertLog = BomConvertLogFactory.getLocalInstance(ctx);
        this.iBomConvertLogEntry = BomConvertLogEntryFactory.getLocalInstance(ctx);
        this.currentUserInfo = (UserInfo)ctx.get((Object)"UserInfo");
        this.currentDate = new Date();
        this.curentTimeStamp = new Timestamp(System.currentTimeMillis());
        this.ctx = ctx;
        if (this.checkSourceBomIsNull(ctx)) {
            this.isException = true;
            return;
        }
        this.isException = false;
    }

    public boolean checkSourceBomIsNull(Context ctx) throws BOSException, EASBizException {
        if (this.bomConvertLogEntryInfo.getSourceBomID() == null) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"sourceBomIDIsNull", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return true;
        }
        return false;
    }

    public static MaterialInfo getMaterialInfo(Context ctx, String fnumber) throws BOSException, EASBizException {
        if (fnumber != null && !fnumber.equals("")) {
            if (materialInfoCacheMap != null && materialInfoCacheMap.containsKey(fnumber)) {
                return materialInfoCacheMap.get(fnumber);
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("model"));
            sic.add(new SelectorItemInfo("baseUnit.id"));
            sic.add(new SelectorItemInfo("baseUnit.name"));
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)fnumber));
            viewInfo.setFilter(filterInfo);
            viewInfo.setSelector(sic);
            MaterialCollection mColl = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(viewInfo);
            if (mColl != null && mColl.size() > 0) {
                if (materialInfoCacheMap == null) {
                    materialInfoCacheMap = new HashMap<String, MaterialInfo>();
                }
                materialInfoCacheMap.put(fnumber, mColl.get(0));
                return mColl.get(0);
            }
        }
        return null;
    }

    protected void updateSuccessfulStatus(Context ctx) throws BOSException, EASBizException {
        this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"successful", (Locale)ctx.getLocale()));
        this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ExecuteEnd);
        updateSic = new SelectorItemCollection();
        updateSic.add(new SelectorItemInfo("execResult"));
        updateSic.add(new SelectorItemInfo("execStatus"));
        this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
    }

    public void afterConvert(Context ctx) throws BOSException, EASBizException {
        this.updateSuccessfulStatus(ctx);
    }

    public static MeasureUnitInfo getMeasureUnitInfo(Context ctx, String unitname, MaterialInfo materialInfo) throws BOSException, EASBizException {
        MeasureUnitInfo unitInfo = null;
        if (materialInfo != null) {
            unitInfo = materialInfo.getBaseUnit();
        }
        if (unitname != null && !unitname.equals("") && unitInfo == null) {
            if (MeasureUnitInfoCacheMap != null && MeasureUnitInfoCacheMap.containsKey(unitname)) {
                return MeasureUnitInfoCacheMap.get(unitname);
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)unitname));
            viewInfo.setFilter(filterInfo);
            viewInfo.setSelector(sic);
            MeasureUnitCollection mColl = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(viewInfo);
            if (mColl != null && mColl.size() > 0) {
                if (MeasureUnitInfoCacheMap == null) {
                    MeasureUnitInfoCacheMap = new HashMap<String, MeasureUnitInfo>();
                }
                MeasureUnitInfoCacheMap.put(unitname, mColl.get(0));
                return mColl.get(0);
            }
        }
        return unitInfo;
    }

    public static BomGroupstandardInfo getBomGroupstandadInfo(Context ctx, StorageOrgUnitInfo sInfo) throws BOSException, EASBizException {
        if (BomGroupstandardInfoCacheMap != null && BomGroupstandardInfoCacheMap.containsKey(sInfo.getId().toString())) {
            return BomGroupstandardInfoCacheMap.get(sInfo.getId().toString());
        }
        if (BomGroupstandardInfoCacheMap == null) {
            BomGroupstandardInfoCacheMap = new HashMap<String, BomGroupstandardInfo>();
        }
        Object info = null;
        BomGroupstandardCollection bomGroupColl = BomGroupstandardFactory.getLocalInstance((Context)ctx).getBomGroupstandardCollection("Where storageOrgUnit.id = '" + sInfo.getId() + "' And number = '999'");
        if (bomGroupColl == null || bomGroupColl.size() < 1) {
            bomGroupColl = BomGroupstandardFactory.getLocalInstance((Context)ctx).getBomGroupstandardCollection("Where storageOrgUnit.id = '" + sInfo.getId() + "' ");
            if (bomGroupColl != null && bomGroupColl.size() > 0) {
                BomGroupstandardInfoCacheMap.put(sInfo.getId().toString(), bomGroupColl.get(0));
                return bomGroupColl.get(0);
            }
        } else {
            BomGroupstandardInfoCacheMap.put(sInfo.getId().toString(), bomGroupColl.get(0));
            return bomGroupColl.get(0);
        }
        BomGroupstandardInfoCacheMap.put(sInfo.getId().toString(), null);
        return null;
    }

    public static boolean getSysParamBooleanValue(Context ctx, String orgID, String sysParamName, boolean withCache) throws BOSException, EASBizException {
        String fvalue = BomConvertBaseProcess.getSysParamValue(ctx, orgID, sysParamName, withCache);
        return fvalue != null && "TRUE".equals(fvalue.toUpperCase());
    }

    public static String getSysParamValue(Context ctx, String orgID, String sysParamName, boolean withCache) throws BOSException, EASBizException {
        if (withCache && SysParamCacheMap != null && SysParamCacheMap.containsKey(orgID + sysParamName)) {
            return SysParamCacheMap.get(orgID + sysParamName);
        }
        String fvalue = null;
        fvalue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(orgID), (String)sysParamName);
        if (withCache) {
            if (SysParamCacheMap == null) {
                SysParamCacheMap = new HashMap<String, String>();
            }
            SysParamCacheMap.put(orgID + sysParamName, fvalue);
        }
        return fvalue;
    }

    protected BomEntryInfo getBomEntryInfoBySourceBillEntryID(Context ctx, String fsourcebillentryid) throws BOSException, EASBizException {
        BomEntryInfo bomEntryInfo = null;
        StringBuilder sql = new StringBuilder();
        String fbomentrID = null;
        sql.append(" Select fid from t_mm_bomentry where fsourcebillentryid = ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{fsourcebillentryid});
        try {
            while (rs.next()) {
                fbomentrID = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        if (fbomentrID != null && !"".equals(fbomentrID)) {
            bomEntryInfo = BomEntryFactory.getLocalInstance((Context)ctx).getBomEntryInfo((IObjectPK)new ObjectUuidPK(fbomentrID), this.getBomEntrySelectSic());
        }
        return bomEntryInfo;
    }

    protected SelectorItemCollection getBomEntrySelectSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("beginCarno.id"));
        sic.add(new SelectorItemInfo("endCarno.id"));
        sic.add(new SelectorItemInfo("beginCarno.number"));
        sic.add(new SelectorItemInfo("endCarno.number"));
        return sic;
    }

    public static MaterialProvideTypeEnum getMaterialProvideTypeEnum(Context ctx, String storageOrgUnitID, String suppOrgUnitID, String materialID) throws BOSException, EASBizException {
        if (storageOrgUnitID.equals(suppOrgUnitID)) {
            return MaterialProvideTypeEnum.CURRENTORGPROVIDE;
        }
        StringBuilder sql = new StringBuilder();
        Object fbomentrID = null;
        sql.append(" Select isnull(r0.FToUnitID,'*') As FToUnitID from  T_ORG_UnitRelation r0  where r0.FFromUnitID= '" + storageOrgUnitID + "' and r0.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
        IRowSet rs1 = null;
        rs1 = ctx == null ? SQLFacadeFactory.getRemoteInstance().getRowset(sql.toString()) : DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        IRowSet rs2 = null;
        sql.setLength(0);
        sql.append(" Select isnull(r0.FToUnitID,'*') As FToUnitID from  T_ORG_UnitRelation r0  where r0.FFromUnitID= '" + suppOrgUnitID + "' and r0.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
        rs2 = ctx == null ? SQLFacadeFactory.getRemoteInstance().getRowset(sql.toString()) : DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            String FToUnitID1 = null;
            String FToUnitID2 = null;
            while (rs1.next()) {
                FToUnitID1 = rs1.getString("FToUnitID");
            }
            while (rs2.next()) {
                FToUnitID2 = rs2.getString("FToUnitID");
            }
            if (FToUnitID1 != null && FToUnitID2 != null && FToUnitID1.equals(FToUnitID2)) {
                String EMMBOM07 = BomConvertBaseProcess.getSysParamValue(ctx, suppOrgUnitID, "EMMBOM07", true);
                if (EMMBOM07 != null && EMMBOM07.equals("3")) {
                    MaterialProvideTypeEnum mpProvide = BomConvertBaseProcess.getMaterialPlanProvide(ctx, suppOrgUnitID, materialID);
                    if (mpProvide == null) {
                        mpProvide = MaterialProvideTypeEnum.SPANORGPROVIDE;
                    }
                    return mpProvide;
                }
                if (EMMBOM07 != null && EMMBOM07.equals("2")) {
                    return MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE;
                }
                return MaterialProvideTypeEnum.SPANORGPROVIDE;
            }
            return MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    public static MaterialProvideTypeEnum getMaterialPlanProvide(Context ctx, String orgunitID, String materialID) throws EASBizException, BOSException {
        if (orgunitID == null || materialID == null) {
            return null;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select fprovidetype from t_bd_materialplan where fmaterialid = '" + materialID + "' and forgunit = '" + orgunitID + "'  ");
        try {
            IRowSet rs = null;
            rs = ctx == null ? SQLFacadeFactory.getRemoteInstance().getRowset(sql.toString()) : DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                if (rs.getString("fprovidetype") == null) continue;
                return MaterialProvideTypeEnum.getEnum((int)rs.getInt("fprovidetype"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    protected Boolean checkPermission(Context ctx, String orgUnitID, String permissionItemName) throws EASBizException, BOSException {
        if (this.checkPermissionCacheMap != null && this.checkPermissionCacheMap.containsKey(orgUnitID + permissionItemName)) {
            return this.checkPermissionCacheMap.get(orgUnitID + permissionItemName);
        }
        boolean hasPer = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(this.currentUserInfo.getId()), (IObjectPK)new ObjectUuidPK(orgUnitID), permissionItemName);
        this.checkPermissionCacheMap.put(orgUnitID + permissionItemName, hasPer);
        return hasPer;
    }

    public static String getMaterialnumber(Context ctx, String materialID) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        sql.append("select fnumber from t_bd_material where fid = ?  ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{materialID});
            if (rs.next()) {
                return rs.getString("fnumber");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static String getUnitName(Context ctx, String unitID) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        sql.append("select fname_l2 from t_bd_measureunit where fid = ?  ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{unitID});
            if (rs.next()) {
                return rs.getString("fname_l2");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static String getOrgUnitName(Context ctx, String orgUnitID) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        sql.append("select fname_l2 As fname from t_org_storage where fid = ?  ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{orgUnitID});
            if (rs.next()) {
                return rs.getString("fname");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static boolean checkMaterialDisCU(Context ctx, String materialNumber, String materialId) throws BOSException, EASBizException {
        CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String[] orgIDs = new String[]{ctrlUnitInfo.getId().toString()};
        Map<String, MaterialInfo> mapPortNo = BomUtilZY.queryMaterialByMaterialAndOrg(ctx, materialNumber, materialId, orgIDs);
        return mapPortNo.get(ctrlUnitInfo.getId().toString()) != null;
    }

    public static String checkMaterialPlan(Context ctx, String materialID, String orgUnitID, DesignModeInfo designModeInfo, DBOMTypeEnum afterBomType, boolean isCheckPlanParam, boolean isParentMaterial, MeasureUnitInfo unitInfo) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        sql.append("select fstatus,fid,fproductunitid ");
        if (isCheckPlanParam) {
            sql.append(",fmanufacturestrategyid,fisolatedrule,FMaterialAttr,FIsConfigable ,fplanningMode");
        }
        sql.append(" from t_bd_materialplan where fmaterialid = ? and forgunit = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{materialID, orgUnitID});
        String fid = null;
        String fstatus = null;
        String fmaterialNumber = null;
        String forgunitName = null;
        String manufacturestrategyid = null;
        String isolatedRule = null;
        String fproductunitid = null;
        String fproductunitname = null;
        int materialAttr = 0;
        int isConFigable = 0;
        int planningMode = 0;
        try {
            if (rs.next()) {
                fstatus = rs.getString("fstatus");
                fid = rs.getString("fid");
                fproductunitid = rs.getString("fproductunitid");
                if (isCheckPlanParam) {
                    manufacturestrategyid = rs.getString("fmanufacturestrategyid");
                    isolatedRule = rs.getString("fisolatedrule");
                    materialAttr = rs.getInt("FMaterialAttr");
                    isConFigable = rs.getInt("FIsConfigable");
                    planningMode = rs.getInt("fplanningMode");
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        if (fid == null || "".equals(fid)) {
            forgunitName = BomConvertBaseProcess.getOrgUnitName(ctx, orgUnitID);
            fmaterialNumber = BomConvertBaseProcess.getMaterialnumber(ctx, materialID);
            return ResourceBase.getString((String)RESURL, (String)"materialPlan_Null", (Locale)ctx.getLocale(), (Object[])new String[]{fmaterialNumber, forgunitName});
        }
        if (fstatus == null || !"1".equals(fstatus)) {
            forgunitName = BomConvertBaseProcess.getOrgUnitName(ctx, orgUnitID);
            fmaterialNumber = BomConvertBaseProcess.getMaterialnumber(ctx, materialID);
            return ResourceBase.getString((String)RESURL, (String)"materialPlan_NoStatus", (Locale)ctx.getLocale(), (Object[])new String[]{fmaterialNumber, forgunitName});
        }
        if (fproductunitid == null || "".equals(fproductunitid)) {
            forgunitName = BomConvertBaseProcess.getOrgUnitName(ctx, orgUnitID);
            fmaterialNumber = BomConvertBaseProcess.getMaterialnumber(ctx, materialID);
            return ResourceBase.getString((String)RESURL, (String)"materialPlan_NoProductionUnit", (Locale)ctx.getLocale(), (Object[])new String[]{fmaterialNumber, forgunitName});
        }
        if (unitInfo != null && !unitInfo.getId().toString().equals(fproductunitid)) {
            forgunitName = BomConvertBaseProcess.getOrgUnitName(ctx, orgUnitID);
            fmaterialNumber = BomConvertBaseProcess.getMaterialnumber(ctx, materialID);
            fproductunitname = BomConvertBaseProcess.getUnitName(ctx, fproductunitid);
            return ResourceBase.getString((String)RESURL, (String)"materialPlan_Unit_NoSame", (Locale)ctx.getLocale(), (Object[])new String[]{fmaterialNumber, forgunitName, fproductunitname, unitInfo.getName()});
        }
        if (isCheckPlanParam && designModeInfo != null) {
            if (!designModeInfo.getStatus().equals((Object)MMBaseStatusEnum.ENABLE)) {
                return ResourceBase.getString((String)RESURL, (String)"DesignMode_NoEnabled", (Locale)ctx.getLocale(), (Object[])new String[]{designModeInfo.getName()});
            }
            if (afterBomType.equals((Object)DBOMTypeEnum.MfgBom)) {
                if (isParentMaterial) {
                    if (planningMode == 0 || planningMode == 1) {
                        if (!designModeInfo.getId().toString().equals("ySgAAAADJLPK0P+Y")) {
                            forgunitName = BomConvertBaseProcess.getOrgUnitName(ctx, orgUnitID);
                            fmaterialNumber = BomConvertBaseProcess.getMaterialnumber(ctx, materialID);
                            return ResourceBase.getString((String)RESURL, (String)"ParentMaterialNoValuddesignMode", (Locale)ctx.getLocale(), (Object[])new String[]{fmaterialNumber, forgunitName});
                        }
                    } else if (manufacturestrategyid == null || "".equals(manufacturestrategyid)) {
                        forgunitName = BomConvertBaseProcess.getOrgUnitName(ctx, orgUnitID);
                        fmaterialNumber = BomConvertBaseProcess.getMaterialnumber(ctx, materialID);
                        return ResourceBase.getString((String)RESURL, (String)"materialPlan_NoManufactureStrage", (Locale)ctx.getLocale(), (Object[])new String[]{fmaterialNumber, forgunitName});
                    }
                }
                boolean isExists = false;
                if (isolatedRule == null) {
                    isolatedRule = "NONE";
                }
                if (isParentMaterial) {
                    if (planningMode != 0 && planningMode != 1) {
                        if (designModeInfo != null && designModeInfo.getEntry() != null && designModeInfo.getEntry().size() > 0) {
                            for (int i = 0; i < designModeInfo.getEntry().size(); ++i) {
                                DesignModeEntryInfo entryInfo = designModeInfo.getEntry().get(i);
                                if (entryInfo.getManufactureStrategy() == null || !entryInfo.getManufactureStrategy().getId().toString().equals(manufacturestrategyid)) continue;
                                String newisolatedRule = "NONE";
                                if (entryInfo.getIsolatedRule() != null) {
                                    newisolatedRule = entryInfo.getIsolatedRule().getValue();
                                }
                                if (!newisolatedRule.equals(isolatedRule)) continue;
                                isExists = true;
                                break;
                            }
                        }
                        if (!isExists) {
                            forgunitName = BomConvertBaseProcess.getOrgUnitName(ctx, orgUnitID);
                            fmaterialNumber = BomConvertBaseProcess.getMaterialnumber(ctx, materialID);
                            return ResourceBase.getString((String)RESURL, (String)"materialPlan_Mf_Isol_NoSame", (Locale)ctx.getLocale(), (Object[])new String[]{fmaterialNumber, forgunitName, designModeInfo.getName()});
                        }
                    }
                } else {
                    List childDesignModeIDList = MfgBomUtil.getChildDesignModeIDByParentDesignMode((Context)ctx, (DesignModeInfo)designModeInfo);
                    DesignModeInfo childDesignModeInfo = MfgBomUtil.getDesignModeByManufactureStrategy((Context)ctx, (String)manufacturestrategyid, (String)isolatedRule);
                    if (!(childDesignModeInfo == null || childDesignModeIDList != null && childDesignModeIDList.contains(childDesignModeInfo.getId().toString()))) {
                        forgunitName = BomConvertBaseProcess.getOrgUnitName(ctx, orgUnitID);
                        fmaterialNumber = BomConvertBaseProcess.getMaterialnumber(ctx, materialID);
                        return ResourceBase.getString((String)RESURL, (String)"child_materialPlan_Mf_Isol_NoSame", (Locale)ctx.getLocale(), (Object[])new String[]{fmaterialNumber, forgunitName, designModeInfo.getName()});
                    }
                }
            }
        }
        return "ok";
    }

    public static String checkMaterialInventroy(Context ctx, String materialID, String orgUnitID) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        sql.append("select fstatus,fid ");
        sql.append(" from t_bd_materialinventory where fmaterialid = ? and forgunit = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{materialID, orgUnitID});
        String fid = null;
        String fstatus = null;
        String fmaterialNumber = null;
        String forgunitName = null;
        try {
            if (rs.next()) {
                fstatus = rs.getString("fstatus");
                fid = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        if (fid == null || "".equals(fid)) {
            forgunitName = BomConvertBaseProcess.getOrgUnitName(ctx, orgUnitID);
            fmaterialNumber = BomConvertBaseProcess.getMaterialnumber(ctx, materialID);
            return ResourceBase.getString((String)RESURL, (String)"materialInventory_Null", (Locale)ctx.getLocale(), (Object[])new String[]{fmaterialNumber, forgunitName});
        }
        if (fstatus == null || !"1".equals(fstatus)) {
            forgunitName = BomConvertBaseProcess.getOrgUnitName(ctx, orgUnitID);
            fmaterialNumber = BomConvertBaseProcess.getMaterialnumber(ctx, materialID);
            return ResourceBase.getString((String)RESURL, (String)"materialInventory_NoStatus", (Locale)ctx.getLocale(), (Object[])new String[]{fmaterialNumber, forgunitName});
        }
        return "ok";
    }

    public static String getOrgUnitName(Context ctx, List orgUnitList) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        sql.append(" select fname_l2 As fvalue from t_org_storage where fid in(").append(SQLUtil.arrayToString((Object[])orgUnitList.toArray())).append(")  ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String fnameString = "";
        try {
            while (rs.next()) {
                if (fnameString.equals("")) {
                    fnameString = rs.getString("fvalue");
                    continue;
                }
                fnameString = fnameString + "\u3001" + rs.getString("fvalue");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return fnameString;
    }

    public static List<String> getMaterialBomOrgUnitList(Context ctx, String materialid, String orgUnitID, String projectID, String trackID, String materialNumber) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        ArrayList<String> paramList = new ArrayList<String>();
        ArrayList<String> orgUnitIDList = new ArrayList<String>();
        orgUnitIDList.add(orgUnitID);
        sql.append(" select distinct h.fstorageorgunitid As forgunitid ");
        sql.append(" from t_mm_bom h   ");
        sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid   ");
        if (materialid == null) {
            sql.append(" inner join t_bd_material m on m.fid = h.fmaterialid   ");
            sql.append(" where m.fnumber = ?  ");
            paramList.add(materialNumber);
        } else {
            sql.append(" where h.fmaterialid = ?  ");
            paramList.add(materialid);
        }
        sql.append(" And d.fconsumefixqty > 0 ");
        if (projectID == null) {
            sql.append(" And h.fprojectid is null ");
        } else {
            sql.append(" And (h.fprojectid = ? or h.fprojectid is null) ");
            paramList.add(projectID);
        }
        if (trackID != null) {
            sql.append(" And exists(select 1 from t_mm_bomentry d where d.fparentid = h.fid and (d.fbegincarnoid = ? or d.fbegincarnoid is null )) ");
            paramList.add(trackID);
        }
        sql.append(" And h.fbasestatus = 4 ");
        sql.append(" And h.fdesignModeID in(").append(SQLUtil.arrayToString((Object[])BomUtil.getAllDesignModeIDList().toArray())).append(") ");
        sql.append(" union ");
        sql.append(" select distinct d.fsupplystorageorgunitid As forgunitid ");
        sql.append(" from t_mm_bom h   ");
        sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid   ");
        if (materialid == null) {
            sql.append(" inner join t_bd_material m on m.fid = d.fmaterialid   ");
            sql.append(" where m.fnumber = ?  ");
            paramList.add(materialNumber);
        } else {
            sql.append(" where d.fmaterialid = ?  ");
            paramList.add(materialid);
        }
        if (projectID == null) {
            sql.append(" And h.fprojectid is null ");
        } else {
            sql.append(" And (h.fprojectid = ? or h.fprojectid is null ) ");
            paramList.add(projectID);
        }
        if (trackID != null) {
            sql.append(" And (d.fbegincarnoid = ? or d.fbegincarnoid is null ) ");
            paramList.add(trackID);
        }
        sql.append(" And h.fbasestatus = 4 ");
        sql.append(" And d.fconsumefixqty > 0 ");
        sql.append(" And h.fdesignModeID in(").append(SQLUtil.arrayToString((Object[])BomUtil.getAllDesignModeIDList().toArray())).append(") ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
        try {
            while (rs.next()) {
                if (orgUnitIDList.contains(rs.getString("forgunitid"))) continue;
                orgUnitIDList.add(rs.getString("forgunitid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return orgUnitIDList;
    }

    public boolean checkMaterialOrgUnitIsMul(Context ctx, List<String> orgUnitIDList, String materialNumber, String errorStringNumber, boolean isparent) throws BOSException, EASBizException {
        if (orgUnitIDList == null || orgUnitIDList.size() < 2) {
            return false;
        }
        CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String paramNumber = "EMMBomOrg";
        if (isparent) {
            paramNumber = "EMMBomOrg_Parent";
        }
        if (!BomConvertBaseProcess.getSysParamBooleanValue(ctx, ctrlUnitInfo.getId().toString(), paramNumber, true)) {
            String MulOrgUnitName = BomConvertBaseProcess.getOrgUnitName(ctx, orgUnitIDList);
            String thisOrgUnitName = ctrlUnitInfo.getName();
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)errorStringNumber, (Locale)ctx.getLocale(), (Object[])new String[]{materialNumber, thisOrgUnitName, MulOrgUnitName}));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return true;
        }
        return false;
    }

    public static String checkMaterialUnitConvertRate(Context ctx, MaterialInfo materialInfo, MeasureUnitInfo unitInfo, MeasureUnitInfo baseUnitInfo) throws BOSException, EASBizException {
        if (materialInfo == null || unitInfo == null || baseUnitInfo == null) {
            return "ok";
        }
        if (baseUnitInfo.getId().toString().equals(unitInfo.getId().toString())) {
            return "ok";
        }
        String fkey = materialInfo.getId().toString() + unitInfo.getId().toString();
        if (MeasureUnitConvertRateCacheMap != null && MeasureUnitConvertRateCacheMap.containsKey(fkey)) {
            return MeasureUnitConvertRateCacheMap.get(fkey);
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" Select fid from t_bd_multimeasureunit a");
        sql.append(" where a.fmaterialid = ? ");
        sql.append(" And fmeasureunitid  = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{materialInfo.getId().toString(), unitInfo.getId().toString()});
        String returnStr = ResourceBase.getString((String)RESURL, (String)"material_Unit_NoMulMeasure", (Locale)ctx.getLocale(), (Object[])new String[]{materialInfo.getNumber(), unitInfo.getName(), baseUnitInfo.getName()});
        if (MeasureUnitConvertRateCacheMap == null) {
            MeasureUnitConvertRateCacheMap = new HashMap<String, String>();
        }
        if (rs == null || rs.size() < 1) {
            MeasureUnitConvertRateCacheMap.put(fkey, returnStr);
            return returnStr;
        }
        MeasureUnitConvertRateCacheMap.put(fkey, "ok");
        return "ok";
    }

    public static DesignBOMBillCollection getDesignBomCollection(Context ctx, BusinessRepEntryInfo entryInfo, BusinessRepInfo info) throws BOSException, EASBizException {
        DesignBOMBillCollection coll = null;
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("erpbatchno1.id"));
        sic.add(new SelectorItemInfo("erpbatchno1.number"));
        sic.add(new SelectorItemInfo("erpbatchno2.id"));
        sic.add(new SelectorItemInfo("erpbatchno2.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("designMode.*"));
        sic.add(new SelectorItemInfo("designMode.Entry.*"));
        sic.add(new SelectorItemInfo("designMode.Entry.manufactureStrategy.id"));
        sic.add(new SelectorItemInfo("designMode.Entry.manufactureStrategy.number"));
        sic.add(new SelectorItemInfo("designMode.Entry.manufactureStrategy.name"));
        evi.setSelector(sic);
        evi.setFilter(new FilterInfo());
        if (entryInfo.getPLMID() != null && !"".equals(entryInfo.getPLMID())) {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)entryInfo.getPLMID(), CompareType.EQUALS));
            coll = DesignBOMBillFactory.getLocalInstance(ctx).getDesignBOMBillCollection(evi);
        }
        if (coll == null || coll.size() < 1) {
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("partNo", (Object)entryInfo.getMno(), CompareType.EQUALS));
            if (!StringUtil.isEmpty((String)entryInfo.getPmno())) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("parentNo", (Object)entryInfo.getPmno(), CompareType.EQUALS));
            }
            if (info.getBatch() != null) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("batch", (Object)info.getBatch(), CompareType.EQUALS));
            }
            if (entryInfo.getDesignMode() != null) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("designMode.id", (Object)entryInfo.getDesignMode().getId(), CompareType.EQUALS));
            }
            if (entryInfo.getDesignMode() != null && entryInfo.getDesignMode().isProject() && entryInfo.getProject() != null) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("project.id", (Object)entryInfo.getProject().getId().toString(), CompareType.EQUALS));
            }
            if (entryInfo.getDesignMode() != null && entryInfo.getDesignMode().isTrackNumber()) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("erpbatchno1 is not null"));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("erpbatchno2 is not null"));
            }
            coll = DesignBOMBillFactory.getLocalInstance(ctx).getDesignBOMBillCollection(evi);
        }
        return coll;
    }

    public static DesignBomTempBillCollection getDesignBomTempBillCollection(Context ctx, DesignBomChangeTempEntryInfo entryInfo, DesignBomChangeTempInfo info) throws BOSException, EASBizException {
        DesignBomTempBillCollection coll = null;
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bTrackNumber.id"));
        sic.add(new SelectorItemInfo("eTrackNumber.id"));
        sic.add(new SelectorItemInfo("bTrackNumber.number"));
        sic.add(new SelectorItemInfo("eTrackNumber.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("designMode.*"));
        sic.add(new SelectorItemInfo("designMode.Entry.*"));
        sic.add(new SelectorItemInfo("designMode.Entry.manufactureStrategy.id"));
        sic.add(new SelectorItemInfo("designMode.Entry.manufactureStrategy.number"));
        sic.add(new SelectorItemInfo("designMode.Entry.manufactureStrategy.name"));
        evi.setSelector(sic);
        evi.setFilter(new FilterInfo());
        if (entryInfo.getPLMID() != null && !"".equals(entryInfo.getPLMID())) {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)entryInfo.getPLMID(), CompareType.EQUALS));
            coll = DesignBomTempBillFactory.getLocalInstance(ctx).getDesignBomTempBillCollection(evi);
        }
        if (coll == null || coll.size() < 1) {
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("materialNumber", (Object)entryInfo.getMaterialNumber(), CompareType.EQUALS));
            if (!StringUtil.isEmpty((String)entryInfo.getPMaterialNumber())) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("pMaterialNumber", (Object)entryInfo.getPMaterialNumber(), CompareType.EQUALS));
            }
            if (info.getDesignBatch() != null) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("designBatch", (Object)info.getDesignBatch(), CompareType.EQUALS));
            }
            if (entryInfo.getDesignMode() != null) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("designMode.id", (Object)entryInfo.getDesignMode().getId(), CompareType.EQUALS));
            }
            if (entryInfo.getDesignMode() != null && entryInfo.getDesignMode().isProject()) {
                if (entryInfo.getProject() != null) {
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("project.id", (Object)entryInfo.getProject().getId().toString(), CompareType.EQUALS));
                }
            } else {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("project.id", null, CompareType.EQUALS));
            }
            if (entryInfo.getDesignMode() != null && entryInfo.getDesignMode().isTrackNumber()) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("bTrackNumber is not null"));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("eTrackNumber is not null"));
            } else {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("bTrackNumber is null"));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("eTrackNumber is null"));
            }
            coll = DesignBomTempBillFactory.getLocalInstance(ctx).getDesignBomTempBillCollection(evi);
        }
        return coll;
    }
}

