/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.convert.process;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.convert.BomConvertLogEntryFactory;
import com.kingdee.eas.zjbom.convert.BomConvertLogEntryInfo;
import com.kingdee.eas.zjbom.convert.BomConvertLogFactory;
import com.kingdee.eas.zjbom.convert.BomConvertLogInfo;
import com.kingdee.eas.zjbom.convert.ExecStatusEnum;
import com.kingdee.eas.zjbom.convert.IBomConvertLog;
import com.kingdee.eas.zjbom.convert.IBomConvertLogEntry;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class BomUnConvertBaseProcess {
    public BomConvertLogEntryInfo bomConvertLogEntryInfo = null;
    public static String RESURL = "com.kingdee.eas.zjbom.convert.unConvertBomResource";
    public BomConvertLogInfo bomConvertLogInfo = null;
    public IBomConvertLog iBomConvertLog = null;
    public IBomConvertLogEntry iBomConvertLogEntry = null;
    public SelectorItemCollection updateSic = null;
    public boolean isException = false;
    public static Map<String, String> orgUnitNameCacheMap = null;
    protected Map<String, Boolean> checkPermissionCacheMap = new HashMap<String, Boolean>();

    public BomUnConvertBaseProcess() throws BOSException, EASBizException {
        orgUnitNameCacheMap = new HashMap<String, String>();
    }

    public void unConvert(Context ctx, BomConvertLogEntryInfo entryInfo, BomConvertLogInfo info) throws BOSException, EASBizException {
        this.bomConvertLogInfo = info;
        this.bomConvertLogEntryInfo = entryInfo;
        this.iBomConvertLog = BomConvertLogFactory.getLocalInstance(ctx);
        this.iBomConvertLogEntry = BomConvertLogEntryFactory.getLocalInstance(ctx);
        if (this.checkSourceBomIsNull(ctx)) {
            this.isException = true;
            return;
        }
        this.isException = false;
    }

    public boolean checkSourceBomIsNull(Context ctx) throws BOSException, EASBizException {
        if (this.bomConvertLogEntryInfo.getSourceBomID() == null) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"sourceBomIDIsNull", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            this.updateSic = new SelectorItemCollection();
            this.updateSic.add(new SelectorItemInfo("execResult"));
            this.updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, this.updateSic);
            return true;
        }
        return false;
    }

    public void afterUnConvert(Context ctx) throws BOSException, EASBizException {
        this.updateSuccessfulStatus(ctx);
    }

    protected void updateSuccessfulStatus(Context ctx) throws BOSException, EASBizException {
        this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"successful", (Locale)ctx.getLocale()));
        this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ExecuteEnd);
        this.updateSic = new SelectorItemCollection();
        this.updateSic.add(new SelectorItemInfo("execResult"));
        this.updateSic.add(new SelectorItemInfo("execStatus"));
        this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, this.updateSic);
    }

    protected Boolean checkPermission(Context ctx, String orgUnitID, String permissionItemName) throws EASBizException, BOSException {
        if (this.checkPermissionCacheMap != null && this.checkPermissionCacheMap.containsKey(orgUnitID + permissionItemName)) {
            return this.checkPermissionCacheMap.get(orgUnitID + permissionItemName);
        }
        boolean hasPer = false;
        UserInfo currentUserInfo = (UserInfo)ctx.get((Object)"UserInfo");
        ObjectUuidPK userPK = new ObjectUuidPK(currentUserInfo.getId());
        hasPer = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)userPK, (IObjectPK)new ObjectUuidPK(orgUnitID), permissionItemName);
        this.checkPermissionCacheMap.put(orgUnitID + permissionItemName, hasPer);
        return hasPer;
    }

    public static String getOrgUnitName(Context ctx, String orgUnitID) throws EASBizException, BOSException {
        if (orgUnitNameCacheMap != null && orgUnitNameCacheMap.containsKey(orgUnitID)) {
            return orgUnitNameCacheMap.get(orgUnitID);
        }
        String fname = null;
        StringBuilder sql = new StringBuilder();
        sql.append("select fname_l2 As fname from t_org_storage where fid = ?  ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{orgUnitID});
            while (rs.next()) {
                fname = rs.getString("fname");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        if (orgUnitNameCacheMap == null) {
            orgUnitNameCacheMap = new HashMap<String, String>();
        }
        orgUnitNameCacheMap.put(orgUnitID, fname);
        return fname;
    }

    protected static SelectorItemCollection getOrgUnitNameSic() throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        return sic;
    }
}

