/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.convert.process;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.DBOMTypeEnum;
import com.kingdee.eas.zjbom.ProcessBomBillFactory;
import com.kingdee.eas.zjbom.ProcessBomBillInfo;
import com.kingdee.eas.zjbom.convert.BomConvertLogEntryInfo;
import com.kingdee.eas.zjbom.convert.BomConvertLogInfo;
import com.kingdee.eas.zjbom.convert.ExecStatusEnum;
import com.kingdee.eas.zjbom.convert.bomConvertFacadeFactory;
import com.kingdee.eas.zjbom.convert.process.BomUnConvertBaseProcess;
import com.kingdee.eas.zjbom.convert.util.BomUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;

public class BomUnConvertProcessBomProcess
extends BomUnConvertBaseProcess {
    public ProcessBomBillInfo processBomBillInfo = null;

    @Override
    public void unConvert(Context ctx, BomConvertLogEntryInfo entryInfo, BomConvertLogInfo info) throws BOSException, EASBizException {
        super.unConvert(ctx, entryInfo, info);
        if (this.isException) {
            return;
        }
        this.getProcessBomBillInfo(ctx, entryInfo.getSourceBomID());
        if (this.checkData(ctx) && bomConvertFacadeFactory.getLocalInstance(ctx).unconvertRequired(this.processBomBillInfo, this.bomConvertLogInfo, this.bomConvertLogEntryInfo)) {
            this.afterUnConvert(ctx);
        }
    }

    public ProcessBomBillInfo getProcessBomBillInfo(Context ctx, String fid) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        this.processBomBillInfo = ProcessBomBillFactory.getLocalInstance(ctx).getProcessBomBillInfo((IObjectPK)new ObjectUuidPK(fid), sic);
        return this.processBomBillInfo;
    }

    public boolean checkData(Context ctx) throws BOSException, EASBizException {
        if (this.processBomBillInfo.getState() == null || !this.processBomBillInfo.getState().equals((Object)BillBaseStatusEnum.AUDITED)) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"Status_NoAudit", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            this.updateSic = new SelectorItemCollection();
            this.updateSic.add(new SelectorItemInfo("execResult"));
            this.updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, this.updateSic);
            return false;
        }
        if (!this.processBomBillInfo.isIsImport()) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"NoConvertStatus", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            this.updateSic = new SelectorItemCollection();
            this.updateSic.add(new SelectorItemInfo("execResult"));
            this.updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, this.updateSic);
            return false;
        }
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        if (this.processBomBillInfo.getConvertBomType() != null && this.processBomBillInfo.getConvertBomType().equals((Object)DBOMTypeEnum.MfgBom)) {
            sql.append(" Select d.fid As fbomentryID,h.fstorageorgunitid ");
            sql.append(" from t_mm_bom h ");
            sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid ");
            sql.append(" where h.fdesignModeID = ? ");
            sql.append(" and d.fsourceprocessid = ? ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{this.processBomBillInfo.getDesignMode().getId().toString(), this.processBomBillInfo.getId().toString()});
            ArrayList<String> bomEntryIDList = new ArrayList<String>();
            ArrayList<String> orgUnitIDList = new ArrayList<String>();
            try {
                while (rs.next()) {
                    bomEntryIDList.add(rs.getString("fbomentryID"));
                    if (orgUnitIDList.contains(rs.getString("fstorageorgunitid"))) continue;
                    orgUnitIDList.add(rs.getString("fstorageorgunitid"));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            String bomCheckResule = BomUtil.checkBomCanUnConvert(ctx, bomEntryIDList);
            if (bomCheckResule == null || !bomCheckResule.equals("ok")) {
                this.bomConvertLogEntryInfo.setExecResult(bomCheckResule);
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                this.updateSic = new SelectorItemCollection();
                this.updateSic.add(new SelectorItemInfo("execResult"));
                this.updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, this.updateSic);
                return false;
            }
            if (orgUnitIDList != null && orgUnitIDList.size() > 0) {
                for (int i = 0; i < orgUnitIDList.size(); ++i) {
                    if (this.checkPermission(ctx, ((String)orgUnitIDList.get(i)).toString(), "mm_bom_delete").booleanValue()) continue;
                    this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"NoPermission_BOM_Delete", (Locale)ctx.getLocale(), (Object[])new String[]{BomUnConvertProcessBomProcess.getOrgUnitName(ctx, ((String)orgUnitIDList.get(i)).toString())}));
                    this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                    this.updateSic = new SelectorItemCollection();
                    this.updateSic.add(new SelectorItemInfo("execResult"));
                    this.updateSic.add(new SelectorItemInfo("execStatus"));
                    this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, this.updateSic);
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean execUnConvert(Context ctx, ProcessBomBillInfo pbInfo) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        if (pbInfo.getConvertBomType() != null && pbInfo.getConvertBomType().equals((Object)DBOMTypeEnum.MfgBom)) {
            sql.append(" Select d.fid As fbomentryID,h.fid As fbomid ");
            sql.append(" from t_mm_bom h ");
            sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid ");
            sql.append(" where h.fdesignModeID = ? ");
            sql.append(" and d.fsourcebillentryid = ? ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{pbInfo.getDesignMode().getId().toString(), pbInfo.getId().toString()});
            ArrayList<String> bomEntryIDList = new ArrayList<String>();
            ArrayList<String> bomIDList = new ArrayList<String>();
            try {
                while (rs.next()) {
                    bomEntryIDList.add(rs.getString("fbomentryID"));
                    bomIDList.add(rs.getString("fbomid"));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            sql.setLength(0);
            sql.append(" delete from t_mm_bomentry where  fid in (").append(SQLUtil.arrayToString((Object[])bomEntryIDList.toArray())).append(") ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" delete from t_mm_bom where  fid in (").append(SQLUtil.arrayToString((Object[])bomIDList.toArray())).append(") ");
            sql.append(" And Not Exists(Select 1 from t_mm_bomentry where fparentid =  t_mm_bom .fid ) ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" delete from t_bot_relation a where a.fsrcobjectid = ? and fdestentityid = ?  ");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{pbInfo.getId().toString(), "8F409A89"});
        }
        return true;
    }

    @Override
    public void afterUnConvert(Context ctx) throws BOSException, EASBizException {
        super.afterUnConvert(ctx);
        this.updateProcessBomStatus(ctx);
    }

    public void updateProcessBomStatus(Context ctx) throws BOSException, EASBizException {
        this.processBomBillInfo.setIsImport(false);
        this.processBomBillInfo.setConvertBomType(DBOMTypeEnum.NULL);
        this.processBomBillInfo.setConvertDate(null);
        this.processBomBillInfo.setConverter(null);
        this.updateSic = new SelectorItemCollection();
        this.updateSic.add(new SelectorItemInfo("isImport"));
        this.updateSic.add(new SelectorItemInfo("convertBomType"));
        this.updateSic.add(new SelectorItemInfo("convertDate"));
        this.updateSic.add(new SelectorItemInfo("converter"));
        ProcessBomBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)this.processBomBillInfo, this.updateSic);
    }
}

