/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.convert.process.change;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.DesignModeInfo;
import com.kingdee.eas.mm.basedata.IssuePropEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.DBOMTypeEnum;
import com.kingdee.eas.zjbom.ProcessBomChangeBillFactory;
import com.kingdee.eas.zjbom.ProcessBomChangeBillInfo;
import com.kingdee.eas.zjbom.convert.BomChangeBillAuditFacadeFactory;
import com.kingdee.eas.zjbom.convert.BomConvertLogEntryInfo;
import com.kingdee.eas.zjbom.convert.BomConvertLogInfo;
import com.kingdee.eas.zjbom.convert.ExecStatusEnum;
import com.kingdee.eas.zjbom.convert.process.change.BomChangeAuditBaseProcess;
import com.kingdee.eas.zjbom.util.BomUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Locale;

public class BomChangeAuditProcessBomCheckDataProcess
extends BomChangeAuditBaseProcess {
    public ProcessBomChangeBillInfo changeBillInfo = null;

    @Override
    public void convert(Context ctx, BomConvertLogEntryInfo entryInfo, BomConvertLogInfo info) throws BOSException, EASBizException {
        super.convert(ctx, entryInfo, info);
        if (this.isException) {
            return;
        }
        this.getChangeBillInfo(ctx, entryInfo.getSourceBomID());
        if (!this.checkBillbaseStatus(ctx)) {
            return;
        }
        if (!this.checkBillCompleted(ctx)) {
            return;
        }
        if (!this.checkBillFiledsNull(ctx)) {
            return;
        }
        if (!this.checkBillValidData(ctx)) {
            return;
        }
        if (!this.checkChangeDataIsValid(ctx)) {
            return;
        }
        String errorStr = null;
        MeasureUnitInfo pUnitInfo = BomChangeAuditProcessBomCheckDataProcess.getMeasureUnitInfo(ctx, this.changeBillInfo.getPUnitName(), this.changeBillInfo.getParentPts());
        errorStr = BomChangeAuditProcessBomCheckDataProcess.checkMaterialPlan(ctx, this.changeBillInfo.getParentPts().getId().toString(), this.changeBillInfo.getLeadInOrgUnitEAS().getId().toString(), this.changeBillInfo.getDesignMode(), DBOMTypeEnum.MfgBom, true, true, pUnitInfo);
        if (errorStr != null && !errorStr.equals("ok")) {
            this.bomConvertLogEntryInfo.setExecResult(errorStr);
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return;
        }
        MeasureUnitInfo unitInfo = BomChangeAuditProcessBomCheckDataProcess.getMeasureUnitInfo(ctx, this.changeBillInfo.getUnitP(), this.changeBillInfo.getPts());
        errorStr = BomChangeAuditProcessBomCheckDataProcess.checkMaterialPlan(ctx, this.changeBillInfo.getPts().getId().toString(), this.changeBillInfo.getSuppliesOrgUnitEAS().getId().toString(), this.changeBillInfo.getDesignMode(), DBOMTypeEnum.MfgBom, true, false, unitInfo);
        if (errorStr != null && !errorStr.equals("ok")) {
            this.bomConvertLogEntryInfo.setExecResult(errorStr);
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return;
        }
        errorStr = BomChangeAuditProcessBomCheckDataProcess.checkMaterialInventroy(ctx, this.changeBillInfo.getParentPts().getId().toString(), this.changeBillInfo.getLeadInOrgUnitEAS().getId().toString());
        if (errorStr != null && !errorStr.equals("ok")) {
            this.bomConvertLogEntryInfo.setExecResult(errorStr);
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return;
        }
        errorStr = BomChangeAuditProcessBomCheckDataProcess.checkMaterialInventroy(ctx, this.changeBillInfo.getPts().getId().toString(), this.changeBillInfo.getSuppliesOrgUnitEAS().getId().toString());
        if (errorStr != null && !errorStr.equals("ok")) {
            this.bomConvertLogEntryInfo.setExecResult(errorStr);
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return;
        }
        if (!BomChangeAuditProcessBomCheckDataProcess.checkMaterialDisCU(ctx, null, this.changeBillInfo.getPts().getId().toString())) {
            CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"MaterialNoCU", (Locale)ctx.getLocale(), (Object[])new String[]{this.changeBillInfo.getPts().getNumber(), ctrlUnitInfo.getName()}));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return;
        }
        if (!BomChangeAuditProcessBomCheckDataProcess.checkMaterialDisCU(ctx, null, this.changeBillInfo.getParentPts().getId().toString())) {
            CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"ParentMaterialNoCU", (Locale)ctx.getLocale(), (Object[])new String[]{this.changeBillInfo.getParentPts().getNumber(), ctrlUnitInfo.getName()}));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return;
        }
        if (!this.checkPermission(ctx, this.changeBillInfo.getLeadInOrgUnitEAS().getId().toString(), "mm_bom_update").booleanValue()) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL2, (String)"NoPermissionByMMBomUpdate", (Locale)ctx.getLocale(), (Object[])new String[]{this.changeBillInfo.getLeadInOrgUnitEAS().getName()}));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return;
        }
        this.updateSuccessfulStatus(ctx);
    }

    public ProcessBomChangeBillInfo getChangeBillInfo(Context ctx, String fid) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("complete"));
        sic.add(new SelectorItemInfo("issueProp"));
        sic.add(new SelectorItemInfo("mainTenanceLevel.id"));
        sic.add(new SelectorItemInfo("unitP"));
        sic.add(new SelectorItemInfo("ptsNumberP"));
        sic.add(new SelectorItemInfo("parentPtsNumberP"));
        sic.add(new SelectorItemInfo("pts.id"));
        sic.add(new SelectorItemInfo("pts.number"));
        sic.add(new SelectorItemInfo("pts.baseUnit.id"));
        sic.add(new SelectorItemInfo("pts.baseUnit.number"));
        sic.add(new SelectorItemInfo("pts.baseUnit.name"));
        sic.add(new SelectorItemInfo("parentPts.id"));
        sic.add(new SelectorItemInfo("parentPts.number"));
        sic.add(new SelectorItemInfo("parentPts.baseUnit.id"));
        sic.add(new SelectorItemInfo("parentPts.baseUnit.number"));
        sic.add(new SelectorItemInfo("parentPts.baseUnit.name"));
        sic.add(new SelectorItemInfo("fixed"));
        sic.add(new SelectorItemInfo("technologicalFlow"));
        sic.add(new SelectorItemInfo("afterFlow"));
        sic.add(new SelectorItemInfo("projectNo.id"));
        sic.add(new SelectorItemInfo("projectNo.number"));
        sic.add(new SelectorItemInfo("trackNumberStart.id"));
        sic.add(new SelectorItemInfo("trackNumberStart.number"));
        sic.add(new SelectorItemInfo("trackNumberEnd.id"));
        sic.add(new SelectorItemInfo("trackNumberEnd.number"));
        sic.add(new SelectorItemInfo("suppliesOrgUnitEAS.id"));
        sic.add(new SelectorItemInfo("suppliesOrgUnitEAS.number"));
        sic.add(new SelectorItemInfo("leadInOrgUnitEAS.id"));
        sic.add(new SelectorItemInfo("leadInOrgUnitEAS.number"));
        sic.add(new SelectorItemInfo("leadInOrgUnitEAS.name"));
        sic.add(new SelectorItemInfo("materialSources"));
        sic.add(new SelectorItemInfo("processBom.id"));
        sic.add(new SelectorItemInfo("oldBom.id"));
        sic.add(new SelectorItemInfo("oldBom.storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("oldBom.parentNo"));
        sic.add(new SelectorItemInfo("oldBom.portNo"));
        sic.add(new SelectorItemInfo("oldBom.parentQty"));
        sic.add(new SelectorItemInfo("oldBom.pUnitname"));
        sic.add(new SelectorItemInfo("oldBom.ration"));
        sic.add(new SelectorItemInfo("oldBom.project.id"));
        sic.add(new SelectorItemInfo("oldBom.drawBillOrg.id"));
        sic.add(new SelectorItemInfo("oldBom.storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("oldBom.endCarno.id"));
        sic.add(new SelectorItemInfo("oldBom.beginCarno.id"));
        sic.add(new SelectorItemInfo("oldBom.materialProperty"));
        sic.add(new SelectorItemInfo("supplier.id"));
        sic.add(new SelectorItemInfo("supplier.number"));
        sic.add(new SelectorItemInfo("getSupplier.id"));
        sic.add(new SelectorItemInfo("getSupplier.number"));
        sic.add(new SelectorItemInfo("designMode.*"));
        sic.add(new SelectorItemInfo("parentQty"));
        sic.add(new SelectorItemInfo("pUnitName"));
        sic.add(new SelectorItemInfo("designMode.Entry.*"));
        sic.add(new SelectorItemInfo("designMode.Entry.manufactureStrategy.id"));
        sic.add(new SelectorItemInfo("designMode.Entry.manufactureStrategy.number"));
        sic.add(new SelectorItemInfo("designMode.Entry.manufactureStrategy.name"));
        this.changeBillInfo = ProcessBomChangeBillFactory.getLocalInstance(ctx).getProcessBomChangeBillInfo((IObjectPK)new ObjectUuidPK(fid), sic);
        return this.changeBillInfo;
    }

    public boolean checkBillbaseStatus(Context ctx) throws BOSException, EASBizException {
        if (this.changeBillInfo.getBaseStatus() != null && this.changeBillInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL2, (String)"billIsAudit", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        return true;
    }

    public boolean checkBillCompleted(Context ctx) throws BOSException, EASBizException {
        if (this.changeBillInfo.isComplete()) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL2, (String)"billIsComplete", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        return true;
    }

    public boolean checkChangeDataIsValid(Context ctx) throws BOSException, EASBizException {
        if (BomChangeAuditProcessBomCheckDataProcess.checkIsChangeParentQtyOrUnit(ctx, this.changeBillInfo)) {
            if (BomChangeAuditProcessBomCheckDataProcess.checkIsChangeChildOthers(ctx, this.changeBillInfo)) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL2, (String)"ChangeValid_001", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (BomChangeAuditProcessBomCheckDataProcess.getMeasureUnitInfo(ctx, this.changeBillInfo.getPUnitName(), null) == null) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL2, (String)"ChangeValid_002", (Locale)ctx.getLocale(), (Object[])new String[]{this.changeBillInfo.getPUnitName()}));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
        }
        return true;
    }

    public static boolean checkIsChangeChildOthers(Context ctx, ProcessBomChangeBillInfo info) {
        if (info.getOldBom() != null) {
            int newMaterialAttr;
            String newStorageOrgUnitID;
            if (!BomUtil.equals(info.getFixed(), info.getOldBom().getRation())) {
                return true;
            }
            if (info.getDesignMode() != null && info.getDesignMode().isProject()) {
                String newProjectID;
                String oldProjectID = info.getOldBom().getProject() == null ? "" : info.getOldBom().getProject().getId().toString();
                String string = newProjectID = info.getProjectNo() == null ? "" : info.getProjectNo().getId().toString();
                if (!StringUtils.equalsIgnoreCase((String)oldProjectID, (String)newProjectID)) {
                    return true;
                }
            }
            if (info.getDesignMode() != null && info.getDesignMode().isTrackNumber()) {
                String newEndTrackNumberID;
                String oldBeginTrackNumberID = info.getOldBom().getBeginCarno() == null ? "" : info.getOldBom().getBeginCarno().getId().toString();
                String oldEndnTrackNumberID = info.getOldBom().getEndCarno() == null ? "" : info.getOldBom().getEndCarno().getId().toString();
                String newBeginTrackNumberID = info.getTrackNumberStart() == null ? "" : info.getTrackNumberStart().getId().toString();
                String string = newEndTrackNumberID = info.getTrackNumberEnd() == null ? "" : info.getTrackNumberEnd().getId().toString();
                if (!StringUtils.equalsIgnoreCase((String)oldBeginTrackNumberID, (String)newBeginTrackNumberID) || !StringUtils.equalsIgnoreCase((String)oldEndnTrackNumberID, (String)newEndTrackNumberID)) {
                    return true;
                }
            }
            String oldSupplyOrgUnitID = info.getOldBom().getDrawBillOrg() == null ? "" : info.getOldBom().getDrawBillOrg().getId().toString();
            String oldStorageOrgUnitID = info.getOldBom().getStorageOrgUnit() == null ? "" : info.getOldBom().getStorageOrgUnit().getId().toString();
            String newSupplyOrgUnitID = info.getSuppliesOrgUnitEAS() == null ? "" : info.getSuppliesOrgUnitEAS().getId().toString();
            String string = newStorageOrgUnitID = info.getLeadInOrgUnitEAS() == null ? "" : info.getLeadInOrgUnitEAS().getId().toString();
            if (!StringUtils.equalsIgnoreCase((String)oldSupplyOrgUnitID, (String)newSupplyOrgUnitID) || !StringUtils.equalsIgnoreCase((String)oldStorageOrgUnitID, (String)newStorageOrgUnitID)) {
                return true;
            }
            int oldMaterialAttr = info.getOldBom().getMaterialProperty().getValue();
            if (oldMaterialAttr != (newMaterialAttr = info.getMaterialSources().getValue())) {
                return true;
            }
        }
        return false;
    }

    public static boolean checkIsChangeParentQtyOrUnit(Context ctx, ProcessBomChangeBillInfo info) {
        BigDecimal newParentQty = info.getParentQty();
        String newParentUnitName = info.getPUnitName();
        StorageOrgUnitInfo newStorageOrgUnitInfo = info.getLeadInOrgUnitEAS();
        StorageOrgUnitInfo oldStorageOrgUnitInfo = null;
        String newparentNumber = info.getParentPtsNumberP();
        String oldparentNumber = null;
        BigDecimal oldParentQty = null;
        String oldParentUnitName = null;
        if (info.getOldBom() == null) {
            return false;
        }
        oldParentQty = info.getOldBom().getParentQty();
        oldParentUnitName = info.getOldBom().getPUnitname();
        oldStorageOrgUnitInfo = info.getOldBom().getStorageOrgUnit();
        oldparentNumber = info.getOldBom().getParentNo();
        if (!BomUtil.equals(newParentQty, oldParentQty)) {
            return true;
        }
        if (!StringUtils.equalsIgnoreCase((String)newparentNumber, (String)oldparentNumber)) {
            return false;
        }
        return !StringUtils.equalsIgnoreCase((String)newParentUnitName, (String)oldParentUnitName);
    }

    public static boolean checkIsChangeParentMaterialOrOrgUnit(Context ctx, ProcessBomChangeBillInfo info) {
        StorageOrgUnitInfo newStorageOrgUnitInfo = info.getLeadInOrgUnitEAS();
        StorageOrgUnitInfo oldStorageOrgUnitInfo = null;
        String newparentNumber = info.getParentPtsNumberP();
        String oldparentNumber = null;
        if (info.getOldBom() == null) {
            return false;
        }
        oldStorageOrgUnitInfo = info.getOldBom().getStorageOrgUnit();
        oldparentNumber = info.getOldBom().getParentNo();
        if (!StringUtils.equalsIgnoreCase((String)newparentNumber, (String)oldparentNumber)) {
            return true;
        }
        return !StringUtils.equalsIgnoreCase((String)newStorageOrgUnitInfo.getId().toString(), (String)oldStorageOrgUnitInfo.getId().toString());
    }

    public boolean checkBillFiledsNull(Context ctx) throws BOSException, EASBizException {
        IRowSet rs;
        if (UIRuleUtil.isNull((BigDecimal)this.changeBillInfo.getFixed())) {
            this.changeBillInfo.setFixed(BigDecimal.ZERO);
        }
        StringBuilder sql = new StringBuilder();
        if (UIRuleUtil.isNull((Object)this.changeBillInfo.getLeadInOrgUnitEAS())) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL2, (String)"StorageOrgUnit_Null", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        if (UIRuleUtil.isNull((Object)this.changeBillInfo.getSuppliesOrgUnitEAS())) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL2, (String)"SupplyOrgUnit_Null", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        if (UIRuleUtil.isNull((Object)this.changeBillInfo.getMaterialSources())) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL2, (String)"MaterialAttr_Null", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        if (UIRuleUtil.isNull((Object)this.changeBillInfo.getParentPts())) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL2, (String)"ParentMaterialNumber_Null", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        if (UIRuleUtil.isNull((Object)this.changeBillInfo.getPts())) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL2, (String)"MaterialNumber_Null", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        if (UIRuleUtil.isNull((Object)this.changeBillInfo.getDesignMode())) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL2, (String)"DesignMode_Null", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        DesignModeInfo dsInfo = this.changeBillInfo.getDesignMode();
        if (dsInfo.isProject() && UIRuleUtil.isNull((Object)this.changeBillInfo.getProjectNo())) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL2, (String)"Project_Null", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        if (dsInfo.isTrackNumber() && UIRuleUtil.isNull((Object)this.changeBillInfo.getTrackNumberStart())) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL2, (String)"beginTrackNumber_Null", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        if (dsInfo.isTrackNumber() && UIRuleUtil.isNull((Object)this.changeBillInfo.getTrackNumberEnd())) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL2, (String)"endTrackNumber_Null", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        if (UIRuleUtil.isNull((BigDecimal)this.changeBillInfo.getParentQty())) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL2, (String)"parentQty_Null", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        if (UIRuleUtil.isNull((String)this.changeBillInfo.getPUnitName())) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL2, (String)"parentMUnit_Null", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        if (this.changeBillInfo.getUnitP() == null || "".equals(this.changeBillInfo.getUnitP())) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"MUnit_Null", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        MeasureUnitInfo pUnitInfo = BomChangeAuditProcessBomCheckDataProcess.getMeasureUnitInfo(ctx, this.changeBillInfo.getPUnitName(), this.changeBillInfo.getParentPts());
        if (pUnitInfo == null) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"unit_NoBaseData", (Locale)ctx.getLocale(), (Object[])new String[]{this.changeBillInfo.getPUnitName()}));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        MeasureUnitInfo unitInfo = BomChangeAuditProcessBomCheckDataProcess.getMeasureUnitInfo(ctx, this.changeBillInfo.getUnitP(), this.changeBillInfo.getPts());
        if (unitInfo == null) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"unit_NoBaseData", (Locale)ctx.getLocale(), (Object[])new String[]{this.changeBillInfo.getUnitP()}));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        String errorStr = null;
        errorStr = BomChangeAuditProcessBomCheckDataProcess.checkMaterialUnitConvertRate(ctx, this.changeBillInfo.getParentPts(), pUnitInfo, this.changeBillInfo.getParentPts().getBaseUnit());
        if (errorStr != null && !errorStr.equals("ok")) {
            this.bomConvertLogEntryInfo.setExecResult(errorStr);
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        errorStr = BomChangeAuditProcessBomCheckDataProcess.checkMaterialUnitConvertRate(ctx, this.changeBillInfo.getPts(), unitInfo, this.changeBillInfo.getPts().getBaseUnit());
        if (errorStr != null && !errorStr.equals("ok")) {
            this.bomConvertLogEntryInfo.setExecResult(errorStr);
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        if (this.changeBillInfo.getMainTenanceLevel() != null && (this.changeBillInfo.getIssueProp() == null || this.changeBillInfo.getIssueProp().equals((Object)IssuePropEnum.NULL))) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"IssueProp_Null", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        if (this.changeBillInfo.getOldBom() == null) {
            sql.setLength(0);
            sql.append(" Select h.fid ");
            sql.append(" from ct_zjb_processbombill h ");
            if (dsInfo.isTrackNumber()) {
                sql.append(" left outer join t_mm_tracknumber bt on bt.fid = h.cfbegincarnoid ");
                sql.append(" left outer join t_mm_tracknumber et on et.fid = h.cfendcarnoid ");
            }
            sql.append(" where  h.cfparentno = ? and h.cfportno = ? and h.cfstorageorgunitid = ? ");
            sql.append(" and h.cfdrawbillorgid = ? ");
            sql.append(" and h.cfration > 0 ");
            if (this.changeBillInfo.getMainTenanceLevel() == null) {
                sql.append(" and h.FMainTenanceLevelID is null ");
            } else {
                sql.append(" and h.FMainTenanceLevelID = '" + this.changeBillInfo.getMainTenanceLevel().getId() + "' ");
            }
            if (dsInfo.isProject()) {
                sql.append(" and h.cfprojectid = '" + this.changeBillInfo.getProjectNo().getId() + "' ");
            }
            if (dsInfo.isTrackNumber()) {
                sql.append(" and bt.fnumber <= '" + this.changeBillInfo.getTrackNumberStart().getNumber() + "' ");
                sql.append(" and et.fnumber >= '" + this.changeBillInfo.getTrackNumberEnd().getNumber() + "' ");
            }
            if ((rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{this.changeBillInfo.getParentPtsNumberP(), this.changeBillInfo.getPtsNumberP(), this.changeBillInfo.getLeadInOrgUnitEAS().getId().toString(), this.changeBillInfo.getSuppliesOrgUnitEAS().getId().toString()})) != null && rs.size() > 0) {
                String errNumber = "ProcessBomExistSameDatas";
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)errNumber, (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
        }
        sql.setLength(0);
        sql.append(" Select d.fid,d.FSourceProcessId as processId ");
        sql.append(" from t_mm_bom h ");
        sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid ");
        if (dsInfo.isTrackNumber()) {
            sql.append(" left outer join t_mm_tracknumber bt on bt.fid = d.fbegincarnoid ");
            sql.append(" left outer join t_mm_tracknumber et on et.fid = d.fendcarnoid ");
        }
        sql.append(" where  h.fmaterialid = ? and d.fmaterialid = ? and h.fstorageorgunitid = ? and h.fdesignmodeid = ? ");
        sql.append(" and d.fsupplystorageorgunitid = ? ");
        if (this.changeBillInfo.getMainTenanceLevel() == null) {
            sql.append(" and h.FMainTenanceLevelID is null ");
        } else {
            sql.append(" and h.FMainTenanceLevelID = '" + this.changeBillInfo.getMainTenanceLevel().getId() + "' ");
        }
        if (dsInfo.isProject()) {
            sql.append(" and h.fprojectid = '" + this.changeBillInfo.getProjectNo().getId() + "' ");
        }
        if (dsInfo.isTrackNumber()) {
            sql.append(" and bt.fnumber <= '" + this.changeBillInfo.getTrackNumberStart().getNumber() + "' ");
            sql.append(" and et.fnumber >= '" + this.changeBillInfo.getTrackNumberEnd().getNumber() + "' ");
        }
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{this.changeBillInfo.getParentPts().getId().toString(), this.changeBillInfo.getPts().getId().toString(), this.changeBillInfo.getLeadInOrgUnitEAS().getId().toString(), dsInfo.getId().toString(), this.changeBillInfo.getSuppliesOrgUnitEAS().getId().toString()});
        try {
            if (rs != null && rs.next() && (rs.getString("processId") == null || !rs.getString("processId").equals(this.changeBillInfo.getProcessBom().getId().toString()))) {
                String errNumber = "isExists_ProcessBom_ManuBom";
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)errNumber, (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.bomConvertLogEntryInfo.setExecResult(e.getMessage());
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        return true;
    }

    public boolean checkBillValidData(Context ctx) throws BOSException, EASBizException {
        String errorStr = BomChangeBillAuditFacadeFactory.getLocalInstance(ctx).checkProcessBomBillData(null, this.changeBillInfo.getId().toString());
        if (errorStr != null && !"ok".equals(errorStr)) {
            this.bomConvertLogEntryInfo.setExecResult(errorStr);
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        return true;
    }
}

