/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcp.client;

import com.kingdee.bos.ctrl.freechart.ui.ExtensionFileFilter;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.industry.emm.pcp.ProjectCollaborationPlanInfo;
import com.kingdee.eas.industry.emm.pcp.ProjectCollaborationPlanScheduleEntryCollection;
import com.kingdee.eas.industry.emm.pcp.ProjectCollaborationPlanScheduleEntryFactory;
import com.kingdee.eas.industry.emm.pcp.ProjectCollaborationPlanScheduleEntryInfo;
import com.kingdee.eas.industry.emm.pcp.client.PCPGanttChartQueryUI;
import com.kingdee.eas.industry.emm.pcp.client.PCPGanttUI;
import com.kingdee.eas.industry.emm.pcp.client.ProjectCollaborationPlanEditUI;
import com.kingdee.eas.mm.basedata.ResourceInfo;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttCalendar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTask;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.action.GPAction;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.action.task.TaskPropertiesAction;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.TestGanttRolloverButton;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.CustomColumn;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskNode;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.util.GanttResourceUtil;
import com.kingdee.eas.scm.common.client.ISCMFilter;
import com.kingdee.eas.scm.common.client.SCMCommonProcessor;
import com.kingdee.eas.scm.common.client.SCMPromptBoxFactory;
import com.kingdee.eas.util.IndustryUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class PCPGanttChartUI
extends GanttProject {
    public static final String COL_QTY = EASResource.getString((String)"com.kingdee.eas.industry.emm.pcp.PCPResource", (String)"0EMMPCPPcp-0127");
    public static final String COL_RESOURCE = EASResource.getString((String)"com.kingdee.eas.industry.emm.pcp.PCPResource", (String)"0EMMPCPPcp-0128");
    private static final long serialVersionUID = -8112370140372800024L;
    private String Resource_Name = "com.kingdee.eas.industry.emm.pcp.PCPResource";
    private String SX_NAME = EASResource.getString((String)this.Resource_Name, (String)"SX_NAME");
    private String FD_NAME = EASResource.getString((String)this.Resource_Name, (String)"FD_NAME");
    private String KEY_BUTTON = "KEY_BUTTON";
    KDWorkButton btnQuery = null;
    KDWorkButton btnRefresh = null;
    KDWorkButton btnView = null;
    CustomerQueryPanel cqp = null;
    final CommonQueryDialog dialog = new CommonQueryDialog();
    final Map dMap = new HashMap();
    final Map filterMap = new HashMap();
    final MetaDataPK mainQueryPK = MetaDataPK.create((String)"com.kingdee.eas.framework.report.app", (String)"CommRptEmptyQuery");
    final Map nMap = new HashMap();
    final Map sMap = new HashMap();
    TestGanttRolloverButton zoomInButton = null;
    TestGanttRolloverButton zoomOutButton = null;

    public PCPGanttChartUI(boolean isOnlyViewer) {
        super(isOnlyViewer);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public void actionPerformed(ActionEvent e) {
        KDWorkButton wb;
        super.actionPerformed(e);
        Object source = e.getSource();
        if (e == null) {
            return;
        }
        if (e.getSource() instanceof KDWorkButton && (wb = (KDWorkButton)source) == this.btnFile) {
            this.savePicture();
        }
    }

    public JMenuItem createNewItem(JMenuItem item, String icon, String name) {
        if (IndustryUtils.isEmptyString((String)name)) {
            return null;
        }
        item = IndustryUtils.isEmptyString((String)icon) ? new JMenuItem() : new JMenuItem(EASResource.getIcon((String)icon));
        item.setName(name);
        item.addActionListener((ActionListener)((Object)this));
        return item;
    }

    public int[] getDefaultIconListIntArray() {
        return new int[]{0, 48, 8, 33, 46, 47, 0, 21, 23, 24, 25, 0, 1, 54, 55, 56, 57};
    }

    public String getSelectFile(boolean isSave, String[] ext) throws Exception {
        KDFileChooser chooser = new KDFileChooser(new File("."));
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setDialogTitle(GanttResourceUtil.getResource((String)"Gantt_File"));
        for (int i = 0; i < ext.length; ++i) {
            chooser.addChoosableFileFilter((FileFilter)new ExtensionFileFilter(ext[i], ext[i]));
        }
        int returnVal = 0;
        returnVal = isSave ? chooser.showSaveDialog((Component)((Object)this)) : chooser.showOpenDialog((Component)((Object)this));
        String strFullPath = null;
        String fExt = null;
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            strFullPath = file.getPath();
            fExt = chooser.getFileFilter().getDescription();
            int index = fExt.indexOf(".");
            fExt = fExt.substring(index + 1);
        }
        if (isSave && strFullPath != null && !strFullPath.endsWith("." + fExt)) {
            return strFullPath + "." + fExt;
        }
        return strFullPath;
    }

    public DefaultListModel initIconList() {
        DefaultListModel dlm = super.initIconList();
        int dlmSize = dlm.size();
        for (int index = 0; index < dlmSize; ++index) {
            TestGanttRolloverButton button;
            Object element = dlm.getElementAt(index);
            TestGanttRolloverButton testGanttRolloverButton = element == null ? null : (button = element instanceof TestGanttRolloverButton ? (TestGanttRolloverButton)element : null);
            if (button == null) continue;
            String keyValue = (String)button.getClientProperty((Object)this.KEY_BUTTON);
            if ("ZOOMIN".equals(keyValue)) {
                this.zoomInButton = button;
                button.setText(this.SX_NAME);
            } else {
                if (!"ZOOMOUT".equals(keyValue)) continue;
                this.zoomOutButton = button;
                button.setText(this.FD_NAME);
            }
            dlm.setElementAt(button, index);
        }
        if (dlm != null) {
            dlm.insertElementAt(this.btnQuery, 1);
            dlm.insertElementAt(this.btnRefresh, 2);
            dlm.insertElementAt(this.btnView, 3);
        }
        return dlm;
    }

    public void initTaskPropeeties() {
        this.setMyTaskPropertiesAction((GPAction)new TaskPropertiesAction(this.getProject(), this.taskSelectionManager, this.getUIFacade()));
        super.initTaskPropeeties();
    }

    public void propertiesTask(int type) {
        try {
            this.view(null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void savePicture() {
        BufferedImage image = this.getImage();
        try {
            String strFullPath = this.getSelectFile(true, new String[]{"jpg"});
            if (strFullPath != null) {
                File file = new File(strFullPath);
                if (file.exists() && !this.showConFirm(GanttResourceUtil.getResource((String)"Gantt_IsCoverPassed"))) {
                    return;
                }
                ImageIO.write((RenderedImage)image, "JPG", new File(strFullPath));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void setButtonText() {
        super.setButtonText();
        if (this.zoomInButton != null) {
            this.zoomInButton.setText(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcp.PCPResource", (String)"0EMMPCPPcp-0129"));
            this.zoomInButton.putClientProperty((Object)this.KEY_BUTTON, (Object)"ZOOMIN");
        }
        if (this.zoomOutButton != null) {
            this.zoomOutButton.setText(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcp.PCPResource", (String)"0EMMPCPPcp-0130"));
            this.zoomOutButton.putClientProperty((Object)this.KEY_BUTTON, (Object)"ZOOMOUT");
        }
    }

    public void show() {
        try {
            this.setTitle(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcp.PCPResource", (String)"0EMMPCPPcp-0131"));
            this.init();
            this.query(null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        super.show();
    }

    protected CustomColumn addColumn(String name, Class type) {
        KDFormattedTextField ftxt;
        if (IndustryUtils.isEmptyString((String)name) || type == null) {
            return null;
        }
        DefaultCellEditor dce = null;
        Object defaultValue = null;
        if (String.class.getName().equals(type.getName())) {
            KDTextField txt = new KDTextField();
            txt.setMaxLength(255);
            dce = new DefaultCellEditor((JTextField)txt);
            defaultValue = "";
        } else if (Integer.class.getName().equals(type.getName())) {
            ftxt = new KDFormattedTextField();
            ftxt.setHorizontalAlignment(4);
            ftxt.setSupportedEmpty(true);
            ftxt.setDataType(0);
            dce = new DefaultCellEditor((JTextField)ftxt);
            defaultValue = 0;
        } else if (BigDecimal.class.getName().equals(type.getName())) {
            ftxt = new KDFormattedTextField();
            ftxt.setHorizontalAlignment(4);
            ftxt.setSupportedEmpty(true);
            ftxt.setDataType(1);
            ftxt.setMinimumValue((Comparable)new BigDecimal("-1.0E18"));
            ftxt.setMaximumValue((Comparable)new BigDecimal("1.0E18"));
            ftxt.setPrecision(4);
            dce = new DefaultCellEditor((JTextField)ftxt);
            defaultValue = BigDecimal.ZERO;
        }
        if (dce == null) {
            return null;
        }
        CustomColumn cc = new CustomColumn(name, type, defaultValue);
        this.getTree().getTreeTable().addNewCustomColumn(cc, dce, false);
        return cc;
    }

    protected void generateGantt(String parent) throws Exception {
        if (IndustryUtils.isEmptyString((String)parent)) {
            return;
        }
        List childList = IndustryUtils.getMapListData((Map)this.sMap, (Object)parent, new ArrayList());
        if (IndustryUtils.isEmptyList((List)childList)) {
            return;
        }
        int childListSize = childList.size();
        for (int index = 0; index < childListSize; ++index) {
            Map dataMap;
            String childID;
            Object childIDObject = childList.get(index);
            String string = childID = childIDObject == null ? null : childIDObject.toString();
            if (IndustryUtils.isEmptyString((String)childID) || IndustryUtils.isEmptyMap((Map)(dataMap = IndustryUtils.getMapMapData((Map)this.dMap, (Object)childID)))) continue;
            String name = IndustryUtils.getMapStringData((Map)dataMap, (Object)"Name");
            Timestamp st = IndustryUtils.getMapTimestampData((Map)dataMap, (Object)"StartTime");
            Timestamp et = IndustryUtils.getMapTimestampData((Map)dataMap, (Object)"EndTime");
            if (st == null || et == null) continue;
            BigDecimal qty = IndustryUtils.getMapBigDecimalData((Map)dataMap, (Object)"Qty", (BigDecimal)BigDecimal.ZERO);
            String r = IndustryUtils.getMapStringData((Map)dataMap, (Object)"Resource", (String)"");
            GanttTask gt = this.getTaskManager().createTask();
            gt.setName(name);
            gt.setStart(new GanttCalendar((Date)st));
            gt.setEnd(new GanttCalendar((Date)et));
            gt.setMilestone(false);
            gt.getCustomValues().setValue(COL_QTY, (Object)qty);
            gt.getCustomValues().setValue(COL_RESOURCE, (Object)r);
            gt.setUserObject((Object)dataMap);
            long days = (et.getTime() - st.getTime()) / 86400000L;
            if (days > 1L) {
                gt.setDuration(this.getTaskManager().createLength(days));
            }
            gt.setCompletionPercentage(0.0f);
            Object ptnObject = IndustryUtils.getMapData((Map)this.nMap, (Object)parent);
            TaskNode ptn = "Null".equals(parent) ? null : (ptnObject instanceof TaskNode ? (TaskNode)ptnObject : null);
            TaskNode tn = this.getTree().addObject((Object)gt, (MutableTreeNode)ptn, -1);
            this.nMap.put(childID, tn);
            this.generateGantt(childID);
        }
    }

    protected void init() {
        this.addColumn(COL_RESOURCE, String.class);
        this.addColumn(COL_QTY, BigDecimal.class);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (this.btnQuery == null) {
            this.btnQuery = new KDWorkButton();
            this.btnQuery.setText(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcp.PCPResource", (String)"0EMMPCPPcp-0132"));
            this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
            this.btnQuery.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        PCPGanttChartUI.this.query(e);
                    }
                    catch (Exception exc) {
                        ExceptionHandler.handle((Component)((Object)PCPGanttChartUI.this), (Throwable)exc);
                    }
                }
            });
        }
        if (this.btnRefresh == null) {
            this.btnRefresh = new KDWorkButton();
            this.btnRefresh.setText(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcp.PCPResource", (String)"0EMMPCPPcp-0133"));
            this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
            this.btnRefresh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        PCPGanttChartUI.this.refresh(e);
                    }
                    catch (Exception exc) {
                        ExceptionHandler.handle((Component)((Object)PCPGanttChartUI.this), (Throwable)exc);
                    }
                }
            });
        }
        if (this.btnView == null) {
            this.btnView = new KDWorkButton();
            this.btnView.setText(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcp.PCPResource", (String)"0EMMPCPPcp-0134"));
            this.btnView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
            this.btnView.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        PCPGanttChartUI.this.view(e);
                    }
                    catch (Exception exc) {
                        ExceptionHandler.handle((Component)((Object)PCPGanttChartUI.this), (Throwable)exc);
                    }
                }
            });
        }
    }

    protected void query(ActionEvent e) throws Exception {
        if (this.cqp == null) {
            this.cqp = new PCPGanttChartQueryUI();
            this.dialog.setOwner(null);
            this.dialog.setUiObject(null);
            this.dialog.setParentUIClassName(PCPGanttUI.class.getName());
            this.dialog.setQueryObjectPK((IMetaDataPK)this.mainQueryPK);
            this.dialog.setTitle(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
            this.dialog.setMaxReturnCountVisible(true);
            this.dialog.setWidth(450);
            this.dialog.setHeight(320);
            SCMPromptBoxFactory scmF7Factory = new SCMPromptBoxFactory(this.cqp, OrgType.NONE);
            this.dialog.setPromptBoxFactory((IPromptBoxFactory)scmF7Factory);
            this.dialog.setProcessor((IProcessor)new SCMCommonProcessor());
            this.dialog.setShowSorter(false);
            this.dialog.setShowFilter(false);
            ISCMFilter iFilter = (ISCMFilter)this.cqp;
            iFilter.setIsSupportMultiOrgs(false);
            iFilter.setContextObject(null);
            iFilter.setAuthorizedMainOrgs(null);
            this.dialog.addUserPanel((KDPanel)this.cqp);
        }
        if (this.dialog.show()) {
            FilterInfo fi = this.cqp.getFilterInfo();
            this.filterMap.put("FilterInfo", fi);
            this.refresh(e);
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        this.getTaskManager().clear();
        this.getTree().clearTree();
        this.sMap.clear();
        this.dMap.clear();
        this.nMap.clear();
        if (IndustryUtils.isEmptyMap((Map)this.filterMap)) {
            return;
        }
        Object fiObject = IndustryUtils.getMapData((Map)this.filterMap, (Object)"FilterInfo");
        FilterInfo fi = fiObject == null ? null : (fiObject instanceof FilterInfo ? (FilterInfo)fiObject : null);
        EntityViewInfo ev = new EntityViewInfo();
        if (fi != null) {
            ev.setFilter(fi);
        }
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("id"));
        selectorItemCollection.add(new SelectorItemInfo("seq"));
        selectorItemCollection.add(new SelectorItemInfo("planNodeNumber"));
        selectorItemCollection.add(new SelectorItemInfo("planNode"));
        selectorItemCollection.add(new SelectorItemInfo("startTime"));
        selectorItemCollection.add(new SelectorItemInfo("finishTime"));
        selectorItemCollection.add(new SelectorItemInfo("qty"));
        selectorItemCollection.add(new SelectorItemInfo("resource.id"));
        selectorItemCollection.add(new SelectorItemInfo("resource.number"));
        selectorItemCollection.add(new SelectorItemInfo("resource.name"));
        selectorItemCollection.add(new SelectorItemInfo("parent.id"));
        selectorItemCollection.add(new SelectorItemInfo("parent.number"));
        ev.setSelector(selectorItemCollection);
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        sorterItemCollection.add(new SorterItemInfo("parent.number"));
        sorterItemCollection.add(new SorterItemInfo("parent.id"));
        sorterItemCollection.add(new SorterItemInfo("seq"));
        ev.setSorter(sorterItemCollection);
        ProjectCollaborationPlanScheduleEntryCollection pcpseCollection = ProjectCollaborationPlanScheduleEntryFactory.getRemoteInstance().getProjectCollaborationPlanScheduleEntryCollection(ev);
        if (IndustryUtils.isEmptyObjectCollection((IObjectCollection)pcpseCollection)) {
            return;
        }
        int pcpseCollectionSize = pcpseCollection.size();
        for (int index = 0; index < pcpseCollectionSize; ++index) {
            List rootList;
            ProjectCollaborationPlanInfo pcpInfo;
            String pcpID;
            ProjectCollaborationPlanScheduleEntryInfo pcpseInfo = pcpseCollection.get(index);
            String pcpseID = IndustryUtils.getObjectValueStringData((IObjectValue)pcpseInfo, (String)"id");
            if (IndustryUtils.isEmptyString((String)pcpseID)) continue;
            Timestamp st = pcpseInfo.getStartTime();
            Timestamp et = pcpseInfo.getFinishTime();
            BigDecimal qty = pcpseInfo.getQty();
            ResourceInfo rInfo = pcpseInfo.getResource();
            String rNumber = IndustryUtils.getObjectValueStringData((IObjectValue)rInfo, (String)"number", (String)"");
            String rName = IndustryUtils.getObjectValueStringData((IObjectValue)rInfo, (String)"name", (String)"");
            if (st == null || et == null || IndustryUtils.isEmptyString((String)(pcpID = IndustryUtils.getObjectValueStringData((IObjectValue)(pcpInfo = pcpseInfo.getParent()), (String)"id")))) continue;
            String parentID = pcpID;
            String sID = pcpID + " " + pcpseID;
            if (IndustryUtils.isEmptyString((String)parentID)) continue;
            List childList = IndustryUtils.getMapListData((Map)this.sMap, (Object)parentID, new ArrayList());
            if (!childList.contains(sID)) {
                String pnn = IndustryUtils.getObjectValueStringData((IObjectValue)pcpseInfo, (String)"planNodeNumber", (String)"");
                String pn = IndustryUtils.getObjectValueStringData((IObjectValue)pcpseInfo, (String)"planNode", (String)"");
                String name = "[" + pnn + "]" + pn;
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                dataMap.put("Name", name);
                dataMap.put("StartTime", st);
                dataMap.put("EndTime", et);
                dataMap.put("Qty", qty);
                dataMap.put("Resource", "(" + rNumber + ")" + rName);
                dataMap.put("PCPID", pcpID);
                this.dMap.put(sID, dataMap);
                childList.add(sID);
                this.sMap.put(parentID, childList);
            }
            if ((rootList = IndustryUtils.getMapListData((Map)this.sMap, (Object)"Null", new ArrayList())).contains(pcpID)) {
                Map dataMap = IndustryUtils.getMapMapData((Map)this.dMap, (Object)pcpID);
                if (st != null) {
                    Timestamp pst = IndustryUtils.getMapTimestampData((Map)dataMap, (Object)"StartTime");
                    if (pst == null) {
                        dataMap.put("StartTime", st);
                    } else if (st.compareTo(pst) < 0) {
                        dataMap.put("StartTime", st);
                    }
                }
                if (et != null) {
                    Timestamp pet = IndustryUtils.getMapTimestampData((Map)dataMap, (Object)"EndTime");
                    if (pet == null) {
                        dataMap.put("EndTime", et);
                    } else if (et.compareTo(pet) > 0) {
                        dataMap.put("EndTime", et);
                    }
                }
                this.dMap.put(pcpID, dataMap);
            } else {
                String pcpNumber = IndustryUtils.getObjectValueStringData((IObjectValue)pcpInfo, (String)"number", (String)pcpID);
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                dataMap.put("Name", pcpNumber);
                dataMap.put("StartTime", st);
                dataMap.put("EndTime", et);
                dataMap.put("PCPID", pcpID);
                this.dMap.put(pcpID, dataMap);
                rootList.add(pcpID);
            }
            this.sMap.put("Null", rootList);
        }
        if (IndustryUtils.isEmptyMap((Map)this.sMap) || IndustryUtils.isEmptyMap((Map)this.dMap)) {
            return;
        }
        this.generateGantt("Null");
    }

    protected final void refreshAfterModified(final IUIWindow uiWindow) {
        Window win = SwingUtilities.getWindowAncestor((JComponent)uiWindow.getUIObject());
        WindowAdapter wl = new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent event) {
                try {
                    if (uiWindow.getUIObject() instanceof ProjectCollaborationPlanEditUI && ((ProjectCollaborationPlanEditUI)uiWindow.getUIObject()).isSaved()) {
                        ((ProjectCollaborationPlanEditUI)uiWindow.getUIObject()).setSaved(false);
                        PCPGanttChartUI.this.refresh(null);
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Component)((Object)PCPGanttChartUI.this), (Throwable)e);
                }
            }
        };
        win.addWindowListener(wl);
    }

    protected void view(ActionEvent e) throws Exception {
        Map dataMap;
        DefaultMutableTreeNode tn = this.getTree().getSelectedNode();
        if (tn == null) {
            return;
        }
        Object gtObject = tn.getUserObject();
        GanttTask gt = gtObject == null ? null : (gtObject instanceof GanttTask ? (GanttTask)gtObject : null);
        Object dataMapObject = gt.getUserObject();
        Map map = dataMapObject == null ? null : (dataMap = dataMapObject instanceof Map ? (Map)dataMapObject : null);
        if (IndustryUtils.isEmptyMap(dataMap)) {
            return;
        }
        String pcpID = IndustryUtils.getMapStringData((Map)dataMap, (Object)"PCPID");
        if (IndustryUtils.isEmptyString((String)pcpID)) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)pcpID);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(ProjectCollaborationPlanEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.refreshAfterModified(uiWindow);
    }
}

