/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcp.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.industry.emm.mm.basedata.OperationScheduleUtils;
import com.kingdee.eas.industry.emm.pcp.client.AbstractResourceLoadAnalysisUI;
import com.kingdee.eas.industry.emm.pcp.client.ResourceLoadAnalysisQueryUI;
import com.kingdee.eas.industry.emm.pm.SqlExecuteFacadeFactory;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.scm.common.client.ISCMFilter;
import com.kingdee.eas.scm.common.client.SCMCommonProcessor;
import com.kingdee.eas.scm.common.client.SCMPromptBoxFactory;
import com.kingdee.eas.util.IndustryUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ResourceLoadAnalysisUI
extends AbstractResourceLoadAnalysisUI {
    public static final String COL_KDTDETAIL_CAPABILITY = "capability";
    public static final String COL_KDTDETAIL_DATE = "date";
    public static final String COL_KDTDETAIL_ID = "id";
    public static final String COL_KDTDETAIL_MATERIAL = "material";
    public static final String COL_KDTDETAIL_MATERIALID = "material.id";
    public static final String COL_KDTDETAIL_OPERATION = "operation";
    public static final String COL_KDTDETAIL_OPERATIONID = "operation.id";
    public static final String COL_KDTDETAIL_PROJECT = "project";
    public static final String COL_KDTDETAIL_PROJECTID = "project.id";
    public static final String COL_KDTDETAIL_QTY = "qty";
    public static final String COL_KDTDETAIL_SEQ = "seq";
    public static final String COL_KDTDETAIL_TASK = "task";
    public static final String COL_KDTDETAIL_TRACKNUMBER = "trackNumber";
    public static final String COL_KDTDETAIL_TRACKNUMBERID = "trackNumber.id";
    public static final String COL_KDTMAIN_RESOURCE = "resource";
    public static final String COL_KDTMAIN_RESOURCEID = "resource.id";
    public static final String COL_KDTMAIN_STORAGEORGUNIT = "storageOrgUnit";
    public static final String COL_KDTMAIN_STORAGEORGUNITID = "storageOrgUnit.id";
    private static final long serialVersionUID = 4686074007442389046L;
    final CustomerQueryPanel cqp = new ResourceLoadAnalysisQueryUI();
    final CommonQueryDialog dialog = new CommonQueryDialog();
    final Map filterMap = new HashMap();
    final Locale locale = SysContext.getSysContext().getLocale();
    final MetaDataPK mainQueryPK = MetaDataPK.create((String)"com.kingdee.eas.framework.report.app", (String)"CommRptEmptyQuery");
    final List periodColList = new ArrayList();
    private String RESURL = "com.kingdee.eas.industry.emm.pcp.PCPResource";

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        FilterInfo fi;
        if (e == null) {
            this.dialog.setOwner((Component)(this.getUIWindow() == null ? (Component)this.getUIContext().get("OwnerWindow") : this));
            this.dialog.setUiObject((IUIObject)this);
            this.dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.dialog.setQueryObjectPK((IMetaDataPK)this.mainQueryPK);
            this.dialog.setTitle(this.getUITitle() + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
            if (this.orgContextManager != null) {
                if (this.orgContextManager.getOwner() != null && this.orgContextManager.getOwner() instanceof CustomerQueryPanel) {
                    this.dialog.addUserPanel((KDPanel)((CustomerQueryPanel)this.orgContextManager.getOwner()));
                }
                this.orgContextManager.init(this.getUIContext());
            }
            this.dialog.setMaxReturnCountVisible(true);
            this.dialog.setWidth(450);
            this.dialog.setHeight(320);
            SCMPromptBoxFactory scmF7Factory = new SCMPromptBoxFactory(this.cqp, this.getMainBizOrgType());
            this.dialog.setPromptBoxFactory((IPromptBoxFactory)scmF7Factory);
            this.dialog.setProcessor((IProcessor)new SCMCommonProcessor());
            this.dialog.setShowSorter(false);
            this.dialog.setShowFilter(false);
            ISCMFilter iFilter = (ISCMFilter)this.cqp;
            if (this.getBOTPViewStatus() == 1) {
                iFilter.setBOTPFilter((Map)((HashMap)this.getUIContext().get("BTPEDITPARAMETER")));
            }
            iFilter.setIsSupportMultiOrgs(false);
            iFilter.setContextObject(null);
            iFilter.setAuthorizedMainOrgs(null);
            this.dialog.addUserPanel((KDPanel)this.cqp);
        }
        if (this.dialog.show() && (fi = this.cqp.getFilterInfo()) != null) {
            this.filterMap.put("FilterInfo", fi);
            if (e != null) {
                this.refreshMainTable();
            }
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refreshMainTable();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionQuery_actionPerformed(null);
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.addListener();
    }

    public void onShow() throws Exception {
        super.onShow();
        if (IndustryUtils.isEmptyMap((Map)this.filterMap)) {
            this.getUIWindow().close();
            return;
        }
        this.initialKDTTable();
        this.refreshMainTable();
        int height = this.spMain.getHeight();
        BigDecimal heightDecimal = new BigDecimal(height);
        this.spMain.setDividerLocation(heightDecimal.divide(new BigDecimal(2)).intValue());
    }

    protected void addListener() throws Exception {
        this.kdtMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    ResourceLoadAnalysisUI.this.kdtMain_selectChanged(e);
                }
                catch (Exception exc) {
                    ResourceLoadAnalysisUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void initialKDTTable() throws Exception {
        IndustryUtils.removeKDTableActionMap((KDTable)this.kdtMain, (String[])new String[]{"AddRow", "RemoveRow", "Delete", "Paste"});
        this.kdtMain.getSelectManager().setSelectMode(1);
        this.kdtDetail.getSelectManager().setSelectMode(2);
        KDTSortManager kdtMainSortManager = new KDTSortManager(this.kdtMain);
        kdtMainSortManager.setSortAuto(true);
        kdtMainSortManager.setClickCount(1);
        KDTSortManager kdtDetailSortManager = new KDTSortManager(this.kdtDetail);
        kdtDetailSortManager.setSortAuto(true);
        kdtDetailSortManager.setClickCount(1);
        IndustryUtils.setKDTableColumnSortable((KDTable)this.kdtMain, (String[])new String[]{COL_KDTMAIN_STORAGEORGUNITID, COL_KDTMAIN_STORAGEORGUNIT, COL_KDTMAIN_RESOURCEID, COL_KDTMAIN_RESOURCE});
        IndustryUtils.setKDTableColumnSortable((KDTable)this.kdtDetail, (String[])new String[]{COL_KDTDETAIL_ID, COL_KDTDETAIL_SEQ, COL_KDTDETAIL_PROJECTID, COL_KDTDETAIL_PROJECT, COL_KDTDETAIL_TRACKNUMBERID, COL_KDTDETAIL_TRACKNUMBER, COL_KDTDETAIL_TASK, COL_KDTDETAIL_MATERIALID, COL_KDTDETAIL_MATERIAL, COL_KDTDETAIL_OPERATIONID, COL_KDTDETAIL_OPERATION, COL_KDTDETAIL_QTY, COL_KDTDETAIL_DATE, COL_KDTDETAIL_CAPABILITY});
    }

    protected void kdtMain_selectChanged(KDTSelectEvent e) throws Exception {
        String resourceID;
        String storageOrgUnitID;
        int selectRow;
        Map selectColumnDataMap;
        Object selectColumnDataObject;
        if (e == null) {
            return;
        }
        KDTSelectBlock sb = e.getSelectBlock();
        if (sb == null) {
            return;
        }
        int selectColumnIndex = sb.getLeft();
        IColumn selectColumn = selectColumnIndex >= 0 ? this.kdtMain.getColumn(selectColumnIndex) : null;
        Object object = selectColumnDataObject = selectColumn == null ? null : selectColumn.getUserObject();
        Map map = selectColumnDataObject == null ? null : (selectColumnDataMap = selectColumnDataObject instanceof Map ? (Map)selectColumnDataObject : null);
        if (IndustryUtils.isEmptyMap(selectColumnDataMap)) {
            return;
        }
        this.filterMap.put("StartDate", IndustryUtils.getMapStringData((Map)selectColumnDataMap, (Object)"StartDate"));
        this.filterMap.put("EndDate", IndustryUtils.getMapStringData((Map)selectColumnDataMap, (Object)"EndDate"));
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdtMain);
        int n = selectRows == null ? -1 : (selectRow = selectRows.length == 0 ? -1 : selectRows[0]);
        if (selectRow < 0) {
            return;
        }
        ICell storageOrgUnitIDCell = this.kdtMain.getCell(selectRow, COL_KDTMAIN_STORAGEORGUNITID);
        ICell resourceIDCell = this.kdtMain.getCell(selectRow, COL_KDTMAIN_RESOURCEID);
        String string = storageOrgUnitIDCell == null ? null : (storageOrgUnitID = storageOrgUnitIDCell.getValue() == null ? null : storageOrgUnitIDCell.getValue().toString());
        String string2 = resourceIDCell == null ? null : (resourceID = resourceIDCell.getValue() == null ? null : resourceIDCell.getValue().toString());
        if (IndustryUtils.isEmptyString((String)storageOrgUnitID) || IndustryUtils.isEmptyString((String)resourceID)) {
            return;
        }
        this.filterMap.put("StorageOrgUnitID", storageOrgUnitID);
        this.filterMap.put("ResourceID", resourceID);
        this.refreshDetailTable();
    }

    protected void refreshDetailTable() throws Exception {
        Locale locale;
        SysContext sysContext = SysContext.getSysContext();
        Locale locale2 = locale = sysContext == null ? null : sysContext.getLocale();
        if (locale == null) {
            return;
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdtDetail);
        ArrayList<String> selectIDList = new ArrayList<String>();
        for (int selectRow : selectRows) {
            String selectID;
            Object selectIDObject = this.kdtDetail.getCell(selectRow, COL_KDTDETAIL_ID).getValue();
            String string = selectID = selectIDObject == null ? null : selectIDObject.toString();
            if (IndustryUtils.isEmptyString((String)selectID) || selectIDList.contains(selectID)) continue;
            selectIDList.add(selectID);
        }
        this.kdtDetail.removeRows();
        this.kdtDetail.getSelectManager().removeAll();
        String souID = IndustryUtils.getMapStringData((Map)this.filterMap, (Object)"StorageOrgUnitID");
        String rID = IndustryUtils.getMapStringData((Map)this.filterMap, (Object)"ResourceID");
        String startDate = IndustryUtils.getMapStringData((Map)this.filterMap, (Object)"StartDate");
        String endDate = IndustryUtils.getMapStringData((Map)this.filterMap, (Object)"EndDate");
        String pNumberFrom = IndustryUtils.getMapStringData((Map)this.filterMap, (Object)"FProjectFrom");
        String pNumberTo = IndustryUtils.getMapStringData((Map)this.filterMap, (Object)"FProjectTo");
        if (IndustryUtils.isEmptyString((String)souID) || IndustryUtils.isEmptyString((String)rID) || IndustryUtils.isEmptyString((String)startDate) || IndustryUtils.isEmptyString((String)endDate)) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        sql.append("Select\r\n");
        sql.append("PCPSE.FID FID\r\n");
        sql.append(",PCPSE.FSeq FSeq\r\n");
        sql.append(",P.FID FProjectID\r\n");
        sql.append(",'['||P.FNumber||']'||P.FName_").append(this.locale.toString()).append(" FProject\r\n");
        sql.append(",TN.FID FTrackNumberID\r\n");
        sql.append(",'['||TN.FNumber||']'||TN.FName_").append(this.locale.toString()).append(" FTrackNumber\r\n");
        sql.append(",Null FTask\r\n");
        sql.append(",M.FID FMaterialID\r\n");
        sql.append(",Case When M.FID Is Null Then Null Else '['||M.FNumber||']'||M.FName_").append(this.locale.toString()).append(" End FMaterial\r\n");
        sql.append(",O.FID FOperationID\r\n");
        sql.append(",Case When O.FID Is Null Then Null Else '['||O.FNumber||']'||O.FName_").append(this.locale.toString()).append(" End FOperation\r\n");
        sql.append(",PCPSE.FQty FQty\r\n");
        sql.append(",RPOE.FDate FDate\r\n");
        sql.append(",RPOE.FUseS_").append(locale.toString()).append(" FUse\r\n");
        sql.append(",PCPSE.FParentID FParentID\r\n");
        sql.append("From T_PCP_ProjectCPSE PCPSE\r\n");
        sql.append("Inner Join T_PCP_ProjectCP PCP On PCP.FID=PCPSE.FParentID\r\n");
        sql.append("Inner Join T_MM_Project P On P.FID=PCPSE.FProjectID\r\n");
        sql.append("Inner Join T_MM_TrackNumber TN On TN.FID=PCPSE.FTrackNumberID\r\n");
        sql.append("Left Join T_MM_Operation O On O.FID=PCPSE.FOperationID\r\n");
        sql.append("Left Join T_BD_Material M On M.FID=PCPSE.FMaterialID\r\n");
        sql.append("Left Join T_PCP_ResourcePool RP On RP.FResourceID=PCPSE.FResourceID\r\n");
        sql.append("Left Join T_PCP_ResourcePoolOrderEntry RPOE On\r\n");
        sql.append("1=1\r\n");
        sql.append("And RPOE.FParentID=RP.FID\r\n");
        sql.append("And RPOE.FOrderID=PCPSE.FID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And PCPSE.FStorageOrgUnitID='").append(souID).append("'\r\n");
        sql.append("And PCPSE.FResourceID='").append(rID).append("'\r\n");
        sql.append("And To_Char(RPOE.FDate,'YYYY-MM-DD')>='").append(startDate).append("'\r\n");
        sql.append("And To_Char(RPOE.FDate,'YYYY-MM-DD')<'").append(endDate).append("'\r\n");
        if (!IndustryUtils.isEmptyString((String)pNumberFrom)) {
            sql.append("And P.FNumber>='").append(pNumberFrom).append("'\r\n");
        }
        if (!IndustryUtils.isEmptyString((String)pNumberTo)) {
            sql.append("And P.FNumber<='").append(pNumberTo).append("'\r\n");
        }
        sql.append("Order By\r\n");
        sql.append("RPOE.FDate\r\n");
        sql.append(",PCPSE.FParentID\r\n");
        sql.append(",PCPSE.FSeq\r\n");
        sql.append(",PCPSE.FID\r\n");
        IRowSet rs = SqlExecuteFacadeFactory.getRemoteInstance().executeQuery(sql.toString());
        if (IndustryUtils.isEmptyRowSet((IRowSet)rs)) {
            return;
        }
        while (rs.next()) {
            IRow row = this.kdtDetail.addRow();
            String id = rs.getString("FID");
            if (IndustryUtils.isEmptyString((String)id)) continue;
            ICell idCell = row.getCell(COL_KDTDETAIL_ID);
            if (idCell != null) {
                idCell.setValue((Object)id);
            }
            row.getCell(COL_KDTDETAIL_SEQ).setValue((Object)rs.getInt("FSeq"));
            row.getCell(COL_KDTDETAIL_PROJECTID).setValue((Object)rs.getString("FProjectID"));
            row.getCell(COL_KDTDETAIL_PROJECT).setValue((Object)rs.getString("FProject"));
            row.getCell(COL_KDTDETAIL_TRACKNUMBERID).setValue((Object)rs.getString("FTrackNumberID"));
            row.getCell(COL_KDTDETAIL_TRACKNUMBER).setValue((Object)rs.getString("FTrackNumber"));
            row.getCell(COL_KDTDETAIL_TASK).setValue((Object)rs.getString("FTask"));
            row.getCell(COL_KDTDETAIL_OPERATIONID).setValue((Object)rs.getString("FOperationID"));
            row.getCell(COL_KDTDETAIL_OPERATION).setValue((Object)rs.getString("FOperation"));
            row.getCell(COL_KDTDETAIL_MATERIALID).setValue((Object)rs.getString("FMaterialID"));
            row.getCell(COL_KDTDETAIL_MATERIAL).setValue((Object)rs.getString("FMaterial"));
            row.getCell(COL_KDTDETAIL_QTY).setValue((Object)rs.getString("FQty"));
            row.getCell(COL_KDTDETAIL_DATE).setValue((Object)rs.getString("FDate"));
            row.getCell(COL_KDTDETAIL_CAPABILITY).setValue((Object)rs.getString("FUse"));
            if (!selectIDList.contains(id)) continue;
            this.kdtDetail.getSelectManager().add(row.getRowIndex(), 0, row.getRowIndex(), this.kdtDetail.getColumnCount() - 1, 2);
            this.kdtDetail.scrollToVisible(row.getRowIndex(), this.kdtDetail.getColumn(COL_KDTDETAIL_PROJECT).getColumnIndex());
        }
        this.kdtDetail.getSelectManager().setSelectMode(10);
    }

    protected void refreshMainTable() throws Exception {
        IRowSet rs;
        String storageOrgUnitNumber;
        Object storageOrgUnitNumberObject;
        FilterItemCollection fiCollection;
        IRow selectRow = KDTableUtil.getSelectedRow((KDTable)this.kdtMain);
        KDTSelectBlock sb = this.kdtMain.getSelectManager().get();
        int selectColumnIndex = sb == null ? -1 : sb.getTop();
        IColumn selectColumn = selectColumnIndex >= 0 ? this.kdtMain.getColumn(selectColumnIndex) : null;
        String selectColumnKey = selectColumn == null ? null : selectColumn.getKey();
        Object selectSOUIDObject = selectRow == null ? null : selectRow.getCell(COL_KDTMAIN_STORAGEORGUNITID).getValue();
        String selectSOUID = selectSOUIDObject == null ? "" : selectSOUIDObject.toString();
        Object selectRIDObject = selectRow == null ? null : selectRow.getCell(COL_KDTMAIN_RESOURCEID).getValue();
        String selectRID = selectRIDObject == null ? "" : selectRIDObject.toString();
        String selectKey = selectSOUID + " " + selectRID;
        this.kdtMain.removeRows();
        this.kdtMain.getSelectManager().removeAll();
        this.kdtDetail.removeRows();
        this.kdtDetail.getSelectManager().removeAll();
        if (!IndustryUtils.isEmptyList((List)this.periodColList)) {
            int periodColListSize = this.periodColList.size();
            for (int index = 0; index < periodColListSize; ++index) {
                String colKey;
                String string = colKey = this.periodColList.get(index) == null ? null : this.periodColList.get(index).toString();
                if (IndustryUtils.isEmptyString(colKey)) continue;
                this.kdtMain.removeColumn(this.kdtMain.getColumnIndex(colKey));
            }
        }
        this.periodColList.clear();
        Object fiObject = IndustryUtils.getMapData((Map)this.filterMap, (Object)"FilterInfo");
        FilterInfo fi = fiObject == null ? null : (fiObject instanceof FilterInfo ? (FilterInfo)fiObject : null);
        FilterItemCollection filterItemCollection = fiCollection = fi == null ? null : fi.getFilterItems();
        if (!IndustryUtils.isEmptyObjectCollection((IObjectCollection)fiCollection)) {
            int fiCollectionSize = fiCollection.size();
            for (int index = 0; index < fiCollectionSize; ++index) {
                FilterItemInfo fiInfo = fiCollection.get(index);
                if (fiInfo == null) continue;
                String fiKey = fiInfo.getPropertyName();
                Object fiValue = fiInfo.getCompareValue();
                if (IndustryUtils.isEmptyString((String)fiKey)) continue;
                this.filterMap.put(fiKey, fiValue);
            }
        }
        String string = (storageOrgUnitNumberObject = IndustryUtils.getMapData((Map)this.filterMap, (Object)"FStorageOrgUnitNumber")) == null ? null : (storageOrgUnitNumber = storageOrgUnitNumberObject instanceof String ? storageOrgUnitNumberObject.toString() : null);
        Set storageOrgUnitNumberSet = storageOrgUnitNumberObject == null ? null : (storageOrgUnitNumberObject instanceof Set ? (Set)storageOrgUnitNumberObject : null);
        String startDateString = IndustryUtils.getMapStringData((Map)this.filterMap, (Object)"FStartDate");
        Date startDate = IndustryUtils.isEmptyString((String)startDateString) ? null : OperationScheduleUtils.sdfDateTime.parse(startDateString);
        String endDateString = IndustryUtils.getMapStringData((Map)this.filterMap, (Object)"FEndDate");
        Date endDate = IndustryUtils.isEmptyString((String)endDateString) ? null : OperationScheduleUtils.sdfDateTime.parse(endDateString);
        String projectNumberFrom = IndustryUtils.getMapStringData((Map)this.filterMap, (Object)"FProjectFrom");
        String projectNumberTo = IndustryUtils.getMapStringData((Map)this.filterMap, (Object)"FProjectTo");
        String showDayString = IndustryUtils.getMapStringData((Map)this.filterMap, (Object)"FShowDay");
        boolean showDay = IndustryUtils.isEmptyString((String)showDayString) ? false : Boolean.parseBoolean(showDayString);
        String showWeekString = IndustryUtils.getMapStringData((Map)this.filterMap, (Object)"FShowWeek");
        boolean showWeek = IndustryUtils.isEmptyString((String)showWeekString) ? false : Boolean.parseBoolean(showWeekString);
        String showMonthString = IndustryUtils.getMapStringData((Map)this.filterMap, (Object)"FShowMonth");
        boolean showMonth = IndustryUtils.isEmptyString((String)showMonthString) ? false : Boolean.parseBoolean(showMonthString);
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        if (startDate != null && endDate != null && (showDay || showWeek || showMonth)) {
            ShareStyleAttributes ssa = Styles.getEmptySSA();
            Style s = Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, this.kdtMain.getHeadSSA()});
            cal.setTime(endDate);
            int endDateWeek = cal.get(3);
            cal.setTime(startDate);
            while (true) {
                String calDateString = OperationScheduleUtils.sdfDate.format(cal.getTime());
                int calDateWeek = cal.get(3);
                if (showDay ? calDateString.compareTo(endDateString) > 0 : (showWeek ? cal.getTime().compareTo(endDate) > 0 && calDateWeek > endDateWeek : showMonth && cal.getTime().compareTo(endDate) > 0 && calDateString.substring(0, 7).compareTo(endDateString.substring(0, 7)) > 0)) break;
                KDTCell hCell = new KDTCell();
                hCell.setSSA(ssa);
                hCell.setStyle(s);
                IColumn col = this.kdtMain.addColumn();
                HashMap<String, String> colMap = new HashMap<String, String>();
                colMap.put("StartDate", calDateString);
                int colIndex = col.getColumnIndex();
                col.getStyleAttributes().setLocked(true);
                col.getStyleAttributes().setNumberFormat("0.00%");
                if (showDay) {
                    col.setKey("d" + calDateString);
                    hCell.setValue((Object)(calDateString.substring(0, 4) + EASResource.getString((String)"com.kingdee.eas.cp.bc.BizCollResource", (String)"year") + calDateString.substring(5, 7) + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSClientResource", (String)"Month") + calDateString.substring(8, 10) + EASResource.getString((String)"com.kingdee.eas.cp.mc.ManageCommunicateResource", (String)"day")));
                    cal.add(6, 1);
                } else if (showWeek) {
                    col.setKey("w" + calDateString.substring(0, 4) + "-" + calDateWeek);
                    hCell.setValue((Object)(calDateString.substring(0, 4) + EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowIndirectUI", (String)"Year") + calDateWeek + EASResource.getString((String)"com.kingdee.eas.mm.project.WBSResource", (String)"PROJECT_PEROID_POST_WEEK")));
                    cal.add(3, 1);
                    cal.set(7, 2);
                } else if (showMonth) {
                    col.setKey("m" + calDateString.substring(0, 7));
                    hCell.setValue((Object)(calDateString.substring(0, 4) + EASResource.getString((String)"com.kingdee.eas.cp.bc.BizCollResource", (String)"year") + calDateString.substring(5, 7) + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSClientResource", (String)"Month")));
                    cal.add(2, 1);
                    cal.set(5, 1);
                }
                colMap.put("EndDate", OperationScheduleUtils.sdfDate.format(cal.getTime()));
                this.kdtMain.getHead().addColumn(colIndex, hCell);
                col.setUserObject(colMap);
                this.periodColList.add(col.getKey());
            }
            IndustryUtils.setKDTableColumnSortable((KDTable)this.kdtMain, (String[])this.periodColList.toArray(new String[0]));
        }
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        sql.append("Select\r\n");
        sql.append("PCPSE.FStorageOrgUnitID FStorageOrgUnitID\r\n");
        sql.append(",'['||SOU.FNumber||']'||SOU.FName_").append(this.locale.toString()).append(" FStorageOrgUnit\r\n");
        sql.append(",PCPSE.FResourceID FResourceID\r\n");
        sql.append(",'['||R.FNumber||']'||R.FName_").append(this.locale.toString()).append(" FResource\r\n");
        sql.append(",RPOE.FUse FUse\r\n");
        sql.append(",RPOE.FDate FTime\r\n");
        sql.append(",RPDE.FTotal FTotal\r\n");
        sql.append("From T_PCP_ProjectCP PCP\r\n");
        sql.append("Inner Join T_PCP_ProjectCPSE PCPSE On PCPSE.FParentID=PCP.FID\r\n");
        sql.append("Inner Join T_MM_Project P On P.FID=PCPSE.FProjectID\r\n");
        sql.append("Inner Join T_Org_Storage SOU On SOU.FID=PCPSE.FStorageOrgUnitID\r\n");
        sql.append("Inner Join T_MM_Resource R On R.FID=PCPSE.FResourceID\r\n");
        sql.append("Left Join T_PCP_ResourcePool RP On RP.FResourceID=PCPSE.FResourceID\r\n");
        sql.append("Left Join T_PCP_ResourcePoolOrderEntry RPOE On\r\n");
        sql.append("1=1\r\n");
        sql.append("And RPOE.FParentID=RP.FID\r\n");
        sql.append("And RPOE.FOrderID=PCPSE.FID\r\n");
        sql.append("Left Join T_PCP_ResourcePoolDateEntry RPDE On\r\n");
        sql.append("1=1\r\n");
        sql.append("And RPDE.FParentID=RP.FID\r\n");
        sql.append("And To_Char(RPDE.FDate,'YYYY-MM-DD')=To_Char(RPOE.FDate,'YYYY-MM-DD')\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        if (!IndustryUtils.isEmptyString((String)storageOrgUnitNumber)) {
            sql.append("And SOU.FNumber='").append(storageOrgUnitNumber).append("'\r\n");
        }
        if (!IndustryUtils.isEmptySet((Set)storageOrgUnitNumberSet)) {
            sql.append("And SOU.FNumber In (\r\n");
            sql.append(SQLUtil.arrayToString((Object[])storageOrgUnitNumberSet.toArray())).append("\r\n");
            sql.append(")\r\n");
        }
        if (!IndustryUtils.isEmptyString((String)projectNumberFrom)) {
            sql.append("And P.FNumber>='").append(projectNumberFrom).append("'\r\n");
        }
        if (!IndustryUtils.isEmptyString((String)projectNumberTo)) {
            sql.append("And P.FNumber<='").append(projectNumberTo).append("'\r\n");
        }
        if (IndustryUtils.isEmptyRowSet((IRowSet)(rs = SqlExecuteFacadeFactory.getRemoteInstance().executeQuery(sql.toString())))) {
            return;
        }
        HashMap<String, IRow> rowMap = new HashMap<String, IRow>();
        while (rs.next()) {
            IColumn reselectColumn;
            Timestamp time;
            String souID = rs.getString("FStorageOrgUnitID");
            String rID = rs.getString("FResourceID");
            if (IndustryUtils.isEmptyString((String)souID) || IndustryUtils.isEmptyString((String)rID)) continue;
            String key = souID + " " + rID;
            Object rowObject = IndustryUtils.getMapData(rowMap, (Object)key);
            IRow row = rowObject == null ? this.kdtMain.addRow() : (rowObject instanceof IRow ? (IRow)rowObject : this.kdtMain.addRow());
            BigDecimal use = rs.getBigDecimal("FUse");
            BigDecimal total = rs.getBigDecimal("FTotal");
            if (rowObject == null) {
                row.getCell(COL_KDTMAIN_STORAGEORGUNITID).setValue((Object)souID);
                row.getCell(COL_KDTMAIN_STORAGEORGUNIT).setValue((Object)rs.getString("FStorageOrgUnit"));
                row.getCell(COL_KDTMAIN_RESOURCEID).setValue((Object)rID);
                row.getCell(COL_KDTMAIN_RESOURCE).setValue((Object)rs.getString("FResource"));
                rowMap.put(key, row);
            }
            if ((time = rs.getTimestamp("FTime")) != null) {
                String[] timeCols;
                cal.setTime(time);
                String timeDayString = OperationScheduleUtils.sdfDate.format(cal.getTime());
                String timeWeekString = timeDayString.substring(0, 4) + "-" + cal.get(3);
                String timeMonthString = timeDayString.substring(0, 7);
                String timeDayCol = "d" + timeDayString;
                String timeWeekCol = "w" + timeWeekString;
                String timeMonthCol = "m" + timeMonthString;
                for (String timeCol : timeCols = new String[]{timeDayCol, timeWeekCol, timeMonthCol}) {
                    BigDecimal newTotal;
                    ICell periodCell;
                    if (!this.periodColList.contains(timeCol) || (periodCell = row.getCell(timeCol)) == null) continue;
                    Object periodCellDataObject = periodCell.getUserObject();
                    Map<String, Object> periodCellDataMap = periodCellDataObject == null ? new HashMap<String, Object>() : (periodCellDataObject instanceof Map ? (Map)periodCellDataObject : new HashMap());
                    List periodDayList = IndustryUtils.getMapListData(periodCellDataMap, (Object)"DayList", new ArrayList());
                    boolean isContainThisDay = periodDayList.contains(timeDayString);
                    if (!isContainThisDay) {
                        periodDayList.add(timeDayString);
                        periodCellDataMap.put("DayList", periodDayList);
                    }
                    BigDecimal periodUse = IndustryUtils.getMapBigDecimalData(periodCellDataMap, (Object)"Use", (BigDecimal)BigDecimal.ZERO);
                    BigDecimal periodTotal = IndustryUtils.getMapBigDecimalData(periodCellDataMap, (Object)"Total", (BigDecimal)BigDecimal.ZERO);
                    BigDecimal newUse = periodUse.add(use);
                    BigDecimal bigDecimal = newTotal = isContainThisDay ? periodTotal : periodTotal.add(total);
                    BigDecimal loadRate = IndustryUtils.isZeroBigDecimal((BigDecimal)newUse) ? BigDecimal.ZERO : (IndustryUtils.isZeroBigDecimal((BigDecimal)newTotal) ? BigDecimal.ZERO : newUse.divide(newTotal, 2, 0));
                    periodCell.setValue((Object)loadRate);
                    periodCellDataMap.put("Use", newUse);
                    periodCellDataMap.put("Total", newTotal);
                    periodCell.setUserObject(periodCellDataMap);
                }
            }
            if (!selectKey.equals(key) || IndustryUtils.isEmptyString((String)selectColumnKey) || (reselectColumn = this.kdtMain.getColumn(selectColumnKey)) == null) continue;
            int reselectColumnIndex = reselectColumn.getColumnIndex();
            this.kdtMain.getSelectManager().add(row.getRowIndex(), reselectColumnIndex, row.getRowIndex(), reselectColumnIndex, 1);
            this.kdtMain.scrollToVisible(row.getRowIndex(), reselectColumnIndex);
        }
        this.kdtMain.getSelectManager().setSelectMode(1);
    }
}

