/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.analysis.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.attachment.util.UICreator;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.eqm.analysis.EqmLocCostAnalysisFacadeFactory;
import com.kingdee.eas.eqm.analysis.IEqmLocCostAnalysisFacade;
import com.kingdee.eas.eqm.analysis.TempEquipmentInfo;
import com.kingdee.eas.eqm.analysis.client.AbstractEqmLocCostAnalysisListUI;
import com.kingdee.eas.eqm.analysis.client.EqmLocCostAnalysisFilterUI;
import com.kingdee.eas.eqm.analysis.client.EqmLocCostAnalysisTreeUI;
import com.kingdee.eas.eqm.archives.EquipmentArchivesFactory;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.archives.IEquipmentArchives;
import com.kingdee.eas.eqm.basedata.EquipmentCategoryFactory;
import com.kingdee.eas.eqm.basedata.EquipmentCategoryInfo;
import com.kingdee.eas.eqm.basedata.EquipmentLocationFactory;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.basedata.EquipmentTypeFactory;
import com.kingdee.eas.eqm.basedata.EquipmentTypeInfo;
import com.kingdee.eas.eqm.basedata.IEquipmentCategory;
import com.kingdee.eas.eqm.basedata.IEquipmentLocation;
import com.kingdee.eas.eqm.basedata.IEquipmentType;
import com.kingdee.eas.eqm.common.core.print.GenePrintActionListener;
import com.kingdee.eas.eqm.common.core.util.GeneDateUtils;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Stack;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class EqmLocCostAnalysisListUI
extends AbstractEqmLocCostAnalysisListUI {
    private CommonQueryDialog queryDialog;
    private EqmLocCostAnalysisFilterUI filterUI = null;
    protected IMetaDataPK mainQueryPK;
    public static final String COL_ARCHIVESNUM = "equipmentNum";
    public static final String COL_ARCHIVESNAME = "equipmentName";
    public static final String COL_LOCATION = "locationNum";
    public static final String COL_LOCATIONNAME = "locationName";
    public static final String COL_MATERIELPLANCOST = "materielPlanCost";
    public static final String COL_MATERIELFACTCOST = "materielFactCost";
    public static final String COL_EMPLOYEEFACTCOST = "employeeFactCost";
    public static final String COL_EMPLOYEEPLANCOST = "employeePlanCost";
    public static final String COL_TOOLSPLANCOST = "toolsPlanCost";
    public static final String COL_TOOLSFACTCOST = "toolsFactCost";
    public static final String COL_SERVICEPLANCOST = "servicePlanCost";
    public static final String COL_SERVICEFACTCOST = "serviceFactCost";
    public static final String COL_LEVEL = "level";
    public static final String COL_EQMARCHIVESLONGNUMBER = "eqmArchivesLongNumber";
    public static final String COL_EQLLOCATIONLONGNUMBER = "eqmLocationLongNumber";
    public static final String COL_NEXTMATERIELPLANCOST = "nextMaterielPlanCost";
    public static final String COL_NEXTMATERIELFACTCOST = "nextMaterielFactCost";
    public static final String COL_NEXTEMPLOYEEPLANCOST = "nextEmployeePlanCost";
    public static final String COL_NEXTEMPLOYEEFACTCOST = "nextEmployeeFactCost";
    public static final String COL_NEXTTOOLSPLANCOST = "nextToolsPlanCost";
    public static final String COL_NEXTTOOLSFACTCOST = "nextToolsFactCost";
    public static final String COL_NEXTSERVICEPLANCOST = "nextServicePlanCost";
    public static final String COL_NEXTSERVICEFACTCOST = "nextServiceFactCost";
    public static final String COL_EQMARCHIVESID = "equipmentArchivesID";
    public static final String COL_EQMLOCATIONID = "eqmLocationID";
    private static final String COSTANALYSIS_RESOURCE_PATH = "com.kingdee.eas.eqm.analysis.AnalysisResource";
    private EntityViewInfo viewInfo = null;
    private FilterInfo customerFilterInfo = null;
    private static final Logger logger = CoreUIObject.getLogger(EqmLocCostAnalysisListUI.class);
    QuerySolutionInfo querySolution = null;
    Object storageOrgUnitInfo = null;
    Object maintainOrgUnits = null;
    Object adminOrgUnitInfo = null;
    Date planStartTimeFrom = null;
    Date planStartTimeTo = null;
    Date realStartTimeFrom = null;
    Date realStartTimeTo = null;
    ArrayList billStatus = new ArrayList();
    ArrayList abcFlag = new ArrayList();
    ArrayList bizStatus = new ArrayList();
    EquipmentLocationInfo equipmentLocationInfo = null;
    EquipmentCategoryInfo equipmentCategoryInfo = null;
    EquipmentTypeInfo equipmentTypeInfo = null;
    EquipmentArchivesInfo equipmentArchivesInfo = null;
    FilterInfo filter = new FilterInfo();
    String planOrgunitid = "";
    private GenePrintActionListener printActionListener = null;

    public EqmLocCostAnalysisListUI() throws Exception {
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.base.message", "MsgQuery");
        this.customerFilterInfo = new FilterInfo();
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnEqmLocCostAnalysis.setEnabled(true);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.addKDTDataRequestListener(new KDTDataRequestListener(){

            public void tableDataRequest(KDTDataRequestEvent e) {
                try {
                    EqmLocCostAnalysisListUI.this.tblMain_tableDataRequest(e);
                }
                catch (Exception exc) {
                    EqmLocCostAnalysisListUI.this.handUIException(exc);
                }
            }
        });
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String cureQueryName = "com.kingdee.eas.base.message.MsgQuery";
        this.querySolution = iQuery.getDefaultSolution(EqmLocCostAnalysisListUI.class.getName(), cureQueryName);
        if (this.querySolution == null) {
            this.showQueryDialog();
        } else {
            EntityViewInfo entityViewInfo = null;
            entityViewInfo = this.querySolution != null && !this.querySolution.getName().equals(EASResource.getString((String)"com.kingdee.eas.eqm.analysis.ANALYSISAutoGenerateResource", (String)"5_EqmLocCostAnalysisListUI")) ? (this.querySolution.getName().equals("Missing Resource") ? this.getInitDefaultSolution() : Util.getInnerFilterInfo((QuerySolutionInfo)this.querySolution)) : this.getInitDefaultSolution();
            FilterInfo filterInfo = entityViewInfo.getFilter();
            for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                Object biz;
                String time;
                IFullOrgUnit iFullOrgUnit;
                FullOrgUnitInfo fullOrgUnitInfo;
                StorageOrgUnitInfo storageOrgUnitInfo;
                IStorageOrgUnit iStorageOrgUnit;
                String id;
                FilterItemInfo filterItem = filterInfo.getFilterItems().get(i);
                if (filterItem.getPropertyName().equals("storageOrgUnit.id")) {
                    id = (String)filterItem.getCompareValue();
                    iStorageOrgUnit = StorageOrgUnitFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext());
                    storageOrgUnitInfo = iStorageOrgUnit.getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
                    if (null != storageOrgUnitInfo) {
                        this.storageOrgUnitInfo = storageOrgUnitInfo;
                    }
                    if (null != (fullOrgUnitInfo = (iFullOrgUnit = FullOrgUnitFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext())).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(id)))) {
                        this.storageOrgUnitInfo = fullOrgUnitInfo;
                    }
                }
                if (filterItem.getPropertyName().equals("prmtMaintainOrgUnit.id")) {
                    id = (String)filterItem.getCompareValue();
                    iStorageOrgUnit = StorageOrgUnitFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext());
                    storageOrgUnitInfo = iStorageOrgUnit.getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
                    if (null != storageOrgUnitInfo) {
                        this.maintainOrgUnits = storageOrgUnitInfo;
                    }
                    if (null != (fullOrgUnitInfo = (iFullOrgUnit = FullOrgUnitFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext())).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(id)))) {
                        this.maintainOrgUnits = fullOrgUnitInfo;
                    }
                }
                if (filterItem.getPropertyName().equals("prmtMaintainDept.id")) {
                    id = (String)filterItem.getCompareValue();
                    IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext());
                    AdminOrgUnitInfo adminOrgUnitInfo = iAdminOrgUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
                    if (null != adminOrgUnitInfo) {
                        this.adminOrgUnitInfo = adminOrgUnitInfo;
                    }
                    if (null != (fullOrgUnitInfo = (iFullOrgUnit = FullOrgUnitFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext())).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(id)))) {
                        this.adminOrgUnitInfo = fullOrgUnitInfo;
                    }
                }
                if (filterItem.getPropertyName().equals("planStartTime")) {
                    time = (String)filterItem.getCompareValue();
                    if (null == this.planStartTimeFrom) {
                        DateFormat planStartTimeFrom = CtrlFormatUtilities.getDateTimeFormat();
                        this.planStartTimeFrom = GeneDateUtils.time((Date)planStartTimeFrom.parse(time), (int)0);
                    } else {
                        DateFormat planStartTimeTo = CtrlFormatUtilities.getDateTimeFormat();
                        this.planStartTimeTo = GeneDateUtils.time((Date)planStartTimeTo.parse(time), (int)1);
                    }
                }
                if (filterItem.getPropertyName().equals("realStartTime")) {
                    time = (String)filterItem.getCompareValue();
                    if (null == this.realStartTimeFrom) {
                        DateFormat startTimeFrom = CtrlFormatUtilities.getDateTimeFormat();
                        this.realStartTimeFrom = GeneDateUtils.time((Date)startTimeFrom.parse(time), (int)0);
                    } else {
                        DateFormat startTimeTo = CtrlFormatUtilities.getDateTimeFormat();
                        this.realStartTimeTo = GeneDateUtils.time((Date)startTimeTo.parse(time), (int)1);
                    }
                }
                if (filterItem.getPropertyName().equals("billStatus")) {
                    Object billSta = filterItem.getCompareValue();
                    this.billStatus.add(billSta);
                }
                if (filterItem.getPropertyName().equals("eqmLocation.id")) {
                    EquipmentLocationInfo equipmentLocationInfo;
                    id = (String)filterItem.getCompareValue();
                    IEquipmentLocation iEquipmentLocation = EquipmentLocationFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext());
                    this.equipmentLocationInfo = equipmentLocationInfo = iEquipmentLocation.getEquipmentLocationInfo((IObjectPK)new ObjectUuidPK(id));
                }
                if (filterItem.getPropertyName().equals("abcFlag")) {
                    Object flag = filterItem.getCompareValue();
                    this.abcFlag.add(flag);
                }
                if (filterItem.getPropertyName().equals("equipmentArchives.category.id")) {
                    EquipmentCategoryInfo equipmentCategoryInfo;
                    id = (String)filterItem.getCompareValue();
                    IEquipmentCategory iEquipmentCategory = EquipmentCategoryFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext());
                    this.equipmentCategoryInfo = equipmentCategoryInfo = iEquipmentCategory.getEquipmentCategoryInfo((IObjectPK)new ObjectUuidPK(id));
                }
                if (filterItem.getPropertyName().equals("equipmentArchives.type.id")) {
                    EquipmentTypeInfo equipmentTypeInfo;
                    id = (String)filterItem.getCompareValue();
                    IEquipmentType iEquipmentType = EquipmentTypeFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext());
                    this.equipmentTypeInfo = equipmentTypeInfo = iEquipmentType.getEquipmentTypeInfo((IObjectPK)new ObjectUuidPK(id));
                }
                if (filterItem.getPropertyName().equals("equipmentArchives.id")) {
                    EquipmentArchivesInfo equipmentArchivesInfo;
                    id = (String)filterItem.getCompareValue();
                    IEquipmentArchives iEquipmentArchives = EquipmentArchivesFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext());
                    this.equipmentArchivesInfo = equipmentArchivesInfo = iEquipmentArchives.getEquipmentArchivesInfo((IObjectPK)new ObjectUuidPK(id));
                }
                if (!filterItem.getPropertyName().equals("bizStatus") || (biz = filterItem.getCompareValue()) != null && biz instanceof ArrayList) continue;
                this.bizStatus.add(biz);
            }
        }
    }

    protected void initListener() {
        super.initListener();
    }

    protected void tblMain_tableDataRequest(KDTDataRequestEvent e) throws BOSException {
        this.setCursorOfWair();
        this.filter.remove("filterInfo");
        int i = 0;
        while (i < this.filter.getFilterItems().size()) {
            this.filter.getFilterItems().removeObject(0);
        }
        IEqmLocCostAnalysisFacade iEqmLocCostAnalysisFacade = EqmLocCostAnalysisFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        if (null == this.querySolution) {
            EqmLocCostAnalysisFilterUI ecaf = (EqmLocCostAnalysisFilterUI)this.queryDialog.getUserPanel(0);
            if (ecaf.getStorageOrgUnits() != null && ecaf.getStorageOrgUnits() instanceof StorageOrgUnitInfo) {
                this.filter.appendFilterItem("planOrgunit.id", (Object)((StorageOrgUnitInfo)ecaf.getStorageOrgUnits()).getId().toString());
            } else if (ecaf.getStorageOrgUnits() != null && ecaf.getStorageOrgUnits() instanceof FullOrgUnitInfo) {
                this.filter.appendFilterItem("planOrgunit.id", (Object)((FullOrgUnitInfo)ecaf.getStorageOrgUnits()).getId().toString());
            }
            if (ecaf.getMaintainOrgUnits() != null && ecaf.getMaintainOrgUnits() instanceof StorageOrgUnitInfo) {
                this.filter.appendFilterItem("maintainOrgUnit.id", (Object)((StorageOrgUnitInfo)ecaf.getMaintainOrgUnits()).getId().toString());
            } else if (ecaf.getMaintainOrgUnits() != null && ecaf.getMaintainOrgUnits() instanceof FullOrgUnitInfo) {
                this.filter.appendFilterItem("maintainOrgUnit.id", (Object)((FullOrgUnitInfo)ecaf.getMaintainOrgUnits()).getId().toString());
            }
            if (ecaf.getMaintainDepts() != null && ecaf.getMaintainDepts() instanceof AdminOrgUnitInfo) {
                this.filter.appendFilterItem("maintainDept.id", (Object)((AdminOrgUnitInfo)ecaf.getMaintainDepts()).getId().toString());
            }
            if (ecaf.getMaintainDepts() != null && ecaf.getMaintainDepts() instanceof FullOrgUnitInfo) {
                this.filter.appendFilterItem("maintainDept.id", (Object)((FullOrgUnitInfo)ecaf.getMaintainDepts()).getId().toString());
            }
            if (ecaf.getPlanStartTimeFrom() != null) {
                this.filter.getFilterItems().add(new FilterItemInfo("planStartTime", (Object)GeneDateUtils.time((Date)ecaf.getPlanStartTimeFrom(), (int)0), CompareType.GREATER_EQUALS));
            }
            if (ecaf.getPlanStartTimeTo() != null) {
                this.filter.getFilterItems().add(new FilterItemInfo("planStartTime", (Object)GeneDateUtils.time((Date)ecaf.getPlanStartTimeTo(), (int)1), CompareType.LESS_EQUALS));
            }
            if (ecaf.getRealStartTimeFrom() != null) {
                this.filter.getFilterItems().add(new FilterItemInfo("realStartTime", (Object)GeneDateUtils.time((Date)ecaf.getRealStartTimeFrom(), (int)0), CompareType.GREATER_EQUALS));
            }
            if (ecaf.getRealStartTimeTo() != null) {
                this.filter.getFilterItems().add(new FilterItemInfo("realStartTime", (Object)GeneDateUtils.time((Date)ecaf.getRealStartTimeTo(), (int)1), CompareType.LESS_EQUALS));
            }
            this.filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)ecaf.getBillStatus(), CompareType.INNER));
            this.filter.getFilterItems().add(new FilterItemInfo("taskType", (Object)new Integer(10), CompareType.EQUALS));
            boolean flag = true;
            if (ecaf.getStorageOrgUnits() != null && ecaf.getStorageOrgUnits() instanceof StorageOrgUnitInfo) {
                this.planOrgunitid = ((StorageOrgUnitInfo)ecaf.getStorageOrgUnits()).getId().toString();
            } else if (ecaf.getStorageOrgUnits() != null && ecaf.getStorageOrgUnits() instanceof FullOrgUnitInfo) {
                this.planOrgunitid = ((FullOrgUnitInfo)ecaf.getStorageOrgUnits()).getId().toString();
            }
            try {
                if (this.planOrgunitid == "") {
                    flag = false;
                } else {
                    HashMap mp = (HashMap)PermissionHelper.getAuthorizedOrg((IObjectPK)this.getUserPk(), (OrgType)OrgType.Storage, (IObjectPK)new ObjectUuidPK(this.planOrgunitid), (String)this.getViewPermItemName());
                    if (!mp.containsKey(this.planOrgunitid)) {
                        flag = false;
                    }
                }
            }
            catch (EASBizException e1) {
                logger.error((Object)e1);
            }
            ArrayList collection = iEqmLocCostAnalysisFacade.getEqmLocCostAnalysisCollection(ecaf.getStorageOrgUnits(), ecaf.getMaintainOrgUnits(), ecaf.getMaintainDepts(), ecaf.getPlanStartTimeFrom(), ecaf.getPlanStartTimeTo(), ecaf.getRealStartTimeFrom(), ecaf.getRealStartTimeTo(), ecaf.getBillStatus(), ecaf.getEquipmentCategorys(), ecaf.getEquipmentTypes(), ecaf.getEquipmentArchives(), ecaf.getBizStatus(), ecaf.getAbcFlag(), ecaf.getEquipmentLocation());
            if (flag) {
                this.loadCollectionFields(collection);
            } else {
                this.loadCollectionFields(null);
            }
        }
        if (null != this.querySolution) {
            if (this.storageOrgUnitInfo != null && this.storageOrgUnitInfo instanceof StorageOrgUnitInfo) {
                this.filter.appendFilterItem("planOrgunit.id", (Object)((StorageOrgUnitInfo)this.storageOrgUnitInfo).getId().toString());
            } else if (this.storageOrgUnitInfo != null && this.storageOrgUnitInfo instanceof FullOrgUnitInfo) {
                this.filter.appendFilterItem("planOrgunit.id", (Object)((FullOrgUnitInfo)this.storageOrgUnitInfo).getId().toString());
            }
            if (this.maintainOrgUnits != null && this.maintainOrgUnits instanceof StorageOrgUnitInfo) {
                this.filter.appendFilterItem("maintainOrgUnit.id", (Object)((StorageOrgUnitInfo)this.maintainOrgUnits).getId().toString());
            } else if (this.maintainOrgUnits != null && this.maintainOrgUnits instanceof FullOrgUnitInfo) {
                this.filter.appendFilterItem("maintainOrgUnit.id", (Object)((FullOrgUnitInfo)this.maintainOrgUnits).getId().toString());
            }
            if (this.adminOrgUnitInfo != null && this.adminOrgUnitInfo instanceof AdminOrgUnitInfo) {
                this.filter.appendFilterItem("maintainDept.id", (Object)((AdminOrgUnitInfo)this.adminOrgUnitInfo).getId().toString());
            }
            if (this.adminOrgUnitInfo != null && this.adminOrgUnitInfo instanceof FullOrgUnitInfo) {
                this.filter.appendFilterItem("maintainDept.id", (Object)((FullOrgUnitInfo)this.adminOrgUnitInfo).getId().toString());
            }
            if (this.planStartTimeFrom != null) {
                this.filter.getFilterItems().add(new FilterItemInfo("planStartTime", (Object)this.planStartTimeFrom, CompareType.GREATER_EQUALS));
            }
            if (this.planStartTimeTo != null) {
                this.filter.getFilterItems().add(new FilterItemInfo("planStartTime", (Object)this.planStartTimeTo, CompareType.LESS_EQUALS));
            }
            if (this.realStartTimeFrom != null) {
                this.filter.getFilterItems().add(new FilterItemInfo("realStartTime", (Object)this.realStartTimeFrom, CompareType.GREATER_EQUALS));
            }
            if (this.realStartTimeTo != null) {
                this.filter.getFilterItems().add(new FilterItemInfo("realStartTime", (Object)this.realStartTimeTo, CompareType.LESS_EQUALS));
            }
            this.filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)this.billStatus, CompareType.INNER));
            this.filter.getFilterItems().add(new FilterItemInfo("taskType", (Object)new Integer(10), CompareType.EQUALS));
            boolean flag = true;
            if (this.storageOrgUnitInfo != null && this.storageOrgUnitInfo instanceof StorageOrgUnitInfo) {
                this.planOrgunitid = ((StorageOrgUnitInfo)this.storageOrgUnitInfo).getId().toString();
            } else if (this.storageOrgUnitInfo != null && this.storageOrgUnitInfo instanceof FullOrgUnitInfo) {
                this.planOrgunitid = ((FullOrgUnitInfo)this.storageOrgUnitInfo).getId().toString();
            }
            try {
                if (this.planOrgunitid == "") {
                    flag = false;
                } else {
                    HashMap mp = (HashMap)PermissionHelper.getAuthorizedOrg((IObjectPK)this.getUserPk(), (OrgType)OrgType.Storage, (IObjectPK)new ObjectUuidPK(this.planOrgunitid), (String)this.getViewPermItemName());
                    if (!mp.containsKey(this.planOrgunitid)) {
                        flag = false;
                    }
                }
            }
            catch (EASBizException e1) {
                logger.error((Object)e1);
            }
            ArrayList collection = iEqmLocCostAnalysisFacade.getEqmLocCostAnalysisCollection(this.storageOrgUnitInfo, this.maintainOrgUnits, this.adminOrgUnitInfo, this.planStartTimeFrom, this.planStartTimeTo, this.realStartTimeFrom, this.realStartTimeTo, this.billStatus, this.equipmentCategoryInfo, this.equipmentTypeInfo, this.equipmentArchivesInfo, this.bizStatus, this.abcFlag, this.equipmentLocationInfo);
            if (flag) {
                this.loadCollectionFields(collection);
            } else {
                this.loadCollectionFields(null);
            }
            this.querySolution = null;
            this.storageOrgUnitInfo = null;
            this.maintainOrgUnits = null;
            this.adminOrgUnitInfo = null;
            this.planStartTimeFrom = null;
            this.planStartTimeTo = null;
            this.realStartTimeFrom = null;
            this.realStartTimeTo = null;
            this.billStatus = null;
            this.equipmentCategoryInfo = null;
            this.equipmentTypeInfo = null;
            this.equipmentArchivesInfo = null;
            this.bizStatus = null;
            this.abcFlag = null;
            this.equipmentLocationInfo = null;
        }
        this.setCursorOfDefault();
    }

    protected EntityViewInfo getInitDefaultSolution() {
        try {
            this.initCommonQueryDialog();
            EntityViewInfo ev = new EntityViewInfo();
            CustomerQueryPanel filterUI = this.getFilterUI();
            if (filterUI != null) {
                filterUI.onLoad();
                FilterInfo filter = filterUI.getFilterInfo();
                ev.setFilter(filter);
            }
            return ev;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    public void loadCollectionFields(ArrayList collection) {
        if (collection != null && collection.size() > 0) {
            for (TempEquipmentInfo info : collection) {
                IRow row = this.tblMain.addRow();
                row.getCell(COL_ARCHIVESNUM).setValue((Object)info.getEquipmentArchivesNumber());
                row.getCell(COL_ARCHIVESNAME).setValue((Object)info.getEquipmentArchivesName());
                row.getCell(COL_EQMARCHIVESID).setValue((Object)info.getEquipmentArchivesId());
                row.getCell(COL_EQMARCHIVESLONGNUMBER).setValue((Object)info.getEqmArchivesLongNumber());
                if (null == info.getEquipmentArchivesName() || info.getEquipmentArchivesName().equals("")) {
                    row.getCell(COL_LOCATION).setValue((Object)info.getEqmLocationNumber());
                    row.getCell(COL_LOCATIONNAME).setValue((Object)info.getEqmLocationName());
                }
                if (null == info.getEquipmentArchivesId() || info.getEquipmentArchivesId().equals("")) {
                    row.getCell(COL_EQMLOCATIONID).setValue((Object)info.getEqmLocationId());
                }
                if (null == info.getEquipmentArchivesId() || info.getEquipmentArchivesId().equals("")) {
                    row.getCell(COL_EQLLOCATIONLONGNUMBER).setValue((Object)info.getEqmLocationLongNumber());
                }
                if (null != info.getPlanStaffCost()) {
                    row.getCell(COL_EMPLOYEEPLANCOST).setValue((Object)info.getPlanStaffCost());
                } else {
                    row.getCell(COL_EMPLOYEEPLANCOST).setValue((Object)new BigDecimal(0.0).setScale(2, 6));
                }
                if (null != info.getRealStaffCost()) {
                    row.getCell(COL_EMPLOYEEFACTCOST).setValue((Object)info.getRealStaffCost());
                } else {
                    row.getCell(COL_EMPLOYEEFACTCOST).setValue((Object)new BigDecimal(0.0).setScale(2, 6));
                }
                if (null != info.getPlanMaterialCost()) {
                    row.getCell(COL_MATERIELPLANCOST).setValue((Object)info.getPlanMaterialCost());
                } else {
                    row.getCell(COL_MATERIELPLANCOST).setValue((Object)new BigDecimal(0.0).setScale(2, 6));
                }
                if (null != info.getRealMaterialCose()) {
                    row.getCell(COL_MATERIELFACTCOST).setValue((Object)info.getRealMaterialCose());
                } else {
                    row.getCell(COL_MATERIELFACTCOST).setValue((Object)new BigDecimal(0.0).setScale(2, 6));
                }
                if (null != info.getPlanToolsCost()) {
                    row.getCell(COL_TOOLSPLANCOST).setValue((Object)info.getPlanToolsCost());
                } else {
                    row.getCell(COL_TOOLSPLANCOST).setValue((Object)new BigDecimal(0.0).setScale(2, 6));
                }
                if (null != info.getRealToolsCost()) {
                    row.getCell(COL_TOOLSFACTCOST).setValue((Object)info.getRealToolsCost());
                } else {
                    row.getCell(COL_TOOLSFACTCOST).setValue((Object)new BigDecimal(0.0).setScale(2, 6));
                }
                if (null != info.getPlanServiceCost()) {
                    row.getCell(COL_SERVICEPLANCOST).setValue((Object)info.getPlanServiceCost());
                } else {
                    row.getCell(COL_SERVICEPLANCOST).setValue((Object)new BigDecimal(0.0).setScale(2, 6));
                }
                if (null != info.getRealServiceCost()) {
                    row.getCell(COL_SERVICEFACTCOST).setValue((Object)info.getRealServiceCost());
                } else {
                    row.getCell(COL_SERVICEFACTCOST).setValue((Object)new BigDecimal(0.0).setScale(2, 6));
                }
                row.getCell(COL_LEVEL).setValue((Object)info.getLevel());
            }
        }
        this.setSortForTable();
        if (this.tblMain.getRowCount() > 0) {
            this.tblMain.getSelectManager().select(0, 0);
        }
    }

    protected void initCommonQueryDialog() {
        if (this.queryDialog == null) {
            this.queryDialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.queryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.queryDialog.setOwner((Component)((Object)this));
            }
            this.queryDialog.setUiObject((IUIObject)this);
            this.queryDialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
            this.queryDialog.setQueryObjectPK(this.mainQueryPK);
            this.queryDialog.setShowFilter(false);
            this.queryDialog.setShowSorter(false);
            this.queryDialog.setDisShowRowCount(false);
            this.queryDialog.setUiObject(null);
            try {
                this.filterUI = (EqmLocCostAnalysisFilterUI)this.getFilterUI();
                this.queryDialog.setHeight(430);
                this.queryDialog.setWidth(600);
                this.queryDialog.addUserPanel((KDPanel)this.filterUI);
                this.queryDialog.setTitle(this.filterUI.getUITitle().trim() + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        this.filterUI = new EqmLocCostAnalysisFilterUI();
        return this.filterUI;
    }

    private boolean showQueryDialog() throws Exception {
        this.initCommonQueryDialog();
        if (this.queryDialog.show()) {
            FilterInfo filterInfo;
            EqmLocCostAnalysisFilterUI filterui = (EqmLocCostAnalysisFilterUI)this.queryDialog.getUserPanel(0);
            if (filterui.verify() && (filterInfo = filterui.getFilterInfo()) != null) {
                EntityViewInfo view = new EntityViewInfo();
                view.setSelector(this.getSelectors());
                view.setFilter(filterInfo);
                this.viewInfo = view;
            }
        } else {
            this.tHelper.setDialog(this.queryDialog);
            SysUtil.abort();
        }
        return true;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.showQueryDialog();
        this.doQuery();
    }

    public void actionEqmLocCostCalculate_actionPerformed(ActionEvent e) throws Exception {
        super.actionEqmLocCostCalculate_actionPerformed(e);
        ArrayList<EquipmentArchivesInfo> archivesList = new ArrayList<EquipmentArchivesInfo>();
        IEqmLocCostAnalysisFacade iEqmLocCostAnalysisFacade = EqmLocCostAnalysisFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        String selectedArchiveId = this.getSelectedKeyValue(this.tblMain, COL_EQMARCHIVESID);
        String[] archiveIds = selectedArchiveId.split(",");
        if (null != archiveIds && archiveIds.length > 0) {
            for (int i = 0; i < archiveIds.length; ++i) {
                EquipmentArchivesInfo equipmentArchivesInfo;
                if (archiveIds[i].equals("") || null == (equipmentArchivesInfo = iEqmLocCostAnalysisFacade.getEquipmentArchive(archiveIds[i]))) continue;
                archivesList.add(equipmentArchivesInfo);
            }
        }
        String[] eqmArchivesLongNumbers = this.getSelectedKeyValue(this.tblMain, COL_EQMARCHIVESLONGNUMBER).split(",");
        if (null != archivesList && archivesList.size() > 0) {
            ArrayList costList = iEqmLocCostAnalysisFacade.getNextEqmArchive(archivesList);
            if (null != eqmArchivesLongNumbers && eqmArchivesLongNumbers.length > 0) {
                for (int j = 0; j < eqmArchivesLongNumbers.length; ++j) {
                    for (int a = 0; a < costList.size(); ++a) {
                        BigDecimal nextMaterielPlanCost = new BigDecimal(0.0);
                        BigDecimal nextMaterielFactCost = new BigDecimal(0.0);
                        BigDecimal nextEmployeePlanCost = new BigDecimal(0.0);
                        BigDecimal nextEmployeeFactCost = new BigDecimal(0.0);
                        BigDecimal nextToolsPlanCost = new BigDecimal(0.0);
                        BigDecimal nextToolsFactCost = new BigDecimal(0.0);
                        BigDecimal nextServicePlanCost = new BigDecimal(0.0);
                        BigDecimal nextServiceFactCost = new BigDecimal(0.0);
                        ArrayList li = (ArrayList)costList.get(a);
                        Stack<String> stack = new Stack<String>();
                        for (int n = 0; n < li.size(); ++n) {
                            TempEquipmentInfo tempEquipmentInfo = (TempEquipmentInfo)li.get(n);
                            if (null == tempEquipmentInfo.getEqmArchivesLongNumber()) continue;
                            if (stack.empty()) {
                                stack.push(tempEquipmentInfo.getEqmArchivesLongNumber());
                            }
                            if (tempEquipmentInfo.getEqmArchivesLongNumber().indexOf(eqmArchivesLongNumbers[j]) == -1) continue;
                            if (null != tempEquipmentInfo.getNextEmployeePlanCost()) {
                                nextEmployeePlanCost = nextEmployeePlanCost.add(tempEquipmentInfo.getNextEmployeePlanCost());
                            }
                            if (null != tempEquipmentInfo.getNextEmployeeFactCost()) {
                                nextEmployeeFactCost = nextEmployeeFactCost.add(tempEquipmentInfo.getNextEmployeeFactCost());
                            }
                            if (null != tempEquipmentInfo.getNextMaterielPlanCost()) {
                                nextMaterielPlanCost = nextMaterielPlanCost.add(tempEquipmentInfo.getNextMaterielPlanCost());
                            }
                            if (null != tempEquipmentInfo.getNextMaterielFactCost()) {
                                nextMaterielFactCost = nextMaterielFactCost.add(tempEquipmentInfo.getNextMaterielFactCost());
                            }
                            if (null != tempEquipmentInfo.getNextToolsPlanCost()) {
                                nextToolsPlanCost = nextToolsPlanCost.add(tempEquipmentInfo.getNextToolsPlanCost());
                            }
                            if (null != tempEquipmentInfo.getNextToolsFactCost()) {
                                nextToolsFactCost = nextToolsFactCost.add(tempEquipmentInfo.getNextToolsFactCost());
                            }
                            if (null != tempEquipmentInfo.getNextServicePlanCost()) {
                                nextServicePlanCost = nextServicePlanCost.add(tempEquipmentInfo.getNextServicePlanCost());
                            }
                            if (null == tempEquipmentInfo.getNextServiceFactCost()) continue;
                            nextServiceFactCost = nextServiceFactCost.add(tempEquipmentInfo.getNextServiceFactCost());
                        }
                        String longNumber = "";
                        while (!stack.empty()) {
                            longNumber = (String)stack.pop();
                        }
                        if (!longNumber.equals(eqmArchivesLongNumbers[j])) continue;
                        int rowIndex = this.getCountIndex(this.tblMain, COL_EQMARCHIVESLONGNUMBER, eqmArchivesLongNumbers[j]);
                        IRow row = this.tblMain.getRow(rowIndex);
                        row.getCell(COL_NEXTEMPLOYEEPLANCOST).setValue((Object)nextEmployeePlanCost.setScale(2, 6));
                        row.getCell(COL_NEXTEMPLOYEEFACTCOST).setValue((Object)nextEmployeeFactCost.setScale(2, 6));
                        row.getCell(COL_NEXTMATERIELPLANCOST).setValue((Object)nextMaterielPlanCost.setScale(2, 6));
                        row.getCell(COL_NEXTMATERIELFACTCOST).setValue((Object)nextMaterielFactCost.setScale(2, 6));
                        row.getCell(COL_NEXTTOOLSPLANCOST).setValue((Object)nextToolsPlanCost.setScale(2, 6));
                        row.getCell(COL_NEXTTOOLSFACTCOST).setValue((Object)nextToolsFactCost.setScale(2, 6));
                        row.getCell(COL_NEXTSERVICEPLANCOST).setValue((Object)nextServicePlanCost.setScale(2, 6));
                        row.getCell(COL_NEXTSERVICEFACTCOST).setValue((Object)nextServiceFactCost.setScale(2, 6));
                    }
                }
            }
        }
        String selectedLocationId = this.getSelectedKeyValue(this.tblMain, COL_EQMLOCATIONID);
        String[] locationIds = selectedLocationId.split(",");
        ArrayList<EquipmentLocationInfo> locationList = new ArrayList<EquipmentLocationInfo>();
        if (null != locationIds && locationIds.length > 0) {
            for (int i = 0; i < locationIds.length; ++i) {
                EquipmentLocationInfo equipmentLocationInfo;
                if (locationIds[i].equals("") || null == (equipmentLocationInfo = iEqmLocCostAnalysisFacade.getEquipmentLocation(locationIds[i]))) continue;
                locationList.add(equipmentLocationInfo);
            }
        }
        String[] eqmLocationLongNumbers = this.getSelectedKeyValue(this.tblMain, COL_EQLLOCATIONLONGNUMBER).split(",");
        ArrayList costs = null;
        if (null != locationList && locationList.size() > 0) {
            for (int b = 0; b < locationList.size(); ++b) {
                EquipmentLocationInfo equipmentLocationInfo = (EquipmentLocationInfo)locationList.get(b);
                costs = iEqmLocCostAnalysisFacade.getNextEqmLocationCost(equipmentLocationInfo);
                for (int a = 0; a < costs.size(); ++a) {
                    if (null == eqmLocationLongNumbers || eqmLocationLongNumbers.length <= 0) continue;
                    for (int j = 0; j < eqmLocationLongNumbers.length; ++j) {
                        TempEquipmentInfo tempEquipmentInfo = (TempEquipmentInfo)costs.get(a);
                        if (!tempEquipmentInfo.getEqmLocationLongNumber().equals(eqmLocationLongNumbers[j])) continue;
                        int rowIndex = this.getCountIndex(this.tblMain, COL_EQLLOCATIONLONGNUMBER, eqmLocationLongNumbers[j]);
                        IRow row = this.tblMain.getRow(rowIndex);
                        row.getCell(COL_NEXTEMPLOYEEPLANCOST).setValue((Object)tempEquipmentInfo.getNextEmployeePlanCost().setScale(2, 6));
                        row.getCell(COL_NEXTEMPLOYEEFACTCOST).setValue((Object)tempEquipmentInfo.getNextEmployeeFactCost().setScale(2, 6));
                        row.getCell(COL_NEXTMATERIELPLANCOST).setValue((Object)tempEquipmentInfo.getNextMaterielPlanCost().setScale(2, 6));
                        row.getCell(COL_NEXTMATERIELFACTCOST).setValue((Object)tempEquipmentInfo.getNextMaterielFactCost().setScale(2, 6));
                        row.getCell(COL_NEXTTOOLSPLANCOST).setValue((Object)tempEquipmentInfo.getNextToolsPlanCost().setScale(2, 6));
                        row.getCell(COL_NEXTTOOLSFACTCOST).setValue((Object)tempEquipmentInfo.getNextToolsFactCost().setScale(2, 6));
                        row.getCell(COL_NEXTSERVICEPLANCOST).setValue((Object)tempEquipmentInfo.getNextServicePlanCost().setScale(2, 6));
                        row.getCell(COL_NEXTSERVICEFACTCOST).setValue((Object)tempEquipmentInfo.getNextServiceFactCost().setScale(2, 6));
                    }
                }
            }
        }
    }

    public String getSelectedKeyValue(KDTable table, String columnName) {
        StringBuffer values = new StringBuffer();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            for (int i = 0; i < selectRows.length; ++i) {
                Object keyValue;
                ICell cell;
                int rowIndex = selectRows[i];
                IRow row = table.getRow(rowIndex);
                if (row == null || (cell = row.getCell(columnName)) == null || (keyValue = cell.getValue()) == null) continue;
                values.append(keyValue.toString());
                if (i == selectRows.length) continue;
                values.append(",");
            }
        } else {
            int rowIndex = this.tblMain.getRowCount();
            for (int i = 0; i < rowIndex; ++i) {
                Object keyValue;
                ICell cell = this.tblMain.getCell(i, columnName);
                if (cell == null || (keyValue = cell.getValue()) == null) continue;
                values.append(keyValue.toString());
                if (i == rowIndex) continue;
                values.append(",");
            }
        }
        return values.toString();
    }

    public int getCountIndex(KDTable table, String columnName, String columnValue) {
        int countIndex = 0;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            for (int i = 0; i < selectRows.length; ++i) {
                Object keyValue;
                ICell cell;
                int rowIndex = selectRows[i];
                IRow row = table.getRow(rowIndex);
                if (row == null || (cell = row.getCell(columnName)) == null || null == (keyValue = cell.getValue()) || !keyValue.equals(columnValue)) continue;
                countIndex = selectRows[i];
            }
        } else {
            int rowIndex = this.tblMain.getRowCount();
            for (int i = 0; i < rowIndex; ++i) {
                Object keyValue;
                ICell cell = this.tblMain.getCell(i, columnName);
                if (cell == null || null == (keyValue = cell.getValue()) || !keyValue.equals(columnValue)) continue;
                countIndex = i;
            }
        }
        return countIndex;
    }

    public void doQuery() {
        this.tblMain.removeRows();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnQuery);
        this.btnQuery.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_filter", (Locale)this.getLocale()));
        this.btnEqmLocCostAnalysis.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_differenceanalyze", (Locale)this.getLocale()));
        this.menuItemCostCalculate.setVisible(true);
        this.menuItemCostCalculate.setEnabled(true);
        this.menuItemCostCalculate.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_deprecalculate", (Locale)this.getLocale()));
        this.menuItemCostAnalysis.setVisible(true);
        this.menuItemCostAnalysis.setEnabled(true);
        this.menuItemCostAnalysis.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_differenceanalyze", (Locale)this.getLocale()));
        this.menuItemPrint.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_print", (Locale)this.getLocale()));
        this.menuItemPrint.setAccelerator(KeyStroke.getKeyStroke("Ctrl P"));
    }

    public void actionEqmLocCostAnalysis_actionPerformed(ActionEvent e) throws Exception {
        super.actionEqmLocCostAnalysis_actionPerformed(e);
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        String selectedArchive = ListUiHelper.getSelectedKeyValue((int[])KDTableUtil.getSelectedRows((KDTable)this.tblMain), (KDTable)this.tblMain, (String)COL_EQMARCHIVESID);
        String selectedLocation = ListUiHelper.getSelectedKeyValue((int[])KDTableUtil.getSelectedRows((KDTable)this.tblMain), (KDTable)this.tblMain, (String)COL_EQMLOCATIONID);
        if (null != selectedArchive && !selectedArchive.equals("")) {
            uiContext.put((Object)"archiveId", (Object)selectedArchive);
        } else {
            uiContext.put((Object)"archiveId", null);
        }
        if (null != selectedLocation && !selectedLocation.equals("") && (null == selectedArchive || selectedArchive.equals(""))) {
            uiContext.put((Object)"locationId", (Object)selectedLocation);
        } else {
            uiContext.put((Object)"locationId", null);
        }
        uiContext.put((Object)"filterInfo", (Object)this.filter);
        String uimode = "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
        UICreator.create((String)EqmLocCostAnalysisTreeUI.class.getName(), (String)uimode, (UIContext)uiContext);
    }

    private void checkSelected() {
        if (this.tblMain.getSelectManager().getBlocks().size() == 0 || this.tblMain.getRowCount() == 0 && this.tblMain.getSelectManager().getBlocks().size() == 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if (this.tblMain.getSelectManager().size() > 1) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getResourceMsg("SELECT_ONLY"));
            SysUtil.abort();
        }
    }

    private String getResourceMsg(String key) {
        return ResourceUtils.getMessage((String)COSTANALYSIS_RESOURCE_PATH, (String)key);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.doInvokePrint(true);
    }

    protected void doInvokePrint(boolean isPrint) throws Exception {
        if (this.planOrgunitid != "") {
            PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectUuidPK(this.planOrgunitid), (String)"eqm_EqmLocCostAnalysis_02print");
        }
        this.preparePrintPage(this.tblMain);
        KDPrinter printer = this.tblMain.getPrintManager().getNewPrintManager().getPrinter();
        if (this.printActionListener == null) {
            BOSObjectType bosType = this.getBizInterface().getType();
            this.printActionListener = new GenePrintActionListener(bosType);
            printer.addPrintActionListener((IPrintActionListener)this.printActionListener);
        }
        if (isPrint) {
            this.tblMain.getPrintManager().print();
        } else {
            this.tblMain.getPrintManager().printPreview();
        }
    }

    protected boolean isIgnoreOrgFilter() {
        return false;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    private IEqmLocCostAnalysisFacade getBizInterface() {
        try {
            return EqmLocCostAnalysisFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        }
        catch (BOSException e) {
            logger.error((Object)e);
            return null;
        }
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (this.planOrgunitid != "") {
            PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectUuidPK(this.planOrgunitid), (String)"eqm_EqmLocCostAnalysis_02print");
        }
        super.actionPrintPreview_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    private void setSortForTable() {
        for (int i = 0; i < this.tblMain.getColumnCount(); ++i) {
            this.tblMain.getColumn(i).setSortable(true);
        }
        if (this.tblMain.getSortMange() != null) {
            this.tblMain.getSortMange().setSortAuto(true);
            this.tblMain.getSortMange().setClickCount(1);
        } else {
            KDTSortManager sortManager = new KDTSortManager(this.tblMain);
            sortManager.setClickCount(1);
            this.tblMain.setSortMange(sortManager);
            this.tblMain.getSortMange().setSortAuto(true);
        }
    }

    public boolean destroyWindow() {
        IEqmLocCostAnalysisFacade iEqmLocCostAnalysisFacade = this.getBizInterface();
        try {
            iEqmLocCostAnalysisFacade.releaseTemporaryTable();
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return super.destroyWindow();
    }

    public static QueryInfo getQueryInfo(IMetaDataPK queryPK) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getQuery(queryPK);
    }

    public String getViewPermItemName() {
        return "eqm_EqmLocCostAnalysis_01view";
    }
}

