/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.analysis.client;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.eqm.analysis.IWorkorderCostAnalysisTreeFacade;
import com.kingdee.eas.eqm.analysis.WorkOrderTreeInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.tree.ITreeBuilder;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang.StringUtils;

public class WorkOrderCostAnalysisLNTreeBuilder
implements ITreeBuilder {
    private String separator;
    private final String defaultSeparator = ":";
    private FilterInfo filter;
    private HashMap nodeMap;
    private TreeMap treeMap;
    private IWorkorderCostAnalysisTreeFacade ctrl;
    private CoreUI ui;

    public WorkOrderCostAnalysisLNTreeBuilder(TreeMap treeMap, IWorkorderCostAnalysisTreeFacade ctrl, HashMap nodeMap) {
        this.treeMap = treeMap;
        this.nodeMap = nodeMap;
        this.ctrl = ctrl;
    }

    public KDTree buildTree(KDTree tree) throws Exception {
        TreeSelectionListener[] selectionListeners;
        if (this.ui != null) {
            this.ui.setCursorOfWair();
        }
        if (tree == null) {
            tree = new KDTree(false);
        }
        if ((selectionListeners = tree.getTreeSelectionListeners()) != null && selectionListeners.length > 0) {
            for (int i = 0; i < selectionListeners.length; ++i) {
                tree.removeTreeSelectionListener(selectionListeners[i]);
            }
        }
        KDTreeNode rootNode = null;
        if (tree.getModel() == null || tree.getModel().getRoot() == null || !(tree.getModel().getRoot() instanceof KDTreeNode)) {
            return null;
        }
        rootNode = (KDTreeNode)tree.getModel().getRoot();
        tree.setShowsRootHandles(true);
        this.buildChildren(rootNode);
        ((DefaultTreeModel)tree.getModel()).setRoot((TreeNode)rootNode);
        if (this.ui != null) {
            this.ui.setCursorOfDefault();
        }
        return tree;
    }

    private List getChildrenNode(WorkOrderTreeInfo treeNodeInfo, int expandLevel2) {
        String longNumber = treeNodeInfo.getLongNumber();
        Iterator iterKey = this.treeMap.keySet().iterator();
        ArrayList childrenList = new ArrayList();
        return childrenList;
    }

    public void refreshTreeNode(KDTree tree, KDTreeNode treeNode) throws Exception {
        treeNode.setVirtual(true);
    }

    public void refreshTreeNode(KDTree tree, KDTreeNode treeNode, FilterInfo filter) throws Exception {
        treeNode.setVirtual(true);
    }

    public void setFilter(FilterInfo filter) {
        this.filter = filter;
    }

    public FilterInfo getFilter() {
        return this.filter;
    }

    public String getSeparator() {
        if (this.separator == null || this.separator.equals("")) {
            return ":";
        }
        return this.separator;
    }

    private KDTreeNode getParentNode(WorkOrderTreeInfo info) {
        String longNumber = info.getLongNumber();
        if (!StringUtils.contains((String)longNumber, (String)this.getSeparator())) {
            return null;
        }
        int lastIndex = longNumber.lastIndexOf(this.getSeparator());
        longNumber = longNumber.substring(0, lastIndex);
        WorkOrderTreeInfo tempParentInfo = (WorkOrderTreeInfo)this.treeMap.get(longNumber);
        return (KDTreeNode)this.nodeMap.get(tempParentInfo);
    }

    private void buildChildren(KDTreeNode parentNode) {
        for (WorkOrderTreeInfo treeInfo : this.nodeMap.keySet()) {
            if (treeInfo.getLevel() == 2) {
                parentNode.add((MutableTreeNode)((KDTreeNode)this.nodeMap.get(treeInfo)));
                continue;
            }
            KDTreeNode node = this.getParentNode(treeInfo);
            if (node != null) {
                node.add((MutableTreeNode)((KDTreeNode)this.nodeMap.get(treeInfo)));
                continue;
            }
            if (node == null && treeInfo.getLongNumber().indexOf(this.getSeparator()) != -1) continue;
        }
    }

    public void setExpandLevel(int expandLevel) {
    }
}

