/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.analysis.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.eqm.analysis.client.AbstractWorkorderCostAnalysisFilterUI;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.common.core.GeneSysDefinedEnum;
import com.kingdee.eas.eqm.common.core.filter.CompositeFilterElement;
import com.kingdee.eas.eqm.common.core.filter.DateCasterEnum;
import com.kingdee.eas.eqm.common.core.filter.IFilterElement;
import com.kingdee.eas.eqm.common.core.filter.IQueryFilterManager;
import com.kingdee.eas.eqm.common.core.filter.RangeFilterElement;
import com.kingdee.eas.eqm.common.core.filter.SingleFilterElement;
import com.kingdee.eas.eqm.common.core.util.GeneDateUtils;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.eqm.maintain.WorkOrderSrcTypeEnum;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WorkorderCostAnalysisFilterUI
extends AbstractWorkorderCostAnalysisFilterUI {
    private static final long serialVersionUID = 1L;
    protected static final String RESOURCE_PATH = "com.kingdee.eas.eqm.analysis.WorkorderCostAnalysisResource";

    public void registerQueryFilterManager(IQueryFilterManager manager) {
        super.registerQueryFilterManager(manager);
        CompositeFilterElement rootElement = this.getFilterManager().getRootElement();
        rootElement.add((IFilterElement)new SingleFilterElement("maintainOrgUnit.id", (Component)this.prmtMaintainOrgUnit));
        RangeFilterElement numberElement = new RangeFilterElement("number", (Component)this.txtNumberFrom, (Component)this.txtNumberTo);
        numberElement.getFrom().putUserInfo("key", "number");
        numberElement.getTo().putUserInfo("key", "number");
        rootElement.add((IFilterElement)numberElement);
        rootElement.add((IFilterElement)new SingleFilterElement("equipmentArchives.id", (Component)this.prmtEquipmentArchives));
        rootElement.add((IFilterElement)new SingleFilterElement("eqmLocation.id", (Component)this.prmtEquipmentLocation));
        rootElement.add((IFilterElement)new SingleFilterElement("workOrderModel.id", (Component)this.prmtWorkOrderModel));
        SingleFilterElement workOrderSrcTypeElement = new SingleFilterElement("sourcetype", (Component)this.comboSourceType);
        workOrderSrcTypeElement.setBlankValue((Object)GeneSysDefinedEnum.SELECT_ALL);
        workOrderSrcTypeElement.setDefaultValue(String.valueOf(999));
        workOrderSrcTypeElement.setDataCaster(DateCasterEnum.IINTEGER_DC);
        rootElement.add((IFilterElement)workOrderSrcTypeElement);
        RangeFilterElement bizDateElement = new RangeFilterElement("realStartTime", (Component)this.startTimeFrom, (Component)this.startTimeTo);
        rootElement.add((IFilterElement)bizDateElement);
        RangeFilterElement planDateElement = new RangeFilterElement("planStartTime", (Component)this.planStartTimeFrom, (Component)this.planStartTimeTo);
        rootElement.add((IFilterElement)planDateElement);
        rootElement.add((IFilterElement)new SingleFilterElement("maintainDept.id", (Component)this.prmtMaintainDept));
        rootElement.add((IFilterElement)new SingleFilterElement("maintainTeam.id", (Component)this.prmtMaintainTeam));
        rootElement.add((IFilterElement)new SingleFilterElement("manager.id", (Component)this.prmtManager));
        CompositeFilterElement billStatus = new CompositeFilterElement("or");
        SingleFilterElement billStatusSaves = new SingleFilterElement("billStatus", (Component)this.chkSave);
        billStatusSaves.setDefaultValue(String.valueOf(true));
        billStatusSaves.putUserInfo("trueValue", String.valueOf(10));
        billStatusSaves.putUserInfo("falseEqualAll", "1");
        billStatusSaves.setDataCaster(DateCasterEnum.IINTEGER_DC);
        SingleFilterElement billStatusSubmit = new SingleFilterElement("billStatus", (Component)this.chkSubmit);
        billStatusSubmit.setDefaultValue(String.valueOf(true));
        billStatusSubmit.putUserInfo("trueValue", String.valueOf(20));
        billStatusSubmit.putUserInfo("falseEqualAll", "1");
        billStatusSubmit.setDataCaster(DateCasterEnum.IINTEGER_DC);
        SingleFilterElement billStatusAudit = new SingleFilterElement("billStatus", (Component)this.chkAudit);
        billStatusAudit.setDefaultValue(String.valueOf(true));
        billStatusAudit.putUserInfo("trueValue", String.valueOf(30));
        billStatusAudit.putUserInfo("falseEqualAll", "1");
        billStatusAudit.setDataCaster(DateCasterEnum.IINTEGER_DC);
        SingleFilterElement billStatusRelease = new SingleFilterElement("billStatus", (Component)this.chkRelease);
        billStatusRelease.setDefaultValue(String.valueOf(true));
        billStatusRelease.putUserInfo("trueValue", String.valueOf(45));
        billStatusRelease.putUserInfo("falseEqualAll", "1");
        billStatusRelease.setDataCaster(DateCasterEnum.IINTEGER_DC);
        SingleFilterElement billStatusStartWork = new SingleFilterElement("billStatus", (Component)this.chkStartWork);
        billStatusStartWork.setDefaultValue(String.valueOf(true));
        billStatusStartWork.putUserInfo("trueValue", String.valueOf(44));
        billStatusStartWork.putUserInfo("falseEqualAll", "1");
        billStatusStartWork.setDataCaster(DateCasterEnum.IINTEGER_DC);
        SingleFilterElement billStatusCheck = new SingleFilterElement("billStatus", (Component)this.chkCheck);
        billStatusCheck.setDefaultValue(String.valueOf(true));
        billStatusCheck.putUserInfo("trueValue", String.valueOf(48));
        billStatusCheck.putUserInfo("falseEqualAll", "1");
        billStatusCheck.setDataCaster(DateCasterEnum.IINTEGER_DC);
        SingleFilterElement billStatusClosed = new SingleFilterElement("billStatus", (Component)this.chkClose);
        billStatusClosed.putUserInfo("trueValue", String.valueOf(49));
        billStatusClosed.putUserInfo("falseEqualAll", "1");
        billStatusClosed.setDataCaster(DateCasterEnum.IINTEGER_DC);
        billStatusClosed.setDefaultValue(String.valueOf(true));
        SingleFilterElement billStatusForceClosed = new SingleFilterElement("billStatus", (Component)this.chkForceClosed);
        billStatusForceClosed.putUserInfo("trueValue", String.valueOf(60));
        billStatusForceClosed.putUserInfo("falseEqualAll", "1");
        billStatusForceClosed.setDataCaster(DateCasterEnum.IINTEGER_DC);
        billStatusForceClosed.setDefaultValue(String.valueOf(true));
        SingleFilterElement billStatusForceFinish = new SingleFilterElement("billStatus", (Component)this.chkFinish);
        billStatusForceFinish.putUserInfo("trueValue", String.valueOf(46));
        billStatusForceFinish.putUserInfo("falseEqualAll", "1");
        billStatusForceFinish.setDataCaster(DateCasterEnum.IINTEGER_DC);
        billStatusForceFinish.setDefaultValue(String.valueOf(true));
        billStatus.add((IFilterElement)billStatusSaves);
        billStatus.add((IFilterElement)billStatusSubmit);
        billStatus.add((IFilterElement)billStatusAudit);
        billStatus.add((IFilterElement)billStatusRelease);
        billStatus.add((IFilterElement)billStatusStartWork);
        billStatus.add((IFilterElement)billStatusCheck);
        billStatus.add((IFilterElement)billStatusClosed);
        billStatus.add((IFilterElement)billStatusForceClosed);
        billStatus.add((IFilterElement)billStatusForceFinish);
        rootElement.add((IFilterElement)billStatus);
        SingleFilterElement billStatusSave = new SingleFilterElement("parent.id", (Component)this.chkSuperParent);
        billStatusSave.putUserInfo("falseEqualAll", "true");
        rootElement.add((IFilterElement)billStatusSave);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = super.getFilterInfo();
        EquipmentArchivesInfo archivesInfo = (EquipmentArchivesInfo)this.prmtEquipmentArchives.getValue();
        EquipmentLocationInfo locationInfo = (EquipmentLocationInfo)this.prmtEquipmentLocation.getValue();
        if (null == archivesInfo && null != locationInfo) {
            filterInfo.getFilterItems().add(new FilterItemInfo("equipmentArchives.id", null, CompareType.EMPTY));
        }
        FilterInfo taskTypeFilterInfo = new FilterInfo();
        taskTypeFilterInfo.appendFilterItem("taskType", (Object)Integer.valueOf("10"));
        FilterItemInfo superParentFilterItem = new FilterItemInfo("parent.id", null);
        if (this.chkSuperParent.isSelected()) {
            for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                FilterItemInfo filterItem = filterInfo.getFilterItems().get(i);
                if (!filterItem.getPropertyName().equals(superParentFilterItem.getPropertyName())) continue;
                filterInfo.getFilterItems().removeObject(i);
                filterInfo.getFilterItems().addObject(i, (IObjectValue)superParentFilterItem);
                break;
            }
        }
        try {
            filterInfo.mergeFilter(taskTypeFilterInfo, "AND");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    public KDBizPromptBox getMainBizOrg() {
        return this.prmtOrgUnit;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtOrgUnit;
    }

    protected String getMainBizOrgField() {
        return "planOrgunit";
    }

    protected void setDefaultValue() {
        this.chkSave.setSelected(true);
        this.chkSubmit.setSelected(true);
        this.chkAudit.setSelected(true);
        this.chkRelease.setSelected(true);
        this.chkStartWork.setSelected(true);
        this.chkCheck.setSelected(true);
        this.chkClose.setSelected(true);
        this.chkForceClosed.setSelected(true);
        this.chkClose.setSelected(true);
        this.chkSuperParent.setSelected(true);
        this.prmtOrgUnit.setValue((Object)this.getDefaultMainBizOrg());
        this.prmtMaintainOrgUnit.setValue((Object)this.getDefaultMainBizOrg());
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        Timestamp dPlanStartTimeFrom = GeneDateUtils.time((Date)calendar.getTime(), (int)0);
        this.startTimeFrom.setValue((Object)dPlanStartTimeFrom);
        this.planStartTimeFrom.setValue((Object)dPlanStartTimeFrom);
        Timestamp dPlanStartTimeTo = GeneDateUtils.time((Date)new Date(), (int)1);
        this.startTimeTo.setValue((Object)dPlanStartTimeTo);
        this.planStartTimeTo.setValue((Object)dPlanStartTimeTo);
    }

    protected void registerCustomerBindings() {
        super.registerCustomerBindings();
        this.prmtMaintainOrgUnit.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                WorkorderCostAnalysisFilterUI.this.prmtMaintainOrgUnit_stateChanged(e);
            }
        });
        this.comboSourceType.removeAllItems();
        this.comboSourceType.addItems(new Object[]{GeneSysDefinedEnum.SELECT_ALL, WorkOrderSrcTypeEnum.MANUAL, WorkOrderSrcTypeEnum.MAINTAINTASKREQ, WorkOrderSrcTypeEnum.MAINTAINSTRATEGY, WorkOrderSrcTypeEnum.MAINTAINROUTE, WorkOrderSrcTypeEnum.MAINTAINSCHEMA, WorkOrderSrcTypeEnum.TASK, WorkOrderSrcTypeEnum.STATUSTEST, WorkOrderSrcTypeEnum.CHECKPLAN});
        try {
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtWorkOrderModel, (String)"com.kingdee.eas.eqm.basedata.app.F7EquipmentWorkOrderModelQuery", (String[])new String[0], (Object[])new Object[0]);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmtMaintainOrgUnit, null, (boolean)false, (OrgType)this.getMainBizOrgType(), (boolean)true, (boolean)false);
    }

    public String getViewPermItemName() {
        return "eqm_analysis_workordercost_01view";
    }

    protected void prmtMaintainOrgUnit_stateChanged(ChangeEvent e) {
        try {
            this.prmtMaintainDept.setValue(null);
            this.prmtMaintainTeam.setValue(null);
            this.prmtManager.setValue(null);
            if (this.prmtMaintainOrgUnit.getValue() == null) {
                this.prmtMaintainDept.setEnabled(false);
                this.prmtMaintainTeam.setEnabled(false);
                this.prmtManager.setEnabled(false);
                return;
            }
            this.prmtMaintainDept.setEnabled(true);
            this.prmtMaintainTeam.setEnabled(true);
            this.prmtManager.setEnabled(true);
            EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmtMaintainDept, (String)"com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery", (OrgType)OrgType.Storage, (OrgType)OrgType.Admin, (OrgUnitInfo)((OrgUnitInfo)this.prmtMaintainOrgUnit.getValue()));
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtMaintainTeam, (String)"com.kingdee.eas.eqm.basedata.app.F7EquipmentMaintainGroupQuery", (String[])new String[]{"storageOrgUnit.id"}, (Object[])new Object[]{((OrgUnitInfo)this.prmtMaintainOrgUnit.getValue()).getId().toString()});
            EQMPromptDialogFactory.createPeoplePrmptList((KDBizPromptBox)this.prmtManager, (String)"com.kingdee.eas.eqm.basedata.app.F7PersonQuery", (OrgType)OrgType.Storage, (OrgType)OrgType.Admin, (OrgUnitInfo)((OrgUnitInfo)this.prmtMaintainOrgUnit.getValue()), (String[])new String[]{"deletedStatus"}, (Object[])new Object[]{new Integer(1)}, (CompareType[])new CompareType[]{CompareType.EQUALS});
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    public boolean isSupportMultiOrgs() {
        return false;
    }

    protected void afterMainOrgChanged(OrgUnitInfo oldOrg, OrgUnitInfo org) {
        super.afterMainOrgChanged(oldOrg, org);
        try {
            String sql = "SELECT DISTINCT \"EQUIPMENTARCHIVES\".FID FROM T_EQM_EquipmentArchives \"EQUIPMENTARCHIVES\" WHERE \"EQUIPMENTARCHIVES\".FID IN (SELECT DISTINCT \"EQUIPMENTARCHIVES\".FID FROM T_EQM_EquipmentArchives \"EQUIPMENTARCHIVES\" INNER JOIN T_ORG_Storage \"PLANORGUNIT\" ON \"EQUIPMENTARCHIVES\".FPlanOrgUnitID = \"PLANORGUNIT\".FID INNER JOIN T_EQM_EquipmentAdjustHistory \"HISTORY\" ON \"EQUIPMENTARCHIVES\".FID = \"HISTORY\".FEquipmentID WHERE \"HISTORY\".FOrgID = '" + org.getId().toString() + "') OR \"EQUIPMENTARCHIVES\".FID IN ( select DISTINCT \"EQUIPMENTARCHIVES\".FID FROM T_EQM_EquipmentArchives \"EQUIPMENTARCHIVES\" WHERE \"EQUIPMENTARCHIVES\".FPlanOrgUnitID = '" + org.getId().toString() + "')";
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtEquipmentArchives, (String)"com.kingdee.eas.eqm.archives.app.F7EquipmentArchivesForCostAnalysis", (String[])new String[]{"id"}, (Object[])new Object[]{sql}, (CompareType[])new CompareType[]{CompareType.INNER});
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtEquipmentLocation, (String)"com.kingdee.eas.eqm.basedata.app.F7EquipmentLocationQuery", (String[])new String[]{"planOrgunit.id"}, (Object[])new Object[]{((OrgUnitInfo)this.getMainBizOrg().getValue()).getId().toString()});
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.txtNumberFrom, (String)"com.kingdee.eas.eqm.maintain.app.F7WorkOrderQuery", (String[])new String[]{"planOrgunit.id"}, (Object[])new Object[]{((OrgUnitInfo)this.getMainBizOrg().getValue()).getId().toString()}, (CompareType[])new CompareType[]{CompareType.EQUALS});
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.txtNumberTo, (String)"com.kingdee.eas.eqm.maintain.app.F7WorkOrderQuery", (String[])new String[]{"planOrgunit.id"}, (Object[])new Object[]{((OrgUnitInfo)this.getMainBizOrg().getValue()).getId().toString()}, (CompareType[])new CompareType[]{CompareType.EQUALS});
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
    }

    public boolean verify() {
        Date realDateFrom = (Date)this.startTimeFrom.getValue();
        Date realDateTo = (Date)this.startTimeTo.getValue();
        Date planDateFrom = (Date)this.planStartTimeFrom.getValue();
        Date planDateTo = (Date)this.planStartTimeTo.getValue();
        if (realDateFrom != null && realDateTo != null && new Timestamp(realDateFrom.getTime()).after(new Timestamp(realDateTo.getTime()))) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceUtils.getMessage((String)RESOURCE_PATH, (String)"filter_mustBefore_realBeginDateAndRealEndDate"));
            return false;
        }
        if (planDateFrom != null && planDateTo != null && new Timestamp(planDateFrom.getTime()).after(new Timestamp(planDateTo.getTime()))) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceUtils.getMessage((String)RESOURCE_PATH, (String)"filter_mustBefore_planBeginDateAndPlanEndDate"));
            return false;
        }
        return super.verify();
    }
}

