/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.util.UICreator;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.basedata.AbstractEquipmentLocationInfo;
import com.kingdee.eas.eqm.basedata.CountTypeEnum;
import com.kingdee.eas.eqm.basedata.EQMBaseDataException;
import com.kingdee.eas.eqm.basedata.EqmSrcBillTypeEnum;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.basedata.EquipmentMeterApplyCollection;
import com.kingdee.eas.eqm.basedata.EquipmentMeterApplyFactory;
import com.kingdee.eas.eqm.basedata.EquipmentMeterApplyInfo;
import com.kingdee.eas.eqm.basedata.EquipmentMeterInfo;
import com.kingdee.eas.eqm.basedata.EquipmentReadingFactory;
import com.kingdee.eas.eqm.basedata.EquipmentReadingInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStatusMontorMsgFactory;
import com.kingdee.eas.eqm.basedata.MeterTypeEnum;
import com.kingdee.eas.eqm.basedata.ReadingWayEnum;
import com.kingdee.eas.eqm.basedata.client.AbstractEquipmentReadingEditUI;
import com.kingdee.eas.eqm.common.core.GeneBatchResult;
import com.kingdee.eas.eqm.common.core.GeneCheckedStatusEnum;
import com.kingdee.eas.eqm.common.core.client.listener.AbstractGeneTableColumnListener;
import com.kingdee.eas.eqm.common.core.client.listener.GeneKDTable;
import com.kingdee.eas.eqm.common.core.client.listener.GeneTableColumnListener;
import com.kingdee.eas.eqm.common.core.util.GeneCommonUtils;
import com.kingdee.eas.eqm.common.core.util.GeneDateUtils;
import com.kingdee.eas.eqm.common.core.util.GeneEqualsUtils;
import com.kingdee.eas.eqm.common.core.util.GeneMenuUtils;
import com.kingdee.eas.eqm.common.core.util.GeneMultiLangUtils;
import com.kingdee.eas.eqm.common.core.util.GeneSelectorUtils;
import com.kingdee.eas.eqm.common.core.util.NumericUtils;
import com.kingdee.eas.eqm.common.core.util.backup.GeneHelper;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.eqm.maintain.WorkOrderInfo;
import com.kingdee.eas.eqm.planning.CheckingPlanningCpTaskInfo;
import com.kingdee.eas.eqm.planning.CheckingPlanningInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class EquipmentReadingEditUI
extends AbstractEquipmentReadingEditUI {
    private static final Logger logger = CoreUIObject.getLogger(EquipmentReadingEditUI.class);
    private static final String NO_SPLIT = "_";
    private static final String REGEXPRESSION = "_[0-9]{4}";
    public static final String TBL_TBLMAIN = "tblMain";
    public static final String COL_ID = "id";
    public static final String COL_METER_NUMBER = "meter.number";
    public static final String COL_METER_NAME = "meter.name";
    public static final String COL_METER_METERTYPE = "meter.meterType";
    public static final String COL_METER_UNIT_NAME = "meter.unit.name";
    public static final String COL_METER_COUNTTYPE = "meter.countType";
    public static final String COL_READINGWAY = "readingWay";
    public static final String COL_CURRENTVALUE = "currentValue";
    public static final String COL_READINGDATE = "readingDate";
    public static final String COL_ACCUMULATEDVALUE = "accumulatedValue";
    public static final String COL_DAYAVERAGEVALUE = "dayAverageValue";
    private GeneKDTable readingTable = null;
    private boolean isModify = false;
    private Map<String, BigDecimal> oldAccumulatedValueMap = new HashMap<String, BigDecimal>();
    private Map existMap = new HashMap();

    public EquipmentReadingEditUI() throws Exception {
        this.readingTable = new GeneKDTable(this.tblMain);
    }

    protected IMetaDataPK getMainQueryPK() {
        return new MetaDataPK("com.kingdee.eas.eqm.basedata.app.EquipmentReadingEditQuery");
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EquipmentReadingFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    public KDTextField getNumTextField() {
        return null;
    }

    public BOSObjectType getBizObjectType() {
        return new EquipmentReadingInfo().getBOSType();
    }

    protected EntityViewInfo getQueryEntityViewInfo() {
        this.viewInfo = new EntityViewInfo();
        if (this.viewInfo.getFilter() == null) {
            this.viewInfo.setFilter(new FilterInfo());
        }
        try {
            FilterInfo filter = new FilterInfo();
            if (this.getEntityFieldName() == null) {
                filter.getFilterItems().add(new FilterItemInfo(COL_ID, null));
            } else {
                filter.getFilterItems().add(new FilterItemInfo(this.getEntityFieldName(), (Object)(this.getEntityValue().getId() == null ? "" : this.getEntityValue().getId().toString())));
            }
            filter.getFilterItems().add(new FilterItemInfo("activedStatus", (Object)Boolean.TRUE));
            filter.getFilterItems().add(new FilterItemInfo("parent.activedStatus", (Object)Boolean.TRUE));
            filter.getFilterItems().add(new FilterItemInfo("meter.checkedStatus", (Object)new Integer(GeneCheckedStatusEnum.AUDITED.getValue())));
            if (this.getUIContext().get("ISMONTOR") != null && ((Boolean)this.getUIContext().get("ISMONTOR")).booleanValue()) {
                String sql;
                if ("equipment.id".equals(this.getEntityFieldName())) {
                    sql = "SELECT FPARENTID FROM T_EQM_EQUIPMENTREADING WHERE FPARENTID IN (SELECT FApplyID FROM T_EQM_EquipmentStatusDetect WHERE FMONITOR=1 and FEQUIPMENTID='" + this.getEntityValue().getId().toString() + "')";
                    filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)sql, CompareType.INNER));
                }
                if ("location.id".equals(this.getEntityFieldName())) {
                    sql = "SELECT FPARENTID FROM T_EQM_EQUIPMENTREADING WHERE FPARENTID IN (SELECT FApplyID FROM T_EQM_EquipmentStatusDetect WHERE FMONITOR=1 and FLOCATIONID='" + this.getEntityValue().getId().toString() + "')";
                    filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)sql, CompareType.INNER));
                }
            }
            this.viewInfo.getFilter().mergeFilter(filter, "and");
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.addObjectCollection((IObjectCollection)GeneSelectorUtils.getSelector((BOSObjectType)new EquipmentReadingInfo().getBOSType(), (String)"", (boolean)false));
            sic.addObjectCollection((IObjectCollection)GeneSelectorUtils.getSelector((BOSObjectType)new EquipmentMeterInfo().getBOSType(), (String)"meter", (boolean)false));
            sic.addObjectCollection((IObjectCollection)GeneSelectorUtils.getSelector((BOSObjectType)new EquipmentMeterApplyInfo().getBOSType(), (String)"parent", (boolean)false));
            sic.add(new SelectorItemInfo("meter.unit.qtyPrecision"));
            sic.add(new SelectorItemInfo(COL_DAYAVERAGEVALUE));
            this.viewInfo.setSelector(sic);
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return this.viewInfo;
    }

    protected void initListener() {
        super.initListener();
        this.prmptEquipment.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EquipmentReadingEditUI.this.prmptEquipment_stateChanged(e);
            }
        });
        this.prmptLocation.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EquipmentReadingEditUI.this.prmptLocation_stateChanged(e);
            }
        });
        this.prmptSrcBill.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EquipmentReadingEditUI.this.prmptWorkorder_stateChanged(e);
            }
        });
        this.readingTable.addTableColumnListener((GeneTableColumnListener)new AbstractGeneTableColumnListener(COL_CURRENTVALUE, true){

            public void tableColumnChanged(KDTEditEvent e) {
                EquipmentReadingEditUI.this.currentValueChange(e);
            }
        });
        this.readingTable.addTableColumnListener((GeneTableColumnListener)new AbstractGeneTableColumnListener(COL_READINGWAY){

            public void tableColumnChanged(KDTEditEvent e) {
                EquipmentReadingEditUI.this.readingWayValueChange(e);
            }
        });
        this.readingTable.addTableColumnListener((GeneTableColumnListener)new AbstractGeneTableColumnListener(COL_METER_NUMBER){

            public void tableColumnChanged(KDTEditEvent e) {
                EquipmentReadingEditUI.this.meterValueChange(e);
            }
        });
        this.readingTable.addTableColumnListener((GeneTableColumnListener)new AbstractGeneTableColumnListener(COL_READINGDATE){

            public void tableColumnChanged(KDTEditEvent e) {
                EquipmentReadingEditUI.this.readingDateValueChange(e);
            }
        });
    }

    public void removeKey(final KDTable table) {
        if (table != null) {
            table.setColumnMoveable(true);
            table.setActiveCellStatus(1);
            table.getActionMap().remove("AddRow");
            table.getActionMap().remove("RemoveRow");
            table.getActionMap().remove("Delete");
            table.getActionMap().remove("Paste");
        }
        AbstractAction actionTable = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (table != null) {
                    table.removeRow(table.getRowCount() - 1);
                    EquipmentReadingEditUI.this.addLine(table);
                }
            }
        };
        KDTableHelper.updateEnterWithTab((KDTable)table, (boolean)true, (Action)actionTable);
        KDTableHelper.downArrowAutoAddRow((KDTable)table, (boolean)true, (Action)actionTable);
    }

    protected void readingDateValueChange(KDTEditEvent e) {
        IRow row = this.tblMain.getRow(e.getRowIndex());
        if (row.getCell(COL_METER_NUMBER).getValue() instanceof EquipmentMeterInfo) {
            EquipmentMeterInfo meter = (EquipmentMeterInfo)row.getCell(COL_METER_NUMBER).getValue();
            if (e.getValue() != null && e.getValue() instanceof Date) {
                ((EquipmentReadingInfo)row.getUserObject()).setReadingDate(new Timestamp(((Date)e.getValue()).getTime()));
                try {
                    this.readingDateChange(row, meter);
                    if (!this.isModify) {
                        this.isModify = true;
                    }
                }
                catch (EASBizException e1) {
                    this.handleException((Exception)((Object)e1));
                }
                catch (BOSException e1) {
                    this.handleException((Exception)((Object)e1));
                }
            } else {
                MsgBox.showInfo((String)GeneMultiLangUtils.getMultiLangString((String)this.getResourceName(), (String)"ReadingDateCannotBeNull"));
                row.getCell(e.getColIndex()).setValue(e.getOldValue());
                SysUtil.abort();
            }
        }
    }

    protected void meterValueChange(KDTEditEvent e) {
        IRow row = this.tblMain.getRow(e.getRowIndex());
        if (row.getCell(COL_METER_NUMBER).getValue() instanceof EquipmentMeterInfo) {
            EquipmentMeterInfo meter = (EquipmentMeterInfo)row.getCell(COL_METER_NUMBER).getValue();
            if (meter == null) {
                return;
            }
            ((EquipmentReadingInfo)row.getUserObject()).setMeter(meter);
            try {
                if (!this.virifyCanAdd(meter, row.getRowIndex()).booleanValue()) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.eqm.basedata.BASEDATAAutoGenerateResource", (String)"68_EquipmentReadingEditUI"));
                    row.getCell(COL_METER_NUMBER).setValue(null);
                    return;
                }
                this.fetchNewAddMeter(meter);
                this.meterChange(row, meter);
                row.getCell("meter.checkContent").setValue((Object)meter.getCheckContent());
                if (!this.isModify) {
                    this.isModify = true;
                }
            }
            catch (EASBizException e1) {
                this.handleException((Exception)((Object)e1));
            }
            catch (BOSException e1) {
                this.handleException((Exception)((Object)e1));
            }
        }
    }

    private Boolean virifyCanAdd(EquipmentMeterInfo meter, int rowIndex) {
        if (MeterTypeEnum.serialMeter.equals((Object)meter.getMeterType())) {
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                if (i == rowIndex) continue;
                EquipmentMeterInfo exsistMeter = (EquipmentMeterInfo)this.tblMain.getRow(i).getCell(COL_METER_NUMBER).getValue();
                if (!meter.getId().toString().equals(exsistMeter.getId().toString()) || !ReadingWayEnum.Reset.equals((Object)((ReadingWayEnum)((Object)this.tblMain.getRow(i).getCell(COL_READINGWAY).getValue()))) && !ReadingWayEnum.Replacement.equals((Object)((ReadingWayEnum)((Object)this.tblMain.getRow(i).getCell(COL_READINGWAY).getValue())))) continue;
                return false;
            }
        }
        return true;
    }

    private void fetchNewAddMeter(EquipmentMeterInfo meter) {
        if (this.existMap.get(meter.getId()) == null) {
            try {
                IObjectCollection collection;
                List result = EquipmentReadingFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).getGeneDtaBaseCollection(this.getQueryEntityViewInfo(), 0, -1);
                if (result != null && result.size() == 2 && (collection = (IObjectCollection)result.get(1)) != null && collection.size() > 0) {
                    for (EquipmentReadingInfo readingInfo : collection) {
                        readingInfo.setMeterNo(readingInfo.getMeter().getNumber());
                        this.existMap.put(readingInfo.getMeter().getId(), readingInfo.clone());
                    }
                }
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    protected void readingWayValueChange(KDTEditEvent e) {
        IRow row = this.tblMain.getRow(e.getRowIndex());
        if (row.getCell(COL_METER_NUMBER).getValue() instanceof EquipmentMeterInfo) {
            EquipmentMeterInfo meterInfo = (EquipmentMeterInfo)row.getCell(COL_METER_NUMBER).getValue();
            if (ReadingWayEnum.Replacement.equals(e.getValue()) || ReadingWayEnum.Reset.equals(e.getValue())) {
                if (MsgBox.isYes((int)MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.eqm.basedata.BASEDATAAutoGenerateResource", (String)"69_EquipmentReadingEditUI")))) {
                    this.removeOtherReading(meterInfo, e.getRowIndex());
                } else {
                    row.getCell(COL_READINGWAY).setValue(e.getOldValue());
                    return;
                }
            }
            if (e.getValue() != null && e.getValue() instanceof ReadingWayEnum) {
                ((EquipmentReadingInfo)row.getUserObject()).setReadingWay((ReadingWayEnum)((Object)e.getValue()));
                try {
                    if (row.getCell(COL_CURRENTVALUE).getValue() != null) {
                        this.readingWayChange(row, meterInfo);
                    }
                    if (!this.isModify) {
                        this.isModify = true;
                    }
                }
                catch (EASBizException e1) {
                    this.handleException((Exception)((Object)e1));
                }
                catch (BOSException e1) {
                    this.handleException((Exception)((Object)e1));
                }
            }
            if (ReadingWayEnum.Replacement.equals(e.getValue())) {
                row.getCell(COL_ACCUMULATEDVALUE).getStyleAttributes().setLocked(false);
                row.getCell(COL_ACCUMULATEDVALUE).setValue((Object)new BigDecimal(0));
            } else {
                row.getCell(COL_ACCUMULATEDVALUE).getStyleAttributes().setLocked(true);
            }
        }
    }

    private void removeOtherReading(EquipmentMeterInfo meterInfo, int rowIndex) {
        ArrayList<Integer> removeIndexList = new ArrayList<Integer>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            EquipmentMeterInfo existMeter;
            if (rowIndex == i || (existMeter = (EquipmentMeterInfo)this.tblMain.getRow(i).getCell(COL_METER_NUMBER).getValue()) == null || !meterInfo.getId().toString().equals(existMeter.getId().toString())) continue;
            removeIndexList.add(i);
        }
        int counter = 0;
        for (Object e : removeIndexList) {
            this.tblMain.removeRow((Integer)e - counter);
            ++counter;
        }
    }

    protected void currentValueChange(KDTEditEvent e) {
        IRow row = this.tblMain.getRow(e.getRowIndex());
        if (row.getCell(COL_METER_NUMBER).getValue() instanceof EquipmentMeterInfo) {
            EquipmentMeterInfo meterInfo = (EquipmentMeterInfo)row.getCell(COL_METER_NUMBER).getValue();
            if (e.getValue() != null) {
                ((EquipmentReadingInfo)row.getUserObject()).setCurrentValue(e.getValue().toString());
                try {
                    this.currentValueChange(row, meterInfo);
                    if (!this.isModify) {
                        this.isModify = true;
                    }
                }
                catch (EASBizException e1) {
                    this.handleException((Exception)((Object)e1));
                }
                catch (BOSException e1) {
                    this.handleException((Exception)((Object)e1));
                }
            } else if (row.getCell(COL_METER_NUMBER).getValue() != null && !ReadingWayEnum.Replacement.equals(row.getCell(COL_READINGWAY).getValue())) {
                row.getCell(COL_ACCUMULATEDVALUE).setValue((Object)this.oldAccumulatedValueMap.get(((EquipmentMeterInfo)row.getCell(COL_METER_NUMBER).getValue()).getNumber()));
            }
        }
    }

    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
    }

    protected void prmptWorkorder_stateChanged(ChangeEvent e) {
        if (this.prmptSrcBill.getValue() instanceof WorkOrderInfo) {
            WorkOrderInfo orderInfo = (WorkOrderInfo)this.prmptSrcBill.getValue();
            if (orderInfo.getEquipmentArchives() == null && orderInfo.getEqmLocation() != null) {
                this.prmptLocation.setValue((Object)orderInfo.getEqmLocation());
            }
            if (orderInfo.getEquipmentArchives() != null) {
                this.prmptEquipment.setValue((Object)orderInfo.getEquipmentArchives());
            }
        } else {
            CheckingPlanningCpTaskInfo info = (CheckingPlanningCpTaskInfo)this.prmptSrcBill.getValue();
            if (info.getLocation() != null) {
                this.prmptLocation.setValue((Object)info.getLocation());
            }
            if (info.getAchieves() != null) {
                this.prmptEquipment.setValue((Object)info.getAchieves());
            }
        }
    }

    protected void prmptLocation_stateChanged(ChangeEvent e) {
        if (this.prmptLocation.getValue() != null) {
            this.registerMeterCondition("flocationid", this.prmptLocation);
        } else {
            this.txtLocationName.setText(null);
        }
    }

    protected void prmptEquipment_stateChanged(ChangeEvent e) {
        if (this.prmptEquipment.getValue() != null) {
            this.registerMeterCondition("fequipmentid", this.prmptEquipment);
        } else {
            this.txtEquipmentName.setText(null);
        }
    }

    private void registerMeterCondition(String field, KDBizPromptBox promptBox) {
        try {
            if (promptBox.getValue() != null) {
                String sql = " Select FMeterID from t_eqm_equipmentMeterApply where {0} = {1} and factivedStatus = 1";
                if (this.getUIContext().get("ISMONTOR") != null && ((Boolean)this.getUIContext().get("ISMONTOR")).booleanValue()) {
                    sql = "Select FMeterID from t_eqm_equipmentMeterApply where {0} = {1} and factivedStatus = 1 and FMeterID IN (Select FMeterID from T_EQM_EquipmentStatusDetect where {2} = {3} and FMONITOR = 1)";
                    EQMPromptDialogFactory.createPrmptList((KDTable)this.tblMain, (String)COL_METER_NUMBER, (String)"com.kingdee.eas.eqm.basedata.app.F7EquipmentMeterQuery", (String[])new String[]{COL_ID}, (Object[])new Object[]{MessageFormat.format(sql, field, "'" + ((ObjectBaseInfo)promptBox.getValue()).getId().toString() + "'", field, "'" + ((ObjectBaseInfo)promptBox.getValue()).getId().toString() + "'")}, (CompareType[])new CompareType[]{CompareType.INNER}, (String)"$number$", (String)"$number$");
                } else {
                    EQMPromptDialogFactory.createPrmptList((KDTable)this.tblMain, (String)COL_METER_NUMBER, (String)"com.kingdee.eas.eqm.basedata.app.F7EquipmentMeterQuery", (String[])new String[]{COL_ID}, (Object[])new Object[]{MessageFormat.format(sql, field, "'" + ((ObjectBaseInfo)promptBox.getValue()).getId().toString() + "'")}, (CompareType[])new CompareType[]{CompareType.INNER}, (String)"$number$", (String)"$number$");
                }
                KDTDefaultCellEditor editor = (KDTDefaultCellEditor)this.tblMain.getColumn(COL_METER_NUMBER).getEditor();
                KDBizPromptBox prmptMeter = (KDBizPromptBox)editor.getComponent();
                prmptMeter.getSelectorCollection().add(new SelectorItemInfo("meter.unit.qtyPrecision"));
            }
        }
        catch (BOSException e1) {
            this.handleException((Exception)((Object)e1));
        }
    }

    protected void registerCustomerBindings() {
        super.registerCustomerBindings();
        this.tblMain.getColumn(COL_ACCUMULATEDVALUE).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        try {
            Object obj = this.getUIContext().get("ENTITYVALUE");
            if (this.getEntityValue() != null) {
                Object info;
                StorageOrgUnitInfo maintainOrgUnitInfo = null;
                if (this.getEntityValue() instanceof EquipmentArchivesInfo) {
                    info = (EquipmentArchivesInfo)this.getEntityValue();
                    this.prmptEquipment.setValue(info);
                    this.txtEquipmentName.setText(info.getName());
                    maintainOrgUnitInfo = info.getMaintainOrgUnit();
                    this.prmptEquipment_stateChanged(null);
                } else if (this.getEntityValue() instanceof EquipmentLocationInfo) {
                    info = (EquipmentLocationInfo)this.getEntityValue();
                    this.prmptLocation.setValue(info);
                    this.txtLocationName.setText(info.getName());
                    maintainOrgUnitInfo = ((AbstractEquipmentLocationInfo)info).getMaintainOrgUnit();
                    this.prmptLocation_stateChanged(null);
                }
                if (obj instanceof WorkOrderInfo) {
                    info = (WorkOrderInfo)obj;
                    this.prmptSrcBill.setValue(info);
                    this.txtSrcBillName.setText(info.getName());
                    this.comboSrcBillType.setSelectedItem((Object)EqmSrcBillTypeEnum.WORKORDER);
                }
                if (obj instanceof CheckingPlanningCpTaskInfo) {
                    info = (CheckingPlanningCpTaskInfo)obj;
                    CheckingPlanningInfo entityInfo = (CheckingPlanningInfo)this.getUIContext().get("ENTITY");
                    this.prmptSrcBill.setValue(info);
                    this.comboSrcBillType.setSelectedItem((Object)EqmSrcBillTypeEnum.POINTINSPECTION);
                    if (entityInfo != null) {
                        this.prmptSrcBill.setData((Object)entityInfo);
                        this.txtSrcBillName.setText(entityInfo.getDescription());
                    }
                    if (info.getAchieves() != null) {
                        this.prmptEquipment.setData((Object)info.getAchieves());
                    }
                    if (info.getLocation() != null && info.getAchieves() == null) {
                        this.prmptLocation.setData((Object)info.getLocation());
                    }
                }
                if (maintainOrgUnitInfo != null) {
                    EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmptEquipment, (String)"com.kingdee.eas.eqm.archives.app.F7EquipmentArchivesQuery", (String[])new String[]{this.getMainBizOrgField() + ".id"}, (Object[])new Object[]{maintainOrgUnitInfo.getId().toString()});
                    EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmptLocation, (String)"com.kingdee.eas.eqm.basedata.app.F7EquipmentLocationQuery", (String[])new String[]{this.getMainBizOrgField() + ".id"}, (Object[])new Object[]{maintainOrgUnitInfo.getId().toString()});
                }
            } else {
                throw new EQMBaseDataException(EQMBaseDataException.TYPEISNOTERROR);
            }
            this.prmptCreator.setValue((Object)SysContext.getSysContext().getCurrentUserInfo());
            EQMPromptDialogFactory.createPickDateTime((KDTable)this.tblMain, (String)COL_READINGDATE, (boolean)true);
            this.creatTime.setValue((Object)new Timestamp(System.currentTimeMillis()));
            Object orgUnitInfo = this.getUIContext().get("CURRENTORGVALUE");
            if (orgUnitInfo != null && orgUnitInfo instanceof OrgUnitInfo) {
                this.initUIMainOrgContext(((OrgUnitInfo)orgUnitInfo).getId().toString());
            }
            this.prmptEquipment.requestFocus();
            this.removeKey(this.tblMain);
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    private void readingDateChange(IRow row, EquipmentMeterInfo meter) throws EASBizException, BOSException {
        this.calc(meter);
    }

    private void meterChange(IRow row, EquipmentMeterInfo meter) throws BOSException, EASBizException {
        EquipmentMeterApplyInfo applyInfo = this.findParent((EquipmentReadingInfo)row.getUserObject(), meter);
        if (meter.getMeterType().getValue() == 30) {
            this.featureRowChange(row, applyInfo);
        } else {
            this.serialRowChange(row, applyInfo);
        }
        this.commonRowChange(row, applyInfo);
    }

    private void currentValueChange(IRow row, EquipmentMeterInfo meterInfo) throws EASBizException, BOSException {
        this.calc(meterInfo);
    }

    private void readingWayChange(IRow row, EquipmentMeterInfo meterInfo) throws EASBizException, BOSException {
        EquipmentReadingInfo info = (EquipmentReadingInfo)row.getUserObject();
        EquipmentMeterApplyInfo applyInfo = this.findParent(info, meterInfo);
        this.commonRowChange(row, applyInfo);
        this.calc(meterInfo);
    }

    private void serialRowChange(IRow row, EquipmentMeterApplyInfo info) throws EASBizException, BOSException {
        if (info != null && info.getMeter().getMeterType() != null) {
            if (info.getMeter().getMeterType().getValue() == 20) {
                row.getCell(COL_READINGWAY).setValue((Object)ReadingWayEnum.Actural);
                row.getCell(COL_READINGWAY).getStyleAttributes().setLocked(true);
                if (info.getMeter().getUnit() != null) {
                    EQMPromptDialogFactory.createNumberic((KDTable)this.tblMain, (int)row.getCell(COL_CURRENTVALUE).getColumnIndex(), (int)row.getRowIndex(), (int)info.getMeter().getUnit().getQtyPrecision(), (boolean)true);
                    EQMPromptDialogFactory.createNumberic((KDTable)this.tblMain, (int)row.getCell(COL_ACCUMULATEDVALUE).getColumnIndex(), (int)row.getRowIndex(), (int)0);
                }
            } else {
                if (info.getMeter().getUnit() != null) {
                    EQMPromptDialogFactory.createNumberic((KDTable)this.tblMain, (int)row.getCell(COL_CURRENTVALUE).getColumnIndex(), (int)row.getRowIndex(), (int)info.getMeter().getUnit().getQtyPrecision());
                    EQMPromptDialogFactory.createEnumList((KDTable)this.tblMain, (int)row.getCell(COL_READINGWAY).getColumnIndex(), (int)row.getRowIndex(), (Object[])new ReadingWayEnum[]{ReadingWayEnum.Replacement, ReadingWayEnum.Reset, info.getReadingWay()});
                    EQMPromptDialogFactory.createNumberic((KDTable)this.tblMain, (int)row.getCell(COL_ACCUMULATEDVALUE).getColumnIndex(), (int)row.getRowIndex(), (int)info.getMeter().getUnit().getQtyPrecision());
                }
                if (info.getReadingWay() != null) {
                    row.getCell(COL_READINGWAY).setValue((Object)info.getReadingWay());
                    row.getCell(COL_READINGWAY).getStyleAttributes().setLocked(false);
                }
            }
        }
    }

    private void featureRowChange(IRow row, EquipmentMeterApplyInfo info) throws EASBizException, BOSException {
        if (info.getMeter().getMeterType().getValue() == 30) {
            Object[] enumsValue = GeneHelper.parseEnumString((String)info.getMeter().getFeatureValue());
            EQMPromptDialogFactory.createEnumList((KDTable)this.tblMain, (int)row.getCell(COL_CURRENTVALUE).getColumnIndex(), (int)row.getRowIndex(), (Object[])enumsValue);
        }
        row.getCell(COL_READINGWAY).setValue((Object)ReadingWayEnum.Actural);
        row.getCell(COL_READINGWAY).getStyleAttributes().setLocked(true);
    }

    private void commonRowChange(IRow row, EquipmentMeterApplyInfo info) throws EASBizException, BOSException {
        if (row.getCell(COL_METER_UNIT_NAME).getValue() == null) {
            row.getCell(COL_METER_UNIT_NAME).setValue(info.getMeter().getUnit() == null ? null : info.getMeter().getUnit().getName());
            row.getCell(COL_METER_COUNTTYPE).setValue((Object)info.getMeter().getCountType());
            row.getCell(COL_METER_NAME).setValue((Object)info.getMeter().getName());
            row.getCell(COL_METER_METERTYPE).setValue((Object)info.getMeter().getMeterType());
        }
        int rowIndex = this.isExist(row, info.getMeter());
        if ((info.getCurrentValue() == null || info.getReadingDate() == null) && rowIndex == -1) {
            if (info.getMeter().getMeterType().getValue() == 10) {
                row.getCell(COL_READINGWAY).setValue((Object)ReadingWayEnum.Replacement);
            } else {
                row.getCell(COL_READINGWAY).setValue((Object)ReadingWayEnum.Actural);
            }
            row.getCell(COL_READINGWAY).getStyleAttributes().setLocked(true);
        }
        row.getCell(COL_METER_NUMBER).getStyleAttributes().setLocked(row.getCell(COL_METER_NUMBER).getValue() != null);
        ReadingWayEnum wayEnum = (ReadingWayEnum)((Object)row.getCell(COL_READINGWAY).getValue());
        if (wayEnum.getValue() == 40 && info.getMeter() != null) {
            boolean canEditAccumlatedValue = info.getMeter().getMeterType().getValue() != 10;
            row.getCell(COL_ACCUMULATEDVALUE).getStyleAttributes().setLocked(canEditAccumlatedValue);
            if (!canEditAccumlatedValue) {
                row.getCell(COL_ACCUMULATEDVALUE).setValue((Object)new BigDecimal(0));
            }
        }
    }

    protected void removeRow(int rowIndex) {
        IRow row = this.tblMain.getRow(rowIndex);
        this.innerRecordLocked(row);
        super.removeRow(rowIndex);
    }

    protected void afterRemoveLine(List delList) {
        super.afterRemoveLine(delList);
        if (GeneCommonUtils.isEmpty((Collection)delList)) {
            return;
        }
        for (EquipmentReadingInfo readingInfo : delList) {
            if (readingInfo.getMeter() == null) continue;
            try {
                this.calc(readingInfo.getMeter());
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        super.loadLineFields(table, row, obj);
        EquipmentReadingInfo info = (EquipmentReadingInfo)obj;
        EquipmentMeterInfo meterInfo = info.getMeter();
        if (meterInfo != null) {
            try {
                switch (meterInfo.getMeterType().getValue()) {
                    case 30: {
                        this.featureRowChange(row, info.getParent());
                        break;
                    }
                    default: {
                        this.serialRowChange(row, info.getParent());
                        if (info.getId() == null) break;
                        this.oldAccumulatedValueMap.put(info.getMeter().getNumber().toString(), info.getAccumulatedValue());
                    }
                }
                this.commonRowChange(row, info.getParent());
            }
            catch (Exception e) {
                this.handleException(e);
            }
        } else {
            row.getCell(COL_READINGWAY).getStyleAttributes().setLocked(true);
        }
    }

    protected void setDataCollection(IObjectCollection collection) {
        if (GeneCommonUtils.isEmpty((Object)collection)) {
            return;
        }
        for (EquipmentReadingInfo readingInfo : collection) {
            this.existMap.put(readingInfo.getMeter().getId(), readingInfo.clone());
            this.setDefaultValue(readingInfo);
        }
        super.setDataCollection(collection);
    }

    private void setDefaultValue(EquipmentReadingInfo readingInfo) {
        readingInfo.setOprStatus((short)2);
        readingInfo.setPreReadingDate(readingInfo.getReadingDate());
        readingInfo.setPreValue(readingInfo.getCurrentValue());
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        readingInfo.setReadingDate(Timestamp.valueOf(sd.format(GeneDateUtils.nowTime())));
        readingInfo.setStepValues(null);
        readingInfo.setCurrentValue(null);
        readingInfo.setSrcBill(null);
        readingInfo.setSrcBillType(EqmSrcBillTypeEnum.NULL);
    }

    protected IObjectValue newInstanceData() {
        EquipmentReadingInfo info = new EquipmentReadingInfo();
        info.setStorageOrgUnit((StorageOrgUnitInfo)this.getDefaultMainBizOrg());
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setReadingWay(ReadingWayEnum.Actural);
        info.setAccumulatedValue(new BigDecimal(0));
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        info.setReadingDate(Timestamp.valueOf(sd.format(GeneDateUtils.nowTime())));
        info.setActivedStatus(true);
        info.put("feature", String.valueOf(System.currentTimeMillis()));
        if (this.prmptLocation.getValue() != null && this.prmptEquipment.getValue() == null) {
            info.setLocation((EquipmentLocationInfo)this.prmptLocation.getValue());
        }
        if (this.prmptEquipment.getValue() != null) {
            info.setEquipment((EquipmentArchivesInfo)this.prmptEquipment.getValue());
        }
        if (this.prmptSrcBill.getValue() != null) {
            if (this.prmptSrcBill.getValue() instanceof WorkOrderInfo) {
                info.setSrcBill(((WorkOrderInfo)this.prmptSrcBill.getValue()).getId().toString());
                info.setSrcBillType(EqmSrcBillTypeEnum.WORKORDER);
            } else {
                info.setSrcBill(((CheckingPlanningInfo)this.prmptSrcBill.getValue()).getId().toString());
                info.setSrcBillType(EqmSrcBillTypeEnum.POINTINSPECTION);
            }
        }
        return info;
    }

    protected void processResult(GeneBatchResult result) throws Exception {
        if (GeneCommonUtils.isEmpty((Object)result)) {
            throw new Exception(EASResource.getString((String)"com.kingdee.eas.eqm.basedata.BASEDATAAutoGenerateResource", (String)"70_EquipmentReadingEditUI"));
        }
        StringBuffer headlineMsg = result.getHeadMsg();
        StringBuffer detailMsg = result.getDetailMsg();
        if (detailMsg != null && detailMsg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)headlineMsg.toString(), (String)detailMsg.toString(), (int)1);
        } else {
            this.setIsShowTextOnly(false);
            this.setMessageText(this.getClassAlise() + " " + EASResource.getString((String)"com.kingdee.eas.eqm.common.core.GeneResource", (String)"BatchSuccessSimpleMsg"));
            this.setNextMessageText("");
            this.setShowMessagePolicy(0);
            this.showMessage();
            this.actionQuery_actionPerformed(null);
        }
    }

    private void innerRecordLocked(IRow row) {
        if (row.getStyleAttributes().isLocked()) {
            MsgBox.showInfo((String)EASResource.getString((String)this.getResourceName(), (String)"InputReadingRecordLocked"));
            SysUtil.abort();
        }
    }

    protected void beforeSubmit(List updateCollection) {
        super.beforeSubmit(updateCollection);
        if (GeneCommonUtils.isEmpty((Collection)updateCollection)) {
            return;
        }
        Iterator iter = this.existMap.keySet().iterator();
        try {
            while (iter.hasNext()) {
                BOSUuid key = (BOSUuid)iter.next();
                EquipmentReadingInfo info = (EquipmentReadingInfo)this.existMap.get(key);
                ArrayList<EquipmentReadingInfo> sameRows = new ArrayList<EquipmentReadingInfo>();
                Iterator it = updateCollection.iterator();
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (obj instanceof String) {
                        it.remove();
                        continue;
                    }
                    EquipmentReadingInfo tmpInfo = (EquipmentReadingInfo)obj;
                    if (!GeneEqualsUtils.equals((Object)info.getMeter(), (Object)tmpInfo.getMeter())) continue;
                    sameRows.add(tmpInfo);
                }
                this.innerVerifyDate(info.getMeter(), sameRows);
                this.calcMeterNo(info.getMeter(), sameRows);
            }
        }
        catch (Exception e) {
            this.handleException(e);
            SysUtil.abort();
        }
    }

    private void calcMeterNo(EquipmentMeterInfo meter, List sameRows) throws EASBizException, BOSException {
        boolean isSerial;
        this.sortByMeterNoAndReadingDate(sameRows);
        EquipmentReadingInfo existReading = (EquipmentReadingInfo)this.existMap.get(meter.getId());
        Iterator iter = sameRows.iterator();
        String maxNo = null;
        if (existReading.getMeterNo() == null) {
            maxNo = null;
        } else {
            String[] args = StringUtil.split((String)existReading.getMeterNo(), (String)NO_SPLIT);
            maxNo = args[args.length - 1];
        }
        boolean bl = isSerial = meter.getMeterType().getValue() == 10;
        while (iter.hasNext()) {
            Object obj;
            EquipmentReadingInfo tmp = (EquipmentReadingInfo)iter.next();
            tmp.setActivedStatus(false);
            if (isSerial && (tmp.getReadingWay().getValue() == 40 || tmp.getReadingWay().getValue() == 30) || !isSerial && maxNo == null) {
                maxNo = this.getNewMeterNo(maxNo);
                tmp.setOprStatus((short)1);
                tmp.setModify(true);
                tmp.setId(null);
            }
            if (this.getEntityType() == 3 && (obj = this.getUIContext().get("ENTITYVALUE")) instanceof WorkOrderInfo) {
                tmp.setSrcBill(((WorkOrderInfo)obj).getId().toString());
                tmp.setSrcBillType(EqmSrcBillTypeEnum.WORKORDER);
            }
            if (this.getEntityType() == 5 && (obj = this.getUIContext().get("ENTITYVALUE")) instanceof CheckingPlanningCpTaskInfo) {
                tmp.setSrcBill(((CheckingPlanningCpTaskInfo)obj).getId().toString());
                tmp.setSrcBillType(EqmSrcBillTypeEnum.POINTINSPECTION);
            }
            tmp.setMeterNo(tmp.getMeter().getNumber() + NO_SPLIT + maxNo);
        }
    }

    private String getNewMeterNo(String maxLongNumber) throws EASBizException, BOSException {
        String currentLongNumber = null;
        if (maxLongNumber == null) {
            currentLongNumber = currentLongNumber == null || currentLongNumber.length() <= 0 ? "1001" : currentLongNumber + "!" + "1001";
        } else {
            String last5 = "";
            last5 = maxLongNumber.length() > 5 ? maxLongNumber.substring(maxLongNumber.length() - 4, maxLongNumber.length()) : maxLongNumber;
            int i = Integer.parseInt(last5, 36) + 1;
            if (i > 9999) {
                currentLongNumber = (GeneCommonUtils.isEmpty((String)currentLongNumber) ? "" : "!") + Integer.toString(i, 36);
            } else if (i >= 0 && i <= 9) {
                currentLongNumber = (GeneCommonUtils.isEmpty((String)currentLongNumber) ? "" : "!") + "000" + i;
            } else if (i >= 10 && i <= 99) {
                currentLongNumber = (GeneCommonUtils.isEmpty((String)currentLongNumber) ? "" : "!") + "00" + i;
            } else if (i >= 100 && i <= 999) {
                currentLongNumber = (GeneCommonUtils.isEmpty((String)currentLongNumber) ? "" : "!") + "0" + i;
            } else if (i >= 1000 && i <= 9999) {
                currentLongNumber = (GeneCommonUtils.isEmpty((String)currentLongNumber) ? "" : "!") + "" + i;
            }
        }
        return currentLongNumber;
    }

    protected void afterSubmit(List updateCollection, GeneBatchResult result) {
        super.afterSubmit(updateCollection, result);
        if (result.getAddInfo().get("parent") != null) {
            try {
                this.openStatusMsg((String)result.getAddInfo().get("parent"));
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        this.isModify = false;
    }

    private void openStatusMsg(String parent) throws EASBizException, BOSException {
        if (this.canOpen(parent)) {
            UIContext uictx = new UIContext((Object)this);
            uictx.put((Object)"PARENTMONTOR", (Object)parent);
            String uimode = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
            UICreator.create((String)"com.kingdee.eas.eqm.basedata.client.EquipmentStatusMontorMsgListUI", (String)uimode, (UIContext)uictx);
        }
    }

    private boolean canOpen(String parent) throws EASBizException, BOSException {
        if (parent == null) {
            return false;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("receiver", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo(COL_ID, (Object)("Select b.fid from T_EQM_EquipmentStatusDetect a,T_EQM_EquipmentStatusMontorMsg b where  a.fid in (" + parent + ") and  a.fid = b.fparentid and a.FLastTriggerDate = b.FReadingDate"), CompareType.INNER));
        return EquipmentStatusMontorMsgFactory.getRemoteInstance().exists(filter);
    }

    protected boolean verifyInput() throws Exception {
        KDTEditManager editManager = this.tblMain.getEditManager();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            if (row.getCell(COL_METER_NUMBER).getValue() == null || !(row.getCell(COL_METER_NUMBER).getValue() instanceof EquipmentMeterInfo)) {
                MsgBox.showInfo((String)GeneMultiLangUtils.getMultiLangString((String)this.getResourceName(), (String)"InputReadingMeterCannotnull", (String[])new String[]{String.valueOf(i + 1)}));
                editManager.editCellAt(i, row.getCell(COL_METER_NUMBER).getColumnIndex());
                return false;
            }
            if (row.getCell(COL_CURRENTVALUE).getValue() == null) {
                MsgBox.showInfo((String)GeneMultiLangUtils.getMultiLangString((String)this.getResourceName(), (String)"CURRENTVALUECANNOTNULL", (String[])new String[]{String.valueOf(i + 1)}));
                editManager.editCellAt(i, row.getCell(COL_CURRENTVALUE).getColumnIndex());
                return false;
            }
            if (row.getCell(COL_READINGWAY).getValue() == null || !(row.getCell(COL_READINGWAY).getValue() instanceof ReadingWayEnum)) {
                MsgBox.showInfo((String)GeneMultiLangUtils.getMultiLangString((String)this.getResourceName(), (String)"READINGWAYCANNOTNULL", (String[])new String[]{String.valueOf(i + 1)}));
                editManager.editCellAt(i, row.getCell(COL_READINGWAY).getColumnIndex());
                return false;
            }
            if (row.getCell(COL_READINGDATE).getValue() != null) continue;
            MsgBox.showInfo((String)GeneMultiLangUtils.getMultiLangString((String)this.getResourceName(), (String)"READINGDATECANNOTNULL", (String[])new String[]{String.valueOf(i + 1)}));
            editManager.editCellAt(i, row.getCell(COL_READINGDATE).getColumnIndex());
            return false;
        }
        return super.verifyInput();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return this.getInnerSelectors();
    }

    protected boolean isIgnoreOrgFilter() {
        return true;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.setVisible(false);
        this.actionUnAudit.setVisible(false);
        this.actionQuery.setVisible(false);
        try {
            boolean enabledComponent = this.getEntityType() == 0;
            this.prmptEquipment.setEnabled(enabledComponent);
            this.prmptLocation.setEnabled(enabledComponent);
            this.prmptSrcBill.setEnabled(enabledComponent);
            this.actionInsertLine.setVisible(false);
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        GeneMenuUtils.hideMenu((KDMenuBar)this.menuBar);
        this.actionSubmit.setEnabled(true);
    }

    public int getEntityType() throws EASBizException {
        Object obj = this.getUIContext().get("ENTITYTYPE");
        if (obj != null) {
            return (Integer)obj;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoreBaseInfo getEntityValue() throws EASBizException {
        Object obj = this.getUIContext().get("ENTITYVALUE");
        if (obj != null) {
            if (obj instanceof WorkOrderInfo) {
                WorkOrderInfo info = (WorkOrderInfo)obj;
                if (info.getEqmLocation() != null && info.getEquipmentArchives() != null || info.getEqmLocation() == null && info.getEquipmentArchives() != null) {
                    return info.getEquipmentArchives();
                }
                if (info.getEquipmentArchives() != null || info.getEqmLocation() == null) return null;
                return info.getEqmLocation();
            }
            if (!(obj instanceof CheckingPlanningCpTaskInfo)) return (CoreBaseInfo)obj;
            CheckingPlanningCpTaskInfo info = (CheckingPlanningCpTaskInfo)obj;
            CheckingPlanningInfo entityInfo = (CheckingPlanningInfo)this.getUIContext().get("ENTITY");
            if (info.getAchieves() != null && info.getLocation() != null || info.getLocation() == null && info.getAchieves() != null) {
                return info.getAchieves();
            }
            if (info.getAchieves() == null && info.getLocation() != null) {
                return info.getLocation();
            }
            info.setTaskDescription(entityInfo.getDescription());
            return null;
        } else {
            if (this.prmptEquipment.getValue() != null) {
                return (CoreBaseInfo)this.prmptEquipment.getValue();
            }
            if (this.prmptLocation.getValue() == null) return null;
            return (CoreBaseInfo)this.prmptLocation.getValue();
        }
    }

    public String getEntityFieldName() throws EASBizException {
        if (this.getEntityValue() instanceof EquipmentArchivesInfo) {
            return "equipment.id";
        }
        if (this.getEntityValue() instanceof EquipmentLocationInfo) {
            return "location.id";
        }
        return "equipment.id";
    }

    private EquipmentMeterApplyInfo findParent(EquipmentReadingInfo readingInfo, EquipmentMeterInfo meter) throws BOSException, EASBizException {
        EquipmentMeterApplyInfo applyInfo = readingInfo.getParent();
        if (applyInfo != null) {
            return applyInfo;
        }
        if (this.getEntityValue() == null) {
            throw new RuntimeException("Error");
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo(this.getEntityFieldName(), (Object)this.getEntityValue().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("meter.id", (Object)meter.getId().toString()));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.addObjectCollection((IObjectCollection)GeneSelectorUtils.getSelector((BOSObjectType)new EquipmentMeterApplyInfo().getBOSType(), (String)"", (boolean)false));
        sic.addObjectCollection((IObjectCollection)GeneSelectorUtils.getSelector((BOSObjectType)new EquipmentMeterInfo().getBOSType(), (String)"meter", (boolean)false));
        sic.add(new SelectorItemInfo("meter.unit.qtyPrecision"));
        viewInfo.setSelector(sic);
        EquipmentMeterApplyCollection col = EquipmentMeterApplyFactory.getRemoteInstance().getEquipmentMeterApplyCollection(viewInfo);
        if (col.size() > 0) {
            applyInfo = col.get(0);
            readingInfo.setParent(applyInfo);
            return applyInfo;
        }
        return null;
    }

    private void calc(EquipmentMeterInfo meterInfo) throws EASBizException, BOSException {
        if (meterInfo == null || meterInfo.getMeterType() == null || meterInfo.getMeterType().getValue() == 30 || meterInfo.getMeterType().getValue() == 20) {
            return;
        }
        ArrayList<EquipmentReadingInfo> sameRows = new ArrayList<EquipmentReadingInfo>();
        int n = this.tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow tmpRow = this.tblMain.getRow(i);
            EquipmentReadingInfo info = (EquipmentReadingInfo)tmpRow.getUserObject();
            this.storeLineFields(this.tblMain, tmpRow, (IObjectValue)info);
            if (!GeneEqualsUtils.equals((Object)info.getMeter(), (Object)meterInfo)) continue;
            info.put("LineNumer", new Integer(i));
            sameRows.add(info);
        }
        EquipmentReadingInfo existReading = (EquipmentReadingInfo)this.existMap.get(meterInfo.getId());
        Iterator iter = sameRows.iterator();
        if (existReading == null) {
            return;
        }
        BigDecimal preValue = existReading.getCurrentValue() == null ? new BigDecimal(0) : NumericUtils.toBigDecimal((Object)existReading.getCurrentValue());
        Timestamp preReadingDate = existReading.getReadingDate();
        BigDecimal accumulatedValue = existReading.getAccumulatedValue();
        CountTypeEnum countType = meterInfo.getCountType();
        while (iter.hasNext()) {
            EquipmentReadingInfo info = (EquipmentReadingInfo)iter.next();
            info.setPreValue(preValue.toString());
            info.setPreReadingDate(preReadingDate);
            BigDecimal currentValue = info.getCurrentValue() == null ? new BigDecimal(0) : NumericUtils.toBigDecimal((Object)info.getCurrentValue());
            ReadingWayEnum readingWayEnum = info.getReadingWay();
            switch (readingWayEnum.getValue()) {
                case 10: {
                    if (countType.getValue() == 10) {
                        accumulatedValue = accumulatedValue.add(currentValue).subtract(NumericUtils.toBigDecimal((Object)preValue));
                        break;
                    }
                    if (countType.getValue() != 20) break;
                    accumulatedValue = accumulatedValue.subtract(currentValue).add(NumericUtils.toBigDecimal((Object)preValue));
                    break;
                }
                case 20: {
                    accumulatedValue = accumulatedValue.add(currentValue);
                    break;
                }
                case 40: {
                    accumulatedValue = info.getAccumulatedValue();
                    break;
                }
            }
            info.setAccumulatedValue(accumulatedValue);
            preValue = info.getCurrentValue() == null ? new BigDecimal(0) : NumericUtils.toBigDecimal((Object)info.getCurrentValue());
            preReadingDate = info.getReadingDate();
            accumulatedValue = info.getAccumulatedValue();
            Integer rowIndex = (Integer)info.get("LineNumer");
            this.tblMain.getRow(rowIndex.intValue()).getCell(COL_ACCUMULATEDVALUE).setValue((Object)accumulatedValue);
        }
    }

    private void innerVerifyDate(EquipmentMeterInfo meterInfo, List sameRows) throws EASBizException, BOSException {
        if (GeneCommonUtils.isEmpty((Collection)sameRows)) {
            return;
        }
        this.sortByMeterNoAndReadingDate(sameRows);
        EquipmentReadingInfo existReading = (EquipmentReadingInfo)this.existMap.get(meterInfo.getId());
        String meterNo = null;
        BigDecimal preValue = existReading.getCurrentValue() == null ? new BigDecimal(0) : NumericUtils.toBigDecimal((Object)existReading.getCurrentValue());
        Timestamp preReadingDate = existReading.getReadingDate();
        Timestamp initReadingDate = existReading.getInitDate();
        boolean right = true;
        boolean first = true;
        Iterator iter = sameRows.iterator();
        boolean isReplacementExist = false;
        boolean applyHaveReadingData = false;
        while (iter.hasNext()) {
            boolean canValid;
            EquipmentReadingInfo info = (EquipmentReadingInfo)iter.next();
            if (info.getReadingDate() == null) continue;
            if (info.getReadingWay().getValue() != 40 && initReadingDate != null && info.getReadingDate() != null && info.getReadingDate().compareTo(initReadingDate) < 0) {
                throw new EQMBaseDataException(EQMBaseDataException.CAN_NOT_ABOVE_INITDATE);
            }
            meterNo = info.getMeterNo();
            BigDecimal tmpCurrentValue = NumericUtils.toBigDecimal((Object)info.getCurrentValue());
            Timestamp currentReadingDate = info.getReadingDate();
            if (currentReadingDate != null && currentReadingDate.getTime() > System.currentTimeMillis()) {
                throw new EQMBaseDataException(EQMBaseDataException.CAN_NOT_AFTER_SYSTEMTIME);
            }
            if (preReadingDate != null && currentReadingDate != null && currentReadingDate.compareTo(preReadingDate) <= 0) {
                throw new EQMBaseDataException(EQMBaseDataException.CAN_NOT_ABOVE_PREDATE);
            }
            boolean bl = canValid = info.getMeter().getMeterType().getValue() == 10;
            if (canValid && info.getReadingWay().getValue() == 10) {
                Integer rowIndex;
                String msg;
                boolean isUp = 10 == info.getMeter().getCountType().getValue();
                KDTEditManager editManager = this.tblMain.getEditManager();
                if (first && preReadingDate != null && currentReadingDate.compareTo(preReadingDate) != 1) {
                    msg = MessageFormat.format(EASResource.getString((String)this.getResourceName(), (String)"InputReadingDateErrorMsg1"), meterInfo.getName(), preReadingDate, currentReadingDate);
                    MsgBox.showInfo((String)msg);
                    rowIndex = (Integer)info.get("LineNumer");
                    if (rowIndex != null) {
                        editManager.editCellAt(rowIndex.intValue(), this.tblMain.getColumn(COL_READINGDATE).getColumnIndex());
                    }
                    SysUtil.abort();
                }
                boolean bl2 = isUp ? tmpCurrentValue.compareTo(preValue) == 1 : (right = tmpCurrentValue.compareTo(preValue) == -1);
                if (!right) {
                    msg = MessageFormat.format(EASResource.getString((String)this.getResourceName(), (String)"InputReadingValueErrMsg"), meterInfo.getName(), preReadingDate, preValue, currentReadingDate, tmpCurrentValue, isUp ? EASResource.getString((String)this.getResourceName(), (String)"Up") : EASResource.getString((String)this.getResourceName(), (String)"Down"));
                    MsgBox.showInfo((String)msg);
                    rowIndex = (Integer)info.get("LineNumer");
                    if (rowIndex != null) {
                        editManager.editCellAt(rowIndex.intValue(), this.tblMain.getColumn(COL_CURRENTVALUE).getColumnIndex());
                    }
                    SysUtil.abort();
                }
            }
            preValue = tmpCurrentValue;
            preReadingDate = currentReadingDate;
            first = false;
            if (isReplacementExist) continue;
            isReplacementExist = info.getReadingWay().getValue() == 40;
        }
        EquipmentReadingInfo readingInfo = (EquipmentReadingInfo)sameRows.get(0);
        if (!applyHaveReadingData) {
            EquipmentMeterApplyInfo applyInfo = this.findParent(readingInfo, meterInfo);
            boolean bl = applyHaveReadingData = applyInfo.getCurrentValue() != null;
        }
        if (!isReplacementExist && !applyHaveReadingData && meterInfo.getMeterType().getValue() == 10) {
            String msg = MessageFormat.format(EASResource.getString((String)this.getResourceName(), (String)"MeterReplacementMustExist"), readingInfo.getMeter().getName());
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
    }

    private int isExist(IRow row, EquipmentMeterInfo meter) {
        int n = this.tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow tmpRow = this.tblMain.getRow(i);
            EquipmentReadingInfo info = (EquipmentReadingInfo)tmpRow.getUserObject();
            EquipmentMeterInfo tmp = (EquipmentMeterInfo)tmpRow.getCell(COL_METER_NUMBER).getValue();
            if (row.getRowIndex() == tmpRow.getRowIndex() || !GeneEqualsUtils.equals((Object)tmp, (Object)meter) || !info.isActivedStatus()) continue;
            return tmpRow.getRowIndex();
        }
        return -1;
    }

    private void sortByMeterNoAndReadingDate(List sameRows) {
        final DateFormat sd = CtrlFormatUtilities.getDateTimeFormat();
        Collections.sort(sameRows, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                EquipmentReadingInfo obj1 = (EquipmentReadingInfo)arg0;
                EquipmentReadingInfo obj2 = (EquipmentReadingInfo)arg1;
                return sd.format(obj1.getReadingDate()).compareTo(sd.format(obj2.getReadingDate()));
            }
        });
    }

    protected void addLine(KDTable table) {
        this.verifyEquipmentAndLocation();
        super.addLine(table);
    }

    protected void insertLine(KDTable table) {
        this.verifyEquipmentAndLocation();
        super.insertLine(table);
    }

    protected void copyLine(KDTable table) {
        this.verifyEquipmentAndLocation();
        super.copyLine(table);
    }

    protected void removeLine(KDTable table) {
        this.verifyEquipmentAndLocation();
        super.removeLine(table);
    }

    protected void afterMainOrgChanged(String oldOrgId, String newOrgId) {
        super.afterMainOrgChanged(oldOrgId, newOrgId);
        this.setDefaultValue();
    }

    private void setDefaultValue() {
        this.tblMain.removeRows(false);
        this.prmptEquipment.setValue(null);
        this.txtLocationName.setText(null);
        this.prmptLocation.setValue(null);
        this.txtEquipmentName.setText(null);
        this.prmptSrcBill.setValue(null);
        this.txtSrcBillName.setText(null);
    }

    public void verifyEquipmentAndLocation() {
        if (this.prmptEquipment.getValue() == null && this.prmptLocation.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.eqm.basedata.client.EquipmentReadingEditUIResource", (String)"Msg_PleaseChooseEquipmentOrLocation"));
            SysUtil.abort();
        }
    }

    public boolean isModify() {
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException e) {
            this.handleControlException();
            this.abort();
        }
        return this.isModify;
    }

    public void actionCopyLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain == null) {
            return;
        }
        if (this.tblMain.getSelectManager().size() == 0 || this.isTableColumnSelected(this.tblMain)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.eqm.basedata.BASEDATAAutoGenerateResource", (String)"71_EquipmentReadingEditUI"));
            return;
        }
        if (this.tblMain.getSelectManager().size() > 0) {
            IRow row = null;
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            for (int i = 0; i < selectRows.length; ++i) {
                ReadingWayEnum readingWay;
                if (selectRows[i] == -1 || !ReadingWayEnum.Replacement.equals((Object)(readingWay = (ReadingWayEnum)((Object)(row = this.tblMain.getRow(selectRows[i])).getCell(COL_READINGWAY).getValue()))) && !ReadingWayEnum.Reset.equals((Object)readingWay)) continue;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.eqm.basedata.BASEDATAAutoGenerateResource", (String)"72_EquipmentReadingEditUI"));
                return;
            }
        }
        super.actionCopyLine_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn(COL_READINGDATE).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateTimeFormatString());
    }
}

