/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.basedata.AbstractEquipmentReadingHistoryInfo;
import com.kingdee.eas.eqm.basedata.AbstractEquipmentReadingInfo;
import com.kingdee.eas.eqm.basedata.CountTypeEnum;
import com.kingdee.eas.eqm.basedata.EQMBaseDataException;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.basedata.EquipmentMeterApplyInfo;
import com.kingdee.eas.eqm.basedata.EquipmentMeterInfo;
import com.kingdee.eas.eqm.basedata.EquipmentReadingCollection;
import com.kingdee.eas.eqm.basedata.EquipmentReadingFactory;
import com.kingdee.eas.eqm.basedata.EquipmentReadingHistoryCollection;
import com.kingdee.eas.eqm.basedata.EquipmentReadingHistoryFactory;
import com.kingdee.eas.eqm.basedata.EquipmentReadingHistoryInfo;
import com.kingdee.eas.eqm.basedata.EquipmentReadingInfo;
import com.kingdee.eas.eqm.basedata.MeterTypeEnum;
import com.kingdee.eas.eqm.basedata.ReadingWayEnum;
import com.kingdee.eas.eqm.basedata.SerialMeterException;
import com.kingdee.eas.eqm.basedata.client.AbstractEquipmentReadingHistoryEditUI;
import com.kingdee.eas.eqm.common.core.GeneBatchResult;
import com.kingdee.eas.eqm.common.core.GeneDataBaseBatchInfo;
import com.kingdee.eas.eqm.common.core.IGeneDataBaseBatch;
import com.kingdee.eas.eqm.common.core.client.listener.AbstractGeneTableColumnListener;
import com.kingdee.eas.eqm.common.core.client.listener.GeneKDTable;
import com.kingdee.eas.eqm.common.core.client.listener.GeneTableColumnListener;
import com.kingdee.eas.eqm.common.core.client.table.TableCellComparator;
import com.kingdee.eas.eqm.common.core.util.GeneCommonUtils;
import com.kingdee.eas.eqm.common.core.util.GeneEqualsUtils;
import com.kingdee.eas.eqm.common.core.util.GeneListenerUtil;
import com.kingdee.eas.eqm.common.core.util.GeneMenuUtils;
import com.kingdee.eas.eqm.common.core.util.GeneMultiLangUtils;
import com.kingdee.eas.eqm.common.core.util.GeneSelectorUtils;
import com.kingdee.eas.eqm.common.core.util.GeneStringUtils;
import com.kingdee.eas.eqm.common.core.util.KDTableUtils;
import com.kingdee.eas.eqm.common.core.util.NumericUtils;
import com.kingdee.eas.eqm.common.core.util.backup.GeneHelper;
import com.kingdee.eas.eqm.common.eqmcore.client.util.ControlledItems;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class EquipmentReadingHistoryEditUI
extends AbstractEquipmentReadingHistoryEditUI {
    private static final Logger logger = CoreUIObject.getLogger(EquipmentReadingHistoryEditUI.class);
    public static final String TBL_Reading = "tblReading";
    public static final String COL_Reading_ID = "id";
    public static final String COL_Reading_METERNO = "meterNo";
    public static final String COL_Reading_INITDATE = "initDate";
    public static final String COL_Reading_INITVALUE = "initValue";
    public static final String COL_Reading_CURRENTVALUE = "currentValue";
    public static final String COL_Reading_READINGDATE = "readingDate";
    public static final String COL_Reading_ACCUMULATEDVALUE = "accumulatedValue";
    public static final String COL_Reading_ACTIVESTATUS = "activedStatus";
    public static final String TBL_TBLMAIN = "tblMain";
    public static final String COL_History_ID = "id";
    public static final String COL_History_READINGWAY = "readingWay";
    public static final String COL_History_CURRENTVALUE = "currentValue";
    public static final String COL_History_READINGDATE = "readingDate";
    public static final String COL_History_ACCUMULATEDVALUE = "accumulatedValue";
    public static final String COL_History_SRCBILLNUM = "srcBillNum";
    public static final String COL_History_CREATOR_NAME = "creator.name";
    public static final String COL_History_CREATETIME = "createTime";
    public static final String COL_History_INITVALUE = "initValue";
    public static final String COL_History_INITDATE = "initDate";
    public static final String COL_History_PREVALUE = "preValue";
    public static final String COL_History_PREREADINGDATE = "preReadingDate";
    public static final String COL_History_STEPVALUES = "stepValues";
    public static final String COL_History_SRCBILLTYPE = "srcBillType";
    public static final String COL_History_ALERTREADINGWAY = "alertReadingWay";
    private static final String HAVECALC = "haveCalc";
    private GeneKDTable readingHistoryTable = null;
    private HashMap precisionPool = new HashMap();
    private Map datas = new HashMap();
    private Map dataCopy = new HashMap();
    protected static final String RESOURCE_PATH = "com.kingdee.eas.eqm.basedata.EquipmentStatusAnalysisResource";

    public void onLoad() throws Exception {
        this.setOprtState("VIEW");
        super.onLoad();
        this.tblReading.getColumn("initDate").setRenderer((IBasicRender)EQMPromptDialogFactory.timeRenderer);
        this.tblReading.getColumn("readingDate").setRenderer((IBasicRender)EQMPromptDialogFactory.timeRenderer);
        this.tblMain.getColumn("readingDate").setRenderer((IBasicRender)EQMPromptDialogFactory.timeRenderer);
        this.tblMain.getColumn("initDate").setRenderer((IBasicRender)EQMPromptDialogFactory.timeRenderer);
        this.tblMain.getColumn(COL_History_PREREADINGDATE).setRenderer((IBasicRender)EQMPromptDialogFactory.timeRenderer);
        this.tblMain.getColumn(COL_History_CREATETIME).setRenderer((IBasicRender)EQMPromptDialogFactory.dateRenderer);
        this.actionRemoveLine.setEnabled(false);
        this.actionSubmit.setEnabled(false);
        this.lockContainer((Container)this.kDPanel3);
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.readingHistoryTable = new GeneKDTable(this.tblMain);
        this.prmptMeter.setRequired(true);
    }

    public BOSObjectType getBizObjectType() {
        return new EquipmentReadingHistoryInfo().getBOSType();
    }

    protected IMetaDataPK getMainQueryPK() {
        return new MetaDataPK("com.kingdee.eas.eqm.basedata.app.EquipmentReadingHistoryEditQuery");
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EquipmentReadingHistoryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    public KDTextField getNumTextField() {
        return null;
    }

    protected IObjectValue newInstanceData() {
        EquipmentReadingHistoryInfo info = new EquipmentReadingHistoryInfo();
        info.setStorageOrgUnit((StorageOrgUnitInfo)this.getDefaultMainBizOrg());
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        return info;
    }

    private boolean isEquipment() {
        return this.prmptEquipment.getValue() != null;
    }

    private boolean isLocation() {
        return this.prmptLocation.getValue() != null;
    }

    public String getEntityFieldName() throws EASBizException {
        if (this.isEquipment()) {
            return "equipment.id";
        }
        if (this.isLocation()) {
            return "location.id";
        }
        return null;
    }

    public int getEntityType() throws EASBizException {
        if (this.isEquipment()) {
            return 1;
        }
        if (this.isLocation()) {
            return 2;
        }
        return 0;
    }

    public CoreBaseInfo getEntityValue() throws EASBizException {
        if (this.isEquipment()) {
            return (CoreBaseInfo)this.prmptEquipment.getValue();
        }
        if (this.isLocation()) {
            return (CoreBaseInfo)this.prmptLocation.getValue();
        }
        return null;
    }

    public String getResourceName() {
        return "com.kingdee.eas.eqm.basedata.client.EquipmentReadingEditUIResource";
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmptmaintainOrg;
    }

    protected ControlledItems[] getNeedMainOrgControl() {
        return new ControlledItems[]{new ControlledItems(this.prmptEquipment, "history.orgID"), new ControlledItems(this.prmptLocation, "maintainOrgUnit.id")};
    }

    protected void initListener() {
        super.initListener();
        this.prmptEquipment.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EquipmentReadingHistoryEditUI.this.prmptEquipment_stateChanged(e);
            }
        });
        this.prmptLocation.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EquipmentReadingHistoryEditUI.this.prmptLocation_stateChanged(e);
            }
        });
        this.prmptMeter.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EquipmentReadingHistoryEditUI.this.prmptMeter_stateChanged(e);
            }
        });
        this.tblReading.addKDTDataRequestListener(new KDTDataRequestListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void tableDataRequest(KDTDataRequestEvent e) {
                try {
                    EquipmentReadingHistoryEditUI.this.tblReading_tableDataRequest(e);
                }
                catch (Exception exc) {
                    EquipmentReadingHistoryEditUI.this.handUIException(exc);
                }
            }
        });
        this.readingHistoryTable.addTableColumnListener((GeneTableColumnListener)new AbstractGeneTableColumnListener("currentValue"){

            public void tableColumnChanged(KDTEditEvent e) {
                EquipmentReadingHistoryEditUI.this.currentValueChange(e);
            }
        });
        this.readingHistoryTable.addTableColumnListener((GeneTableColumnListener)new AbstractGeneTableColumnListener("readingDate"){

            public void tableColumnChanged(KDTEditEvent e) {
                EquipmentReadingHistoryEditUI.this.readingDateChange(e);
            }
        });
        this.readingHistoryTable.addTableColumnListener((GeneTableColumnListener)new AbstractGeneTableColumnListener("accumulatedValue", true){

            public void tableColumnChanged(KDTEditEvent e) {
                EquipmentReadingHistoryEditUI.this.acculumatedValueChange(e);
            }
        });
        EventListener[] events = this.tblReading.getListenerList().getListeners(KDTSelectListener.class);
        if (events.length > 0) {
            this.tblReading.removeKDTSelectListener((KDTSelectListener)events[0]);
        }
        if ((events = this.tblMain.getListenerList().getListeners(KDTSelectListener.class)).length > 0) {
            this.tblMain.removeKDTSelectListener((KDTSelectListener)events[0]);
        }
    }

    protected void acculumatedValueChange(KDTEditEvent e) {
        if (this.isView()) {
            return;
        }
        try {
            if (GeneEqualsUtils.equals((Object)e.getOldValue(), (Object)e.getValue())) {
                return;
            }
            IRow row = this.tblMain.getRow(e.getRowIndex());
            this.calc(row, false, (BigDecimal)e.getOldValue() == null ? new BigDecimal(0) : e.getOldValue(), (BigDecimal)e.getValue() == null ? new BigDecimal(0) : e.getValue());
            this.refreshTable((EquipmentReadingHistoryInfo)row.getUserObject(), e.getColIndex());
        }
        catch (EQMBaseDataException e1) {
            this.handleException((Exception)((Object)e1));
            KDTEditManager editManager = this.tblMain.getEditManager();
            editManager.editCellAt(e.getRowIndex(), e.getColIndex());
        }
        catch (BOSException e1) {
            this.handleException((Exception)((Object)e1));
        }
        catch (EASBizException e1) {
            this.handleException((Exception)((Object)e1));
        }
    }

    protected void readingDateChange(KDTEditEvent e) {
        if (this.isView()) {
            return;
        }
        try {
            Timestamp nextMeterNoInitDate;
            EquipmentReadingHistoryInfo info;
            IRow row = this.tblMain.getRow(e.getRowIndex());
            DateFormat sd = CtrlFormatUtilities.getDateTimeFormat();
            if (e.getValue() == null) {
                MsgBox.showInfo((String)GeneMultiLangUtils.getMultiLangString((String)"com.kingdee.eas.eqm.basedata.client.EquipmentReadingEditUIResource", (String)"ReadingDateCannotBeNull"));
                row.getCell(e.getColIndex()).setValue(e.getOldValue());
                SysUtil.abort();
            }
            if (!(e.getValue() instanceof Timestamp)) {
                return;
            }
            Timestamp newValue = (Timestamp)e.getValue();
            if (newValue.compareTo((info = (EquipmentReadingHistoryInfo)row.getUserObject()).getInitDate()) < 0) {
                throw new EQMBaseDataException(EQMBaseDataException.CAN_NOT_BELOW_INITDATE);
            }
            EquipmentReadingInfo nextMeterNo = this.getNextMeterNoReading(info);
            Timestamp timestamp = nextMeterNoInitDate = nextMeterNo == null ? null : nextMeterNo.getInitDate();
            if (nextMeterNoInitDate != null && newValue.compareTo(nextMeterNoInitDate) > 0) {
                throw new EQMBaseDataException(EQMBaseDataException.CAN_NOT_ABOVE_NEXTINITDATE, new Object[]{info.getMeterNo(), sd.format(newValue), nextMeterNo.getMeterNo(), sd.format(nextMeterNoInitDate)});
            }
            info = this.findFromCache(info);
            info.setReadingDate(newValue);
            if (info.getMeter() == null || info.getMeter().getMeterType() == null || info.getMeter().getMeterType().getValue() == 30 || info.getMeter().getMeterType().getValue() == 20) {
                info.setOprStatus((short)2);
                info.setModify(true);
                this.addData(info, true);
                ArrayList<BOSUuid> l = new ArrayList<BOSUuid>();
                l.add(info.getParent().getId());
                this.updateMeterChangeRecord(l);
            }
            this.innerVerifyDate(info.getParent());
            this.calc(info);
            this.refreshTable(info, this.tblMain.getColumnIndex("readingDate"));
            this.sortTableByMeterNoAndReadingDate(this.tblMain, this.tblMain.getColumnIndex("readingDate"));
        }
        catch (Exception e1) {
            this.handleException(e1);
            this.readingHistoryTable.disableTableColumnListener("readingDate");
            this.tblMain.getCell(e.getRowIndex(), e.getColIndex()).setValue(e.getOldValue());
            this.readingHistoryTable.enabledTableColumnListener("readingDate");
            KDTEditManager editManager = this.tblMain.getEditManager();
            editManager.editCellAt(e.getRowIndex(), e.getColIndex());
        }
    }

    private void calc(EquipmentReadingHistoryInfo historyInfo) throws EASBizException, BOSException {
        if (historyInfo.getMeter() == null || historyInfo.getMeter().getMeterType() == null || historyInfo.getMeter().getMeterType().getValue() == 30 || historyInfo.getMeter().getMeterType().getValue() == 20) {
            List sameRows = this.getAllData(historyInfo);
            Collections.sort(sameRows, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    EquipmentReadingHistoryInfo obj1 = (EquipmentReadingHistoryInfo)arg0;
                    EquipmentReadingHistoryInfo obj2 = (EquipmentReadingHistoryInfo)arg1;
                    return obj1.getReadingDate().compareTo(obj2.getReadingDate());
                }
            });
            Iterator iter = sameRows.iterator();
            while (iter.hasNext()) {
                this.calcPreInfo((EquipmentReadingHistoryInfo)iter.next(), false);
            }
            iter = sameRows.iterator();
            return;
        }
        List sameRows = this.getAllData(historyInfo);
        Collections.sort(sameRows, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                EquipmentReadingHistoryInfo obj1 = (EquipmentReadingHistoryInfo)arg0;
                EquipmentReadingHistoryInfo obj2 = (EquipmentReadingHistoryInfo)arg1;
                return obj1.getReadingDate().compareTo(obj2.getReadingDate());
            }
        });
        Iterator iter = sameRows.iterator();
        EquipmentReadingHistoryInfo initInfo = (EquipmentReadingHistoryInfo)iter.next();
        BigDecimal preValue = initInfo.getStepValues() == null ? new BigDecimal(0) : NumericUtils.toBigDecimal((Object)initInfo.getStepValues());
        Timestamp preReadingDate = initInfo.getInitDate();
        BigDecimal accumulatedValue = initInfo.getAccumulatedValue();
        CountTypeEnum countType = historyInfo.getMeter().getCountType();
        boolean isReset = false;
        boolean isReplace = false;
        ArrayList<BOSUuid> list = new ArrayList<BOSUuid>();
        list.add(historyInfo.getParent().getId());
        while (iter.hasNext()) {
            EquipmentReadingHistoryInfo info = (EquipmentReadingHistoryInfo)iter.next();
            if (!isReplace) {
                boolean bl = isReplace = info.getReadingWay().getValue() == 40;
            }
            if (!isReplace) {
                info.setPreValue(preValue.toString());
                info.setPreReadingDate(preReadingDate);
                if (info.getReadingWay().getValue() == 10) {
                    info.setStepValues(info.getCurrentValue());
                } else if (info.getReadingWay().getValue() == 20) {
                    BigDecimal gapValue = NumericUtils.toBigDecimal((Object)info.getCurrentValue());
                    if (countType.getValue() == 20) {
                        gapValue = gapValue.multiply(new BigDecimal(-1));
                    }
                    info.setStepValues(NumericUtils.toBigDecimal((Object)info.getPreValue()).add(gapValue).toString());
                }
                info.setOprStatus((short)2);
                info.setModify(true);
            }
            if (!isReplace) {
                BigDecimal currentValue = info.getCurrentValue() == null ? new BigDecimal(0) : NumericUtils.toBigDecimal((Object)info.getCurrentValue());
                ReadingWayEnum readingWayEnum = info.getReadingWay();
                switch (readingWayEnum.getValue()) {
                    case 10: {
                        if (countType.getValue() == 10) {
                            accumulatedValue = accumulatedValue.add(currentValue).subtract(preValue == null ? new BigDecimal(0) : NumericUtils.toBigDecimal((Object)preValue));
                            break;
                        }
                        if (countType.getValue() != 20) break;
                        accumulatedValue = accumulatedValue.subtract(currentValue).add(preValue == null ? new BigDecimal(0) : NumericUtils.toBigDecimal((Object)preValue));
                        break;
                    }
                    case 20: {
                        accumulatedValue = accumulatedValue.add(currentValue);
                        break;
                    }
                    case 40: {
                        accumulatedValue = info.getAccumulatedValue();
                        break;
                    }
                }
                info.setAccumulatedValue(accumulatedValue);
                accumulatedValue = info.getAccumulatedValue();
                info.setOprStatus((short)2);
                info.setModify(true);
            }
            if (!isReplace) {
                preValue = info.getStepValues() == null ? new BigDecimal(0) : NumericUtils.toBigDecimal((Object)info.getStepValues());
                preReadingDate = info.getReadingDate();
            }
            if (!isReplace && !list.contains(info.getParent().getId())) {
                list.add(info.getParent().getId());
            }
            this.addData(info, true);
        }
        this.updateMeterChangeRecord(list);
    }

    private List getAllData(EquipmentReadingHistoryInfo info) throws EASBizException, BOSException {
        ArrayList<EquipmentReadingHistoryInfo> sameRows = new ArrayList<EquipmentReadingHistoryInfo>();
        Iterator iter = this.datas.keySet().iterator();
        EquipmentReadingInfo currentReadingInfo = (EquipmentReadingInfo)this.datas.get(info.getParent().getId());
        while (iter.hasNext()) {
            BOSUuid uuid = (BOSUuid)iter.next();
            EquipmentReadingInfo readingInfo = (EquipmentReadingInfo)this.datas.get(uuid);
            if (readingInfo.getReadingDate().compareTo(currentReadingInfo.getReadingDate()) < 0 || readingInfo.getOprStatus() == 3 || GeneCommonUtils.isEmpty((Object)readingInfo.getReadingHistory())) continue;
            for (EquipmentReadingHistoryInfo historyInfo : readingInfo.getReadingHistory()) {
                if (historyInfo.getOprStatus() == 3) continue;
                sameRows.add(historyInfo);
            }
        }
        this.queryData(info, sameRows, info.getInitDate());
        return sameRows;
    }

    private void calcPreInfo(EquipmentReadingHistoryInfo info, boolean isCalcAcculumated) {
        EquipmentReadingInfo readingInfo = null;
        readingInfo = info == null ? (EquipmentReadingInfo)this.datas.get(this.getSelectedReadingInfo().getId()) : (EquipmentReadingInfo)this.datas.get(info.getParent().getId());
        if (readingInfo == null || readingInfo.getReadingHistory() == null || readingInfo.getReadingHistory().size() <= 0) {
            return;
        }
        List sameRows = this.transHistoryToList(info);
        Iterator iter = sameRows.iterator();
        String preValue = null;
        Timestamp preReadingDate = null;
        BigDecimal stepValue = new BigDecimal(0);
        while (iter.hasNext()) {
            EquipmentReadingHistoryInfo historyInfo = (EquipmentReadingHistoryInfo)iter.next();
            if (historyInfo.getMeter().getMeterType() == MeterTypeEnum.serialMeter) {
                if (historyInfo.getOprStatus() == 3) continue;
                try {
                    this.calc(historyInfo);
                }
                catch (EASBizException e) {
                    this.handleException((Exception)((Object)e));
                }
                catch (BOSException e) {
                    this.handleException((Exception)((Object)e));
                }
                break;
            }
            if (historyInfo.getOprStatus() == 3) {
                historyInfo.setCurrentValue(null);
            }
            if (isCalcAcculumated) {
                historyInfo.setAccumulatedValue(stepValue);
                historyInfo.setStepValues(stepValue.toString());
            }
            historyInfo.setPreValue(preValue);
            historyInfo.setPreReadingDate(preReadingDate);
            preValue = historyInfo.getParent().getReadingWay().equals((Object)ReadingWayEnum.Increment) ? NumericUtils.toBigDecimal((Object)historyInfo.getCurrentValue()).add(NumericUtils.toBigDecimal((Object)preValue)).toString() : historyInfo.getCurrentValue();
            preReadingDate = historyInfo.getReadingDate();
            stepValue = NumericUtils.toBigDecimal((Object)historyInfo.getCurrentValue()).add(stepValue);
            historyInfo.setOprStatus((short)2);
            this.addData(historyInfo, true);
        }
    }

    private List transHistoryToList(EquipmentReadingHistoryInfo historyInfo) {
        EquipmentReadingInfo readingInfo = (EquipmentReadingInfo)this.datas.get(historyInfo.getParent().getId());
        ArrayList<EquipmentReadingHistoryInfo> sameRows = new ArrayList<EquipmentReadingHistoryInfo>();
        for (EquipmentReadingHistoryInfo historyInfo2 : readingInfo.getReadingHistory()) {
            if (historyInfo2.getOprStatus() == 3) continue;
            sameRows.add(historyInfo2);
        }
        Collections.sort(sameRows, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                EquipmentReadingHistoryInfo obj1 = (EquipmentReadingHistoryInfo)arg0;
                EquipmentReadingHistoryInfo obj2 = (EquipmentReadingHistoryInfo)arg1;
                return obj1.getReadingDate().compareTo(obj2.getReadingDate());
            }
        });
        return sameRows;
    }

    protected void currentValueChange(KDTEditEvent e) {
        if (this.isView()) {
            return;
        }
        try {
            if (e.getOldValue() != null && e.getValue() != null) {
                BigDecimal oldValue = null;
                if (GeneStringUtils.isNumber((String)e.getOldValue().toString())) {
                    oldValue = NumericUtils.toBigDecimal((Object)e.getOldValue().toString());
                }
                BigDecimal newValue = null;
                if (GeneStringUtils.isNumber((String)e.getValue().toString())) {
                    newValue = NumericUtils.toBigDecimal((Object)e.getValue().toString());
                }
                if (oldValue != null && newValue != null && oldValue.compareTo(newValue) == 0) {
                    return;
                }
            }
            IRow row = this.tblMain.getRow(e.getRowIndex());
            this.dataCopy = this.cloneCache();
            this.calc(row, true, e.getOldValue() == null ? "0" : e.getOldValue(), e.getValue() == null ? "0" : e.getValue());
            this.refreshTable((EquipmentReadingHistoryInfo)row.getUserObject(), e.getColIndex());
        }
        catch (SerialMeterException e1) {
            this.datas = this.dataCopy;
            this.handleException((Exception)((Object)e1));
            this.refreshTable((EquipmentReadingHistoryInfo)this.tblMain.getRow(e.getRowIndex()).getUserObject(), e.getColIndex());
        }
        catch (EQMBaseDataException e1) {
            this.handleException((Exception)((Object)e1));
            this.readingHistoryTable.disableTableColumnListener("currentValue");
            this.tblMain.getCell(e.getRowIndex(), e.getColIndex()).setValue(e.getOldValue());
            this.readingHistoryTable.enabledTableColumnListener("currentValue");
        }
        catch (BOSException e1) {
            this.handleException((Exception)((Object)e1));
            this.readingHistoryTable.disableTableColumnListener("currentValue");
            this.tblMain.getCell(e.getRowIndex(), e.getColIndex()).setValue(e.getOldValue());
            this.readingHistoryTable.enabledTableColumnListener("currentValue");
        }
        catch (EASBizException e1) {
            this.handleException((Exception)((Object)e1));
            this.readingHistoryTable.disableTableColumnListener("currentValue");
            this.tblMain.getCell(e.getRowIndex(), e.getColIndex()).setValue(e.getOldValue());
            this.readingHistoryTable.enabledTableColumnListener("currentValue");
        }
    }

    private Map cloneCache() {
        HashMap<BOSUuid, Object> cloneMap = new HashMap<BOSUuid, Object>();
        for (Object obj : this.datas.keySet()) {
            EquipmentReadingInfo data = (EquipmentReadingInfo)this.datas.get(obj);
            if (data == null) continue;
            cloneMap.put(BOSUuid.read((String)obj.toString()), data.clone());
        }
        return cloneMap;
    }

    protected void beforeRemoveLine(List delList) {
        super.beforeRemoveLine(delList);
        if (GeneCommonUtils.isEmpty((Collection)delList)) {
            return;
        }
        for (EquipmentReadingHistoryInfo historyInfo : delList) {
            if (this.canRemove(historyInfo)) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.eqm.basedata.client.EquipmentReadingEditUIResource", (String)"History_CannotDeleteDuetoExistsValue"));
            SysUtil.abort();
            break;
        }
    }

    protected void removeRow(int rowIndex) {
        if (this.isView()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.eqm.basedata.client.EquipmentReadingEditUIResource", (String)"History_CannotDeleteDuetoViewStatus"));
            SysUtil.abort();
        }
        try {
            boolean isSerial;
            IRow row = this.tblMain.getRow(rowIndex);
            EquipmentReadingHistoryInfo historyInfo = (EquipmentReadingHistoryInfo)row.getUserObject();
            if (!this.canRemove(historyInfo)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.eqm.basedata.client.EquipmentReadingEditUIResource", (String)"History_CannotDeleteDuetoExistsValue"));
                SysUtil.abort();
            }
            super.removeRow(rowIndex);
            historyInfo = this.findFromCache(historyInfo);
            if (historyInfo != null) {
                historyInfo.setOprStatus((short)3);
                historyInfo.setModify(true);
            }
            this.addData(historyInfo, true);
            EquipmentReadingInfo parent = (EquipmentReadingInfo)this.datas.get(historyInfo.getParent().getId());
            int meterType = parent.getMeter().getMeterType().getValue();
            if (meterType == 10) {
                if (this.isLastRecord(historyInfo)) {
                    EquipmentReadingHistoryInfo preHistoryInfo;
                    EquipmentReadingHistoryInfo nextHistoryInfo = this.findNextHistory(historyInfo, true);
                    if (nextHistoryInfo != null && nextHistoryInfo.getAccumulatedValue() != null) {
                        this.calc(false, nextHistoryInfo.getAccumulatedValue(), (Object)new BigDecimal(0), historyInfo);
                    }
                    if ((preHistoryInfo = this.findPreHistory(historyInfo, true)) != null && preHistoryInfo.getAccumulatedValue() != null) {
                        this.calc(false, new BigDecimal(0), (Object)preHistoryInfo.getAccumulatedValue(), historyInfo);
                    }
                }
                this.calcPreInfo(historyInfo, true);
            } else {
                this.calcInitDate(historyInfo);
            }
            historyInfo.setOprStatus((short)3);
            historyInfo.setModify(true);
            this.addData(historyInfo, true);
            boolean bl = isSerial = historyInfo.getMeter().getMeterType().getValue() == 10;
            if (isSerial && (historyInfo.getReadingWay().getValue() == 40 || historyInfo.getReadingWay().getValue() == 30) || !isSerial && this.tblMain.getRowCount() == 0) {
                parent.setOprStatus((short)3);
                parent.setModify(true);
                this.updateActiveStatus();
                this.refreshTable(null, 0);
            } else {
                ArrayList<BOSUuid> uuids = new ArrayList<BOSUuid>();
                uuids.add(historyInfo.getParent().getId());
                this.updateMeterChangeRecord(uuids);
                this.refreshTable(historyInfo, 0);
            }
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
    }

    private void calcInitDate(EquipmentReadingHistoryInfo info) {
        EquipmentReadingInfo readingInfo = null;
        readingInfo = info == null ? (EquipmentReadingInfo)this.datas.get(this.getSelectedReadingInfo().getId()) : (EquipmentReadingInfo)this.datas.get(info.getParent().getId());
        if (readingInfo == null || readingInfo.getReadingHistory() == null || readingInfo.getReadingHistory().size() <= 0) {
            return;
        }
        List sameRows = this.transHistoryToList(info);
        Iterator iter = sameRows.iterator();
        String preValue = null;
        Timestamp preReadingDate = null;
        EquipmentReadingHistoryInfo firstHistoryInfo = null;
        while (iter.hasNext()) {
            EquipmentReadingHistoryInfo historyInfo = (EquipmentReadingHistoryInfo)iter.next();
            if (historyInfo.getId().equals((Object)info.getId())) continue;
            if (this.isFirstRecord(historyInfo)) {
                firstHistoryInfo = historyInfo;
                historyInfo.setPreReadingDate(null);
                historyInfo.setPreValue(null);
            } else {
                historyInfo.setPreValue(preValue);
                historyInfo.setPreReadingDate(preReadingDate);
            }
            historyInfo.setInitDate(firstHistoryInfo.getReadingDate());
            historyInfo.setInitValue(firstHistoryInfo.getCurrentValue());
            preValue = historyInfo.getCurrentValue();
            preReadingDate = historyInfo.getReadingDate();
            historyInfo.setOprStatus((short)2);
            this.addData(historyInfo, true);
        }
    }

    private void updateActiveStatus() {
        EquipmentReadingInfo maxReadingInfo = this.findMaxReadingInfo();
        if (maxReadingInfo == null) {
            return;
        }
        maxReadingInfo.setActivedStatus(true);
        this.datas.put(maxReadingInfo.getId(), maxReadingInfo);
        for (BOSUuid uuid : this.datas.keySet()) {
            EquipmentReadingInfo readingInfo = (EquipmentReadingInfo)this.datas.get(uuid);
            if (readingInfo.getOprStatus() == 3 || readingInfo.getId().equals((Object)maxReadingInfo.getId())) continue;
            readingInfo.setActivedStatus(false);
            this.datas.put(readingInfo.getId(), readingInfo);
        }
    }

    private EquipmentReadingInfo findMaxReadingInfo() {
        Iterator iter = this.datas.keySet().iterator();
        AbstractEquipmentReadingInfo maxReadingInfo = null;
        while (iter.hasNext()) {
            BOSUuid uuid = (BOSUuid)iter.next();
            EquipmentReadingInfo readingInfo = (EquipmentReadingInfo)this.datas.get(uuid);
            if (readingInfo.getOprStatus() == 3 || maxReadingInfo != null && maxReadingInfo.getReadingDate().compareTo(readingInfo.getReadingDate()) >= 0) continue;
            maxReadingInfo = readingInfo;
        }
        return maxReadingInfo;
    }

    private boolean canRemove(EquipmentReadingHistoryInfo historyInfo) {
        if (historyInfo != null && (historyInfo.getReadingWay().getValue() == 40 || historyInfo.getReadingWay().getValue() == 30)) {
            EquipmentReadingInfo readingInfo = (EquipmentReadingInfo)this.datas.get(historyInfo.getParent().getId());
            if (readingInfo.getReadingHistory() != null) {
                for (EquipmentReadingHistoryInfo info : readingInfo.getReadingHistory()) {
                    if (info.getId().equals((Object)historyInfo.getId()) || info.getOprStatus() == 3) continue;
                    return false;
                }
            }
        } else {
            int meterType = historyInfo.getMeter().getMeterType().getValue();
            if (meterType == 20 || meterType == 30) {
                EquipmentReadingInfo readingInfo = (EquipmentReadingInfo)this.datas.get(historyInfo.getParent().getId());
                EquipmentReadingHistoryInfo tmp = this.findFirstReadingHistoryInfo(readingInfo);
                return !this.isFirstRecord(historyInfo) || tmp.getId().equals((Object)historyInfo.getId());
            }
        }
        return true;
    }

    public boolean isFirstRecord(EquipmentReadingHistoryInfo historyInfo) {
        EquipmentReadingInfo readingInfo = (EquipmentReadingInfo)this.datas.get(historyInfo.getParent().getId());
        if (readingInfo.getReadingHistory() != null) {
            for (EquipmentReadingHistoryInfo info : readingInfo.getReadingHistory()) {
                if (info.getOprStatus() == 3 || info.getReadingDate().compareTo(historyInfo.getReadingDate()) >= 0 || info.getId().equals((Object)historyInfo.getId())) continue;
                return false;
            }
        }
        return true;
    }

    public EquipmentReadingHistoryInfo findNextHistory(EquipmentReadingHistoryInfo historyInfo, boolean findNextReading) throws EASBizException, BOSException {
        EquipmentReadingInfo readingInfo = (EquipmentReadingInfo)this.datas.get(historyInfo.getParent().getId());
        if (readingInfo.getReadingHistory() != null) {
            ArrayList<EquipmentReadingHistoryInfo> l = new ArrayList<EquipmentReadingHistoryInfo>();
            for (EquipmentReadingHistoryInfo pp : readingInfo.getReadingHistory()) {
                if (pp.getOprStatus() == 3 && !pp.getId().equals((Object)historyInfo.getId())) continue;
                l.add(pp);
            }
            Collections.sort(l, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    EquipmentReadingHistoryInfo obj1 = (EquipmentReadingHistoryInfo)arg0;
                    EquipmentReadingHistoryInfo obj2 = (EquipmentReadingHistoryInfo)arg1;
                    return obj1.getReadingDate().compareTo(obj2.getReadingDate());
                }
            });
            int index = l.indexOf(historyInfo);
            if (index > 0 && index < l.size() - 1) {
                return (EquipmentReadingHistoryInfo)l.get(index + 1);
            }
            if (findNextReading) {
                EquipmentReadingInfo preReadingInfo = null;
                ArrayList<EquipmentReadingInfo> l1 = new ArrayList<EquipmentReadingInfo>();
                for (BOSUuid uuid : this.datas.keySet()) {
                    EquipmentReadingInfo readingInfo2 = (EquipmentReadingInfo)this.datas.get(uuid);
                    if (readingInfo2.getOprStatus() == 3) continue;
                    l1.add(readingInfo2);
                }
                Collections.sort(l1, new Comparator(){

                    public int compare(Object arg0, Object arg1) {
                        EquipmentReadingInfo obj1 = (EquipmentReadingInfo)arg0;
                        EquipmentReadingInfo obj2 = (EquipmentReadingInfo)arg1;
                        return obj1.getReadingDate().compareTo(obj2.getReadingDate());
                    }
                });
                int index1 = l1.indexOf(readingInfo);
                if (index1 >= 0 && index1 < l1.size() - 1) {
                    List samedata;
                    preReadingInfo = (EquipmentReadingInfo)l1.get(index1 + 1);
                    if (GeneCommonUtils.isEmpty((Object)preReadingInfo.getReadingHistory()) && !GeneCommonUtils.isEmpty((Collection)(samedata = this.getAllData(historyInfo)))) {
                        for (EquipmentReadingHistoryInfo tmp : samedata) {
                            this.addData(tmp, false);
                        }
                    }
                    EquipmentReadingHistoryInfo info = this.findFirstReadingHistoryInfo(preReadingInfo);
                    return info;
                }
                return null;
            }
        }
        return null;
    }

    public EquipmentReadingHistoryInfo findPreHistory(EquipmentReadingHistoryInfo historyInfo, boolean findPreReading) throws EASBizException, BOSException {
        EquipmentReadingInfo readingInfo = (EquipmentReadingInfo)this.datas.get(historyInfo.getParent().getId());
        if (readingInfo.getReadingHistory() != null) {
            ArrayList<EquipmentReadingHistoryInfo> l = new ArrayList<EquipmentReadingHistoryInfo>();
            for (EquipmentReadingHistoryInfo pp : readingInfo.getReadingHistory()) {
                if (pp.getOprStatus() == 3 && !pp.getId().equals((Object)historyInfo.getId())) continue;
                l.add(pp);
            }
            Collections.sort(l, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    EquipmentReadingHistoryInfo obj1 = (EquipmentReadingHistoryInfo)arg0;
                    EquipmentReadingHistoryInfo obj2 = (EquipmentReadingHistoryInfo)arg1;
                    return obj1.getReadingDate().compareTo(obj2.getReadingDate());
                }
            });
            int index = l.indexOf(historyInfo);
            if (index > 0 && index < l.size()) {
                return (EquipmentReadingHistoryInfo)l.get(index - 1);
            }
            if (findPreReading) {
                EquipmentReadingInfo preReadingInfo = null;
                ArrayList l1 = new ArrayList();
                for (BOSUuid uuid : this.datas.keySet()) {
                    l1.add(this.datas.get(uuid));
                }
                Collections.sort(l1, new Comparator(){

                    public int compare(Object arg0, Object arg1) {
                        EquipmentReadingInfo obj1 = (EquipmentReadingInfo)arg0;
                        EquipmentReadingInfo obj2 = (EquipmentReadingInfo)arg1;
                        return obj1.getReadingDate().compareTo(obj2.getReadingDate());
                    }
                });
                int index1 = l1.indexOf(readingInfo);
                if (index1 > 0 && index1 < l1.size()) {
                    List samedata;
                    preReadingInfo = (EquipmentReadingInfo)l1.get(index1 - 1);
                    if (GeneCommonUtils.isEmpty((Object)preReadingInfo.getReadingHistory()) && !GeneCommonUtils.isEmpty((Collection)(samedata = this.getAllData(historyInfo)))) {
                        for (EquipmentReadingHistoryInfo tmp : samedata) {
                            this.addData(tmp, false);
                        }
                    }
                    EquipmentReadingHistoryInfo info = this.findLastReadingHistoryInfo(preReadingInfo);
                    return info;
                }
                return null;
            }
        }
        return null;
    }

    public EquipmentReadingHistoryInfo findFirstReadingHistoryInfo(EquipmentReadingInfo preReadingInfo) {
        if (preReadingInfo.getReadingHistory() == null || preReadingInfo.getReadingHistory().size() <= 0) {
            return null;
        }
        Iterator iter = preReadingInfo.getReadingHistory().iterator();
        AbstractEquipmentReadingHistoryInfo minReadingInfo = null;
        while (iter.hasNext()) {
            EquipmentReadingHistoryInfo readingInfo = (EquipmentReadingHistoryInfo)iter.next();
            if (readingInfo.getOprStatus() == 3 || minReadingInfo != null && minReadingInfo.getReadingDate().compareTo(readingInfo.getReadingDate()) <= 0) continue;
            minReadingInfo = readingInfo;
        }
        return minReadingInfo;
    }

    public EquipmentReadingHistoryInfo findLastReadingHistoryInfo(EquipmentReadingInfo preReadingInfo) {
        if (preReadingInfo.getReadingHistory() == null || preReadingInfo.getReadingHistory().size() <= 0) {
            return null;
        }
        Iterator iter = preReadingInfo.getReadingHistory().iterator();
        AbstractEquipmentReadingHistoryInfo maxReadingInfo = null;
        while (iter.hasNext()) {
            EquipmentReadingHistoryInfo readingInfo = (EquipmentReadingHistoryInfo)iter.next();
            if (readingInfo.getOprStatus() == 3 || maxReadingInfo != null && maxReadingInfo.getReadingDate().compareTo(readingInfo.getReadingDate()) >= 0) continue;
            maxReadingInfo = readingInfo;
        }
        return maxReadingInfo;
    }

    public boolean isLastRecord(EquipmentReadingHistoryInfo historyInfo) {
        EquipmentReadingInfo readingInfo = (EquipmentReadingInfo)this.datas.get(historyInfo.getParent().getId());
        if (readingInfo.getReadingHistory() != null) {
            for (EquipmentReadingHistoryInfo info : readingInfo.getReadingHistory()) {
                if (info.getOprStatus() == 3 || info.getReadingDate().compareTo(historyInfo.getReadingDate()) <= 0 || info.getId().equals((Object)historyInfo.getId())) continue;
                return false;
            }
        }
        return true;
    }

    private EquipmentReadingHistoryInfo findFromCache(EquipmentReadingHistoryInfo historyInfo) {
        EquipmentReadingInfo readingInfo = (EquipmentReadingInfo)this.datas.get(historyInfo.getParent().getId());
        if (GeneCommonUtils.isEmpty((Object)readingInfo.getReadingHistory())) {
            return null;
        }
        for (EquipmentReadingHistoryInfo readingHistoryInfo : readingInfo.getReadingHistory()) {
            if (!readingHistoryInfo.getId().equals((Object)historyInfo.getId())) continue;
            return readingHistoryInfo;
        }
        return null;
    }

    private void refreshTable(EquipmentReadingHistoryInfo readingHistoryInfo, int columnIndex) {
        EquipmentReadingInfo readingInfo = null;
        Iterator iter = this.datas.keySet().iterator();
        EquipmentReadingCollection readingCollection = new EquipmentReadingCollection();
        EquipmentReadingHistoryCollection readingHistoryCollection = new EquipmentReadingHistoryCollection();
        while (iter.hasNext()) {
            BOSUuid uuid = (BOSUuid)iter.next();
            EquipmentReadingInfo equipmentReadingInfo = (EquipmentReadingInfo)this.datas.get(uuid);
            if (equipmentReadingInfo.getOprStatus() == 3) continue;
            readingCollection.addObject((IObjectValue)equipmentReadingInfo);
            if (readingHistoryInfo == null) {
                readingInfo = equipmentReadingInfo;
                if (readingInfo.getReadingHistory() == null || readingInfo.getReadingHistory().size() <= 0) continue;
                readingHistoryInfo = (EquipmentReadingHistoryInfo)readingInfo.getReadingHistory().getObject(0);
                readingHistoryCollection = readingInfo.getReadingHistory();
                continue;
            }
            readingInfo = (EquipmentReadingInfo)this.datas.get(readingHistoryInfo.getParent().getId());
            if (!uuid.equals((Object)readingHistoryInfo.getParent().getId())) continue;
            readingHistoryCollection = equipmentReadingInfo.getReadingHistory();
        }
        this.tblReading.removeRows(false);
        this.tblReading.setUserObject((Object)readingCollection);
        this.loadCollectionFields(this.tblReading, (IObjectCollection)readingCollection);
        this.sortTableByMeterNoAndReadingDate(this.tblReading, this.tblReading.getColumnIndex("readingDate"));
        this.fixLocation(this.tblReading, (GeneDataBaseBatchInfo)readingInfo, -1);
        if (GeneCommonUtils.isEmpty((Object)((Object)readingHistoryCollection))) {
            this.doQuery();
        } else {
            this.tblMain.removeRows(false);
            this.loadCollectionFields((IObjectCollection)readingHistoryCollection);
            this.sortTableByMeterNoAndReadingDate(this.tblMain, this.tblMain.getColumnIndex("readingDate"));
            this.fixLocation(this.tblMain, (GeneDataBaseBatchInfo)readingHistoryInfo, columnIndex);
        }
    }

    private void sortTableByMeterNoAndReadingDate(KDTable table, int columnIndex) {
        List rows = table.getBody().getRows();
        Collections.sort(rows, new TableCellComparator(columnIndex, 0));
    }

    private void fixLocation(KDTable table, GeneDataBaseBatchInfo obj, int columnIndex) {
        if (table == null || obj == null || table.getRowCount() <= 0) {
            return;
        }
        int n = table.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = table.getRow(i);
            GeneDataBaseBatchInfo tmp = (GeneDataBaseBatchInfo)row.getUserObject();
            if (!tmp.getId().equals((Object)obj.getId())) continue;
            table.getSelectManager().select(row.getRowIndex(), columnIndex);
            table.getSelectManager().setActiveRowIndex(row.getRowIndex());
            break;
        }
        if (table.getName().equals(TBL_TBLMAIN)) {
            this.tblMain.getCell(0, "readingDate").getStyleAttributes().setLocked(true);
        }
    }

    private void calc(IRow row, boolean isCurrentValueChanged, Object beforeValue, Object newValue) throws BOSException, EASBizException {
        EquipmentReadingHistoryInfo info = (EquipmentReadingHistoryInfo)row.getUserObject();
        this.calc(isCurrentValueChanged, beforeValue, newValue, info);
    }

    private void calc(boolean isCurrentValueChanged, Object beforeValue, Object newValue, EquipmentReadingHistoryInfo info) throws BOSException, EASBizException {
        boolean isSerialMeter;
        List sameRows = this.getCalcDataRange(info, beforeValue, isCurrentValueChanged);
        if (GeneCommonUtils.isEmpty((Collection)sameRows)) {
            return;
        }
        Iterator it = sameRows.iterator();
        while (it.hasNext()) {
            EquipmentReadingHistoryInfo tmp = (EquipmentReadingHistoryInfo)it.next();
            if (tmp.getOprStatus() != 3) continue;
            it.remove();
        }
        Collections.sort(sameRows, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                EquipmentReadingHistoryInfo obj1 = (EquipmentReadingHistoryInfo)arg0;
                EquipmentReadingHistoryInfo obj2 = (EquipmentReadingHistoryInfo)arg1;
                return obj1.getReadingDate().compareTo(obj2.getReadingDate());
            }
        });
        boolean bl = isSerialMeter = info.getMeter().getMeterType().getValue() == 10;
        if (isSerialMeter) {
            BigDecimal currentValue = isCurrentValueChanged ? NumericUtils.toBigDecimal((Object)(newValue == null ? "0" : newValue)) : (BigDecimal)newValue;
            BigDecimal oldValue = isCurrentValueChanged ? NumericUtils.toBigDecimal((Object)beforeValue) : (BigDecimal)beforeValue;
            BigDecimal gapValue = currentValue.subtract(oldValue);
            switch (info.getReadingWay().getValue()) {
                case 10: {
                    this.updateOnActual(isCurrentValueChanged, gapValue, info, sameRows);
                    break;
                }
                case 20: {
                    this.updateOnIncrement(isCurrentValueChanged, gapValue, info, sameRows);
                    break;
                }
                case 40: {
                    this.updateOnReplacement(isCurrentValueChanged, gapValue, info, sameRows);
                    break;
                }
                case 30: {
                    this.updateOnReset(isCurrentValueChanged, gapValue, info, sameRows);
                }
            }
        } else {
            info.setStepValues(newValue == null ? null : newValue.toString());
            info.setOprStatus((short)2);
            info.setModify(true);
            info.setCurrentValue(info.getStepValues());
            this.addData(info, true);
            int index = 0;
            EquipmentReadingHistoryInfo firseHistoryInfo = (EquipmentReadingHistoryInfo)this.tblMain.getRow(0).getUserObject();
            boolean isInit = true;
            if (firseHistoryInfo.getReadingDate().compareTo(info.getReadingDate()) < 0) {
                isInit = false;
            }
            if (sameRows != null && sameRows.size() > 0) {
                int n = sameRows.size();
                while (index < n) {
                    EquipmentReadingHistoryInfo historyInfo = (EquipmentReadingHistoryInfo)sameRows.get(index);
                    if (historyInfo.getId().equals((Object)info.getId())) {
                        if (index < n - 1) {
                            EquipmentReadingHistoryInfo nextHistoryInfo = (EquipmentReadingHistoryInfo)sameRows.get(index + 1);
                            nextHistoryInfo.setPreValue(info.getStepValues());
                            nextHistoryInfo.setOprStatus((short)2);
                            nextHistoryInfo.setModify(true);
                            this.addData(nextHistoryInfo, true);
                            sameRows.set(index + 1, nextHistoryInfo);
                        }
                        sameRows.set(index, info);
                    }
                    if (isInit) {
                        historyInfo.setInitDate(info.getReadingDate());
                        historyInfo.setInitValue(info.getCurrentValue());
                        historyInfo.setOprStatus((short)2);
                        historyInfo.setModify(true);
                        this.addData(historyInfo, true);
                    }
                    ++index;
                }
            }
            EquipmentReadingInfo readingInfo = (EquipmentReadingInfo)this.datas.get(info.getParent().getId());
            if (index == sameRows.size() - 1) {
                readingInfo = (EquipmentReadingInfo)this.datas.get(info.getParent().getId());
                readingInfo.setAccumulatedValue(info.getAccumulatedValue());
                readingInfo.setPreValue(info.getPreValue());
                readingInfo.setPreReadingDate(info.getPreReadingDate());
                readingInfo.setInitDate(info.getInitDate());
                readingInfo.setInitValue(info.getInitValue());
                readingInfo.setCurrentValue(info.getStepValues());
                readingInfo.setReadingDate(info.getReadingDate());
            }
            if (this.isLastRecord(info)) {
                readingInfo = (EquipmentReadingInfo)this.datas.get(info.getParent().getId());
                readingInfo.setAccumulatedValue(info.getAccumulatedValue());
                readingInfo.setPreValue(info.getPreValue());
                readingInfo.setPreReadingDate(info.getPreReadingDate());
                readingInfo.setInitDate(info.getInitDate());
                readingInfo.setInitValue(info.getInitValue());
                readingInfo.setCurrentValue(info.getStepValues());
                readingInfo.setReadingDate(info.getReadingDate());
            }
            if (isInit) {
                readingInfo.setInitDate(info.getReadingDate());
                readingInfo.setInitValue(info.getCurrentValue());
            }
            readingInfo.setOprStatus((short)2);
            readingInfo.setModify(true);
        }
    }

    private void updateOnReset(boolean isCurrentValueChanged, BigDecimal gapValue, EquipmentReadingHistoryInfo info, List sameRows) {
        Iterator iter = sameRows.iterator();
        boolean isReset = false;
        boolean isReplace = false;
        String featureCode = HAVECALC + System.currentTimeMillis();
        EquipmentReadingInfo parent = (EquipmentReadingInfo)this.datas.get(info.getParent().getId());
        ReadingWayEnum parentReadingWay = parent.getParent().getReadingWay();
        CountTypeEnum typeEnum = info.getMeter().getCountType();
        BigDecimal tmpGapValue = gapValue;
        if (isCurrentValueChanged) {
            if (typeEnum.getValue() == 20) {
                tmpGapValue = tmpGapValue.multiply(new BigDecimal(1));
            } else if (typeEnum.getValue() == 10) {
                tmpGapValue = tmpGapValue.multiply(new BigDecimal(-1));
            }
        }
        ArrayList<BOSUuid> list = new ArrayList<BOSUuid>();
        list.add(info.getParent().getId());
        while (iter.hasNext() && !isReplace) {
            EquipmentReadingHistoryInfo historyInfo = (EquipmentReadingHistoryInfo)iter.next();
            if (historyInfo.getOprStatus() == 3) continue;
            boolean isCurrentObject = historyInfo.getId().equals((Object)info.getId());
            if (!isReset && !isCurrentObject) {
                boolean bl = isReset = historyInfo.getReadingWay().getValue() == 30 || historyInfo.getReadingWay().getValue() == 40;
            }
            if (!isReplace && !isCurrentObject) {
                boolean bl = isReplace = historyInfo.getReadingWay().getValue() == 40;
            }
            if (!isReset) {
                EquipmentReadingHistoryInfo nearestActualInfo;
                if (isCurrentObject) {
                    historyInfo.setCurrentValue(NumericUtils.toBigDecimal((Object)historyInfo.getCurrentValue()).add(gapValue).toString());
                    historyInfo.setStepValues(historyInfo.getCurrentValue());
                } else if (parentReadingWay.getValue() == 20) {
                    historyInfo.setPreValue(NumericUtils.toBigDecimal((Object)historyInfo.getPreValue()).add(gapValue).toString());
                    historyInfo.setStepValues(NumericUtils.toBigDecimal((Object)historyInfo.getStepValues()).add(gapValue).toString());
                } else if (parentReadingWay.getValue() == 10 && (nearestActualInfo = this.findNearestActualInfo(sameRows, info, parentReadingWay)).get(featureCode) == null) {
                    nearestActualInfo.setPreValue(NumericUtils.toBigDecimal((Object)nearestActualInfo.getPreValue()).add(gapValue).toString());
                    nearestActualInfo.setOprStatus((short)2);
                    nearestActualInfo.setModify(true);
                    nearestActualInfo.put(featureCode, featureCode);
                    this.addData(nearestActualInfo, true);
                }
                historyInfo.setOprStatus((short)2);
                historyInfo.setModify(true);
            }
            if (!isReset && historyInfo.getMeterNo().equalsIgnoreCase(info.getMeterNo())) {
                historyInfo.setInitValue(info.getCurrentValue());
                historyInfo.setInitDate(info.getReadingDate());
                historyInfo.setOprStatus((short)2);
                historyInfo.setModify(true);
            }
            if (!isReplace && !isCurrentObject && parentReadingWay.getValue() == 10) {
                historyInfo.setAccumulatedValue(historyInfo.getAccumulatedValue().add(tmpGapValue));
                historyInfo.setOprStatus((short)2);
                historyInfo.setModify(true);
            }
            this.addData(historyInfo, true);
            if (isReplace || info.getMeterNo().equals(historyInfo.getMeterNo()) || list.contains(historyInfo.getParent().getId())) continue;
            list.add(historyInfo.getParent().getId());
        }
        this.updateMeterChangeRecord(list);
    }

    private void updateOnReplacement(boolean isCurrentValueChanged, BigDecimal gapValue, EquipmentReadingHistoryInfo info, List sameRows) {
        Iterator iter = sameRows.iterator();
        boolean isReset = false;
        boolean isReplace = false;
        EquipmentReadingInfo parent = (EquipmentReadingInfo)this.datas.get(info.getParent().getId());
        ReadingWayEnum parentReadingWay = parent.getParent().getReadingWay();
        CountTypeEnum typeEnum = info.getMeter().getCountType();
        BigDecimal tmpGapValue = gapValue;
        if (isCurrentValueChanged) {
            if (typeEnum.getValue() == 20) {
                tmpGapValue = tmpGapValue.multiply(new BigDecimal(1));
            } else if (typeEnum.getValue() == 10) {
                tmpGapValue = tmpGapValue.multiply(new BigDecimal(-1));
            }
        }
        String featureCode = HAVECALC + System.currentTimeMillis();
        ArrayList<BOSUuid> list = new ArrayList<BOSUuid>();
        list.add(info.getParent().getId());
        while (iter.hasNext() && !isReplace) {
            EquipmentReadingHistoryInfo historyInfo = (EquipmentReadingHistoryInfo)iter.next();
            if (historyInfo.getOprStatus() == 3) continue;
            boolean isCurrentObject = historyInfo.getId().equals((Object)info.getId());
            if (!isReset && !isCurrentObject) {
                boolean bl = isReset = historyInfo.getReadingWay().getValue() == 30 || historyInfo.getReadingWay().getValue() == 40;
            }
            if (!isReplace && !isCurrentObject) {
                boolean bl = isReplace = historyInfo.getReadingWay().getValue() == 40;
            }
            if (isCurrentValueChanged) {
                if (!isReset) {
                    EquipmentReadingHistoryInfo nearestActualInfo;
                    if (isCurrentObject) {
                        historyInfo.setCurrentValue(NumericUtils.toBigDecimal((Object)historyInfo.getCurrentValue()).add(gapValue).toString());
                        historyInfo.setStepValues(historyInfo.getCurrentValue());
                    } else if (parentReadingWay.getValue() == 20) {
                        historyInfo.setPreValue(NumericUtils.toBigDecimal((Object)historyInfo.getPreValue()).add(gapValue).toString());
                        historyInfo.setStepValues(NumericUtils.toBigDecimal((Object)historyInfo.getStepValues()).add(gapValue).toString());
                    } else if (parentReadingWay.getValue() == 10 && (nearestActualInfo = this.findNearestActualInfo(sameRows, info, parentReadingWay)).get(featureCode) == null) {
                        nearestActualInfo.setPreValue(NumericUtils.toBigDecimal((Object)nearestActualInfo.getPreValue()).add(gapValue).toString());
                        nearestActualInfo.setOprStatus((short)2);
                        nearestActualInfo.setModify(true);
                        nearestActualInfo.put(featureCode, featureCode);
                        this.addData(nearestActualInfo, true);
                    }
                    historyInfo.setOprStatus((short)2);
                    historyInfo.setModify(true);
                }
                if (!isReset && historyInfo.getMeterNo().equalsIgnoreCase(info.getMeterNo())) {
                    historyInfo.setInitValue(NumericUtils.toBigDecimal((Object)historyInfo.getInitValue()).add(gapValue).toString());
                    historyInfo.setInitDate(info.getReadingDate());
                    historyInfo.setOprStatus((short)2);
                    historyInfo.setModify(true);
                }
                if (!isReplace && !isCurrentObject && parentReadingWay.getValue() == 10) {
                    historyInfo.setAccumulatedValue(historyInfo.getAccumulatedValue().add(tmpGapValue));
                    historyInfo.setOprStatus((short)2);
                    historyInfo.setModify(true);
                }
            } else if (!isReplace) {
                historyInfo.setAccumulatedValue(historyInfo.getAccumulatedValue().add(gapValue));
                historyInfo.setOprStatus((short)2);
                historyInfo.setModify(true);
            }
            this.addData(historyInfo, true);
            if (isReplace || info.getMeterNo().equals(historyInfo.getMeterNo()) || list.contains(historyInfo.getParent().getId())) continue;
            list.add(historyInfo.getParent().getId());
        }
        this.updateMeterChangeRecord(list);
    }

    private void updateOnIncrement(boolean isCurrentValueChanged, BigDecimal gapValue, EquipmentReadingHistoryInfo info, List sameRows) {
        Iterator iter = sameRows.iterator();
        boolean isReset = false;
        boolean isReplace = false;
        CountTypeEnum typeEnum = info.getMeter().getCountType();
        BigDecimal tmpGapValue = gapValue;
        if (isCurrentValueChanged && typeEnum.getValue() == 20) {
            tmpGapValue = tmpGapValue.multiply(new BigDecimal(-1));
        }
        ArrayList<BOSUuid> list = new ArrayList<BOSUuid>();
        list.add(info.getParent().getId());
        while (iter.hasNext() && !isReplace) {
            EquipmentReadingHistoryInfo historyInfo = (EquipmentReadingHistoryInfo)iter.next();
            if (historyInfo.getOprStatus() == 3) continue;
            boolean isCurrentObject = historyInfo.getId().equals((Object)info.getId());
            if (!isReset && !isCurrentObject) {
                boolean bl = isReset = historyInfo.getReadingWay().getValue() == 30 || historyInfo.getReadingWay().getValue() == 40;
            }
            if (!isReplace && !isCurrentObject) {
                boolean bl = isReplace = historyInfo.getReadingWay().getValue() == 40;
            }
            if (!isReset) {
                if (isCurrentObject) {
                    historyInfo.setCurrentValue(NumericUtils.toBigDecimal((Object)historyInfo.getCurrentValue()).add(gapValue).toString());
                } else {
                    historyInfo.setPreValue(NumericUtils.toBigDecimal((Object)historyInfo.getPreValue()).add(tmpGapValue).toString());
                }
                historyInfo.setStepValues(NumericUtils.toBigDecimal((Object)historyInfo.getStepValues()).add(tmpGapValue).toString());
                historyInfo.setOprStatus((short)2);
                historyInfo.setModify(true);
            }
            if (!isReplace) {
                historyInfo.setAccumulatedValue(historyInfo.getAccumulatedValue().add(gapValue));
                historyInfo.setOprStatus((short)2);
                historyInfo.setModify(true);
            }
            this.addData(historyInfo, true);
            if (isReplace || info.getMeterNo().equals(historyInfo.getMeterNo()) || list.contains(historyInfo.getParent().getId())) continue;
            list.add(historyInfo.getParent().getId());
        }
        this.updateMeterChangeRecord(list);
    }

    private void updateOnActual(boolean isCurrentValueChanged, BigDecimal gapValue, EquipmentReadingHistoryInfo info, List sameRows) throws SerialMeterException {
        Iterator iter = sameRows.iterator();
        boolean isReset = false;
        boolean isReplace = false;
        ArrayList<BOSUuid> list = new ArrayList<BOSUuid>();
        list.add(info.getParent().getId());
        CountTypeEnum typeEnum = info.getMeter().getCountType();
        BigDecimal tmpGapValue = gapValue;
        if (isCurrentValueChanged && typeEnum.getValue() == 20) {
            tmpGapValue = tmpGapValue.multiply(new BigDecimal(-1));
        }
        while (iter.hasNext() && !isReplace) {
            EquipmentReadingHistoryInfo historyInfo = (EquipmentReadingHistoryInfo)iter.next();
            if (historyInfo.getOprStatus() == 3) continue;
            boolean isCurrentObject = historyInfo.getId().equals((Object)info.getId());
            if (!isReset && !isCurrentObject) {
                boolean bl = isReset = historyInfo.getReadingWay().getValue() == 30 || historyInfo.getReadingWay().getValue() == 40;
            }
            if (!isReplace && !isCurrentObject) {
                boolean bl = isReplace = historyInfo.getReadingWay().getValue() == 40;
            }
            if (!isReset) {
                if (!isCurrentObject) {
                    historyInfo.setPreValue(NumericUtils.toBigDecimal((Object)historyInfo.getPreValue()).add(gapValue).toString());
                }
                historyInfo.setCurrentValue(NumericUtils.toBigDecimal((Object)historyInfo.getCurrentValue()).add(gapValue).toString());
                historyInfo.setStepValues(NumericUtils.toBigDecimal((Object)historyInfo.getStepValues()).add(gapValue).toString());
                historyInfo.setOprStatus((short)2);
                historyInfo.setModify(true);
                if (NumericUtils.toBigDecimal((Object)historyInfo.getCurrentValue()).compareTo(new BigDecimal(0)) < 0) {
                    throw new SerialMeterException(SerialMeterException.SERIALMETEREXCEPTION);
                }
            }
            if (!isReplace) {
                historyInfo.setAccumulatedValue(historyInfo.getAccumulatedValue().add(tmpGapValue));
                historyInfo.setOprStatus((short)2);
                historyInfo.setModify(true);
            }
            this.addData(historyInfo, true);
            if (isReplace || info.getMeterNo().equals(historyInfo.getMeterNo()) || list.contains(historyInfo.getParent().getId())) continue;
            list.add(historyInfo.getParent().getId());
        }
        this.updateMeterChangeRecord(list);
    }

    private void updateMeterChangeRecord(List list) {
        if (GeneCommonUtils.isEmpty((Collection)list)) {
            return;
        }
        for (BOSUuid uuid : list) {
            EquipmentReadingInfo readingInfo = (EquipmentReadingInfo)this.datas.get(uuid);
            if (readingInfo.getReadingHistory() == null) continue;
            AbstractEquipmentReadingHistoryInfo maxInfo = null;
            for (EquipmentReadingHistoryInfo historyInfo : readingInfo.getReadingHistory()) {
                if (historyInfo.getOprStatus() == 3 || maxInfo != null && maxInfo.getReadingDate().compareTo(historyInfo.getReadingDate()) >= 0) continue;
                maxInfo = historyInfo;
            }
            if (maxInfo == null) continue;
            readingInfo.setAccumulatedValue(maxInfo.getAccumulatedValue());
            readingInfo.setPreValue(maxInfo.getPreValue());
            readingInfo.setPreReadingDate(maxInfo.getPreReadingDate());
            readingInfo.setInitDate(maxInfo.getInitDate());
            readingInfo.setInitValue(maxInfo.getInitValue());
            readingInfo.setCurrentValue(maxInfo.getStepValues());
            readingInfo.setReadingDate(maxInfo.getReadingDate());
            readingInfo.setOprStatus((short)2);
            readingInfo.setModify(true);
        }
    }

    private EquipmentReadingHistoryInfo findNearestActualInfo(List sameRows, EquipmentReadingHistoryInfo info, ReadingWayEnum readingWayEnum) {
        for (EquipmentReadingHistoryInfo historyInfo : sameRows) {
            if (historyInfo.getReadingDate().compareTo(info.getReadingDate()) != 1 || historyInfo.getReadingWay().getValue() != readingWayEnum.getValue()) continue;
            return historyInfo;
        }
        return null;
    }

    private List getCalcDataRange(EquipmentReadingHistoryInfo info, Object beforeValue, boolean isCurrentValueChanged) throws BOSException, EASBizException {
        ArrayList<EquipmentReadingHistoryInfo> sameRows = new ArrayList<EquipmentReadingHistoryInfo>();
        boolean isForceQuery = false;
        EquipmentReadingInfo readingInfo = (EquipmentReadingInfo)this.datas.get(info.getParent().getId());
        Iterator iter = this.datas.keySet().iterator();
        boolean findReplaceRecord = false;
        Timestamp lastestReadingDate = null;
        while (iter.hasNext() && !isForceQuery) {
            BOSUuid uuid = (BOSUuid)iter.next();
            EquipmentReadingInfo tmp = (EquipmentReadingInfo)this.datas.get(uuid);
            if (tmp.getReadingDate().compareTo(readingInfo.getReadingDate()) < 0) continue;
            if (tmp.getReadingHistory() == null) {
                isForceQuery = true;
                continue;
            }
            Iterator it = tmp.getReadingHistory().iterator();
            while (it != null && it.hasNext() && !isForceQuery) {
                EquipmentReadingHistoryInfo historyInfo = (EquipmentReadingHistoryInfo)it.next();
                if (historyInfo.getReadingDate().compareTo(info.getReadingDate()) < 0) continue;
                if (historyInfo.getId().equals((Object)info.getId()) && isCurrentValueChanged) {
                    historyInfo.setCurrentValue(beforeValue.toString());
                }
                sameRows.add(historyInfo);
                if (historyInfo.getReadingWay().getValue() == 40) {
                    findReplaceRecord = true;
                }
                if (lastestReadingDate != null && historyInfo.getReadingDate().compareTo(lastestReadingDate) <= 0) continue;
                lastestReadingDate = historyInfo.getReadingDate();
            }
        }
        if (findReplaceRecord && !isForceQuery) {
            return sameRows;
        }
        if (isForceQuery) {
            this.queryData(info, sameRows, null);
        } else {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            viewInfo.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("meter.id", (Object)info.getMeter().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("readingDate", (Object)info.getReadingDate(), CompareType.GREATER_EQUALS));
            int count = EquipmentReadingHistoryFactory.getRemoteInstance().getGeneDtaBaseCount(viewInfo);
            if (sameRows.size() < count) {
                this.queryData(info, sameRows, lastestReadingDate);
            }
        }
        return sameRows;
    }

    private void queryData(EquipmentReadingHistoryInfo info, List sameRows, Timestamp lastestReadingDate) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("meter.id", (Object)info.getMeter().getId().toString()));
        if (lastestReadingDate != null) {
            filter.getFilterItems().add(new FilterItemInfo("readingDate", (Object)lastestReadingDate, CompareType.GREATER_EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("readingDate", (Object)info.getReadingDate(), CompareType.GREATER_EQUALS));
        }
        filter.mergeFilter(this.getDefaultFilter(), "and");
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.addObjectCollection((IObjectCollection)GeneSelectorUtils.getSelector((BOSObjectType)new EquipmentReadingHistoryInfo().getBOSType(), (String)"", (boolean)false));
        sic.addObjectCollection((IObjectCollection)GeneSelectorUtils.getSelector((BOSObjectType)new EquipmentMeterInfo().getBOSType(), (String)"meter", (boolean)false));
        sic.addObjectCollection((IObjectCollection)GeneSelectorUtils.getSelector((BOSObjectType)new EquipmentReadingInfo().getBOSType(), (String)"parent", (boolean)false));
        GeneSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String)"creator");
        sic.add(new SelectorItemInfo(COL_History_CREATETIME));
        viewInfo.setSelector(sic);
        EquipmentReadingHistoryCollection collection = EquipmentReadingHistoryFactory.getRemoteInstance().getEquipmentReadingHistoryCollection(viewInfo);
        Iterator iter1 = collection.iterator();
        while (iter1.hasNext()) {
            EquipmentReadingHistoryInfo history = (EquipmentReadingHistoryInfo)iter1.next();
            boolean find = false;
            int n = sameRows.size();
            for (int i = 0; i < n; ++i) {
                EquipmentReadingHistoryInfo tmp = (EquipmentReadingHistoryInfo)sameRows.get(i);
                if (!tmp.getId().equals((Object)history.getId())) continue;
                find = true;
                break;
            }
            if (find || this.isDeleted(history)) continue;
            sameRows.add(history);
        }
    }

    private boolean isDeleted(EquipmentReadingHistoryInfo info) {
        EquipmentReadingInfo currentReadingInfo = (EquipmentReadingInfo)this.datas.get(info.getParent().getId());
        if (currentReadingInfo.getOprStatus() == 3) {
            return true;
        }
        if (currentReadingInfo.getReadingHistory() != null) {
            for (EquipmentReadingHistoryInfo historyInfo : currentReadingInfo.getReadingHistory()) {
                if (!historyInfo.getId().equals((Object)info.getId()) || historyInfo.getOprStatus() != 3) continue;
                return true;
            }
        }
        return false;
    }

    private FilterInfo getDefaultFilter() throws EASBizException {
        FilterInfo filter = new FilterInfo();
        if (this.prmptmaintainOrg.getValue() != null) {
            StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)this.prmptmaintainOrg.getValue();
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitInfo.getId().toString()));
        }
        if (this.getEntityFieldName() == null) {
            filter.getFilterItems().add(new FilterItemInfo("id", null));
        } else {
            filter.getFilterItems().add(new FilterItemInfo(this.getEntityFieldName(), (Object)(this.getEntityValue().getId() == null ? "" : this.getEntityValue().getId().toString())));
        }
        return filter;
    }

    private void addData(EquipmentReadingHistoryInfo history, boolean isUpdate) {
        int index;
        if (this.datas.get(history.getParent().getId()) == null) {
            this.datas.put(history.getParent().getId(), history.getParent());
        }
        EquipmentReadingInfo readingInfo = (EquipmentReadingInfo)this.datas.get(history.getParent().getId());
        boolean find = false;
        if (readingInfo.getReadingHistory() != null) {
            int n = readingInfo.getReadingHistory().size();
            for (index = 0; index < n; ++index) {
                EquipmentReadingHistoryInfo historyInfo = (EquipmentReadingHistoryInfo)readingInfo.getReadingHistory().getObject(index);
                if (!historyInfo.getId().equals((Object)history.getId())) continue;
                find = true;
                break;
            }
        }
        if (!find) {
            readingInfo.addReadingHistory(history);
        } else if (isUpdate) {
            readingInfo.getReadingHistory().setObject(index, (IObjectValue)history);
        }
    }

    private void innerVerifyDate(EquipmentReadingInfo equipmentReadingInfo) throws EQMBaseDataException {
        List sameRows = this.sortByMeterNoAndReadingDate(equipmentReadingInfo);
        for (EquipmentReadingHistoryInfo info : sameRows) {
            boolean isSerialMeter;
            if (info.getReadingDate().compareTo(info.getInitDate()) < 0) {
                throw new EQMBaseDataException(EQMBaseDataException.CAN_NOT_ABOVE_INITDATE);
            }
            if (info.getReadingDate().getTime() > System.currentTimeMillis()) {
                throw new EQMBaseDataException(EQMBaseDataException.CAN_NOT_AFTER_SYSTEMTIME);
            }
            boolean bl = isSerialMeter = info.getMeter().getMeterType().getValue() == 10;
            if (isSerialMeter) {
                this.compareReadingDateWithNeighbor(info, sameRows);
            }
            switch (info.getReadingWay().getValue()) {
                case 10: {
                    boolean isFitValue;
                    if (!isSerialMeter) break;
                    boolean isUp = 10 == info.getMeter().getCountType().getValue();
                    BigDecimal currentValue = NumericUtils.toBigDecimal((Object)info.getCurrentValue());
                    BigDecimal initValue = NumericUtils.toBigDecimal((Object)info.getInitValue());
                    boolean bl2 = isUp ? currentValue.compareTo(initValue) == 1 || currentValue.compareTo(initValue) == 0 : (isFitValue = currentValue.compareTo(initValue) == -1 || currentValue.compareTo(initValue) == 0);
                    if (!isFitValue) {
                        throw new EQMBaseDataException(EQMBaseDataException.CAN_NOT_ABOVE_INITVALUE, new Object[]{info.getMeterNo(), currentValue, isUp ? EASResource.getString((String)this.getResourceName(), (String)"Up") : EASResource.getString((String)this.getResourceName(), (String)"Down"), initValue});
                    }
                    this.compareValueWithNeighbor(true, info, sameRows);
                    break;
                }
                case 20: {
                    break;
                }
                case 40: {
                    if (!isSerialMeter) break;
                    this.compareValueWithNeighbor(false, info, sameRows);
                    break;
                }
                case 30: {
                    if (!isSerialMeter) break;
                    this.compareValueWithNeighbor(false, info, sameRows);
                }
            }
        }
    }

    private EquipmentReadingInfo getNextMeterNoReading(EquipmentReadingHistoryInfo info) {
        EquipmentReadingInfo nextReadingInfo = null;
        ArrayList l = new ArrayList();
        for (BOSUuid uuid : this.datas.keySet()) {
            l.add(this.datas.get(uuid));
        }
        Collections.sort(l, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                EquipmentReadingInfo obj1 = (EquipmentReadingInfo)arg0;
                EquipmentReadingInfo obj2 = (EquipmentReadingInfo)arg1;
                return obj1.getReadingDate().compareTo(obj2.getReadingDate());
            }
        });
        nextReadingInfo = (EquipmentReadingInfo)this.datas.get(info.getParent().getId());
        int index = l.indexOf(nextReadingInfo);
        if (index < l.size() - 1) {
            return (EquipmentReadingInfo)l.get(index + 1);
        }
        return null;
    }

    private void compareReadingDateWithNeighbor(EquipmentReadingHistoryInfo info, List sameRows) throws EQMBaseDataException {
        boolean isEquals;
        Timestamp nextMeterNoInitDate;
        Timestamp timestamp = nextMeterNoInitDate = this.getNextMeterNoReading(info) == null ? null : this.getNextMeterNoReading(info).getInitDate();
        if (nextMeterNoInitDate != null && info.getReadingDate().compareTo(nextMeterNoInitDate) > 0) {
            throw new EQMBaseDataException(EQMBaseDataException.CAN_NOT_ABOVE_NEXTINITDATE);
        }
        Timestamp preReadingDate = null;
        Timestamp nextReadingDate = null;
        Timestamp currentReadingDate = info.getReadingDate();
        int index = sameRows.indexOf(info);
        if (index > 1) {
            EquipmentReadingHistoryInfo preInfo = (EquipmentReadingHistoryInfo)sameRows.get(index - 1);
            preReadingDate = preInfo.getReadingDate();
        }
        if (index < sameRows.size() - 1) {
            EquipmentReadingHistoryInfo nextInfo = (EquipmentReadingHistoryInfo)sameRows.get(index + 1);
            nextReadingDate = nextInfo.getReadingDate();
        }
        boolean bl = isEquals = preReadingDate != null && preReadingDate.compareTo(currentReadingDate) == 0 || nextReadingDate != null && nextReadingDate.compareTo(currentReadingDate) == 0;
        if (isEquals) {
            DateFormat sd = CtrlFormatUtilities.getDateTimeFormat();
            throw new EQMBaseDataException(EQMBaseDataException.CAN_NOT_DUPLICATE_READINGDATE, new Object[]{sd.format(currentReadingDate)});
        }
    }

    private void compareValueWithNeighbor(boolean isActual, EquipmentReadingHistoryInfo info, List sameRows) throws EQMBaseDataException {
        EquipmentReadingHistoryInfo nextInfo;
        EquipmentReadingHistoryInfo preInfo;
        boolean isUp = 10 == info.getMeter().getCountType().getValue();
        int index = sameRows.indexOf(info);
        BigDecimal currentValue = NumericUtils.toBigDecimal((Object)info.getCurrentValue());
        BigDecimal preValue = null;
        BigDecimal nextValue = null;
        Timestamp preDate = null;
        Timestamp nextDate = null;
        DateFormat sd = CtrlFormatUtilities.getDateTimeFormat();
        if (index >= 1 && (preInfo = (EquipmentReadingHistoryInfo)sameRows.get(index - 1)).getReadingWay().getValue() == 10) {
            preValue = NumericUtils.toBigDecimal((Object)preInfo.getCurrentValue());
            preDate = preInfo.getReadingDate();
        }
        if (index < sameRows.size() - 1 && (nextInfo = (EquipmentReadingHistoryInfo)sameRows.get(index + 1)).getReadingWay().getValue() == 10) {
            nextValue = NumericUtils.toBigDecimal((Object)nextInfo.getCurrentValue());
            nextDate = nextInfo.getReadingDate();
        }
        boolean isFitValue = true;
        if (isActual && preValue != null) {
            boolean bl = isUp ? currentValue.compareTo(preValue) == 1 : (isFitValue = currentValue.compareTo(preValue) == -1);
        }
        if (nextValue != null) {
            boolean bl = isFitValue && (isUp ? currentValue.compareTo(nextValue) == -1 : currentValue.compareTo(nextValue) == 1) ? true : (isFitValue = false);
        }
        if (!isFitValue) {
            throw new EQMBaseDataException(EQMBaseDataException.VALUE_INPUT_ERROR_FOR_NOACTUAL, new Object[]{info.getMeterNo(), preDate == null ? sd.format(info.getReadingDate()) : sd.format(preDate), nextDate == null ? sd.format(info.getReadingDate()) : sd.format(nextDate)});
        }
    }

    public boolean isModify() {
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException e) {
            this.handleControlException();
            this.abort();
        }
        boolean isModify = false;
        Iterator iter = this.datas.keySet().iterator();
        block2: while (iter.hasNext() && !isModify) {
            BOSUuid uuid = (BOSUuid)iter.next();
            EquipmentReadingInfo readingInfo = (EquipmentReadingInfo)this.datas.get(uuid);
            if (readingInfo.isModify()) {
                isModify = true;
                break;
            }
            if (readingInfo.getReadingHistory() == null) continue;
            for (EquipmentReadingHistoryInfo historyInfo : readingInfo.getReadingHistory()) {
                if (!historyInfo.isModify()) continue;
                isModify = true;
                continue block2;
            }
        }
        return isModify;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        int size;
        this.checkPermission("ACTION_SAVE", null);
        if (this.isView()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.eqm.basedata.client.EquipmentReadingEditUIResource", (String)"History_CannotSaveDuetoViewStatus"));
            SysUtil.abort();
        }
        if (this.datas.size() <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.eqm.common.core.GeneResource", (String)"Msg_NoDataSubmited"));
            SysUtil.abort();
        }
        ArrayList<EquipmentMeterApplyInfo> applies = new ArrayList<EquipmentMeterApplyInfo>();
        ArrayList<EquipmentReadingInfo> readings = new ArrayList<EquipmentReadingInfo>();
        ArrayList<EquipmentReadingHistoryInfo> histories = new ArrayList<EquipmentReadingHistoryInfo>();
        Iterator iter = this.datas.keySet().iterator();
        AbstractEquipmentReadingInfo maxReadingInfo = null;
        EquipmentMeterApplyInfo parent = null;
        while (iter.hasNext()) {
            BOSUuid uuid = (BOSUuid)iter.next();
            EquipmentReadingInfo readingInfo = (EquipmentReadingInfo)this.datas.get(uuid);
            if (parent == null) {
                parent = readingInfo.getParent();
            }
            this.innerVerifyDate(readingInfo);
            if (readingInfo.getOprStatus() == 2 || readingInfo.getOprStatus() == 3) {
                readingInfo.put("from", "from");
                readings.add(readingInfo);
                if (readingInfo.getReadingHistory() != null) {
                    for (EquipmentReadingHistoryInfo historyInfo : readingInfo.getReadingHistory()) {
                        if (historyInfo.getOprStatus() != 2 && historyInfo.getOprStatus() != 3) continue;
                        historyInfo.put("from", "from");
                        histories.add(historyInfo);
                    }
                }
            }
            if (readingInfo.getOprStatus() == 3 || maxReadingInfo != null && maxReadingInfo.getReadingDate().compareTo(readingInfo.getReadingDate()) >= 0) continue;
            maxReadingInfo = readingInfo;
        }
        if (readings != null && readings.size() > 0) {
            parent.setAccumulatedValue(maxReadingInfo == null ? null : maxReadingInfo.getAccumulatedValue());
            parent.setReadingDate(maxReadingInfo == null ? null : maxReadingInfo.getReadingDate());
            parent.setCurrentValue(maxReadingInfo == null ? null : maxReadingInfo.getCurrentValue());
            parent.setOprStatus((short)2);
            parent.setModify(true);
            applies.add(parent);
        }
        if ((size = applies.size() + readings.size() + histories.size()) <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.eqm.common.core.GeneResource", (String)"Msg_NoDataSubmited"));
        } else if (this.verifyInput()) {
            ArrayList<ArrayList<Object>> updateCollection = new ArrayList<ArrayList<Object>>();
            updateCollection.add(applies);
            updateCollection.add(readings);
            updateCollection.add(histories);
            GeneBatchResult result = ((IGeneDataBaseBatch)this.getBizInterface()).batchSubmitData(updateCollection);
            this.processResult(result);
        }
    }

    protected void processResult(GeneBatchResult result) throws Exception {
        if (GeneCommonUtils.isEmpty((Object)result)) {
            throw new Exception(EASResource.getString((String)"com.kingdee.eas.eqm.basedata.BASEDATAAutoGenerateResource", (String)"70_EquipmentReadingEditUI"));
        }
        StringBuffer headlineMsg = result.getHeadMsg();
        StringBuffer detailMsg = result.getDetailMsg();
        if (detailMsg != null && detailMsg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)headlineMsg.toString(), (String)detailMsg.toString(), (int)1);
        } else {
            this.setIsShowTextOnly(false);
            this.setMessageText(this.getClassAlise() + " " + EASResource.getString((String)"com.kingdee.eas.eqm.common.core.GeneResource", (String)"BatchSuccessSimpleMsg"));
            this.setNextMessageText("");
            this.setShowMessagePolicy(0);
            this.showMessage();
            this.prmptMeter_stateChanged(null);
        }
    }

    private List sortByMeterNoAndReadingDate(EquipmentReadingInfo equipmentReadingInfo) {
        ArrayList<EquipmentReadingHistoryInfo> sameRows = new ArrayList<EquipmentReadingHistoryInfo>();
        if (GeneCommonUtils.isEmpty((Object)(equipmentReadingInfo = (EquipmentReadingInfo)this.datas.get(equipmentReadingInfo.getId())).getReadingHistory())) {
            return sameRows;
        }
        int n = equipmentReadingInfo.getReadingHistory().size();
        for (int i = 0; i < n; ++i) {
            EquipmentReadingHistoryInfo info = (EquipmentReadingHistoryInfo)equipmentReadingInfo.getReadingHistory().getObject(i);
            if (info.getOprStatus() == 3) continue;
            sameRows.add(this.findFromCache(info));
        }
        Collections.sort(sameRows, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                EquipmentReadingHistoryInfo obj1 = (EquipmentReadingHistoryInfo)arg0;
                EquipmentReadingHistoryInfo obj2 = (EquipmentReadingHistoryInfo)arg1;
                return obj1.getReadingDate().compareTo(obj2.getReadingDate());
            }
        });
        return sameRows;
    }

    public EquipmentMeterInfo getSelectedMeterInfo() {
        if (this.getSelectedRowNumber() == -1) {
            return null;
        }
        return ((EquipmentReadingInfo)this.tblReading.getRow(this.getSelectedRowNumber()).getUserObject()).getMeter();
    }

    public EquipmentReadingInfo getSelectedReadingInfo() {
        if (this.getSelectedRowNumber() == -1) {
            return null;
        }
        return (EquipmentReadingInfo)this.tblReading.getRow(this.getSelectedRowNumber()).getUserObject();
    }

    protected void tblReading_tableDataRequest(KDTDataRequestEvent e) {
        this.setCursorOfWair();
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            if (viewInfo.getFilter() == null) {
                viewInfo.setFilter(new FilterInfo());
            }
            if (this.prmptMeter.getValue() != null) {
                EquipmentMeterInfo meterInfo = (EquipmentMeterInfo)this.prmptMeter.getValue();
                viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("meter.id", (Object)meterInfo.getId().toString()));
            } else {
                viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("id", null));
            }
            if (this.getEntityFieldName() == null) {
                viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("id", null));
            } else {
                viewInfo.getFilter().getFilterItems().add(new FilterItemInfo(this.getEntityFieldName(), (Object)(this.getEntityValue().getId() == null ? "" : this.getEntityValue().getId().toString())));
            }
            if (this.prmptmaintainOrg.getValue() != null) {
                // empty if block
            }
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo(COL_Reading_METERNO, null, CompareType.NOTEQUALS));
            SorterItemCollection sorterItemCollection = new SorterItemCollection();
            sorterItemCollection.add(new SorterItemInfo("readingDate"));
            viewInfo.setSorter(sorterItemCollection);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.addObjectCollection((IObjectCollection)GeneSelectorUtils.getSelector((BOSObjectType)new EquipmentReadingInfo().getBOSType(), (String)"", (boolean)false));
            sic.addObjectCollection((IObjectCollection)GeneSelectorUtils.getSelector((BOSObjectType)new EquipmentMeterInfo().getBOSType(), (String)"meter", (boolean)false));
            sic.add(new SelectorItemInfo("meter.unit.qtyPrecision"));
            sic.addObjectCollection((IObjectCollection)GeneSelectorUtils.getSelector((BOSObjectType)new EquipmentMeterApplyInfo().getBOSType(), (String)"parent", (boolean)false));
            viewInfo.setSelector(sic);
            EquipmentReadingCollection collection = EquipmentReadingFactory.getRemoteInstance().getEquipmentReadingCollection(viewInfo);
            if (collection != null && collection.size() > 0) {
                Iterator it = collection.iterator();
                while (it.hasNext()) {
                    EquipmentReadingInfo info = (EquipmentReadingInfo)it.next();
                    this.datas.put(info.getId(), info);
                    IRow row = this.tblReading.addRow();
                    this.loadLineFields(this.tblReading, row, (IObjectValue)info);
                }
            }
        }
        catch (Exception ex) {
            ExceptionHandler.handle((Throwable)ex);
            SysUtil.abort();
        }
        this.setCursorOfDefault();
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        super.loadLineFields(table, row, obj);
        if (table.getName().equals(this.tblMain.getName())) {
            EquipmentReadingHistoryInfo readingHistoryInfo = (EquipmentReadingHistoryInfo)obj;
            if (readingHistoryInfo.getReadingWay().getValue() == 40) {
                row.getCell("accumulatedValue").getStyleAttributes().setLocked(false);
            }
            if (readingHistoryInfo.getReadingWay().getValue() == 40 || readingHistoryInfo.getReadingWay().getValue() == 30) {
                row.getCell("readingDate").getStyleAttributes().setLocked(true);
            } else {
                row.getCell("readingDate").getStyleAttributes().setLocked(false);
            }
            if (readingHistoryInfo.getMeter().getMeterType().getValue() == 30) {
                Object[] enumsValue = GeneHelper.parseEnumString((String)readingHistoryInfo.getMeter().getFeatureValue());
                EQMPromptDialogFactory.createEnumList((KDTable)this.tblMain, (int)row.getCell("currentValue").getColumnIndex(), (int)row.getRowIndex(), (Object[])enumsValue);
                EQMPromptDialogFactory.createText((KDTable)this.tblMain, (String)"currentValue");
                EQMPromptDialogFactory.createText((KDTable)this.tblMain, (String)"initValue");
                EQMPromptDialogFactory.createText((KDTable)this.tblMain, (String)COL_History_PREVALUE);
                EQMPromptDialogFactory.createText((KDTable)this.tblMain, (String)COL_History_STEPVALUES);
                EQMPromptDialogFactory.createText((KDTable)this.tblReading, (String)"initValue");
                EQMPromptDialogFactory.createText((KDTable)this.tblReading, (String)"currentValue");
                EQMPromptDialogFactory.createNumberic((KDTable)this.tblMain, (String)"accumulatedValue", (int)0, (boolean)true);
                EQMPromptDialogFactory.createNumberic((KDTable)this.tblReading, (String)"initValue", (int)0, (boolean)true);
                EQMPromptDialogFactory.createNumberic((KDTable)this.tblMain, (String)COL_History_PREVALUE, (int)0, (boolean)true);
                EQMPromptDialogFactory.createNumberic((KDTable)this.tblMain, (String)COL_History_STEPVALUES, (int)0, (boolean)true);
                EQMPromptDialogFactory.createNumberic((KDTable)this.tblMain, (String)"initValue", (int)0, (boolean)true);
                EQMPromptDialogFactory.createNumberic((KDTable)this.tblReading, (String)"initValue", (int)0, (boolean)true);
                EQMPromptDialogFactory.createNumberic((KDTable)this.tblReading, (String)"currentValue", (int)0, (boolean)true);
            } else if (readingHistoryInfo.getMeter().getMeterType().getValue() == 20) {
                if (readingHistoryInfo.getMeter().getMeterType() != null) {
                    EQMPromptDialogFactory.createNumberic((KDTable)this.tblMain, (int)row.getCell("currentValue").getColumnIndex(), (int)row.getRowIndex(), (int)this.getPrecision(readingHistoryInfo.getMeter().getUnit()), (boolean)true);
                    EQMPromptDialogFactory.createNumberic((KDTable)this.tblMain, (String)"accumulatedValue", (int)0, (boolean)true);
                    EQMPromptDialogFactory.createNumberic((KDTable)this.tblMain, (String)"initValue", (int)this.getPrecision(readingHistoryInfo.getMeter().getUnit()), (boolean)true);
                    EQMPromptDialogFactory.createNumberic((KDTable)this.tblMain, (String)COL_History_PREVALUE, (int)readingHistoryInfo.getMeter().getUnit().getQtyPrecision(), (boolean)true);
                    EQMPromptDialogFactory.createNumberic((KDTable)this.tblMain, (String)COL_History_STEPVALUES, (int)this.getPrecision(readingHistoryInfo.getMeter().getUnit()), (boolean)true);
                    EQMPromptDialogFactory.createNumberic((KDTable)this.tblReading, (String)"initValue", (int)readingHistoryInfo.getMeter().getUnit().getQtyPrecision(), (boolean)true);
                    EQMPromptDialogFactory.createNumberic((KDTable)this.tblReading, (String)"currentValue", (int)this.getPrecision(readingHistoryInfo.getMeter().getUnit()), (boolean)true);
                }
            } else if (readingHistoryInfo.getMeter().getMeterType() != null) {
                EQMPromptDialogFactory.createNumberic((KDTable)this.tblMain, (int)row.getCell("currentValue").getColumnIndex(), (int)row.getRowIndex(), (int)this.getPrecision(readingHistoryInfo.getMeter().getUnit()));
                EQMPromptDialogFactory.createNumberic((KDTable)this.tblMain, (String)"accumulatedValue", (int)this.getPrecision(readingHistoryInfo.getMeter().getUnit()));
                EQMPromptDialogFactory.createNumberic((KDTable)this.tblMain, (String)"initValue", (int)this.getPrecision(readingHistoryInfo.getMeter().getUnit()));
                EQMPromptDialogFactory.createNumberic((KDTable)this.tblMain, (String)COL_History_PREVALUE, (int)this.getPrecision(readingHistoryInfo.getMeter().getUnit()));
                EQMPromptDialogFactory.createNumberic((KDTable)this.tblMain, (String)COL_History_STEPVALUES, (int)this.getPrecision(readingHistoryInfo.getMeter().getUnit()), (boolean)true);
                EQMPromptDialogFactory.createNumberic((KDTable)this.tblReading, (String)"initValue", (int)this.getPrecision(readingHistoryInfo.getMeter().getUnit()));
                EQMPromptDialogFactory.createNumberic((KDTable)this.tblReading, (String)"currentValue", (int)this.getPrecision(readingHistoryInfo.getMeter().getUnit()));
            }
        } else {
            EquipmentReadingInfo readingInfo = (EquipmentReadingInfo)obj;
            if (readingInfo.getMeter().getMeterType().getValue() == 10) {
                if (readingInfo.getMeter().getMeterType() != null) {
                    EQMPromptDialogFactory.createNumberic((KDTable)this.tblReading, (String)"accumulatedValue", (int)this.getPrecision(readingInfo.getMeter().getUnit()));
                }
            } else if (readingInfo.getMeter().getMeterType() != null) {
                EQMPromptDialogFactory.createNumberic((KDTable)this.tblReading, (String)"accumulatedValue", (int)0);
            }
        }
    }

    private int getSelectedRowNumber() {
        if (this.tblReading.getRowCount() <= 0) {
            return -1;
        }
        if (this.tblReading.getSelectManager().size() == 0) {
            return 0;
        }
        return KDTableUtils.getSelectedRows((KDTable)this.tblReading)[0];
    }

    protected EntityViewInfo getQueryEntityViewInfo() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        if (viewInfo.getFilter() == null) {
            viewInfo.setFilter(new FilterInfo());
        }
        if (this.tblReading.getRowCount() == 0) {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("id", null));
        } else {
            BOSUuid currentParentid = (BOSUuid)this.tblReading.getRow(this.getSelectedRowNumber()).getCell("id").getValue();
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("parent.id", (Object)currentParentid.toString()));
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.addObjectCollection((IObjectCollection)GeneSelectorUtils.getSelector((BOSObjectType)new EquipmentReadingHistoryInfo().getBOSType(), (String)"", (boolean)false));
        sic.addObjectCollection((IObjectCollection)GeneSelectorUtils.getSelector((BOSObjectType)new EquipmentMeterInfo().getBOSType(), (String)"meter", (boolean)false));
        sic.addObjectCollection((IObjectCollection)GeneSelectorUtils.getSelector((BOSObjectType)new EquipmentReadingInfo().getBOSType(), (String)"parent", (boolean)false));
        GeneSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String)"creator");
        sic.add(new SelectorItemInfo(COL_History_CREATETIME));
        sic.add(new SelectorItemInfo("meter.unit.qtyPrecision"));
        viewInfo.setSelector(sic);
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        sorterItemCollection.add(new SorterItemInfo("readingDate"));
        viewInfo.setSorter(sorterItemCollection);
        return viewInfo;
    }

    protected void prmptMeter_stateChanged(ChangeEvent e) {
        this.datas.clear();
        this.doQueryForChangeRecord();
        this.doQuery();
        if (this.prmptMeter.getValue() != null) {
            EquipmentMeterInfo meterInfo = (EquipmentMeterInfo)this.prmptMeter.getValue();
            this.unit.setText(meterInfo.getUnit() == null ? null : meterInfo.getUnit().getName());
            this.countType.setText(meterInfo.getCountType().getAlias());
        } else {
            this.unit.setText(null);
            this.countType.setText(null);
        }
    }

    private void doQueryForChangeRecord() {
        this.tblReading.removeRows();
        this.tblReading.repaint();
    }

    protected void prmptLocation_stateChanged(ChangeEvent e) {
        this.registerMeterCondition("flocationid", this.prmptLocation);
        if (this.prmptLocation.getValue() != null) {
            this.txtLocationName.setText(((EquipmentLocationInfo)this.prmptLocation.getValue()).getName());
            ChangeListener[] listeners = GeneListenerUtil.getChangeListener((KDBizPromptBox)this.prmptEquipment);
            GeneListenerUtil.removeChangeListener((KDBizPromptBox)this.prmptEquipment, (ChangeListener[])listeners);
            this.prmptEquipment.setValue(null);
            GeneListenerUtil.addChangeListener((KDBizPromptBox)this.prmptEquipment, (ChangeListener[])listeners);
            this.txtEquipmentName.setText(null);
        } else {
            this.txtLocationName.setText(null);
        }
        this.setDefaultValue(2);
    }

    protected void prmptEquipment_stateChanged(ChangeEvent e) {
        this.registerMeterCondition("fequipmentid", this.prmptEquipment);
        if (this.prmptEquipment.getValue() != null) {
            this.txtEquipmentName.setText(((EquipmentArchivesInfo)this.prmptEquipment.getValue()).getName());
            ChangeListener[] listeners = GeneListenerUtil.getChangeListener((KDBizPromptBox)this.prmptLocation);
            GeneListenerUtil.removeChangeListener((KDBizPromptBox)this.prmptLocation, (ChangeListener[])listeners);
            this.prmptLocation.setValue(null);
            GeneListenerUtil.addChangeListener((KDBizPromptBox)this.prmptLocation, (ChangeListener[])listeners);
            this.txtLocationName.setText(null);
        } else {
            this.txtEquipmentName.setText(null);
        }
        this.setDefaultValue(2);
    }

    protected void tblMain_tableDataRequest(KDTDataRequestEvent e) throws Exception {
        List result;
        int rowNumber = this.getSelectedRowNumber();
        if (rowNumber == -1) {
            return;
        }
        int count = EquipmentReadingHistoryFactory.getRemoteInstance().getGeneDtaBaseCount(this.getQueryEntityViewInfo());
        EquipmentReadingInfo readingInfo = (EquipmentReadingInfo)this.tblReading.getRow(rowNumber).getUserObject();
        if (((readingInfo = (EquipmentReadingInfo)this.datas.get(readingInfo.getId())).getReadingHistory() == null || readingInfo.getReadingHistory().size() < count) && (result = EquipmentReadingHistoryFactory.getRemoteInstance().getGeneDtaBaseCollection(this.getQueryEntityViewInfo(), 0, -1)) != null && result.size() == 2) {
            IObjectCollection collection = (IObjectCollection)result.get(1);
            for (EquipmentReadingHistoryInfo history : collection) {
                this.addData(history, false);
            }
        }
        this.tblMain.setRowCount((readingInfo = (EquipmentReadingInfo)this.datas.get(readingInfo.getId())).getReadingHistory() == null ? 0 : readingInfo.getReadingHistory().size());
        this.loadCollectionFields(readingInfo.getReadingHistory());
        this.sortTableByMeterNoAndReadingDate(this.tblMain, this.tblMain.getColumnIndex("readingDate"));
        if (this.tblMain.getRowCount() != 0) {
            this.tblMain.getRow(0).getCell("readingDate").getStyleAttributes().setLocked(true);
        }
    }

    protected void setDataCollection(IObjectCollection collection) {
        super.setDataCollection(collection);
        if (this.getSelectedReadingInfo() != null) {
            this.getSelectedReadingInfo().setReadingHistory(collection);
        }
    }

    @Override
    protected void tblReading_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblReading_tableClicked(e);
        this.doQuery();
    }

    protected void registerCustomerBindings() {
        this.setMainOrgStatus();
        try {
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmptEquipment, (String)"com.kingdee.eas.eqm.archives.app.F7EquipmentArchivesForMaintainOrgQuery");
            EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmptmaintainOrg, (String)this.getAddNewPermItemName(), (boolean)false, (OrgType)this.getMainBizOrgType(), (boolean)true, (boolean)false);
            OrgUnitInfo org = this.getDefaultMainBizOrg();
            if (org == null) {
                org = this.getMainOrgInfo();
            }
            this.getMainBizOrg().setValue((Object)org);
            this.dataBinder.registerBinding("collection1", EquipmentReadingInfo.class, (Component)this.tblReading, "userObject");
            this.dataBinder.registerBinding("collection1.id", BOSUuid.class, (Component)this.tblReading, "id.text");
            this.dataBinder.registerBinding("collection1.meterNo", String.class, (Component)this.tblReading, "meterNo.text");
            this.dataBinder.registerBinding("collection1.initDate", Timestamp.class, (Component)this.tblReading, "initDate.text");
            this.dataBinder.registerBinding("collection1.initValue", String.class, (Component)this.tblReading, "initValue.text");
            this.dataBinder.registerBinding("collection1.currentValue", String.class, (Component)this.tblReading, "currentValue.text");
            this.dataBinder.registerBinding("collection1.readingDate", Timestamp.class, (Component)this.tblReading, "readingDate.text");
            this.dataBinder.registerBinding("collection1.accumulatedValue", BigDecimal.class, (Component)this.tblReading, "accumulatedValue.text");
            this.dataBinder.registerBinding("collection1.activedStatus", Boolean.class, (Component)this.tblReading, "activedStatus.text");
            this.tblReading.checkParsed(true);
            EQMPromptDialogFactory.createPickDateTime((KDTable)this.tblMain, (String)"readingDate", (boolean)true);
            EQMPromptDialogFactory.createPickDateTime((KDTable)this.tblMain, (String)"initDate", (boolean)true);
            EQMPromptDialogFactory.createPickDateTime((KDTable)this.tblMain, (String)COL_History_PREREADINGDATE, (boolean)true);
            EQMPromptDialogFactory.createPickDateTime((KDTable)this.tblReading, (String)"readingDate", (boolean)true);
            EQMPromptDialogFactory.createPickDateTime((KDTable)this.tblMain, (String)COL_History_CREATETIME, (boolean)false);
            EQMPromptDialogFactory.createNumberic((KDTable)this.tblMain, (String)"accumulatedValue", (int)4);
            EQMPromptDialogFactory.createNumberic((KDTable)this.tblReading, (String)"accumulatedValue", (int)4);
            this.prmptmaintainOrg.setRequired(true);
            this.registerMeterCondition("fequipmentid", this.prmptEquipment);
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.prmptEquipment.requestFocusInWindow();
    }

    protected void initUserConfig() {
        super.initUserConfig();
        this.tblReading.getSelectManager().setSelectMode(2);
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.setVisible(false);
        this.actionUnAudit.setVisible(false);
        this.actionQuery.setVisible(false);
        this.actionAddLine.setVisible(false);
        this.actionInsertLine.setVisible(false);
        this.actionCopyLine.setVisible(false);
        this.actionEdit.setVisible(true);
        this.actionEdit.setEnabled(true);
        this.actionSubmit.setEnabled(true);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        GeneMenuUtils.hideMenu((KDMenuBar)this.menuBar);
    }

    private boolean isView() {
        return this.tblMain.getAccessAuthority() == 1;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.setOprtState("EDIT");
        this.unLockUI();
        this.actionRemoveLine.setEnabled(true);
        this.actionSubmit.setEnabled(true);
    }

    private void registerMeterCondition(String field, KDBizPromptBox promptBox) {
        try {
            if (promptBox.getValue() != null) {
                String sql = " Select FMeterID from t_eqm_equipmentMeterApply where {0} = {1} ";
                this.prmptMeter.getQueryAgent().resetRuntimeEntityView();
                EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmptMeter, (String)"com.kingdee.eas.eqm.basedata.app.F7EquipmentMeterQuery", (String[])new String[]{"id"}, (Object[])new Object[]{MessageFormat.format(sql, field, "'" + ((ObjectBaseInfo)promptBox.getValue()).getId().toString() + "'")}, (CompareType[])new CompareType[]{CompareType.INNER});
            } else {
                EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmptMeter, (String)"com.kingdee.eas.eqm.basedata.app.F7EquipmentMeterQuery", (String[])new String[]{"id"}, (Object[])new Object[]{null}, (CompareType[])new CompareType[]{CompareType.EQUALS});
            }
        }
        catch (BOSException e1) {
            this.handleException((Exception)((Object)e1));
        }
    }

    protected void afterMainOrgChanged(String oldOrgId, String newOrgId) {
        super.afterMainOrgChanged(oldOrgId, newOrgId);
        if (!newOrgId.equals(oldOrgId)) {
            String strTemp = EASResource.getString((String)"com.kingdee.eas.eqm.basedata.BASEDATAAutoGenerateResource", (String)"73_EquipmentReadingHistoryEditUI");
            int ret = MsgBox.showConfirm2((String)strTemp);
            if (ret == 2) {
                return;
            }
            this.setDefaultValue(1);
        }
    }

    protected String getAddNewPermItemName() {
        return "eqm_equipmentmeterhistory_01view";
    }

    private void setDefaultValue(int type) {
        this.tblMain.removeRows(false);
        this.unit.setText(null);
        this.countType.setText(null);
        if (type <= 1) {
            this.prmptEquipment.setValue(null);
            this.txtLocationName.setText(null);
            this.prmptLocation.setValue(null);
            this.txtEquipmentName.setText(null);
        }
        if (type <= 2) {
            this.prmptMeter.setValue(null);
        }
    }

    protected IObjectValue createNewData() {
        return this.doCreateNewData(null);
    }

    private int getPrecision(MeasureUnitInfo unit) {
        int precision = 4;
        if (this.precisionPool.containsKey(unit.getId())) {
            return (Integer)this.precisionPool.get(unit.getId());
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("qtyPrecision"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        ObjectUuidPK pk = new ObjectUuidPK(unit.getId());
        try {
            precision = MeasureUnitFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext()).getMeasureUnitInfo((IObjectPK)pk, sic).getQtyPrecision();
            this.precisionPool.put(unit.getId(), new Integer(precision));
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return precision;
    }
}

