/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.basedata.EquipmentReadingInfo;
import com.kingdee.eas.eqm.basedata.client.AbstractEquipmentReadingSingleEditUI;
import com.kingdee.eas.eqm.common.core.util.GeneListenerUtil;
import com.kingdee.eas.eqm.common.eqmcore.client.util.ControlledItems;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.eqm.maintain.WorkOrderInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.HashSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class EquipmentReadingSingleEditUI
extends AbstractEquipmentReadingSingleEditUI {
    private static final Logger logger = CoreUIObject.getLogger(EquipmentReadingSingleEditUI.class);

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmptmaintainOrg;
    }

    @Override
    public BOSObjectType getBizObjectType() {
        return new EquipmentReadingInfo().getBOSType();
    }

    protected ControlledItems[] getNeedMainOrgControl() {
        return new ControlledItems[]{new ControlledItems(this.prmptEquipment, "maintainOrgUnit.id"), new ControlledItems(this.prmptLocation, "maintainOrgUnit.id"), new ControlledItems(this.prmptSrcBill, "maintainOrgUnit.id")};
    }

    protected String getAddNewPermItemName() {
        return "eqm_equipmentmeterreading_01view";
    }

    @Override
    protected void registerCustomerBindings() {
        try {
            this.prmptSrcBill.setEnabled(false);
            HashSet<Integer> set = new HashSet<Integer>();
            set.add(new Integer(45));
            set.add(new Integer(46));
            set.add(new Integer(48));
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmptSrcBill, (String)"com.kingdee.eas.eqm.maintain.app.F7WorkOrderQuery", (String[])new String[]{"billStatus"}, (Object[])new Object[]{set}, (CompareType[])new CompareType[]{CompareType.INCLUDE});
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmptEquipment, (String)"com.kingdee.eas.eqm.archives.app.F7EquipmentArchivesQuery", (String[])new String[]{"bizStatus"}, (Object[])new Object[]{new Integer(10)});
            EQMPromptDialogFactory.createPickDateTime((KDTable)this.tblMain, (String)"readingDate", (boolean)true);
            this.tblMain.getColumn("readingDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
            EQMPromptDialogFactory.createNumberic((KDTable)this.tblMain, (String)"accumulatedValue", (int)4);
            this.prmptmaintainOrg.setValue((Object)this.getDefaultMainBizOrg());
            if (this.prmptCreator.getValue() == null) {
                this.prmptCreator.setValue((Object)SysContext.getSysContext().getCurrentUserInfo());
            }
            this.removeKey(this.tblMain);
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.prmptEquipment.requestFocusInWindow();
    }

    private boolean isEquipment() {
        return this.prmptEquipment.getValue() != null;
    }

    private boolean isLocation() {
        return this.prmptLocation.getValue() != null;
    }

    @Override
    public String getEntityFieldName() throws EASBizException {
        if (this.isEquipment()) {
            return "equipment.id";
        }
        if (this.isLocation()) {
            return "location.id";
        }
        return null;
    }

    @Override
    public int getEntityType() throws EASBizException {
        if (this.isEquipment()) {
            return 1;
        }
        if (this.isLocation()) {
            return 2;
        }
        return 0;
    }

    @Override
    public CoreBaseInfo getEntityValue() throws EASBizException {
        if (this.isEquipment()) {
            return (CoreBaseInfo)this.prmptEquipment.getValue();
        }
        if (this.isLocation()) {
            return (CoreBaseInfo)this.prmptLocation.getValue();
        }
        return null;
    }

    public String getResourceName() {
        return "com.kingdee.eas.eqm.basedata.client.EquipmentReadingEditUIResource";
    }

    @Override
    protected void prmptEquipment_stateChanged(ChangeEvent e) {
        super.prmptEquipment_stateChanged(e);
        if (this.prmptEquipment.getValue() != null) {
            this.txtEquipmentName.setText(((EquipmentArchivesInfo)this.prmptEquipment.getValue()).getName());
            this.setLocationValue(null);
            this.setSrcBillValue(null);
        }
        this.doQuery();
    }

    @Override
    protected void prmptLocation_stateChanged(ChangeEvent e) {
        super.prmptLocation_stateChanged(e);
        if (this.prmptLocation.getValue() != null) {
            this.txtLocationName.setText(((EquipmentLocationInfo)this.prmptLocation.getValue()).getName());
            this.setEquipmentValue(null);
            this.setSrcBillValue(null);
        }
        this.doQuery();
    }

    protected void prmptSrcBill_stateChanged(ChangeEvent e) {
        if (this.prmptSrcBill.getValue() != null) {
            WorkOrderInfo orderInfo = (WorkOrderInfo)this.prmptSrcBill.getValue();
            if (orderInfo.getEquipmentArchives() == null && orderInfo.getEqmLocation() != null) {
                this.setLocationValue(orderInfo.getEqmLocation());
                this.setEquipmentValue(null);
            }
            if (orderInfo.getEquipmentArchives() != null) {
                this.setEquipmentValue(orderInfo.getEquipmentArchives());
                this.setLocationValue(null);
            }
        }
        this.doQuery();
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.actionSubmit.setEnabled(true);
    }

    private void setEquipmentValue(EquipmentArchivesInfo archivesInfo) {
        ChangeListener[] listeners = GeneListenerUtil.getChangeListener((KDBizPromptBox)this.prmptEquipment);
        GeneListenerUtil.removeChangeListener((KDBizPromptBox)this.prmptEquipment, (ChangeListener[])listeners);
        this.prmptEquipment.setValue((Object)archivesInfo);
        this.txtEquipmentName.setText(archivesInfo == null ? null : archivesInfo.getName());
        GeneListenerUtil.addChangeListener((KDBizPromptBox)this.prmptEquipment, (ChangeListener[])listeners);
    }

    private void setLocationValue(EquipmentLocationInfo locationInfo) {
        ChangeListener[] listeners = GeneListenerUtil.getChangeListener((KDBizPromptBox)this.prmptLocation);
        GeneListenerUtil.removeChangeListener((KDBizPromptBox)this.prmptLocation, (ChangeListener[])listeners);
        this.prmptLocation.setValue((Object)locationInfo);
        this.txtLocationName.setText(locationInfo == null ? null : locationInfo.getName());
        GeneListenerUtil.addChangeListener((KDBizPromptBox)this.prmptLocation, (ChangeListener[])listeners);
    }

    private void setSrcBillValue(WorkOrderInfo workOrderInfo) {
        ChangeListener[] listeners = GeneListenerUtil.getChangeListener((KDBizPromptBox)this.prmptSrcBill);
        GeneListenerUtil.removeChangeListener((KDBizPromptBox)this.prmptSrcBill, (ChangeListener[])listeners);
        this.prmptSrcBill.setValue((Object)workOrderInfo);
        this.txtSrcBillName.setText(workOrderInfo == null ? null : workOrderInfo.getName());
        GeneListenerUtil.addChangeListener((KDBizPromptBox)this.prmptSrcBill, (ChangeListener[])listeners);
    }
}

