/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.client.staopr;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.basedata.client.staopr.AbstractEntryPanel;
import com.kingdee.eas.eqm.basedata.client.staopr.StandardOperationUtils;
import com.kingdee.eas.eqm.common.core.verify.AbstractVerifyItem;
import com.kingdee.eas.eqm.common.eqmcore.EqmFinanceFacadeFactory;
import com.kingdee.eas.eqm.common.eqmcore.IEqmFinanceFacade;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractTaskRelatedEntryPanel
extends AbstractEntryPanel {
    protected Map cache_CurrencyInfo = new HashMap();
    public static final int DEFAULT_PRECISION = 2;

    @Override
    protected void setColumnFormater() {
        super.setColumnFormater();
        if ("kdtServices".equals(this.table.getName())) {
            StandardOperationUtils.setMoneyFormatByCurrency(this.table, "lineCost", "currency", true);
        } else {
            StandardOperationUtils.setMoneyFormatByCurrency(this.table, "lineCost", "currency", false);
        }
    }

    protected CurrencyInfo getCurrencyInfo(OrgUnitInfo orgInfo) {
        if (orgInfo == null || orgInfo.getId() == null) {
            return null;
        }
        String ckey = orgInfo.getId().toString();
        if (this.cache_CurrencyInfo.get(ckey) != null) {
            return (CurrencyInfo)this.cache_CurrencyInfo.get(ckey);
        }
        CurrencyInfo currencyInfo = null;
        try {
            IEqmFinanceFacade facade = EqmFinanceFacadeFactory.getRemoteInstance();
            if (new StorageOrgUnitInfo().getBOSType().equals((Object)orgInfo.getBOSType())) {
                currencyInfo = facade.getCurrency(orgInfo.getId().toString(), 4);
            } else if (new PurchaseOrgUnitInfo().getBOSType().equals((Object)orgInfo.getBOSType())) {
                currencyInfo = facade.getCurrency(orgInfo.getId().toString(), 3);
            }
            if (currencyInfo != null) {
                this.cache_CurrencyInfo.put(ckey, currencyInfo);
            }
        }
        catch (Exception e) {
            this.parent.handUIException(e);
        }
        return currencyInfo;
    }

    public void currencyChanged(KDTPropertyChangeEvent e) {
        IRow row = this.table.getRow(e.getRowIndex());
        CurrencyInfo currency = (CurrencyInfo)row.getCell("currency").getValue();
        if (currency != null) {
            int precision = currency.getPrecision();
            if ("kdtServices".equals(this.table.getName())) {
                StandardOperationUtils.setRowNumberEditor(precision, this.table, row.getRowIndex(), new String[]{"lineCost"}, StandardOperationUtils.BigDecimal_MaxValue, StandardOperationUtils.BigDecimal_Zero, true);
            } else {
                StandardOperationUtils.setRowNumberEditor(precision, this.table, row.getRowIndex(), new String[]{"lineCost"}, StandardOperationUtils.BigDecimal_MaxValue, StandardOperationUtils.BigDecimal_Zero, false);
            }
            this.afterCurrencyChanged(e);
        }
    }

    protected void afterCurrencyChanged(KDTPropertyChangeEvent e) {
    }

    final class LineCostTooLongVerifyItem
    extends AbstractVerifyItem {
        LineCostTooLongVerifyItem() {
        }

        public boolean verify() throws EASBizException, BOSException {
            String tableName = "";
            if ("kdtPersons".equals(AbstractTaskRelatedEntryPanel.this.table.getName())) {
                tableName = ResourceUtils.getMessage((String)"com.kingdee.eas.eqm.basedata.BASEDATAAutoGenerateResource2", (String)"infoMsg12");
            } else if ("kdtMaterails".equals(AbstractTaskRelatedEntryPanel.this.table.getName())) {
                tableName = ResourceUtils.getMessage((String)"com.kingdee.eas.eqm.basedata.BASEDATAAutoGenerateResource2", (String)"infoMsg13");
            } else if ("kdtTools".equals(AbstractTaskRelatedEntryPanel.this.table.getName())) {
                tableName = ResourceUtils.getMessage((String)"com.kingdee.eas.eqm.basedata.BASEDATAAutoGenerateResource2", (String)"infoMsg14");
            }
            for (int i = 0; i < AbstractTaskRelatedEntryPanel.this.table.getRowCount(); ++i) {
                long longValue;
                IRow row = AbstractTaskRelatedEntryPanel.this.table.getRow(i);
                Object value = row.getCell("lineCost").getValue();
                if (value == null || (longValue = ((BigDecimal)value).longValue()) <= 999999999999L) continue;
                String msg = ResourceUtils.getMessage((String)"com.kingdee.eas.eqm.basedata.BASEDATAAutoGenerateResource2", (String)"infoMsg15");
                MessageFormat mf = new MessageFormat(msg);
                String result = mf.format(new String[]{tableName, i + 1 + ""});
                MsgBox.showWarning((String)result);
                SysUtil.abort();
            }
            return true;
        }
    }
}

