/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.client.staopr;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.attachment.util.UICreator;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.framework.ICUIDGetterFacade;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.eqm.basedata.EquipmentDocBAFacadeFactory;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprAssetInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprAssetRestrictInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprMaterialCollection;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprPersonCollection;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprTaskInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprToolCollection;
import com.kingdee.eas.eqm.basedata.EquipmentStandardOperationFactory;
import com.kingdee.eas.eqm.basedata.EquipmentStandardOperationInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStandardOperationTreeInfo;
import com.kingdee.eas.eqm.basedata.IEquipmentStandardOperation;
import com.kingdee.eas.eqm.basedata.client.staopr.SOEditUI;
import com.kingdee.eas.eqm.basedata.client.staopr.StandardOperationUtils;
import com.kingdee.eas.eqm.basedata.client.verify.EQMDataBaseUsableVerifyItem;
import com.kingdee.eas.eqm.basedata.client.verify.NotDupAssetVerifyItem;
import com.kingdee.eas.eqm.basedata.client.verify.NotEmptyAssetVerifyItem;
import com.kingdee.eas.eqm.basedata.client.verify.NotEmptyCraftsOrgUnitVerifyItem;
import com.kingdee.eas.eqm.common.core.GeneUsableStatusEnum;
import com.kingdee.eas.eqm.common.core.client.verify.DataBaseAuditVerifyItem;
import com.kingdee.eas.eqm.common.core.util.GeneCommonUtils;
import com.kingdee.eas.eqm.common.core.util.GeneResourceUtil;
import com.kingdee.eas.eqm.common.core.util.GeneSelectorUtils;
import com.kingdee.eas.eqm.common.core.verify.AbstractVerifyItem;
import com.kingdee.eas.eqm.common.core.verify.IVerifyItem;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;

public class EquipmentStandardOperationEditUI
extends SOEditUI {
    private static final long serialVersionUID = 1L;
    protected static final String COL_ARCHIVES = "equipmnetArchives";
    protected static final String COL_LOCATION = "equipmentLocation";
    protected static final String ARCHIVEQUERY = "com.kingdee.eas.eqm.archives.app.F7EquipmentArchivesQuery";
    private static final String PARENT = "parent";
    private static final String PERMISSION_ADDNEW = "eqm_equipmentstandardoperation_01view";
    private static final String PROP_FILE = "com.kingdee.eas.eqm.basedata.EquipmentStandardOperationResource";
    private static final String PROP_GENRESOURCE_FILE = "com.kingdee.eas.eqm.common.core.GeneResource";
    private static final String PROP_FORBIDDEN = ".forbidden";
    private static final String PROP_USE = ".use";

    @Override
    public ICoreBase getBizInterface() throws Exception {
        return EquipmentStandardOperationFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.editData.put("treeid", (EquipmentStandardOperationTreeInfo)this.getUIContext().get("ParentNode"));
        }
    }

    @Override
    protected IObjectValue createNewData() {
        return this.doCreateNewData(null);
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        EquipmentStaOprTaskInfo taskInfo = new EquipmentStaOprTaskInfo();
        taskInfo.setOrderNumber(10);
        return taskInfo;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected IObjectValue newInstanceData() {
        EquipmentStandardOperationInfo objectValue = new EquipmentStandardOperationInfo();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        objectValue.setDuration(new BigDecimal("0"));
        objectValue.setStorageOrgUnit((StorageOrgUnitInfo)this.getDefaultMainBizOrg());
        objectValue.setUsableStatus(GeneUsableStatusEnum.UNCHECKED);
        if (this.editData != null) {
            objectValue.put(PARENT, this.editData.getParent());
        } else {
            objectValue.put(PARENT, (EquipmentStandardOperationTreeInfo)this.getUIContext().get("ParentNode"));
        }
        return objectValue;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = this.getInnerSelectors();
        GeneSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String)PARENT);
        sic.add(new SelectorItemInfo("storageOrgUnit.CU.id"));
        sic.add(new SelectorItemInfo("tasks.*"));
        sic.add(new SelectorItemInfo("materials.*"));
        sic.add(new SelectorItemInfo("materials.material.*"));
        sic.add(new SelectorItemInfo("materials.material.baseUnit.name"));
        sic.add(new SelectorItemInfo("materials.material.baseUnit.number"));
        sic.add(new SelectorItemInfo("materials.material.baseUnit.measureUnitGroup.id"));
        sic.add(new SelectorItemInfo("materials.measureUnit.qtyPrecision"));
        sic.add(new SelectorItemInfo("materials.currency.precision"));
        sic.add(new SelectorItemInfo("materials.material.pricePrecision"));
        sic.add(new SelectorItemInfo("tools.*"));
        sic.add(new SelectorItemInfo("tools.tool.*"));
        sic.add(new SelectorItemInfo("tools.tool.baseUnit.name"));
        sic.add(new SelectorItemInfo("tools.tool.baseUnit.number"));
        sic.add(new SelectorItemInfo("tools.tool.baseUnit.measureUnitGroup.id"));
        sic.add(new SelectorItemInfo("tools.tool.baseUnit.qtyPrecision"));
        sic.add(new SelectorItemInfo("tools.measureUnit.qtyPrecision"));
        sic.add(new SelectorItemInfo("tools.currency.precision"));
        sic.add(new SelectorItemInfo("tools.tool.pricePrecision"));
        sic.add(new SelectorItemInfo("persons.maintainCraftItem.*"));
        sic.add(new SelectorItemInfo("persons.maintainCraftItem.parent"));
        sic.add(new SelectorItemInfo("persons.maintainCraftItem.parent.name"));
        sic.add(new SelectorItemInfo("persons.maintainCraftItem.parent.number"));
        sic.add(new SelectorItemInfo("persons.maintainCraftItem.skillLevel.name"));
        sic.add(new SelectorItemInfo("persons.maintainStaff.name"));
        sic.add(new SelectorItemInfo("persons.maintainStaff.number"));
        sic.add(new SelectorItemInfo("persons.currency.precision"));
        sic.add(new SelectorItemInfo("services.currency.precision"));
        sic.add(new SelectorItemInfo("assets.equipmentArchives.id"));
        sic.add(new SelectorItemInfo("assets.equipmentArchives.name"));
        sic.add(new SelectorItemInfo("assets.equipmentArchives.category.name"));
        sic.add(new SelectorItemInfo("assets.equipmentArchives.bizStatus"));
        sic.add(new SelectorItemInfo("assets.assetRestricts.staopr.name"));
        sic.add(new SelectorItemInfo("assets.assetRestricts.staopr.number"));
        sic.add(new SelectorItemInfo("assets.assetRestricts.*"));
        return sic;
    }

    public SorterItemCollection getSorters() {
        SorterItemCollection sorters = new SorterItemCollection();
        SorterItemInfo item = new SorterItemInfo("tasks.orderNumber");
        item.setSortType(SortType.ASCEND);
        sorters.add(item);
        return sorters;
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        return this.getBizInterface().getValue(pk, this.getMergedSelector(), this.getSorters());
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.taskEntryPanel.initLayout();
        this.assetEntryPanel.initLayout();
        this.assetRestrictEntryPanel.initLayout();
        this.restrictEntryPanel.initLayout();
        this.personEntryPanel.initLayout();
        this.materialEntryPanel.initLayout();
        this.toolEntryPanel.initLayout();
        this.serviceEntryPanel.initLayout();
        int tabHeight = 560;
        int tabWidth = 980;
        this.tabTasks.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, tabWidth, tabHeight));
        this.tabAssets.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, tabWidth, tabHeight));
        this.tabRestricts.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, tabWidth, tabHeight));
        MatteBorder b = BorderFactory.createMatteBorder(0, 8, 8, 8, this.tabRestricts.getParent().getBackground());
        this.tabRestricts.setBorder((Border)b);
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.toolBar.remove((Component)this.btnRelationDoc);
        this.toolBar.addComponentAfterComponent((Component)this.btnRelationDoc, (Component)this.btnRemove);
        this.btnRelationDoc.setTextIconDisStyle((short)2);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        EquipmentStandardOperationInfo info = (EquipmentStandardOperationInfo)this.getDataObject();
        String opr = this.getOprtState();
        if (this.getUIContext().get("FromWO") != null && GeneCommonUtils.isEmpty((Object)this.parent.getValue())) {
            this.actionAudit.setEnabled(false);
            this.actionEdit.setEnabled(false);
        } else if (opr.equals("ADDNEW")) {
            this.actionCancel.setEnabled(false);
            this.actionCancelCancel.setEnabled(false);
        } else if (GeneUsableStatusEnum.USABLE.equals((Object)info.getUsableStatus())) {
            this.setUsebleStatus();
        } else if (GeneUsableStatusEnum.FORBIDDEN.equals((Object)info.getUsableStatus())) {
            this.setForbiddenStatus();
        } else {
            this.setUnCheckedStatus();
        }
        this.actionRelationDoc.setEnabled(true);
        this.actionRelationDoc.setVisible(true);
    }

    private void setUsebleStatus() {
        this.actionCancel.setEnabled(true);
        this.actionCancelCancel.setEnabled(false);
        this.actionAudit.setEnabled(false);
        this.actionUnAudit.setEnabled(true);
    }

    private void setUnCheckedStatus() {
        this.actionCancel.setEnabled(false);
        this.actionAudit.setEnabled(true);
        this.actionUnAudit.setEnabled(false);
        this.actionCancelCancel.setEnabled(false);
    }

    private void setForbiddenStatus() {
        this.actionCancel.setEnabled(false);
        this.actionAudit.setEnabled(false);
        this.actionUnAudit.setEnabled(false);
        this.actionCancelCancel.setEnabled(true);
    }

    protected void initListener() {
        super.initListener();
        this.taskEntryPanel.initListener();
        this.assetEntryPanel.initListener();
        this.assetRestrictEntryPanel.initListener();
        this.restrictEntryPanel.initListener();
        this.personEntryPanel.initListener();
        this.materialEntryPanel.initListener();
        this.toolEntryPanel.initListener();
        this.serviceEntryPanel.initListener();
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtPlanOrgUnit;
    }

    protected String getMainBizOrgField() {
        return super.getMainBizOrgField();
    }

    protected void afterMainOrgChanged(String oldOrgId, String newOrgId) {
        this.materialEntryPanel.afterMainOrgChanged(oldOrgId, newOrgId);
        this.toolEntryPanel.afterMainOrgChanged(oldOrgId, newOrgId);
        this.personEntryPanel.afterMainOrgChanged(oldOrgId, newOrgId);
        this.serviceEntryPanel.afterMainOrgChanged(oldOrgId, newOrgId);
        this.taskEntryPanel.afterMainOrgChanged(oldOrgId, newOrgId);
        this.restrictEntryPanel.afterMainOrgChanged(oldOrgId, newOrgId);
        this.assetEntryPanel.afterMainOrgChanged(oldOrgId, newOrgId);
        this.assetRestrictEntryPanel.afterMainOrgChanged(oldOrgId, newOrgId);
        super.afterMainOrgChanged(oldOrgId, newOrgId);
    }

    protected void registerCustomerBindings() {
        super.registerCustomerBindings();
        this.initPlanOrgUnitPromptBoxSelectors();
        EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmtPlanOrgUnit, (String)PERMISSION_ADDNEW, (boolean)false, (OrgType)this.getMainBizOrgType(), (boolean)true, (boolean)false);
        this.taskEntryPanel.registerCustomerBindings();
        this.assetEntryPanel.registerCustomerBindings();
        this.assetRestrictEntryPanel.registerCustomerBindings();
        this.restrictEntryPanel.registerCustomerBindings();
        this.personEntryPanel.registerCustomerBindings();
        this.materialEntryPanel.registerCustomerBindings();
        this.toolEntryPanel.registerCustomerBindings();
        this.serviceEntryPanel.registerCustomerBindings();
        StandardOperationUtils.setColNonnegativeIntFormat(this.kdtTasks, "orderNumber");
        this.txtDuration.setRemoveingZeroInDispaly(false);
        this.txtDuration.setHorizontalAlignment(4);
        this.txtDuration.setMinimumValue((Comparable)new BigDecimal("0.0"));
        this.setKDTable();
    }

    protected void loadData() throws Exception {
        super.loadData();
    }

    private void initPlanOrgUnitPromptBoxSelectors() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("name"));
        selectors.add(new SelectorItemInfo("number"));
        selectors.add(new SelectorItemInfo("CU.*"));
        this.prmtPlanOrgUnit.setSelectorCollection(selectors);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        this.getVerifyManager().removeVerifyItem(DataBaseAuditVerifyItem.class);
        this.getVerifyManager().addVerifyItem((IVerifyItem)new EQMDataBaseUsableVerifyItem(this));
        this.getVerifyManager().addVerifyItem((IVerifyItem)new NotEmptyAssetVerifyItem(this, this.kdtAssets, COL_ARCHIVES, COL_LOCATION));
        this.getVerifyManager().addVerifyItem((IVerifyItem)new NotDupAssetVerifyItem(this, this.kdtAssets, COL_ARCHIVES, COL_LOCATION));
        this.getVerifyManager().addVerifyItem((IVerifyItem)new TaskNumberVerifyItem());
        this.getVerifyManager().addVerifyItem((IVerifyItem)new NotEmptyCraftsOrgUnitVerifyItem(this, this.kdtPersons, "maintainCrafts", "maintainOrgUnit"));
        this.taskEntryPanel.verifyInput(e);
        this.assetEntryPanel.verifyInput(e);
        this.assetRestrictEntryPanel.verifyInput(e);
        this.restrictEntryPanel.verifyInput(e);
        this.personEntryPanel.verifyInput(e);
        this.materialEntryPanel.verifyInput(e);
        this.toolEntryPanel.verifyInput(e);
        this.serviceEntryPanel.verifyInput(e);
        super.verifyInput(e);
        this.validateKdtAssets(this.kdtAssets);
        this.validateNotEmptyKdtCurrency(this.kdtPersons);
        this.validateNotEmptyKdtCurrency(this.kdtMaterails);
        this.validateNotEmptyKdtCurrency(this.kdtTools);
        this.validateNotEmptyKdtCurrency(this.kdtServices);
    }

    private void validateKdtAssets(KDTable kdtAssets) {
        for (int i = 0; i < kdtAssets.getRowCount(); ++i) {
            EquipmentStaOprAssetInfo asset = (EquipmentStaOprAssetInfo)kdtAssets.getRow(i).getUserObject();
            if (asset == null || asset.getAssetRestricts() == null) continue;
            for (int j = 0; j < asset.getAssetRestricts().size(); ++j) {
                EquipmentStaOprAssetRestrictInfo restrict = asset.getAssetRestricts().get(j);
                if (restrict.getStaopr() != null) continue;
                MsgBox.showInfo((String)GeneResourceUtil.getMsg((String)PROP_FILE, (String)"ENTRY_CANNOT_NULL", (Object[])new Object[]{new Integer(j + 1), this.kdtAssetRestricts.getHeadRow(0).getCell("standardOperation").getValue()}));
                if (kdtAssets != null) {
                    kdtAssets.getSelectManager().select(i, 0);
                }
                this.requestParentFocus((Container)this.kdtAssetRestricts);
                this.kdtAssetRestricts.getEditManager().editCellAt(j, this.kdtAssetRestricts.getColumnIndex("standardOperation"));
                SysUtil.abort();
            }
        }
    }

    private void validateNotEmptyKdtCurrency(KDTable kdtTable) {
        for (int i = 0; i < kdtTable.getRowCount(); ++i) {
            IRow row = kdtTable.getRow(i);
            if (row.getCell("currency").getValue() != null) continue;
            this.requestParentFocus((Container)kdtTable);
            MsgBox.showInfo((String)GeneResourceUtil.getMsg((String)PROP_FILE, (String)"CURRENCY_CANNOT_NULL", (Object[])new Object[]{kdtTable.getHeadRow(0).getCell(this.getHeadRow(kdtTable)).getValue()}));
            SysUtil.abort();
        }
    }

    private String getHeadRow(KDTable table) {
        String headRow = null;
        if (table.equals(this.kdtPersons)) {
            headRow = "maintainOrgUnit";
        } else if (table.equals(this.kdtMaterails)) {
            headRow = "storageOrgUnit";
        } else if (table.equals(this.kdtTools)) {
            headRow = "storageOrgUnit";
        } else if (table.equals(this.kdtServices)) {
            headRow = "purchaseOrgUnit";
        }
        return headRow;
    }

    private void requestParentFocus(Container child) {
        Container parent = child.getParent();
        while (parent != null) {
            if (parent instanceof KDTabbedPane) {
                ((KDTabbedPane)parent).setSelectedComponent((Component)child);
            }
            child = parent;
            parent = child.getParent();
        }
    }

    @Override
    public void loadFields() {
        this.taskEntryPanel.beforeLoadData();
        this.assetEntryPanel.beforeLoadData();
        this.assetRestrictEntryPanel.beforeLoadData();
        this.restrictEntryPanel.beforeLoadData();
        this.personEntryPanel.beforeLoadData();
        this.materialEntryPanel.beforeLoadData();
        this.toolEntryPanel.beforeLoadData();
        this.serviceEntryPanel.beforeLoadData();
        super.loadFields();
        this.btnAddLine.setVisible(false);
        this.btnRemoveLine.setVisible(false);
        this.btnInsertLine.setVisible(false);
        this.btnCopyLine.setVisible(false);
        this.taskEntryPanel.afterLoadData();
        this.assetEntryPanel.afterLoadData();
        this.assetRestrictEntryPanel.afterLoadData();
        this.restrictEntryPanel.afterLoadData();
        this.personEntryPanel.afterLoadData();
        this.materialEntryPanel.afterLoadData();
        this.toolEntryPanel.afterLoadData();
        this.serviceEntryPanel.afterLoadData();
        KDTextField txtInput = new KDTextField();
        txtInput.setMaxLength(44);
        this.kdtTasks.getColumn("taskNumber").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtInput));
        for (int rowIndex = 0; rowIndex < this.kdtAssets.getRowCount(); ++rowIndex) {
            IRow row = this.kdtAssets.getRow(rowIndex);
            EquipmentLocationInfo location = (EquipmentLocationInfo)row.getCell(COL_LOCATION).getValue();
            String storageOrg = ((StorageOrgUnitInfo)this.prmtPlanOrgUnit.getValue()).getId().toString();
            this.filterArchivesByLocation(location, storageOrg, this.kdtAssets, row.getRowIndex());
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCancel.setTextIconDisStyle((short)3);
        this.btnCancel.setText(EASResource.getString((String)"com.kingdee.eas.eqm.common.core.GeneResource.forbidden"));
        this.btnCancelCancel.setTextIconDisStyle((short)3);
        this.btnCancelCancel.setText(EASResource.getString((String)"com.kingdee.eas.eqm.common.core.GeneResource.use"));
        Icon icon = EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_relatedresources", (Locale)SysContext.getSysContext().getLocale());
        this.actionRelationDoc.putValue("SmallIcon", icon);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        this.checkPermission("ACTION_CANCEL", this.editData.getCU().getId().toString());
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IEquipmentStandardOperation biz = (IEquipmentStandardOperation)this.getBizInterface();
        biz.unuse((IObjectPK)pk);
        this.setOprtState("VIEW");
        this.afterDoAction(e, (IObjectPK)pk, EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Forbid _OK"));
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        this.checkPermission("ACTION_CANCELCANCEL", this.editData.getCU().getId().toString());
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IEquipmentStandardOperation biz = (IEquipmentStandardOperation)this.getBizInterface();
        biz.use((IObjectPK)pk);
        this.afterDoAction(e, (IObjectPK)pk, EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Startup_OK"));
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
    }

    private void afterDoAction(ActionEvent e, IObjectPK pk, String msg) throws Exception {
        this.setShowMessagePolicy(0);
        this.setMessageText(msg);
        this.setIsShowTextOnly(true);
        this.showMessage();
        this.setDataObject(this.getValue(pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
        this.setSave(true);
        this.setSaved(true);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        GeneUsableStatusEnum u;
        this.checkPermission("ACTION_MODIFY", this.getCUIDFromBizobject());
        if (this.editData != null && (u = this.editData.getUsableStatus()) != null && u != GeneUsableStatusEnum.UNCHECKED) {
            String info = EASResource.getString((String)PROP_GENRESOURCE_FILE, (String)"Msg_AuditedCannotEdit");
            MsgBox.showInfo((Component)((Object)this), (String)info);
            SysUtil.abort();
        }
        String tempOprState = this.getOprtState();
        this.setSave(false);
        this.setOprtState("EDIT");
        IObjectValue val = (IObjectValue)this.getUIContext().get("CURRENT.VO");
        this.getUIContext().put("CURRENT.VO", null);
        try {
            this.setDataObject(val);
        }
        catch (Exception ex) {
            this.setOprtState(tempOprState);
            this.getUIContext().put("CURRENT.VO", val);
            throw ex;
        }
        this.unLockUI();
        this.showMessageForStatus();
        this.initDataStatus();
        this.setDefaultFocused();
    }

    public void beforeActionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("com.kingdee.eas.framework.client.AbstractEditUI$ActionSubmit")) {
            this.taskEntryPanel.beforeSubmit();
            this.materialEntryPanel.beforeSubmit();
            this.toolEntryPanel.beforeSubmit();
            this.personEntryPanel.beforeSubmit();
            this.serviceEntryPanel.beforeSubmit();
            this.assetEntryPanel.beforeSubmit();
            this.assetRestrictEntryPanel.beforeSubmit();
            this.restrictEntryPanel.beforeSubmit();
        }
        super.beforeActionPerformed(e);
    }

    private String getCUIDFromBizobject() throws Exception {
        return this.getICGF().getCUID(this.editData.getId().toString());
    }

    private ICUIDGetterFacade getICGF() throws Exception {
        return CUIDGetterFacadeFactory.getRemoteInstance();
    }

    protected void setTitle() {
        this.setUITitle(this.resHelper.getString("this.title"));
    }

    public boolean isBizUnitOnly() {
        return true;
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue obj) {
        super.setFieldsNull(obj);
        if (obj instanceof EquipmentStandardOperationInfo) {
            EquipmentStandardOperationInfo info = (EquipmentStandardOperationInfo)obj;
            info.setName(null);
            info.setUsableStatus(GeneUsableStatusEnum.UNCHECKED);
        }
    }

    public boolean checkBeforeWindowClosing() {
        boolean flag = super.checkBeforeWindowClosing();
        if (flag && this.oprtState.equals(OprtState.ADDNEW) && this.actionRelationDoc.isEnabled() && this.editData != null && this.editData.getId() != null) {
            try {
                if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(this.editData.getId().toString()))) {
                    EquipmentDocBAFacadeFactory.getRemoteInstance().removeRelation(this.editData.getId().toString());
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return flag;
    }

    @Override
    public void actionRelationDoc_actionPerformed(ActionEvent e) throws Exception {
        UIContext uictx = new UIContext((Object)this);
        uictx.put((Object)"BOID", this.editData == null || this.editData.getId() == null ? null : this.editData.getId().toString());
        if (this.oprtState.equals(OprtState.ADDNEW) || this.oprtState.equals(OprtState.VIEW)) {
            uictx.put((Object)"ISEDIT", (Object)Boolean.FALSE);
        } else {
            uictx.put((Object)"ISEDIT", (Object)Boolean.TRUE);
        }
        uictx.put((Object)"mainOrg", this.prmtPlanOrgUnit.getValue());
        String uimode = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        UICreator.create((String)"com.kingdee.eas.eqm.basedata.client.EquipmentDocBAListUI", (String)uimode, (UIContext)uictx);
    }

    public void afterActionPerformed(ActionEvent e) {
        super.afterActionPerformed(e);
        ItemAction action = this.getActionFromActionEvent(e);
        if (action != null && action.equals(this.actionRemove)) {
            if (this.editData.getUsableStatus() == GeneUsableStatusEnum.FORBIDDEN) {
                this.setForbiddenStatus();
            } else if (this.editData.getUsableStatus() == GeneUsableStatusEnum.USABLE) {
                this.setUsebleStatus();
            } else {
                this.setUnCheckedStatus();
            }
        }
    }

    @Override
    public void storeFields() {
        EquipmentStaOprToolCollection tools;
        EquipmentStaOprMaterialCollection materials;
        super.storeFields();
        EquipmentStaOprPersonCollection entries = this.editData.getPersons();
        if (entries != null) {
            for (int i = 0; i < entries.size(); ++i) {
                if (entries.get(i).getMaintainCrafts() != null || entries.get(i).getMaintainOrgUnit() != null) continue;
                entries.removeObject(i);
                --i;
            }
        }
        if ((materials = this.editData.getMaterials()) != null) {
            BigDecimal amount = null;
            MeasureUnitInfo unitInfo = null;
            for (int i = 0; i < materials.size(); ++i) {
                amount = materials.get(i).getAmount();
                unitInfo = materials.get(i).getMeasureUnit();
                if (unitInfo == null) {
                    materials.get(i).setAmount(StandardOperationUtils.formatMoney(amount, 0));
                    continue;
                }
                materials.get(i).setAmount(StandardOperationUtils.formatMoney(amount, unitInfo.getQtyPrecision()));
            }
        }
        if ((tools = this.editData.getTools()) != null) {
            BigDecimal amount = null;
            MeasureUnitInfo unitInfo = null;
            for (int i = 0; i < tools.size(); ++i) {
                amount = tools.get(i).getAmount();
                unitInfo = tools.get(i).getMeasureUnit();
                if (unitInfo == null) {
                    tools.get(i).setAmount(StandardOperationUtils.formatMoney(amount, 0));
                    continue;
                }
                tools.get(i).setAmount(StandardOperationUtils.formatMoney(amount, unitInfo.getQtyPrecision()));
            }
        }
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
    }

    @Override
    protected KDTable getDetailTable() {
        if (this.panelDetails.getSelectedComponent() != null) {
            if (this.panelDetails.getSelectedIndex() == 0) {
                return this.kdtTasks;
            }
            if (this.panelDetails.getSelectedIndex() == 1) {
                return this.kdtTasks;
            }
            if (this.panelDetails.getSelectedIndex() == 2) {
                return this.kdtAssets;
            }
            if (this.panelDetails.getSelectedIndex() == 3) {
                return this.kdtRestricts;
            }
        }
        return this.kdtTasks;
    }

    private void setKDTable() {
        this.kdtTasks.setColumnMoveable(true);
        this.kdtTasks.setActiveCellStatus(1);
        this.kdtTasks.getActionMap().remove("AddRow");
        this.kdtTasks.getActionMap().remove("RemoveRow");
        this.kdtTasks.getActionMap().remove("Delete");
        this.kdtTasks.getActionMap().remove("Paste");
        this.kdtPersons.setColumnMoveable(true);
        this.kdtPersons.setActiveCellStatus(1);
        this.kdtPersons.getActionMap().remove("AddRow");
        this.kdtPersons.getActionMap().remove("RemoveRow");
        this.kdtPersons.getActionMap().remove("Delete");
        this.kdtPersons.getActionMap().remove("Paste");
        this.kdtMaterails.setColumnMoveable(true);
        this.kdtMaterails.setActiveCellStatus(1);
        this.kdtMaterails.getActionMap().remove("AddRow");
        this.kdtMaterails.getActionMap().remove("RemoveRow");
        this.kdtMaterails.getActionMap().remove("Delete");
        this.kdtMaterails.getActionMap().remove("Paste");
        this.kdtTools.setColumnMoveable(true);
        this.kdtTools.setActiveCellStatus(1);
        this.kdtTools.getActionMap().remove("AddRow");
        this.kdtTools.getActionMap().remove("RemoveRow");
        this.kdtTools.getActionMap().remove("Delete");
        this.kdtTools.getActionMap().remove("Paste");
        this.kdtServices.setColumnMoveable(true);
        this.kdtServices.setActiveCellStatus(1);
        this.kdtServices.getActionMap().remove("AddRow");
        this.kdtServices.getActionMap().remove("RemoveRow");
        this.kdtServices.getActionMap().remove("Delete");
        this.kdtServices.getActionMap().remove("Paste");
        this.kdtAssets.setColumnMoveable(true);
        this.kdtAssets.setActiveCellStatus(1);
        this.kdtAssets.getActionMap().remove("AddRow");
        this.kdtAssets.getActionMap().remove("RemoveRow");
        this.kdtAssets.getActionMap().remove("Delete");
        this.kdtAssets.getActionMap().remove("Paste");
        this.kdtAssetRestricts.setColumnMoveable(true);
        this.kdtAssetRestricts.setActiveCellStatus(1);
        this.kdtAssetRestricts.getActionMap().remove("AddRow");
        this.kdtAssetRestricts.getActionMap().remove("RemoveRow");
        this.kdtAssetRestricts.getActionMap().remove("Delete");
        this.kdtAssetRestricts.getActionMap().remove("Paste");
    }

    protected boolean isSuportCancel() {
        return true;
    }

    protected boolean isSuportBiz() {
        return true;
    }

    protected void filterArchivesByLocation(EquipmentLocationInfo location, String storageOrgUnitID, KDTable table, int rowIndex) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("initial", (Object)Boolean.TRUE, CompareType.EQUALS));
        items.add(new FilterItemInfo("bizStatus", (Object)new Integer(10), CompareType.EQUALS));
        items.add(new FilterItemInfo("planOrgUnit.id", (Object)storageOrgUnitID, CompareType.EQUALS));
        items.add(new FilterItemInfo("maintainOrgUnit.id", (Object)storageOrgUnitID, CompareType.EQUALS));
        items.add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitID, CompareType.EQUALS));
        if (location != null) {
            items.add(new FilterItemInfo("location.id", (Object)location.getId().toString(), CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and (#2 or #3 or #4) and #5");
        } else {
            filter.setMaskString("#0 and #1 and (#2 or #3 or #4)");
        }
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("location.name"));
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("location.number"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("storageOrgUnit.name"));
        selector.add(new SelectorItemInfo("planOrgUnit.name"));
        selector.add(new SelectorItemInfo("maintainOrgUnit.name"));
        selector.add(new SelectorItemInfo("bizStatus"));
        selector.add(new SelectorItemInfo("abcIdentify"));
        selector.add(new SelectorItemInfo("logic"));
        selector.add(new SelectorItemInfo("special"));
        selector.add(new SelectorItemInfo("initial"));
        selector.add(new SelectorItemInfo("billStatus"));
        selector.add(new SelectorItemInfo("storageOrgUnit.id"));
        view.setSelector(selector);
        try {
            EQMPromptDialogFactory.createPrmptList((KDTable)table, (int)table.getColumnIndex(COL_ARCHIVES), (int)rowIndex, (String)ARCHIVEQUERY, (EntityViewInfo)view);
            ObjectValueRender numberRender = new ObjectValueRender();
            numberRender.setFormat((IDataFormat)new BizDataFormat("$number$"));
            table.getCell(rowIndex, table.getColumnIndex(COL_ARCHIVES)).setRenderer((IBasicRender)numberRender);
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    protected String getMaterialIDForView() {
        int[] selectRows;
        if (this.panelDetails.getSelectedIndex() != 0) {
            return null;
        }
        if (this.panelTaskDetails.getSelectedIndex() == 1 && (selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdtMaterails)).length > 0 && selectRows[0] > -1) {
            MaterialInfo material = (MaterialInfo)this.kdtMaterails.getCell(selectRows[0], "materail").getValue();
            if (material == null) {
                return null;
            }
            return material.getId().toString();
        }
        if (this.panelTaskDetails.getSelectedIndex() == 2 && (selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdtTools)).length > 0 && selectRows[0] > -1) {
            MaterialInfo tool = (MaterialInfo)this.kdtTools.getCell(selectRows[0], "tool").getValue();
            if (tool == null) {
                return null;
            }
            return tool.getId().toString();
        }
        return null;
    }

    private class TaskNumberVerifyItem
    extends AbstractVerifyItem {
        private static final String PROP_SERVICE = ".service";
        private static final String PROP_TOOL = ".tool";
        private static final String PROP_MATERIAL = ".material";
        private static final String PROP_PERSON = ".person";

        private TaskNumberVerifyItem() {
        }

        public boolean verify() throws EASBizException, BOSException {
            List taskNumbers = EquipmentStandardOperationEditUI.this.getTaskNumbers();
            this.validateTaskNumber(taskNumbers, EquipmentStandardOperationEditUI.this.kdtPersons, EASResource.getString((String)"com.kingdee.eas.eqm.basedata.EquipmentStandardOperationResource.person"));
            this.validateTaskNumber(taskNumbers, EquipmentStandardOperationEditUI.this.kdtMaterails, EASResource.getString((String)"com.kingdee.eas.eqm.basedata.EquipmentStandardOperationResource.material"));
            this.validateTaskNumber(taskNumbers, EquipmentStandardOperationEditUI.this.kdtTools, EASResource.getString((String)"com.kingdee.eas.eqm.basedata.EquipmentStandardOperationResource.tool"));
            this.validateTaskNumber(taskNumbers, EquipmentStandardOperationEditUI.this.kdtServices, EASResource.getString((String)"com.kingdee.eas.eqm.basedata.EquipmentStandardOperationResource.service"));
            return true;
        }

        private void validateTaskNumber(List taskNumbers, KDTable table, String tabName) {
            List personTaskNumbers = EquipmentStandardOperationEditUI.this.getTaskNumberList(table);
            for (int i = 0; i < personTaskNumbers.size(); ++i) {
                if (taskNumbers.contains(personTaskNumbers.get(i))) continue;
                String msg = EASResource.getString((String)"com.kingdee.eas.eqm.basedata.EquipmentStandardOperationResource.taskNumberNotExist");
                msg = MessageFormat.format(msg, tabName, personTaskNumbers.get(i));
                MsgBox.showWarning((String)msg);
                EquipmentStandardOperationEditUI.this.selectCell(table, "task", i);
                SysUtil.abort();
            }
        }
    }
}

