/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.client.staopr;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainCraftsInfo;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainCraftsItemCollection;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainCraftsItemFactory;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainCraftsItemInfo;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainGroupCollection;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainGroupFactory;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainGroupTreeInfo;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainStaffInfo;
import com.kingdee.eas.eqm.basedata.EquipmentSkillLevelInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprPersonInfo;
import com.kingdee.eas.eqm.basedata.client.staopr.AbstractTaskRelatedEntryPanel;
import com.kingdee.eas.eqm.basedata.client.staopr.ICellPromptViewInfoModifer;
import com.kingdee.eas.eqm.basedata.client.staopr.PersonAmountCellsBinder;
import com.kingdee.eas.eqm.basedata.client.staopr.StandardOperationUtils;
import com.kingdee.eas.eqm.basedata.client.staopr.TableCellsPromptBoxBinder;
import com.kingdee.eas.eqm.basedata.client.staopr.TableColumnPromptBoxBinder;
import com.kingdee.eas.eqm.common.core.util.GeneCommonUtils;
import com.kingdee.eas.eqm.common.core.util.KDTableUtils;
import com.kingdee.eas.eqm.common.core.verify.IVerifyItem;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PersonEntryPanel
extends AbstractTaskRelatedEntryPanel {
    private PersonAmountCellsBinder amountCellsBinder;

    @Override
    protected void setColumnFormater() {
        super.setColumnFormater();
        StandardOperationUtils.setColHoursFormat(this.table, "hours");
        StandardOperationUtils.setColMoneyFormat(this.table, "rate");
        StandardOperationUtils.setColNonnegativeIntFormat(this.table, "amount");
        StandardOperationUtils.setColNonnegativeIntFormat(this.table, "lineCost");
    }

    @Override
    protected IObjectValue createNewData(boolean maxOrderNumber) {
        EquipmentStaOprPersonInfo personInfo = new EquipmentStaOprPersonInfo();
        personInfo.setLineCost(new BigDecimal("0.00"));
        personInfo.setRate(new BigDecimal("0.00"));
        personInfo.setHours(new BigDecimal("0.0"));
        personInfo.setAmount(0);
        if (this.getPlanOrgUnit() != null) {
            personInfo.setCurrency(this.getCurrencyInfo((OrgUnitInfo)this.getPlanOrgUnit()));
        }
        return personInfo;
    }

    @Override
    protected void afterInitLayout() {
        KDTableUtils.setEntryTitleVisible((DetailPanel)this.detailPanel, (boolean)false);
    }

    @Override
    protected void bindColumn() {
        TableColumnPromptBoxBinder craftsColumnBinder = new TableColumnPromptBoxBinder(this.table, "maintainCrafts", "com.kingdee.eas.eqm.basedata.app.F7EquipmentMaintainCraftsQuery");
        craftsColumnBinder.setDisplayFormat("$number$");
        craftsColumnBinder.addSelector("skillLevel.*").addSelector("parent.*").addSelector("skillLevelRate");
        craftsColumnBinder.bind();
        try {
            EQMPromptDialogFactory.createPrmptOrgDialog((KDTable)this.table, (String)"maintainOrgUnit", (String)"com.kingdee.eas.basedata.org.app.StorageItemQuery", null, (boolean)false, (OrgType)OrgType.Storage, (boolean)true, (boolean)false);
        }
        catch (BOSException e) {
            this.parent.handUIException(e);
        }
    }

    @Override
    protected void bindCell() {
        TableCellsPromptBoxBinder binder = null;
        binder = new TableCellsPromptBoxBinder(this.table, "maintainGroup", "com.kingdee.eas.eqm.basedata.app.F7EquipmentMaintainGroupQuery");
        binder.addModifer(new MaintainGroupViewModifer());
        binder.bind();
        binder = new TableCellsPromptBoxBinder(this.table, "maintainStaff", "com.kingdee.eas.eqm.basedata.app.F7EquipmentMaintainStaffQuery");
        binder.addModifer(new MaintainStaffViewModifer());
        binder.bind();
        binder = new TableCellsPromptBoxBinder(this.table, "techLevel", "com.kingdee.eas.eqm.basedata.app.F7EquipmentSkillLevelQuery");
        binder.addModifer(new SkillLevelCellViewInofModifer());
        binder.bind();
        this.amountCellsBinder = new PersonAmountCellsBinder(this);
        this.amountCellsBinder.bind();
    }

    @Override
    protected void initColumnPropertyChangeProcessor() {
        this.registerColumnPropertyChangeProcessor("rate", "calculatePersonLineCost");
        this.registerColumnPropertyChangeProcessor("amount", "calculatePersonLineCost");
        this.registerColumnPropertyChangeProcessor("hours", "calculatePersonLineCost");
    }

    private void changeMaintainCrafts(IRow row) {
        if (row.getCell("maintainCrafts").getValue() == null) {
            row.getCell("maintainCraftsName").setValue(null);
            row.getCell("techLevel").setValue(null);
            row.getCell("rate").setValue((Object)new BigDecimal("0.00"));
            return;
        }
        if (!(row.getCell("maintainCrafts").getValue() instanceof EquipmentMaintainCraftsItemInfo)) {
            return;
        }
        EquipmentMaintainCraftsItemInfo itemInfo = (EquipmentMaintainCraftsItemInfo)row.getCell("maintainCrafts").getValue();
        if (itemInfo != null) {
            row.getCell("maintainCraftsName").setValue((Object)itemInfo.getParent().getName());
            row.getCell("techLevel").setValue((Object)itemInfo.getSkillLevel());
            if (itemInfo.getSkillLevelRate() != null) {
                row.getCell("rate").setValue((Object)itemInfo.getSkillLevelRate());
            }
            row.getCell("maintainOrgUnit").setValue(null);
            this.changeMaintainOrgUnit(row);
        }
    }

    public void maintainOrgUnitChanged(KDTPropertyChangeEvent e) {
        IRow row = this.table.getRow(e.getRowIndex());
        this.changeMaintainOrgUnit(row);
        CurrencyInfo currency = (CurrencyInfo)row.getCell("currency").getValue();
        if (currency != null) {
            this.calculatePersonLineCost(e);
        }
    }

    private void changeMaintainOrgUnit(IRow row) {
        if (row.getCell("maintainOrgUnit").getValue() == null) {
            row.getCell("maintainGroup").setValue(null);
            row.getCell("maintainStaff").setValue(null);
            this.changeMaintainStaff(row);
            row.getCell("currency").setValue((Object)this.getCurrencyInfo((OrgUnitInfo)this.getPlanOrgUnit()));
        } else {
            StorageOrgUnitInfo storageInfo;
            CurrencyInfo currencyInfo;
            row.getCell("maintainGroup").setValue(null);
            row.getCell("maintainStaff").setValue(null);
            if (row.getCell("maintainCrafts").getValue() != null) {
                row.getCell("maintainCrafts").setValue(null);
                this.changeMaintainCrafts(row);
            }
            if ((currencyInfo = this.getCurrencyInfo((OrgUnitInfo)(storageInfo = (StorageOrgUnitInfo)row.getCell("maintainOrgUnit").getValue()))) != null) {
                row.getCell("currency").setValue((Object)currencyInfo);
            } else {
                currencyInfo = this.getCurrencyInfo((OrgUnitInfo)this.getPlanOrgUnit());
                row.getCell("currency").setValue((Object)currencyInfo);
            }
        }
    }

    public void maintainGroupChanged(KDTPropertyChangeEvent e) {
        IRow row = this.table.getRow(e.getRowIndex());
        if (row.getCell("maintainGroup").getValue() != null && row.getCell("maintainStaff").getValue() != null) {
            EquipmentMaintainGroupTreeInfo groupTree = (EquipmentMaintainGroupTreeInfo)row.getCell("maintainGroup").getValue();
            EquipmentMaintainStaffInfo staff = (EquipmentMaintainStaffInfo)row.getCell("maintainStaff").getValue();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemInfo item = new FilterItemInfo("parent.id", (Object)groupTree.getId());
            filter.getFilterItems().add(item);
            item = new FilterItemInfo("staff.id", (Object)staff.getId());
            filter.getFilterItems().add(item);
            try {
                EquipmentMaintainGroupCollection groupItems = EquipmentMaintainGroupFactory.getRemoteInstance().getEquipmentMaintainGroupCollection(view);
                if (groupItems.size() == 0) {
                    row.getCell("maintainStaff").setValue(null);
                }
            }
            catch (BOSException e1) {
                this.parent.handUIException(e1);
            }
        }
    }

    public void maintainStaffChanged(KDTPropertyChangeEvent e) {
        this.changeMaintainStaff(this.table.getRow(e.getRowIndex()));
    }

    public void changeMaintainStaff(IRow row) {
        this.amountCellsBinder.setEnabled(row.getRowIndex());
    }

    public void calculatePersonLineCost(KDTPropertyChangeEvent e) {
        IRow row = this.table.getRow(e.getRowIndex());
        BigDecimal result = null;
        Object amount = row.getCell("amount").getValue();
        Object hours = row.getCell("hours").getValue();
        Object rate = row.getCell("rate").getValue();
        if (amount != null && hours != null && rate != null) {
            result = ((BigDecimal)rate).multiply((BigDecimal)hours).multiply(new BigDecimal(amount + ""));
        }
        if (result == null) {
            row.getCell("lineCost").setValue(null);
        } else {
            if (result.longValue() > 999999999999L) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.eqm.basedata.BASEDATAAutoGenerateResource", (String)"102_PersonEntryPanel"));
            }
            CurrencyInfo currency = (CurrencyInfo)row.getCell("currency").getValue();
            int precision = 2;
            if (currency != null) {
                precision = currency.getPrecision();
            }
            row.getCell("lineCost").setValue((Object)StandardOperationUtils.formatMoney(result, precision));
        }
    }

    @Override
    protected void tableEditStopped(KDTEditEvent e) {
        super.tableEditStopped(e);
        IRow row = this.table.getRow(e.getRowIndex());
        if (e.getColIndex() == this.table.getColumnIndex("maintainCrafts")) {
            if (e != null && e.getOldValue() == null && e.getValue() == null) {
                return;
            }
            Object value = this.table.getCell(e.getRowIndex(), "maintainCrafts").getValue();
            if (value == null) {
                row.getCell("maintainCraftsName").setValue(null);
                row.getCell("techLevel").setValue(null);
                row.getCell("rate").setValue((Object)new BigDecimal("0.00"));
                return;
            }
            if (!(value instanceof EquipmentMaintainCraftsItemInfo)) {
                return;
            }
            EquipmentMaintainCraftsItemInfo craftsItemInfo = (EquipmentMaintainCraftsItemInfo)value;
            EquipmentSkillLevelInfo skillLevelInfo = null;
            BigDecimal skillLevelRate = null;
            if (craftsItemInfo != null) {
                skillLevelInfo = craftsItemInfo.getSkillLevel();
                skillLevelRate = craftsItemInfo.getSkillLevelRate();
                row.getCell("maintainCrafts").setValue((Object)craftsItemInfo.getParent());
                row.getCell("maintainCraftsName").setValue((Object)craftsItemInfo.getParent().getName());
                if (skillLevelInfo.getName() == null || skillLevelInfo.getName().trim().equals("")) {
                    skillLevelInfo = null;
                }
                row.getCell("techLevel").setValue((Object)skillLevelInfo);
                if (skillLevelRate != null) {
                    row.getCell("rate").setValue((Object)skillLevelRate);
                }
                row.getCell("maintainOrgUnit").setValue(null);
                this.changeMaintainOrgUnit(row);
            }
        } else if (e.getColIndex() == this.table.getColumnIndex("techLevel")) {
            EquipmentMaintainCraftsInfo craftsItemInfo = (EquipmentMaintainCraftsInfo)this.table.getCell(e.getRowIndex(), "maintainCrafts").getValue();
            if (craftsItemInfo == null) {
                return;
            }
            if (GeneCommonUtils.equals((Object)e.getValue(), (Object)e.getOldValue())) {
                return;
            }
            Object value = this.table.getCell(e.getRowIndex(), "techLevel").getValue();
            FilterInfo filter = new FilterInfo();
            FilterItemInfo item = new FilterItemInfo("parent.id", (Object)craftsItemInfo.getId().toString());
            filter.getFilterItems().add(item);
            if (value == null) {
                item = new FilterItemInfo("skillLevel", (Object)"RYxyvQSzRRSYEXCuh8Deag8GUVM=");
                filter.getFilterItems().add(item);
            } else {
                EquipmentSkillLevelInfo skillLevelInfo = (EquipmentSkillLevelInfo)value;
                item = new FilterItemInfo("skillLevel.id", (Object)skillLevelInfo.getId().toString());
                filter.getFilterItems().add(item);
            }
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("skillLevel.id"));
            try {
                BigDecimal skillLevelRate;
                EquipmentMaintainCraftsItemCollection craftsItems = EquipmentMaintainCraftsItemFactory.getRemoteInstance().getEquipmentMaintainCraftsItemCollection(view);
                if (craftsItems.size() > 0 && (skillLevelRate = craftsItems.get(0).getSkillLevelRate()) != null) {
                    this.table.getCell(e.getRowIndex(), "rate").setValue((Object)skillLevelRate);
                }
            }
            catch (BOSException exp) {
                this.parent.handUIException(exp);
            }
        }
    }

    @Override
    public void beforeSubmit() {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            IRow row = this.table.getRow(i);
            if (row.getCell("hours").getValue() == null) {
                row.getCell("hours").setValue((Object)new BigDecimal("0.0"));
            }
            if (row.getCell("amount").getValue() == null) {
                row.getCell("amount").setValue((Object)new Integer("1"));
            }
            if (row.getCell("rate").getValue() != null) continue;
            row.getCell("rate").setValue((Object)new BigDecimal("0.00"));
        }
    }

    @Override
    protected void verifyInput(ActionEvent e) throws Exception {
        this.parent.getVerifyManager().addVerifyItem((IVerifyItem)new AbstractTaskRelatedEntryPanel.LineCostTooLongVerifyItem());
    }

    @Override
    protected void afterCurrencyChanged(KDTPropertyChangeEvent e) {
        this.calculatePersonLineCost(e);
    }

    private final class MaintainStaffViewModifer
    implements ICellPromptViewInfoModifer {
        private MaintainStaffViewModifer() {
        }

        @Override
        public void modify(KDTable table, String columnName, int rowIndex, EntityViewInfo viewInfo) {
            Object maintainOrgCellValue = table.getRow(rowIndex).getCell("maintainOrgUnit").getValue();
            StorageOrgUnitInfo storageOrgUnitInfo = null;
            if (maintainOrgCellValue != null) {
                storageOrgUnitInfo = (StorageOrgUnitInfo)maintainOrgCellValue;
            }
            KDBizPromptBox staffF7 = (KDBizPromptBox)table.getRow(rowIndex).getCell("maintainStaff").getEditor().getComponent();
            if (storageOrgUnitInfo != null) {
                staffF7.setCurrentMainBizOrgUnit((OrgUnitInfo)storageOrgUnitInfo, OrgType.Storage);
                FilterItemInfo filterItem = new FilterItemInfo("maintainOrgUnit.id", (Object)storageOrgUnitInfo.getId().toString(), CompareType.EQUALS);
                viewInfo.getFilter().getFilterItems().add(filterItem);
            } else {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.eqm.basedata.EquipmentStandardOperationResource.mustSelectMaintainOrg"));
                SysUtil.abort();
            }
            Object maintainGroupCellValue = table.getRow(rowIndex).getCell("maintainGroup").getValue();
            if (maintainGroupCellValue != null) {
                EquipmentMaintainGroupTreeInfo group = (EquipmentMaintainGroupTreeInfo)maintainGroupCellValue;
                FilterItemInfo filterItem = new FilterItemInfo("group.parent.id", (Object)group.getId().toString(), CompareType.EQUALS);
                viewInfo.getFilter().getFilterItems().add(filterItem);
            }
        }
    }

    private final class MaintainGroupViewModifer
    implements ICellPromptViewInfoModifer {
        private MaintainGroupViewModifer() {
        }

        @Override
        public void modify(KDTable table, String columnName, int rowIndex, EntityViewInfo viewInfo) {
            Object maintainOrgCellValue = table.getRow(rowIndex).getCell("maintainOrgUnit").getValue();
            KDBizPromptBox groupF7 = (KDBizPromptBox)table.getRow(rowIndex).getCell("maintainGroup").getEditor().getComponent();
            StorageOrgUnitInfo storageOrgUnitInfo = null;
            if (maintainOrgCellValue != null) {
                storageOrgUnitInfo = (StorageOrgUnitInfo)maintainOrgCellValue;
            }
            if (storageOrgUnitInfo != null) {
                groupF7.setCurrentMainBizOrgUnit((OrgUnitInfo)storageOrgUnitInfo, OrgType.Storage);
                FilterItemInfo filterItem = new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitInfo.getId().toString(), CompareType.EQUALS);
                viewInfo.getFilter().getFilterItems().add(filterItem);
            } else {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.eqm.basedata.EquipmentStandardOperationResource.mustSelectMaintainOrg"));
                SysUtil.abort();
            }
        }
    }

    private final class SkillLevelCellViewInofModifer
    implements ICellPromptViewInfoModifer {
        private SkillLevelCellViewInofModifer() {
        }

        @Override
        public void modify(KDTable table, String columnName, int rowIndex, EntityViewInfo viewInfo) {
            Object value = table.getRow(rowIndex).getCell("maintainCrafts").getValue();
            if (value == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.eqm.basedata.EquipmentStandardOperationResource.mustSelectMaintainCraft"));
                SysUtil.abort();
                return;
            }
            Set skillIds = this.getCraftsItemSkillIds((EquipmentMaintainCraftsInfo)value);
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)skillIds, CompareType.INCLUDE));
        }

        private Set getCraftsItemSkillIds(EquipmentMaintainCraftsInfo maintainCraftsInfo) {
            HashSet<String> set = new HashSet<String>();
            try {
                FilterInfo filter = new FilterInfo();
                FilterItemInfo item = new FilterItemInfo("parent.id", (Object)maintainCraftsInfo.getId().toString());
                filter.getFilterItems().add(item);
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(filter);
                CoreBaseCollection maintaincraftsitemCollection = EquipmentMaintainCraftsItemFactory.getRemoteInstance().getCollection(view);
                Iterator iter = maintaincraftsitemCollection.iterator();
                while (iter != null && iter.hasNext()) {
                    EquipmentMaintainCraftsItemInfo craftsItemInfo = (EquipmentMaintainCraftsItemInfo)iter.next();
                    set.add(craftsItemInfo.getSkillLevel().getId().toString());
                }
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
            return set;
        }
    }
}

