/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.client.staopr;

import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTextField;

public class StandardOperationUtils {
    public static final String DISPLAY_FORMAT = "displayFormat";
    public static final Object EDIT_FORMAT = "editFormat";
    public static final Map F7_FORMAT_NAME_NUMBER = new HashMap();
    public static final BigDecimal BigDecimal_MaxValue = new BigDecimal("9999999999999.99999999");
    public static final BigDecimal BigDecimal_MinValue = new BigDecimal("-9999999999999.99999999");
    public static final BigDecimal BigDecimal_Zero = new BigDecimal("0.0");
    public static final int DEFAULT_PRECISION = 2;
    public static final Map F7_FORMAT_NUMBER_NUMBER;

    public static KDBizPromptBox createPrmptList(KDTable tblMain, String column, String queryInfo, String[] properties, Object[] values, CompareType[] types, Map config) {
        String displayFormatStr = "$name$";
        String editFormatStr = "$number$";
        if (config.get(DISPLAY_FORMAT) != null) {
            displayFormatStr = config.get(DISPLAY_FORMAT).toString();
        }
        if (config.get(EDIT_FORMAT) != null) {
            editFormatStr = config.get(EDIT_FORMAT).toString();
        }
        EntityViewInfo view = new EntityViewInfo();
        if (properties != null && values != null && types != null) {
            FilterInfo filter = new FilterInfo();
            for (int i = 0; i < properties.length; ++i) {
                filter.getFilterItems().add(new FilterItemInfo(properties[i], values[i], types[i]));
            }
            view.setFilter(filter);
        }
        KDBizPromptBox tblMain_column_PromptBox = new KDBizPromptBox();
        tblMain_column_PromptBox.setQueryInfo(queryInfo);
        tblMain_column_PromptBox.setVisible(true);
        tblMain_column_PromptBox.setEditable(true);
        tblMain_column_PromptBox.setDisplayFormat(displayFormatStr);
        tblMain_column_PromptBox.setEditFormat(editFormatStr);
        tblMain_column_PromptBox.setCommitFormat(editFormatStr);
        tblMain_column_PromptBox.setEntityViewInfo(view);
        KDTDefaultCellEditor tblMain_column_CellEditor = new KDTDefaultCellEditor((IKDEditor)tblMain_column_PromptBox);
        tblMain.getColumn(column).setEditor((ICellEditor)tblMain_column_CellEditor);
        ObjectValueRender tblMain_column_OVR = new ObjectValueRender();
        tblMain_column_OVR.setFormat((IDataFormat)new BizDataFormat(displayFormatStr));
        tblMain.getColumn(column).setRenderer((IBasicRender)tblMain_column_OVR);
        return tblMain_column_PromptBox;
    }

    public static KDFormattedTextField setColMoneyFormat(KDTable kdt, String colName) {
        KDFormattedTextField textField = new KDFormattedTextField();
        textField.setName(kdt.getName() + "_" + colName);
        textField.setVisible(true);
        textField.setEditable(true);
        textField.setHorizontalAlignment(4);
        textField.setDataType(1);
        textField.setMinimumValue((Comparable)new BigDecimal("0.0"));
        textField.setMaximumValue((Comparable)new BigDecimal("999999999999.9999999999"));
        textField.setPrecision(2);
        textField.setSupportedEmpty(true);
        textField.setRemoveingZeroInDispaly(false);
        textField.setNegatived(false);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)textField);
        kdt.getColumn(colName).setEditor((ICellEditor)cellEditor);
        kdt.getColumn(colName).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)2));
        return textField;
    }

    public static KDTextField setColRemarkFormat(KDTable kdt, String colName) {
        KDTextField textField = new KDTextField();
        if (kdt.getColumn(colName) != null) {
            textField.setMaxLength(80);
            KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)textField);
            kdt.getColumn(colName).setEditor((ICellEditor)cellEditor);
        }
        return textField;
    }

    public static KDFormattedTextField setColHoursFormat(KDTable kdt, String colName) {
        KDFormattedTextField textField = new KDFormattedTextField();
        textField.setName(kdt.getName() + "_" + colName);
        textField.setVisible(true);
        textField.setEditable(true);
        textField.setHorizontalAlignment(4);
        textField.setDataType(1);
        textField.setMinimumValue((Comparable)new BigDecimal("0.00"));
        textField.setMaximumValue((Comparable)new BigDecimal("99999.99"));
        textField.setPrecision(2);
        textField.setSupportedEmpty(true);
        textField.setRemoveingZeroInDispaly(false);
        textField.setNegatived(false);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)textField);
        kdt.getColumn(colName).setEditor((ICellEditor)cellEditor);
        kdt.getColumn(colName).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)2));
        return textField;
    }

    public static KDFormattedTextField setColNonnegativeIntFormat(KDTable kdt, String colName) {
        KDFormattedTextField textField = new KDFormattedTextField();
        textField.setName(kdt.getName() + "_" + colName);
        textField.setVisible(true);
        textField.setEditable(true);
        textField.setHorizontalAlignment(4);
        textField.setDataType(0);
        textField.setMinimumValue((Comparable)Integer.valueOf("0"));
        textField.setMaximumValue((Comparable)new Integer(Integer.MAX_VALUE));
        textField.setNegatived(false);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)textField);
        kdt.getColumn(colName).setEditor((ICellEditor)cellEditor);
        kdt.getColumn(colName).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        return textField;
    }

    public static BigDecimal formatMoney1(BigDecimal result) {
        if (result.compareTo(new BigDecimal("0.005")) == -1) {
            return new BigDecimal("0.00");
        }
        String s = result.toString();
        double d = Double.valueOf(s) * 100.0;
        String l = Math.round(d) + "";
        if (l.length() == 0) {
            return new BigDecimal("0.00");
        }
        if (l.length() == 1) {
            return new BigDecimal("0.0" + l);
        }
        BigDecimal b = new BigDecimal(l.substring(0, l.length() - 2) + "." + l.substring(l.length() - 2) + "");
        return b;
    }

    public static BigDecimal formatMoney(BigDecimal result, int precision) {
        if (result == null) {
            return null;
        }
        BigDecimal temp = new BigDecimal(result.toString()).setScale(precision, 4);
        return temp;
    }

    public static Object findFirstDupElement(List list) {
        if (list.size() < 2) {
            return null;
        }
        Object result = null;
        block0: for (int i = 0; i < list.size() - 1; ++i) {
            Object current = list.get(i);
            if (current == null) continue;
            for (int j = i + 1; j < list.size(); ++j) {
                Object other = list.get(j);
                if (!current.equals(other)) continue;
                result = current;
                break block0;
            }
        }
        return result;
    }

    public static void setEntryTitleWidth(DetailPanel detailPanel, int width) {
        KDPanel controlPanel = (KDPanel)detailPanel.getComponent(0);
        KDContainer conTitle = (KDContainer)controlPanel.getComponent(0);
        controlPanel.remove((Component)conTitle);
        controlPanel.add((Component)conTitle, (Object)new KDLayout.Constraints(0, 5, width, 19, 5));
    }

    public static void setEntryTitleStyle(DetailPanel detailPanel, int style) {
        KDPanel controlPanel = (KDPanel)detailPanel.getComponent(0);
        KDContainer conTitle = (KDContainer)controlPanel.getComponent(0);
        conTitle.setTitleStyle(style);
        conTitle.setOpaque(false);
    }

    public static int caculateInsertTaskOrderNumber(KDTable table, String columnName, boolean maxNumber) {
        int orderNum = 10;
        if (table.getRowCount() == 0) {
            return orderNum;
        }
        if (table.getSelectManager().size() == 0 || maxNumber) {
            Object value = table.getRow(table.getRowCount() - 1).getCell(columnName).getValue();
            int v = value == null ? 0 : (Integer)value;
            double d = (double)(v + 10) / 10.0;
            orderNum = (int)d * 10;
            return orderNum;
        }
        int top = table.getSelectManager().get().getTop();
        try {
            if (top == 0) {
                IRow row = table.getRow(0);
                int lastNumber = (Integer)row.getCell(columnName).getValue();
                if (lastNumber <= 20) {
                    return orderNum;
                }
                String numStr = lastNumber - 10 + "";
                orderNum = Integer.valueOf(numStr.substring(0, numStr.length() - 1) + "0");
            } else {
                int num2;
                int num1 = (Integer)table.getRow(top - 1).getCell(columnName).getValue();
                int avg = (num1 + (num2 = ((Integer)table.getRow(top).getCell(columnName).getValue()).intValue())) / 2;
                orderNum = avg > 10 ? avg : orderNum;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return orderNum;
    }

    public static void selectCell(KDTable table, String columnName, int rowIndex) {
        int columnIndex = table.getColumnIndex(columnName);
        table.getSelectManager().select(rowIndex, columnIndex);
        table.getSelectManager().setActiveRowIndex(rowIndex);
        if (columnIndex > -1) {
            KDTEditManager editManager = table.getEditManager();
            editManager.editCellAt(rowIndex, columnIndex);
        }
    }

    public static void setMoneyFormatByCurrency(KDTable kdt, String colName, String currencyColName, boolean canUsed) {
        for (int rowIndex = 0; rowIndex < kdt.getRowCount(); ++rowIndex) {
            CurrencyInfo currency = (CurrencyInfo)kdt.getRow(rowIndex).getCell(currencyColName).getValue();
            int precision = 2;
            if (currency != null) {
                precision = currency.getPrecision();
            }
            StandardOperationUtils.setRowNumberEditor(precision, kdt, rowIndex, new String[]{colName}, BigDecimal_MaxValue, BigDecimal_Zero, canUsed);
        }
    }

    public static void setMoneyFormatByMaterial(KDTable kdt, String colName, String materialColName, boolean canUsed) {
        for (int rowIndex = 0; rowIndex < kdt.getRowCount(); ++rowIndex) {
            MaterialInfo material = (MaterialInfo)kdt.getRow(rowIndex).getCell(materialColName).getValue();
            int precision = 2;
            if (material != null) {
                precision = material.getPricePrecision();
            }
            StandardOperationUtils.setRowNumberEditor(precision, kdt, rowIndex, new String[]{colName}, BigDecimal_MaxValue, BigDecimal_Zero, canUsed);
        }
    }

    public static void setRowNumberEditor(int precision, KDTable table, int rowIndex, String[] cols, BigDecimal maxValue, BigDecimal minValue, boolean canUsed) {
        IRow row = table.getRow(rowIndex);
        for (int i = 0; i < cols.length; ++i) {
            KDFormattedTextField txtNum = StandardOperationUtils.getNumberEditor(precision, maxValue, minValue);
            txtNum.setEditable(canUsed);
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)txtNum);
            row.getCell(cols[i]).setEditor((ICellEditor)editor);
            row.getCell(cols[i]).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)precision));
        }
    }

    public static KDFormattedTextField getNumberEditor(int precision, BigDecimal maxValue, BigDecimal minValue) {
        KDFormattedTextField colTxtField = new KDFormattedTextField();
        colTxtField.setDataType(1);
        colTxtField.setPrecision(precision);
        colTxtField.setHorizontalAlignment(4);
        colTxtField.setSupportedEmpty(true);
        colTxtField.setRemoveingZeroInDispaly(false);
        colTxtField.setRemoveingZeroInEdit(false);
        colTxtField.setNegatived(false);
        if (minValue != null) {
            colTxtField.setMinimumValue((Comparable)minValue);
        }
        if (minValue == null || colTxtField.getMinimumValue() == null || colTxtField.getMinimumValue().compareTo(BigDecimal_MinValue) == -1) {
            colTxtField.setMinimumValue((Comparable)BigDecimal_MinValue);
        }
        if (maxValue != null) {
            colTxtField.setMaximumValue((Comparable)maxValue);
        }
        if (maxValue == null || colTxtField.getMaximumValue() == null || colTxtField.getMaximumValue().compareTo(BigDecimal_MaxValue) == 1) {
            colTxtField.setMaximumValue((Comparable)BigDecimal_MaxValue);
        }
        return colTxtField;
    }

    public static KDBizPromptBox createTableCellsPromptBox(KDTable table, int rowIndex, String columnName, String queryInfo, EntityViewInfo ev) {
        KDBizPromptBox promptBox = new KDBizPromptBox();
        promptBox.setQueryInfo(queryInfo);
        promptBox.setVisible(true);
        promptBox.setEnabled(true);
        promptBox.setDisplayFormat("$number$");
        promptBox.setEditFormat("$number$");
        promptBox.setCommitFormat("$number$");
        promptBox.setUseCacheObject(false);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("name"));
        selectors.add(new SelectorItemInfo("number"));
        promptBox.setSelectorCollection(selectors);
        promptBox.setEntityViewInfo(ev);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((IKDEditor)promptBox);
        ICell cell = table.getRow(rowIndex).getCell(columnName);
        cell.setEditor((ICellEditor)cellEditor);
        ObjectValueRender valueRender = new ObjectValueRender();
        valueRender.setFormat((IDataFormat)new BizDataFormat("$name$"));
        cell.setRenderer((IBasicRender)valueRender);
        return promptBox;
    }

    static {
        F7_FORMAT_NAME_NUMBER.put(DISPLAY_FORMAT, "$name");
        F7_FORMAT_NAME_NUMBER.put(EDIT_FORMAT, "number");
        F7_FORMAT_NUMBER_NUMBER = new HashMap();
        F7_FORMAT_NUMBER_NUMBER.put(DISPLAY_FORMAT, "$number");
        F7_FORMAT_NUMBER_NUMBER.put(EDIT_FORMAT, "number");
    }
}

