/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.basedata.EquipmentLocationCollection;
import com.kingdee.eas.eqm.basedata.EquipmentLocationFactory;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.basedata.EquipmentMeterApplyCollection;
import com.kingdee.eas.eqm.basedata.EquipmentMeterApplyFactory;
import com.kingdee.eas.eqm.basedata.EquipmentMeterApplyInfo;
import com.kingdee.eas.eqm.basedata.EquipmentMeterCollection;
import com.kingdee.eas.eqm.basedata.EquipmentMeterFactory;
import com.kingdee.eas.eqm.basedata.EquipmentMeterInfo;
import com.kingdee.eas.eqm.basedata.EquipmentReadingCollection;
import com.kingdee.eas.eqm.basedata.EquipmentReadingFactory;
import com.kingdee.eas.eqm.basedata.EquipmentReadingHistoryCollection;
import com.kingdee.eas.eqm.basedata.EquipmentReadingHistoryFactory;
import com.kingdee.eas.eqm.basedata.EquipmentReadingHistoryInfo;
import com.kingdee.eas.eqm.basedata.EquipmentReadingInfo;
import com.kingdee.eas.eqm.basedata.IEquipmentLocation;
import com.kingdee.eas.eqm.basedata.IEquipmentMeter;
import com.kingdee.eas.eqm.basedata.IEquipmentMeterApply;
import com.kingdee.eas.eqm.basedata.IEquipmentReading;
import com.kingdee.eas.eqm.basedata.IEquipmentReadingHistory;
import com.kingdee.eas.eqm.common.eqmcore.app.util.DataImportEqmTools;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;

public class DataImportEqmLocationMeterTools {
    private static final String RESOURCE_PATH = "com.kingdee.eas.eqm.basedata.EquipmentLocationResource";

    public static EquipmentMeterApplyInfo getMeterApplyInfo(Context ctx, String location_number, String meter_number, String orgId) throws TaskExternalException {
        EquipmentLocationInfo locationInfo = DataImportEqmLocationMeterTools.getEquipmentLocationInfo(ctx, location_number, orgId);
        EquipmentMeterInfo meterInfo = DataImportEqmLocationMeterTools.getEquipmentMeterInfoWithUnit(ctx, meter_number, orgId);
        EquipmentReadingHistoryInfo readingInfo = DataImportEqmLocationMeterTools.getReadingHistoryInfo(ctx, location_number, meter_number, orgId);
        EquipmentMeterApplyInfo info = new EquipmentMeterApplyInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("meter", (Object)meterInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("location", (Object)locationInfo.getId()));
        viewInfo.setFilter(filter);
        try {
            IEquipmentMeterApply iEquipmentMeterApply = EquipmentMeterApplyFactory.getLocalInstance(ctx);
            EquipmentMeterApplyCollection equipmentMeterApplyCollection = iEquipmentMeterApply.getEquipmentMeterApplyCollection(viewInfo);
            if (equipmentMeterApplyCollection != null && equipmentMeterApplyCollection.size() > 0) {
                throw new TaskExternalException(DataImportEqmLocationMeterTools.getResourceMsg("location") + "\uff1a" + locationInfo.getName() + DataImportEqmLocationMeterTools.getResourceMsg("meter_isExisting") + "\uff1a" + meterInfo.getName());
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        if (readingInfo != null) {
            DataImportEqmLocationMeterTools.changeReadingToMeterApply(info, readingInfo);
        } else {
            info.setLocation(locationInfo);
            info.setMeter(meterInfo);
        }
        return info;
    }

    public static void changeReadingToMeterApply(EquipmentMeterApplyInfo meterApplyInfo, EquipmentReadingHistoryInfo readingInfo) {
        meterApplyInfo.setAccumulatedValue(readingInfo.getAccumulatedValue());
        meterApplyInfo.setActivedStatus(readingInfo.isActivedStatus());
        meterApplyInfo.setReadingWay(readingInfo.getReadingWay());
        meterApplyInfo.setReadingDate(readingInfo.getReadingDate());
        meterApplyInfo.setCurrentValue(readingInfo.getCurrentValue());
    }

    public static EquipmentMeterInfo getEquipmentMeterInfoWithUnit(Context ctx, String number, String orgId) throws TaskExternalException {
        if (number == null || "".equals(number)) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        IEquipmentMeter iEquipmentMeter = null;
        EquipmentMeterCollection equipmentMeterCollection = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("unit.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("unit.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("unit.qtyPrecision"));
        try {
            DataImportTools.AddFilterItemInfo((FilterInfo)filter, (String)"storageOrgUnit", (Object)orgId);
            DataImportTools.AddFilterItemInfo((FilterInfo)filter, (String)"number", (Object)number);
            filter.setMaskString("#0 and #1");
            viewInfo.setFilter(filter);
            iEquipmentMeter = EquipmentMeterFactory.getLocalInstance(ctx);
            equipmentMeterCollection = iEquipmentMeter.getEquipmentMeterCollection(viewInfo);
            if (equipmentMeterCollection == null || equipmentMeterCollection.size() <= 0) {
                throw new TaskExternalException(ResourceUtils.getMessage((String)"com.kingdee.eas.eqm.basedata.BASEDATAAutoGenerateResource", (String)"120_DataImportEqmLocationMeterTools"));
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return equipmentMeterCollection.get(0);
    }

    public static void saveReadingInfo(Context ctx, EquipmentMeterInfo meterInfo, EquipmentLocationInfo locationInfo, EquipmentMeterApplyInfo applyInfo, StorageOrgUnitInfo storageInfo) throws TaskExternalException {
        EquipmentReadingInfo info = new EquipmentReadingInfo();
        info.setParent(applyInfo);
        info.setLocation(locationInfo);
        info.setMeter(meterInfo);
        info.setStorageOrgUnit(storageInfo);
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setActivedStatus(true);
        try {
            EquipmentReadingFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(DataImportEqmLocationMeterTools.getResourceMsg("saveReadingInfo_Err"));
        }
        catch (BOSException e) {
            throw new TaskExternalException(DataImportEqmLocationMeterTools.getResourceMsg("saveReadingInfo_Err"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EquipmentReadingInfo getReadingInfo(Context ctx, String location_number, String meter_number, String orgId) throws TaskExternalException {
        EquipmentReadingCollection equipmentReadingCollection;
        if (location_number == null || "".equals(location_number)) {
            return null;
        }
        if (meter_number == null || "".equals(meter_number)) {
            return null;
        }
        EquipmentLocationInfo locationInfo = DataImportEqmLocationMeterTools.getEquipmentLocationInfo(ctx, location_number, orgId);
        EquipmentMeterInfo meterInfo = DataImportEqmLocationMeterTools.getEquipmentMeterInfo(ctx, meter_number, orgId);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("currentValue"));
        viewInfo.getSelector().add(new SelectorItemInfo("accumulatedValue"));
        viewInfo.getSelector().add(new SelectorItemInfo("readingDate"));
        viewInfo.getSelector().add(new SelectorItemInfo("activedStatus"));
        viewInfo.getSelector().add(new SelectorItemInfo("averageCalWay"));
        viewInfo.getSelector().add(new SelectorItemInfo("readingWay"));
        viewInfo.getSelector().add(new SelectorItemInfo("meter.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("location.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("storageOrgUnit"));
        viewInfo.getSelector().add(new SelectorItemInfo("CU.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("meter", (Object)meterInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("location", (Object)locationInfo.getId()));
        viewInfo.setFilter(filter);
        try {
            IEquipmentReading iEquipmentReading = EquipmentReadingFactory.getLocalInstance(ctx);
            equipmentReadingCollection = iEquipmentReading.getEquipmentReadingCollection(viewInfo);
            if (equipmentReadingCollection != null && equipmentReadingCollection.size() > 0) return equipmentReadingCollection.get(0);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return equipmentReadingCollection.get(0);
    }

    public static EquipmentMeterInfo getEquipmentMeterInfo(Context ctx, String number, String orgId) throws TaskExternalException {
        FilterInfo filter = new FilterInfo();
        IEquipmentMeter iEquipmentMeter = null;
        EquipmentMeterCollection equipmentMeterCollection = null;
        if (number == null || "".equals(number)) {
            return null;
        }
        try {
            DataImportTools.AddFilterItemInfo((FilterInfo)filter, (String)"storageOrgUnit", (Object)orgId);
            DataImportTools.AddFilterItemInfo((FilterInfo)filter, (String)"number", (Object)number);
            filter.setMaskString("#0 and #1");
            iEquipmentMeter = EquipmentMeterFactory.getLocalInstance(ctx);
            equipmentMeterCollection = iEquipmentMeter.getEquipmentMeterCollection(DataImportEqmTools.getViewInfo((FilterInfo)filter));
            if (equipmentMeterCollection == null || equipmentMeterCollection.size() <= 0) {
                throw new TaskExternalException(ResourceUtils.getMessage((String)"com.kingdee.eas.eqm.basedata.BASEDATAAutoGenerateResource", (String)"120_DataImportEqmLocationMeterTools"));
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return equipmentMeterCollection.get(0);
    }

    public static EquipmentLocationInfo getEquipmentLocationInfo(Context ctx, String number, String orgId) throws TaskExternalException {
        FilterInfo filter = new FilterInfo();
        IEquipmentLocation iEquipmentLocation = null;
        EquipmentLocationCollection equipmentLocationCollection = null;
        if (number == null || "".equals(number)) {
            return null;
        }
        try {
            DataImportTools.AddFilterItemInfo((FilterInfo)filter, (String)"storageOrgUnit", (Object)orgId);
            DataImportTools.AddFilterItemInfo((FilterInfo)filter, (String)"number", (Object)number);
            filter.setMaskString("#0 and #1");
            iEquipmentLocation = EquipmentLocationFactory.getLocalInstance(ctx);
            equipmentLocationCollection = iEquipmentLocation.getEquipmentLocationCollection(DataImportEqmTools.getViewInfo((FilterInfo)filter));
            if (equipmentLocationCollection == null || equipmentLocationCollection.size() <= 0) {
                throw new TaskExternalException(ResourceUtils.getMessage((String)"com.kingdee.eas.eqm.basedata.BASEDATAAutoGenerateResource", (String)"121_DataImportEqmLocationMeterTools"));
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return equipmentLocationCollection.get(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EquipmentReadingHistoryInfo getReadingHistoryInfo(Context ctx, String location_number, String meter_number, String orgId) throws TaskExternalException {
        EquipmentReadingHistoryCollection equipmentReadingHistoryCollection;
        if (location_number == null || "".equals(location_number)) {
            return null;
        }
        if (meter_number == null || "".equals(meter_number)) {
            return null;
        }
        EquipmentLocationInfo locationInfo = DataImportEqmLocationMeterTools.getEquipmentLocationInfo(ctx, location_number, orgId);
        EquipmentMeterInfo meterInfo = DataImportEqmLocationMeterTools.getEquipmentMeterInfo(ctx, meter_number, orgId);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("currentValue"));
        viewInfo.getSelector().add(new SelectorItemInfo("accumulatedValue"));
        viewInfo.getSelector().add(new SelectorItemInfo("ReadingHistoryDate"));
        viewInfo.getSelector().add(new SelectorItemInfo("activedStatus"));
        viewInfo.getSelector().add(new SelectorItemInfo("averageCalWay"));
        viewInfo.getSelector().add(new SelectorItemInfo("initValue"));
        viewInfo.getSelector().add(new SelectorItemInfo("ReadingHistoryWay"));
        viewInfo.getSelector().add(new SelectorItemInfo("meter.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("location.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("location.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("storageOrgUnit"));
        viewInfo.getSelector().add(new SelectorItemInfo("CU.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("meter", (Object)meterInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("location", (Object)locationInfo.getId()));
        viewInfo.setFilter(filter);
        try {
            IEquipmentReadingHistory iEquipmentReadingHistory = EquipmentReadingHistoryFactory.getLocalInstance(ctx);
            equipmentReadingHistoryCollection = iEquipmentReadingHistory.getEquipmentReadingHistoryCollection(viewInfo);
            if (equipmentReadingHistoryCollection != null && equipmentReadingHistoryCollection.size() > 0) return equipmentReadingHistoryCollection.get(0);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return equipmentReadingHistoryCollection.get(0);
    }

    public static String getResourceMsg(String key) {
        return ResourceUtils.getMessage((String)RESOURCE_PATH, (String)key);
    }
}

