/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprTaskCollection;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprTaskFactory;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprTaskInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStandardOperationCollection;
import com.kingdee.eas.eqm.basedata.EquipmentStandardOperationFactory;
import com.kingdee.eas.eqm.basedata.EquipmentStandardOperationInfo;
import com.kingdee.eas.eqm.basedata.datatask.DataImportEqmStaOprTools;
import com.kingdee.eas.eqm.common.datatask.EQMBaseDataTransmission;
import com.kingdee.eas.eqm.common.eqmcore.app.util.DataImportEqmTools;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Locale;

public class DataImportEqmStaOprTask
extends EQMBaseDataTransmission {
    private static final int DURATION_PRECISION = 2;
    private static final int TaskNum_MAX_SIZE = 44;
    private static final int REMARK_MAX_SIZE = 255;
    private static final int DEMAND_MAX_SIZE = 200;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return EquipmentStaOprTaskFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        EquipmentStaOprTaskInfo excelInfo = new EquipmentStaOprTaskInfo();
        DataImportEqmStaOprTools.virifyExcelCellValueNull(this.getDataString(hsData, "Fparent_storageOrgUnit_number"), "PlanOrg_Is_Null");
        StorageOrgUnitInfo orgInfo = null;
        try {
            orgInfo = this.getStorageOrgUnitInfoFromNumber(ctx, this.getDataString(hsData, "Fparent_storageOrgUnit_number"));
        }
        catch (BOSException e2) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("PlanOrg_Not_Exist"));
        }
        this.isAuthorizedOrgUnit(ctx, this.getDataString(hsData, "Fparent_storageOrgUnit_number"));
        DataImportEqmStaOprTools.virifyExcelCellValueNull(this.getDataString(hsData, "FParent_number"), "StaOpr_Num_Is_Null");
        try {
            excelInfo.setStandardOperation(this.getStaOpr(ctx, orgInfo, this.getDataString(hsData, "FParent_number")));
        }
        catch (Exception e1) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("StaOpr_Num_Error"));
        }
        DataImportEqmStaOprTools.virifyExcelCellValueNull(this.getDataString(hsData, "FOrderNumber"), "Task_OrderNum_Is_Null");
        try {
            if (DataImportEqmTools.getDataint((Hashtable)hsData, (String)"FOrderNumber") < 0) {
                throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Task_OrderNum_Less_Zero"));
            }
            excelInfo.setOrderNumber(DataImportEqmTools.getDataint((Hashtable)hsData, (String)"FOrderNumber"));
        }
        catch (Exception e) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Task_OrderNum_Error"));
        }
        try {
            this.virifyTaskNumber(ctx, this.getDataString(hsData, "FTaskNumber"), excelInfo.getStandardOperation());
        }
        catch (BOSException e1) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("TaskNum_Error"));
        }
        excelInfo.setTaskNumber(this.getDataString(hsData, "FTaskNumber"));
        this.virifyTaskRemark(this.getDataString(hsData, "FRemark"));
        excelInfo.setRemark(this.getDataString(hsData, "FRemark"));
        this.virifyTaskDemand(this.getDataString(hsData, "FDemand"));
        excelInfo.setDemand(this.getDataString(hsData, "FDemand"));
        if (DataImportEqmStaOprTools.isExcelCellValueNull(this.getDataString(hsData, "FDuration"))) {
            excelInfo.setDuration(new BigDecimal("0"));
        } else {
            excelInfo.setDuration(DataImportEqmTools.getNumByPrecision((String)this.getDataString(hsData, "FDuration"), (int)2, (String)DataImportEqmStaOprTools.getStaOprResourceMsg("Duration"), (boolean)true));
        }
        return excelInfo;
    }

    private void virifyTaskDemand(String demand) throws TaskExternalException {
        if (DataImportEqmStaOprTools.isOverMaxSize(demand, 200)) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Task_Demand_Over_Max_Size"));
        }
    }

    private void virifyTaskRemark(String remark) throws TaskExternalException {
        if (DataImportEqmStaOprTools.isExcelCellValueNull(remark)) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Task_Des_Is_Null"));
        }
        if (DataImportEqmStaOprTools.isOverMaxSize(remark, 255)) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Remark_Over_Max_Size"));
        }
    }

    private EquipmentStandardOperationInfo getStaOpr(Context ctx, StorageOrgUnitInfo orgInfo, String number) throws BOSException, TaskExternalException {
        EquipmentStandardOperationCollection staOprs = EquipmentStandardOperationFactory.getLocalInstance(ctx).getEquipmentStandardOperationCollection(this.getStaOprView(number, orgInfo));
        if (staOprs.get(0).getId() != null) {
            return staOprs.get(0);
        }
        throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("StaOpr_Num_Error"));
    }

    private EntityViewInfo getStaOprView(String number, StorageOrgUnitInfo orgInfo) {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgInfo.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        return view;
    }

    private void virifyTaskNumber(Context ctx, String taskNumber, EquipmentStandardOperationInfo staOpr) throws TaskExternalException, BOSException {
        if (DataImportEqmStaOprTools.isExcelCellValueNull(taskNumber)) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("TaskNum_Is_Null"));
        }
        if (DataImportEqmStaOprTools.isOverMaxSize(taskNumber, 44)) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("TaskNum_Over_Max_Size"));
        }
        if (this.isDupl(ctx, taskNumber, staOpr)) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("TaskNum_Dupl"));
        }
    }

    private boolean isDupl(Context ctx, String taskNumber, EquipmentStandardOperationInfo staOpr) throws BOSException, TaskExternalException {
        EquipmentStaOprTaskCollection tasks = EquipmentStaOprTaskFactory.getLocalInstance(ctx).getEquipmentStaOprTaskCollection(this.getTaskView(taskNumber, staOpr.getId().toString()));
        return tasks.size() > 0;
    }

    private EntityViewInfo getTaskView(String taskNumber, String staOprID) {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("taskNumber", (Object)taskNumber, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("standardOperation.id", (Object)staOprID, CompareType.EQUALS));
        view.setFilter(filter);
        return view;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            Locale locale = ctx.getLocale();
            if (DataImportEqmStaOprTools.isExcelCellValueNull(rs.getString("tasks.orderNumber"))) {
                return null;
            }
            this.putTable(result, "Fparent_storageOrgUnit_number", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "Fparent_storageOrgUnit_name_" + locale, rs.getString("storageOrgUnit.name"));
            this.putTable(result, "FOrderNumber", rs.getString("tasks.orderNumber"));
            this.putTable(result, "FTaskNumber", rs.getString("tasks.taskNumber"));
            this.putTable(result, "FRemark", rs.getString("tasks.remark"));
            this.putTable(result, "FDemand", rs.getString("tasks.demand"));
            this.putTable(result, "FDuration", DataImportEqmTools.getNumByPrecision((String)rs.getString("tasks.duration"), (int)2));
            this.putTable(result, "FParent_number", rs.getString("number"));
            this.putTable(result, "FParent_name_" + locale, rs.getString("name"));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.eqm.basedata.app.EquipmentStaOprTaskImExQuery";
    }

    public String getDataString(Hashtable hsData, String fieldName) {
        return (String)((DataToken)hsData.get((Object)fieldName)).data;
    }

    public void putTable(Hashtable htable, Object key, Object value) {
        if (value != null) {
            htable.put(key, value);
        }
    }

    protected String getImportPermItemName() {
        return "eqm_equipmentstandardoperation_20baseImport";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        EntityViewInfo viewInfo = (EntityViewInfo)this.getContextParameter("mainQuery");
        return viewInfo.getFilter();
    }
}

