/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.eqm.archives.EquipmentArchivesFactory;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.archives.EquipmentBizStatus;
import com.kingdee.eas.eqm.archives.IEquipmentArchives;
import com.kingdee.eas.eqm.basedata.EquipmentLocationFactory;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.basedata.IEquipmentLocation;
import com.kingdee.eas.eqm.basedata.IsolationTempAssetFactory;
import com.kingdee.eas.eqm.basedata.IsolationTempAssetInfo;
import com.kingdee.eas.eqm.basedata.IsolationTempFactory;
import com.kingdee.eas.eqm.common.datatask.EQMBaseDataTransmission;
import com.kingdee.eas.eqm.common.eqmcore.app.util.DataImportEqmTools;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Hashtable;
import java.util.Locale;

public class IsolationTempAssetTransmission
extends EQMBaseDataTransmission {
    private static final String RESOURCE_PATH = "com.kingdee.eas.eqm.basedata.IsolationtempResource";
    private static final String EqmArchives_Type = "ET";
    private static final String Location_Type = "LT";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return IsolationTempAssetFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String locationNumber;
        CoreBaseInfo entryInfoByNumber;
        String orgNum;
        String str = null;
        StorageOrgUnitInfo storageInfo = null;
        IsolationTempAssetInfo entryInfo = new IsolationTempAssetInfo();
        Hashtable baseData = hsData;
        String storageOrgNumber = this.getDataString(baseData, "FParent_storageOrgUnit_number");
        if (storageOrgNumber == null || "".equals(storageOrgNumber.trim())) {
            throw new TaskExternalException(this.getResourceMsg("storageOrgUnit_CanNotNull"));
        }
        if (this.isAuthorizedOrgUnit(ctx, storageOrgNumber)) {
            try {
                storageInfo = this.getStorageOrgUnitInfoFromNumber(ctx, storageOrgNumber);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        if (!storageOrgNumber.equals(orgNum = storageInfo.getNumber())) {
            throw new TaskExternalException("");
        }
        String number = this.getDataString(baseData, "FParent_number");
        if (number == null || "".equals(number.trim())) {
            throw new TaskExternalException(this.getResourceMsg("number_CanNotNull"));
        }
        try {
            CoreBaseInfo headInfo = this.getInfoByNumber(ctx, (ICoreBase)IsolationTempFactory.getLocalInstance(ctx), number, storageOrgNumber, null);
            headInfo.put("storageOrgUnit", (Object)storageInfo);
            entryInfo.put("parent", headInfo);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        EquipmentArchivesInfo archivesInfo = null;
        EquipmentLocationInfo locationInfo = null;
        String archivesNumber = this.getDataString(baseData, "FEqmArchives_number");
        if (archivesNumber != null && archivesNumber.trim().length() > 0) {
            try {
                IEquipmentArchives biz = EquipmentArchivesFactory.getLocalInstance((Context)ctx);
                archivesInfo = (EquipmentArchivesInfo)this.getInfoByNumber(ctx, (ICoreBase)biz, archivesNumber, storageOrgNumber, this.buildArchivesORLocationView((ICoreBase)biz, archivesNumber, storageOrgNumber));
                entryInfoByNumber = this.getAssetInfoByNumber(ctx, this.getController(ctx), number, storageOrgNumber, archivesNumber, EqmArchives_Type);
                if (entryInfoByNumber != null) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.eqm.planning.EquipmentCheckingRegulationResource", (String)"archivesNumberOnly", (Locale)ContextUtils.getLocaleFromEnv()));
                }
                entryInfo.setEqmArchives(archivesInfo);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        if ((locationNumber = this.getDataString(baseData, "FLocation_number")) != null && locationNumber.trim().length() > 0) {
            try {
                if (archivesInfo == null) {
                    IEquipmentLocation biz = EquipmentLocationFactory.getLocalInstance(ctx);
                    locationInfo = (EquipmentLocationInfo)this.getInfoByNumber(ctx, (ICoreBase)biz, locationNumber, storageOrgNumber, this.buildArchivesORLocationView((ICoreBase)biz, locationNumber, storageOrgNumber));
                }
                if ((archivesNumber == null || archivesNumber.trim().length() == 0) && (entryInfoByNumber = this.getAssetInfoByNumber(ctx, this.getController(ctx), number, storageOrgNumber, locationNumber, Location_Type)) != null) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.eqm.planning.EquipmentCheckingRegulationResource", (String)"locationNumberOnly", (Locale)ContextUtils.getLocaleFromEnv()));
                }
                entryInfo.setLocation(locationInfo);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        if (archivesInfo != null && locationNumber != null && locationNumber.trim().length() > 0) {
            entryInfo.setLocation(archivesInfo.getLocation());
        } else if (archivesInfo == null && (locationNumber == null || locationNumber.trim().length() == 0)) {
            throw new TaskExternalException(this.getResourceMsg("CheckArchiveAndlocation"));
        }
        str = this.getDataString(baseData, "FRemark");
        DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)entryInfo, (String)str, (String)"remark", (int)255);
        entryInfo.setRemark(str);
        return entryInfo;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            Locale locale = ctx.getLocale();
            this.putTable(result, "FParent_storageOrgUnit_number", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "FParent_storageOrgUnit_name", rs.getString("storageOrgUnit.name"));
            this.putTable(result, "FParent_number", rs.getString("number"));
            this.putTable(result, "FParent_name", rs.getString("name"));
            this.putTable(result, "FEqmArchives_number", rs.getString("eqmArchives.number"));
            this.putTable(result, "FEqmArchives_name", rs.getString("eqmArchives.name"));
            this.putTable(result, "FEqmArchives_categoryName", rs.getString("category.name"));
            this.putTable(result, "FEqmArchives_bizStatus", EquipmentBizStatus.getEnum((int)rs.getInt("eqmArchives.bizStatus")) == null ? null : EquipmentBizStatus.getEnum((int)rs.getInt("eqmArchives.bizStatus")).getAlias(locale));
            this.putTable(result, "FLocation_number", rs.getString("location.number"));
            this.putTable(result, "FLocation_name", rs.getString("location.name"));
            this.putTable(result, "FRemark", rs.getString("assets.remark"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private String getResourceMsg(String key) {
        return ResourceBase.getString((String)RESOURCE_PATH, (String)key, (Locale)ContextUtils.getLocaleFromEnv());
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.eqm.basedata.app.ExpIsolationTempAssetQuery";
    }

    protected String getImportPermItemName() {
        return "eqm_isolationtemp_10import";
    }

    protected CoreBaseInfo getAssetInfoByNumber(Context ctx, ICoreBase biz, String number, String storageOrgNumber, String entryNumber, String type) throws BOSException {
        if (biz == null) {
            return null;
        }
        if (number == null || number.trim().length() == 0) {
            return null;
        }
        if (entryNumber == null || entryNumber.toString().trim().length() == 0) {
            return null;
        }
        String ckey = biz.getType() + number + storageOrgNumber + entryNumber + type;
        if (this.cache_entryInfo.get(ckey) != null) {
            return (CoreBaseInfo)this.cache_entryInfo.get(ckey);
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (EqmArchives_Type.equals(type)) {
            filter.getFilterItems().add(new FilterItemInfo("eqmArchives.number", (Object)entryNumber));
        } else if (Location_Type.equals(type)) {
            filter.getFilterItems().add(new FilterItemInfo("location.number", (Object)entryNumber));
            filter.getFilterItems().add(new FilterItemInfo("eqmArchives.number is null"));
        }
        filter.getFilterItems().add(new FilterItemInfo("parent.number", (Object)number));
        if (storageOrgNumber != null) {
            filter.getFilterItems().add(new FilterItemInfo("parent.storageOrgUnit.number", (Object)storageOrgNumber));
        }
        ev.setFilter(filter);
        CoreBaseCollection coll = biz.getCollection(ev);
        CoreBaseInfo voInfo = null;
        if (coll != null && coll.size() > 0) {
            voInfo = coll.get(0);
            this.cache_entryInfo.put(ckey, voInfo);
        }
        return voInfo;
    }

    private EntityViewInfo buildArchivesORLocationView(ICoreBase biz, String number, String planStorageOrgNumber) throws BOSException {
        if (biz == null) {
            return null;
        }
        if (number == null || number.trim().length() == 0) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        if (new EquipmentArchivesInfo().getBOSType().equals((Object)biz.getType())) {
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("number"));
            viewInfo.getSelector().add(new SelectorItemInfo("name"));
            viewInfo.getSelector().add(new SelectorItemInfo("location.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("location.number"));
            viewInfo.getSelector().add(new SelectorItemInfo("location.name"));
            filter.getFilterItems().add(new FilterItemInfo("initial", (Object)Boolean.TRUE, CompareType.EQUALS));
            if (planStorageOrgNumber != null) {
                filter.getFilterItems().add(new FilterItemInfo("planOrgUnit.number", (Object)planStorageOrgNumber));
            }
        } else if (new EquipmentLocationInfo().getBOSType().equals((Object)biz.getType())) {
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("number"));
            viewInfo.getSelector().add(new SelectorItemInfo("name"));
            if (planStorageOrgNumber != null) {
                filter.getFilterItems().add(new FilterItemInfo("planOrgUnit.number", (Object)planStorageOrgNumber));
            }
        }
        viewInfo.setFilter(filter);
        return viewInfo;
    }
}

