/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.BooleanDataType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.eqm.archives.EquipmentArchivesFactory;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.archives.IEquipmentArchives;
import com.kingdee.eas.eqm.basedata.EquipmentLocationFactory;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.basedata.IEquipmentLocation;
import com.kingdee.eas.eqm.basedata.IsolationTempFactory;
import com.kingdee.eas.eqm.basedata.IsolationTempRestoreFactory;
import com.kingdee.eas.eqm.basedata.IsolationTempRestoreInfo;
import com.kingdee.eas.eqm.common.core.util.GeneStringUtils;
import com.kingdee.eas.eqm.common.datatask.EQMBaseDataTransmission;
import com.kingdee.eas.eqm.common.eqmcore.app.util.DataImportEqmTools;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Hashtable;
import java.util.Locale;

public class IsolationTempRestoreTransmission
extends EQMBaseDataTransmission {
    private static final String RESOURCE_PATH = "com.kingdee.eas.eqm.basedata.IsolationtempResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return IsolationTempRestoreFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String locationNumber;
        String orgNum;
        String str = null;
        StorageOrgUnitInfo storageInfo = null;
        IsolationTempRestoreInfo entryInfo = new IsolationTempRestoreInfo();
        Hashtable baseData = hsData;
        String storageOrgNumber = this.getDataString(baseData, "FParent_storageOrgUnit_number");
        if (storageOrgNumber == null || "".equals(storageOrgNumber.trim())) {
            throw new TaskExternalException(this.getResourceMsg("storageOrgUnit_CanNotNull"));
        }
        if (this.isAuthorizedOrgUnit(ctx, storageOrgNumber)) {
            try {
                storageInfo = this.getStorageOrgUnitInfoFromNumber(ctx, storageOrgNumber);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        if (!storageOrgNumber.equals(orgNum = storageInfo.getNumber())) {
            throw new TaskExternalException("");
        }
        String number = this.getDataString(baseData, "FParent_number");
        if (number == null || "".equals(number.trim())) {
            throw new TaskExternalException(this.getResourceMsg("number_CanNotNull"));
        }
        try {
            CoreBaseInfo headInfo = this.getInfoByNumber(ctx, (ICoreBase)IsolationTempFactory.getLocalInstance(ctx), number, storageOrgNumber, null);
            headInfo.put("storageOrgUnit", (Object)storageInfo);
            entryInfo.put("parent", headInfo);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        String serialNumberStr = this.getDataString(baseData, "FSerialNumber");
        DataImportEqmTools.checkIsNull((Context)ctx, (AbstractObjectValue)entryInfo, (String)serialNumberStr, (String)"serialNumber");
        int serialNumber = this.getInt(ctx, (AbstractObjectValue)entryInfo, serialNumberStr, "serialNumber");
        try {
            CoreBaseInfo entryInfoByNumber = this.getEntryInfoByNumber(ctx, this.getController(ctx), number, storageOrgNumber, new Integer(serialNumber).toString(), this.buildEntrytView(number, storageOrgNumber, new Integer(serialNumber)));
            if (entryInfoByNumber != null && serialNumber == (Integer)entryInfoByNumber.get("serialNumber")) {
                throw new TaskExternalException(this.getResourceMsg("duplicateSerialNumber"));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        entryInfo.setSerialNumber(serialNumber);
        str = this.getDataString(baseData, "FName");
        DataImportEqmTools.checkIsNull((Context)ctx, (AbstractObjectValue)entryInfo, (String)str, (String)"name");
        DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)entryInfo, (String)str, (String)"name", (int)255);
        entryInfo.setName(str);
        EquipmentArchivesInfo archivesInfo = null;
        EquipmentLocationInfo locationInfo = null;
        String archivesNumber = this.getDataString(baseData, "FEqmArchives_number");
        if (archivesNumber != null && archivesNumber.trim().length() > 0) {
            try {
                IEquipmentArchives biz = EquipmentArchivesFactory.getLocalInstance((Context)ctx);
                archivesInfo = (EquipmentArchivesInfo)this.getInfoByNumber(ctx, (ICoreBase)biz, archivesNumber, storageOrgNumber, this.buildArchivesORLocationView((ICoreBase)biz, archivesNumber, storageOrgNumber));
                entryInfo.setEqmArchives(archivesInfo);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        if ((locationNumber = this.getDataString(baseData, "FLocation_number")) != null && locationNumber.trim().length() > 0) {
            try {
                if (archivesInfo == null) {
                    IEquipmentLocation biz = EquipmentLocationFactory.getLocalInstance(ctx);
                    locationInfo = (EquipmentLocationInfo)this.getInfoByNumber(ctx, (ICoreBase)biz, locationNumber, storageOrgNumber, this.buildArchivesORLocationView((ICoreBase)biz, locationNumber, storageOrgNumber));
                    entryInfo.setLocation(locationInfo);
                }
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        if (archivesInfo != null && locationNumber != null && locationNumber.trim().length() > 0) {
            entryInfo.setLocation(archivesInfo.getLocation());
        }
        if (GeneStringUtils.isEmpty((String)(str = this.getDataString(baseData, "FTurnOff")))) {
            entryInfo.setTurnOff(false);
        } else {
            entryInfo.setTurnOff(DataImportEqmTools.getBooleanDataType((String)str));
        }
        str = this.getDataString(baseData, "FRemark");
        DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)entryInfo, (String)str, (String)"remark", (int)255);
        entryInfo.setRemark(str);
        return entryInfo;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            Locale locale = ctx.getLocale();
            this.putTable(result, "FParent_storageOrgUnit_number", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "FParent_storageOrgUnit_name", rs.getString("storageOrgUnit.name"));
            this.putTable(result, "FParent_number", rs.getString("number"));
            this.putTable(result, "FParent_name", rs.getString("name"));
            this.putTable(result, "FSerialNumber", rs.getString("restore.serialNumber"));
            this.putTable(result, "FName", rs.getString("restore.name"));
            this.putTable(result, "FEqmArchives_number", rs.getString("eqmArchives.number"));
            this.putTable(result, "FEqmArchives_name", rs.getString("eqmArchives.name"));
            this.putTable(result, "FLocation_number", rs.getString("location.number"));
            this.putTable(result, "FLocation_name", rs.getString("location.name"));
            this.putTable(result, "FTurnOff", BooleanDataType.getEnum((String)rs.getString("restore.turnOff")).getAlias(locale));
            this.putTable(result, "FRemark", rs.getString("restore.remark"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private String getResourceMsg(String key) {
        return ResourceBase.getString((String)RESOURCE_PATH, (String)key, (Locale)ContextUtils.getLocaleFromEnv());
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.eqm.basedata.app.ExpIsolationTempRestoreQuery";
    }

    protected String getImportPermItemName() {
        return "eqm_isolationtemp_10import";
    }

    protected EntityViewInfo buildEntrytView(String headNumber, String storageOrgNumber, Integer entryNumber) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("serialNumber"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("serialNumber", (Object)entryNumber));
        filter.getFilterItems().add(new FilterItemInfo("parent.number", (Object)headNumber));
        if (storageOrgNumber != null) {
            filter.getFilterItems().add(new FilterItemInfo("parent.storageOrgUnit.number", (Object)storageOrgNumber));
        }
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private EntityViewInfo buildArchivesORLocationView(ICoreBase biz, String number, String planStorageOrgNumber) throws BOSException {
        if (biz == null) {
            return null;
        }
        if (number == null || number.trim().length() == 0) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        if (new EquipmentArchivesInfo().getBOSType().equals((Object)biz.getType())) {
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("number"));
            viewInfo.getSelector().add(new SelectorItemInfo("name"));
            viewInfo.getSelector().add(new SelectorItemInfo("location.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("location.number"));
            viewInfo.getSelector().add(new SelectorItemInfo("location.name"));
            filter.getFilterItems().add(new FilterItemInfo("initial", (Object)Boolean.TRUE, CompareType.EQUALS));
            if (planStorageOrgNumber != null) {
                filter.getFilterItems().add(new FilterItemInfo("planOrgUnit.number", (Object)planStorageOrgNumber));
            }
        } else if (new EquipmentLocationInfo().getBOSType().equals((Object)biz.getType())) {
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("number"));
            viewInfo.getSelector().add(new SelectorItemInfo("name"));
            if (planStorageOrgNumber != null) {
                filter.getFilterItems().add(new FilterItemInfo("planOrgUnit.number", (Object)planStorageOrgNumber));
            }
        }
        viewInfo.setFilter(filter);
        return viewInfo;
    }
}

