/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap_tax;

import com.kingdee.eas.fi.arap_tax.GTaxImporter;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class DataParse {
    private static final Logger logger = Logger.getLogger(GTaxImporter.class);
    private String seperator = null;
    private String qualifySymbol = null;
    private boolean hasQualifySymbol = false;
    private String[] strings;

    public DataParse(String seperator, String qualifySymbol) {
        this.seperator = seperator;
        this.qualifySymbol = qualifySymbol == null ? "\"" : qualifySymbol;
    }

    private void toArray(String sRow) {
        ArrayList<String> dataList = new ArrayList<String>();
        logger.info((Object)sRow);
        int begin = 0;
        int end = sRow.indexOf(this.seperator);
        if (end == -1) {
            this.strings = new String[]{sRow};
            return;
        }
        String s1 = null;
        while (end != -1) {
            s1 = sRow.substring(begin, end);
            dataList.add(s1);
            if (end + this.seperator.length() > sRow.length()) break;
            sRow = sRow.substring(end + this.seperator.length());
            end = sRow.indexOf(this.seperator);
        }
        if (end == -1) {
            dataList.add(sRow);
        } else {
            dataList.add("");
        }
        this.strings = DataParse.list2StringArray(dataList);
        logger.info(dataList);
    }

    public List parse(String sRow) {
        if (StringUtils.isEmpty((String)sRow)) {
            return Collections.EMPTY_LIST;
        }
        this.toArray(sRow);
        for (int i = 0; i < this.strings.length - 1; ++i) {
            if (this.strings[i] == null) continue;
            int shiftIndex = this.strings[i].indexOf(this.qualifySymbol);
            if (shiftIndex != -1) {
                boolean bl = this.hasQualifySymbol = !this.hasQualifySymbol;
            }
            if (!this.hasQualifySymbol) continue;
            if (shiftIndex == 0) {
                this.strings[i] = this.strings[i].substring(this.qualifySymbol.length());
            }
            this.readNext(i, i);
        }
        ArrayList<String> dataList = new ArrayList<String>();
        for (int i = 0; i < this.strings.length; ++i) {
            if (this.strings[i] == null) continue;
            dataList.add(this.strings[i]);
        }
        logger.info(dataList);
        return dataList;
    }

    private void readNext(int startIndex, int currentIndex) {
        if (currentIndex >= this.strings.length - 1) {
            return;
        }
        if (this.strings[startIndex].endsWith(this.qualifySymbol)) {
            this.strings[startIndex] = this.strings[startIndex].substring(0, this.strings[startIndex].indexOf(this.qualifySymbol));
            this.hasQualifySymbol = false;
            return;
        }
        int shiftIndex = this.strings[currentIndex + 1].indexOf(this.qualifySymbol);
        if (shiftIndex == -1) {
            this.strings[startIndex] = this.strings[startIndex] + this.seperator + this.strings[currentIndex + 1];
            this.strings[currentIndex + 1] = null;
            this.readNext(startIndex, currentIndex + 1);
        } else {
            this.strings[startIndex] = this.strings[startIndex] + this.seperator + this.strings[currentIndex + 1].substring(0, shiftIndex);
            this.strings[currentIndex + 1] = this.strings[currentIndex + 1].substring(shiftIndex + this.qualifySymbol.length());
            if (this.strings[currentIndex + 1].length() == 0) {
                this.strings[currentIndex + 1] = null;
            }
            this.hasQualifySymbol = false;
        }
    }

    private static String[] list2StringArray(List list) {
        String[] s = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            s[i] = (String)list.get(i);
        }
        return s;
    }

    public String format(Object obj) {
        logger.info(obj);
        if (obj == null) {
            return "";
        }
        String s1 = obj.toString();
        if (s1.indexOf(this.seperator) != -1) {
            if (s1.indexOf(this.qualifySymbol) != -1) {
                String replaceStr = "";
                if ("\"".equals(this.qualifySymbol)) {
                    replaceStr = "'";
                } else if ("'".equals(this.qualifySymbol)) {
                    replaceStr = "\"";
                }
                s1 = s1.replaceAll(this.qualifySymbol, replaceStr);
            }
            s1 = this.qualifySymbol + s1 + this.qualifySymbol;
        }
        logger.info((Object)s1);
        return s1;
    }

    public static void main(String[] args) {
        String s = "zz~~ff~~gg~~xxxx~~\"ss~~s~~~~~y\"~~tt~~\"u~ee\"~~uu~~~~";
        DataParse utils = new DataParse("~~", "\"");
        utils.format("~~\u6211\u7684\"\"\"");
    }
}

