/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap_tax.client;

import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.arap_tax.TaxFileTypeEnum;
import com.kingdee.eas.fi.arap_tax.client.AbstractGTaxDataFileUI;
import com.kingdee.eas.fi.arap_tax.client.SimpleFileFilter;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class GTaxDataFileUI
extends AbstractGTaxDataFileUI {
    private static final Logger logger = CoreUIObject.getLogger(GTaxDataFileUI.class);
    private static final String RES = "com.kingdee.eas.fi.arap_tax.client.GTaxEasResource";
    private File selectedFile = null;
    private SimpleFileFilter fileFilter = null;
    private boolean fExport = false;
    private int closeType = -1;
    private TaxFileTypeEnum fileType;

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnFileChooser.setIcon(EASResource.getIcon((String)"imgTbtn_open"));
        this.btnFileChooser.setText(null);
        Map uiCtx = this.getUIContext();
        this.fileType = (TaxFileTypeEnum)((Object)uiCtx.get("fileType"));
        this.fileFilter = new SimpleFileFilter(this.fileType.getName(), this.fileType.getAlias());
        if (uiCtx.get("export") != null) {
            this.fExport = true;
        }
        this.selectedFile = (File)uiCtx.get("selectedFile");
        if (this.selectedFile != null && this.selectedFile.exists()) {
            this.txtFilePath.setText(this.selectedFile.getPath());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        String sFile = this.txtFilePath.getText();
        if (sFile == null || sFile.trim().length() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"FileNull"));
            return;
        }
        if (sFile.indexOf(".") == -1) {
            sFile = sFile + "." + this.fileType.getValue();
        }
        this.selectedFile = new File(sFile);
        if (!this.fileFilter.accept(this.selectedFile)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"FileTypeWrong"));
            return;
        }
        if (!this.fExport && !this.selectedFile.exists()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"FileNotExist"));
            return;
        }
        if (this.fExport) {
            if (!this.selectedFile.exists()) {
                int val = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"CreateFile"));
                if (val != 0) return;
                this.createFile(this.selectedFile);
            } else {
                int val = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"OverwriteFile"));
                if (val == 2) {
                    return;
                }
            }
        }
        this.closeType = 1;
        this.disposeUIWindow();
    }

    private void createFile(File file) throws IOException {
        int ind;
        String fullPath = file.getAbsolutePath();
        File dir = new File(fullPath.substring(0, ind = fullPath.lastIndexOf(File.separator)));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        file.createNewFile();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.closeType = -1;
        this.disposeUIWindow();
    }

    @Override
    protected void btnFileChooser_actionPerformed(ActionEvent e) throws Exception {
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setFileFilter((FileFilter)this.fileFilter);
        if (this.selectedFile != null && this.selectedFile.length() > 0L) {
            fileChooser.setSelectedFile(this.selectedFile);
        }
        if (fileChooser.showOpenDialog((Component)((Object)this)) != 0) {
            return;
        }
        String sFile = fileChooser.getSelectedFile().getPath();
        this.selectedFile = fileChooser.getSelectedFile();
        this.txtFilePath.setText(sFile);
    }

    public File getSelectedFile() {
        if (this.closeType == -1) {
            return null;
        }
        return this.selectedFile;
    }
}

