/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap_tax.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.arap_tax.GTaxImportLog;
import com.kingdee.eas.fi.arap_tax.client.AbstractGTaxDataLogUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class GTaxDataLogUI
extends AbstractGTaxDataLogUI {
    private static final Logger logger = CoreUIObject.getLogger(GTaxDataLogUI.class);
    private static final String RES = "com.kingdee.eas.fi.arap_tax.client.GTaxEasResource";
    private GTaxImportLog actionLog = null;

    public void onLoad() throws Exception {
        super.onLoad();
        Map uiCtx = this.getUIContext();
        if (uiCtx.get("exportLog") != null) {
            this.actionLog = (GTaxImportLog)uiCtx.get("exportLog");
            this.loadActionLog(true);
        } else {
            this.actionLog = (GTaxImportLog)uiCtx.get("importLog");
            this.loadActionLog(false);
        }
    }

    private void loadActionLog(boolean fExport) {
        Date sqlDate = new Date(this.actionLog.startTime.getTime());
        this.lblTimeVal.setText(sqlDate.toString());
        this.lblCostVal.setText(this.actionLog.getCostTime());
        if (fExport) {
            this.lblTypeDesc.setText(EASResource.getString((String)RES, (String)"ExportLogUI"));
        }
        this.txtArea.setText(this.getDetailMsg());
    }

    private String getDetailMsg() {
        Object[] countArr = null;
        String msgPre = null;
        if (this.actionLog.fExport) {
            msgPre = EASResource.getString((String)RES, (String)"ExportDataCount");
            countArr = new String[]{String.valueOf(this.actionLog.billCount), String.valueOf(this.actionLog.newCount), String.valueOf(this.actionLog.failCount)};
        } else {
            msgPre = EASResource.getString((String)RES, (String)"ImportDataCount");
            countArr = new String[]{String.valueOf(this.actionLog.billCount), String.valueOf(this.actionLog.newCount), String.valueOf(this.actionLog.overCount), String.valueOf(this.actionLog.failCount)};
        }
        String msg = MessageFormat.format(msgPre, countArr);
        if (this.actionLog.errList.size() > 0) {
            msg = msg + "\r\n" + EASResource.getString((String)RES, (String)"ErrDetail") + "\r\n" + this.actionLog.getErrDetailMsg();
        }
        return msg;
    }

    @Override
    public void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    private String getSummaryMsg() {
        String msg = this.lblTime.getText() + this.lblTimeVal.getText() + "    " + this.lblCost.getText() + this.lblCostVal.getText() + "    " + this.lblType.getText() + this.lblTypeDesc.getText() + "\r\n" + this.lblDetail.getText() + "\r\n";
        return msg;
    }

    @Override
    public void btnLogFile_actionPerformed(ActionEvent e) throws Exception {
        String sLogDir = System.getProperty("user.home") + File.separator + ".EAS";
        File logFile = new File(sLogDir = FilenameUtils.normalize((String)sLogDir));
        if (!logFile.exists()) {
            logFile.mkdirs();
        }
        String sLogFile = sLogDir + File.separator + (this.actionLog.fExport ? "exportLog" : "importLog") + System.currentTimeMillis() + ".log";
        logFile = new File(sLogFile);
        logFile.createNewFile();
        String sLog = this.getSummaryMsg() + this.getDetailMsg();
        FileOutputStream out = null;
        OutputStreamWriter writer = null;
        BufferedWriter buffWriter = null;
        try {
            out = new FileOutputStream(logFile);
            writer = new OutputStreamWriter(out);
            buffWriter = new BufferedWriter(writer);
            buffWriter.write(sLog);
            buffWriter.flush();
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (writer != null) {
                    writer.close();
                }
                if (buffWriter != null) {
                    buffWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
        MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)RES, (String)"LogSaved") + sLogFile));
    }
}

