/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.rptclient.gr.rptclient.query.BaseQueryPanel;
import com.kingdee.eas.rptclient.gr.rptclient.util.BaseBizDataUtil;
import com.kingdee.eas.rptclient.newrpt.util.CommonUtil;
import com.kingdee.util.enum.EnumUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;

public class ReportFilterUI
extends BaseQueryPanel {
    private KDLabelContainer contPeriodType;
    private KDComboBox comboPeriodType;
    private KDLabelContainer contRptSrcType;
    private KDComboBox comboRptSrcType;
    private KDLabelContainer contTemplate;
    private KDComboBox comboxTemplate;
    private KDLabelContainer contCurrency;
    private KDComboBox comboxCurrency;
    private KDCheckBox chkIncludeRptByHisTmp;
    private TemplateCollection templates = null;

    public ReportFilterUI() throws Exception {
        this.initTemplates();
        this.jbInit();
    }

    private void initTemplates() throws EASBizException, BOSException {
        if (this.templates == null || this.templates.isEmpty()) {
            this.templates = BaseBizDataUtil.getTemplates();
        }
    }

    private void jbInit() throws Exception {
        this.setUITitle(CommonUtil.getResource("title_report_filterui"));
        this.contPeriodType = new KDLabelContainer();
        this.comboPeriodType = new KDComboBox();
        this.contRptSrcType = new KDLabelContainer();
        this.comboRptSrcType = new KDComboBox();
        this.contTemplate = new KDLabelContainer();
        this.comboxTemplate = new KDComboBox();
        this.contCurrency = new KDLabelContainer();
        this.comboxCurrency = new KDComboBox();
        this.chkIncludeRptByHisTmp = new KDCheckBox();
        this.contPeriodType.setName("contPeriodType");
        this.comboPeriodType.setName("comboPeriodType");
        this.contRptSrcType.setName("contRptSrcType");
        this.comboRptSrcType.setName("comboRptSrcType");
        this.contTemplate.setName("contNumber");
        this.comboxTemplate.setName("txtNumber");
        this.contCurrency.setName("contName");
        this.comboxCurrency.setName("txtName");
        this.chkIncludeRptByHisTmp.setName("chkIncludeRptByHisTmp");
        this.contPeriodType.setBoundLabelText(CommonUtil.getResource("RptPeriodType"));
        this.contPeriodType.setBoundLabelLength(100);
        this.contPeriodType.setBoundLabelUnderline(true);
        this.comboPeriodType.addItem((Object)CommonUtil.getResource("common_all"));
        this.comboPeriodType.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.fi.rpt.RptPeriodTypeEnum").toArray());
        this.contRptSrcType.setBoundLabelText(CommonUtil.getResource("ReportType"));
        this.contRptSrcType.setBoundLabelLength(100);
        this.contRptSrcType.setBoundLabelUnderline(true);
        this.comboRptSrcType.addItem((Object)CommonUtil.getResource("common_all"));
        this.comboRptSrcType.addItem((Object)RptSrcTypeEnum.NORMAL);
        this.comboRptSrcType.addItem((Object)RptSrcTypeEnum.DYNAMICNORMALREPORT);
        this.contTemplate.setBoundLabelText(CommonUtil.getResource("template"));
        this.contTemplate.setBoundLabelLength(100);
        this.contTemplate.setBoundLabelUnderline(true);
        this.comboxTemplate.addItem((Object)CommonUtil.getResource("common_all"));
        Iterator iter = this.templates.iterator();
        while (iter.hasNext()) {
            TemplateInfo template = (TemplateInfo)iter.next();
            this.comboxTemplate.addItem((Object)template.getName());
        }
        this.contCurrency.setBoundLabelText(CommonUtil.getResource("currency"));
        this.contCurrency.setBoundLabelLength(100);
        this.contCurrency.setBoundLabelUnderline(true);
        this.comboxCurrency.addItem((Object)CommonUtil.getResource("common_all"));
        this.comboxCurrency.addItems(BaseBizDataUtil.getCurrencies().toArray());
        this.chkIncludeRptByHisTmp.setText(CommonUtil.getResource("IncludeRptByHisTmp"));
    }

    public void initUIContentLayout() {
        this.setBounds(new Rectangle(10, 10, 320, 180));
        this.setLayout(null);
        int x = 10;
        int y = 10;
        int width = this.getWidth() - 20;
        int height = 19;
        this.contPeriodType.setBounds(new Rectangle(x, y, width, height));
        this.add((Component)this.contPeriodType, null);
        y = y + 19 + 5;
        this.contRptSrcType.setBounds(new Rectangle(x, y, width, height));
        this.add((Component)this.contRptSrcType, null);
        y = y + 19 + 5;
        this.contCurrency.setBounds(new Rectangle(x, y, width, height));
        this.add((Component)this.contCurrency, null);
        y = y + 19 + 5;
        this.contTemplate.setBounds(new Rectangle(x, y, width, height));
        this.add((Component)this.contTemplate, null);
        y = y + 19 + 5;
        this.chkIncludeRptByHisTmp.setBounds(new Rectangle(x, y, width, height));
        this.add((Component)this.chkIncludeRptByHisTmp, null);
        this.contPeriodType.setBoundEditor((JComponent)this.comboPeriodType);
        this.contRptSrcType.setBoundEditor((JComponent)this.comboRptSrcType);
        this.contTemplate.setBoundEditor((JComponent)this.comboxTemplate);
        this.contCurrency.setBoundEditor((JComponent)this.comboxCurrency);
        x = 0;
        y = y + 19 + 10;
        height = 10;
        this.kDSeparator.setBounds(new Rectangle(0, y, this.getWidth(), height));
        this.add((Component)this.kDSeparator, null);
        x = this.getWidth() - 161;
        width = 73;
        height = 21;
        this.btnOk.setBounds(new Rectangle(x, y += 10, width, height));
        this.add((Component)this.btnOk, null);
        x = this.getWidth() - 83;
        this.btnCancel.setBounds(new Rectangle(x, y, width, height));
        this.add((Component)this.btnCancel, null);
    }

    protected void pkDateStart_dataChanged(DataChangeEvent e) throws Exception {
    }

    protected void pkDateEnd_dataChanged(DataChangeEvent e) throws Exception {
    }

    public boolean isDoQuery() {
        return this.isDoQuery;
    }

    public Map getConditions() {
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        if (this.comboPeriodType.getSelectedIndex() > 0) {
            conditions.put("periodType", this.comboPeriodType.getSelectedItem());
        }
        if (this.comboRptSrcType.getSelectedIndex() > 0) {
            conditions.put("sourceType", this.comboRptSrcType.getSelectedItem());
        }
        if (this.comboxTemplate.getSelectedIndex() > 0) {
            conditions.put("template", this.templates.get(this.comboxTemplate.getSelectedIndex() - 1));
        }
        if (this.comboxCurrency.getSelectedIndex() > 0) {
            conditions.put("currency", this.comboxCurrency.getSelectedItem());
        }
        conditions.put("isIncludeRptByHisTmp", new Boolean(this.chkIncludeRptByHisTmp.isSelected()));
        return conditions;
    }
}

