/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.InvalidMetaDataException;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.token.CollectionFormulaParser;
import com.kingdee.bos.metadata.query.token.IToken;
import com.kingdee.bos.metadata.query.token.LogicToken;
import com.kingdee.bos.metadata.query.token.OperatorToken;
import com.kingdee.bos.metadata.query.token.TokenKey;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.BaseCommonQueryClientException;
import com.kingdee.eas.base.commonquery.LogicSignEnum;
import com.kingdee.eas.rptclient.gr.rptclient.query.CommonQueryUI;
import com.kingdee.eas.rptclient.gr.rptclient.query.CustomerQueryPanel;
import com.kingdee.eas.rptclient.gr.rptclient.query.IQueryInfoPanel;
import com.kingdee.eas.rptclient.gr.rptclient.query.QuerySolutionVO;
import com.kingdee.eas.rptclient.gr.rptclient.query.QueryToolBar;
import com.kingdee.eas.rptclient.gr.rptclient.query.SolutionListPanel;
import com.kingdee.eas.rptclient.gr.rptclient.query.Util;
import com.kingdee.eas.rptclient.gr.rptclient.util.QuerySolutionDAO;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class CommonQueryPanel
extends KDPanel {
    private int closeWindowType = 2;
    private HashMap panels = new HashMap();
    private QueryToolBar defaultToolBar;
    private KDTabbedPane tabbedPanel;
    private SolutionListPanel solutionListPanel;
    boolean showToolbar;
    private boolean showButton;
    private int width;
    private int height;
    private int tabIndex = 0;
    private EntityViewInfo resultEntityViewInfo;
    private EntityViewInfo lockedEntityViewInfo;
    private String parentUIClassName;
    private static final String commonQueryRes = CommonQueryPanel.class.getName();
    private KDButton btnConfirm;
    private KDButton btnCancel;
    protected KDCheckBox cbDefaultView;
    private EntityViewInfo defalutEntityViewInfo;

    void disVisiableDefaultView() {
        this.cbDefaultView.setVisible(false);
    }

    public CommonQueryPanel(EntityViewInfo entityViewInfo, EntityViewInfo lockedEntityViewInfo, IMetaDataPK queryObjectPK, String parentUIClassName, boolean showToolbar, boolean showButton, int width, int height) throws BaseCommonQueryClientException {
        entityViewInfo = (EntityViewInfo)entityViewInfo.clone();
        if (parentUIClassName == null) {
            throw new BaseCommonQueryClientException(BaseCommonQueryClientException.PARENT_UI_CLASS_NAME_IS_NULL);
        }
        this.parentUIClassName = parentUIClassName;
        this.showToolbar = showToolbar;
        this.showButton = showButton;
        this.width = width;
        this.height = height;
        this.resultEntityViewInfo = entityViewInfo;
        this.lockedEntityViewInfo = lockedEntityViewInfo;
    }

    public void onLoad() throws Exception {
        this.tabbedPanel = new KDTabbedPane();
        this.jbInit();
    }

    public void addPanel(KDPanel panel) throws Exception {
        this.panels.put(panel.getClass().getName(), panel);
        CustomerQueryPanel customerQueryPanel = (CustomerQueryPanel)panel;
        customerQueryPanel.initLayout();
        customerQueryPanel.onLoad();
        customerQueryPanel.setPreferredSize(new Dimension(this.getMainPanelWidth(), this.getMainPanelHeight()));
        this.tabbedPanel.insertTab(((IQueryInfoPanel)panel).getPanelName(), null, (Component)panel, null, this.tabIndex);
        ++this.tabIndex;
    }

    public void addPanels(ArrayList panels) throws Exception {
        for (int i = 0; i < panels.size(); ++i) {
            this.addPanel((KDPanel)panels.get(i));
        }
    }

    private KDButton createConfirmButton() {
        this.btnConfirm = new KDButton();
        this.btnConfirm.setText(EASResource.getString((String)commonQueryRes, (String)"confirm"));
        this.btnConfirm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CommonQueryPanel.this.confirmButton_actionPerformed(e);
            }
        });
        return this.btnConfirm;
    }

    private KDButton createCancelButton() {
        this.btnCancel = new KDButton();
        this.btnCancel.setText(EASResource.getString((String)commonQueryRes, (String)"cancel"));
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CommonQueryPanel.this.cancelButton_actionPerformed(e);
            }
        });
        return this.btnCancel;
    }

    private KDCheckBox createDefaultViewCheck() {
        this.cbDefaultView = new KDCheckBox();
        this.cbDefaultView.setText(EASResource.getString((String)commonQueryRes, (String)"defaultView"));
        return this.cbDefaultView;
    }

    private void jbInit() {
        this.initMainPanel();
        this.initLeftPanel();
        this.initRightPanel();
        this.initBottomPanel();
    }

    private void initMainPanel() {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(this.width, this.height));
    }

    void setShowButton(boolean is) {
        this.showButton = is;
    }

    void initLeftPanel() {
        if (this.showButton) {
            if (this.showToolbar) {
                this.defaultToolBar = new QueryToolBar();
                this.defaultToolBar.setBounds(10, 10, 180, 20);
                this.add((Component)((Object)this.defaultToolBar));
                this.solutionListPanel = new SolutionListPanel();
                this.solutionListPanel.setBounds(10, 30, 180, this.height - 10 - 20 - 45 - 3);
                this.add((Component)((Object)this.solutionListPanel));
            }
        } else if (this.showToolbar) {
            this.defaultToolBar = new QueryToolBar();
            this.defaultToolBar.setBounds(10, 10, 180, 20);
            this.add((Component)((Object)this.defaultToolBar));
            this.solutionListPanel = new SolutionListPanel();
            this.solutionListPanel.setBounds(10, 30, 180, this.height - 10 - 20 - 10 + 2);
            this.add((Component)((Object)this.solutionListPanel));
        }
    }

    private void initRightPanel() {
        this.initTabbedPanel();
        if (this.showButton) {
            if (this.showToolbar) {
                this.tabbedPanel.setBounds(198, 30, this.width - 10 - 180 - 8 - 10, this.height - 10 - 62 - 8);
                this.add((Component)this.tabbedPanel);
            } else {
                this.tabbedPanel.setBounds(10, 10, this.width - 10 - 10, this.height - 10 - 51);
                this.add((Component)this.tabbedPanel);
            }
        } else if (this.showToolbar) {
            this.tabbedPanel.setBounds(198, 10, this.width - 10 - 180 - 8 - 10, this.height - 10 - 10);
            this.add((Component)this.tabbedPanel);
        } else {
            this.tabbedPanel.setBounds(10, 10, this.width - 10 - 10, this.height - 10 - 10);
            this.add((Component)this.tabbedPanel);
        }
    }

    private void initBottomPanel() {
        if (this.showButton) {
            this.createConfirmButton();
            this.add((Component)this.btnConfirm);
            this.btnConfirm.setBounds(this.width - 10 - 73 - 3 - 73, this.height - 10 - 21, 73, 21);
            this.createCancelButton();
            this.add((Component)this.btnCancel);
            this.btnCancel.setBounds(this.width - 10 - 73, this.height - 10 - 21, 73, 21);
            this.createDefaultViewCheck();
            this.add((Component)this.cbDefaultView);
            this.cbDefaultView.setBounds(8, this.height - 10 - 21, 150, 21);
            KDSeparator separator = new KDSeparator();
            separator.setBounds(0, this.height - 10 - 21 - 9, this.width, 2);
            this.add((Component)separator);
        }
    }

    protected int getMainPanelWidth() {
        if (this.showToolbar) {
            return this.width - 10 - 180 - 8 - 10;
        }
        return this.width - 10 - 10;
    }

    protected int getMainPanelHeight() {
        if (this.showButton) {
            return this.height - 10 - 51;
        }
        return this.height;
    }

    private void initTabbedPanel() {
    }

    protected void setUserPanelDisplay(QuerySolutionVO vo) throws Exception {
        Collection panels = this.getPanels().values();
        Iterator itePanel = panels.iterator();
        while (itePanel.hasNext()) {
            KDPanel palTemp = (KDPanel)itePanel.next();
            if (!(palTemp instanceof IQueryInfoPanel)) continue;
            IQueryInfoPanel userPanel = (IQueryInfoPanel)palTemp;
            EntityViewInfo userEntityViewInfo = new EntityViewInfo(vo.getEntityView());
            ((CoreUIObject)userPanel).onLoad();
            userPanel.loadData(userEntityViewInfo);
        }
    }

    protected void confirmButton_actionPerformed(ActionEvent e) {
        QuerySolutionVO vo;
        if (this.verify()) {
            this.closeWindowType = 0;
            Util.getWindow((Component)((Object)this)).dispose();
        }
        if (this.getDefaultToolBar() != null && (vo = this.getDefaultToolBar().getCurrentQuerySolutionVO()) != null) {
            try {
                if (this.cbDefaultView != null && vo.getIsUserDefaultSolu() != this.cbDefaultView.isSelected()) {
                    vo.setIsUserDefaultSolu(this.cbDefaultView.isSelected());
                    QuerySolutionDAO.store(vo);
                }
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
        }
    }

    protected boolean saveDefaultView() {
        try {
            String parentUIName = this.getParentUIClassName();
            QuerySolutionVO oldVO = QuerySolutionDAO.getUserDefaultSolutionByType(parentUIName);
            if (this.cbDefaultView.isSelected()) {
                QuerySolutionVO vo = null;
                if (this.getDefaultToolBar().getCurrentQuerySolutionVO() != null) {
                    vo = this.getDefaultToolBar().getCurrentQuerySolutionVO();
                    vo.setIsUserDefaultSolu(true);
                    QuerySolutionDAO.store(vo);
                }
                if (oldVO != null && vo != null && !oldVO.getId().equals(vo.getId())) {
                    oldVO.setIsUserDefaultSolu(false);
                    QuerySolutionDAO.store(oldVO);
                }
            } else {
                if (this.getDefaultToolBar().getCurrentQuerySolutionVO() != null) {
                    QuerySolutionVO vo = this.getDefaultToolBar().getCurrentQuerySolutionVO();
                    vo.setIsUserDefaultSolu(false);
                    QuerySolutionDAO.store(vo);
                }
                if (oldVO != null) {
                    oldVO.setIsUserDefaultSolu(false);
                    QuerySolutionDAO.store(oldVO);
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void cancelButton_actionPerformed(ActionEvent e) {
        this.closeWindowType = 1;
        Util.getWindow((Component)((Object)this)).dispose();
    }

    private void clearEntityViewInfo() {
        if (this.resultEntityViewInfo.getFilter() != null) {
            this.resultEntityViewInfo.getFilter().setMaskString("");
            this.resultEntityViewInfo.getFilter().getFilterItems().clear();
        }
        this.resultEntityViewInfo.getSorter().clear();
    }

    private void mergeCommonFilterInfo() {
        this.resultEntityViewInfo.setFilter(new FilterInfo());
    }

    private void mergeCommonFilterInnerInfo() {
        this.resultEntityViewInfo.setFilter(new FilterInfo());
    }

    private void mergeCommonSorters() {
        this.resultEntityViewInfo.getSorter().addObjectCollection((IObjectCollection)new SorterItemCollection());
    }

    private void mergeCustomerEntityViewInfo() {
        try {
            Collection collection = this.panels.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                FilterInfo filterInfo;
                Object object = iterator.next();
                if (!(object instanceof IQueryInfoPanel) || (filterInfo = ((IQueryInfoPanel)object).getFilterInfo()) == null || filterInfo.getFilterItems().size() <= 0) continue;
                String tempFormulaString = this.resultEntityViewInfo.getFilter().getMaskString();
                if (tempFormulaString == null || tempFormulaString.trim().equalsIgnoreCase("")) {
                    this.resultEntityViewInfo.setFilter(filterInfo);
                    continue;
                }
                this.mergeFilter(this.resultEntityViewInfo.getFilter(), filterInfo, LogicSignEnum.AND.getName());
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void setCurrentEntityViewInfo() {
        this.clearEntityViewInfo();
        this.mergeCommonFilterInfo();
        this.mergeCommonSorters();
        this.mergeCustomerEntityViewInfo();
    }

    private void setCurrentEntityViewInnerInfo() {
        this.clearEntityViewInfo();
        this.mergeCommonFilterInnerInfo();
        this.mergeCommonSorters();
        this.mergeCustomerEntityViewInfo();
    }

    private void mergeFilter(FilterInfo oldFilterInfo, FilterInfo newFilterInfo, String logic) throws BOSException {
        if (!TokenKey.isLogicWord((String)logic)) {
            throw new InvalidMetaDataException("The logic operator is not avaliable.");
        }
        StringBuffer newMaskString = new StringBuffer();
        if (newFilterInfo.getMaskString() == null) {
            for (int i = 0; i < newFilterInfo.getFilterItems().size(); ++i) {
                if (i > 0) {
                    newMaskString.append(" AND ");
                }
                newMaskString.append("#").append(i);
            }
        } else {
            newMaskString.append(newFilterInfo.getMaskString());
        }
        if (newMaskString.length() == 0) {
            return;
        }
        oldFilterInfo.setMaskString('(' + oldFilterInfo.getMaskString() + ')');
        CollectionFormulaParser parserOld = new CollectionFormulaParser(oldFilterInfo.getMaskString(), (AbstractObjectCollection)oldFilterInfo.getFilterItems());
        CollectionFormulaParser parserNew = new CollectionFormulaParser(newMaskString.toString(), (AbstractObjectCollection)newFilterInfo.getFilterItems());
        parserOld.tokenList.add((IToken)new LogicToken(logic));
        parserOld.tokenList.add((IToken)new OperatorToken('('));
        parserOld.tokenList.addAll((Collection)parserNew.tokenList);
        parserOld.tokenList.add((IToken)new OperatorToken(')'));
        oldFilterInfo.getFilterItems().addObjectCollection((IObjectCollection)newFilterInfo.getFilterItems());
        oldFilterInfo.setMaskString(parserOld.tokenList.showOrginValue());
    }

    public EntityViewInfo getEntityViewInfo() {
        this.setCurrentEntityViewInfo();
        return this.resultEntityViewInfo;
    }

    public EntityViewInfo getEntityViewInnerInfo() {
        this.setCurrentEntityViewInnerInfo();
        return this.resultEntityViewInfo;
    }

    protected KDPanel getPanel(String panelName) {
        return (KDPanel)this.panels.get(panelName);
    }

    protected boolean isShowToolBar(boolean showToolBar) {
        return this.showToolbar;
    }

    protected QueryToolBar getDefaultToolBar() {
        return this.defaultToolBar;
    }

    protected HashMap getPanels() {
        return this.panels;
    }

    protected KDTabbedPane getTabbedPanel() {
        return this.tabbedPanel;
    }

    protected int getCloseWindowType() {
        return this.closeWindowType;
    }

    protected SolutionListPanel getSolutionListPanel() {
        return this.solutionListPanel;
    }

    public boolean verify() {
        boolean flag = false;
        ArrayList customerQueryPanels = this.getCustomerQueryPanel();
        int size = this.getCustomerQueryPanel().size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                flag = ((CustomerQueryPanel)customerQueryPanels.get(i)).verify();
                if (flag) continue;
                return false;
            }
        }
        return true;
    }

    public ArrayList getCustomerQueryPanel() {
        ArrayList customerQueryPanels = new ArrayList();
        Collection collection = this.panels.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof IQueryInfoPanel)) continue;
            customerQueryPanels.add(object);
        }
        return customerQueryPanels;
    }

    protected String getParentUIClassName() {
        return this.parentUIClassName;
    }

    protected Component getParentUI() {
        CommonQueryUI commonQueryUI = (CommonQueryUI)((Object)Util.getComponent((Component)((Object)this), CommonQueryUI.class.getName()));
        return (Component)commonQueryUI.getUIContext().get("Owner");
    }

    public EntityViewInfo getLockedEntityViewInfo() {
        return this.lockedEntityViewInfo;
    }

    public KDButton getConfirmButton() {
        return this.btnConfirm;
    }

    public boolean isShowButton() {
        return this.showButton;
    }

    public void setCloseWindowType(int closeWindowType) {
        this.closeWindowType = closeWindowType;
    }

    public void setDefalutEntityViewInfo(EntityViewInfo info) {
        this.defalutEntityViewInfo = info;
    }

    public EntityViewInfo getDefaultEntityViewInfo() {
        return this.defalutEntityViewInfo;
    }
}

